cf ----------------------------------------------------------------------------
cf
cf    pcsr0(1) ... mean
cf    pcsr0(2) ... standard deviation
cf
cf ----------------------------------------------------------------------------

      real function harmonic2(deriv,fact,iftyp,indatm0,nacns,pcsr0,
     &  npcns,x,y,z, atmacc,natmp,natngh,dvx,dvy,dvz)
        implicit none
#include "dharmonic.int"
#include "harmonic.int"
#include "feature.int"
#include "amod.cst"
#include "amod.cmn"
        integer  iftyp,nacns,natmp,npcns
        real  fact,feat(1),tmps
        logical  deriv
        integer  indatm0(:),natngh(:)
        real  atmacc(:),dvx(:),dvy(:),dvz(:)
        real  pcsr0(:),x(:),y(:),z(:)

        call feature(x,y,z,atmacc,natmp,indatm0,nacns,iftyp,feat,1,
     &    natngh)

        harmonic2 = harmonic(fact,feat(1),iftyp,pcsr0,npcns,tmps)

        if (deriv) call dharmonic(fact,feat(1),iftyp,indatm0,nacns,
     &    pcsr0, npcns,tmps,x,y,z,natmp,dvx,dvy,dvz)

        return
#include "undef.meta"
      end



      real function harmonic(fact,feat,iftyp,pcsr0,npcns,tmps)
        implicit none
#include "deltafn.int"
#include "numbers.cst"
        integer  iftyp,npcns
        real  fact,feat,tmps
        real  pcsr0(:)

c ----- calculate the normalized difference between feature and ideal value:
        call deltafn(feat,pcsr0(1),pcsr0(2),iftyp,tmps)

        harmonic = fact*rt*(0.5*tmps*tmps)

        return
#include "undef.meta"
      end



      subroutine dharmonic(fact,feat,iftyp,indatm0,nacns,pcsr0,npcns,
     &  tmps,x,y,z, natmp,dvx,dvy,dvz)
        implicit none
#include "featder.int"
#include "amod.cst"
#include "amod.cmn"
        integer  i,iftyp,k,nacns,natmp,npcns
        real  fact,fderf,feat,tmps
        real  feat9(1)
        integer  indatm0(:)
        real  dervx(mapcsr),dervy(mapcsr),dervz(mapcsr),dvx(:)
        real  dvy(:),dvz(:),pcsr0(:),x(:)
        real  y(:)
        real  z(:)

c ----- according to the chain derivation rule, the partial derivative
c       with respect to x of the function F of f, where f is a function of
c       x, is: partial derivative of F with respect to f multiplied by
c       the partial derivative of f with respect to x
c       (in this case, for F = -log(Gaussian on f), this derivative is
c       [(normalized feature) / sigma], i.e. tmps/stand dev)
        feat9(1)=feat
        call featder(x,y,z,natmp,indatm0,nacns,feat9,1, dervx,dervy,
     &    dervz,iftyp)

c ----- multiply them with the partial derivative of F with respect to f
        fderf = fact * rt * tmps / pcsr0(2)

c ------add the derivative contributions to the accumulating derivative arrays:
        do  i = 1, nacns
          k      = indatm0(i)
          dvx(k) = dvx(k) + fderf*dervx(i)
          dvy(k) = dvy(k) + fderf*dervy(i)
          dvz(k) = dvz(k) + fderf*dervz(i)
        end do

        return
#include "undef.meta"
      end




      real function leftharmonic2(deriv,fact,iftyp,indatm0,nacns,pcsr0,
     &  npcns,x,y,z, atmacc,natmp,natngh,dvx,dvy,dvz)
        implicit none
#include "dharmonic.int"
#include "harmonic.int"
#include "feature.int"
#include "amod.cst"
#include "amod.cmn"
        integer  iftyp,nacns,natmp,npcns
        real  differ,fact,feat(1),tmps
        logical  deriv
        integer  indatm0(:),natngh(:)
        real  atmacc(:),dvx(:),dvy(:),dvz(:)
        real  pcsr0(:),x(:),y(:),z(:)

        call feature(x,y,z,atmacc,natmp,indatm0,nacns,iftyp,feat,1,
     &    natngh)

c ----- calculate the difference between feature and ideal value:
        differ = feat(1) - pcsr0(1)

        if (differ .lt. 0.0) then
          leftharmonic2 = harmonic(fact,feat(1),iftyp,pcsr0,npcns,tmps)
          if (deriv) call dharmonic(fact,feat(1),iftyp,indatm0,nacns,
     &      pcsr0,npcns,tmps,x, y,z,natmp,dvx,dvy,dvz)
        else
          leftharmonic2 = 0.0
        end if

        return
#include "undef.meta"
      end




      real function leftharmonic(fact,feat,pcsr0,npcns)
        implicit none
#include "numbers.cst"
        integer npcns
        real differ,fact,feat,tmps
        real pcsr0(:)

c ----- calculate the difference between feature and ideal value:
        differ = feat - pcsr0(1)

        if (differ .lt. 0.0) then
c ------- calculate the normalized violation
          tmps = differ/pcsr0(2)
          leftharmonic = fact*rt*(0.5*tmps*tmps)
        else
          leftharmonic = 0.0
        end if

        return
#include "undef.meta"
      end




      real function rightharmonic2(deriv,fact,iftyp,indatm0,nacns,pcsr0,
     &  npcns,x,y,z, atmacc,natmp,natngh,dvx,dvy,dvz)
        implicit none
#include "dharmonic.int"
#include "harmonic.int"
#include "feature.int"
#include "amod.cst"
#include "amod.cmn"
        integer  iftyp,nacns,natmp,npcns
        real  differ,fact,feat(1),tmps
        logical  deriv
        integer  indatm0(:),natngh(:)
        real  atmacc(:),dvx(:),dvy(:),dvz(:)
        real  pcsr0(:),x(:),y(:),z(:)

        call feature(x,y,z,atmacc,natmp,indatm0,nacns,iftyp,feat,1,
     &    natngh)

c ----- calculate the difference between feature and ideal value:
        differ = feat(1) - pcsr0(1)

        if (differ .gt. 0.0) then
          rightharmonic2 = harmonic(fact,feat(1),iftyp,pcsr0,npcns,tmps)
c ------- update the first -derivatives?
          if (deriv) call dharmonic(fact,feat(1),iftyp,indatm0,nacns,
     &      pcsr0,npcns,tmps,x,y,z,natmp,dvx,dvy,dvz)
        else
          rightharmonic2 = 0.0
        end if

        return
#include "undef.meta"
      end



      real function rightharmonic(fact,feat,pcsr0,npcns)
        implicit none
#include "numbers.cst"
        integer npcns
        real differ,fact,feat,tmps
        real pcsr0(:)

c ----- calculate the difference between feature and ideal value:
        differ = feat - pcsr0(1)

        if (differ .gt. 0.0) then
c ------- calculate the normalized violation
          tmps = differ/pcsr0(2)
          rightharmonic = fact*rt*(0.5*tmps*tmps)
        else
          rightharmonic = 0.0
        end if

        return
#include "undef.meta"
      end




      real function vmin1(iftyp,indatm0,nacns,pcsr0,npcns,x,y,z,atmacc,
     &  natmp,natngh)
        implicit none
#include "feature.int"
#include "amod.cst"
#include "amod.cmn"
        integer  iftyp,nacns,natmp,npcns
        real  feat(1)
        integer  indatm0(:),natngh(:)
        real  atmacc(:),pcsr0(:),x(:),y(:)
        real  z(:)

        call feature(x,y,z,atmacc,natmp,indatm0,nacns,iftyp,feat,1,
     &    natngh)

        vmin1 = min(0.0, feat(1) - pcsr0(1))

        return
#include "undef.meta"
      end




      real function rsrmin1(pcsr0,npcns)
        implicit none
        integer npcns
        real pcsr0(:)

        rsrmin1 = pcsr0(1)

        return
#include "undef.meta"
      end




      real function rvmin1(iftyp,indatm0,nacns,pcsr0,npcns,x,y,z,atmacc,
     &  natmp, natngh)
        implicit none
#include "vmin1.int"
#include "amod.cst"
#include "amod.cmn"
        integer  iftyp,nacns,natmp,npcns
        integer  indatm0(:),natngh(:)
        real  atmacc(:),pcsr0(:),x(:),y(:)
        real  z(:)

        rvmin1 =
     &    vmin1(iftyp,indatm0,nacns,pcsr0,npcns,x,y,z,atmacc,natmp,
     &    natngh)/pcsr0(2)

        return
#include "undef.meta"
      end




      real function vmin2(iftyp,indatm0,nacns,pcsr0,npcns,x,y,z,atmacc,
     &  natmp,natngh)
        implicit none
#include "feature.int"
#include "amod.cst"
#include "amod.cmn"
        integer  iftyp,nacns,natmp,npcns
        real  feat(1)
        integer  indatm0(:),natngh(:)
        real  atmacc(:),pcsr0(:),x(:),y(:)
        real  z(:)

        call feature(x,y,z,atmacc,natmp,indatm0,nacns,iftyp,feat,1,
     &    natngh)

        vmin2 = max(0.0, feat(1) - pcsr0(1))

        return
#include "undef.meta"
      end




      real function rvmin2(iftyp,indatm0,nacns,pcsr0,npcns,x,y,z,atmacc,
     &  natmp, natngh)
        implicit none
#include "vmin2.int"
#include "amod.cst"
#include "amod.cmn"
        integer  iftyp,nacns,natmp,npcns
        integer  indatm0(:),natngh(:)
        real  atmacc(:),pcsr0(:),x(:),y(:)
        real  z(:)

        rvmin2 =
     &    vmin2(iftyp,indatm0,nacns,pcsr0,npcns,x,y,z,atmacc,natmp,
     &    natngh)/pcsr0(2)

        return
#include "undef.meta"
      end




      real function vmin3(iftyp,indatm0,nacns,pcsr0,npcns,x,y,z,atmacc,
     &  natmp,natngh)
        implicit none
#include "deltaf.int"
#include "feature.int"
#include "amod.cst"
#include "amod.cmn"
        integer  iftyp,nacns,natmp,npcns
        real  feat(1)
        integer  indatm0(:),natngh(:)
        real  atmacc(:),pcsr0(:),x(:),y(:)
        real  z(:)

        call feature(x,y,z,atmacc,natmp,indatm0,nacns,iftyp,feat,1,
     &    natngh)

        call deltaf(feat(1),pcsr0(1),iftyp,vmin3)

        return
#include "undef.meta"
      end



      real function rvmin3(iftyp,indatm0,nacns,pcsr0,npcns,x,y,z,atmacc,
     &  natmp, natngh)
        implicit none
#include "vmin3.int"
#include "amod.cst"
#include "amod.cmn"
        integer  iftyp,nacns,natmp,npcns
        integer  indatm0(:),natngh(:)
        real  atmacc(:),pcsr0(:),x(:),y(:)
        real  z(:)

        rvmin3 =
     &    vmin3(iftyp,indatm0,nacns,pcsr0,npcns,x,y,z,atmacc,natmp,
     &    natngh)/pcsr0(2)

        return
#include "undef.meta"
      end




      subroutine sclrsr1(pcsr0,npcns,fact)
        implicit none
        integer npcns
        real fact
        real pcsr0(:)

        pcsr0(1) = fact*pcsr0(1)

        return
#include "undef.meta"
      end

