import Tkinter, string, os, chimeraInit, chimera

class BiocoreError(Exception):
    pass

class Biocore:
    def __init__(self, url=None, session=None, project=None):
        self.URL     = url
        self.Session = session
        self.Project = project

        self.tk = chimera.tkgui.app.master
        self.mytk = self.tk.tk
        self.tkeval = self.mytk.eval

        import biocore
        biocore_pkg = os.path.split(biocore.__file__)[0]
        biocore_pkg = string.join(biocore_pkg.split(os.sep),'/')

        res = self.tkeval("set auto_path [lappend $auto_path 0 \"%s\"]" % biocore_pkg)

        biocore_file =  os.path.join(biocore_pkg, "biocore.tcl")
        biocore_file = string.join(biocore_file.split(os.sep),'/')

        self.tkeval("set biocoreHush 1")
        self.tkeval("source \"%s\"" % str(biocore_file) )

        ## Create a Biocore object on the Tcl layer.    
        self.tkeval('Biocore b')

        ## set the URL
        self.tkeval("b configure URL \"%s\"" % url)

        ## set session
        self.tkeval("b configure Session %s" % session)

        ## set Project
        self.tkeval("b configure Project %s" % project)

    def getBiofsDirectoryEntry(self, id, allow):
        dir = BioFSDirectory()
        self.tkeval("BiofsDirectory biofsDir")
        self.tkeval("eval biofsDir configure [b getBiofsDirectory %s %s]" % (id, allow) )
        dir.Id       = id
        dir.Parent   = self.tkeval("biofsDir cget Parent")
        dir.Name     = self.tkeval("biofsDir cget Name") 
        dir.Time     = self.tkeval("biofsDir cget Time")
        dir.Entries  = self.tkeval("biofsDir cget Entries")

        ## want to return a reference to the actual biofsdirectory
        return dir

    def listBiofsDirContents(self, dirID):
        ## return a list of BiofsDirs

        dirs = []
        files = []
        
        self.tkeval("BiofsDirectory biofsDir")

        try:
            self.tkeval("eval biofsDir configure [b getBiofsDirectory %s 0]" % dirID)
        except Tkinter.TclError, what:
            raise BiocoreError, "there was an error accessing directory in BioFS: %s" % what

        else:
            numDirs = string.atoi(self.tkeval("llength [set dirList [biofsDir cget Entries]]"))
            count = 0
            self.tkeval("set count 0")
            while (count < numDirs):
                self.tkeval("BiofsDirectoryEntry bioDE")
                self.tkeval("eval bioDE configure [lindex $dirList $count]")
                
                if self.tkeval("bioDE cget Type") == "0":
                    biodir = BioFSDirectory(Id      = self.tkeval("bioDE cget Id"),
                                            Parent  = self.tkeval("bioDE cget Parent"),
                                            Name = self.tkeval("bioDE cget Name"), 
                                            Time = self.tkeval("bioDE cget Time")
                                            )
                    dirs.append(biodir)

                elif self.tkeval("bioDE cget Type") == "1":
                    biofile = BioFSDirectoryEntry(Id     = self.tkeval("bioDE cget Id"),
                                                  Name   = self.tkeval("bioDE cget Name"),
                                                  Length = self.tkeval("bioDE cget Length"),
                                                  User   = self.tkeval("bioDE cget User"),
                                                  Time   = self.tkeval("bioDE cget Time")
                                                  )
                    files.append(biofile)
                    
                count = count+1
                self.tkeval("incr count")

            return (dirs,files)

    def getBiofsFile(self, biofsID, strFileLocation):
        # want to return a reference to the actual file
        try:
            self.tkeval("b getBiofsFile \"%s\" \"%s\"" % (biofsID, strFileLocation) )
        except Tkinter.TclError, what:
            raise BiocoreError, "Error downloading file: %s" % what
        

    def putBiofsFile(self, biofsId, localFileLoc, remoteFileLoc):
        try:
            self.tkeval("b putBiofsFile \"%s\" \"%s\" \"%s\"" % (biofsId, localFileLoc, remoteFileLoc) )
        except Tkinter.TclError, what:
            raise BiocoreError, "Error uploading file: %s" % what

    def createBiofsDirectory(self, parent_id, folder_name):
        try:
            self.tkeval("b createBiofsDirectory \"%s\" \"%s\"" % \
                        (parent_id, folder_name) )
        except Tkinter.TclError, what:
            raise BiocoreError, "Error creating directory %s: %s" % (folder_name, what)
                
    def login(self, username, passwd):
        self.tkeval("UserInfo ui")

        try:
            res = self.tkeval("eval ui configure [b login %s %s]" % (username, passwd) )
        except Tkinter.TclError, what:
            raise BiocoreError, "Error logging in to BioCoRE: %s" % what

    def logout(self):
        try:
            self.tkeval("b logout")
        except Tkinter.TclError, what:
            raise BiocoreError, "Error logging out of BioCoRE: %s" % what
        

class BioFSDirectory:
    def __init__(self, Id=None, Parent=None, Name=None, Time=None, Entries=None):
        self.Id      = Id
        self.Parent  = Parent
        self.Name    = Name
        self.Time    = Time
        self.Entries = Entries
        

class BioFSDirectoryEntry:
    def __init__(self, Id=None, Name=None, Length=None, User=None, Time=None, Type=None):
        self.Id      = Id
        self.Name    = Name
        self.Length  = Length
        self.User    = User
        self.Time    = Time
        self.Type    = Type

class UserInfo:
    def __init__(self):
        self.Id = ''



#if __name__ ==  '__main__':
#    b = Biocore("https://biocore-s.ks.uiuc.edu/biocore/servlet/",
#                "DA267121866EBAB206793D672F5928A5", "153")
#
#    b.login("dan", "fubar")
#
#    b.listBiofsDirContents(0)
