from chimera import dialogs
from OpenSave import OpenModeless, SaveModeless
import biocore
from bc import BiocoreError
#from biocore import ROOTPATH, processOpenSelection, processSaveSelection
import sys, os
import Tkinter

CSSDir = "Chimera Saved States"

class SaveBCSessionDialog(SaveModeless):
    name = "Save Session to BioCoRE"
    title = "Choose Save Location"
    provideStatus = True

    def __init__(self):
        SaveModeless.__init__(self, command=biocore.processSaveSelection,
                              filters=[("Chimera session", ["*.py"], ".py")],
                              initialdir=os.path.join(biocore.ROOTPATH,CSSDir),
                              clientPos = 's'
                              )
        self.millerBrowser.newFolderCB = self.newFolderCB

    def fillInUI(self,parent):
        SaveModeless.fillInUI(self,parent)
        
        self.refreshButton = Tkinter.Button(self.clientArea, text="Refresh",
                                            command = self.refreshDirView)
        self.refreshButton.pack(side='top', expand='false')

    def refreshDirView(self, startfrom=None):
        ## if startfrom == None, do the currently selected directory.
        if not startfrom:
            dir_to_refresh = self.millerBrowser.mainColumn.getPaths()[0]
        else:
            dir_to_refresh = startfrom
        
        ## just the dir name, not the whole path
        dirname  =  os.path.split(dir_to_refresh)[1]

        if os.path.isfile(dir_to_refresh):
            self.status("Can't refresh a file (\"%s\"). Must be a directory" % dirname)
            return
        
        self.status( "Refreshing directory \"%s\"......" %  dirname)
        if biocore.refreshDirHier(dir_to_refresh):
            self.millerBrowser.setPath(dir_to_refresh) 
            self.status("Refreshing directory \"%s\"......complete" % dirname, blankAfter=2)   
        else:
            self.status("Error refreshing directory structure", blankAfter=3)

    def newFolderCB(self, button):
        self.millerBrowser.folderPromptDialog.deactivate()
        if button == None or button == 'Cancel':
            return
        folder = self.millerBrowser.folderPromptDialog.get()
        if not folder:
            raise ValueError, "Empty new folder name"
        self.millerBrowser.mainColumn.newFolder(folder)

        new_folder_path = self.millerBrowser.mainColumn.getPaths()[0]
        
        self.millerBrowser._setDirEntry(new_folder_path)

        try:
            ##why pass it redundant information. Need to change...
            biocore.createNewFolder(new_folder_path, folder)    
        except BiocoreError, what:
            self.status("Error creating directory %s: %s" % (folder,what), blankAfter=3 )
            return

        folder_parent = os.path.split(new_folder_path)[0]
        
        ## do we need to do the whole damn thing?
        self.refreshDirView(startfrom = folder_parent)
        
dialogs.register(SaveBCSessionDialog.name, SaveBCSessionDialog)



class OpenBCSessionDialog(OpenModeless):
    name          = "Open Session from BioCoRE"
    title         = "Choose Session File To Open"
    provideStatus = True

    def __init__(self):
        OpenModeless.__init__(self, command=biocore.processOpenSelection,
                              filters=[("Chimera session", ["*.py"])],
                              initialdir=os.path.join(biocore.ROOTPATH,CSSDir),
                              clientPos='s'
                              )
    def fillInUI(self,parent):
        OpenModeless.fillInUI(self,parent)

        self.refreshButton = Tkinter.Button(self.clientArea, text="Refresh",
                                            command = self.refreshDirView)
        self.refreshButton.pack(side='top', expand='false')


    def refreshDirView(self, startfrom=None):
        if not startfrom:
            dir_to_refresh = self.millerBrowser.mainColumn.getPaths()[0]
        else:
            dir_to_refresh = startfrom

        dirname  =  os.path.split(dir_to_refresh)[1]

        if os.path.isfile(dir_to_refresh):
            self.status("Can't refresh a file (\"%s\"). Must be a directory" % dirname)
            return
        
        
        self.status("Refreshing directory \"%s\"......" % dirname)
        if biocore.refreshDirHier(dir_to_refresh):
            self.millerBrowser.setPath(dir_to_refresh)
            self.status("Refreshing directory \"%s\"......complete" % dirname, blankAfter=2)
        else:
            self.status("Error refreshing directory structure", blankAfter=3)
        
dialogs.register(OpenBCSessionDialog.name, OpenBCSessionDialog)
