#!/usr/bin/perl

use strict;
use FileHandle;

my $tcHistoryFile = $ARGV[0];
my $tcToSmpFile = $ARGV[1];
my $outputFile = $ARGV[2];

unless ($tcHistoryFile && $tcToSmpFile && $outputFile){
    print STDERR "usage: perl makeTigrToSmpMap.pl <tcHistoryFile> <tcToSmpFile> <outputFile>\n";
    exit(1);
}

my $tcHistoryMap;

my $historyFh = FileHandle->new("<" . $tcHistoryFile) || die "could not open $tcHistoryFile\n";

my $outFh = FileHandle->new(">" . $outputFile) || die "could not open $outputFile\n";

while (<$historyFh>){
    chomp;
    my $line = $_;
    next if ($line =~ /^THC/);  #yeah!
    my ($oldTc, $newTc, $type) = split('\s+', $line);
    $newTc =~ /TC(\d+)/;
    my $number = $1;
    if ($number > 36845){
	$tcHistoryMap->{$oldTc}->{$newTc} = $type;
    }
}
 
my $tcToSmpFh = FileHandle->new("<" . $tcToSmpFile) || die "could not open $tcToSmpFile\n";

my $tcToSmpMap;
while (<$tcToSmpFh>){
    chomp;
    my $line = $_;
    next if ($line =~ /Query/);
    my @cols = split('\s+', $line);
    my $tcName = $cols[0];
    $tcToSmpMap->{$tcName} = $line;
    &printMappingLine($tcName, "current", "current", $line);
}


foreach my $oldTcId (sort keys %$tcHistoryMap){
    my $newTcIds = $tcHistoryMap->{$oldTcId};
    foreach my $newTcId (keys %$newTcIds){
	my $type = $newTcIds->{$newTcId};
	my $smpInfoLine = $tcToSmpMap->{$newTcId};
	
	&printMappingLine($oldTcId, $newTcId, $type, $smpInfoLine);
    }
}


sub printMappingLine{
    my ($oldTcId, $newTcId, $splitMergeType, $mappingInfoLine) = @_;

    my @cols = split('\s+', $mappingInfoLine);
    my $smpName = $cols[3];
    my $significance = $cols[5];
    my $length = $cols[6];

    print $outFh "$oldTcId\t$smpName\t$newTcId\t$splitMergeType\t$significance\t$length\n";
}
