#!/usr/bin/perl

use strict;
use FileHandle;

my $tcHistoryFile = $ARGV[0];
my $tcToSmpFile = $ARGV[1];
my $outputFile = $ARGV[2];

unless ($tcHistoryFile && $tcToSmpFile && $outputFile){
    print STDERR "usage: perl makeTigrToSmpMap.pl <tcHistoryFile> <tcToSmpFile> <outputFile>\n";
    exit(1);
}

my $tcHistoryMap;

my $historyFh = FileHandle->new("<" . $tcHistoryFile) || die "could not open $tcHistoryFile\n";

my $outFh = FileHandle->new(">" . $outputFile) || die "could not open $outputFile\n";

while (<$historyFh>){
    chomp;
    my $line = $_;
    my ($oldTc, $newTc, $type) = split('\s+', $line);

    $tcHistoryMap->{$oldTc}->{$newTc} = $type;
    if ($type eq "split"){
	$newTc =~ /TC(\d+)/;
	my $number = $1;
	if ($number < 36845){
	    print STDERR "old tc $oldTc was split to less than 36845 ($number)\n";
	}
    }
}
    


my $finalMap;

foreach my $oldTc (keys %$tcHistoryMap){
    print STDERR "initial processing of $oldTc f\n";
    my $newTcs = $tcHistoryMap->{$oldTc};
    my $finalTcs;
    foreach my $newTc (keys %$newTcs){
	print STDERR "\tprocessing map to $newTc\n";
	my $type = $newTcs->{$newTc};
	if ($type eq "merge"){
	    $finalMap->{$oldTc}->{$newTc} = $type;
	}
	if ($type eq "split"){
	    print STDERR "\tcalling get final split tcs for $newTc\n";
	    $finalTcs = &getFinalSplitTcs($newTc, $tcHistoryMap, $finalTcs);
	    foreach my $finalTc (keys %$finalTcs){
		$finalMap->{$oldTc}->{$finalTc} = $type; #if one split, the whole thing is labeled as split
		print STDERR "adding to final map old $oldTc final $finalTc type $type\n";
	    }
	}
    }
}

print STDERR "checking tc consistency\n";
foreach my $oldTc (sort keys %$tcHistoryMap){
    my $newTcs = $tcHistoryMap->{$oldTc};
    my $finalTcs;
    print STDERR "next old tc: $oldTc\n";
    foreach my $newTc (keys %$newTcs){
	my $type = $newTcs->{$newTc};
	if ($type eq "split"){
	    
	    my $finalTcs = $finalMap->{$oldTc};
	    $newTc =~ /TC(\d+)/;
	    my $number = $1;
	    print STDERR "found $oldTc -> $newTc, number $number\n";
	    if ($number < 36845){
		my $finalTcsForNew = $finalMap->{$newTc};
		foreach my $finalTcForNew (keys %$finalTcsForNew){
		    print STDERR "\tfound final tc $finalTcForNew\n";
		    $finalTcForNew  =~ /TC(\d+)/;
		    my $newNumber = $1;

		    if ($newNumber > 36845){
			unless ($finalMap->{$oldTc}->{$finalTcForNew}){
			    print STDERR "old tc $oldTc was mapped to $newTc which was in turn mapped to $finalTcForNew, but $oldTc was not mapped to $finalTcForNew\n";
			}
			else {
			    print STDERR "old tc $oldTc was mapped to $newTc which was in turn mapped to $finalTcForNew.  Also, $oldTc was mapped to $finalTcForNew\n";
			}
		    }
		}
	    }
	}
    }
}


foreach my $oldTc (sort ({$a <=> $b} keys %$finalMap)){
    print $outFh $oldTc . "\n";
#    my $newTcs = $finalMap->{$oldTc};
#    foreach my $newTc (keys %$newTcs){
#	print $outFh $oldTc . "\t" . $newTc . "\n";
#    }
}

#mappedSplitTc: the tc that the old tc was mapped to as a split.  See if it is the final split in the line or if there are more
sub getFinalSplitTcs{
    my ($mappedSplitTc, $tcHistoryMap, $finalTcs) = @_;
    
    my $newTcs = $tcHistoryMap->{$mappedSplitTc};
    print STDERR "\t\twithin get final split for $mappedSplitTc.  new tcs: $newTcs\n";
    if ($newTcs){
	foreach my $newTc(keys %$newTcs){
	    print "recursive call to final split tcs for $newTc\n";
	    $finalTcs = &getFinalSplitTcs($newTc, $tcHistoryMap, $finalTcs);
	}
    }
    else {
	$finalTcs->{$mappedSplitTc} = 1;
	print STDERR "\t\tadding mapped split tc $mappedSplitTc to final\n";
    }
    return $finalTcs;
}
