#!/usr/bin/perl

use strict;
use DBI;
use FileHandle;



my $humanSeqs = $ARGV[0];
my $outputFile = $ARGV[1];

unless ($outputFile){
    print STDERR "usage: perl makeHumanModbaseMap.pl <humanInputFile> <outputFile>\n";
    exit(1);
}

my $dbh = &getDbh();
my $sequences = &loadSeqs($humanSeqs);

#my $uniprotQuery = "select database_id from uniprot_taxonomy where current = 1 and seq_id = ?";
my $uniprotQuery = "select database_id from sequences where  database_name = 'gi' and run = 'human_2008' and seq_id = ?";

my $sth = $dbh->prepare($uniprotQuery);

my $outputFh = FileHandle->new(">" . $outputFile) || die "could not open $outputFile for writing\n";

foreach my $sequence (keys %$sequences){
    $sth->execute($sequence);

    my $foundId = 0;
    while (my ($databaseId) = $sth->fetchrow_array()){
	$foundId = 1;
	print $outputFh "$sequence\t$databaseId\n";
    }
    unless ($foundId){
	print STDERR "did not find ID for sequence $sequence\n";
    }

}


sub loadSeqs{

    my ($seqFile) = @_;
    my $seqs;
    my $seqFh = FileHandle->new("<" . $seqFile) || die "could not open $seqFile\n";

    while (<$seqFh>){
	chomp;
	my $line = $_;
	$seqs->{$line} = 1;
    }
    return $seqs;
}



sub getDbh{


    my $dbString = "DBI:mysql:database=modbase:hostname=modbase";
    my $username = "modbase";
    my $password = "modbasesecret";
    
    print STDERR "connecting\n";
    
    my $dbh = DBI->connect( $dbString, $username, $password, {RaiseError => 1});
    
    return $dbh;


}
