#!/usr/bin/perl

use strict;
use FileHandle;
use FastaReader;


my $inputFile = $ARGV[0];
my $outputFile = $ARGV[1];

unless ($inputFile && $outputFile){
    print STDERR "usage: perl getSmpIds.pl <inputFile> <outputFile>\n";
    exit(1);
}

my $reader = FastaReader->new("$inputFile", 1);
$reader->read();
my $sequences = $reader->getSequences();

my $outFh = FileHandle->new(">" . $outputFile) || die "could not open $outputFile for writing\n";

foreach my $header (keys %$sequences){
    my @cols = split('\|', $header);
    my $smp = $cols[0];
    $smp =~ s/\s//g;
    print $outFh $smp . "\n";
}
