*
* FOLD:
*
*  Darren R Flower 1991-5.
*
*   Define Secondary structure of a protein from analysis of hydrogen bonding 
*   patterns. Uses protocol related to that of Baker and Hubbard (1984) to 
*   define hydrogen bonds. Uses protocol related in part to that of Kabsch and 
*   Sander (1983) to do recognition of pattern. Use IUPAC definition to 
*   establish range limits. Analyse higher level organisation (Sheets, 
*   topology, Barrels, etc).
*
*-------------------------------------------------------------------------------
*
      PROGRAM FOLD
*
* announce subroutine.
*
      WRITE(*,1000)
*
* read databases.
*
      CALL DATAIN
*
* read control input.
*
      CALL READCARD
*
* format statements.
*
1000  FORMAT(/'  FOLD  version 5.0  D R Flower 1995.'/)
*
      STOP'FOLD has completed normally.'
      END
*
*-------------------------------------------------------------------------------
*
* Analyse this molecule.
*
      SUBROUTINE DOFOLD
*
* Declarations.
*
      INCLUDE 'FOLD.INC'
*
* open output files.
*
      CALL OPENAL
*
* calculate main chain dihedrals.
*
      CALL DIHED
*
* calculate disulphides.
*
      CALL SSBOND
*
* find hydrogen bonds.
*
      CALL SSCALC
*
* find hydrogen bonds.
*
      CALL SSANAL
*
* write results.
*
      CALL DISPLY
*
* Close output files.
*
      CALL CLOSE1
*
* format statements.
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* open named files stemming from read in file.
*
      SUBROUTINE OPENAL
*
* declarations.
*
      INTEGER EXDEC,OPDEC
*
      CHARACTER LINE*80,FLINE*80,NM*80
*
      INCLUDE 'FOLD.INC'
*
* Open input coordinate file
*
      OPEN(UNIT=1,STATUS='OLD',READONLY,ERR=100)
      GOTO 6767
*
100   CONTINUE
      WRITE(*,7002)
*
      RETURN
*
* Get FLINE name.
*
6767  CONTINUE
*
      INQUIRE(UNIT=1,NAME=LINE,EXIST=EXDEC,OPENED=OPDEC,ERR=1000)
*
      FLINE='                                                              
     +                                                   '
*
* parse root name from file name string.
*
      CALL FINDN(80,IFAIL,LINE,FLINE)
*
      IF (IFAIL.EQ.1) FLINE(1:8)='FOLD$OUT'
*
* now get names.
*
      MOLNAME=FLINE
*
*  long file with english in it. 
*
      CALL MAKEN(FLINE,NM,'long',4)
      OPEN(UNIT=9,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* summary file.
*
      CALL MAKEN(FLINE,NM,'sum',3)
      OPEN(UNIT=10,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* summary file.
*
      CALL MAKEN(FLINE,NM,'range',5)
      OPEN(UNIT=11,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* sheet analysis.
*
      CALL MAKEN(FLINE,NM,'sheet',5)
      OPEN(UNIT=12,FILE=NM,STATUS='NEW',RECL=2000,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* short summary.
*
      CALL MAKEN(FLINE,NM,'short',5)
      OPEN(UNIT=14,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* NBRF secondary structure file.
*
      CALL MAKEN(FLINE,NM,'nbrf',4)
      OPEN(UNIT=20,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
      WRITE(20,7020) FLINE(1:75)
*
* Hydrogen bond geometry file.
*
      CALL MAKEN(FLINE,NM,'hbonds',6)
      OPEN(UNIT=25,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* bulge analysis.
*
      CALL MAKEN(FLINE,NM,'bulge',5)
      OPEN(UNIT=43,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* hairpin analysis.
*
      CALL MAKEN(FLINE,NM,'hairpin',7)
      OPEN(UNIT=42,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* disulphide analysis.
*
      CALL MAKEN(FLINE,NM,'disul',5)
      OPEN(UNIT=46,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* write file of turns.
*
      CALL MAKEN(FLINE,NM,'turns',5)
      OPEN(UNIT=70,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* write vector file.
*
      CALL MAKEN(FLINE,NM,'vec',3)
      OPEN(UNIT=71,IOSTAT=IOS,STATUS='NEW',FILE=NM,
     + ACCESS='SEQUENTIAL',FORM='UNFORMATTED',RECL=8,ERR=1002)
*
* title each file.
*
      WRITE(9,8000)
      WRITE(10,8000)
      WRITE(11,8000)
      WRITE(12,8000)
      WRITE(14,8000)
      WRITE(25,8000)
      WRITE(43,8000)
      WRITE(42,8000)
      WRITE(46,8000)
      WRITE(70,8000)
*
* Error handling.
*
      GOTO 1001
*
1000  CONTINUE
*
* Input file errors.
*
      IF (EXDEC.NE..TRUE.) THEN
      WRITE(*,7000)
      RETURN
      ELSE
      IF (OPDEC.EQ..FALSE.) THEN
      WRITE(*,7001)
      RETURN
      ELSE
      WRITE(*,7002)
      RETURN
      ENDIF
      ENDIF
1002  CONTINUE
*
* Output file errors.
*
      WRITE(*,7003)
      RETURN
1001  CONTINUE
*
* format statements.
*
7000  FORMAT(/' Input File does not exist.'/)
7001  FORMAT(/' Input File exists but can not be opened.'/)
7002  FORMAT(/' Error opening Input File.'/)
7003  FORMAT(/' Error opening an Output File.'/)
7020  FORMAT('>X1;',A75/)
7060  FORMAT('CODE:  ',A10)
8000  FORMAT(//20X,'             F O L D '//,
     +         20X,' Summary of Secondary Structures'//)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* make name of file from root.
*
      SUBROUTINE MAKEN(NLINE,VV,SXS,GG)
*
* declarations.
*
      CHARACTER NLINE*80,SXS*30,VV*80
*
      INTEGER I,K,GG
*
* initialise.
*
      VV(1:80)='                                                              
     +                  '
*
* do the stuff.
*
      DO 1 I=1,80 
      IF (NLINE(81-I:81-I).NE.' ') GOTO 2 
1     CONTINUE
      RETURN 
2     CONTINUE
      K=81-I
*
      VV(1:K+GG+1)=NLINE(1:K)//'.'//SXS(1:GG)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Read control input from keywords.
*
      SUBROUTINE READCARD
*
* specification statements.
*
      INTEGER IFAIL
      CHARACTER A*80,CARD*10,BLINE*80,
     +AOLD*80,FILNAM*80,CASEALL*80,
     +SNAM1*80,SNAM2*80
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      BLINE='                                                                 
     +                                       '
*
* set defaults.
*
      FTYP=0
      ANGMIN=100.0
      ANGMAX=170.0
      DMINHB=3.5
      LNKTOL=1
      BLGDEC=0
      BLGLEN=0
      IUPAC=0
      IUPSHT=0
      RNGDEC=0
      INVDEC=0
      HELLEN=0
      STDLEN=0
      TRNDEC=0
      DRWDEC=0
      HELDEC=0
      SHTDEC=0
      TRIDEC=0
      DISULD=0
      PINDEC=0
      HBDEC=0
      NBRFDEC=0
      RANGED=0
      TRIWRI=2
      NOLONG=0
      NOSUM=0
      NOSHOR=0
      NOBUL=0
*
* data reading control.
*
      IREAD=5
      ILOG=129
      LOGDEC=0
*
* open external channel to sys$input or text file.
*
      OPEN(UNIT=IREAD,STATUS='UNKNOWN',ERR=101)
*
* loop through cards until read of some form of termination marker.
*
1     CONTINUE
*
* write prompt.
*
      IF (IREAD.EQ.5) WRITE(*,4000)
*
* read instruction line to parse.
*
      READ(IREAD,3000,END=120,ERR=1) A
*
* echo line.
*
      IF (IREAD.EQ.111) WRITE(*,4001) A
      IF (LOGDEC.EQ.1) WRITE(ILOG,3000) A
*
* cut any leading spaces.
*
      DO 10 I=1,80
      IF (A(I:I).NE.' ') THEN
      A(1:80)=A(I:80)//BLINE(1:I)
      L=I
      GOTO 20
      ENDIF
10    CONTINUE
*
20    CONTINUE
*
* check for comment marker.
*
      IF (A(1:1).EQ.'!') GOTO 1
      IEND=INDEX(A,'!')
      IF (IEND.EQ.0) IEND=80
*
* change case and get card.
*
      AOLD=A
      A=CASEALL(A,1)
      CARD=A(1:10)
*
* check for return or blank line only.
*
      IF (CARD(1:4).EQ.'    ') GOTO 1
*
* check for termination marker.
*
      IF (CARD(1:2).EQ.'##')   GOTO 101
      IF (CARD(1:3).EQ.'END')  GOTO 101
      IF (CARD(1:4).EQ.'QUIT') GOTO 101
      IF (CARD(1:4).EQ.'STOP') GOTO 101
      IF (CARD(1:4).EQ.'EXIT') GOTO 101
      IF (CARD(1:3).EQ.'BYE')  GOTO 101
*
* now check for each card in turn and then read arguments on card.
*
* open and read a file.
*
      IF (CARD(1:4).EQ.'READ') THEN
*
* parse file name.
*
      FILNAM=BLINE
      CALL PULWRD((IEND-4),FILNAM,AOLD(5:IEND))
      CALL LSTWRD(2,(IEND-4),SNAM1,A(5:IEND))
      CALL LSTWRD(3,(IEND-4),SNAM2,A(5:IEND))
*
* open files.
*
      IF (FILNAM(1:1).EQ.' ') THEN
*
      OPEN(UNIT=1,STATUS='OLD',ERR=1070,
     +READONLY,RECL=35000)
      REWIND(UNIT=1)
*
      CALL CLEAR1
*
      CALL FILEIN(1,IFAIL)
*
      GOTO 1
*
      ELSEIF (FILNAM(1:1).EQ.'@') THEN
*
* file of filenames.
*
      CLOSE(UNIT=2)
      OPEN(UNIT=2,STATUS='OLD',FILE=FILNAM(2:),ERR=1070,
     +READONLY,RECL=1000)
      REWIND(UNIT=2)
*
* process many files.
*
      CALL DOMANY(2)
*
      ELSE
*
* single files.
*
      CLOSE(UNIT=1)
      OPEN(UNIT=1,STATUS='OLD',FILE=FILNAM,ERR=1070,
     +READONLY,RECL=35000)
      REWIND(UNIT=1)
*
      CALL CLEAR1
*
      CALL FILEIN(1,IFAIL)
*
      ENDIF
*
      GOTO 1
*
* read from instruction file.
*
      ELSE IF (CARD(1:1).EQ.'@') THEN
*
* parse file name.
*
      IF (IREAD.EQ.5) THEN
      FILNAM=BLINE
      CALL PULWRD(IEND,FILNAM,AOLD(2:IEND))
*
* open input log file.
*
      OPEN(UNIT=111,FILE=FILNAM,STATUS='OLD',READONLY,
     +ERR=121)
*
* change to read log file.
*
      IOLD=IREAD
      IREAD=111
*
      ELSE
*
* log file within log file. not allowed.
*
      WRITE(*,4010)
      ENDIF
*
      GOTO 1
*
* open Log file.
*
      ELSE IF (CARD(1:3).EQ.'LOG') THEN
*
      IF (LOGDEC.EQ.0) THEN
      LOGDEC=1
      FILNAM=BLINE
      CALL PULWRD((IEND-3),FILNAM,AOLD(4:IEND))
      OPEN(UNIT=ILOG,FILE=FILNAM,STATUS='NEW',ERR=1071,
     +CARRIAGECONTROL='LIST')
      WRITE(*,4002)
      ELSE
      WRITE(*,4003)
      ENDIF
*
      GOTO 1
*
* close log file.
*
      ELSE IF (CARD(1:5).EQ.'NOLOG') THEN
*
      IF (LOGDEC.EQ.1) THEN      
      LOGDEC=0
      WRITE(*,4004)
      CLOSE(UNIT=129)
      ELSE
      WRITE(*,4005)
      ENDIF
*
      GOTO 1
*
      ELSE
*
* call all other options.
*
      CALL DOCARD(IFAIL,IEND,CARD,A,AOLD)
*
* Error trap.
*
      IF (IFAIL.EQ.1) THEN
      GOTO 750
      ELSEIF (IFAIL.EQ.2) THEN
      GOTO 100
      ELSEIF (IFAIL.EQ.3) THEN
      GOTO 1071
      ELSEIF (IFAIL.EQ.4) THEN
      GOTO 1071
      ELSE
      GOTO 1
      ENDIF
*
      ENDIF
*
* error trap and warn unknown card.
*
750   CONTINUE
*
      FILNAM=BLINE
      CALL PULWRD(IEND,FILNAM,AOLD(1:IEND))
      WRITE(*,3009) FILNAM(1:40)
      IF (LOGDEC.EQ.1) WRITE(ILOG,3009) FILNAM(1:40)
*
      GOTO 1
*
* Error trap error on failure on read.
*
100   CONTINUE
*
      FILNAM=BLINE
      CALL PULWRD(IEND,FILNAM,AOLD(1:IEND))
      WRITE(*,3005) FILNAM(1:40)
      IF (LOGDEC.EQ.1) WRITE(ILOG,3005) FILNAM(1:40)
*
      GOTO 1
*
* error trap read in.
*
120   CONTINUE
*
      CLOSE(UNIT=IREAD)
*
      IF (IREAD.EQ.111) THEN
      WRITE(*,3012)
      IREAD=5
      OPEN(UNIT=IREAD,STATUS='UNKNOWN')
      GOTO 1
      ELSE
      WRITE(*,3011)
      ENDIF
*     
      GOTO 101
*
* no file to open.
*
1070  CONTINUE
*
      WRITE(*,4059)
      GOTO 1
*
* no file to open.
*
1071  CONTINUE
*
      WRITE(*,4079)
      GOTO 1
*
* error trap for subsidiary input file.
*
121   CONTINUE
      WRITE(*,3020)
      GOTO 1
*
122   CONTINUE
      WRITE(*,3021)
      GOTO 1
*
101   CONTINUE
*
* close input and log files.
* 
      CLOSE(UNIT=5)
      IF (IREAD.EQ.111) CLOSE(UNIT=IREAD)
      IF (LOGDEC.EQ.1) CLOSE(UNIT=ILOG)
*
* format statements.
*
3000  FORMAT(A80)
3005  FORMAT(' Error parsing from command ',A40)
3009  FORMAT(' Unknown command ',A40)
3010  FORMAT(/
     +' Reading of commands has been completed with normal 
     +termination.')
3011  FORMAT(/
     +' Reading of commands has been terminated by end of file.')
3012  FORMAT(' Read end of subsidiary instruction file.')
3020  FORMAT(' Instruction file does not exist.')
3021  FORMAT(' Instruction file is empty.')
3050  FORMAT(/' ERROR: no instructions to read.')
*
4000  FORMAT(' Fold: '$)
4001  FORMAT(' Data line:'/,1X,A80)
4002  FORMAT(' LOG file opened.')
4003  FORMAT(' already writing a LOG file.')
4004  FORMAT(' LOG file now closed.')
4005  FORMAT(' no LOG file to close.')
4010  FORMAT(' already reading a LOG file.')
4050  FORMAT(' All parameters have been reset.')
4051  FORMAT(' Can not read input file. File type not given.')
4052  FORMAT(' Can not write output file. File type not given.')
4053  FORMAT(' Atom data cleared.')
4059  FORMAT(' Can not read input file.
     + Error in file specification.')
4060  FORMAT(' Creating sub-process.')
4079  FORMAT(' Can not open output file.
     + Error in file specification.')
*
5000  FORMAT(/' Rings perceived:'/)
5001  FORMAT(/' Geometry calculation.'/)
5002  FORMAT(' Bond angles.'/)
5003  FORMAT(/' Torsion angles.'/)
5005  FORMAT(' Bond Lengths.'/)
*
7001  FORMAT(/' Did not receive input/output file types.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get information from cards.
*
      SUBROUTINE DOCARD(IFAIL,IEND,CARD,A,AOLD)
*
* Declarations.
*
      INTEGER IFAIL,IEND,IIH(80)
      REAL FFH(80)
*
      CHARACTER A*80,CARD*10,CCH(80)*1,
     +AOLD*80,FILNAM*80,SNAM1*80
*
      INCLUDE 'FOLD.INC'
*
* Reinitialise.
*
      IFAIL=0
*
* check for each card in turn and then read arguments on card.
*
*  filetype:
*
      IF (CARD(1:6).EQ.'FILEIN') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      FTYP=IIH(1)
      IF (FTYP.LT.1.OR.FTYP.GT.5) GOTO 100
      GOTO 1
*
* define hbond parameters:
*
      ELSEIF (CARD(1:6).EQ.'ANGMIN') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      ANGMIN=FFH(1)
      IF (ANGMIN.LT.0.0)   ANGMIN=0.0
      IF (ANGMIN.GT.180.0) ANGMIN=180.0
*
      IF (NH.LT.2) THEN
      ANGMIN1=ANGMIN
      ELSE
      ANGMIN1=FFH(2)
      IF (ANGMIN1.LT.0.0)   ANGMIN1=0.0
      IF (ANGMIN1.GT.180.0) ANGMIN1=180.0
      ENDIF
*
      GOTO 1
*
      ELSEIF (CARD(1:6).EQ.'ANGMAX') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      ANGMAX=FFH(1)
      IF (ANGMAX.LT.0.0)   ANGMAX=0.0
      IF (ANGMAX.GT.180.0) ANGMAX=180.0
*
      IF (NH.LT.2) THEN
      ANGMAX1=ANGMIN
      ELSE
      ANGMAX1=FFH(2)
      IF (ANGMAX1.LT.0.0)   ANGMAX1=0.0
      IF (ANGMAX1.GT.180.0) ANGMAX1=180.0
      ENDIF
*
      GOTO 1
*
      ELSEIF (CARD(1:6).EQ.'DISMAX') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      DMAXHB=FFH(1)
      IF (DMINHB.LT.0.0) DMINHB=0.0
      GOTO 1
*
      ELSEIF (CARD(1:6).EQ.'DISMIN') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      DMINHB=FFH(1)
      IF (DMINHB.LT.0.0) DMINHB=0.0
      GOTO 1
*
      ELSEIF (CARD(1:7).EQ.'CONTACT') THEN
      CALL LRDRF(A(8:IEND),(IEND-7),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      DCONTACT=FFH(1)
      IF (DCONTACT.LT.0.0) DCONTACT=0.0
      GOTO 1
*
* toggle Analysis of beta bulges.
* 
      ELSE IF (CARD(1:5).EQ.'BULGE') THEN
      CALL LRDRF(A(6:IEND),(IEND-5),IIH,FFH,CCH,NH)
      IF (NH.LT.1) THEN
      BLGLEN=1
      ELSE
      BLGLEN=IIH(1)
      ENDIF
      GOTO 1 
*
* get tolerance for combining strands into sheets.
*
      ELSE IF (CARD(1:4).EQ.'JOIN') THEN
      CALL LRDRF(A(5:IEND),(IEND-4),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      LNKTOL=MAX(ABS(IIH(1)),ABS(INT(FFH(1))))
      GOTO 1 
*
* Analyse sheets.
*
      ELSE IF (CARD(1:6).EQ.'SHEETS') THEN
*
      SHTDEC=1
*
      GOTO 1 
*
* toggle bulge linking of strands. 
*
      ELSE IF (CARD(1:4).EQ.'LINK') THEN
      BLGDEC=1
      IF (BLGLEN.EQ.0) BLGLEN=1
      GOTO 1 
*
* toggle non-strict assignments.
*
      ELSE IF (CARD(1:5).EQ.'IUPAC') THEN
      IUPDEC=1
*
* flag strand options.
*
      IY=INDEX(A(1:IEND),'STRAND')
*
      IF (IY.GT.0) THEN 
      IUPSHT=1
      CALL LRDRF(A(IY:IEND),(IEND-IY),IIH,FFH,CCH,NH)
      IY=MAX(IIH(1),INT(FFH(1)))
      IF (IY.EQ.2) IUPSHT=2
      ENDIF
*
      GOTO 1 
*
* identify ring paths.
*
      ELSEIF (CARD(1:5).EQ.'REDUC') THEN
*
      REDDEC=1
      GOTO 1 
*
* identify ring paths.
*
      ELSEIF (CARD(1:5).EQ.'RINGS') THEN
*
      RNGDEC=1
      GOTO 1 
*
* identify turns.
*
      ELSEIF (CARD(1:5).EQ.'TURNS') THEN
*
      TRNDEC=1
      GOTO 1 
*
* Vector file.
*
      ELSEIF (CARD(1:4).EQ.'DRAW') THEN
*
      DRWDEC=1
      GOTO 1 
*
* Vector file.
*
      ELSEIF (CARD(1:5).EQ.'HBOND') THEN
*
      HBDEC=1
      GOTO 1 
*
* Vector file.
*
      ELSEIF (CARD(1:5).EQ.'HAIRP') THEN
*
      PINDEC=1
      GOTO 1 
*
* Write NBRF file.
*
      ELSEIF (CARD(1:4).EQ.'NBRF') THEN
*
      NBRFDEC=1
      GOTO 1
*
* Write Range file.
*
      ELSEIF (CARD(1:5).EQ.'RANGE') THEN
*
      RANGED=1
      GOTO 1
*
      ELSEIF (CARD(1:5).EQ.'DISUL') THEN
*
      DISULD=1
      GOTO 1
*
      ELSEIF (CARD(1:6).EQ.'NOLONG') THEN
*
      NOLONG=1
      GOTO 1
*
      ELSEIF (CARD(1:7).EQ.'NOSHORT') THEN
*
      NOSHOR=1
      GOTO 1
*
      ELSEIF (CARD(1:5).EQ.'NOSUM') THEN
*
      NOSUM=1
      GOTO 1
*
      ELSEIF (CARD(1:5).EQ.'NOBUL') THEN
*
      NOBUL=1
      GOTO 1
*
      ELSEIF (CARD(1:4).EQ.'VIEW') THEN
*
      CALL VIEW
*
      ELSEIF (CARD(1:5).EQ.'ANALY') THEN
*
* Analyse structure.
*
      IF (NN.GT.0) THEN
      CALL DOFOLD
      ELSE
      WRITE(*,3045)
      ENDIF
*
      GOTO 1
      ELSE
*
* unknown card.
*
      IFAIL=1
*
      ENDIF
*
* jump to end of look up.
*
1     CONTINUE
*
      RETURN
*
* error trap.
*
100   CONTINUE
*
      IFAIL=2
      RETURN
*
1070  CONTINUE
*
      IFAIL=3
      RETURN
*
1071  CONTINUE
*
      IFAIL=4
*
* error trap.
*
      IF (ANGMAX.LT.ANGMIN) THEN
      APAP=ANGMAX
      ANGMAX=ANGMIN
      ANGMIN=APAP
      ENDIF
*
* format statements.
*
3000  FORMAT(A80)
3005  FORMAT(' Error reading from card ',A4)
3009  FORMAT(' unknown card encountered ',A4)
3010  FORMAT(/
     +' Reading of cards has been completed with normal termination.')
3031  FORMAT(/
     +' Reading of cards has been terminated by end of file.')
3045  FORMAT(' No structure available to analyze.')
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
*  read in files.
*
      SUBROUTINE FILEIN(II,IFAIL)
*
* declarations.
*
      INTEGER II,IDEC,IFAIL
*
      INCLUDE 'FOLD.INC'
*
      IFAIL=0
*
* open files.
*
      OPEN(UNIT=II,STATUS='OLD',READONLY,ERR=100)
*
* choose filetype.
*
      IF (FTYP.EQ.1) THEN
      CALL PROLSQIN(II)
      ELSEIF (FTYP.EQ.2) THEN 
      CALL PDBIN(II)
      ELSEIF (FTYP.EQ.5) THEN
      CALL FRODOIN(II)
      ELSE
      WRITE(*,1000)
      CALL PDBIN(II)
      ENDIF
*
* create atom lookup table.
*
      CALL LOOKUP(IDEC)
*
* error trap no atoms
*
      IF (IDEC.EQ.1) THEN
      IFAIL=1
      WRITE(*,1002)
      CLOSE(UNIT=9,DISPOSE='DELETE')
      CLOSE(UNIT=10,DISPOSE='DELETE')
      CLOSE(UNIT=11,DISPOSE='DELETE')
      CLOSE(UNIT=12,DISPOSE='DELETE')
      CLOSE(UNIT=42,DISPOSE='DELETE')
      CLOSE(UNIT=43,DISPOSE='DELETE')
      RETURN
      ENDIF
*
      RETURN
*
* error no file.
*
100   CONTINUE      
*
      WRITE(*,1001)
*
* format statements.
*
1000  FORMAT(/' ERROR: file type not given.'/) 
1001  FORMAT(/' ERROR: file not found.'/) 
1002  FORMAT(/' ERROR: No protein atoms read from file.'/) 
*
      END
*
*-------------------------------------------------------------------------------
*
*' read in FRODO type DIAMOND format file.
*
      SUBROUTINE FRODOIN(II)
*
* declarations.
*
      INTEGER J,II
*
      INCLUDE 'FOLD.INC'
*
* announce subroutine.
*
      WRITE(*,7001)
*
      DO 11 J=1,3
      READ(II,101) DFLINE(J)
11    CONTINUE
*
      J=1
*
1     CONTINUE
*
      READ(II,100,ERR=50,END=500)
     +X(J),Y(J),Z(J),
     +BFAC(J),AT(J),RN(J),AN(J),ATR(J),
     +RNAM(J),RLAB(J),ATNAM(J)
*
      J=J+1
*
      IF (J.GT.7000) THEN
      WRITE(*,8000)
      NN=7000
      RETURN
      ENDIF
*
50    CONTINUE
      GOTO 1
500   CONTINUE
      WRITE(*,7000)
*
      NN=J-1
*
      IF (NN.GT.0) THEN
      WRITE(*,7002) NN
      ELSE 
      WRITE(*,7003) 
      RETURN
      ENDIF
*
* format statements:
*
100   FORMAT(4F10.5,3I5,F9.4,1X,A3,4X,A1,2X,A4)                           DIAMF
101   FORMAT(A80)
7000  FORMAT(/' Read-in of file completed.')
7001  FORMAT(/' Reading Frodo type Diamond format file (5).')
7002  FORMAT(/1X,I5,' atoms read in.'/)
7003  FORMAT(/' ERROR: no atoms read from file.'/)
8000  FORMAT(/' Maximum number of atoms exceeded. Read in aborted.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
*' read in BROOKHAVEN format file.
*
      SUBROUTINE PDBIN(II)
*
* declarations.
*
      INTEGER J,II
      CHARACTER IDEN*6
*
      INCLUDE 'FOLD.INC'
*
* announce subroutine
*
      WRITE(*,7001)
*
* work through file.
*
      J=1
1     CONTINUE
*
      READ(II,100,END=500,ERR=50)
     +IDEN,AN(J),ATNAM(J),RNAM(J),RLAB(J),
     +RN(J),
     +X(J),Y(J),Z(J),QOCC(J),BFAC(J)
*
      IF (IDEN.EQ.'ATOM  ') THEN 
      ATY(J)=1
      J=J+1
      ENDIF
*
      IF (J.GT.7000) THEN
      WRITE(*,8000)
      NN=7000
      RETURN
      ENDIF 
*
50    CONTINUE
      GOTO 1
500   CONTINUE
      WRITE(*,7000)
*
      NN=J-1
*
      IF (NN.GT.0) THEN
      WRITE(*,7002) NN
      ELSE 
      WRITE(*,7003) 
      RETURN
      ENDIF
*
* format statements:
*
100   FORMAT(A6,I5,2X,A4,A3,1X,A1,I4,4X,3F8.3,2F6.2)                      PDB
7000  FORMAT(/' Read-in of file completed.')
7001  FORMAT(/' Reading Brookhaven format file.')
7002  FORMAT(/1X,I5,' atoms read in.'/)
7003  FORMAT(/' ERROR: no atoms read from file.'/)
8000  FORMAT(/' Maximum number of atoms exceeded. Read in aborted.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* read in PROLSQ type DIAMOND format file.
*
      SUBROUTINE PROLSQIN(II)
*
* declarations.
*
      INTEGER J,II
*
      INCLUDE 'FOLD.INC'
*
* announce subroutine.
*
      WRITE(*,7001)
*
      DO 11 J=1,3
      READ(II,101) DFLINE(J)
11    CONTINUE
*
      J=1
*
1     CONTINUE
*
      READ(II,100,ERR=50,END=500)
     +X(J),Y(J),Z(J),
     +BFAC(J),AT(J),RN(J),AN(J),ATR(J),
     +RNAM(J),RLAB(J),ATNAM(J)
*
      J=J+1
*
      IF (J.GT.7000) THEN
      WRITE(*,8000)
      NN=7000
      RETURN
      ENDIF
*
50    CONTINUE
      GOTO 1
500   CONTINUE
      WRITE(*,7000)
*
      NN=J-1
*
      IF (NN.GT.0) THEN
      WRITE(*,7002) NN
      ELSE 
      WRITE(*,7003) 
      RETURN
      ENDIF
*
* format statements:
*
100   FORMAT(4F10.5,3I5,F9.4,1X,A3,3X,A1,3X,A4)                           DIAMP
101   FORMAT(A80)
7000  FORMAT(/' Read-in of file completed.')
7001  FORMAT(/' Reading a Prolsq type Diamond format file.')
7002  FORMAT(/1X,I5,' atoms read in.'/)
7003  FORMAT(/' ERROR: no atoms read from file.'/)
8000  FORMAT(/' Maximum number of atoms exceeded. Read in aborted.'/)
*
      RETURN 
      END
*  
*-------------------------------------------------------------------------------
*
* create lookup table or index for atoms.
*
      SUBROUTINE LOOKUP(IDEC)
*
* Declarations.
*
      INTEGER I,J,K,PP,E1,CHDEC,IP1,IV
      INTEGER IND(1000),IDN2(1000),LKL(1000),ATMPCH(1000)
*
      CHARACTER CHLIST*20
*
* lookup table:
*
      CHARACTER ATLOOK(38)*4
*
      INCLUDE 'FOLD.INC'
*
* form lookup table for standard atom names.
*
      DATA  ATLOOK /
*      1      2      3      4      5
     +'N   ','C   ','O   ','CA  ','CB  ',
*      6      7      8      9
     +'CG  ','CD  ','NE  ','CZ  ',
*      10     11     12     13
     +'NH1 ','NH2 ','OD1 ','OD2 ',
*      14     15     16     17
     +'CD1 ','CE1 ','CE2 ','CD2 ',
*      18     19     20     21
     +'SG  ','OE1 ','OE2 ','OH  ',
*      22     23     24     25
     +'OG1 ','CG2 ','CE  ','NZ  ',
*      26     27     28     29
     +'CG1 ','ND2 ','NE2 ','SD  ',
*      30     31     32
     +'OG  ','OT  ','OTX ', 
     +'ND1 ',
     +'NE1 ',
     +'CZ2 ',
     +'CH2 ',
     +'CZ3 ',
     +'CE3 ' /
*
* Initialise.
*
      CHLIST='                                                    '
*
* Create lookup table for atoms.
*
* error trap.
*
      IF (NN.LT.1) THEN
      IDEC=1
      RETURN
      ELSE
*
* initialise with first atom.
* 
      CHL=1
      CHLIST(1:1)=RLAB(1)
      RN1(1)=RN(1)
      RN2(1)=RN(1)
      ATMPCH(1)=0
*
* loop through all atoms creating index as we go.
*
      DO 4 I=1,NN
*
* check in list of chain identifiers.
*
      PP=0
      CHDEC=INDEX(CHLIST(1:CHL),RLAB(I))
*
* is this a new chain.
*
      IF (CHDEC.LT.1) THEN
*
      IF (CHL.LT.10) THEN
      CHL=CHL+1
      CHLIST(CHL:CHL)=RLAB(I)
      CHDEC=CHL
      RN1(CHDEC)=RN(I)
      RN2(CHDEC)=RN(I)
      ATMPCH(CHDEC)=1
      ELSE
      GOTO 4
      ENDIF
*
      ELSE
*
* increment atoms/chain counter.
*
      ATMPCH(CHDEC)=ATMPCH(CHDEC)+1
*
      ENDIF
*
* get limits of this chain.
*
      RN2(CHDEC)=MAX(RN2(CHDEC),RN(I))
      RN1(CHDEC)=MIN(RN1(CHDEC),RN(I))
*
* get pointers.
*
      PP=POS(-1,RN(I),CHDEC)+1
      POS(-1,RN(I),CHDEC)=PP
*
      POS(PP,RN(I),CHDEC)=I
*
4     CONTINUE
*
* now go through tree structure assigning residue types and sorting
* protein atoms.
*
      DO 10 I=1,CHL
      DO 10 J=RN1(I),RN2(I)
*
* reset
*
      IJ=0
      KJ=0
      LMAX=0
*
* get number of atoms in this residue.
*
      INAT=POS(-1,J,I)
*
* error trap empty residue.
*
      IF (INAT.GT.0) THEN
      DO 11 K=1,INAT
*
* get pointer.
*
      JJ=POS(K,J,I)
*
* is it a protein or hetero atom.
* is atom in protein lookup table.
*
      DO 12 L=1,38
      IF (ATNAM(JJ).EQ.ATLOOK(L)) THEN
      IJ=IJ+1
      LKL(IJ)=JJ
      IND(IJ)=L
      IF (LMAX.LT.L) LMAX=L
      ENDIF
12    CONTINUE
*
      KJ=KJ+1
*
* error trap.
*
11    CONTINUE
      ENDIF
*
* assign residue type.
*
      IF (KJ.EQ.0) THEN
*
* no atoms.
*
      POS(0,J,I)=-1
      ELSE
*
      IF (IJ.NE.KJ) THEN
*
* not protein.
*
      POS(0,J,I)=0
*
      ELSE
*
* protein.
*
      POS(0,J,I)=1
*
* error trap no atoms.
*
      IF (INAT.GT.0) THEN
*
* sort on position in atom list.
*
      CALL ISORT(INAT,IND,IDN2)
*
* reinitialise.
*
      DO 17 L=1,40
      POS(L,J,I)=0
17    CONTINUE
*
* write back the index.
*
      IT1=0
      DO 16 L=1,INAT
*
* get pointer to sorted position.
*
      E1=IDN2(L)
*
      IF (E1.GT.0) THEN
*
* within residue position counter
*
      IT1=IT1+1
*
* get pointers.
*
      IV=LKL(E1)
      IP1=IND(E1)
*
* error trap.
*
      IF (IP1.LT.41) THEN
      IF (IV.GT.0.AND.IV.LE.NN) THEN
*
* save pointer to data arrays.
*
      POS(IT1,J,I)=IV
*
      ENDIF
      ENDIF
      ENDIF
*
16    CONTINUE
*
* record number of atoms in this residue.
*
      POS(-1,J,I)=INAT
*
      ENDIF
*
      ENDIF
      ENDIF
*
10    CONTINUE
*
* Write results: Summary of chain labels and size of chains.
*
      CCLIS=CHLIST
*
      WRITE(*,1000) CHL
      DO 7 I=1,CHL
      WRITE(*,1001) I,CHLIST(I:I),ATMPCH(I),RN1(I),RN2(I)
7     CONTINUE
*
      ENDIF
*
* format statements.
*
1000  FORMAT(' Number of different chains:',I3,'.')
1001  FORMAT('   chain',I4,' label:',1X,A1,' with',I5,' atoms.'/,
     +       '        residue limits:',I4,' - ',I4,'.')
1010  FORMAT(' Unknown Atom Name: ',A4,' from chain:',I4)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get next word from string.
*
      SUBROUTINE PULWRD(II,B,A)
*
* declarations.
*
      INTEGER II,ICOUNT,IDEC
      CHARACTER A*(*),B*80
*
* initialise
*
      ICOUNT=0
      IDEC=0
      B='                                                              
     +                                                              '
*
* work through line.
*
      DO 1 I=1,II
*
      IF (A(I:I).NE.' ') THEN
      IDEC=1
      ICOUNT=ICOUNT+1
      B(ICOUNT:ICOUNT)=A(I:I)
      ENDIF
*
      IF (A(I:I).EQ.' '.AND.IDEC.EQ.1) RETURN
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
*  Integer sorting routine. Returns the order of A in IN.
*
*  ref: COMM. ACM vol.12 #3 march 1969, R.C.Singleton.
*
      SUBROUTINE ISORT(N,A,IN)
*
* declarations.
*
      INTEGER N,A(N),IN(N),IL(16),IU(16),T,TT,I,J
*
* initialise.
*
      DO 1000 I=1,N
      IN(I)=I
1000  CONTINUE
*
      M=1
      I=1
      J=N
*
* begin.
*
5     CONTINUE
      IF (I.GE.J) GOTO 70
10    CONTINUE
      K=I
      IJ=(I+J)/2
      T=IN(IJ)
      IF (A(IN(I)).LE.A(T)) GOTO 20
      IN(IJ)=IN(I)
      IN(I)=T
      T=IN(IJ)
20    CONTINUE
      L=J
      IF (A(IN(J)).GE.A(T)) GOTO 40
      IF (A(IN(J)).LT.A(IN(I))) GOTO 25
      IN(IJ)=IN(J)
      IN(J)=T
      T=IN(IJ)
      GOTO 40
*
25    CONTINUE
      IN(IJ)=IN(I)
      IN(I)=IN(J)
      IN(J)=T
      T=IN(IJ)
      GOTO 40
*
30    CONTINUE
      IN(L)=IN(K)
      IN(K)=TT
40    CONTINUE
      L=L-1
      IF (A(IN(L)).GT.A(T)) GOTO 40
      TT=IN(L)
50    CONTINUE
      K=K+1
      IF (A(IN(K)).LT.A(T)) GOTO 50
      IF (K.LE.L) GOTO 30
      IF ((L-I).LE.(J-K)) GOTO 60
      IL(M)=I
      IU(M)=L
      I=K
      M=M+1
      GOTO 80
*
60    CONTINUE
      IL(M)=K
      IU(M)=J
      J=L
      M=M+1
      GOTO 80
*
70    CONTINUE
      M=M-1
      IF (M.EQ.0) GOTO 900
      I=IL(M)
      J=IU(M)
80    CONTINUE
      IF ((J-I).GE.11) GOTO 10
      IF (I.EQ.1) GOTO 5
      I=I-1
90    CONTINUE
      I=I+1
      IF (I.EQ.J) GOTO 70
      T=IN(I+1)
      IF (A(IN(I)).LE.A(T)) GOTO 90
      K=I
100   CONTINUE
      IN(K+1)=IN(K)
      K=K-1
      IF (A(T).LT.A(IN(K))) GOTO 100
      IN(K+1)=T
      GOTO 90
*
900   CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* read fragment library and angle files.
*
      SUBROUTINE DATAIN
*
* declarations.
*
      INCLUDE 'FOLD.INC'
*
* open next file.
*
      OPEN(UNIT=116,STATUS='OLD',READONLY,ERR=200)
*
* read torsion angle names/pointers.
*
      NAT=1
*
10    CONTINUE
*
      READ(116,2000,ERR=10,END=12) 
     +TNAM1(NAT),T1(NAT),
     +TNAM2(NAT),T2(NAT),
     +TNAM3(NAT),T3(NAT),
     +TNAM4(NAT),T4(NAT),
     +TORNAM(NAT)
*
      NAT=NAT+1
*
      GOTO 10
*
12    CONTINUE
*
      NAT=NAT-1
*
      WRITE(*,2010) NAT
*
* store number of torsions.
*
      NTOR=NAT
*
* close data file.
*
      CLOSE(UNIT=116)
*
200   CONTINUE
*
* format statements.
*
1000  FORMAT(A1,A3,1X,A1,I3)
1001  FORMAT(A4,I3,I4,I2,3F10.5,4(I3,I1))
1002  FORMAT(I5,' library residues read.') 
2000  FORMAT(4(A4,I3,1X),A4)
2010  FORMAT(I5,' Torsion angles read.')
7000  FORMAT(/1X,A3,1X,I3/)
7003  FORMAT(/' Reading Libraries.'/)
7004  FORMAT(/)
7103  FORMAT(1X,A4,2X,F9.4)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* read fragment library and angle files.
*
      SUBROUTINE FINDN(IL,IFAIL,LINE,FLINE)
*
* declarations.
*
      INTEGER IL,K1,K2,IFAIL
      CHARACTER LINE*(*),FLINE*(*)
*
* initialise.
*
      K1=0
      K2=0
*
* find root from input string.
*
      DO 1 I=IL,1,-1
*
* Vax delimiter.
*
      IF (LINE(I:I).EQ.']') GOTO 11
*
* Unix delimiter.
*
      IF (LINE(I:I).EQ.'/') GOTO 11
*
1     CONTINUE
*
* trap just name.
*
      I=0
*
11    CONTINUE
*
      K1=I+1
*
      DO 2 I=IL,K1,-1
      IF (LINE(I:I).EQ.'.') GOTO 12
2     CONTINUE
*
* trap just name.
*
      I=IL+1
*
12    CONTINUE
*
      K2=I-1
*
* error trap.
*
      IF (K1.LT.K2) THEN 
*
* create root name string.
*
      IFAIL=0
      CL=(K2-K1)+1
      FLINE(1:CL)=LINE(K1:K2)
*
      ELSE
*
* fail.
*
      IFAIL=1
*
      ENDIF 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* case swapping routine:
*' IFLAG=1 : lower to upper case.
*' IFLAG=0 : upper to lower case.
*
      CHARACTER*80 FUNCTION CASEALL(W,IFLAG)
*
* declarations.
*
      IMPLICIT LOGICAL (A-Z)
*
      INTEGER I,AV,IFLAG
*
      CHARACTER W*80
*
* do change.
*
      IF (IFLAG.EQ.1) THEN
      DO 1 I=1,80
      AV=ICHAR(W(I:I))
      IF (AV.GE.97.AND.AV.LE.122) AV=AV-32
      W(I:I)=CHAR(AV)
1     CONTINUE
      ELSE
      DO 11 I=1,80
      AV=ICHAR(W(I:I))
      IF (AV.GE.65.AND.AV.LE.90) AV=AV+32
      W(I:I)=CHAR(AV)
11    CONTINUE
      ENDIF
*
      CASEALL=W
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get first word from a line
*
      SUBROUTINE LSTWRD(IW,II,B,A)
*
* declarations.
*
      INTEGER II,ICOUNT,IDEC
      CHARACTER A*(*),B*80
*
* initialise
*
      ICOUNT=0
      IDEC=0
      B(1:80)='                                                  
     +                                             '
      IT=1
*
* work through line.
*
      DO 1 I=1,II
*
* a non-blank character.
*
      IF (A(I:I).NE.' ') THEN
*
* set flags and counters.
*
      IDEC=1
      ICOUNT=ICOUNT+1
*
* Error trap.
*
      IF (ICOUNT.LT.81) THEN
      B(ICOUNT:ICOUNT)=A(I:I)
      ENDIF
*
      ENDIF
*
* end of a word.
*
      IF (A(I:I).EQ.' '.AND.IDEC.EQ.1) THEN
*
* reset flags and counters.
*
      ICOUNT=0
      IDEC=0
*
* increment word counter.
*
      IT=IT+1
*
* Check if we have the word required.
*
      IF (IT.EQ.IW+1) RETURN
*
* default word string.
*
      B(1:80)='                                                  
     +                                             '
      ENDIF
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* automated transformation.
*
      SUBROUTINE DOMANY(IO1)
*
* Declarations.
*
      INTEGER IO1
      CHARACTER FLINE*80,BLINE*80
      CHARACTER FNAM1*80
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      BLINE='                                                             
     +                                                '
*
* work through a file of file names.
*
1     CONTINUE
*
* read a file name.
*
      READ(IO1,1000,ERR=1,END=100) FLINE
*
* parse names.
*
      FNAM1=BLINE
      CALL PULWRD(80,FNAM1,FLINE)
*
* open input file.
*
      IF (FNAM1(1:1).EQ.' ') THEN
      GOTO 1
      ELSE
      OPEN(UNIT=1,STATUS='OLD',FILE=FNAM1,RECL=1000,
     +READONLY,ERR=70)
      REWIND(UNIT=1)
*
* reinitialise.
*
      CALL CLEAR1
*
* read file.
*
      CALL FILEIN(1,IFAIL)
*
      ENDIF
*
* do analysis.
*
      IF (IFAIL.EQ.0) THEN
      CALL DOFOLD
      ENDIF
*
70    CONTINUE
*
* Close files.
*
      CLOSE(UNIT=1)
*
* return for next one.
*
      GOTO 1
*
100   CONTINUE
*
1000  FORMAT(A80)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* set/reset defaults.
*
      SUBROUTINE CLEAR1
*
* declarations.
*
      INTEGER I,J,II
      INCLUDE 'FOLD.INC'
*
* initialise atom indexing.
*
      DO 1 I=1,CHL
*
      DO 2 J=RN1(I),RN2(I)
      DO 2 II=-2,40
      POS(II,J,I)=0
2     CONTINUE
*
      RN1(I)=0
      RN2(I)=0
*
1     CONTINUE
*
      CALL CLEAR2
*
      CHL=0
*
* clear connectivities and other information.
*
      DO 3 I=1,NN
*
* clear attributes.
*
      X(I)=0.0
      Y(I)=0.0
      Z(I)=0.0
      BFAC(I)=0.0
      QOCC(I)=0.0
*
      RN(I)=1
      ATR(I)=0.0
      AT(I)=0
      AN(I)=0
      ATY(I)=0
*
3     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE CLEAR2
*
      INCLUDE 'FOLD.INC'
*
* initialise residue based properties.
*
      DO 1 I=1,CHL
      DO 2 J=RN1(I),RN2(I)
*
      DO 10 K=1,10
      DANGL(K,J,I)=0
10    CONTINUE
      DO 11 K=1,6
      BLGLNK(K,J,I)=0
11    CONTINUE
*
2     CONTINUE
1     CONTINUE
*
* initialise element based properties.
*
      DO 3 I=1,10
*
*
      DO 4 J=1,100
      BULGE1(J,I)=0
      BULGE2(J,I)=0
4     CONTINUE
*
3     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* set/reset defaults.
*
      SUBROUTINE CLOSE1
*
      INCLUDE 'FOLD.INC'
*
* Close files. Keep or delete.
*
* Long file.
*
      IF (NOLONG.EQ.0) THEN
      CLOSE(UNIT=9)
      ELSE
      CLOSE(UNIT=9,DISPOSE='DELETE')
      ENDIF
*
* Summary file.
*
      IF (NOSUM.EQ.0) THEN
      CLOSE(UNIT=10)
      ELSE
      CLOSE(UNIT=10,DISPOSE='DELETE')
      ENDIF
*
* Short file.
*
      IF (NOSHOR.EQ.0) THEN
      CLOSE(UNIT=14)
      ELSE
      CLOSE(UNIT=14,DISPOSE='DELETE')
      ENDIF
*
* Summary of Ranges.
*
      IF (RANGED.EQ.0) THEN
      CLOSE(UNIT=11,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=11)
      ENDIF
*
* Sheets file.
*
      IF (SHTDEC.EQ.0) THEN
      CLOSE(UNIT=12,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=12)
      ENDIF
*
* NBRF file.
*
      IF (NBRFDEC.EQ.0) THEN
      CLOSE(UNIT=20,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=20)
      ENDIF
*
* Hydrogen Bonds.
*
      IF (HBDEC.EQ.0) THEN
      CLOSE(UNIT=25,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=25)
      ENDIF
*
* Bulges.
*
      IF (BLGDEC.EQ.0.OR.NOBUL.EQ.1) THEN
      CLOSE(UNIT=43,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=43)
      ENDIF
*
* Hairpins.
*
      IF (PINDEC.EQ.0) THEN
      CLOSE(UNIT=42,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=42)
      ENDIF
*
* Disulphides.
*
      IF (DISULD.EQ.0) THEN
      CLOSE(UNIT=46,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=46)
      ENDIF
*
* Turns.
*
      IF (TRNDEC.EQ.0) THEN
      CLOSE(UNIT=70,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=70)
      ENDIF
*
* Drawing / Vector file.
*
      IF (DRWDEC.EQ.0) THEN
      CLOSE(UNIT=71,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=71)
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* do hydrogen bonding calculation.
*
* find donors and acceptors.
*
      SUBROUTINE SSCALC
*
* declarations.
*
      INTEGER NMAINO,NMAINN,E1,E2,E3,E4,NTRIC,I,J
      INTEGER IMAINN(5000),IMAINO(5000)
*
      INTEGER 
     +HBLIST(1000,1000),
     +PARLST(2,1000),
     +TYLST(2,1000),
     +SSHEL(1000),
     +SSTRN(1000),
     +SSSHT(1000),
     +TRILST(4,1000)
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      IOBLG=1
      INBULG=0
      NHBOND=0
*
      DO 500 I=1,10
      DO 500 J=1,1000
      SECSTR(J,I)=0
      HELSTR(J,I)=0
      SHTSTR(J,I)=0
      ITURN(J,I)=0
      ISSBND(J,I)=0
      IANGL(J,I)=0
      BBPART(1,J,I)=0
      BBPART(2,J,I)=0   
      PPLINK(1,J,I)=0
      PPLINK(2,J,I)=0
      TYLINK(1,J,I)=0
      TYLINK(2,J,I)=0
500   CONTINUE
*
* work through chains.
*
      DO 1 I=1,CHL
*
* reinitialise.
*
      DO 501 II=1,1000
      SSHEL(II)=0
      SSTRN(II)=0
      SSSHT(II)=0
      TYLST(1,II)=0
      TYLST(2,II)=0
      PARLST(1,II)=0
      PARLST(2,II)=0
      DO 501 J=1,4
      TRILST(J,II)=0
501   CONTINUE
*
* Calculate hydrogen bonds.
*
      CALL HBCALC(I,NMAINN,NMAINO,IMAINN,IMAINO,HBLIST)
*
* Analyse hydrogen bonds.
*
      NTRIC=0
      CALL HBANAL(NMAINO,I,NTRIC,
     +SSHEL,SSSHT,SSTRN,PARLST,TYLST,HBLIST,
     +TRILST)
*
* put secondary structure into global array.
*
      DO 3 J=1,NMAINO
*
* get pointer.
*
      E1=IMAINO(J)
*
* Error trap.
*
      IF (E1.GT.0) THEN 
*
* get pointers.
*
      E2=RN(E1)
      E3=INDEX(CCLIS,RLAB(E1))
*
* Error trap.
*
      IF (E2.GT.0.AND.E3.GT.0) THEN
*
* save secondary structure information.
*
      SECSTR(E2,E3)=MIN(SSHEL(J),ABS(SSSHT(J)))
      HELSTR(E2,E3)=SSHEL(J)
      SHTSTR(E2,E3)=SSSHT(J)
      ITURN(E2,E3)=SSTRN(J)
*
* partners.
*
      E4=IMAINO(PARLST(1,J))
      IF (E4.GT.0) THEN
      BBPART(1,E2,E3)=E4 
      TYLINK(1,E2,E3)=TYLST(1,J)
      ENDIF
*
      E4=IMAINO(PARLST(2,J))
      IF (E4.GT.0) THEN
      BBPART(2,E2,E3)=E4 
      TYLINK(2,E2,E3)=TYLST(2,J)
      ENDIF
*
      ENDIF
      ENDIF
3     CONTINUE
*
* process bulge links.
*
      IF (BLGLEN.GT.0.AND.INBULG.GE.IOBLG) THEN
*
* do the extra bulges found for this chain.
*
      DO 4 I1=IOBLG,INBULG
*
* get pointers.
*
      E1=BLGLNK(1,1,I1)
      E2=BLGLNK(2,1,I1)
      E3=BLGLNK(3,1,I1)
*
* save them.
*
      BLGLNK(1,1,I1)=IMAINO(E1)
      BLGLNK(2,1,I1)=IMAINO(E2)
      BLGLNK(3,1,I1)=IMAINO(E3)
*
4     CONTINUE
*
* save end of this list.
*
      IOBLG=INBULG
      ENDIF
*
1     CONTINUE
*
      RETURN
      END
*  
*-------------------------------------------------------------------------------
*
* do hydrogen bonding ANALYSIS.
*
      SUBROUTINE HBANAL(IELEMN,ICHL,NTRIC,
     +SSHEL,SSSHT,SSTRN,PARLST,TYLST,HBLIST,TRILST)
*
* declarations.
*
      INTEGER I,J,K,IELEMN,ICHL
*
      INTEGER HBLIST(1000,1000),PARLST(2,1000),
     +SSHEL(1000),SSSHT(1000),TYLST(2,1000),SSTRN(1000),
     +TRILST(4,1000),NTRIC
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      DO 2 J=1,IELEMN
*
* Primitive assignment.
*
      SSHEL(J)=0
      SSSHT(J)=0
*
* N(j)->O (partner)
*
* INNER
*
      PARLST(1,J)=0
*
* O(j)->N (partner)
*
* OUTER
*
      PARLST(2,J)=0
*
2     CONTINUE
*
* get turns and helices.
*
      DO 401 J=1,IELEMN
*
* 2 Turns.
*
      JJ=J-2
      IF (JJ.GT.1) THEN
      IF (HBLIST(JJ,J).EQ.1) THEN
      SSTRN(J)=SSTRN(J)+2
      ENDIF
      ENDIF
*
* 3 Turns.
*
      JJ=J-3
      IF (JJ.GT.1) THEN
      IF (HBLIST(JJ,J).EQ.1) THEN
      SSHEL(J)=3
      SSTRN(J)=SSTRN(J)+30
      ENDIF
      ENDIF
*
* 4 Turns.
*
      JJ=J-4
      IF (JJ.GT.1) THEN
      IF (HBLIST(JJ,J).EQ.1) THEN
      SSHEL(J)=4
      SSTRN(J)=SSTRN(J)+400
      ENDIF
      ENDIF
*
401   CONTINUE
*
* beta bridges.
*
      DO 101 J=1,IELEMN
*
      DO 101 I=J,IELEMN
*
* error trap.
*
      IJI=ABS(J-I)
*
* Bulges.
*
      IF (BLGLEN.GT.0) THEN
*
      DO 201 K=1,BLGLEN
*
* error trap.
*
      IF (IJI.LE.K) GOTO 201
*
*  anti-parallel.
*
*   classic.
*
      IF 
     +(HBLIST(I,J-K).EQ.1.AND.HBLIST(J,I).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=I
      BLGLNK(2,1,INBULG)=J
      BLGLNK(3,1,INBULG)=J+K
      BLGLNK(1,2,INBULG)=1
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
      IF 
     +(HBLIST(J,I-K).EQ.1.AND.HBLIST(I,J).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=J
      BLGLNK(2,1,INBULG)=I
      BLGLNK(3,1,INBULG)=I+K
      BLGLNK(1,2,INBULG)=1
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
*  wide type.
*
      IF 
     +(HBLIST(J-1,I+1).EQ.1.AND.HBLIST(I-1,J+1+K).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=I
      BLGLNK(2,1,INBULG)=J
      BLGLNK(3,1,INBULG)=J+K
      BLGLNK(1,2,INBULG)=2
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
      IF 
     +(HBLIST(I-1,J+1).EQ.1.AND.HBLIST(J-1,I+1+K).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=J
      BLGLNK(2,1,INBULG)=I
      BLGLNK(3,1,INBULG)=I+K
      BLGLNK(1,2,INBULG)=2
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
* parallel bulge.
*
*  classic.
*
      IF 
     +(HBLIST(I,J+1+K).EQ.1.AND.HBLIST(J-1,I).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=I
      BLGLNK(2,1,INBULG)=J
      BLGLNK(3,1,INBULG)=J+K
      BLGLNK(1,2,INBULG)=3
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
      IF 
     +(HBLIST(J,I+1+K).EQ.1.AND.HBLIST(I-1,J).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=J
      BLGLNK(2,1,INBULG)=I
      BLGLNK(3,1,INBULG)=I+K
      BLGLNK(1,2,INBULG)=3
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
201   CONTINUE
*
      ENDIF
*
* error trap.
*
      IF (IJI.LT.2) GOTO 101
*
* Anti-Parallel bridge.
*
      IF 
     +(HBLIST(I,J).EQ.1.AND.HBLIST(J,I).EQ.1) THEN
*
      PARLST(1,J)=I
      PARLST(1,I)=J
      TYLST(1,J)=8
      TYLST(1,I)=8
      SSSHT(I)=8
      SSSHT(J)=8
*
      GOTO 101
      ENDIF
*
* error trap.
*
      IF (IJI.LT.3) GOTO 101
*
* Outer type beta-bridge.
*
      IF 
     +(HBLIST(I-1,J+1).EQ.1.AND.HBLIST(J-1,I+1).EQ.1) THEN
*
      PARLST(2,I)=J
      PARLST(2,J)=I
      TYLST(2,J)=8
      TYLST(2,I)=8
      SSSHT(I)=8
      SSSHT(J)=8
*
      GOTO 101
      ENDIF
*
* Parallel bridges.
*
      IF 
     +(HBLIST(I-1,J).EQ.1.AND.HBLIST(J,I+1).EQ.1) THEN
*
      PARLST(1,J)=I
      PARLST(2,I)=J
      TYLST(1,J)=9
      TYLST(2,I)=9
      SSSHT(I)=9
      SSSHT(J)=9
*
      GOTO 101
      ENDIF
*
      IF 
     +(HBLIST(J-1,I).EQ.1.AND.HBLIST(I,J+1).EQ.1) THEN
*
      PARLST(1,I)=J
      PARLST(2,J)=I
      TYLST(1,I)=9
      TYLST(2,J)=9
      SSSHT(I)=9
      SSSHT(J)=9
*
      GOTO 101
      ENDIF
*
101   CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* do hydrogen bonding calculation.
*
*   find donors and acceptors.
*   create separate file for each sort of interaction.
*
      SUBROUTINE 
     +HBCALC(II,NMAINN,NMAINO,IMAINN,IMAINO,HBLIST)
*
* declarations.
*
      INTEGER J,NHB,IDEC,II
      INTEGER NMAINN,NMAINO,IMAINN(5000),IMAINO(5000),E1,NP,OP
      INTEGER HBLIST(1000,1000)
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      DMNHBS=DMAXHB*DMAXHB
*
* announce subroutine.
*
      WRITE(*,1000) DMINHB,DMAXHB,
     +              ANGMIN,ANGMAX,ANGMIN1,ANGMAX1
*
* find main chain bonding atoms.
*
      NMAINN=0
      NMAINO=0
*
      DO 1 J=RN1(II),RN2(II)
*
*      IF (POS(0,J,I).LT.1) GOTO 1
*      IF (POS(-1,J,I).LT.4) GOTO 1
*
      E1=POS(1,J,II)
      IF (E1.GT.0) THEN
      NMAINN=NMAINN+1
      IMAINN(NMAINN)=E1
      ELSE
      NMAINN=NMAINN+1
      IMAINN(NMAINN)=0
      ENDIF
*
      E1=POS(3,J,II)
      IF (E1.GT.0) THEN
      NMAINO=NMAINO+1
      IMAINO(NMAINO)=E1
      ELSE
      NMAINO=NMAINO+1
      IMAINO(NMAINO)=0
      ENDIF
1     CONTINUE
*
* write out summary of donors and acceptors found.
*
      IF (NMAINN.LT.1) THEN
      WRITE(*,1033) 
      STOP'FOLD has been terminated by Error Status.'
      ELSEIF (NMAINO.LT.1) THEN
      WRITE(*,1034)
      STOP'FOLD has been terminated by Error Status.'
      ELSE
      WRITE(*,1002) NMAINO,NMAINN
      ENDIF
*
* Now find main chain - main chain hydrogen bonds.
*
      NHB=0
*
      DO 11 IDONOR=1,NMAINN
*
      NP=IMAINN(IDONOR)
*
      IF (NP.GT.0) THEN
*
      DO 12 IACCOR=1,NMAINO
*
      OP=IMAINO(IACCOR)
*
      HBLIST(IACCOR,IDONOR)=0
*
      IF (OP.GT.0) THEN
*
* check not same residue.
*
      IF (RN(NP).EQ.RN(OP)) THEN
      IF (RLAB(NP).EQ.RLAB(OP)) GOTO 22
      ENDIF
*
* use distance to screen out non-hits.
*
      CALL GETDIS(IDEC,NP,OP,DD,DMAXHB,DMNHBS)
*
* check if good angles. calculate geometry.
*
      IF (IDEC.EQ.1) THEN 
*
* Check geometry of interaction.
*
      CALL 
     +ANALHB(MIDEC,NP,OP,DD)
*
* Store logical hbond.
*
      IF (MIDEC.EQ.1) THEN
      NHB=NHB+1
      HBLIST(IACCOR,IDONOR)=1
      ENDIF
*
      ENDIF
*
22    CONTINUE
*
      ENDIF
*
12    CONTINUE
*
      ENDIF
*
11    CONTINUE
*
      WRITE(*,1003) NHB
*
* format statements.
*
1000  FORMAT(/' Calculating Hydrogen bonds.'//,
     +'      minimum distance for hydrogen bond:',F8.3,'.'/,
     +'      maximum distance for hydrogen bond:',F8.3,'.'/,
     +'  limits for hydrogen bond angle (N-O-C):',2F8.3/,
     +'  limits for hydrogen bond angle (O-N-C):',2F8.3)
1001  FORMAT(/'  Main Chain - Main Chain Hydrogen Bonds.'//)
1002  FORMAT(/
     +I5,' main chain acceptors found.'/,
     +I5,' main chain donors found.'/)
1003  FORMAT(/' Total number of good main chain hydrogen bonds 
     +found:',I6/)
1010  FORMAT(
     +'      Donor      Acceptor      distance      angle    in-plane  
     +  out-of-plane'/)
1033  FORMAT(/' ERROR: no main chain donors found.')
1034  FORMAT(/' ERROR: no main chain acceptors found.')
3000  FORMAT(36I2)
*
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* form lookup table for standard atom names.
*
*      DATA  ATLOOK /
*     +'N   ','C   ','O   ','CA  ','CB  ',
*     +'CG  ','CD  ','NE  ','CZ  ',
*     +'NH1 ','NH2 ','OD1 ','OD2 ',
*     +'CD1 ','CE1 ','CE2 ','CD2 ',
*     +'SG  ','OE1 ','OE2 ','OH  ',
*     +'OG1 ','CG2 ','CE  ','NZ  ',
*     +'CG1 ','ND2 ','NE2 ','SD  ',
*     +'OG  ','OT  ','OTX ' /
*  
*-------------------------------------------------------------------------------
*
* check hydrogen bonding distance.
*
      SUBROUTINE GETDIS(IDEC,NP,OP,DD,DLIM,DLIMS)
*
* declarations.
*
      INTEGER NP,OP,IDEC
      REAL DD,DLIM,DLIMS
      REAL DX,DY,DZ,DR
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      IDEC=0
      DD=0.0
*
      DX=ABS(X(NP)-X(OP))
      IF (DX.GT.DLIM) RETURN
      DY=ABS(Y(NP)-Y(OP))
      IF (DY.GT.DLIM) RETURN
      DZ=ABS(Z(NP)-Z(OP))
      IF (DZ.GT.DLIM) RETURN
      DR=DX*DX+DY*DY+DZ*DZ
*
* now check.
*
      IF (DR.LE.DLIMS) THEN
      DD=SQRT(DR)
      IDEC=1
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* analyse geometry of hydrogen bond.
*
      SUBROUTINE ANALHB(MDEC,NP,OP,DD1)
*
* declarations.
*
      INTEGER NP,OP,EC,MDEC,K,EC1,K1,L1,EO1,EN,L
      REAL BANG,TANG1,TANG2,DD1
*
      INCLUDE 'FOLD.INC'
*
* reinitialise.
*
      MDEC=0
*
* trap short hbonds.
*
      IF (DD1.LT.DMINHB) THEN
      RETURN
      ENDIF
*
* get pointer to C and N of acceptor.
*
      K=INDEX(CCLIS,RLAB(OP))
      L=RN(OP)
*
* Error trap.
*
      IF (K.GT.0.AND.L.GT.0) THEN
*
* now get atom pointers.
*
      EC=POS(2,L,K)
      EN=POS(1,L+1,K)
*
* Error trap.
*
      IF (EC.GT.0.AND.EN.GT.0) THEN
*
* get bond angle of hydrogen bond.
*
      CALL BANGL(EC,OP,NP,BANG)
*
* is it acceptable.
*
      IF (BANG.LT.ANGMIN.OR.
     +    BANG.GT.ANGMAX) THEN
      ELSE
*
* get pointer to C and N of donor.
*
      K1=INDEX(CCLIS,RLAB(NP))
      L1=RN(NP)
*
* Error trap.
*
      IF (K1.GT.0.AND.L1.GT.0) THEN
*
* Get atom pointers.
*
      EC1=POS(2,L1-1,K1)
      EO1=POS(3,L1-1,K1)
*
* Error trap.
*
      IF (EC1.GT.0.AND.EO1.GT.0) THEN
*
* Calculate this bond angle.
*
      CALL BANGL(EC1,NP,OP,BANG2)
*
* is it acceptable.
*
      IF (BANG2.LT.ANGMIN1.OR.
     +    BANG2.GT.ANGMAX1) THEN
      ELSE
*
* set return flag for bond counter.
*
      MDEC=1
*
* draw vectors to file.
*
      IF (DRWDEC.EQ.1) THEN
      CALL VECPLT(0,X(NP),Y(NP),Z(NP),71)
      CALL VECPLT(1,X(OP),Y(OP),Z(OP),71)
      ENDIF
*
* update 3D hbond list.
*
      IF (NHBOND.LT.15000) THEN
      NHBOND=NHBOND+1
      LSTHBD(1,NHBOND)=NP
      LSTHBD(2,NHBOND)=OP
      ENDIF
*
* Calculate torsion angles N-C-Oac-Nd.
*
      CALL TORANG(EN,EC,OP,NP,TANG1)
*
* Calculate torsion angle N-C-Nd-Oac.
*
      CALL TORANG(EO1,EC1,NP,OP,TANG2)
*
* Calculate peptide-peptide dihedral angle.
*
      CALL TORANG(EC,OP,NP,EC1,TANG3)
*
* Write information.
*
      WRITE(25,1500) RNAM(NP),RN(NP),RLAB(NP),
     +RNAM(OP),RN(OP),RLAB(OP),
     +DD1,BANG,BANG2,TANG3
*
* projection geometry.
*
      WRITE(25,2000) 
     +DANGL(1,L,K),DANGL(2,L,K),ASYMB(L,K),
     +DD1,BANG,TANG1
*
      WRITE(25,2001) 
     +DANGL(1,L1,K1),DANGL(2,L1,K1),ASYMB(L1,K1),
     +DD1,BANG2,TANG2
*
      ENDIF
      ENDIF
*
      ENDIF
      ENDIF
*
      ENDIF
      ENDIF
*
* format statements.
*
1000  FORMAT(1X,2(A4,A3,I4,A1,1X),4(F10.3,1X))
1001  FORMAT(1X,2(A4,A3,I4,A1,1X),2(F10.3,1X),2(5X,'-',5X))
1002  FORMAT(1X,2(A4,A3,I4,A1,1X),F10.3,1X,3(5X,'-',5X))
*
1500  FORMAT(1X,A3,I4,A1,' - ',1X,A3,I4,A1,
     +' C O N C:',F5.2,3F9.3)
2000  FORMAT(2X,2F8.2,1X,A2,'   N O C N:',3F9.3)
2001  FORMAT(2X,2F8.2,1X,A2,'   O N C O:',3F9.3)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get angle of Hydrogen bond.
*
      SUBROUTINE BANGL(EC,OP,NP,BANG)
*
* Declarations.
*
      INTEGER EC,OP,NP
      REAL BANG
*
      REAL X1(3),X2(3)
      REAL DD1,DD2,DX1,DX2,DY1,DY2,DZ1,DZ2
      REAL CONV
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      CONV=180.0/3.14159
*
* get vectors.
*
      X1(1)=X(NP)-X(OP)
      X1(2)=Y(NP)-Y(OP)
      X1(3)=Z(NP)-Z(OP)
      X2(1)=X(EC)-X(OP)
      X2(2)=Y(EC)-Y(OP)
      X2(3)=Z(EC)-Z(OP)
*
* Get angle.
*
      DX1=X1(1)**2
      DY1=X1(2)**2
      DZ1=X1(3)**2
*
      DX2=X2(1)**2
      DY2=X2(2)**2
      DZ2=X2(3)**2
*
      DD1=SQRT(DX1+DY1+DZ1)
      DD2=SQRT(DX2+DY2+DZ2)
*
      TAU=(
     +X1(1)*X2(1)+
     +X1(2)*X2(2)+
     +X1(3)*X2(3))
*
      DAU=(DD1*DD2)
*
      IF (ABS(DAU).LT.0.00001) THEN
      BANG=0.0
      RETURN
      ENDIF
*
      TAU=TAU/DAU
      BANG=ACOS(TAU)*CONV
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Check the 3x3 matrix for orthogonality.
*
      SUBROUTINE CHKMAT(R,DET)
*
* declarations.
*
      REAL R(3,3),DET
*
* Determinant.
*
      DET=
     $   R(1,1)*R(2,2)*R(3,3)
     $ + R(1,2)*R(2,3)*R(3,1)
     $ + R(1,3)*R(2,1)*R(3,2)
     $ - R(1,3)*R(2,2)*R(3,1)
     $ - R(1,2)*R(2,1)*R(3,3)
     $ - R(1,1)*R(2,3)*R(3,2)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* write drawing command to VECTOR file.
*
      SUBROUTINE VECPLT(IFLAG,X,Y,Z,IIO)
*
* declarations.
*
      INTEGER IFLAG,ICOL,IIO
      REAL X,Y,Z,XDUMMY,YDUMMY,FDUMMY
*
* initialise.
*
      XDUMMY=0.
      YDUMMY=0.
      FDUMMY=0.
      ICOL=0
*
* MOVE if iflag=0.
* DRAW if iflag=1.
*
      WRITE(IIO) IFLAG,ICOL,XDUMMY,YDUMMY,FDUMMY,X,Y,Z
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Find all disulphides.
*
      SUBROUTINE SSBOND
*
* Declarations.
*
      INTEGER IE,E1,E2,IPSS(1000),NSP,ISS1(500),ISS2(500),IDEC,NSS
*
      INCLUDE 'FOLD.INC'
*
* Announce subroutine.
*
      WRITE(*,1000)
*
* work through chains.
*
      NSS=0
      DO 1 I=1,CHL
      DO 1 J=RN1(I),RN2(I)     
*
* get pointers and atom names.
*
      IE=POS(6,J,I)
*
      IF (ATNAM(IE).EQ.'SG  ') THEN
      NSS=NSS+1
      IPSS(NSS)=IE
      ENDIF
*
1     CONTINUE
*
* Error trap no cysteines.
*
      IF (NSS.GT.0) THEN
*
* report cysteines found.
*
      WRITE(*,1001) NSS
*
* check good disulphide bond distance.
*
      NSP=0
*
* work through all cysteines.
*
      DO 2 I=1,NSS
      DO 2 J=(I+1),NSS
*
* get pointers.
*
      E1=IPSS(I)
      E2=IPSS(J)
*
* get distance.
*
      IDEC=0
      CALL GETDIS(IDEC,E1,E2,DD,3.5,3.5*3.5)
*
* check it.
*
      IF (IDEC.EQ.1) THEN
*
* save pair.
*
      NSP=NSP+1
      ISS1(NSP)=E1
      ISS2(NSP)=E2
*
* get information.
*
      CALL CLCSSB(E1,E2,NSP,DD)
*
      ENDIF
*
2     CONTINUE
*
      ENDIF
*
* write summary. delete file if empty.
*
      IF (NSP.GT.0) THEN
      WRITE(*,7005) NSP
      WRITE(46,7005) NSP
      ELSE
      CLOSE(UNIT=46,DISPOSE='DELETE')
      ENDIF
*
* format statements.
*
1000  FORMAT(/' Calculating Disulphide bond parameters.') 
1001  FORMAT(/' Number of free sulphurs:',I5,'.'/)
1100  FORMAT(/' Chain: ',I2,' label: ',A1,'.')
7000  FORMAT(/1X,A3,1X,I3/)
7001  FORMAT(/' Bond Lengths.'/)
7004  FORMAT(/)
7005  FORMAT(' Total number of disulphides found:',I6,'.'/)
7101  FORMAT(2(1X,A3),2X,F9.4)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Calculate SS-bond characteristics.
*
      SUBROUTINE CLCSSB(E1,E2,IDISUL,DSS)
*
* Declarations.
*
      INTEGER E1,E2,C1,CA1,N1,R1,R2,C2,CA2,N2,IDISUL
      REAL DSS
*
      INCLUDE 'FOLD.INC'
*
* get pointers to other atoms. CB,CA, AND N.
*
      R1=RN(E1)
      L1=INDEX(CCLIS,RLAB(E1))
      C1=POS(5,R1,L1)    
      CA1=POS(4,R1,L1)    
      N1=POS(1,R1,L1)
*
      R2=RN(E2)
      L2=INDEX(CCLIS,RLAB(E2))
      CA2=POS(4,R2,L2)    
      C2=POS(5,R2,L2)
      N2=POS(1,R2,L2)
*
* Save disulphide connection pointer.
*
      ISSBND(R1,L1)=IDISUL
      ISSBND(R2,L2)=IDISUL
*
* get CA-CA distance.
*
      CALL GETDIS(IDEC,CA1,CA2,DCA,50.0,2500.)
*
* get the bond angles.
*
      CALL BNDANG(E2,E1,C1,B1)
      CALL BNDANG(E1,E2,C2,B2)
*
* get the torsion angles. Di-SS, CHI1 and CHI2 for both.
*
      CALL TORANG(C1,E1,E2,C2,TT)
*
* chi1
*
      CALL TORANG(N1,CA1,C1,E1,TC1)
      CALL TORANG(N2,CA2,C2,E2,TC2)
*
* chi2
*
      CALL TORANG(CA1,C1,E1,E2,TB1)
      CALL TORANG(CA2,C2,E2,E1,TB2)
*
* now write result.
*
      WRITE(46,1000) IDISUL,
     +RNAM(E1),R1,RLAB(E1),
     +RNAM(E2),R2,RLAB(E2),
     +DSS,B1,B2,TT,
     +RNAM(E1),R1,RLAB(E1),TC1,
     +RNAM(E2),R2,RLAB(E2),TC2,
     +RNAM(E1),R1,RLAB(E1),TB1,
     +RNAM(E2),R2,RLAB(E2),TB2,
     +DCA
*
* format statements.
*
1000  FORMAT(' Disulphide number:',I4,'.'/,
     +1X,A3,I4,A1,' - ',A3,I4,A1/,
     +'            S - S distance:',F10.4/,
     +'       CB-SG-SG bond angle:',F10.4/,
     +'       SG-SG-CB bond angle:',F10.4/,
     +' CB-SG-SG-CB torsion angle:',F10.4/,
     +'           CHI1 - ',A3,I4,A1,':',F10.4/,
     +'           CHI1 - ',A3,I4,A1,':',F10.4/,
     +'           CHI2 - ',A3,I4,A1,':',F10.4/,
     +'           CHI2 - ',A3,I4,A1,':',F10.4/,
     +'            CA-CA distance:',F10.4/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* measure bond angle.
*
      SUBROUTINE BNDANG(E1,E2,E3,TANG)
*
* declarations.
*
      INTEGER E1,E2,E3
      REAL DD1,DD2,DX1,DX2,DY1,DY2,DZ1,DZ2,CONV,TANG
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      CONV=180.0/3.14159
*
* calculate.
*
      DD1=SQRT((X(E1)-X(E2))**2 + 
     + (Y(E1)-Y(E2))**2 + 
     + (Z(E1)-Z(E2))**2)
*
      DD2=SQRT((X(E3)-X(E2))**2 + 
     + (Y(E3)-Y(E2))**2 + 
     + (Z(E3)-Z(E2))**2)
*
      DX1=X(E1)-X(E2)
      DY1=Y(E1)-Y(E2)
      DZ1=Z(E1)-Z(E2)
*
      DX2=X(E3)-X(E2)
      DY2=Y(E3)-Y(E2)
      DZ2=Z(E3)-Z(E2)
*
      TAU=(
     $DX1*DX2+ 
     $DY1*DY2+ 
     $DZ1*DZ2)
*
      DAU=(DD1*DD2)
*
      IF (ABS(DAU).LT.0.00001) THEN
      TAU=0.0
      ELSE
      TAU=TAU/DAU
      ENDIF
      TANG=ACOS(TAU)*CONV
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* calculate torsion angles.
*
      SUBROUTINE DIHED
*
* declarations.
*
      INTEGER I,J,K,NT
      REAL TORS(10),TANG,TANG1,TANG2
      CHARACTER SYMBOL*2
*
      INCLUDE 'FOLD.INC'
*
* announce subroutine.
*
      WRITE(*,1000)
*
* Initialise.
*
      DO 500 I=1,10
      DO 500 J=1,1000
      DO 500 K=1,10
      DANGL(K,J,I)=0.0
500   CONTINUE
*
* work through chains.
*
      DO 1 I=1,CHL
      DO 1 J=RN1(I),RN2(I)
*
* get phi:
*
      CALL APHI(J,I,TANG1)
      DANGL(1,J,I)=TANG1
*
* get psi:
*
      CALL APSI(J,I,TANG2)
      DANGL(2,J,I)=TANG2
*
* get Omega:
*
      CALL AOMG(J,I,TANG)
      DANGL(3,J,I)=TANG
*
* Get and store Ramachandran region.
*
      CALL REGAS(TANG1,TANG2,SYMBOL)
      ASYMB(J,I)=SYMBOL
*
* get all side chain torsions.
*
      CALL GETANG(J,I,NT,TORS)
*
* store them.
*
      IF (NT.GT.0) THEN
      DO 2 I1=1,NT
      DANGL(3+I1,J,I)=TORS(I1)
2     CONTINUE
      IANGL(J,I)=NT+3
      ELSE
      IANGL(J,I)=3
      ENDIF
*
1     CONTINUE
*
* format statements.
*
1000  FORMAT(/' Calculating main chain torsion angles.'/)
*
      RETURN
      END
*  
*-------------------------------------------------------------------------------
*
      SUBROUTINE GETANG(IRES,ICHL,IL,TORS)
*
* Declarations.
*
      INTEGER GETTOR,IL,IRES,ICHL
      INTEGER E1,E2,E3,E4,Q1,Q2,Q3,Q4
      REAL TORS(10)
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      IL=0
*
* work through all torsions.
*
      DO 1 K=4,NTOR
*
* check torsion.
*
      IDEC=GETTOR(K,IRES,ICHL,E1,E2,E3,E4,Q1,Q2,Q3,Q4)
*
* check that this torsion has been found.
*
      IF (IDEC.EQ.1) THEN
*
* increment counter of found torsions.
*
      IL=IL+1
*
* calculate present torsion angle.
*
      CALL TORANG(E1,E2,E3,E4,TANG)
*
* store it.
*
      TORS(IL)=TANG
*     
      ENDIF
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* do angle calculation.
*
      SUBROUTINE APSI(JJ,II,TANG)
*
* declarations.
*
      INTEGER E1,E2,E3,E4,JJ,II
      REAL TANG
*
      INCLUDE 'FOLD.INC'
*
* get pointers.
*
      E1=POS(1,JJ,II)
      E2=POS(4,JJ,II)
      E3=POS(2,JJ,II)
      E4=POS(1,JJ+1,II)
*
* call torsion angle.
*
      CALL TORANG(E1,E2,E3,E4,TANG)
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* do main angle calculation.
*
      SUBROUTINE APHI(JJ,II,TANG)
*
* declarations.
*
      INTEGER JJ,II,E1,E2,E3,E4
      REAL TANG
*
      INCLUDE 'FOLD.INC'
*
* get pointers.
*
      E1=POS(2,JJ-1,II)
      E2=POS(1,JJ,II)
      E3=POS(4,JJ,II)
      E4=POS(2,JJ,II)
*
* call torsion angle.
*
      CALL TORANG(E1,E2,E3,E4,TANG)
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* do main angle calculation.
*
      SUBROUTINE AOMG(JJ,II,TANG)
*
* declarations.
*
      INTEGER II,JJ,E1,E2,E3,E4
*
      REAL TANG
*
      INCLUDE 'FOLD.INC'
*
* get pointers.
*
      E1=POS(4,JJ-1,II)
      E2=POS(2,JJ-1,II)
      E3=POS(1,JJ,II)
      E4=POS(4,JJ,II)
*
* call torsion angle.
*
      CALL TORANG(E1,E2,E3,E4,TANG)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Measure torsion angle.
*
      SUBROUTINE TORANG(E1,E2,E3,E4,TANG)
*
* declarations.
*
      INTEGER E1,E2,E3,E4,I,J
      REAL    TANG,T,S,CONV,WMAG
      REAL    XX(3,4),Q(3,3),U(3),V(3),W(3),A(3),B(3)
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      CONV=180.0/3.14159
      TANG=0.0
*
* error trap:
*
      IF (E1.LT.1) RETURN
      IF (E2.LT.1) RETURN
      IF (E3.LT.1) RETURN
      IF (E4.LT.1) RETURN
*
* form triad of interatomic vectors.
*
      XX(1,1)=X(E1)
      XX(1,2)=X(E2)
      XX(1,3)=X(E3)
      XX(1,4)=X(E4)
      XX(2,1)=Y(E1)
      XX(2,2)=Y(E2)
      XX(2,3)=Y(E3)
      XX(2,4)=Y(E4)
      XX(3,1)=Z(E1)
      XX(3,2)=Z(E2)
      XX(3,3)=Z(E3)
      XX(3,4)=Z(E4)
*
      DO 10 I=1,3
      U(I)=XX(I,1)-XX(I,2)
      V(I)=XX(I,4)-XX(I,3)
      W(I)=XX(I,3)-XX(I,2)
10    CONTINUE
*
* Find a = u.cross.w.
*
      A(1)=U(2)*W(3)-U(3)*W(2)
      A(2)=U(3)*W(1)-U(1)*W(3)
      A(3)=U(1)*W(2)-U(2)*W(1)
*
* find b = v.cross.w.
*
      B(1)=V(2)*W(3)-V(3)*W(2)
      B(2)=V(3)*W(1)-V(1)*W(3)
      B(3)=V(1)*W(2)-V(2)*W(1)
*
* find ^w^.
*
      WMAG=SQRT(W(1)**2+W(2)**2+W(3)**2)
*
*' (A.CROSS.B).DOT.W = ^A^*^B^*^W^*SIN(ANGLE).
*
      DO 20 J=1,3
      Q(1,J)=A(J)
      Q(2,J)=B(J)
      Q(3,J)=W(J)
20    CONTINUE
*
* Get determinant.
*
      CALL CHKMAT(Q,S)
*
*' (A.DOT.B)*^W^ = ^A^*^B^*^W^*COS(ANGLE).
*
      T=(A(1)*B(1)+A(2)*B(2)+A(3)*B(3))*WMAG
*
* torsion angle result in degrees.
*
      IF (ABS(S).LT.0.0001) THEN
      TANG=0.0
      ELSE
      TANG=ATAN2(S,T)*CONV
      ENDIF
* 
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get torsion angle names.
*
      INTEGER FUNCTION GETTOR(ITOR,IRES,ICHL,
     +I1,I2,I3,I4,Q1,Q2,Q3,Q4)
*
* Declarations.
*
      INTEGER Q(4),IH(4)
      INTEGER I1,I2,I3,I4,Q1,Q2,Q3,Q4
      CHARACTER TN(4)*4
*
      INCLUDE 'FOLD.INC'
*
* reset decision variable.
*
      GETTOR=0
      ILAST=1
*
* get size of residue.
*
      II=POS(-1,IRES,ICHL)
*
* Error trap no atoms.
*
      IF (II.GT.0) THEN
*
* get pointers
*
      TN(1)=TNAM1(ITOR)
      TN(2)=TNAM2(ITOR)
      TN(3)=TNAM3(ITOR)
      TN(4)=TNAM4(ITOR)
*
* work through all torsions.
*
      DO 3 K=1,4
*
* work through remaining atoms.
*
      DO 2 I=ILAST,II
*
* get atom pointer.
*
      IP1=POS(I,IRES,ICHL)
*
* comapre atom names.
*
      IF (IP1.GT.0) THEN
      IF (ATNAM(IP1).EQ.TN(K)) THEN
      ILAST=I+1
      Q(K)=I
      IH(K)=IP1
      GOTO 3
      ENDIF
      ENDIF
*
2     CONTINUE
*
* Error.
*
      RETURN
*
3     CONTINUE
*
* copy back pointers.
*
      I1=IH(1)
      I2=IH(2)
      I3=IH(3)
      I4=IH(4)
*
      Q1=Q(1)
      Q2=Q(2)
      Q3=Q(3)
      Q4=Q(4)
*
* flag successful torsion discovery.
*
      GETTOR=1
*
      ENDIF
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* assign residues to secondary structure types.
*
      SUBROUTINE SSANAL
*
* declarations.
*
      INTEGER I,II,JJ
*
      INCLUDE 'FOLD.INC'
*
* report definition criteria.
*
      IF (IUPDEC.EQ.0) THEN
      WRITE(*,1001)
      ELSE
      IF (IUPSHT.GT.0) THEN
      WRITE(*,1003)
      ELSE
      WRITE(*,1002)
      ENDIF
      ENDIF
*
* Assign structure to residues. First Pass.
*
      CALL SSELEM
*
* join strands interupted by explicit beta-bulges.
*
      IF (BLGDEC.EQ.1) THEN
*
* Error trap no bulges.
*
      IF (INBULG.GT.0) THEN
      CALL BULGES
      IF (NOBUL.EQ.0) THEN
      CALL WRBLG
      ENDIF
      ELSE
      CLOSE(UNIT=43,DISPOSE='DELETE')
      ENDIF
*
      ENDIF
*
* now list isolated turns.
*
      IF (TRNDEC.EQ.1) THEN
      CALL TURNS
      ENDIF
*
* having assigned residues to a particular secondary structure type work
* through chains doing higher order analysis.
*
      DO 3 I=1,CHL
*
* get lists.
*
      CALL LISTS(I)
*
* Analysis of sheets of this chain.
*
* initialise
*
      DO 551 II=1,100
      SHMARK(II)=0
      SHTCON(II)=0
      DO 551 JJ=1,100
      SHTLNK(JJ,II)=0
      SHTNUM(JJ,II)=0
      SHLTYP(JJ,II)=0
      SHTYP8(JJ,II)=0
      SHTYP9(JJ,II)=0
551   CONTINUE
*
      DO 96 II=1,20
      SHTRNG(II,I)=0
      SHTLEN(II,I)=0
      SHTTYP(II,I)=0
      SHTMRK(II,I)=0
      DO 94 J=1,100
      SHTORI(J,II,I)=0
      SHTTOP(J,II,I)=0
      SHNCON(J,II,I)=0
94    CONTINUE
      DO 96 J=1,30
      RNGLEN(J,II,I)=0
      DO 96 K=1,50
      RNGLST(K,J,II,I)=0
      SHICON(K,J,II,I)=0
96    CONTINUE
*
      NSHEET(I)=0
*
      IF (NSTRAND(I).GT.0) THEN
      CALL SHTSUB(I)
      ENDIF
*
3     CONTINUE 
*
* trap empty hairpin file.
*
      IF (NPIN.GT.0) THEN
      WRITE(42,1000) NPIN
      ELSE
      CLOSE(UNIT=42,DISPOSE='DELETE')
      ENDIF
*
* format statements.
*
1000  FORMAT(/'   Total number of beta-hairpins:',I5,'.'/)
1001  FORMAT(/'   Using strict definitions for helices and strands.')
1002  FORMAT(/'   Using IUPAC definitions for helices.')
1003  FORMAT(/'   Using IUPAC definitions for helices and strands.')
1010  FORMAT(/'   Applying Ring Perception to Closed Sheets.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* assign residues to secondary structure types.
*
      SUBROUTINE SSELEM
*
* declarations.
*
      INTEGER E1,E2,I,J,J1,MCHL
*
      CHARACTER
     +A1*1,A0*1,A2*1,A3*1,SYM2(1000,10)*1,ABB*1
*
      INCLUDE 'FOLD.INC'
*
* work through all chains.
*
      MCHL=MIN(CHL,10)
*
      DO 1 I=1,MCHL
*
* re-initialise.
*
      DO 550 J=1,1000
      SYM2(J,I)=' '
      STRSYM(J,I)=' '
550   CONTINUE
*
* work through the residues of this chain doing helices.
*
      DO 2 J=RN1(I),RN2(I)
*
* get values of structure type.
*
      E1=HELSTR(J,I)
*
* decide.
*
      IF (E1.EQ.0) THEN
*
* skip if nothing.
*
      GOTO 2
*
* 310-helices.
*
      ELSEIF (E1.EQ.3) THEN
      E0=HELSTR(J+1,I)
      IF (E0.EQ.3) THEN
      DO 501 J1=0,2
      IF (STRSYM(J-J1,I).EQ.' ') STRSYM(J-J1,I)='3'
501   CONTINUE
      ENDIF
      GOTO 2     
*
* Alpha-helices.
*
      ELSEIF (E1.EQ.4) THEN
      E0=HELSTR(J+1,I)
      IF (E0.EQ.4) THEN
      DO 502 J1=0,3
      STRSYM(J-J1,I)='4'
502   CONTINUE
      ENDIF
      GOTO 2     
*
      ENDIF 
*
2     CONTINUE
*
* now do strands.
*
      DO 22 J=RN1(I),RN2(I)
*
* get values of structure type.
*
      ABB=STRSYM(J,I)
*
* error trap.
*
      IF (ABB.NE.' ') GOTO 22
*
      E1=SHTSTR(J,I)
*
* error trap.
*
      IF (E1.EQ.0) THEN
      GOTO 22
*
*  anti-parallel beta-strands.
*
      ELSEIF (E1.EQ.8) THEN
*
* get flanking stuff.
*
      E0=SHTSTR(J-1,I)
      E2=SHTSTR(J+1,I)
      A0=STRSYM(J-1,I)
      A2=STRSYM(J+1,I)
*
* anti-parallel strands.
*
      IF (E0.EQ.8) THEN
*
      IF (A0.EQ.'4'.OR.A0.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='A'
      GOTO 22
      ENDIF
*
      ELSEIF (E2.EQ.8) THEN 
*
      IF (A2.EQ.'4'.OR.A2.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='A'
      GOTO 22
      ENDIF
*
* parallel strands.
*
      ELSEIF (E0.EQ.9) THEN
*
      IF (A0.EQ.'4'.OR.A0.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='A'
      GOTO 22
      ENDIF
*
      ELSEIF (E2.EQ.9) THEN
*
      IF (A2.EQ.'4'.OR.A2.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='A'
      GOTO 22
      ENDIF
*
      ELSE
*
* isolated bridge.
*
*      STRSYM(J,I)='a'
*
      GOTO 22
      ENDIF
*
      GOTO 22
*
* parallel beta-strands.
*
      ELSEIF (E1.EQ.9) THEN
*
* get stuff for flanking residues.
*
      E0=SHTSTR(J-1,I)
      E2=SHTSTR(J+1,I)
      A0=STRSYM(J-1,I)
      A2=STRSYM(J+1,I)
*
* parallel strands.
*
      IF (E0.EQ.9) THEN
*
      IF (A0.EQ.'4'.OR.A0.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='P'
      GOTO 22
      ENDIF
*
      ELSEIF (E2.EQ.9) THEN
*
      IF (A2.EQ.'4'.OR.A2.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='P'
      GOTO 22
      ENDIF
*
* anti-parallel strands.
*
      ELSEIF (E0.EQ.8) THEN
*
      IF (A0.EQ.'4'.OR.A0.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='P'
      GOTO 22
      ENDIF
*
      ELSEIF (E2.EQ.8) THEN
*
      IF (A2.EQ.'4'.OR.A2.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='P'
      GOTO 22
      ENDIF
*
      ELSE
*
* isolated bridge.
*
*      STRSYM(J,I)='p'
*
      GOTO 22
      ENDIF
*
      ENDIF
*
22    CONTINUE      
*
* non-strict assignments. 
*
      IF (IUPDEC.EQ.1) THEN
*
* work through residues doing helices.
*
      DO 50 J=RN1(I),RN2(I)
*
* get values of structure type.
*
      A1=STRSYM(J,I)
*
* decide.
*
      IF (A1.NE.' ') THEN 
*
      A2=STRSYM(J-1,I)
      A3=STRSYM(J+1,I)
*
* extend minus.
*
      IF (A2.EQ.' '.AND.SYM2(J-1,I).EQ.' ') THEN 
*
* helices.
*
      IF (A1.EQ.'4') THEN
      SYM2(J-1,I)='4'
      ELSEIF (A1.EQ.'3') THEN
      SYM2(J-1,I)='3'
      ENDIF
*
      ENDIF
*
* extend Plus.
*
      IF (A3.EQ.' '.AND.SYM2(J+1,I).EQ.' ') THEN 
*
* helices.
*
      IF (A1.EQ.'4') THEN
      SYM2(J+1,I)='4'
      ELSEIF (A1.EQ.'3') THEN
      SYM2(J+1,I)='3'
      ENDIF
*
      ENDIF
*
      ENDIF
*
50    CONTINUE
*
* now do strands.
*
      DO 51 J=RN1(I),RN2(I)
*
* get values of structure type.
*
      A1=STRSYM(J,I)
*
* decide.
*
      IF (A1.NE.' ') THEN 
*
      A2=STRSYM(J-1,I)
      A3=STRSYM(J+1,I)
*
* extend minus.
*
      IF (A2.EQ.' '.AND.SYM2(J-1,I).EQ.' ') THEN 
*
* strands.
*
      IF (A1.EQ.'P') THEN
      SYM2(J-1,I)='Q'
      ELSEIF (A1.EQ.'A') THEN
*
* flexible definitions of strand ends.
*
      IF (IUPSHT.EQ.1) THEN
      SYM2(J-1,I)='B'
      ELSEIF (IUPSHT.EQ.2) THEN
      E1=BBPART(1,J,I)
      IF (E1.GT.0) SYM2(J-1,I)='B'
      ENDIF
*
      ENDIF
      ENDIF
*
* extend Plus.
*
      IF (A3.EQ.' '.AND.SYM2(J+1,I).EQ.' ') THEN 
*
* Strands.
*
      IF (A1.EQ.'P') THEN
      SYM2(J+1,I)='Q'
      ELSEIF (A1.EQ.'A') THEN
*
* flexible definitions of strand ends.
*
      IF (IUPSHT.EQ.1) THEN
      SYM2(J+1,I)='B'
      ELSEIF (IUPSHT.EQ.2) THEN
      E1=BBPART(1,J,I)
      IF (E1.GT.0) SYM2(J+1,I)='B'
      ENDIF
*
      ENDIF
*
      ENDIF
      ENDIF
*
51    CONTINUE
*
* Copy sub array into global one.
* Check that beta-hairpins etc are not closed.
*
      DO 507 J=RN1(I),RN2(I)
*
* check sub array entry.
*
      IF (SYM2(J,I).NE.' ') THEN
      IF (STRSYM(J,I).EQ.' ') THEN
*
* get putative definitions.
*
      A1=SYM2(J,I)
      A2=SYM2(J-1,I)
      A3=SYM2(J+1,I)
*
* check strands.
*
      IF (A1.EQ.'B') THEN
      IF (A2.EQ.'B'.OR.A3.EQ.'B'.OR.A2.EQ.'Q'.OR.A3.EQ.'Q') THEN
      STRSYM(J,I)=' '
      ELSE
      STRSYM(J,I)='A'
      ENDIF
      ENDIF
*
      IF (A1.EQ.'Q') THEN
      IF (A2.EQ.'Q'.OR.A3.EQ.'Q'.OR.A2.EQ.'B'.OR.A3.EQ.'B') THEN
      STRSYM(J,I)=' '
      ELSE
      STRSYM(J,I)='P'
      ENDIF
      ENDIF
*
* now check for helices.
*
      IF (A1.EQ.'4') THEN
      STRSYM(J,I)='4'
      ELSEIF (A1.EQ.'3') THEN
      STRSYM(J,I)='3'
      ENDIF
*
      ENDIF
      ENDIF
*
507   CONTINUE
*
      ENDIF
*
* Check isolated bridges.
*
      DO 508 J=RN1(I),RN2(I)
*
* parallel
*
      IF (STRSYM(J,I).EQ.'p') THEN
      IF (STRSYM(J+1,I).EQ.'P'.OR.STRSYM(J-1,I).EQ.'P') 
     +STRSYM(J,I)='P'
      ENDIF
*
* antiparallel
*
      IF (STRSYM(J,I).EQ.'a') THEN
      IF (STRSYM(J-1,I).EQ.'A'.OR.STRSYM(J+1,I).EQ.'A') 
     +STRSYM(J,I)='A'
      ENDIF
*
508   CONTINUE
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get lists of secondary structure elements.
*
      SUBROUTINE LISTS(I)
*
* declarations.
*
      INTEGER I
*
      CHARACTER ANOW*1,ALAST*1
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      ALAST=' '
      CALL INITEL(I)
*
* work through this chain.
*
      DO 1 II=RN1(I),RN2(I)+1
*
* simplify and error trap for last residue in this chain.
*
      IF (II.GT.RN2(I)) THEN
      ANOW=' '
      ELSE
      ANOW=STRSYM(II,I)
      IF (ANOW.EQ.'A'.OR.ANOW.EQ.'P') ANOW='E'
      ENDIF
*
* sheets.
*
      IF (ANOW.EQ.'E') THEN 
      IF (ALAST.NE.'E') THEN 
      NELEM(I)=NELEM(I)+1
      ELEM(NELEM(I),I)=1
      NSTRAND(I)=NSTRAND(I)+1
      STRAND1(NSTRAND(I),I)=II
*
      IF (ALAST.EQ.' ') LOOP2(NLOOP(I),I)=II-1
      IF (ALAST.EQ.'3') HEL3N2(NHEL3(I),I)=II-1
      IF (ALAST.EQ.'4') HEL4N2(NHEL4(I),I)=II-1
*
      ENDIF
      ENDIF
*
* error trap for single bridges interrupting helices.
*
      IF (ANOW.EQ.'a'.OR.ANOW.EQ.'p') THEN 
      IF (ALAST.EQ.'3') HEL3N2(NHEL3(I),I)=II-1
      IF (ALAST.EQ.'4') HEL4N2(NHEL4(I),I)=II-1
      ENDIF
*
* mark strands.
*
      IF (ANOW.EQ.'E') THEN
      SSLINK(II,I)=NSTRAND(I)
      ENDIF
*
* 3-helix.
*
      IF (ANOW.EQ.'3') THEN
      IF (ALAST.NE.'3') THEN 
      NELEM(I)=NELEM(I)+1
      ELEM(NELEM(I),I)=2
      NHEL3(I)=NHEL3(I)+1
      HEL3N1(NHEL3(I),I)=II
*
      IF (ALAST.EQ.' ') LOOP2(NLOOP(I),I)=II-1
      IF (ALAST.EQ.'E') STRAND2(NSTRAND(I),I)=II-1
      IF (ALAST.EQ.'4') HEL4N2(NHEL4(I),I)=II-1
*
      ENDIF
      ENDIF
*
* 4-helix
*
      IF (ANOW.EQ.'4') THEN
      IF (ALAST.NE.'4') THEN 
      NELEM(I)=NELEM(I)+1
      ELEM(NELEM(I),I)=2
      NHEL4(I)=NHEL4(I)+1
      HEL4N1(NHEL4(I),I)=II
      IF (ALAST.EQ.' ') LOOP2(NLOOP(I),I)=II-1
      IF (ALAST.EQ.'E') STRAND2(NSTRAND(I),I)=II-1
      IF (ALAST.EQ.'3') HEL3N2(NHEL3(I),I)=II-1
      ENDIF
      ENDIF
*
* loops.
*
      IF (ANOW.EQ.' ') THEN
      IF (ALAST.NE.' ') THEN
      NLOOP(I)=NLOOP(I)+1
      LOOP1(NLOOP(I),I)=II
      IF (ALAST.EQ.'E') STRAND2(NSTRAND(I),I)=II-1
      IF (ALAST.EQ.'3') HEL3N2(NHEL3(I),I)=II-1
      IF (ALAST.EQ.'4') HEL4N2(NHEL4(I),I)=II-1
      ENDIF
      ENDIF
*
* store structure type.
*
      ALAST=ANOW
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Initialise lists.
*
      SUBROUTINE INITEL(ICHAIN)
*
* declarations.
*
      INTEGER I,ICHAIN
*
      INCLUDE 'FOLD.INC'
*
* counters.
*
      NELEM(ICHAIN)=0
      NLOOP(ICHAIN)=0
      NSTRAND(ICHAIN)=0
      NHEL3(ICHAIN)=0
      NHEL4(ICHAIN)=0
*
* Ranges.
*
      DO 1 I=1,100
      LOOP1(I,ICHAIN)=0
      LOOP2(I,ICHAIN)=0
      STRAND1(I,ICHAIN)=0
      STRAND2(I,ICHAIN)=0
      HEL3N1(I,ICHAIN)=0
      HEL3N2(I,ICHAIN)=0
      HEL4N1(I,ICHAIN)=0
      HEL4N2(I,ICHAIN)=0
1     CONTINUE
*
      DO 2 I=1,1000
      ELEM(I,ICHAIN)=0
      SSLINK(I,ICHAIN)=0
2     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* close bulges in strands.
*
      SUBROUTINE BULGES
*
* declarations.
*
      INTEGER I,J,K,E1,E2,E3,J1,J2,J3,I1,I2,I3,II
      CHARACTER A1*1
*
      INCLUDE 'FOLD.INC'
*
* work through chains linking bulge interrupted chains.
*
      DO 9 I=1,CHL
*
* get lists.
*
      CALL LISTS(I)
*
* work through bulges.
*
      DO 91 J=1,INBULG
*
* get pointers.
*
      E1=BLGLNK(1,1,J)
      E2=BLGLNK(2,1,J)
      E3=BLGLNK(3,1,J)
*
* error trap.
*
      IF (E1.GT.0.AND.E2.GT.0.AND.E3.GT.0) THEN 
*
* get pointers.
*
      I1=INDEX(CCLIS,RLAB(E1))
      I2=INDEX(CCLIS,RLAB(E2))
      I3=INDEX(CCLIS,RLAB(E3))
*
* error trap.
*
      IF (I1.GT.0.AND.I2.GT.0.AND.I3.GT.0) THEN
*
      IF (I1.EQ.I.AND.I2.EQ.I.AND.I3.EQ.I) THEN
*
* get pointers.
*
      J1=RN(E1)
      J2=RN(E2)
      J3=RN(E3)
*
* error trap.
*
      IF (SSLINK(J1,I).EQ.SSLINK(J2,I).OR.
     +    SSLINK(J1,I).EQ.SSLINK(J3,I).OR.
     +    SSLINK(J1,I).EQ.SSLINK(J2-1,I).OR.
     +    SSLINK(J1,I).EQ.SSLINK(J3+1,I)) THEN
      ELSE
*
* get symbol.
*
      A1=STRSYM(J1,I)
*
* check appropriate type of secondary strcuture.
*
      IF (A1.EQ.'A'.OR.A1.EQ.'P') THEN
*
      IF (STRSYM(J2,I).EQ.'A'.OR.STRSYM(J2,I).EQ.'P'
     +.OR.STRSYM(J2-1,I).EQ.'A'.OR.STRSYM(J2-1,I).EQ.'P') THEN
*
      IF (STRSYM(J3,I).EQ.'A'.OR.STRSYM(J3,I).EQ.'P'
     +.OR.STRSYM(J3+1,I).EQ.'A'.OR.STRSYM(J3+1,I).EQ.'P') THEN
*
* choose fill in type.
*
      K=BLGLNK(1,2,J)
      A1=' '
      IF (K.EQ.1.OR.K.EQ.2) A1='A'
      IF (K.EQ.3) A1='P'
*
* fill bulge.
*
      DO 92 II=J2,J3
      IF (STRSYM(II,I).EQ.' ') STRSYM(II,I)=A1
92    CONTINUE
*
      ENDIF
      ENDIF
      ENDIF
*
      ENDIF
*
      ENDIF
      ENDIF
      ENDIF
*
91    CONTINUE
*
9     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* find and analyse sheets in structure.
*
      SUBROUTINE SHTSUB(I)
*
* declarations.
*
      INTEGER I,J,II,IH,JJ,EE1,E1,E2,E3,E4,N8,N9,N10,IDEC
      INTEGER NLIST(100),ILIST(100,100),IRG
      INTEGER LOCORI(100,100),NCON(1000),ICON(100,1000)
*
      CHARACTER ANOW*1
*
      INCLUDE 'FOLD.INC'
*
* Initialise
*
      DO 95 II=1,NSTRAND(I)
*
      DO 95 J=1,NSTRAND(I)
*
      LOCORI(J,II)=0
*
      SHNCON(J,II,I)=0
*
      ORISHT(J,II,I)=0
      LNKSHT(J,II,I)=0
*
      SHEETS(J,II,I)=0
*
95    CONTINUE
*
* work though strands.
*
* get links.
*
      DO 1 II=1,NSTRAND(I)
      DO 2 J=STRAND1(II,I),STRAND2(II,I)
*
* get indexes.
*
      DO 3 IH=1,2
*
* Get pointers.
*
      EE1=BBPART(IH,J,I)
*
* Error trap in range.
*
      IF (EE1.GT.0.AND.EE1.LE.NN) THEN
*
      E3=INDEX(CCLIS,RLAB(EE1))
      E4=RN(EE1)
*
* error trap no neighbour.
*
      IF (E3.GT.0.AND.E4.GT.0) THEN
      ANOW=STRSYM(E4,E3)
*
* check strand.
*
      IF (ANOW.EQ.'P'.OR.ANOW.EQ.'A') THEN
      PPLINK(IH,E4,E3)=II
      E1=SSLINK(E4,E3)
*
* fill entries.
*
      IF (E1.GT.0) THEN
*
* Strand connection matrix.
*
      SHTLNK(E1,II)=SHTLNK(E1,II)+1
      SHTLNK(II,E1)=SHTLNK(II,E1)+1
*
* type of connection: parallel or antiparallel.
*
      IF (ABS(TYLINK(IH,E4,E3)).EQ.8) THEN
      SHTYP8(E1,II)=SHTYP8(E1,II)+1
      SHTYP8(II,E1)=SHTYP8(II,E1)+1
      ELSEIF (ABS(TYLINK(IH,E4,E3)).EQ.9) THEN
      SHTYP9(E1,II)=SHTYP9(E1,II)+1
      SHTYP9(II,E1)=SHTYP9(II,E1)+1
      ENDIF
*
      ENDIF
*
      ENDIF
      ENDIF
      ENDIF
*
3     CONTINUE
*
2     CONTINUE
1     CONTINUE
*
* Decide overall parallel/antiparallel connectedness of linked strands.
*
      DO 20 I2=1,NSTRAND(I)
      DO 20 I1=1,NSTRAND(I)
*
* Error trap self comparison.
*
      IF (I1.EQ.I2) GOTO 20
*
* logic for pure vs mixed.
*
      IF (SHTYP8(I1,I2).GT.0) THEN
*
      IF (SHTYP9(I1,I2).LT.1) THEN
      SHLTYP(I1,I2)=8
      ELSE
      IF (SHTYP9(I1,I2).LT.SHTYP8(I1,I2)) THEN
      SHLTYP(I1,I2)=18
      ELSE     
      SHLTYP(I1,I2)=19
      ENDIF
      ENDIF
*
      ELSE
      SHLTYP(I1,I2)=9
      ENDIF
*
* get matrix for richardson orientation.
*
      IF (SHLTYP(I1,I2).EQ.9.OR.SHLTYP(I1,I2).EQ.19) THEN
      LOCORI(I1,I2)=0
      ELSE
      LOCORI(I1,I2)=1
      ENDIF
*
20    CONTINUE
*
* Cluster:
*
      IFK=NSTRAND(I)
      CALL CLUSHT2(LNKTOL,IFK,SHTLNK,LOCORI)
*
* reinitialise.
*
      DO 4 II=1,100
      SHMARK(II)=0
4     CONTINUE
*
* check for antiparallel beta-hairpins.
*
      WRITE(42,1000) I,CCLIS(I:I)
*
* work through strands.
*
      DO 5 II=1,(NSTRAND(I)-1)
*
* Is connection +1 ?
*
      IF (SHTLNK(II,II+1).EQ.1) THEN
*
* Is connection antiparallel.
*
      IF (SHLTYP(II,II+1).EQ.8.OR.SHLTYP(II,II+1).EQ.18) THEN
*
* Increment hairpin counter.
*
      NPIN=NPIN+1
*
* record strands participating.
*
      WRITE(42,1001) II,II+1, 
     +STRAND1(II,I),STRAND2(II,I),
     +STRAND1(II+1,I),STRAND2(II+1,I)
*
* classify hairpin.
*
      DO 51 IY=STRAND2(II,I),STRAND1(II,I),-1
      DO 51 IH=1,2
*
* get pointers.
*
      IE1=BBPART(IH,IY,I)
      IF (IE1.GT.0) THEN
      IE4=RN(IE1)
      IT=PPLINK(IH,IY,I)
*
* is this the loop closing hydrogen bond ?.
*
      IF (IT.EQ.(II+1)) THEN
      ID1=ABS(IY-IE4)-1
      GOTO 52
      ENDIF
      ENDIF
*
51    CONTINUE
52    CONTINUE
*
* Write Sibanda classification to file.
*
      IF (IH.EQ.1) THEN
      WRITE(42,1002) ID1,ID1
      ELSE
      WRITE(42,1002) (ID1-2),ID1
      ENDIF
*
      ENDIF
      ENDIF
5     CONTINUE
*
* Fill sheet lists.
*
      DO 6 II=1,NSTRAND(I)
*
* error trap.
*
      IF (SHMARK(II).EQ.1) THEN
      ELSE
*
* increment counters.
*
      SHMARK(II)=1
      NSHEET(I)=NSHEET(I)+1
      SHTLEN(NSHEET(I),I)=1
*
      SHTNUM(SHTLEN(NSHEET(I),I),NSHEET(I))=II
      SHEETS(SHTLEN(NSHEET(I),I),NSHEET(I),I)=II
*
* get partners in sheet.
*
      DO 66 JJ=1,NSTRAND(I)
*
* trap diagonal.
*
      IF (II.EQ.JJ) THEN
      ELSE
*
* is there a connection ? if so add into list and mark it.
*
      IF (SHTLNK(II,JJ).GT.0) THEN
*
      SHTLEN(NSHEET(I),I)=SHTLEN(NSHEET(I),I)+1
      SHEETS(SHTLEN(NSHEET(I),I),NSHEET(I),I)=JJ
      SHTNUM(SHTLEN(NSHEET(I),I),NSHEET(I))=JJ
      SHMARK(JJ)=1
*
      ENDIF
      ENDIF
*
66    CONTINUE
*
      ENDIF
*
6     CONTINUE
*
* Save data.
*
      DO 601 K1=1,NSTRAND(I)
      DO 601 K2=1,NSTRAND(I)
      ORISHT(K2,K1,I)=LOCORI(K2,K1)
      LNKSHT(K2,K1,I)=SHTLNK(K2,K1)
601   CONTINUE
*
* get connectivity of sheets.
*
      IF (NSHEET(I).GT.0) THEN
*
* work through sheets.
*
      DO 7 II=1,NSHEET(I)
*
* work through members of this sheet.
*
      IF (SHTLEN(II,I).GT.1) THEN
*
* reinitialise.
*
      DO 8 JJ=1,100
      SHTCON(JJ)=0
      NCON(JJ)=0
8     CONTINUE
*
      E3=0
      N8=0
      N9=0
      N10=0
*
* work through members of this sheet.
*
      DO 9 JJ=1,SHTLEN(II,I)
*
* set pointers.
*
      E1=SHTNUM(JJ,II)
      E2=0
*
* Compare to all other strands.
*
      DO 10 KK=1,SHTLEN(II,I)
*
* get pointer.
*
      E4=SHTNUM(KK,II)
*
* Partner ?
*
      IF (SHTLNK(E4,E1).EQ.1.AND.E4.NE.E1) THEN
*
      E2=E2+1
      E3=E3+1
*
* fill connection table.
*
      NCON(JJ)=NCON(JJ)+1
      ICON(NCON(JJ),JJ)=KK
      NCON(KK)=NCON(KK)+1
      ICON(NCON(KK),KK)=JJ
*
* Type of sheet.
*
      IF (SHLTYP(E4,E1).EQ.8) N8=N8+1
      IF (SHLTYP(E4,E1).EQ.9) N9=N9+1
      IF (SHLTYP(E4,E1).EQ.18.OR.SHLTYP(E4,E1).EQ.19) N10=N10+1
*
      ENDIF
10    CONTINUE
      SHTCON(E2)=SHTCON(E2)+1
9     CONTINUE
*
* classify joining type.
*
      CALL SHCLAS(IDEC,N8,N9,N10)      
*
* store result.
*
      SHTTYP(II,I)=IDEC
*
* get richardson topology.
*
      CALL RICHARD(II,I)
*
* calculate number of rings.
*
      E3=(E3/2)-SHTLEN(II,I)+1
      SHTRNG(II,I)=E3
*
* Classify sheet.
*
      IF (E3.GT.0) THEN 
*
* closed and unbranched.
*
      IF (SHTCON(1).LT.1) THEN
      SHTMRK(II,I)=1
      ELSE
*
* closed and branched.
*
      SHTMRK(II,I)=2
      ENDIF
*
      ELSE
*
      IF (SHTCON(1).GT.2) THEN
*
* open and branched
*
      SHTMRK(II,I)=3
      ELSE
*
* open and unbranched.
*
      SHTMRK(II,I)=4
      ENDIF
*
      ENDIF
*
* Save Sheet connectivity.
*
      IFK=SHTLEN(II,I)
      CALL BNDDUP(IFK,NCON,ICON)
*
      DO 35 IU=1,SHTLEN(II,I)
      SHNCON(IU,II,I)=NCON(IU)
      DO 35 IZ=1,NCON(IU)
      SHICON(IZ,IU,II,I)=ICON(IZ,IU)
35    CONTINUE
*
* find rings.
*
      IF (RNGDEC.EQ.1) THEN
*
* Error trap no rings.
*
      IF (E3.GT.0) THEN 
*
* Call ring perception algorithm.
*
      IFK=SHTLEN(II,I)
      CALL RINGS(IFK,IRG,NCON,ICON,NLIST,ILIST)
*
* Order rings.
*
      CALL RNGORD(IRG,NLIST,ILIST)
*
* Save number of rings.
*
      SHTRNG(II,I)=IRG
*
* Save lists of ring members.
*
      IF (IRG.GT.0) THEN
      DO 30 IU=1,IRG
      RNGLEN(IU,II,I)=NLIST(IU)
      DO 31 IZ=1,NLIST(IU)
      RNGLST(IZ,IU,II,I)=ILIST(IZ,IU)
31    CONTINUE
30    CONTINUE
      ENDIF
*
      ENDIF
*
      ENDIF
*
      ENDIF
*
7     CONTINUE
      ENDIF
*
* format statements.
*
1000  FORMAT(/' Chain: ',I2,' label: "',A1,'"'/)
1001  FORMAT(' strands ',I3,' and ',I3,' form a beta-hairpin.'/,
     +'   residues',I5,' - ',I5,' and',I5,' - ',I5,'.')
1002  FORMAT(6X,'Sibanda classification:',I4,':',I4,'.'/)
*
      RETURN
      END
*  
*-------------------------------------------------------------------------------
*
* classify joining of strands within sheet.
*
      SUBROUTINE SHCLAS(IDEC,N8,N9,N10)
*
* declarations.
*
      INTEGER IDEC,N8,N9,N10
*
* logic
*
      IDEC=0
*
* mixed.
*
      IF (N8*N9.GT.0.OR.N10.GT.0) THEN
      IDEC=3
      ELSE
*
      IF (N8.LT.1.AND.N9.GT.0) THEN
*
* parallel
*
      IDEC=2
      ELSEIF (N8.GT.0.AND.N9.LT.1) THEN
*
* antiparallel.
*
      IDEC=1
      ENDIF
*
      ENDIF
*
      RETURN
      END
*  
*-------------------------------------------------------------------------------
*
* write results out to files.
*
      SUBROUTINE DISPLY
*
* declarations.
*
      INTEGER I,J,E1,E2,E3
*
      CHARACTER LINE1*80,LINE2*80,LINE3*80,LINE4*80,
     +LINE5*80,LINE6*80
*
      CHARACTER A1*1,A3*3,S1L*1,S2L*1,S3L*1,
     +A1L*1,A2L*1,SMB2*2,SMBC*1
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      LINE3='                                                                
     +                             '
*
* work through chains writing summary of secondary structure.
*
      DO 1 I=1,CHL
*
* write chain label.
*
      WRITE(9,1001)  I,CCLIS(I:I)
      WRITE(10,1001) I,CCLIS(I:I)
      WRITE(14,1001) I,CCLIS(I:I)
*
* reinitialise.
*
      J1=0
      LINE1=LINE3
      LINE2=LINE3
      LINE4=LINE3
      LINE5=LINE3
      LINE6=LINE3
*
* work through chain.
*
      DO 2 J=RN1(I),RN2(I)
*
* get pointer to this residue.
*
      E1=POS(1,J,I)
*
* error trap.
*
      IF (E1.GT.0) THEN
*
* increment line pointers.
*
      J1=J1+1
      SMBC=' '
*
* get secondary structure symbol.
*
      S1L=STRSYM(J,I)
*
* get disulphide label.
*
      IF (ISSBND(J,I).GT.0) THEN
      IFK=(ISSBND(J,I)+26)
      CALL NUMLET(IFK,S3L)
      ELSE
      S3L=' '
      ENDIF
*
* get sheet label.
*
      IF (SSLINK(J,I).GT.0) THEN
      IFK=SSLINK(J,I)
      CALL NUMLET(IFK,S2L)
      LINE4(J1:J1)=S2L
      ELSE
      S2L=' '
      ENDIF
*
* get strand partners.
*
      A1L=' '
      A2L=' '
      E2=PPLINK(1,J,I)
      E3=PPLINK(2,J,I)
*
      IF (E2.GT.0) THEN
      CALL NUMLET(E2,A1L)
      LINE5(J1:J1)=A1L
      ENDIF
*
      IF (E3.GT.0) THEN
      CALL NUMLET(E3,A2L)
      LINE6(J1:J1)=A2L
      ENDIF
*
* get pointers to actual partners.
*
      E2=BBPART(1,J,I)
      E3=BBPART(2,J,I)
*
* error trap.
*
      IF (E2.LT.1) A1L=' '
      IF (E3.LT.1) A2L=' '
*
* do stuff for long file
*
      A3=RNAM(E1)
*
* alpha-helix.
*
      IF (S1L.EQ.'4') THEN
      WRITE(9,1101) A3,J
*
* 310 helix.
*
      ELSE IF (S1L.EQ.'3') THEN
      WRITE(9,1102) A3,J
*
* antiparallel strand.
*
      ELSE IF (S1L.EQ.'A') THEN
*
*      IF (A1L.NE.' '.AND.A2L.NE.' ') THEN
      IF (E2.GT.0.AND.E3.GT.0) THEN
*
* doubly connected.
*
      WRITE(9,1104) A3,J,S2L,
     +RNAM(E2),RN(E2),RLAB(E2),A1L,
     +RNAM(E3),RN(E3),RLAB(E3),A2L
      SMBC='d'
*
* Singly connected.
*
      ELSEIF (E2.GT.0) THEN
      WRITE(9,1105) A3,J,S2L,
     +RNAM(E2),RN(E2),RLAB(E2),A1L
      SMBC='s'
*
      ELSEIF (E3.GT.0) THEN
      WRITE(9,1106) A3,J,S2L,
     +RNAM(E3),RN(E3),RLAB(E3),A2L
      SMBC='s'
*
* unnconected.
*
      ELSE 
*
      WRITE(9,1110) A3,J
*
      ENDIF
*
* parallel strand.
*
      ELSE IF (S1L.EQ.'P') THEN
*
*      IF (A1L.NE.' '.AND.A2L.NE.' ') THEN
      IF (E2.GT.0.AND.E3.GT.0) THEN
*
* doubly connected.
*
      WRITE(9,1107) A3,J,S2L,
     +RNAM(E2),RN(E2),RLAB(E2),A1L,
     +RNAM(E3),RN(E3),RLAB(E3),A2L
      SMBC='d'
*
* Singly connected.
*
      ELSEIF (E2.GT.0) THEN
      WRITE(9,1108) A3,J,S2L,
     +RNAM(E2),RN(E2),RLAB(E2),A1L
      SMBC='s'
*
      ELSEIF (E3.GT.0) THEN
      WRITE(9,1109) A3,J,S2L,
     +RNAM(E3),RN(E3),RLAB(E3),A2L
      SMBC='s'
*
      ELSE 
*
* unconnected.
*
      WRITE(9,1111) A3,J,S1L
*
      ENDIF
*
* not part of a secondary structure.
*
      ELSE
*
      WRITE(9,1100) A3,J
*
      ENDIF
*
* get other information for summary files.
*
      CALL RNMTCH(A3,A1)
*
      LINE1(J1:J1)=A1
      LINE2(J1:J1)=S1L
*
* get region of ramachandran chart. 
*
      SMB2=ASYMB(J,I)
*
* write angles.
*
      IF (SMB2(2:2).EQ.' ') THEN
      WRITE(9,1113) (DANGL(K7,J,I),K7=1,3),SMB2(1:1)
      ELSE
      WRITE(9,1112) (DANGL(K7,J,I),K7=1,3),SMB2
      ENDIF
*
* write short output.
*
      IF (IANGL(J,I).GT.3) THEN
*
      WRITE(14,1115) 
     +A3,J,S3L,SMBC,S1L,
     +(DANGL(K7,J,I),K7=1,3),SMB2,
     +(DANGL(K8,J,I),K8=4,IANGL(J,I))
*
      ELSE
*
      WRITE(14,1114) 
     +A3,J,S3L,SMBC,S1L,
     +(DANGL(K7,J,I),K7=1,3),SMB2
*
      ENDIF
*
      ENDIF
* 
* write this line.
*
      IF (J1.EQ.80) THEN
      WRITE(10,2000) LINE1,LINE2,LINE4,LINE5,LINE6
      CALL WRNBRF(20,LINE2)
      J1=0
      LINE1=LINE3
      LINE2=LINE3
      LINE4=LINE3
      LINE5=LINE3
      LINE6=LINE3
      ENDIF 
*
2     CONTINUE
*
* cope with overhanging sequence.
*
      IF (J1.GT.0) THEN
      WRITE(10,2000) LINE1,LINE2,LINE4,LINE5,LINE6
      CALL WRNBRF(20,LINE2) 
      ENDIF
*
* terminate NBRF file.
*
      WRITE(20,1021)
*
1     CONTINUE
*
* Write ranges.
*
      IF (RANGED.EQ.1) THEN
      CALL RGEDIS
      ENDIF
*
* Display Sheet information.
*
      IF (SHTDEC.EQ.1) THEN
      CALL SHTDIS
      ENDIF
*
* format statements.
*
1000  FORMAT(//20X,'             F O L D '//,
     +         20X,' Summary of Secondary Structures'//)
1001  FORMAT(/' Chain: ',I2,' label: "',A1,'"'/)
1020  FORMAT(A80)
1021  FORMAT('*')
*
1100  FORMAT(2X,A3,I4)
1101  FORMAT(2X,A3,I4,' is in an Alpha-helix.')
1102  FORMAT(2X,A3,I4,' is in a 310 helix.')
1103  FORMAT(2X,A3,I4,' is in a PI helix.')
1104  FORMAT(2X,A3,I4,
     +' is a doubly connected part of an anti-parallel strand ('
     +,A1,').'/,
     +9X,' inner bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.'/,
     +9X,' outer bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.')
1105  FORMAT(2X,A3,I4,
     +' is a singly connected part of an anti-parallel strand (',
     +A1,').'/,
     +9X,' inner bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.')
1106  FORMAT(2X,A3,I4,
     +' is a singly connected part of an anti-parallel strand (',
     +A1,').'/,
     +9X,' outer bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.')
1107  FORMAT(2X,A3,I4,
     +' is a doubly connected part of a parallel strand (',A1,').'/,
     +9X,' inner bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.'/,
     +9X,' outer bridge partner: ',A3,I4,A1,' part of strand: ',A1,'.')
1108  FORMAT(2X,A3,I4,
     +' is a singly connected part of a parallel strand (',
     +A1,').'/,
     +9X,' inner bridge partner: ',A3,I4,A1,' part of strand: ',A1,'.')
1109  FORMAT(2X,A3,I4,
     +' is a singly connected part of a parallel strand (',
     +A1,').'/,
     +9X,' outer bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.')
1110  FORMAT(2X,A3,I4,
     +' is an unconnected part of an anti-parallel strand.')
1111  FORMAT(2X,A3,I4,
     +' is an unconnected part of a parallel strand.')
1112  FORMAT(10X,'   (Phi:',F9.2,'  Psi:',F9.2,'  Omg:',F9.2,
     +'  region: ',A2,') ')
1113  FORMAT(10X,'   (Phi:',F9.2,'  Psi:',F9.2,'  Omg:',F9.2,
     +'  region: ',A1,') ')
1114  FORMAT(3X,A3,I5,A1,2X,A1,A1,2X,3F9.2,2X,A2)
1115  FORMAT(3X,A3,I5,A1,2X,A1,A1,2X,3F9.2,2X,A2,7(3F9.2,2X))
*
2000  FORMAT(5(A80/))
2032  FORMAT(A80/A80)
2001  FORMAT(I1)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* write range summaries. 
*
      SUBROUTINE RGEDIS
*
* Declarations.
*
      INTEGER LTYP(500),AMTHEL,AMTSTR,ACCIAA(20),E1,E2
      CHARACTER W1*1,W2*2,A3*3
*
      INCLUDE 'FOLD.INC'
*
* Work through chains.
*
      DO 3 I=1,CHL
*
* Initialise.
*
      AMTHEL=0
      AMTSTR=0
*
      DO 700 JJ=1,20
      ACCIAA(JJ)=0
700   CONTINUE
*
      WRITE(11,1001) I,CCLIS(I:I)
*
* alpha helices.
*
      IF (NHEL4(I).GT.0) THEN
      WRITE(11,*)
      DO 41 JJ=1,NHEL4(I)
      WRITE(11,1500) HEL4N1(JJ,I),HEL4N2(JJ,I)
      AMTHEL=AMTHEL+ABS(HEL4N2(JJ,I)-HEL4N1(JJ,I))+1
41    CONTINUE
      ENDIF
*
* 310 helices.
*
      IF (NHEL3(I).GT.0) THEN
      WRITE(11,*)
      DO 42 JJ=1,NHEL3(I)
      WRITE(11,1501) HEL3N1(JJ,I),HEL3N2(JJ,I)
      AMTHEL=AMTHEL+ABS(HEL3N2(JJ,I)-HEL3N1(JJ,I))+1
42    CONTINUE
      ENDIF
*
* Strands.
*
      IF (NSTRAND(I).GT.0) THEN
      WRITE(11,*)
      DO 44 JJ=1,NSTRAND(I)
      WRITE(11,1503) STRAND1(JJ,I),STRAND2(JJ,I)
      AMTSTR=AMTSTR+ABS(STRAND2(JJ,I)-STRAND1(JJ,I))+1
44    CONTINUE
      ENDIF
*
* process loops.
*
      IF (NLOOP(I).GT.0) THEN
*
      WRITE(11,*)
*
      DO 46 JJ=2,(NLOOP(I)-1)
      LTYP(JJ)=0
      IF ((LOOP2(JJ,I)-LOOP1(JJ,I)).GT.1) THEN
      E1=LOOP1(JJ,I)
      E2=LOOP2(JJ,I)
      W1=STRSYM(E1-1,I)
      W2=STRSYM(E2+1,I)
      IF (W1.EQ.'A'.OR.W1.EQ.'P') THEN
      IF (W2.EQ.'A'.OR.W2.EQ.'P') THEN
      LTYP(JJ)=1
      ELSEIF (W2.EQ.'4'.OR.W2.EQ.'3') THEN
      LTYP(JJ)=2
      ENDIF
      ENDIF
      IF (W1.EQ.'4'.OR.W1.EQ.'3') THEN
      IF (W2.EQ.'A'.OR.W2.EQ.'P') THEN
      LTYP(JJ)=2
      ELSEIF (W2.EQ.'4'.OR.W2.EQ.'3') THEN
      LTYP(JJ)=3
      ENDIF
      ENDIF
      ENDIF
46    CONTINUE
      DO 47 JJ=2,(NLOOP(I)-1)
      IF (LTYP(JJ).EQ.1) THEN
      E1=LOOP1(JJ,I)
      E2=LOOP2(JJ,I)
      WRITE(11,1505) E1,E2
      ENDIF
47    CONTINUE
      DO 48 JJ=2,(NLOOP(I)-1)
      IF (LTYP(JJ).EQ.2) THEN
      E1=LOOP1(JJ,I)
      E2=LOOP2(JJ,I)
      WRITE(11,1506) E1,E2
      ENDIF
48    CONTINUE
      DO 49 JJ=2,(NLOOP(I)-1)
      IF (LTYP(JJ).EQ.3) THEN
      E1=LOOP1(JJ,I)
      E2=LOOP2(JJ,I)
      WRITE(11,1507) E1,E2
      ENDIF
49    CONTINUE
      ENDIF
*
3     CONTINUE
*
* format statements.
*
1001  FORMAT(/' Chain: ',I2,' label: "',A1,'"'/)
1500  FORMAT(' Alpha Helix:',I5,I5)
1501  FORMAT('   310 Helix:',I5,I5)
1502  FORMAT('    PI Helix:',I5,I5)
1503  FORMAT('      Strand:',I5,I5)
1504  FORMAT('        Loop:',I5,I5)
1505  FORMAT('     BB-Loop:',I5,I5)
1506  FORMAT('     AB-Loop:',I5,I5)
1507  FORMAT('     AA-Loop:',I5,I5)
1510  FORMAT('       Bulge:',I5,I5)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* write results out to files.
*
      SUBROUTINE SHTDIS
*
* declarations.
*
      INTEGER I,J,IDEC,E1,E2,ITOP,K1,K2,P(100)
*
      CHARACTER LINE3*80
*
      CHARACTER A1*1,A4*4,TSLINE*80
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      LINE3='                                                            
     +                               '
*
* write summary of sheets to file.
*
      IDEC=0
      DO 5 I=1,CHL
*
* Trap no sheets.
*
      IF (NSHEET(I).GT.0) THEN
      IDEC=1
      WRITE(12,1001) I,CCLIS(I:I)
*
* work through sheets in this chain.
*
      DO 51 II=1,NSHEET(I)
*
* trap sheet length.
*
      IF (SHTLEN(II,I).GT.1) THEN
*
* report sheet number and length.
*
      WRITE(12,1600) II,SHTLEN(II,I)
*
      ITOP=1
      TSLINE=LINE3
      CALL NUMLET(II,A1)
      TSLINE(1:10)=
     +MOLNAME(1:4)//' '//CCLIS(I:I)//'_'//A1//': '
      ITOP=11
*
* work through this sheet.
*
      DO 6 J=1,SHTLEN(II,I)
*
* Get pointer.
*
      E1=SHEETS(J,II,I)
*
* write sheet topology.
*
      CALL TOPDIS(SHTORI(J,II,I),SHTTOP(J,II,I),ITOP,E1,I,TSLINE)
*
6     CONTINUE
*
* Report summary line for sheet.
*
      CALL PACK1(ITOP,TSLINE)
      WRITE(12,1667) 
      CALL WRLINE(12,ABS(ITOP)-1,
     +TSLINE(1:ABS(ITOP-2))//'.')
*
* now do DRF topology.
*
      CALL SHTSMI(12,II,I)
*
* classify sheet.
*
      IF (SHTMRK(II,I).EQ.1) THEN
      WRITE(12,1601)
      ELSEIF (SHTMRK(II,I).EQ.2) THEN 
      WRITE(12,1602)
      ELSEIF (SHTMRK(II,I).EQ.3) THEN
      WRITE(12,1603)
      ELSEIF (SHTMRK(II,I).EQ.4) THEN
      WRITE(12,1604)
      ELSE
      WRITE(12,1605)
      ENDIF
*
* echo number of rings.
* 
      IF (SHTRNG(II,I).EQ.1) THEN
*
* a single ring.
*
      WRITE(12,1606) 
*
      IF (RNGDEC.EQ.1) THEN
*
* report length.
*
      WRITE(12,1710) 1,RNGLEN(1,II,I)
*
* reinitialise.
*
      ITOP=1
      TSLINE=LINE3
      CALL NUMLET(II,A1)
      TSLINE(1:16)=
     +MOLNAME(1:4)//' '//CCLIS(I:I)//'_'//A1//': '
      ITOP=11
*
* get within ring sequence distance.
*
      CALL SIRING(1,II,I,P)
*
      DO 91 IZ=1,RNGLEN(1,II,I)
*
* get pointers.
*
      K1=RNGLST(IZ,1,II,I)
      E1=SHEETS(K1,II,I)
*
      E2=0
      IF (IZ.GT.1) THEN
      K2=RNGLST(IZ-1,1,II,I)
      E2=SHEETS(K2,II,I)
      ELSE
      K2=RNGLST(RNGLEN(1,II,I),1,II,I)
      E2=SHEETS(K2,II,I)
      ENDIF
*
* get distance between strands in sequence.
*
      IF (REDDEC.EQ.1) THEN
      K3=K1-K2
      K3=P(K1)-P(K2)
      ELSE
      K3=E1-E2
      ENDIF
*
* write sheet topology.
*
      CALL TOPDIS(ORISHT(E1,E2,I),K3,ITOP,E1,I,TSLINE)
*
91    CONTINUE
*
      CALL PACK1(ITOP,TSLINE)
      WRITE(A4,'(I4)') RNGLEN(1,II,I)
      WRITE(12,1667) 
      CALL WRLINE(12,ABS(ITOP)+9,' ring '//
     +TSLINE(1:ABS(ITOP)-2)//'.'//A4)
*
      WRITE(12,*)
      ENDIF
*
      ELSEIF (SHTRNG(II,I).GT.1) THEN
*
* multiple rings.
*
      WRITE(12,1607) SHTRNG(II,I)
      IF (RNGDEC.EQ.1) THEN
      DO 8 IZ=1,SHTRNG(II,I)
*
      WRITE(12,1710) IZ,RNGLEN(IZ,II,I)
*
* reinitialise.
*
      ITOP=1
      TSLINE=LINE3
      CALL NUMLET(II,A1)
      TSLINE(1:10)=
     +MOLNAME(1:4)//' '//CCLIS(I:I)//'_'//A1//': '
      ITOP=11
*
* get within ring sequence distance.
*
      CALL SIRING(IZ,II,I,P)
*
      DO 81 IZ1=1,RNGLEN(IZ,II,I)
*
* get pointers.
*
      K1=RNGLST(IZ1,IZ,II,I)
      E1=SHEETS(K1,II,I)
*
      E2=0
      IF (IZ1.GT.1) THEN
      K2=RNGLST(IZ1-1,IZ,II,I)
      E2=SHEETS(K2,II,I)
      ELSE
      K2=RNGLST(RNGLEN(IZ,II,I),IZ,II,I)
      E2=SHEETS(K2,II,I)
      ENDIF
*
* get distance in sequence between strands.
*
      IF (REDDEC.EQ.1) THEN
      K3=K1-K2
      K3=P(K1)-P(K2)
      ELSE
      K3=E1-E2
      ENDIF
*
* write sheet topology.
*
      CALL TOPDIS(ORISHT(E1,E2,I),K3,ITOP,E1,I,TSLINE)
*
81    CONTINUE
*
      CALL PACK1(ITOP,TSLINE)
      WRITE(A4,'(I4)') RNGLEN(IZ,II,I)
      WRITE(12,1667) 
      CALL WRLINE(12,ABS(ITOP)+9,' ring '//
     +TSLINE(1:ABS(ITOP)-2)//'.'//A4)
*
      WRITE(12,*)
8     CONTINUE
      ENDIF
      ELSE
*
* no rings.
*
      WRITE(*,*)
      ENDIF
*
* joining classification. 
*
      IF (SHTTYP(II,I).EQ.1) THEN
      WRITE(12,1701)
      ELSEIF (SHTTYP(II,I).EQ.2) THEN 
      WRITE(12,1702)
      ELSEIF (SHTTYP(II,I).EQ.3) THEN
      WRITE(12,1703)
      ELSE
      WRITE(12,1705)
      ENDIF
*
      ENDIF
*
51    CONTINUE
*
      ENDIF
*
5     CONTINUE
*
* trap empty sheet file.
*
      IF (IDEC.EQ.1) THEN
      CLOSE(UNIT=12)
      ELSE
      CLOSE(UNIT=12,DISPOSE='DELETE')
      ENDIF
*
* Format Statements.
*
1001  FORMAT(/' Chain: ',I2,' label: "',A1,'"'/)
*
1600  FORMAT(/' Sheet:',I3,' has',I3,' strands.'/)
1601  FORMAT(/' this sheet is CLOSED and UNBRANCHED.')
1602  FORMAT(/' this sheet is CLOSED and BRANCHED.')
1603  FORMAT(/' this sheet is OPEN and BRANCHED.')
1604  FORMAT(/' this sheet is OPEN and UNBRANCHED.')
1605  FORMAT(/' this sheet is UNCLASSIFIED.')
1606  FORMAT('  and contains 1 ring.'/)
1607  FORMAT('  and contains',I3,' rings.'/)
1652  FORMAT('      Strand:',I5,I5,3X,A4)
1662  FORMAT('      Strand:',I5,I5,3X,A5)
1654  FORMAT('      Strand:',I5,I5)
1664  FORMAT('      Strand:',I5,I5)
1667  FORMAT(/' Topological summary: '/)
*
1653  FORMAT('+',I2,'.')
1655  FORMAT('-',I2,'.')
1663  FORMAT('+',I2,'x.')
1665  FORMAT('-',I2,'x.')
*
1701  FORMAT('  sheet joining is antiparallel.'/)
1702  FORMAT('  sheet joining is parallel.'/)
1703  FORMAT('  sheet joining is mixed parallel and antiparallel.'/)
1705  FORMAT('  sheet joining is unclassified.'/)
*
1710  FORMAT(5X,'    ring number:',I4,'. ring length:',I4,'.'/)
1711  FORMAT(10X,' Strand:',2I5) 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get 1 letter code given three letter code.
*
      SUBROUTINE RNMTCH(RLONG,R1)
*
* declarations.
*
      INTEGER I
      CHARACTER RLONG*3,R1*1
      CHARACTER*4 RLIST(20)
*
* initialise.
*
      DATA RLIST /
     +'ALAA',
     +'ARGR',
     +'ASNN',
     +'ASPD',
     +'CYSC',
     +'GLNQ',
     +'GLUE',
     +'GLYG',
     +'HISH',
     +'ILEI',
     +'LEUL',
     +'LYSK',
     +'METM',
     +'PHEF',
     +'PROP',
     +'SERS',
     +'THRT',
     +'TRPW',
     +'TYRY',
     +'VALV' /
*
* run through list.
*
      DO 1 I=1,20
      IF (RLONG(1:3).EQ.RLIST(I)(1:3)) GOTO 2
1     CONTINUE
      R1='X'
      RETURN
*
2     CONTINUE
*
      R1(1:1)=RLIST(I)(4:4)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get 1 letter code given three letter code.
*
      SUBROUTINE RESPNT(RLONG,IAA)
*
* declarations.
*
      INTEGER I,IAA
      CHARACTER RLONG*3
      CHARACTER*4 RLIST(20)
*
* initialise.
*
      DATA RLIST /
     +'ALAA',
     +'ARGR',
     +'ASNN',
     +'ASPD',
     +'CYSC',
     +'GLNQ',
     +'GLUE',
     +'GLYG',
     +'HISH',
     +'ILEI',
     +'LEUL',
     +'LYSK',
     +'METM',
     +'PHEF',
     +'PROP',
     +'SERS',
     +'THRT',
     +'TRPW',
     +'TYRY',
     +'VALV' /
*
* run through list.
*
      DO 1 I=1,20
      IF (RLONG(1:3).EQ.RLIST(I)(1:3)) GOTO 2
1     CONTINUE
      IAA=0
      RETURN
*
2     CONTINUE
*
      IAA=I
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get a letter corresponding to a number. cyclic.
*
      SUBROUTINE NUMLET(IN,A1)
*
* declarations.
*
      INTEGER II,IN
      CHARACTER LINE1*26,LINE2*26,A1*1
*
* initialise.
*
      LINE1='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
      LINE2='abcdefghijklmnopqrstuvwxyz'
*
* Do it.
*
      II=IN
1     CONTINUE
*
      IF (II.GT.52) THEN
      II=II-52
      GOTO 1
      ENDIF
*
      IF (II.GT.26) THEN
      II=II-26
      A1=LINE2(II:II)
      ELSE
      A1=LINE1(II:II)
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* write out beta bulges to bulge summary file
*
      SUBROUTINE WRBLG
*
* declarations.
*
      INTEGER E1,E2,E3,V1,IK1,IK2,I1,I3,J1,J2,J3
      CHARACTER S1*2
      CHARACTER LINE1*80,LINE2*80,BLINE*80,A1*1
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      BLINE='                                                             
     +                                                           '
*
* title file.
*
      IF (INBULG.GT.0) THEN
      WRITE(*,2000)
      WRITE(*,2001) BLGLEN,INBULG
      WRITE(43,2001) BLGLEN,INBULG
      ELSE
      RETURN
      ENDIF
*
* work through list of Bulges.
*
      DO 1 J=1,INBULG
*
* reinitialise.
*
      IK1=0
      IK2=0
      LINE1=BLINE
      LINE2=BLINE
*
* get pointers.
*
      E1=BLGLNK(1,1,J)
      E2=BLGLNK(2,1,J)
      E3=BLGLNK(3,1,J)
*
* error trap
*
      IF (E1.LT.1) GOTO 2
      IF (E2.LT.1) GOTO 2
      IF (E3.LT.1) GOTO 2
*
* write header.
*
      KV=BLGLNK(1,2,J)
      KW=BLGLNK(2,2,J)
*
      IF (KV.EQ.1) WRITE(43,1001) KW
      IF (KV.EQ.2) WRITE(43,1002) KW
      IF (KV.EQ.3) WRITE(43,1003) KW
      IF (KV.EQ.4) WRITE(43,1004) KW
*
* get pointers to involved residues.
*
      I1=INDEX(CCLIS,RLAB(E1))
      I3=INDEX(CCLIS,RLAB(E3))
      J1=RN(E1)
      J2=RN(E2)
      J3=RN(E3)
*
      IF (I1.GT.0.AND.I3.GT.0) THEN
*
* work through ranges. 
*
      DO 3 I=J2-2,J3+2
*
* get regions of ramachandran chart.
*
      S1=ASYMB(I,I3)
*
* get pointer.
*
      V1=POS(1,I,I3)
*
* write residues.
*
      WRITE(43,1000) 
     +RNAM(V1),RN(V1),RLAB(V1),STRSYM(I,I1),
     +S1,DANGL(1,I,I3),DANGL(2,I,I3)
*
* record sequence.
*
      IK1=IK1+1
      CALL RNMTCH(RNAM(V1),A1)
      LINE1(IK1:IK1)=A1
*
3     CONTINUE
*
      WRITE(43,*)
*
* work through ranges. 
*
      DO 4 I=J1-2,J1+2
*
* get pointer.
*
      V1=POS(1,I,I1)
*
* get regions of ramachandran chart.
*
      S1=ASYMB(I,I1)
*
* write residues.
*
      WRITE(43,1000) 
     +RNAM(V1),RN(V1),RLAB(V1),STRSYM(I,I1),
     +S1,DANGL(1,I,I1),DANGL(2,I,I1)
*
* record sequence.
*
      IK2=IK2+1
      CALL RNMTCH(RNAM(V1),A1)
      LINE2(IK2:IK2)=A1
*
4     CONTINUE
*
      ENDIF
*
2     CONTINUE
*
* write output sequence.
*
      WRITE(43,3010) LINE1(1:20),LINE2(1:20)
*
1     CONTINUE
*
* format statements.
*
1000  FORMAT(3X,A3,I4,A1,2X,A1,5X,A2,2(1X,F8.3))
*
1001  FORMAT(/' classic antiparallel bulge of length',I4,'.'/)
1002  FORMAT(/' wide type antiparallel bulge of length',I4,'.'/)
1003  FORMAT(/' classic parallel bulge of length',I4,'.'/)
1004  FORMAT(/' wide type parallel bulge of length',I4,'.'/)
*
2000  FORMAT(/2X,' Analysis of beta-bulges.')
2001  FORMAT(/2X,'  Maximum size of Bulge:',I6,'.'/,2X,
     +        ' Number of Bulges found:',I6,'.'/)
*
3000  FORMAT('  Bulge length:',I4/,
     +3X,A3,I4,A1,1X,A2,2(1X,F8.3)/,
     +3X,A3,I4,A1,1X,A2,2(1X,F8.3)/,
     +3X,A3,I4,A1,1X,A2,2(1X,F8.3))
3001  FORMAT('  Bulge length:',I4,'.'/)
3010  FORMAT('  Bulge:'/,10X,A20,' - ',A20)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* assign regions of PHI/PSI space.
*
      SUBROUTINE REGAS(TANG1,TANG2,SYMB)
*
* declarations.
*
      REAL TANG1,TANG2,T1,T2
      CHARACTER*2 SYMB
*
      INTEGER I1,I2,ITYP(8,8)
      CHARACTER SB(6)*2
*
* initialise.
*
      DATA SB / 
     + 'AR','AL','B ','GR','GL','E ' /
*
      DATA ITYP / 
     + 3, 3, 3, 3, 0, 0, 0, 0,
     + 3, 3, 3, 3, 2, 2, 0, 0,
     + 0, 3, 3, 0, 2, 2, 0, 0,
     + 0, 4, 4, 0, 2, 2, 5, 0,
     + 0, 1, 1, 1, 0, 5, 5, 0,
     + 0, 1, 1, 1, 0, 0, 0, 0,
     + 0, 0, 0, 0, 0, 6, 6, 0,
     + 3, 3, 3, 3, 0, 6, 6, 0 /
*
* lookup angles in 2d array:
* 
      T1=TANG1+180.0
      T2=TANG2+180.0
*
* get pointers
*
      I1=INT(T1/45.0)+1
      I2=INT(T2/45.0)+1
*
* use look up table.
*
      I3=ITYP(I1,9-I2)
*
* get symbol.
*
      SYMB='  '
      IF (I3.GT.0.AND.I3.LT.7) THEN
      SYMB=SB(I3)
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* convert structure definition line to pseudo NBRF.
*
      SUBROUTINE WRNBRF(IOUT,LINE)
*
* declarations.
*
      INTEGER IOUT,I
      CHARACTER LINE*80,FLINE*80
*
* work through line 
*
      DO 1 I=1,80
      FLINE(I:I)='-'
      IF (LINE(I:I).EQ.'A') FLINE(I:I)='A'
      IF (LINE(I:I).EQ.'P') FLINE(I:I)='P'
      IF (LINE(I:I).EQ.'4') FLINE(I:I)='H'
      IF (LINE(I:I).EQ.'3') FLINE(I:I)='G'
1     CONTINUE
*
* write line.
*
      WRITE(IOUT,1000) FLINE
*
* format statements.
*
1000  FORMAT(A80)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* calculate RCBs and paths of all rings.
*
      SUBROUTINE RINGS(INODE,IDEL,NCON,ICON,NLIST,ILIST)
*
* Declarations.
*
      INTEGER INODE,IBND,NVX,IDEL,NFRAG,IFK
      INTEGER CORD1(2000),CORD2(2000)
      INTEGER NCON(1000),ICON(100,1000),IEDGE(2,2000)
      INTEGER IMRK(1000),P(2000),IDN(2000),ITEMP(1000)
      INTEGER NLIST(100),ILIST(100,100),BCON(100,1000)
*
* initialise.
*
      IBND=0
      IDEL=0
      NVX=0
      NFRAG=0
*
      DO 700 I=1,2000
      P(I)=0
      IDN(I)=0
      IMRK(I)=0
      IEDGE(1,I)=0
      IEDGE(2,I)=0
      CORD1(I)=0
      CORD2(I)=0
700   CONTINUE
*
      DO 128 I=1,INODE
*
* copy connection list.
*
      DO 129 IT=1,NCON(I)
      ITEMP(IT)=ICON(IT,I)
129   CONTINUE
*
* sort partners.
*
      IFK=NCON(I)
      CALL ISORT(IFK,ITEMP,IDN)
*
* reinitialise.
*
      IMRK(I)=0
      P(I)=0
*
* restore sorted partner lists.
*
      DO 130 J=1,NCON(I)
      I1=IDN(J)
      BCON(J,I)=ITEMP(I1)
      ICON(J,I)=ITEMP(I1)
130   CONTINUE
*
128   CONTINUE
*
* work through all fragments.
*
100   CONTINUE
*
* initialise.
*
      IBND=0
*
* increment fragment counter.
*
      NFRAG=NFRAG+1
*
* get root of tree.
*
      INOW=0
      DO 2 I=1,INODE
      IF (IMRK(I).EQ.0) THEN
      INOW=I
      IMRK(INOW)=NFRAG
      GOTO 3
      ENDIF
2     CONTINUE
*
      IF (INOW.EQ.0) THEN
      ELSE
*
* create tree.
*
3     CONTINUE
*
* fill edge list.
*
      IF (P(INOW).EQ.0) THEN
      NVX=NVX+1
      P(INOW)=NVX
      ENDIF
*
* work through connections to this node.
*
      DO 4 I=1,NCON(INOW)
      IC=ICON(I,INOW)
      IF (IC.GT.0) THEN
      IBND=IBND+1
      IEDGE(1,IBND)=INOW
      IEDGE(2,IBND)=IC
      ICON(I,INOW)=0
      DO 41 J=1,NCON(IC)
      IF (ICON(J,IC).EQ.INOW) ICON(J,IC)=0
41    CONTINUE
      ENDIF
4     CONTINUE
*
* check if any bonds remain.
*
      IF (IBND.GT.0) THEN
*
* get pointers to remaining edges.
*
      I1=IEDGE(1,IBND)
      I2=IEDGE(2,IBND)
*
* find a loop closing bond.
*
      IF (IMRK(I1).EQ.NFRAG.AND.IMRK(I2).EQ.NFRAG) THEN
      IDEL=IDEL+1
      CORD1(IDEL)=I1
      CORD2(IDEL)=I2
      ELSE
*
* not a loop closing bond.
*
      INOW=I2
      IMRK(I2)=NFRAG
      ENDIF
*
      IBND=IBND-1
*
      GOTO 3
      ELSE
      ENDIF
*
      ENDIF
*
* all fragments found.
*
      IF (INOW.EQ.0) THEN
      ELSE
      GOTO 100
      ENDIF
*
* now find cycles in graph.
*
      DO 6 I=1,IDEL
*
* get first cord.
*
      IF (P(CORD1(I)).GT.P(CORD2(I))) THEN
      I1=CORD2(I)
      I2=CORD1(I)
      ELSE
      I2=CORD2(I)
      I1=CORD1(I)
      ENDIF
*
* reset pointers and counters.
*
      INOW=I2
      NLIST(I)=1
      ILIST(1,I)=INOW
*
      IT=NVX+1
      IK=0
*
* find partner with lowest position in tree.
*
      DO 71 II=1,NCON(INOW)
      IB=BCON(II,INOW)
      IF (P(IB).LT.IT.AND.IB.NE.I1.
     +AND.P(IB).NE.0.AND.P(IB).GE.P(I1)) THEN
      IT=P(IB)
      IK=IB
      ENDIF
71    CONTINUE
*
* check we have found one.
*
      IF (IK.GT.0) THEN 
*
      NLIST(I)=NLIST(I)+1
      ILIST(NLIST(I),I)=IK
      INOW=IK
*
8     CONTINUE
*
* update pointers and counters.
*
      IT=NVX+1
      IK=0
*
* work through all connections to find partner.
*
      DO 7 II=1,NCON(INOW)
      IB=BCON(II,INOW)
*
* check if we have found other partner of cord.
*
      IF (IB.EQ.I1) THEN
      NLIST(I)=NLIST(I)+1
      ILIST(NLIST(I),I)=I1
      GOTO 6
      ENDIF
*
* search for lowest scoring partner.
*
      IF (P(IB).LT.IT .AND.
     +    P(IB).NE.0  .AND.
     +    P(IB).GE.P(I1)) THEN
*
      IT=P(IB)
      IK=IB
*
      ENDIF
*
7     CONTINUE
*
* update list of ring members.
*
      NLIST(I)=NLIST(I)+1
      ILIST(NLIST(I),I)=IK
      INOW=IK
*
* check if we have found other partner of cord.
*
      IF (IK.EQ.I1.OR.NLIST(I).GT.INODE) THEN
      ELSE
      GOTO 8
      ENDIF
*
      ENDIF
*
6     CONTINUE
*
* loop back for next fragment.
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* cluster sheets.
*
      SUBROUTINE CLUSHT2(NTOL,NSTRND,LINKS,LINKA)
*
* declarations.
*
      INTEGER I,J,K,J1,J2
      INTEGER NTOL,NSTRND,LINKS(100,100),LINKA(100,100)
*
      INTEGER LINK1(100,100),LINK2(100,100)
*
* Check enough connections. if enough make a 1-2 link.
*
      DO 1 I=1,NSTRND
      DO 1 J=1,NSTRND
      IF (LINKS(J,I).GE.NTOL) THEN
      LINK1(J,I)=1
      ELSE
      LINK1(J,I)=0
      ENDIF
1     CONTINUE
*
      DO 11 I=1,NSTRND
      LINK1(I,I)=0
11    CONTINUE
*
* get 1-n links from 1-(n-1) links.
*
      DO 2 K=1,NSTRND
      DO 2 I=1,NSTRND
      DO 2 J1=1,NSTRND
      DO 2 J2=1,NSTRND     
*
* error trap self-self comparison.
*
      IF (J1.EQ.J2) GOTO 2
*
* is there a conection ?
*
      IF (LINK1(I,J1).EQ.1.AND.LINK1(J2,I).EQ.K) THEN
*
* has it been found before.
*
      IF (LINK1(J2,J1).EQ.0) THEN
      LINK1(J2,J1)=K+1
      IF (LINKA(I,J1).EQ.LINKA(J2,I)) THEN
      LINKA(J2,J1)=0
      LINKA(J1,J2)=0
      ELSE
      LINKA(J2,J1)=1
      LINKA(J1,J2)=1
      ENDIF
      ENDIF
*
      ENDIF
*
* is there a conection ?
*
      IF (LINK1(J2,I).EQ.1.AND.LINK1(I,J1).EQ.K) THEN
*
* has it been found before.
*
      IF (LINK1(J2,J1).EQ.0) THEN
      LINK1(J2,J1)=K+1
      IF (LINKA(J2,I).EQ.LINKA(I,J1)) THEN
      LINKA(J2,J1)=0
      LINKA(J1,J2)=0
      ELSE
      LINKA(J2,J1)=1
      LINKA(J1,J2)=1
      ENDIF
      ENDIF
*
      ENDIF
*
2     CONTINUE
*
* copy sheetmatrix back.
*
      DO 4 I=1,NSTRND
      DO 4 J=1,NSTRND
      LINKS(J,I)=LINK1(J,I)     
4     CONTINUE
*
      RETURN 
      END
*
*-------------------------------------------------------------------------------
*
* Display turns.
*
      SUBROUTINE TURNS
*
* Declarations.
*
      INTEGER I1,I2,E1,NT(2),INT1(1000,2),INT2(1000,2)
      CHARACTER A9*9,A12*12,SMB2*2
*
      INCLUDE 'FOLD.INC'
*
* work through all chains. 
*
      DO 1 I=1,CHL
*
* work through all residues. 
*
      DO 2 J=RN1(I),RN2(I)
*
* Error trap.
*
      IK=ITURN(J,I)
*
      IF (IK.EQ.0) THEN
      ELSE
*
* get H-bond turn type.
*
      IF (IK.GT.4999) IK=IK-5000
      IF (IK.GT.399)  IK=IK-400
      IK1=IK
      IF (IK.GT.29)   IK=IK-30
*
      IF (IK.EQ.2.OR.IK1.GT.2) THEN
*
* check not all part of a proper helix.
*
      DO 3 K1=0,3
*
* Error trap.
*
      IF (STRSYM(J-K1,I).EQ.'4') THEN
      ELSEIF (STRSYM(J-K1,I).EQ.'3') THEN
      ELSE
      IF (IK1.GT.2) THEN
*
* B-turns.
*
      NT(2)=NT(2)+1
      INT1(NT(2),2)=J
      INT2(NT(2),2)=I
      ELSE
*
* gamma-turns
*
      NT(1)=NT(1)+1
      INT1(NT(1),1)=J
      INT2(NT(1),1)=I
      ENDIF
      GOTO 2
      ENDIF
*
3     CONTINUE
*
      ENDIF
      ENDIF
*
2     CONTINUE
*
1     CONTINUE
*
*100   CONTINUE
*
* now write results to file.
*
      IF (NT(1).GT.0) THEN
*
* write header.
*
      WRITE(70,1000)
*
* work through all turns.
*
      DO 41 I=1,NT(1)
*
* get pointers.
*
      I1=INT1(I,1)
      I2=INT2(I,1)
      E1=POS(4,I1,I2)
      I1=I1-2
      E2=POS(4,I1,I2)
*
* Error trap.
*
      IF (E1.GT.0.AND.E2.GT.0) THEN
*
* get main chain conformations.
*
      SMB2=ASYMB(I1,I2)
      A9(1:3)=SMB2//' '
      SMB2=ASYMB(I1+1,I2)
      A9(4:6)=SMB2//' '
      SMB2=ASYMB(I1+2,I2)
      A9(7:9)=SMB2//' '
*
* write this turn.
*
      WRITE(70,1001) 
     +RNAM(E2),RN(E2),RLAB(E2),
     +RNAM(E1),RN(E1),RLAB(E1),
     +A9//'   '
*
      ENDIF
41    CONTINUE
      WRITE(70,1003) NT(1)
      ENDIF
*
* beta turns.
*
      IF (NT(2).GT.0) THEN
*
* write header.
*
      WRITE(70,1002)
*
* work through turns.
*
      DO 42 I=1,NT(2)
*
* get pointers.
*
      I1=INT1(I,2)
      I2=INT2(I,2)
      E1=POS(4,I1,I2)
      I1=I1-3
      E2=POS(4,I1,I2)
*
* error trap.
*
      IF (E1.GT.0.AND.E2.GT.0) THEN
*
* get main chain conformations.
*
      SMB2=ASYMB(I1,I2)
      A12(1:3)=SMB2//' '
      SMB2=ASYMB(I1+1,I2)
      A12(4:6)=SMB2//' '
      SMB2=ASYMB(I1+2,I2)
      A12(7:9)=SMB2//' '
      SMB2=ASYMB(I1+3,I2)
      A12(10:12)=SMB2//' '
*
* write turn to file.
*
      WRITE(70,1001) 
     +RNAM(E2),RN(E2),RLAB(E2),
     +RNAM(E1),RN(E1),RLAB(E1),A12
*
      ENDIF
42    CONTINUE
*
* write total number found.
*
      WRITE(70,1003) NT(2)
      ENDIF
*
* Close empty file.
*
      IF (NT(1).LT.1.AND.NT(2).LT.1) THEN
      CLOSE(UNIT=70,DISPOSE='DELETE')
      ENDIF
*
* format statements.
*
1000  FORMAT(/'  Gamma turns:'/)
1001  FORMAT(3X,A3,I4,A1,' - ',A3,I4,A1,' -',3X,A12)
1002  FORMAT(/'  Beta turns:'/)
1003  FORMAT(/' Total number of turns:',I6)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Create DRF nomenclature of sheet joining.
*
      SUBROUTINE SHTSMI(IOUT,ISHEET,ICHL)
*
* Declarations.
*
      INTEGER ISHEET,ICHL
*
* initialise.
*
      CALL INITSM(ISHEET,ICHL)
*
* write toplogy.
*
      CALL WRSMIL(IOUT,ISHEET,ICHL)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* initialise smiles strings.
*
      SUBROUTINE INITSM(ISHEET,ICHL)
*
* declarations.
*
      INTEGER I,J,ISHEET,ICHL,I1,I2,RNGNUM
      CHARACTER A1*1
*
      INCLUDE 'FOLD.INC'
*
* work through strings.
*
      DO 1 I=1,SHTLEN(ISHEET,ICHL)
*
* default string.
*
      IF (SHNCON(I,ISHEET,ICHL).GT.0) THEN
*
      DO 11 J=1,50
      TOPLINE(I)(J:J)=' '
11    CONTINUE
*
* get letter of strand connection.
*
      IF (REDDEC.EQ.1) THEN
      CALL NUMLET(I,A1)
      ELSE
      IFK=SHEETS(I,ISHEET,ICHL)
      CALL NUMLET(IFK,A1)
      ENDIF
*
      TOPLINE(I)(1:1)=A1
*
      ENDIF
*
1     CONTINUE
*
* reinitialise.
*
      RNGNUM=0
      IRING=SHTRNG(ISHEET,ICHL)
*
* found all rings. now modify connectivity information.
*
      DO 30 I=1,IRING
*
* increase ring counter
*
      RNGNUM=RNGNUM+1
* 
* get pointers.
*
      I1=RNGLST(1,I,ISHEET,ICHL)
      I2=RNGLST(RNGLEN(I,ISHEET,ICHL),I,ISHEET,ICHL)
*
* modify connections.
*
      DO 31 J=1,SHNCON(I1,ISHEET,ICHL)
      IF (SHICON(J,I1,ISHEET,ICHL).EQ.I2) THEN
      SHICON(J,I1,ISHEET,ICHL)=-ABS(SHICON(J,I1,ISHEET,ICHL))
      ENDIF
31    CONTINUE
*
      DO 32 J=1,SHNCON(I2,ISHEET,ICHL)
      IF (SHICON(J,I2,ISHEET,ICHL).EQ.I1) THEN
      SHICON(J,I2,ISHEET,ICHL)=-ABS(SHICON(J,I2,ISHEET,ICHL))
      ENDIF
32    CONTINUE
*
* write orientation
*
      A1=' '
      IF (ORISHT(I1,I2,ICHL).EQ.0) A1='x'
*
* write broken bonds to smiles file.
*
      IF (RNGNUM.LT.10) THEN
*
* less than 10 ring closures.
*
      WRITE(TOPLINE(I1)(42:46),1000) A1,RNGNUM
      CALL PACK(TOPLINE(I1))
*
      WRITE(TOPLINE(I2)(42:46),1000) A1,RNGNUM
      CALL PACK(TOPLINE(I2))
*
      ELSE
*
* more than 10 ring closures.
*
      WRITE(TOPLINE(I1)(42:49),1010) A1,RNGNUM
      CALL PACK(TOPLINE(I1))
*
      WRITE(TOPLINE(I2)(42:49),1010) A1,RNGNUM
      CALL PACK(TOPLINE(I2))
      ENDIF
*
30    CONTINUE
*
* formats statements.
*
1000  FORMAT(A1,I4)
1010  FORMAT(A1,'%',I6)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* find longest path through an acyclic graph which has at least one branching 
* point.
*
      SUBROUTINE WRSMIL(IOUT,ISHEET,ICHL)
*
* Declarations.
*
      INTEGER NLIST,IFAIL,IOUT,SCON(1000),PBIG,
     +P(1000),ILIST(1000),NLAST,ILAST(1000),IMRK(1000),NCON(1000),
     +ICON(100,1000),ISHEET,ICHL,ITOP
*
      CHARACTER FLINE*2000,A1*1,FLINE2*500
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      ITOP=1
      FLINE2='                                                        
     +                                                             
     +                                                             
     +                                                             '
      FLINE='                                                        
     +                                                             
     +                                                             
     +                                                             '
*
      CALL NUMLET(ISHEET,A1)
      FLINE2(1:10)=
     +MOLNAME(1:4)//' '//CCLIS(ICHL:ICHL)//'_'//A1//': '
      ITOP=11
*
      IFAIL=0
      NLAST=0
      DO 6 I=1,SHTLEN(ISHEET,ICHL)
      NCON(I)=SHNCON(I,ISHEET,ICHL)
      IF (SHNCON(I,ISHEET,ICHL).GT.0) THEN
      ILAST(I)=0
      IMRK(I)=0
      SCON(I)=0
      DO 61 J=1,NCON(I)
      ICON(J,I)=SHICON(J,I,ISHEET,ICHL)
      IF (ICON(J,I).GT.0) SCON(I)=SCON(I)+1
61    CONTINUE
      ENDIF
6     CONTINUE
*
* get spanning tree.
*
      IFK=SHTLEN(ISHEET,ICHL)
      CALL SPTREE(
     +IFK,NLIST,PBIG,ILIST,P,SCON,NCON,ICON)
*
* mark atoms of main chain.
*
      DO 770 I=1,NLIST
      IF (ILIST(I).LT.1) ILIST(I)=0
      P(ILIST(I))=-1
770   CONTINUE
*
* copy sheet identification to smiles.
*
      CALL NUMLET(ISHEET,A1)
      FLINE(1:10)=
     +MOLNAME(1:4)//' '//CCLIS(ICHL:ICHL)//'_'//A1//': '
      IL=10
*
* now write smiles.
*
      WRITE(IOUT,1668)
      CALL TOPOUT(IOUT,IL,ILIST(1),0,ISHEET,ICHL,FLINE,ITOP,FLINE2)
*
* work through main chain.
*
      DO 107 I=2,NLIST
*
      K1=ILIST(I)
*
      IF (K1.GT.0) THEN
*
      K2=ILIST(I-1)
      K3=ILIST(I+1)
*
* write smiles for this main chain atom.
*
      CALL TOPOUT(IOUT,IL,K1,K2,ISHEET,ICHL,FLINE,ITOP,FLINE2)
*
* is it branched.
*
      IF (SCON(K1).GT.2) THEN
*
400   CONTINUE
*
      NLAST=0
*
* find pointers to branches. longest first.
*
      P1=0
      ID=0
      DO 20 J=1,NCON(K1)
      I1=ICON(J,K1)
      IF (I1.GT.0) THEN
      IF (I1.EQ.K2.OR.I1.EQ.K3) THEN
      ELSE
      IF (P(I1).GT.P1) THEN
      P1=P(I1)
      ID=I1
      ENDIF
      ENDIF
      ENDIF
20    CONTINUE
*
* check we have found all branches.
*
      IF (ID.EQ.0) THEN
      ELSE
*
      IT=ID
      IPART=K1
*
      P(IT)=-1
*
* write bracket.
*
      IL=IL+1
      FLINE(IL:IL)='('
*
600   CONTINUE
*
* error trap.
*
      IT=ABS(IT)
      IF (IT.LT.1) THEN
      GOTO 400
      ENDIF
*
* reach a terminal node.
*
      IF (SCON(IT).EQ.1) THEN
*
* write this atom.
*
      CALL TOPOUT(IOUT,IL,IT,IPART,ISHEET,ICHL,FLINE,ITOP,FLINE2)
*
* write closing bracket.
* 
      IL=IL+1
      FLINE(IL:IL)=')'
*
* go back to last branching point.
*
      IF (NLAST.LT.1) THEN
      GOTO 400
      ELSE
      IT=ILAST(NLAST)
      GOTO 600
      ENDIF
*
* move up linear branch.
*
      ELSEIF (SCON(IT).EQ.2) THEN
*
* write this atom.
*
      CALL TOPOUT(IOUT,IL,IT,IPART,ISHEET,ICHL,FLINE,ITOP,FLINE2)
*
* get pointer to next atom.
*
      P1=PBIG+1
      ID=0
      IJ=0
*
* find shortest connection of this branch.
*
      DO 347 J=1,NCON(IT)
      I1=ICON(J,IT)
      IF (I1.GT.0) THEN
      IF (P(I1).GT.0) THEN
      IJ=IJ+1
      IF (P(I1).LT.P1) THEN
      P1=P(I1)
      ID=I1
      ENDIF
      ENDIF
      ENDIF
347   CONTINUE
*
      IPART=IT
      IT=ID
      P(IT)=-1
*
* error trap.
*
      IF (ID.LT.1) THEN
      IF (NLAST.LT.1) THEN
      GOTO 400
      ELSE
      IT=ILAST(NLAST)
      GOTO 600
      ENDIF
      ENDIF
*
* go to next atom.
*
      GOTO 600
*
* branching point.
*
      ELSEIF (SCON(IT).GT.2) THEN
*
      P1=PBIG+1
      ID=0
      IJ=0
*
* find shortest connection of this branch.
*
      DO 307 J=1,NCON(IT)
      I1=ICON(J,IT)
      IF (I1.GT.0) THEN
      IF (P(I1).GT.0) THEN
      IJ=IJ+1
      IF (P(I1).LT.P1) THEN
      P1=P(I1)
      ID=I1
      ENDIF
      ENDIF
      ENDIF
307   CONTINUE
*
* have all connections been used.
*
      IF (ID.EQ.0.OR.IJ.EQ.0) THEN
*
* end of this main chain branch.
*
      IF (NLAST.LT.2) GOTO 400
*
* go back to last branching point.
*
      NLAST=NLAST-1
      IT=ILAST(NLAST)
      GOTO 600
      ENDIF
*
* write this atom.
*
      IF (IMRK(IT).EQ.0) THEN
      CALL TOPOUT(IOUT,IL,IT,IPART,ISHEET,ICHL,FLINE,ITOP,FLINE2)
      ENDIF
*
* write bracket for branches.
*
      IF (IJ.GT.1) THEN
      IL=IL+1
      FLINE(IL:IL)='('
      ENDIF
*
* save this atom. branch.
*
      NLAST=NLAST+1
      ILAST(NLAST)=IT
      IMRK(IT)=1
      IPART=IT
      IT=ID
*
      P(IT)=-1
*
      GOTO 600
*
* reached a terminal atom.
*
      ELSE
      IF (NLAST.LT.1) THEN
      GOTO 400
      ELSE
      IT=ILAST(NLAST)
      GOTO 600
      ENDIF
      ENDIF
*
      ENDIF
      ENDIF
      ENDIF
*
107   CONTINUE
*
* write overhanging line.
*
      CALL PACK1(IL,FLINE)
      CALL PACK1(ITOP,FLINE2)
*
      WRITE(12,1667) 
      CALL WRLINE(12,ABS(ITOP)-1,
     +FLINE2(1:ABS(ITOP-2))//'.')
      CALL WRLINE(IOUT,IL,FLINE)
*
* format statements.
*
1000  FORMAT(' Topology string too long. Not written.')
1667  FORMAT(/' Topological summary: '/)
1668  FORMAT(/' Topology based on Joining: '/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Write out topology file.
*
      SUBROUTINE TOPOUT(IOUT,IL,K1,K2,ISHEET,ICHL,FLINE,ITOP,FLINE2)
*
* Declarations.
*
      INTEGER IL,IOUT,ISHEET,ICHL,K1,K2,E1,ITOP
      CHARACTER FLINE*2000,FLINE2*500
      CHARACTER TOPSMB*5
*
      INCLUDE 'FOLD.INC'
*
* error trap.
*
      IF (K1.LT.1) RETURN
*
* Get pointer.
*
      E1=SHEETS(K1,ISHEET,ICHL)
      E2=SHEETS(K2,ISHEET,ICHL)
*
* get sequence distance.
*
      IF (REDDEC.EQ.1) THEN
      ID=ABS(K1-K2)
      ELSE
      ID=ABS(E1-E2)
      ENDIF
*
* write sheet topology.
*
      IORI=1
      IF (E1.GT.0.AND.E2.GT.0) THEN
      IF (ORISHT(E1,E2,ICHL).EQ.0) IORI=0
      ENDIF
*
* write orientation to topology string.
*
      IF (IORI.EQ.0) THEN
      IL=IL+1
      FLINE(IL:IL)='x'
      ENDIF
*
* work through this string.
*
      DO 2 IK=1,50
*
* trap white space.
*
      IF (TOPLINE(K1)(IK:IK).NE.' ') THEN
*
* copy to output file.
*
      IL=IL+1
      FLINE(IL:IL)=TOPLINE(K1)(IK:IK)
*
* write string.
*
      IF (IL.EQ.2000) THEN
      WRITE(IOUT,1000) FLINE
      IL=0
      ENDIF
      ENDIF
*
2     CONTINUE
*
* Now write strands in connectedness order.
*
      IF (K2.EQ.0) THEN
      WRITE(IOUT,1654) STRAND1(E1,ICHL),STRAND2(E1,ICHL)
      ELSE
*
      IF (K1.GT.K2) THEN
*
* positive
*
      IF (IORI.EQ.1) THEN
*
* antiparallel.
*
      WRITE(TOPSMB(1:4),1653) ID
      WRITE(IOUT,1652) STRAND1(E1,ICHL),STRAND2(E1,ICHL),TOPSMB(1:4)
      FLINE2(ITOP:ITOP+3)=TOPSMB(1:3)//','
      ITOP=ITOP+4
      ELSE
*
* parallel.
*
      WRITE(TOPSMB(1:5),1663) ID
      WRITE(IOUT,1662) STRAND1(E1,ICHL),STRAND2(E1,ICHL),TOPSMB(1:5)
      FLINE2(ITOP:ITOP+4)=TOPSMB(1:4)//','
      ITOP=ITOP+5
      ENDIF
*
      ELSEIF (K2.GT.K1) THEN
*
* negative.
*
      IF (IORI.EQ.1) THEN
*
* antiparallel.
*
      WRITE(TOPSMB(1:4),1655) ID
      WRITE(IOUT,1652) STRAND1(E1,ICHL),STRAND2(E1,ICHL),TOPSMB(1:4)
      FLINE2(ITOP:ITOP+4)=TOPSMB(1:3)//','
      ITOP=ITOP+4
      ELSE
*
* parallel.
*
      WRITE(TOPSMB(1:5),1665) ID
      WRITE(IOUT,1662) STRAND1(E1,ICHL),STRAND2(E1,ICHL),TOPSMB(1:5)
      FLINE2(ITOP:ITOP+4)=TOPSMB(1:4)//','
      ITOP=ITOP+5
      ENDIF
      ENDIF
*
      ENDIF
*
* Format statements.
*
1000  FORMAT(/' Summary of topology: '/,
     +A2000)
*
1652  FORMAT('      Strand:',I5,I5,3X,A4)
1662  FORMAT('      Strand:',I5,I5,3X,A5)
1654  FORMAT('      Strand:',I5,I5)
1664  FORMAT('      Strand:',I5,I5)
*
1667  FORMAT(/' Topological summary: '/,A)
*
1653  FORMAT('+',I2,'.')
1655  FORMAT('-',I2,'.')
1663  FORMAT('+',I2,'x.')
1665  FORMAT('-',I2,'x.')
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* find longest path through an acyclic graph which has at least one branching 
* point.
*
      SUBROUTINE SPTREE(INODE,NLIST,PBIG,ILIST,P,SCON,NCON,ICON)
*
* Declarations.
*
      INTEGER N1,LCON(1000),NLIST,ITEMP(1000),
     +P(1000),LCON1(1000),ILIST(1000),SCON(1000),ICOUNT,PBIG,
     +ICON(100,1000),NCON(1000),INODE
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      NLIST=0
      DO 6 I=1,INODE
      P(I)=1
      LCON(I)=SCON(I)
      LCON1(I)=SCON(I)
      ILIST(I)=0
6     CONTINUE
*
* top of loop.
*
100   CONTINUE
*
* reinitialise.
*
      N1=0
*
* work through and find all singly connected atoms.
*
      DO 2 I=1,INODE
*
      IF (LCON(I).EQ.1) THEN
*
      LCON(I)=0
*
      ICOUNT=P(I)
*
      I1=I
*
200   CONTINUE
*
      N1=N1+1
      P(I1)=ICOUNT
      LCON(I1)=0
*
      DO 3 J=1,NCON(I1)
      I2=ICON(J,I1)
      IF (I2.GT.0) THEN
      IF (LCON(I2).EQ.2) THEN
      ICOUNT=ICOUNT+1
      IF (P(I2).GT.ICOUNT) ICOUNT=P(I2)
      I1=I2      
      GOTO 200
      ELSEIF (LCON(I2).GT.2) THEN
      LCON1(I2)=LCON1(I2)-1
      P(I2)=MAX(P(I2),ICOUNT+1)
      GOTO 2
      ENDIF
      ENDIF
3     CONTINUE
*      
      ENDIF
2     CONTINUE
*
      IF (N1.GT.0) THEN
      DO 50 I=1,INODE
      IF (LCON(I).GT.0) THEN
      LCON(I)=MAX(0,LCON1(I))
      ELSE
      LCON1(I)=0
      ENDIF
50    CONTINUE
      GOTO 100
      ENDIF
*
* get node furthest from outside of graph.
*
      PBIG=0
      IBIG=0
      DO 10 I=1,INODE
      IF (P(I).GT.PBIG) THEN
      IBIG=I
      PBIG=P(I)
      ENDIF
10    CONTINUE
*
      IDEC=1
      NLIST=0
      P(IBIG)=-1
*
* now find longest path.
*
300   CONTINUE
*
      IT=0
      P1=0
      DO 11 I=1,NCON(IBIG)
      IJ=ICON(I,IBIG)
      IF (IJ.GT.0) THEN
      IF (P(IJ).GT.P1) THEN
      IT=IJ
      P1=P(IJ)
      ENDIF
      ENDIF
11    CONTINUE
*
      P(IT)=-1
      NLIST=NLIST+1
      ILIST(NLIST)=IT
*
301   CONTINUE      
*
      IF (IT.GT.0) THEN
*
      I1=0
      P1=0
      DO 12 I=1,NCON(IT)
      IJ=ICON(I,IT)
      IF (IJ.GT.0) THEN
      IF (P(IJ).GT.P1) THEN
      I1=IJ
      P1=P(IJ)
      ENDIF
      ENDIF
12    CONTINUE
*
      IF (I1.EQ.0.OR.P1.EQ.0) THEN
      ELSE
*
      IT=I1
      P(IT)=-1
      NLIST=NLIST+1
      ILIST(NLIST)=IT
*
      IF (P1.GT.1) GOTO 301
*
      ENDIF
      ENDIF
*
* invert first list.
*
      IF (IDEC.EQ.1) THEN
*
      DO 15 I=1,NLIST
      ITEMP(I)=ILIST(I)
15    CONTINUE
*
      IU=0
      DO 16 I=NLIST,1,-1
      IU=IU+1
      ILIST(IU)=ITEMP(I)
16    CONTINUE
*
      NLIST=NLIST+1
      ILIST(NLIST)=IBIG
*
      IMIDP=NLIST
*
      IDEC=0
*
* return for second half of list.
*
      GOTO 300
      ENDIF
*
* invert list, if needed, so smallest terminii first.
*
      IF (ILIST(1).GT.ILIST(NLIST)) THEN
*
      DO 148 I=1,NLIST
      ITEMP(I)=ILIST(I)
148   CONTINUE
*
      IU=0
      DO 149 I=NLIST,1,-1
      IU=IU+1
      ILIST(IU)=ITEMP(I)
149   CONTINUE
*
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* write a string without trailing spaces.
*
      SUBROUTINE WRLINE(IOUT,ILEN,LINE)
*
* Declarations.
*
      INTEGER ILEN,IOUT
*
      CHARACTER LINE*(*)
      CHARACTER CC*9
*
* error trap.
*
      IF (ILEN.GT.0.AND.ILEN.LT.1000000) THEN
*
* write line of known length.
*
      IF (ILEN.GT.99999) THEN
      WRITE(CC,105) '(A',ILEN,')'
      ELSE
      IF (ILEN.GT.9999) THEN
      WRITE(CC,104) '(A',ILEN,') '
      ELSE
      IF (ILEN.GT.999) THEN
      WRITE(CC,103) '(A',ILEN,')  '
      ELSE
      IF (ILEN.GT.99) THEN
      WRITE(CC,102) '(A',ILEN,')   '
      ELSE
*
      IF (ILEN.GT.9) THEN
      WRITE(CC,101) '(A',ILEN,')    '
      ELSE
      WRITE(CC,100) '(A',ILEN,')     '
      ENDIF
*
      ENDIF
      ENDIF
      ENDIF
      ENDIF
*
* write line to output file.
*
      WRITE(IOUT,CC) LINE(1:ILEN)
*
      ENDIF
*
* format statements.
*
100   FORMAT(A2,I1,A6)
101   FORMAT(A2,I2,A5)
102   FORMAT(A2,I3,A4)
103   FORMAT(A2,I4,A3)
104   FORMAT(A2,I5,A2)
105   FORMAT(A2,I6,A1)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* pack a string.
*
      SUBROUTINE PACK(AA)
*
* Declarations.
*
      CHARACTER AA*50,VV*50
*
      INTEGER I,J
*
* work through string.
*
      J=0
      DO 1 I=1,50
      VV(I:I)=' '
      IF  (AA(I:I).NE.' ') THEN
      J=J+1
      VV(J:J)=AA(I:I)
      ENDIF
1     CONTINUE
*
* copy back packed string.
*
      AA=VV
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* delete duplicates from the bond connection table.
*
      SUBROUTINE BNDDUP(INODE,NCON,ICON)
*
* Declarations.
*
      INTEGER INODE,NCON(1000),ICON(100,1000)
*
* work through all atoms.
*
      DO 1 I=1,INODE
*
      DO 2 J=1,NCON(I)
      I1=ICON(J,I)
      IF (I1.GT.0) THEN
      DO 3 K=(J+1),NCON(I)
      I2=ICON(K,I)
      IF (I1.EQ.I2) ICON(K,I)=0
3     CONTINUE
      ENDIF
2     CONTINUE
*
* compress bond list.
*
      CALL COMPRESS(I,NCON,ICON)
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* compress connectivity list.
*
      SUBROUTINE COMPRESS(IP,NCON,ICON)
*
* Declarations.
*
      INTEGER NEWCON(1000),IP,J,II,NCON(1000),ICON(100,1000)
*
* Error trap.
*
      IF (IP.LT.1) THEN
      ELSE
*
* initialise
*
      II=0
*
* Process next atom.
*
      DO 5 J=1,NCON(IP)
*
      NEWCON(J)=0
*
      IF (ICON(J,IP).EQ.0) THEN
      ELSE
      II=II+1
      NEWCON(II)=ABS(ICON(J,IP))
      ENDIF
*
5     CONTINUE
*
* write new lists. 
*
      NCON(IP)=II
*
      DO 6 J=1,8
      ICON(J,IP)=NEWCON(J)
6     CONTINUE
*
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get Richardson's Topology of sheet joining.
*
      SUBROUTINE RICHARD(ISHEET,ICHL)
*
* Declarations.
*
      INTEGER ISHEET,ICHL
      INTEGER IRICH,INOW,IDOI,IDOJ,IDIJ
      INTEGER J2,J3,JJ
*
      INCLUDE 'FOLD.INC'
*
* Assign Richardson topology.
*
      INOW=0
*
* work through strands of this sheet.
*
      DO 1 J=1,SHTLEN(ISHEET,ICHL)
*
* get topology of strand connections.
* 
      IF (J.LT.3) THEN
*
      J2=SHEETS(J-1,ISHEET,ICHL)
      J3=SHEETS(J,ISHEET,ICHL)
      SHTTOP(J,ISHEET,ICHL)=LNKSHT(J3,J2,ICHL)
      SHTORI(J,ISHEET,ICHL)=ORISHT(J3,J2,ICHL)
*
      ELSE
*
* get pointers.
*
      JJ=SHEETS(J,ISHEET,ICHL)
      J2=SHEETS(J-1,ISHEET,ICHL)
      J3=SHEETS(J-2,ISHEET,ICHL)
*
* get distances.
*
      IDIJ=LNKSHT(J2,JJ,ICHL)
      IDOJ=LNKSHT(J3,JJ,ICHL)
      IDOI=LNKSHT(J3,J2,ICHL)
*
* logic to get distance and direction.
*
      CALL RICHTOP(INOW,IDOI,IDOJ,IDIJ,IRICH)
*
* record it.
*
      SHTTOP(J,ISHEET,ICHL)=IDIJ*IRICH
      SHTORI(J,ISHEET,ICHL)=ORISHT(J2,JJ,ICHL)
*
      ENDIF
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get Richardson topology of an open sheet.
*
      SUBROUTINE RICHTOP(INOW,DOI,DOJ,DIJ,IRICH)
*
* Declarations.
*
      INTEGER INOW,DOI,DOJ,DIJ,IRICH
*
* Is it plus or minus.
*
      IF (INOW.GT.0) THEN
*
       IF (DOJ.EQ.(DOI+DIJ)) THEN
        INOW=1
        IRICH=-1
        RETURN
       ELSE
        IF (DOI.EQ.(DOJ+DIJ)) THEN
         INOW=1
         IRICH=1
         RETURN
        ELSE IF (DIJ.EQ.(DOI+DOJ)) THEN
         INOW=-1
         IRICH=1
         RETURN
        ENDIF
       ENDIF
*
      ELSE IF (INOW.LT.1) THEN
*
       IF (DOJ.EQ.(DOI+DIJ)) THEN
        INOW=-1
        IRICH=1
        RETURN
       ELSE
        IF (DOI.EQ.(DOJ+DIJ)) THEN
         INOW=-1
         IRICH=-1
         RETURN
        ELSE IF (DIJ.EQ.(DOI+DOJ)) THEN
         INOW=1
         IRICH=-1
         RETURN
        ENDIF
       ENDIF
*
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* display topology of strands.
*
      SUBROUTINE TOPDIS(IORIENT,ITOPOL,ITOP,E1,ISHEET,TSLINE)
*
* Declarations.
*
      INTEGER IORIENT,ITOPOL,ITOP,E1,ISHEET
      CHARACTER TOPSMB*5,TSLINE*80
      INCLUDE 'FOLD.INC'
*
      IF (IORIENT.EQ.1) THEN
*
* Antiparallel.
*
      IF (ITOPOL.GT.0) THEN
      WRITE(TOPSMB(1:4),1653) ABS(ITOPOL)
      TSLINE(ITOP:ITOP+3)=TOPSMB(1:3)//','
      ITOP=ITOP+4
      WRITE(12,1652) 
     +STRAND1(E1,ISHEET),STRAND2(E1,ISHEET),TOPSMB(1:4)
      ELSEIF (ITOPOL.EQ.0) THEN
      WRITE(12,1654) STRAND1(E1,ISHEET),STRAND2(E1,ISHEET)
      ELSEIF (ITOPOL.LT.0) THEN
      WRITE(TOPSMB(1:4),1655) ABS(ITOPOL)
      TSLINE(ITOP:ITOP+3)=TOPSMB(1:3)//','
      ITOP=ITOP+4
      WRITE(12,1652) 
     +STRAND1(E1,ISHEET),STRAND2(E1,ISHEET),TOPSMB(1:4)
      ENDIF
*
      ELSE
*
* parallel.
*
      IF (ITOPOL.GT.0) THEN
      WRITE(TOPSMB,1663) ABS(ITOPOL)
      TSLINE(ITOP:ITOP+4)=TOPSMB(1:4)//','
      ITOP=ITOP+5
      WRITE(12,1662) 
     +STRAND1(E1,ISHEET),STRAND2(E1,ISHEET),TOPSMB
      ELSEIF (ITOPOL.EQ.0) THEN
      WRITE(12,1664) STRAND1(E1,ISHEET),STRAND2(E1,ISHEET)
      ELSEIF (ITOPOL.LT.0) THEN
      WRITE(TOPSMB,1665) ABS(ITOPOL)
      TSLINE(ITOP:ITOP+4)=TOPSMB(1:4)//','
      ITOP=ITOP+5
      WRITE(12,1662) 
     +STRAND1(E1,ISHEET),STRAND2(E1,ISHEET),TOPSMB
      ENDIF
*
      ENDIF
*
* format statements.
*
1652  FORMAT('      Strand:',I5,I5,3X,A4)
1662  FORMAT('      Strand:',I5,I5,3X,A5)
1654  FORMAT('      Strand:',I5,I5)
1664  FORMAT('      Strand:',I5,I5)
1653  FORMAT('+',I2,'.')
1655  FORMAT('-',I2,'.')
1663  FORMAT('+',I2,'x.')
1665  FORMAT('-',I2,'x.')
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* pack a string.
*
      SUBROUTINE PACK1(IL,AA)
*
* Declarations.
*
      CHARACTER AA*80,VV*80
*
      INTEGER I,J
*
* work through string.
*
      J=0
      DO 1 I=1,80
      VV(I:I)=' '
      IF (AA(I:I).EQ.':'.OR.AA(I:I).EQ.',') THEN
      J=J+1
      VV(J:J)=AA(I:I)
      J=J+1
      VV(J:J)=' '
      ELSEIF (AA(I:I).NE.' ') THEN
      J=J+1
      VV(J:J)=AA(I:I)
      ENDIF
1     CONTINUE
*
* copy back packed string.
*
      IL=J
      AA=VV
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Within ring sequence distance.
*
      SUBROUTINE SIRING(IRING,ISHEET,ICHAIN,P)
*
* Declarations.
*
      INTEGER ISHEET,ICHAIN,IRING,P(100),IDN(100),P1(100)
*
      INCLUDE 'FOLD.INC'
*
      DO 2 I=1,100
      P(I)=0
2     CONTINUE
*
      II=0
      IZ=RNGLEN(IRING,ISHEET,ICHAIN)
      DO 1 I=1,IZ
*
      K1=RNGLST(I,IRING,ISHEET,ICHAIN)
*
      IF (K1.GT.0) THEN
      II=II+1
      P1(II)=K1
      ENDIF
*
1     CONTINUE
*
      CALL ISORT(II,P1,IDN)
*
      DO 3 I=1,II
      K1=IDN(I)
      P(P1(K1))=I
3     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* calculate RCBs and paths of all rings.
*
      SUBROUTINE RNGORD(IDEL,NLIST,ILIST)
*
* Declarations.
*
      INTEGER IDEL,ILOW,ILOC
      INTEGER NLIST(100),ILIST(100,100),JLIST(200)
*
* do all rings.
*
      DO 10 IU=1,IDEL
*
* get ring to start with lowest member.
*
      ILOW=2000000
*
      DO 1 IZ=1,NLIST(IU)
      IF (ILOW.GT.ILIST(IZ,IU)) THEN
      ILOW=ILIST(IZ,IU)
      ILOC=IZ
      ENDIF
1     CONTINUE
*
* copy reordered ring list.
*
      IF (ILOC.GT.1) THEN
      IT1=0
      DO 2 IZ=ILOC,NLIST(IU)
      IT1=IT1+1
      JLIST(IT1)=ILIST(IZ,IU)
2     CONTINUE
      DO 3 IZ=1,ILOC-1
      IT1=IT1+1
      JLIST(IT1)=ILIST(IZ,IU)
3     CONTINUE
      IT1=NLIST(IU)
      ELSE
      IT1=NLIST(IU)
      DO 7 I=1,IT1
      JLIST(I)=ILIST(I,IU)
7     CONTINUE
      ENDIF
*
* re-order.
*
      IF (JLIST(2).LT.JLIST(IT1)) THEN
      DO 4 IZ=1,IT1
      ILIST(IZ,IU)=JLIST(IZ)
4     CONTINUE
      ELSE
      ILIST(1,IU)=JLIST(1)
      IT2=1
      DO 5 IZ=IT1,2,-1
      IT2=IT2+1
      ILIST(IT2,IU)=JLIST(IZ)
5     CONTINUE
      ENDIF
*
10    CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* simple but fairly robust parser.
*     picks up lists of integer and real numbers. 
*     plus a letter if it follows an integer directly.
*
* nb:
*
*  ILAST = 0 not a number.
*  ILAST = 1 integer number.
*  ILAST = 2 real number.
*
      SUBROUTINE LRDRF(A,N,IH,FH,CH,NN)
*
* decalarations.
*
      IMPLICIT INTEGER (A-Z)
*
      INTEGER J1,N,NN,PP,I,ILAST,FCOUNT,FFT
      INTEGER IH(80),MULT(80)
*
      REAL FH(80)
*
      CHARACTER A*(*),CH(80)*1 
*
* initialise.
*
      DO 10 I=1,80
      IH(I)=0
      FH(I)=0.0
      CH(I)=' '
10    CONTINUE
*
      J1=1
      ILAST=0
      IH(J1)=0
      FH(J1)=0.0
      MULT(J1)=1
      FCOUNT=1
*
* Work through line.
*
      DO 2 I=1,N
      PP=INDEX('0123456789',A(I:I))
*
      IF (PP.GT.0) THEN
*
      IF (ILAST.NE.2) THEN
* integer
      ILAST=1
      IH(J1)=(IH(J1)*10)+(PP-1)
      ELSE
* real
      FFT=10**FCOUNT
      FH(J1)=FH(J1)+(FLOAT(PP-1)/FLOAT(FFT))
      FCOUNT=FCOUNT+1
      ENDIF
*
* get sign.
*
      IF (A(I-1:I-1).EQ.'-') MULT(J1)=-1
*
      ELSE
*
* found a decimal point.
*
      IF (A(I:I).EQ.'.') THEN 
      ILAST=2
      FCOUNT=1
      FH(J1)=FLOAT(IH(J1))
      IH(J1)=0
* get sign.
      IF (A(I-1:I-1).EQ.'-') MULT(J1)=-1
      GOTO 2
      ENDIF
*
* get chain label.
* 
      IF (ILAST.EQ.1) THEN
      CH(J1)=A(I:I)
      J1=J1+1
      MULT(J1)=1
      IH(J1)=0
      CH(J1)=' '
      ILAST=0
      ENDIF
*
* last was decimal point.
*
      IF (ILAST.EQ.2) THEN
      J1=J1+1
      MULT(J1)=1
      IH(J1)=0
      CH(J1)=' '
      ILAST=0
      ENDIF
*
      ENDIF
*
2     CONTINUE
*
* get number of numbers found.
*
      NN=J1-1
*
* get correct sign for each number.
*
      DO 3 I=1,NN
      IF (MULT(I).EQ.-1) THEN
      IH(I)=-IH(I)
      FH(I)=-FH(I)
      ENDIF
3     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* draw molecule.
*
      SUBROUTINE VIEW
*
* get loops.
*
      CALL GETLOP
*
* get bonds.
*
      CALL GETSSC
      CALL GETBND
*
* display.
*
      CALL VIEWRB
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Actually draw molecule
*
      SUBROUTINE DWCATR(ICATR,ILIG,XG,YG,ZG,DTX,DTY,STX,DTZ)
*
* Declarations.
*
      INTEGER ICATR(20),ILIG,IZMX,IZMN,IAX
      REAL XG(9000),YG(9000),ZG(9000)
      REAL DTX,DTY,STX,DTZ
*
      INCLUDE 'FOLD.INC'
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* set up depth cueing parameters.
*
      IZMN=10
      IZMX=255
*
* draw all bonds.
*
      IF (ICATR(1).EQ.1) THEN
*
      CALL LINEWI(2)
*
      DO 451 I=1,CHL
*
* get first atom colour.
*
      IF  (I.EQ.1) THEN
      CALL LRGBRA(0,IZMN,0,0,IZMX,0,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
      ELSEIF (I.EQ.2) THEN
      CALL LRGBRA(IZMN,0,0,IZMX,0,0,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
      ELSEIF (I.EQ.3) THEN
      CALL LRGBRA(0,0,IZMN,0,0,IZMX,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
      ELSEIF (I.EQ.4) THEN
      CALL LRGBRA(IZMN,IZMN,0,IZMX,IZMX,0,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
      ELSEIF (I.EQ.5) THEN
      CALL LRGBRA(IZMN,0,IZMN,IZMX,0,IZMX,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
      ELSEIF (I.EQ.6) THEN
      CALL LRGBRA(0,IZMN,IZMN,0,IZMX,IZMX,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
      ELSE
      CALL LRGBRA(IZMN,IZMN,IZMN,IZMX,IZMX,IZMX,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
      ENDIF
*
      DO 452 J=RN1(I)+1,RN2(I)
*
      I1=POS(4,J-1,I)
      I2=POS(4,J,I)
*
* Error trap.
*
      IF (I1.GT.0.AND.I2.GT.0) THEN
*
      IF (POS(0,J,I).EQ.1.AND.POS(0,J-1,I).EQ.1) THEN
*
* draw pseudo bond.
*
      CALL MOVE(
     +STX*XG(I1)+DTX,
     +STX*YG(I1)+DTY,
     +STX*ZG(I1)+DTZ)
*
      CALL DRAW(
     +STX*XG(I2)+DTX,
     +STX*YG(I2)+DTY,
     +STX*ZG(I2)+DTZ)
*
      ENDIF
      ENDIF
*
452   CONTINUE
*
451   CONTINUE
*
      ENDIF
*
* call molecular structure.
*
      CALL DWMOL1(XG,YG,ZG,DTX,DTY,STX)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* finds centre of gravity of n atoms. coordinates xbar, ybar, zbar.
*
      SUBROUTINE DRCOFG(NN,XX,YY,ZZ)
*
* Declarations.
*
      INTEGER NN,I,J,K
*
      REAL XX(9000),YY(9000),ZZ(9000),YBAR,XBAR,ZBAR,XN
*
* initialise.
*
      XBAR=0.0
      YBAR=0.0
      ZBAR=0.0
*
* sum coordinates.
*
      DO 1 I=1,NN
      XBAR=XBAR+XX(I)
      YBAR=YBAR+YY(I)
      ZBAR=ZBAR+ZZ(I)
1     CONTINUE
*
* average.
*
      XN=FLOAT(NN)
      XBAR=(XBAR/XN)
      YBAR=(YBAR/XN)
      ZBAR=(ZBAR/XN)
*
* apply translation to centre coordinates.
*
      DO 2 I=1,NN
      XX(I)=XX(I)-XBAR
      YY(I)=YY(I)-YBAR
      ZZ(I)=ZZ(I)-ZBAR
2     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE DRROT(NN,R,XG,YG,ZG)
*
* Declarations.
*
      INTEGER I
*
      REAL XD,YD,ZD,XG(9000),YG(9000),ZG(9000),R(3,3)
*
* apply rotation to all atoms.
*
      DO 2 I=1,NN
      XD=R(1,1)*XG(I)+R(1,2)*YG(I)+R(1,3)*ZG(I)
      YD=R(2,1)*XG(I)+R(2,2)*YG(I)+R(2,3)*ZG(I)
      ZD=R(3,1)*XG(I)+R(3,2)*YG(I)+R(3,3)*ZG(I)
      XG(I)=XD
      YG(I)=YD
      ZG(I)=ZD
2     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* rotate around x axis.
*
      SUBROUTINE DRXROT(R,ANG)
*
* Declarations.
*
      INTEGER I,J,K
*
      REAL R(3,3),ANG,CA,SA
*
* get arguments.
*
      ANG=ANG*(3.14159/180.0)
      CA=COS(ANG)
      SA=SIN(ANG)
*
* create matrix.
*
      R(2,2)=CA
      R(2,3)=SA
      R(3,2)=-SA
      R(3,3)=CA
*
      DO 1 J=1,3
      R(1,J)=0.0
      R(J,1)=0.0
1     CONTINUE
*
      R(1,1)=1.0
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* rotate around y axis.
*
      SUBROUTINE DRYROT(R,ANG)
*
* Declarations.
*
      INTEGER I,J,K
*
      REAL R(3,3),ANG,CA,SA
*
* get arguments.
*
      ANG=ANG*(3.14159/180.0)
      CA=COS(ANG)
      SA=SIN(ANG)
*
* create matrix.
*
      R(1,1)=CA
      R(1,3)=-SA
      R(3,1)=SA
      R(3,3)=CA
*
      DO 1 J=1,3
      R(2,J)=0.0
      R(J,2)=0.0
1     CONTINUE
*
      R(2,2)=1.0
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* rotate around z axis.
*
      SUBROUTINE DRZROT(R,ANG)
*
* Declarations.
*
      INTEGER I,J,K
*
      REAL R(3,3),ANG,CA,SA
*
* get arguments.
*
      ANG=ANG*(3.14159/180.0)
      CA=COS(ANG)
      SA=SIN(ANG)
*
* create matrix.
*
      R(1,1)=CA
      R(1,2)=SA
      R(2,1)=-SA
      R(2,2)=CA
*
      DO 1 J=1,3
      R(3,J)=0.0
      R(J,3)=0.0
1     CONTINUE
*
      R(3,3)=1.0
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Actually draw molecule
*
      SUBROUTINE DWMOL1(XG,YG,ZG,DTX,DTY,STX)
*
* Declarations.
*
      INTEGER I1,I2,IZMN,IZMX
      REAL XG(9000),YG(9000),ZG(9000)
      REAL DTX,DTY,STX
      REAL X1,Y1,Z1,X2,Y2,Z2
*
      INCLUDE 'FOLD.INC'
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* set up depth cueing parameters.
*
      IZMN=10
      IZMX=255
*
* draw covalent bonds.
*
      DO 1 I=1,NBOND
*
* get pointers.
*
      I1=LSTBND(1,I)
      I2=LSTBND(2,I)
*
* local copy of coordinates.
*
      X1=XG(I1)
      Y1=YG(I1)
      Z1=ZG(I1)
*
      X2=XG(I2)
      Y2=YG(I2)
      Z2=ZG(I2)
*
* draw central bond.
*
      CALL
     +DWBND2(ATY(I1),ATY(I2),
     +IZMX,IZMN,X1,X2,Y1,Y2,Z1,Z2,DTX,DTY,STX,DTZ)
*
1     CONTINUE
*
      DO 2 I=1,NHBOND
*
* get pointers.
*
      I1=LSTHBD(1,I)
      I2=LSTHBD(2,I)
*
* local copy of coordinates.
*
      X1=XG(I1)
      Y1=YG(I1)
      Z1=ZG(I1)
*
      X2=XG(I2)
      Y2=YG(I2)
      Z2=ZG(I2)
*
* draw bond.
*
      CALL
     +DWBND2(15,15,IZMX,IZMN,X1,X2,Y1,Y2,Z1,Z2,DTX,DTY,STX,DTZ)
*
2     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* draw a split bond
*
      SUBROUTINE 
     +DWBND2(I1,I2,IZMX,IZMN,X1,X2,Y1,Y2,Z1,Z2,DTX,DTY,STX,DTZ)
*
      INTEGER IZMX,IZMN
      INTEGER I1,I2
      REAL X1,X2,X3,X4,Y1,Y2,Y3,Y4,Z1,Z2,Z3,Z4
      REAL DTX,DTY,STX,DTZ
*
* get first atom colour.
*
      CALL ELECUE(I1,IZMN,IZMX)
*
* draw first half of bond.
*
      CALL MOVE(
     +STX*X1+DTX,
     +STX*Y1+DTY,
     +STX*Z1+DTZ)
*
      CALL DRAW(
     +0.5*STX*(X1+X2)+DTX,
     +0.5*STX*(Y1+Y2)+DTY,
     +0.5*STX*(Z1+Z2)+DTZ)
*
* choose colour.
*
      CALL ELECUE(I2,IZMN,IZMX)
*
* draw second half of bond.
*
      CALL MOVE(
     +0.5*STX*(X1+X2)+DTX,
     +0.5*STX*(Y1+Y2)+DTY,
     +0.5*STX*(Z1+Z2)+DTZ)
      CALL DRAW(
     +STX*X2+DTX,
     +STX*Y2+DTY,
     +STX*Z2+DTZ)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Actually draw molecule
*
      SUBROUTINE ELECUE(I1,IZMN,IZMX)
*
* Declarations.
*
      INTEGER IZMX,IZMN,I1
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* set RGB colour ramps for depth cueing elements.
*
      IF  (I1.EQ.6) THEN
      CALL LRGBRA(0,IZMN,0,0,IZMX,0,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
*
      ELSEIF (I1.EQ.8) THEN
      CALL LRGBRA(IZMN,0,0,IZMX,0,0,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
*
      ELSEIF (I1.EQ.7) THEN
      CALL LRGBRA(0,0,IZMN,0,0,IZMX,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
*
      ELSEIF (I1.EQ.16) THEN
      CALL LRGBRA(IZMN,IZMN,0,IZMX,IZMX,0,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
*
      ELSEIF (I1.EQ.15) THEN
      CALL LRGBRA(IZMN,0,IZMN,IZMX,0,IZMX,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
*
      ELSEIF (I1.EQ.17.OR.I1.EQ.9.OR.I1.EQ.35.OR.I1.EQ.53) THEN
      CALL LRGBRA(0,IZMN,IZMN,0,IZMX,IZMX,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
*
      ELSE
      CALL LRGBRA(IZMN,IZMN,IZMN,IZMX,IZMX,IZMX,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Set colours for atoms in RGB mode.
*
      SUBROUTINE ELECOL(I1,IZMX)
*
* Declarations.
*
      INTEGER IZMX,I1
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* set RGB colour ramps for depth cueing elements.
*
      IF  (I1.EQ.6) THEN
      CALL RGBCOL(0,IZMX,0)
*
      ELSEIF (I1.EQ.8) THEN
      CALL RGBCOL(IZMX,0,0)
*
      ELSEIF (I1.EQ.7) THEN
      CALL RGBCOL(0,0,IZMX)
*
      ELSEIF (I1.EQ.15) THEN
      CALL RGBCOL(IZMX,0,IZMX)
*
      ELSEIF (I1.EQ.16) THEN
      CALL RGBCOL(IZMX,IZMX,0)
*
      ELSEIF (I1.EQ.17.OR.I1.EQ.9.OR.I1.EQ.35.OR.I1.EQ.53) THEN
      CALL RGBCOL(0,IZMX,IZMX)
*
      ELSE
      CALL RGBCOL(IZMX,IZMX,IZMX)
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* draw a split cylinder bond
*
      SUBROUTINE 
     +DWCYLB(I1,I2,IZMX,IZMN,X1,X2,Y1,Y2,Z1,Z2,DTX,DTY,STX,DTZ,ATS)
*
      INTEGER IZMX,IZMN
      INTEGER I1
      REAL X1,X2,X3,X4,Y1,Y2,Y3,Y4,Z1,Z2,Z3,Z4
      REAL DTX,DTY,STX,DTZ,ATS
*
* get first atom colour.
*
      CALL ELECOL(I1,255)
*
* draw first half of bond.
*
      CALL DWBCYL(ATS,
     +STX*X1+DTX,
     +STX*Y1+DTY,
     +STX*Z1+DTZ,
     +0.5*STX*(X1+X2)+DTX,
     +0.5*STX*(Y1+Y2)+DTY,
     +0.5*STX*(Z1+Z2)+DTZ)
*
* choose colour.
*
      CALL ELECOL(I2,255)
*
* draw second half of bond.
*
      CALL DWBCYL(ATS,
     +0.5*STX*(X1+X2)+DTX,
     +0.5*STX*(Y1+Y2)+DTY,
     +0.5*STX*(Z1+Z2)+DTZ,
     +STX*X2+DTX,
     +STX*Y2+DTY,
     +STX*Z2+DTZ)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Draw pointer.
*
      SUBROUTINE DWBCYL(ATS,XX1,YY1,ZZ1,XX2,YY2,ZZ2)
*
* declarations.
*
      REAL V3(3),BV(3,2),D1,D2,D3,CY(500),CX(500)
      REAL DTX,DTZ,DTY,STX,CXX,CYY,CX2,CY2
      REAL XE(3),XS(3),U1(3),U2(3),U3(3),PP(3),UZ(3),UX(3)
      REAL X4(3),XW(3),X3(3),X1(3),X2(3)
      REAL XX1,XX2,YY1,YY2,ZZ1,ZZ2
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* initialise.
*
      DATA UZ / 0.0,0.0,1.0 /
      DATA UX / 1.0,0.0,0.0 /
*
      IUP=0
      PI=3.14159
      DSECT=0.75
      D1=ATS
      D3=0.0
      STX=1.0
*
* get vectors.
*
      XS(1)=XX1
      XS(2)=YY1
      XS(3)=ZZ1
      XE(1)=XX2
      XE(2)=YY2
      XE(3)=ZZ2
*
      DO 1 I=1,3
      V3(I)=XE(I)-XS(I)
1     CONTINUE
*
      CALL NORM3(V3)
*
      DO 12 I=1,3
      U1(I)=V3(I)
12    CONTINUE
*
* get cylinder axis.
*
      CALL NORM3(U1)
*
* two other two orthogonal axes.
*
      IF (ABS(U1(3)).GT.0.9999) THEN
      CALL CROSS3(U2,U1,UX)
      ELSE
      CALL CROSS3(U2,U1,UZ)
      ENDIF
*
      CALL NORM3(U2)
      CALL CROSS3(U3,U2,U1)
      CALL NORM3(U3)
*
* set up points for circle.
*
      M=180
      DTH=2.0*PI/M
      N1=M/4
      N2=M/2
      N3=3*M/4
      THETA=0.0
*
* set up points for circle.
*
      DO 20 JDO=1,180
      A=COS(THETA)
      B=SIN(THETA)
      CX(JDO)=A
      CY(JDO)=B
      CX(JDO+N1)=-B
      CY(JDO+N1)=A
      CX(JDO+N2)=-A
      CY(JDO+N2)=-B
      CX(JDO+N3)=B
      CY(JDO+N3)=-A
      THETA=THETA+DTH
20    CONTINUE
      NPP=M+1
      CX(M+1)=CX(1)
      CY(M+1)=CY(1)
*
* now plot cylinder as the sequence of npp points.
*
      DO 40 II=1,180,10
*
* get circle points.
*
      CXX=CX(II)
      CYY=CY(II)
      CX2=CX(II+10)
      CY2=CY(II+10)
*
* draw main cylinder.
*
      CALL BGNPOL
*
      PP(1)=D1*(U2(1)*CXX+U3(1)*CYY)
      PP(2)=D1*(U2(2)*CXX+U3(2)*CYY)
      PP(3)=D1*(U2(3)*CXX+U3(3)*CYY)
*
      XW(1)=PP(1)+XS(1)
      XW(2)=PP(2)+XS(2)
      XW(3)=PP(3)+XS(3)
*
      CALL NORM3(PP)
*
      CALL N3F(PP)
      CALL V3F(XW)
*
      PP(1)=D1*(U2(1)*CX2+U3(1)*CY2)
      PP(2)=D1*(U2(2)*CX2+U3(2)*CY2)
      PP(3)=D1*(U2(3)*CX2+U3(3)*CY2)
*
      XW(1)=PP(1)+XS(1)
      XW(2)=PP(2)+XS(2)
      XW(3)=PP(3)+XS(3)
*
      CALL NORM3(PP)
      CALL N3F(PP)
      CALL V3F(XW)
*
      PP(1)=D1*(U2(1)*CX2+U3(1)*CY2)
      PP(2)=D1*(U2(2)*CX2+U3(2)*CY2)
      PP(3)=D1*(U2(3)*CX2+U3(3)*CY2)
*
      XW(1)=PP(1)+XE(1)
      XW(2)=PP(2)+XE(2)
      XW(3)=PP(3)+XE(3)
*
      CALL NORM3(PP)
*
      CALL N3F(PP)
      CALL V3F(XW)
*
      PP(1)=D1*(U2(1)*CXX+U3(1)*CYY)
      PP(2)=D1*(U2(2)*CXX+U3(2)*CYY)
      PP(3)=D1*(U2(3)*CXX+U3(3)*CYY)
*
      XW(1)=PP(1)+XE(1)
      XW(2)=PP(2)+XE(2)
      XW(3)=PP(3)+XE(3)
*
      CALL NORM3(PP)
      CALL N3F(PP)
      CALL V3F(XW)
*
      CALL ENDPOL
*
40    CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Actually draw molecule
*
      SUBROUTINE DWLAB2(XG,YG,ZG,DTX,DTY,STX,DTZ)
*
* Declarations.
*
      INTEGER XSIZE,IZMX,IZMN
      REAL XG(9000),YG(9000),ZG(9000)
      REAL X1,X2,X3,X4,Y1,Y2,Y3,Y4,Z1,Z2,Z3,Z4
      REAL DTX,DTY,STX,DTZ,SC(4)
      CHARACTER A4*4
*
      INCLUDE 'FOLD.INC'
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* set colour of label.
*
      IZMN=10
      IZMX=255
      CALL LRGBRA(0,0,IZMN,0,0,IZMX,$0,$7FFFFF)
      CALL DEPTHC(.TRUE.)
*
* draw all labels.
*
      DO 44 I=1,NN
*
* write atom name.
*
      WRITE(A4,4000) ATNAM(I)
*
      X1=STX*XG(I)+DTX
      X2=STX*YG(I)+DTY
      X3=STX*ZG(I)+DTZ
      CALL CMOV(X1,X2,X3)
*
      CALL CHARST(A4,4)
*
44    CONTINUE
*
* format statements.
*
4000  FORMAT(A4)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* draw ribbon representation of protein chain.
*
      SUBROUTINE VIEWRB
*
* Declarations.
*
      INTEGER I,J,K
      INTEGER GID,DEV,IDIS,ILIG,ILAB,ITHK,WMENU,LMENU,IMENU
*
      INTEGER XORIGIN,YORIGIN,XSIZE,YSIZE,IMX,IMY,XOLD,YOLD
      INTEGER*2 VAL,ACTIVE
*
      REAL RX,RY,SCL,DTX,DTY,STX,STY,SAVMAT(4,4),STW,
     +XBAR,YBAR,ZBAR,XN,XL,XD,DTZ
      REAL XG(9000),YG(9000),ZG(9000),ROTMAT(3,3)
      CHARACTER MENUL*80
*
* include statements.
*
      INCLUDE 'FOLD.INC'
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* lighting definitions.
*
      INTEGER*4 MATSIZ,LIGSIZ,MODSIZ,WIDTH,HEIGHT
      PARAMETER (MATSIZ=21,LIGSIZ=14,MODSIZ=12)
*
      REAL OXYGEN(MATSIZ),LIGHT(LIGSIZ),MODEL(MODSIZ)
*
      INTEGER INC,AZIM,FOVY
*
* Initalize data arrays to be passed to initalize lighting properties.
*
      DATA OXYGEN /
     +   AMBIEN, 0.3, 0.3, 0.3,
     +   DIFFUS, 0.5, 0.5, 0.5,
     +   EMISSI, 0.0, 0.0, 0.0,
     +   SPECUL, 1.0, 1.0, 1.0,
     +   SHININ, 64.0,
     +   ALPHA, 0.0,
     +   LMNULL /
*
      DATA LIGHT /
     +   AMBIEN, 0.3, 0.3, 0.3,
     +   LCOLOR, 1.0, 1.0, 1.0,
     +   POSITI, 1.0, 1.0, 1.0, 0.0,
     +   LMNULL /
*
      DATA MODEL /
     +   AMBIEN, 0.3, 0.3, 0.3,
     +   ATTENU, 1.0, 0.0,
     +   LOCALV, 0.0,
     +   204, 1.0,
     +   LMNULL /
*
      INC=0
      AZIM=0
      DIST=5.0
      IDIS=0
      ILIG=0
      ILAB=0
      ITHK=1
*
* Initial processing of coordinates. Copy and Centre.
*
      DO 45 I=1,NN
      XG(I)=X(I)
      YG(I)=Y(I)
      ZG(I)=Z(I)
45    CONTINUE
*
* expand helices.
*
      CALL MODHEL(XG,YG,ZG)
*
* Centre molecule.
*
      CALL DRCOFG(NN,XG,YG,ZG)
*
      XL=0.0
      DO 47 I=1,NN
      XD=
     +XG(I)**2 + 
     +YG(I)**2 + 
     +ZG(I)**2
      IF (XD.GT.XL) XL=XD
47    CONTINUE
*
      XL=SQRT(XL)
*
* Initialise.
*
      DTX=0.0
      DTY=0.0
      DTZ=0.0
      STX=1.0
*
* Setup initial Graphics.
*
      CALL FOREGR
      CALL PREFPO(550,1000,250,700)
*
* Open window.
*
      GID=WINOPE(' FOLD',5)
*
* Activate window.
*
      CALL WINSET(GID)
*
* Change to working Graphics status.
*
      CALL WINCON
      CALL KEEPAS(1,1)
      CALL MINSIZ(250,250)
      CALL WINCON
*
* enable double buffering.
*
      CALL DOUBLE
*
      CALL RGBMOD
*
* get graphics configuration.
*
      CALL GCONFI
*
* Enable Z-buffering.
*
      CALL ZBUFFE(.TRUE.)
*
* Set viewing mode.
*
      CALL MMODE(MVIEWI)
*
* queue input devices.
*
      CALL QDEVIC(WINQUI)
      CALL QDEVIC(MOUSEX)
      CALL QDEVIC(MOUSEY)
      CALL QDEVIC(ESCKEY)
      CALL QDEVIC(F1KEY)
      CALL QDEVIC(LEFTSH)
*
* create menus.
*
      IMENU=NEWPUP()
*
      MENUL=
*      1234567890123456789012345678901234567890123456789012345
     +'Style %t|Ribbon|line|Cylinder %m %l|Exit'
      CALL ADDTOP(IMENU,MENUL(1:40),40,0)
*
* set perspective.
*
      CALL ORTHO(-10.0,10.0,-10.0,10.0,-10.0,10.0)
*
* Set depth cueing off.
*
      CALL DEPTHC(.FALSE.)
*
* Define all the necessary lighting properties : materials, lights, and
* models.  See lmdef for more detail.  The calls to lmdef(), and 
* lmbind, must follow the first call to mmode(MPROJE).  The call to
* mmode(MPROJE) lets the system know that we want to do lighting, and
* will probably be passing along property definitions and the like.
*
      CALL LMDEF(DEFMAT,1,MATSIZ,OXYGEN)
      CALL LMDEF(DEFLIG,1,LIGSIZ,LIGHT)
      CALL LMDEF(DEFLMO,1,MODSIZ,MODEL)
*
* Set the current light and lighting model.  If you were to have more than
*  one light in the scene at one time, you would use LIGHT1, LIGHT2, ...
*  also in calls to lmbind.  There is only one model allowed at one time,
*  so if you had multiple models defined, you would switch between models
*  with the lmbind(LMODEL, ...) call.
*
      CALL LMBIND(LIGHT0,1)
      CALL LMBIND(LMODEL,1)
      CALL LMBIND(MATERI,1)
*
* Initial Hard Scaling.
*
      SCL=10.0/XL
      CALL SCALE(SCL,SCL,SCL)
*
* draw it initially.
*
*
      IF (IDIS.EQ.0) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
      CALL DWTRIG(0,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.1) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWCATR(ICATR,ILIG,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.2) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWMOL5(XG,YG,ZG,DTX,DTY,STX,DTZ)
      ENDIF
      CALL SWAPBU
*
1     CONTINUE
*
* read queued input.
*
      DEV=QREAD(VAL)
*
* terminate session.
*
      IF  (DEV.EQ.ESCKEY.OR.DEV.EQ.WINQUI) THEN
*
* jump to end of subroutine.
*
      GOTO 10
*
* reset molecule to starting point.
*
      ELSEIF (DEV.EQ.F1KEY) THEN
*
* re-initialise.
*
      DO 245 I=1,NN
      XG(I)=X(I)
      YG(I)=Y(I)
      ZG(I)=Z(I)
245   CONTINUE
*
* Centre it again.
*
      CALL DRCOFG(NN,XG,YG,ZG)
*
      DTX=0.0
      DTY=0.0
      DTZ=0.0
      STX=1.0
*
* draw molecule.
*
      IF (IDIS.EQ.0) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
      CALL DWTRIG(0,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.1) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWCATR(ICATR,ILIG,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.2) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWMOL5(XG,YG,ZG,DTX,DTY,STX,DTZ)
      ENDIF
      CALL SWAPBU
      GOTO 1
*
      ELSEIF (DEV.EQ.REDRAW) THEN
*
* refresh screen after iconisation or resizing.
*
      CALL RESHAP
*
      IF (IDIS.EQ.0) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
      CALL DWTRIG(0,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.1) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWCATR(ICATR,ILIG,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.2) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWMOL5(XG,YG,ZG,DTX,DTY,STX,DTZ)
      ENDIF
      CALL SWAPBU
      GOTO 1
*
* rotation.
*
      ELSEIF (GETBUT(LEFTMO)) THEN
*
* get values.
*
      IMX=GETVAL(MOUSEX)
      IMY=GETVAL(MOUSEY)
*
* type of rotation.
*
      IF (GETBUT(LEFTSH).EQ.1) THEN
*
* Z rotation.
*
      STW=FLOAT(IMX-XOLD)
      STY=FLOAT(IMY-YOLD)
*
      RY=-0.5*(STW+STY)
*
      CALL DRZROT(ROTMAT,RY)
      CALL DRROT(NN,ROTMAT,XG,YG,ZG)
      CALL DRCOFG(NN,XG,YG,ZG)
*
      ELSE
*
* XY rotation.
*
      RY=-0.5*(FLOAT(IMX-XOLD))
      RX= 0.5*(FLOAT(IMY-YOLD))
*
* apply rotation.
*
      CALL DRXROT(ROTMAT,RX)
      CALL DRROT(NN,ROTMAT,XG,YG,ZG)
      CALL DRYROT(ROTMAT,RY)
      CALL DRROT(NN,ROTMAT,XG,YG,ZG)
      CALL DRCOFG(NN,XG,YG,ZG)
*
      ENDIF
*
* store present value.
*
      XOLD=IMX
      YOLD=IMY
*
* black background.
*
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
*
* actually draw bonds of molecule.
*
      IF (IDIS.EQ.0) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
      CALL DWTRIG(0,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.1) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWCATR(ICATR,ILIG,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.2) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWMOL5(XG,YG,ZG,DTX,DTY,STX,DTZ)
      ENDIF
*
      CALL SWAPBU
*
      GOTO 1
*
* translation.
*
      ELSEIF (GETBUT(MIDDLE)) THEN
*
* get values.
*
      IMX=GETVAL(MOUSEX)
      IMY=GETVAL(MOUSEY)
*
* direction of translation.
*
      IF (GETBUT(LEFTSH).EQ.1) THEN
*
* translation along Z
*
      STW=FLOAT(IMX-XOLD)
      STY=FLOAT(IMY-YOLD)
*
      DTZ=DTZ+0.03*(STW+STY)
*
      ELSE
*
* XY translation.
*
      DTX=DTX+0.03*FLOAT(IMX-XOLD)
      DTY=DTY+0.03*FLOAT(IMY-YOLD)
*
      ENDIF
*
* black background.
*
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
*
* save cursor position.
*
      XOLD=IMX
      YOLD=IMY
*
* actually draw bonds of molecule.
*
      IF (IDIS.EQ.0) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
      CALL DWTRIG(0,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.1) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWCATR(ICATR,ILIG,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.2) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWMOL5(XG,YG,ZG,DTX,DTY,STX,DTZ)
      ENDIF
*
      CALL SWAPBU
*
* scaling.
*
      ELSEIF (GETBUT(RIGHTM)) THEN
*
      IF (GETBUT(LEFTSH)) THEN
*
* get mouse positions.
*
      IMX=GETVAL(MOUSEX)
      IMY=GETVAL(MOUSEY)
*
* get value of scale
*
      STW=FLOAT(IMX-XOLD)
      STY=FLOAT(IMY-YOLD)
*
      STX=STX+0.005*(STW+STY)
*
      IF (STX.LT.0.08) STX=0.08
*
* save present mouse position.
*
      XOLD=IMX
      YOLD=IMY
*
* actually draw molecule.
*
      IF (IDIS.EQ.0) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
      CALL DWTRIG(0,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.1) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWCATR(ICATR,ILIG,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.2) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWMOL5(XG,YG,ZG,DTX,DTY,STX,DTZ)
      ENDIF
*
      CALL SWAPBU
*
      ELSE
*
* Change display style.
*
      IKK=DOPUP(IMENU)
*
      IF (IKK.EQ.1) THEN
      IDIS=0
      CALL DEPTHC(.FALSE.)
      ELSEIF (IKK.EQ.2) THEN
      IDIS=1
      CALL DEPTHC(.TRUE.)
      ELSEIF (IKK.EQ.3) THEN
      IDIS=2
      CALL DEPTHC(.FALSE.)
      ELSEIF (IKK.EQ.4) THEN
*
* end session.
*
      GOTO 10
*
      ELSE
      IDIS=0
      CALL DEPTHC(.FALSE.)
      ENDIF
*
* actually draw bonds of molecule.
*
      IF (IDIS.EQ.0) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
      CALL DWTRIG(0,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.1) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWCATR(ICATR,ILIG,XG,YG,ZG,DTX,DTY,STX,DTZ)
      ELSEIF (IDIS.EQ.2) THEN
      CALL RGBCOL(0,0,0)
      CALL CLEAR
      CALL ZCLEAR
* actually draw bonds of molecule.
      CALL DWMOL5(XG,YG,ZG,DTX,DTY,STX,DTZ)
      ENDIF
*
      CALL SWAPBU
*
      GOTO 1
*
      ENDIF
*
      ELSE
*
* get latest coordinates of mouse.
*
      XOLD=GETVAL(MOUSEX)
      YOLD=GETVAL(MOUSEY)
*
      ENDIF
*
* return for next queued event.
*
      GOTO 1
*
10    CONTINUE
*
* Switch off lighting settings.
*
      CALL LMBIND(LIGHT0,0)
      CALL LMBIND(LMODEL,0)
      CALL LMBIND(MATERI,0)
*
* Close this window.
*
      CALL WINCLO(GID)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Actually draw molecule
*
      SUBROUTINE DWTRIG(IDDEC,XG,YG,ZG,DTX,DTY,STX,DTZ)
*
* Declarations.
*
      INTEGER I1,I2,I3,I4,IAX,INDX(9000),NSEG,ICHL
      REAL XG(9000),YG(9000),ZG(9000)
      REAL BV(3,2),XAXIS(3,9000),HELPRM(3,9000),VAXIS(3,4),VK(3,100)
      REAL DTX,DTY,STX,DTZ,ACA,VS(3)
*
      INCLUDE 'FOLD.INC'
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* change to colour change lighting mode.
*
      CALL LMCOLO(LMCAMB)
*
* get Backbone axis.
*
      CALL RIBAX(XG,YG,ZG,XAXIS)
*
* create helices.
*
      CALL RGBCOL(250,0,0)
*
* draw cylinder.
*
      IF (HELTYP.EQ.1) THEN
*
      DO 90 ICHL=1,CHL
      DO 91 I=1,NHEL4(ICHL)
*
* get pointers to ends of helix.
*
      I1=HEL4N1(I,ICHL)
      I2=HEL4N2(I,ICHL)
*
      IF (I1.GT.0.AND.I2.GT.0) THEN
*
      II1=POS(4,I1,ICHL)
      II2=POS(4,I2,ICHL)
*
      IF (II1.GT.0.AND.II2.GT.0) THEN
*
* coordinates of ends.
*
      BV(1,1)=XAXIS(1,II1)
      BV(2,1)=XAXIS(2,II1)
      BV(3,1)=XAXIS(3,II1)
*
      BV(1,2)=XAXIS(1,II2)
      BV(2,2)=XAXIS(2,II2)
      BV(3,2)=XAXIS(3,II2)
*
* draw it.
*
      CALL DWCYL(1.5,2.0,3.0,BV,STX,DTX,DTY,DTZ)
*
      ENDIF
      ENDIF
*
91    CONTINUE
90    CONTINUE
*
      ELSE
*
      DO 80 ICHL=1,CHL
      DO 81 I=1,NHEL4(ICHL)
*
* get pointers to ends of helix.
*
      I1=HEL4N1(I,ICHL)
      I2=HEL4N2(I,ICHL)
*
* draw ribbon.
*
      CALL DW4ARC(I1,I2,ICHL,XAXIS,XG,YG,ZG,DTX,DTY,STX,DTZ)
*
81    CONTINUE
80    CONTINUE
*
      CALL RGBCOL(250,250,0)
*
      DO 70 ICHL=1,CHL
      DO 71 I=1,NHEL3(ICHL)
*
* get pointers to ends of helix.
*
      I1=HEL3N1(I,ICHL)
      I2=HEL3N2(I,ICHL)
*
* draw ribbon.
*
      CALL DW4ARC(I1,I2,ICHL,XAXIS,XG,YG,ZG,DTX,DTY,STX,DTZ)
*
71    CONTINUE
70    CONTINUE
*
      ENDIF
*
* draw strands.
*
      CALL RGBCOL(15,255,15)
*
      DO 2 ICHL=1,CHL
      DO 2 I=1,NSTRAND(ICHL)
*
* draw fully smoothed strand.
*
      CALL DWSTND(I,ICHL,XG,YG,ZG,XAXIS,DTX,DTY,STX,DTZ)
*
2     CONTINUE
*
* Now draw loops.
*
      CALL RGBCOL(30,30,190)
      CALL DWLOOP(DTX,DTY,STX,DTZ,XAXIS)
*
* default lighting mode
*
      CALL LMCOLO(LMCCOL) 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get backkbone axis.
*
      SUBROUTINE RIBAX(XG,YG,ZG,XAXIS)
*
* Declarations.
*
      INTEGER I1,IAX,NSEG,INDX(9000)
      REAL XG(9000),YG(9000),ZG(9000)
      REAL XAXIS(3,9000),HELPRM(3,9000)
*
      INCLUDE 'FOLD.INC'
*
* get axis.
*
      CALL GETHLP(XG,YG,ZG,XAXIS,HELPRM)      
*
      DO 1 I=1,CHL
*
* get index.
*
      IAX=0
      DO 88 J=RN1(I),RN2(I)
      I1=POS(4,J,I)
      IF (I1.GT.0) THEN
      IAX=IAX+1
      INDX(IAX)=I1
      ENDIF
88    CONTINUE
*
* smooth with a B-spline.
*
      NSEG=4
      CALL GTSPL(NSEG,IAX,INDX,XAXIS)
*
* Super smooth ?
*
      CALL GTSPL(NSEG,IAX,INDX,XAXIS)
*
* get points.
*
      I1=POS(4,RN1(I),I)
      IF (I1.GT.0) THEN
      XAXIS(1,I1)=XG(I1)
      XAXIS(2,I1)=YG(I1)
      XAXIS(3,I1)=ZG(I1)
      ENDIF
      I1=POS(4,RN2(I),I)
      IF (I1.GT.0) THEN
      XAXIS(1,I1)=XG(I1)
      XAXIS(2,I1)=YG(I1)
      XAXIS(3,I1)=ZG(I1)
      ENDIF
      I1=POS(4,RN2(I)-1,I)
      IF (I1.GT.0) THEN
      XAXIS(1,I1)=XG(I1)
      XAXIS(2,I1)=YG(I1)
      XAXIS(3,I1)=ZG(I1)
      ENDIF
*
1     CONTINUE
*
      RETURN
      END

*
*-------------------------------------------------------------------------------
*
      SUBROUTINE GTRIG1(X1,X2,X3,VV,VN)
*
* Declarations.
*
      REAL X1(3),X2(3),X3(3),VN(3),VV(3),V1(3),V2(3)
*
* get first CA-CA vector.
*
      DO 1 I=1,3
      V1(I)=X2(I)-X1(I)
      V2(I)=X2(I)-X3(I)
      VV(I)=V1(I)+V2(I)
1     CONTINUE
*
      CALL NORM3(VV)
*
* get vector normal to CA-CA-CA plane.
*
      CALL CROSS3(VN,V1,V2)
      CALL NORM3(VN)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Projection of vector V1 onto V2 returned in PR. PR is normalised.
*
      SUBROUTINE PROJV(V1,V2,PR)
*
* Declarations.
*
      REAL V1(3),V2(3),PR(3),SCAL,W
*
* initialise.
*
      W=0.0
*
* get magnitude.
*
      DO 1 I=1,3
      W=W+(V2(I)**2.0)      
1     CONTINUE
*
* get dot product.
*
      CALL DOT3(V1,V2,SCAL)
*
* get factor.
*
      W=SCAL/W
*
* project.
*
      DO 2 I=1,3
      PR(I)=W*V2(I)
2     CONTINUE
*
* normalise.
*
      CALL NORM3(PR)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Dot product of two vectors.
*
      SUBROUTINE DOT3(A,B,SSS)
*
* Declarations.
*
      REAL SSS,A(3),B(3)
*
* calculate.
*
      SSS = A(1)*B(1) + A(2)*B(2) + A(3)*B(3)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Draw pointer.
*
      SUBROUTINE DWCYL(D1,D2,D3,BV,STX,DTX,DTY,DTZ)
*
* declarations.
*
      REAL V3(3),BV(3,2),D1,D2,D3,CY(500),CX(500)
      REAL DTX,DTZ,DTY,STX,CXX,CYY,CX2,CY2
      REAL XE(3),XS(3),U1(3),U2(3),U3(3),PP(3),UZ(3),UX(3)
      REAL X4(3),XW(3),X3(3),X1(3),X2(3)
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* initialise.
*
      DATA UZ / 0.0,0.0,1.0 /
      DATA UX / 1.0,0.0,0.0 /
*
      IUP=0
      PI=3.14159
      DSECT=0.75
*
* get vectors.
*
      DO 1 I=1,3
      XS(I)=BV(I,1)
      XE(I)=BV(I,2)
      V3(I)=BV(I,2)-BV(I,1)
1     CONTINUE
*
      CALL NORM3(V3)
*
      DO 12 I=1,3
      U1(I)=V3(I)
12    CONTINUE
*
* get cylinder axis.
*
      CALL NORM3(U1)
*
* two other two orthogonal axes.
*
      IF (ABS(U1(3)).GT.0.9999) THEN
      CALL CROSS3(U2,U1,UX)
      ELSE
      CALL CROSS3(U2,U1,UZ)
      ENDIF
*
      CALL NORM3(U2)
      CALL CROSS3(U3,U2,U1)
      CALL NORM3(U3)
*
* set up points for circle.
*
      M=180
      DTH=2.0*PI/M
      N1=M/4
      N2=M/2
      N3=3*M/4
      THETA=0.0
*
* set up points for circle.
*
      DO 20 JDO=1,180
      A=COS(THETA)
      B=SIN(THETA)
      CX(JDO)=A
      CY(JDO)=B
      CX(JDO+N1)=-B
      CY(JDO+N1)=A
      CX(JDO+N2)=-A
      CY(JDO+N2)=-B
      CX(JDO+N3)=B
      CY(JDO+N3)=-A
      THETA=THETA+DTH
20    CONTINUE
      NPP=M+1
      CX(M+1)=CX(1)
      CY(M+1)=CY(1)
*
* now plot cylinder as the sequence of npp points.
*
      DO 40 II=1,180,20
*
* get circle points.
*
      CXX=CX(II)
      CYY=CY(II)
      CX2=CX(II+20)
      CY2=CY(II+20)
*
* draw end plate.
*
      CALL BGNPOL
*
      XW(1)=STX*(XS(1))+DTX
      XW(2)=STX*(XS(2))+DTY
      XW(3)=STX*(XS(3))+DTZ
*
      CALL N3F(V3)
      CALL V3F(XW)
*
      PP(1)=D1*U2(1)*CXX+D1*U3(1)*CYY
      PP(2)=D1*U2(2)*CXX+D1*U3(2)*CYY
      PP(3)=D1*U2(3)*CXX+D1*U3(3)*CYY
*
      XW(1)=STX*(PP(1)+XS(1))+DTX
      XW(2)=STX*(PP(2)+XS(2))+DTY
      XW(3)=STX*(PP(3)+XS(3))+DTZ
*
      CALL N3F(V3)
      CALL V3F(XW)
*
      PP(1)=D1*U2(1)*CX2+D1*U3(1)*CY2
      PP(2)=D1*U2(2)*CX2+D1*U3(2)*CY2
      PP(3)=D1*U2(3)*CX2+D1*U3(3)*CY2
*
      XW(1)=STX*(PP(1)+XS(1))+DTX
      XW(2)=STX*(PP(2)+XS(2))+DTY
      XW(3)=STX*(PP(3)+XS(3))+DTZ
*
      CALL N3F(V3)
      CALL V3F(XW)
*
      CALL ENDPOL
*
* draw main cylinder.
*
      CALL BGNPOL
*
      PP(1)=D1*U2(1)*CXX+D1*U3(1)*CYY
      PP(2)=D1*U2(2)*CXX+D1*U3(2)*CYY
      PP(3)=D1*U2(3)*CXX+D1*U3(3)*CYY
*
      XW(1)=STX*(PP(1)+XS(1))+DTX
      XW(2)=STX*(PP(2)+XS(2))+DTY
      XW(3)=STX*(PP(3)+XS(3))+DTZ
*
      CALL NORM3(PP)
      CALL N3F(PP)
      CALL V3F(XW)
*
      PP(1)=D1*U2(1)*CX2+D1*U3(1)*CY2
      PP(2)=D1*U2(2)*CX2+D1*U3(2)*CY2
      PP(3)=D1*U2(3)*CX2+D1*U3(3)*CY2
*
      XW(1)=STX*(PP(1)+XS(1))+DTX
      XW(2)=STX*(PP(2)+XS(2))+DTY
      XW(3)=STX*(PP(3)+XS(3))+DTZ
*
      CALL NORM3(PP)
      CALL N3F(PP)
      CALL V3F(XW)
*
      PP(1)=D1*U2(1)*CX2+D1*U3(1)*CY2
      PP(2)=D1*U2(2)*CX2+D1*U3(2)*CY2
      PP(3)=D1*U2(3)*CX2+D1*U3(3)*CY2
*
      XW(1)=STX*(PP(1)+XE(1)-D3*U1(1))+DTX
      XW(2)=STX*(PP(2)+XE(2)-D3*U1(2))+DTY
      XW(3)=STX*(PP(3)+XE(3)-D3*U1(3))+DTZ
*
      CALL NORM3(PP)
      CALL N3F(PP)
      CALL V3F(XW)
*
      PP(1)=D1*U2(1)*CXX+D1*U3(1)*CYY
      PP(2)=D1*U2(2)*CXX+D1*U3(2)*CYY
      PP(3)=D1*U2(3)*CXX+D1*U3(3)*CYY
*
      XW(1)=STX*(PP(1)+XE(1)-D3*U1(1))+DTX
      XW(2)=STX*(PP(2)+XE(2)-D3*U1(2))+DTY
      XW(3)=STX*(PP(3)+XE(3)-D3*U1(3))+DTZ
*
      CALL NORM3(PP)
*
      CALL N3F(PP)
      CALL V3F(XW)
*
      CALL ENDPOL
*
* Draw head of pointer.
*
      CALL BGNPOL
*
      PP(1)=D2*U2(1)*CXX+D2*U3(1)*CYY
      PP(2)=D2*U2(2)*CXX+D2*U3(2)*CYY
      PP(3)=D2*U2(3)*CXX+D2*U3(3)*CYY
*
      XW(1)=STX*(PP(1)+XE(1)-D3*U1(1))+DTX
      XW(2)=STX*(PP(2)+XE(2)-D3*U1(2))+DTY
      XW(3)=STX*(PP(3)+XE(3)-D3*U1(3))+DTZ
*
      CALL NORM3(PP)
*
      CALL N3F(PP)
      CALL V3F(XW)
*
      PP(1)=D2*U2(1)*CX2+D2*U3(1)*CY2
      PP(2)=D2*U2(2)*CX2+D2*U3(2)*CY2
      PP(3)=D2*U2(3)*CX2+D2*U3(3)*CY2
*
      X3(1)=STX*(PP(1)+XE(1)-D3*U1(1))+DTX
      X3(2)=STX*(PP(2)+XE(2)-D3*U1(2))+DTY
      X3(3)=STX*(PP(3)+XE(3)-D3*U1(3))+DTZ
*
      CALL NORM3(PP)
*
      CALL N3F(PP)
      CALL V3F(X3)
*
      X1(1)=XW(1)-XE(1)
      X1(2)=XW(2)-XE(2)
      X1(3)=XW(3)-XE(3)
      X2(1)=X3(1)-XE(1)
      X2(2)=X3(2)-XE(2)
      X2(3)=X3(3)-XE(3)
*
      CALL CROSS3(X4,X1,X2)
      CALL NORM3(X4)     
*
      XW(1)=STX*(XE(1))+DTX
      XW(2)=STX*(XE(2))+DTY
      XW(3)=STX*(XE(3))+DTZ
*
      CALL N3F(X4)
      CALL V3F(XW)
*
      CALL ENDPOL
*
40    CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
*  Calculate helical parameters from Calpha coordinates.
*  Use Method owing to Sugeta and Miyazawa (1963).
*
      SUBROUTINE GETHLP(XG,YG,ZG,XAXIS,HELPRM)
*
* declarations.
*
      INTEGER I,J,E1,E2
      INTEGER INDX(9000),IN(20)
*
      REAL XG(9000),YG(9000),ZG(9000),
     +     XAXIS(3,9000),HELPRM(3,9000)
*
      REAL C1(3),C2(3),B(3),B1(3),CV(3)
      REAL VEC(3,1000)
      REAL P1P,P1M,P1,TT1,TT2,TANG
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      CONV=180.0/3.1415
*
* work through chains.
*
      DO 100 J=1,CHL
*
* reinitialise for this chain.
*
      IN(J)=0
*
* do this chain.
*
      DO 1 I=RN1(J),RN2(J)-1
*
* get pointers.
*
      E1=POS(4,I,J)
      E2=POS(4,I+1,J)
*
* error trap.
*
      IF (E1.LT.1) GOTO 1
      IF (E2.LT.1) GOTO 1
*
* increment counters and index.
*
      IN(J)=IN(J)+1
      INDX(IN(J))=E1
*
* calculate vectors.
*
      VEC(1,IN(J))=XG(E2)-XG(E1)
      VEC(2,IN(J))=YG(E2)-YG(E1)
      VEC(3,IN(J))=ZG(E2)-ZG(E1)
*
1     CONTINUE
*
* now work through inter residue 
*
      DO 2 I=2,(IN(J)-1)
*
* get the C vectors.
*
      DO 21 JJ=1,3      
      C1(JJ)=VEC(JJ,I-1)-VEC(JJ,I)
      C2(JJ)=VEC(JJ,I)-VEC(JJ,I+1)
      B(JJ)=VEC(JJ,I)
21    CONTINUE
*
* get values from these vectors.
*
      CALL MAGVEC(CC,C1)
      CALL MAGVEC(BB,B)
      CALL ANGVEC(TANG,C1,C2)
*
* get vector product of the axis-perpendicular vectors C and C'
*
      CALL CROSS3(B1,C1,C2)
*
* get scalar product of this with B vector.
*
      CALL DOT3(B,B1,BB1)
*
* now get the helix parameters.
*
      TT1=1.0-TANG
      TT2=SQRT(ABS(1.0-TANG*TANG))
      P1=CC/(2.0*TT1)
      DD=BB*BB-(2.0*P1*P1*TT1)
*
* save infromation.
*
      E1=INDX(I)
*
* error trap.
*
      IF (E1.GT.0) THEN
*
* helix parameters.
*
      HELPRM(1,E1)=ACOS(TANG)*CONV
      HELPRM(2,E1)=P1
      HELPRM(3,E1)=SQRT(ABS(DD))
*
* normalise.
*
      CALL NORM3(C1)
*
* store.
*
      DO 11 II=1,3
      XAXIS(II,E1)=C1(II)
11    CONTINUE
*
      ENDIF
*
2     CONTINUE
*
100   CONTINUE
*
* now get positions of axis points.
*
      DO 300 I=1,CHL
*
      P1M=0.0
*
      DO 301 J=RN1(I)+1,RN2(I)-1
*
* get pointer.
*
      E1=POS(4,J,I)
*
* error trap no atom.
*
      IF (E1.GT.0) THEN
*
      P1=ABS(HELPRM(2,E1))
*
* over complicated error trap for a vector which is too long.
*
      IF (P1.GT.5.0) THEN
*
* get flanking lengths.
*
      E1P=POS(4,J+1,I)
      P1P=ABS(HELPRM(2,E1P))
*
* error trap.
*
      IF (P1M.LE.0.0001) P1M=P2M
      IF (P2M.LE.0.0001) P2M=P1M
*
      P1=(P1M+P1P)/2.0      
      IF (P1.GT.5.0.OR.P1.LE.0.0001) P1=5.0
*
      ENDIF
*
* calculate position
*
      XAXIS(1,E1)=XG(E1)-P1*XAXIS(1,E1)
      XAXIS(2,E1)=YG(E1)-P1*XAXIS(2,E1)
      XAXIS(3,E1)=ZG(E1)-P1*XAXIS(3,E1)
*
* save radius.
*
      P1M=P1
*
      ENDIF
*
301   CONTINUE
*
      E1=POS(4,RN1(I),I)
      XAXIS(1,E1)=XG(E1)
      XAXIS(2,E1)=YG(E1)
      XAXIS(3,E1)=ZG(E1)
*
      E1=POS(4,RN2(I),I)
      XAXIS(1,E1)=XG(E1)
      XAXIS(2,E1)=YG(E1)
      XAXIS(3,E1)=ZG(E1)
*
300   CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* angle between two vectors.
*
      SUBROUTINE ANGVEC(SSS,A1,A2)
*
* declarations.
*
      REAL SSS,A1(3),A2(3),CONV,AA2(3),AA1(3)
*
      CONV=180.0/3.1415
*
* initialise.
*
      SSS=0.0
*
* do the stuff.
*
      CALL NORM3(A1)
      CALL NORM3(A2)
*
      DO 1 II=1,3
      SSS=SSS+(A1(II)*A2(II))
1     CONTINUE
*
* error trap.
*
      IF (SSS.GT.1.0) SSS=1.0
      IF (SSS.LT.-1.0) SSS=-1.0
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get magnitude or length of a 3-vector.
*
      SUBROUTINE MAGVEC(CMAG,CV)
*
* declarations.
*
      INTEGER I
      REAL CMAG,CV(3)
*
* calculate magnitude.
*
      CMAG=0.0
      DO 1 I=1,3
      CMAG=CMAG+CV(I)**2
1     CONTINUE
*
* Error trap.
*
      IF (CMAG.GT.0.0) THEN
      CMAG=SQRT(CMAG)
      ELSE
      CMAG=0.0
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Draw arc.
*
      SUBROUTINE 
     +DW3ARC(I1,I2,I3,ANGCA,XAXIS,XG,YG,ZG,DTX,DTY,STX,DTZ)
*
* Declarations.
*
      INTEGER NE,I1,I2,I3
      REAL THETA,ANGCA,V(3),SWID,CWID
*
      REAL XAXIS(3,9000),XG(9000),YG(9000),ZG(9000),
     +     DTX,DTY,STX,DTZ,
     +     D1,DS,DMAG
*
      REAL XD,YD,ZD,ST,CT,D,VV(3),Q(4),DEGTOR,R(3,3),XW(3),XS(3)
      REAL NO(3),XO(3),VO(3),X1(3),X2(3),X3(3),X4(3),V1(3),VS(3)
      REAL VK(3),V2(3),VW(3)
*
      INCLUDE 'FOLD.INC'
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* initialise.
*
      SWID=1.4
      CWID=2.5
      DEGTOR=3.1415926/180.0
      ISTEP=10
*
      THETA=-ANGCA/FLOAT(ISTEP)
*
* create rotation vector.
*
      VV(1)=XAXIS(1,I2)-XAXIS(1,I1)
      VV(2)=XAXIS(2,I2)-XAXIS(2,I1)
      VV(3)=XAXIS(3,I2)-XAXIS(3,I1)
*
* get distance step.
*
      CALL MAGVEC(DMAG,VV)
      DS=DMAG/FLOAT(ISTEP+1)
      D1=0.0
*
* Create rotation matrix.
*
* normalise rotation vector.
*
      CALL NORM3(VV)
*
* Calculate quaternion parameters.
*
      ST=SIN(THETA*DEGTOR/2.0)
      Q(1)=COS(THETA*DEGTOR/2.0)
*
      DO 1 I=1,3
      Q(I+1)=VV(I)*ST
1     CONTINUE
*
* Calculate rotation matrix:
*
      CALL QUTROT(R,Q,D)
*
* get normal.
*
      X2(1)=XG(I1)-XAXIS(1,I1)
      X2(2)=YG(I1)-XAXIS(2,I1)
      X2(3)=ZG(I1)-XAXIS(3,I1)
*
      CALL NORM3(X2)
*
* work through arc.
*
      DO 10 K=1,ISTEP
*
* Apply matrix to coordinates.
*
      X3(1)=R(1,1)*X2(1)+R(1,2)*X2(2)+R(1,3)*X2(3)
      X3(2)=R(2,1)*X2(1)+R(2,2)*X2(2)+R(2,3)*X2(3)
      X3(3)=R(3,1)*X2(1)+R(3,2)*X2(2)+R(3,3)*X2(3)
*
* draw polygon.
*
      CALL BGNPOL
*
      XW(1)=STX*(XAXIS(1,I1)+D1*VV(1)+CWID*X2(1)+SWID*VV(1))+DTX
      XW(2)=STX*(XAXIS(2,I1)+D1*VV(2)+CWID*X2(2)+SWID*VV(2))+DTY
      XW(3)=STX*(XAXIS(3,I1)+D1*VV(3)+CWID*X2(3)+SWID*VV(3))+DTZ
*
      CALL N3F(X2)
      CALL V3F(XW)
*
      XW(1)=STX*(XAXIS(1,I1)+D1*VV(1)+CWID*X2(1)-SWID*VV(1))+DTX
      XW(2)=STX*(XAXIS(2,I1)+D1*VV(2)+CWID*X2(2)-SWID*VV(2))+DTY
      XW(3)=STX*(XAXIS(3,I1)+D1*VV(3)+CWID*X2(3)-SWID*VV(3))+DTZ
*
      CALL N3F(X2)
      CALL V3F(XW)
*
* Get distance increment up central axis vector.
*
      D1=D1+DS
*
      XW(1)=STX*(XAXIS(1,I1)+D1*VV(1)+CWID*X3(1)-SWID*VV(1))+DTX
      XW(2)=STX*(XAXIS(2,I1)+D1*VV(2)+CWID*X3(2)-SWID*VV(2))+DTY
      XW(3)=STX*(XAXIS(3,I1)+D1*VV(3)+CWID*X3(3)-SWID*VV(3))+DTZ
*
      CALL N3F(X3)
      CALL V3F(XW)
*
      XW(1)=STX*(XAXIS(1,I1)+D1*VV(1)+CWID*X3(1)+SWID*VV(1))+DTX
      XW(2)=STX*(XAXIS(2,I1)+D1*VV(2)+CWID*X3(2)+SWID*VV(2))+DTY
      XW(3)=STX*(XAXIS(3,I1)+D1*VV(3)+CWID*X3(3)+SWID*VV(3))+DTZ
*
      CALL N3F(X3)
      CALL V3F(XW)
*
      CALL ENDPOL
*
* Save vectors.
*
      DO 11 I=1,3
      X2(I)=X3(I)
11    CONTINUE
*
10    CONTINUE
*
      X3(1)=R(1,1)*X2(1)+R(1,2)*X2(2)+R(1,3)*X2(3)
      X3(2)=R(2,1)*X2(1)+R(2,2)*X2(2)+R(2,3)*X2(3)
      X3(3)=R(3,1)*X2(1)+R(3,2)*X2(2)+R(3,3)*X2(3)
*
      CALL BGNPOL
*
      XW(1)=STX*(XAXIS(1,I2)+CWID*X2(1)+SWID*VV(1))+DTX
      XW(2)=STX*(XAXIS(2,I2)+CWID*X2(2)+SWID*VV(2))+DTY
      XW(3)=STX*(XAXIS(3,I2)+CWID*X2(3)+SWID*VV(3))+DTZ
*
      CALL N3F(X2)
      CALL V3F(XW)
*
      XW(1)=STX*(XAXIS(1,I2)+CWID*X2(1)-SWID*VV(1))+DTX
      XW(2)=STX*(XAXIS(2,I2)+CWID*X2(2)-SWID*VV(2))+DTY
      XW(3)=STX*(XAXIS(3,I2)+CWID*X2(3)-SWID*VV(3))+DTZ
*
      CALL N3F(X2)
      CALL V3F(XW)
*
* Get distance increment up central axis vector.
*
      D1=D1+DS
*
      XW(1)=STX*(XAXIS(1,I2)+CWID*X3(1)-SWID*VV(1))+DTX
      XW(2)=STX*(XAXIS(2,I2)+CWID*X3(2)-SWID*VV(2))+DTY
      XW(3)=STX*(XAXIS(3,I2)+CWID*X3(3)-SWID*VV(3))+DTZ
*
      CALL N3F(X3)
      CALL V3F(XW)
*
      XW(1)=STX*(XAXIS(1,I2)+CWID*X3(1)+SWID*VV(1))+DTX
      XW(2)=STX*(XAXIS(2,I2)+CWID*X3(2)+SWID*VV(2))+DTY
      XW(3)=STX*(XAXIS(3,I2)+CWID*X3(3)+SWID*VV(3))+DTZ
*
      CALL N3F(X3)
      CALL V3F(XW)
*
      CALL ENDPOL
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Draw arc.
*
      SUBROUTINE 
     +DW4ARC(IHEL1,IHEL2,ICHL,XAXIS,XG,YG,ZG,DTX,DTY,STX,DTZ)
*
* Declarations.
*
      INTEGER NE,I1,I2,I3,I4,IHEL1,IHEL2,ICHL,IK
      REAL THETA,ANGCA,V(3),SWID,CWID
*
      REAL XG(9000),YG(9000),ZG(9000),XAXIS(3,9000),
     +     DTX,DTY,STX,DTZ,
     +     D1,DS,DMAG,XK(3,9000)
*
      REAL XD,YD,ZD,ST,CT,D,VV(3),Q(4),DEGTOR,R(3,3),XW(3),XS(3)
      REAL NO(3),XO(3),VO(3),X1(3),X2(3),X3(3),X4(3),V1(3),VS(3)
      REAL V2(3),VW(3),VAXIS(3,4),VK(3,100),XZ(3)
*
      INCLUDE 'FOLD.INC'
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* initialise.
*
      SWID=1.4
      CWID=2.5
      IK=0
      DEGTOR=3.1415926/180.0
*
      I1=POS(4,IHEL1,ICHL)
      I2=POS(4,IHEL2,ICHL)
*
      DO 456 J=1,3
      XZ(J)=XAXIS(J,I2)-XAXIS(J,I1)
456   CONTINUE
*
      CALL NORM3(XZ)
*
* Draw helix.
*
      DO 50 J=IHEL1,IHEL2-1
*
* get pointers.
*
      I1=POS(4,J-1,ICHL)
      I2=POS(4,J,ICHL)
      I3=POS(4,J+1,ICHL)
      I4=POS(4,J+2,ICHL)
*
* create rotation vector.
*
      VAXIS(1,1)=XG(I1)
      VAXIS(2,1)=YG(I1)
      VAXIS(3,1)=ZG(I1)
*
      VAXIS(1,2)=XG(I2)
      VAXIS(2,2)=YG(I2)
      VAXIS(3,2)=ZG(I2)
*
      VAXIS(1,3)=XG(I3)
      VAXIS(2,3)=YG(I3)
      VAXIS(3,3)=ZG(I3)
*
      VAXIS(1,4)=XG(I4)
      VAXIS(2,4)=YG(I4)
      VAXIS(3,4)=ZG(I4)
*
* B-spline interpolation.
*
      CALL GTSPL2(30,VAXIS,VK)
*      
      DO 2 K=1,30
      IK=IK+1
      DO 3 JJ=1,3
      XK(JJ,IK)=VK(JJ,K)
3     CONTINUE
2     CONTINUE
*
50    CONTINUE
*
* work through arc.
*
      ST4=0.0
      DO 10 K=2,30
*
      ST4=ST4+0.033
*
* draw polygon.
*
      CALL DWFARC(K-1,K,K+1,K+2,XK,XG,YG,ZG,XZ,DTX,DTY,STX,DTZ,ST4)
*
10    CONTINUE
*
      DO 11 K=31,IK-31
*
* draw polygon.
*
      CALL DWFARC(K-1,K,K+1,K+2,XK,XG,YG,ZG,XZ,DTX,DTY,STX,DTZ,1.0)
*
11    CONTINUE
*
      ST4=1.7
      DO 12 K=IK-30,IK-2
*
      ST4=ST4-0.05666
*
* draw polygon.
*
      CALL DWFARC(K-1,K,K+1,K+2,XK,XG,YG,ZG,XZ,DTX,DTY,STX,DTZ,ST4)
*
12    CONTINUE
*
* adjust backbone positions.
*
      I1=POS(4,IHEL1,ICHL)
      IF (I1.GT.0) THEN
      XAXIS(1,I1)=XK(1,1)
      XAXIS(2,I1)=XK(2,1)
      XAXIS(3,I1)=XK(3,1)
      ENDIF
*
      I1=POS(4,IHEL2,ICHL)
      IF (I1.GT.0) THEN
      XAXIS(1,I1)=XK(1,IK)
      XAXIS(2,I1)=XK(2,IK)
      XAXIS(3,I1)=XK(3,IK)
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Draw arc.
*
      SUBROUTINE 
     +DWFARC(I1,I2,I3,I4,XK,XG,YG,ZG,XZ,DTX,DTY,STX,DTZ,ST4)
*
* Declarations.
*
      INTEGER NE,I1,I2,I3,I4,IHEL1,IHEL2,ICHL
      REAL THETA,ANGCA,V(3),SWID,CWID
*
      REAL XG(9000),YG(9000),ZG(9000),
     +     DTX,DTY,STX,DTZ,
     +     D1,DS,DMAG,XK(3,9000)
*
      REAL XD,YD,ZD,ST,CT,D,VV(3),Q(4),DEGTOR,R(3,3),XW(3),XS(3)
      REAL NO(3),XO(3),VO(3),X1(3),X2(3),X3(3),X4(3),V1(3),VS(3)
      REAL VK(3),V2(3),VW(3),VAXIS(3,4),X5(3),X6(3),XZ(3),ST4
*
      INCLUDE 'FOLD.INC'
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* initialise.
*
      SWID=1.4*ST4
*
      CWID=2.5
      DEGTOR=3.1415926/180.0
*
      DO 1 I=1,3
      X1(I)=XK(I,I2)-XK(I,I1)
      X2(I)=XK(I,I2)-XK(I,I3)
      X4(I)=XK(I,I3)-XK(I,I4)
      X3(I)=XK(I,I3)-XK(I,I2)
*
      X5(I)=(X1(I)+X2(I))
      X6(I)=(X3(I)+X4(I))
*
      V1(I)=XZ(I)
      V2(I)=XZ(I)
*
1     CONTINUE
*
      CALL NORM3(X5)
      CALL NORM3(X6)
*
*      CALL CROSS3(V1,X1,X2)
*      CALL NORM3(V1)
*      CALL CROSS3(V2,X3,X4)
*      CALL NORM3(V2)
*
      CALL BGNPOL
*
      XW(1)=STX*(XK(1,I2)+SWID*V1(1))+DTX
      XW(2)=STX*(XK(2,I2)+SWID*V1(2))+DTY
      XW(3)=STX*(XK(3,I2)+SWID*V1(3))+DTZ
*
      CALL N3F(X5)
      CALL V3F(XW)
*
      XW(1)=STX*(XK(1,I2)-SWID*V1(1))+DTX
      XW(2)=STX*(XK(2,I2)-SWID*V1(2))+DTY
      XW(3)=STX*(XK(3,I2)-SWID*V1(3))+DTZ
*
      CALL N3F(X5)
      CALL V3F(XW)
*
* Get distance increment up central axis vector.
*
      XW(1)=STX*(XK(1,I3)-SWID*V2(1))+DTX
      XW(2)=STX*(XK(2,I3)-SWID*V2(2))+DTY
      XW(3)=STX*(XK(3,I3)-SWID*V2(3))+DTZ
*
      CALL N3F(X6)
      CALL V3F(XW)
*
      XW(1)=STX*(XK(1,I3)+SWID*V2(1))+DTX
      XW(2)=STX*(XK(2,I3)+SWID*V2(2))+DTY
      XW(3)=STX*(XK(3,I3)+SWID*V2(3))+DTZ
*
      CALL N3F(X6)
      CALL V3F(XW)

      CALL ENDPOL
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Draw arc.
*
      SUBROUTINE 
     +DW5ARC(IHEL1,IHEL2,ICHL,XAXIS,XG,YG,ZG,DTX,DTY,STX,DTZ)
*
* Declarations.
*
      INTEGER NE,I1,I2,I3,I4,IHEL1,IHEL2,ICHL,IK
      REAL THETA,ANGCA,V(3),SWID,CWID
*
      REAL XG(9000),YG(9000),ZG(9000),XAXIS(3,9000),
     +     DTX,DTY,STX,DTZ,
     +     SC(4),BV(3,2)
*
      REAL XD,YD,ZD,ST,CT,D,VV(3),Q(4),DEGTOR,R(3,3),XW(3),XS(3)
      REAL NO(3),XO(3),VO(3),X1(3),X2(3),X3(3),X4(3),V1(3),VS(3)
      REAL V2(3),VW(3),VAXIS(3,4),VK(3,100),XZ(3)
*
      INCLUDE 'FOLD.INC'
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
      INCLUDE '/usr/include/gl/fsphere.h'
*
      I1=POS(4,IHEL2-3,ICHL)
      I2=POS(4,IHEL2,ICHL)
*
* get ends of helix.
*
      DO 717 I=1,3
      BV(I,1)=XAXIS(I,I1)
      BV(I,2)=XAXIS(I,I2)
717   CONTINUE
*
      CALL DWCYL(1.2,2.0,3.0,BV,STX,DTX,DTY,DTZ)
*
* Draw helix.
*
      IF ((IHEL2-3).GT.IHEL1) THEN
*
      DO 50 J=IHEL1+1,IHEL2-3
*
* draw lines.
*
      IJ=POS(4,J,ICHL)
      IJ1=POS(4,J-1,ICHL)
*
      IF (IJ1.GT.0.AND.IJ.GT.1) THEN
*
      CALL DWBCYL(1.2*STX,
     +STX*XAXIS(1,IJ)+DTX,
     +STX*XAXIS(2,IJ)+DTY,
     +STX*XAXIS(3,IJ)+DTZ,
     +STX*XAXIS(1,IJ1)+DTX,
     +STX*XAXIS(2,IJ1)+DTY,
     +STX*XAXIS(3,IJ1)+DTZ)
*
      ENDIF
*
50    CONTINUE
*
* smooth corners
*
      SC(4)=1.2*STX
      DO 14 J=IHEL1+1,IHEL2-3
*
      IJ=POS(4,J,ICHL)
*
      IF (IJ.GT.0) THEN
*
      SC(1)=STX*XAXIS(1,IJ)+DTX
      SC(2)=STX*XAXIS(2,IJ)+DTY
      SC(3)=STX*XAXIS(3,IJ)+DTZ
*
* draw sphere.
*
      CALL SPHDRA(SC)
*
      ENDIF
*
14    CONTINUE
*
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------
*
* fit spline in 3D.
*
*
* bezier
*    {-1.0,  3.0, -3.0, 1.0}
*    { 3.0, -6.0,  3.0, 0.0}
*    {-3.0,  3.0,  0.0, 0.0}
*    { 1.0,  0.0,  0.0, 0.0} 
*
* cardinal
*    {-0.5,  1.5, -1.5,  0.5}
*    { 1.0, -2.5,  2.0, -0.5}
*    {-0.5,  0.0,  0.5,  0.0}
*    { 0.0,  1.0,  0.0,  0.0}
*
* b spline
*    {-1.0/6.0,  3.0/6.0, -3.0/6.0, 1.0/6.0}
*    { 3.0/6.0, -6.0/6.0,  3.0/6.0,     0.0}
*    {-3.0/6.0,  0.0,      3.0/6.0,     0.0}
*    { 1.0/6.0,  4.0/6.0,  1.0/6.0,     0.0}
*
*
      SUBROUTINE GTSPL(NSEG,NAXIS,INDX,XAXIS)
*
* Declarations
*
      INTEGER NAXIS,INDX(9000),NSEG,IP
*
      REAL XAXIS(3,9000),XK(3,9000),SUM,FN1,FN3,FN2
*
      REAL S(4,4),B(4,4),M(4,4),G(4,4),RI(4,4)
*
* Error trap.
*
      IF (NSEG.LT.4) RETURN
      IF (NAXIS.LT.1) RETURN
*
* reset matrices.
*
      DO 1 I=1,4
      DO 1 J=1,4
      S(J,I)=0.0
      B(J,I)=0.0
      M(J,I)=0.0
      G(J,I)=1.0
1     CONTINUE
*
* fill S
*
      FN1=1.0/FLOAT(NSEG)
      FN2=FN1*FN1
      FN3=FN1*FN2
*
      S(1,1)=6.0*FN3
      S(2,1)=6.0*FN3
      S(3,1)=FN3
      S(2,2)=2.0*FN2
      S(3,2)=FN2
      S(3,3)=FN1
      S(4,4)=1.0
*
      B(1,1)=-1.0
      B(2,1)=3.0
      B(3,1)=-3.0
      B(4,1)=1.0
      B(1,2)=3.0
      B(2,2)=-6.0
      B(4,2)=4.0
      B(1,3)=-3.0
      B(2,3)=3.0
      B(3,3)=3.0
      B(4,3)=1.0
      B(1,4)=1.0
*
      DO 7 I=1,4
      DO 7 J=1,4
      B(J,I)=B(J,I)/6.0
7     CONTINUE
*
* do points.
*
      DO 10 K=2,NAXIS-2
*
      I1=INDX(K-1)
      I2=INDX(K)
      I3=INDX(K+1)
      I4=INDX(K+2)
*
      DO 8 I=1,3
      G(1,I)=XAXIS(I,I1)
      G(2,I)=XAXIS(I,I2)
      G(3,I)=XAXIS(I,I3)
      G(4,I)=XAXIS(I,I4)
8     CONTINUE
*
* get product of sub matrices.
*
      DO 2 II=1,4
      DO 2 J1=1,4
      SUM=0.0
      DO 3 K1=1,4
      SUM=SUM+B(II,K1)*G(K1,J1)
3     CONTINUE
      RI(II,J1)=SUM
2     CONTINUE
*
      DO 4 II=1,4
      DO 4 J1=1,4
      SUM=0.0
      DO 5 K1=1,4
      SUM=SUM+S(II,K1)*RI(K1,J1)
5     CONTINUE
      M(II,J1)=SUM
4     CONTINUE
*
* generate points of spline.
*
      IP=IP+1
*
      DO 20 I=1,NSEG
*
      DO 21 K1=4,2,-1
      DO 22 K2=1,4
      M(K1,K2)=M(K1,K2)+M(K1-1,K2)
22    CONTINUE
21    CONTINUE
*
      IF (I.EQ.2) THEN
      XK(1,K)=M(4,1)/M(4,4)
      XK(2,K)=M(4,2)/M(4,4)
      XK(3,K)=M(4,3)/M(4,4)
      ENDIF
*
20    CONTINUE
*
10    CONTINUE
*
* copy back smoothed points.
*
      DO 12 I=1,NAXIS
      IP=INDX(I)
      DO 14 J=1,3
      XAXIS(J,IP)=XK(J,I)
14    CONTINUE
12    CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE GTSPL2(NSEG,XAXIS,XK)
*
* Declarations
*
      INTEGER NSEG,IP
*
      REAL XAXIS(3,4),XK(3,100),SUM,FN1,FN3,FN2
*
      REAL S(4,4),B(4,4),M(4,4),G(4,4),RI(4,4)
*
* Error trap.
*
      IF (NSEG.LT.4) RETURN
*
* reset matrices.
*
      DO 1 I=1,4
      DO 1 J=1,4
      S(J,I)=0.0
      B(J,I)=0.0
      M(J,I)=0.0
      G(J,I)=1.0
1     CONTINUE
*
* fill S
*
      FN1=1.0/FLOAT(NSEG)
      FN2=FN1*FN1
      FN3=FN1*FN2
*
      S(1,1)=6.0*FN3
      S(2,1)=6.0*FN3
      S(3,1)=FN3
      S(2,2)=2.0*FN2
      S(3,2)=FN2
      S(3,3)=FN1
      S(4,4)=1.0
*
      B(1,1)=-1.0
      B(2,1)=3.0
      B(3,1)=-3.0
      B(4,1)=1.0
      B(1,2)=3.0
      B(2,2)=-6.0
      B(4,2)=4.0
      B(1,3)=-3.0
      B(2,3)=3.0
      B(3,3)=3.0
      B(4,3)=1.0
      B(1,4)=1.0
*
      DO 7 I=1,4
      DO 7 J=1,4
      B(J,I)=B(J,I)/6.0
7     CONTINUE
*
* do points.
*
      DO 8 I=1,3
      G(1,I)=XAXIS(I,1)
      G(2,I)=XAXIS(I,2)
      G(3,I)=XAXIS(I,3)
      G(4,I)=XAXIS(I,4)
8     CONTINUE
*
* get product of sub matrices.
*
      DO 2 II=1,4
      DO 2 J1=1,4
      SUM=0.0
      DO 3 K1=1,4
      SUM=SUM+B(II,K1)*G(K1,J1)
3     CONTINUE
      RI(II,J1)=SUM
2     CONTINUE
*
      DO 4 II=1,4
      DO 4 J1=1,4
      SUM=0.0
      DO 5 K1=1,4
      SUM=SUM+S(II,K1)*RI(K1,J1)
5     CONTINUE
      M(II,J1)=SUM
4     CONTINUE
*
* generate points of spline.
*
      XK(1,1)=M(4,1)/M(4,4)
      XK(2,1)=M(4,2)/M(4,4)
      XK(3,1)=M(4,3)/M(4,4)
*
      IP=1
      DO 20 I=1,NSEG
*
      DO 21 K1=4,2,-1
      DO 22 K2=1,4
      M(K1,K2)=M(K1,K2)+M(K1-1,K2)
22    CONTINUE
21    CONTINUE
*
      IP=IP+1
*
      XK(1,IP)=M(4,1)/M(4,4)
      XK(2,IP)=M(4,2)/M(4,4)
      XK(3,IP)=M(4,3)/M(4,4)
*
20    CONTINUE
*
* copy back smoothed points.
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* draw molecule.
*
      SUBROUTINE GETLOP
*
* Declarations.
*
      INTEGER IDIS,I,J,ICHL
*
* include statements.
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      DO 15 I=1,CHL
*
      DO 16 J=1,1000
      LOOPS(J,I)=-1
16    CONTINUE
*
      DO 17 J=RN1(I),RN2(I)
      IF ((POS(0,J,I).LT.1.OR.POS(-1,J,I).LT.4)) THEN
      LOOPS(J,I)=2
      ELSE
      I1=POS(4,J,I)
      IF (ATNAM(I1).NE.'CA  ') THEN
      LOOPS(J,I)=2
      ENDIF
      ENDIF
17    CONTINUE
*
15    CONTINUE
*
* mark ranges.
*
      DO 3 ICHL=1,CHL
      DO 3 I=1,NSTRAND(ICHL)
      DO 4 J=STRAND1(I,ICHL),STRAND2(I,ICHL)
      LOOPS(J,ICHL)=2
4     CONTINUE
3     CONTINUE
*
* Helices.
*
      DO 1 ICHL=1,CHL
      DO 1 I=1,NHEL4(ICHL)
      DO 2 J=HEL4N1(I,ICHL),HEL4N2(I,ICHL)
      LOOPS(J,ICHL)=2
2     CONTINUE
1     CONTINUE
*
      DO 5 ICHL=1,CHL
      DO 5 I=1,NHEL3(ICHL)
      DO 6 J=HEL3N1(I,ICHL),HEL3N2(I,ICHL)
      LOOPS(J,ICHL)=2
6     CONTINUE
5     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Draw arc.
*
      SUBROUTINE 
     +DWLOOP(DTX,DTY,STX,DTZ,XAXIS)
*
* Declarations.
*
      INTEGER I,I1,J,IJ,IJ1
*
      REAL XAXIS(3,9000),DTX,DTY,STX,DTZ,SC(4)
*
      INCLUDE 'FOLD.INC'
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
      INCLUDE '/usr/include/gl/fsphere.h'
*
      SC(4)=0.2*STX
*
      DO 50 I=1,CHL
*
* draw lines.
*
      DO 51 J=RN1(I)+1,RN2(I)
*
      IF (LOOPS(J-1,I).LT.1.OR.LOOPS(J,I).LT.1) THEN
*
      IJ=POS(4,J,I)
      IJ1=POS(4,J-1,I)
*
      IF (IJ1.GT.0.AND.IJ.GT.0) THEN
*
      CALL DWBCYL(0.2*STX,
     +STX*XAXIS(1,IJ)+DTX,
     +STX*XAXIS(2,IJ)+DTY,
     +STX*XAXIS(3,IJ)+DTZ,
     +STX*XAXIS(1,IJ1)+DTX,
     +STX*XAXIS(2,IJ1)+DTY,
     +STX*XAXIS(3,IJ1)+DTZ)
*
      ENDIF
      ENDIF
*
51    CONTINUE
*
* smooth corners
*
      DO 14 J=RN1(I),RN2(I)
*
      IF (LOOPS(J,I).LT.1) THEN
*
      IJ=POS(4,J,I)
*
      IF (IJ.GT.0) THEN
*
      SC(1)=STX*XAXIS(1,IJ)+DTX
      SC(2)=STX*XAXIS(2,IJ)+DTY
      SC(3)=STX*XAXIS(3,IJ)+DTZ
*
* draw sphere.
*
      CALL SPHDRA(SC)
*
      ENDIF
      ENDIF
*
14    CONTINUE
*
50    CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* normalise 3-vector.
*
      SUBROUTINE NORM3(X)
*
* declarations.
*
      REAL X(3),SUM
*
* get square of vector length.
*
      SUM=X(1)**2+X(2)**2+X(3)**2
*
* error trap.
*
      IF (SUM.GT.0.0) THEN
*
* get length of vector.
*
      SUM=SQRT(SUM)
*
* normalise.
*
      DO 1 I=1,3
      X(I)=X(I)/SUM
1     CONTINUE
*
      ENDIF
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* cross product.
*
      SUBROUTINE CROSS3(VV,X2,X1)
*
* declarations.
*
      REAL VV(3),X2(3),X1(3)
*
* explicit calculation.
*
      VV(1)=X1(2)*X2(3) - X2(2)*X1(3)
      VV(2)=X1(3)*X2(1) - X2(3)*X1(1)
      VV(3)=X1(1)*X2(2) - X2(1)*X1(2)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Calculate 3x3 rotation matrix from 4 quaternion parameters Q(1-4).
*
      SUBROUTINE QUTROT(R,Q,DET)
*
* declarations.
*
      IMPLICIT INTEGER (A-Z)
*
      REAL R(3,3),Q(4),PQ(4),PS(4),PV(4,4),DET
*
* normalise quaternion components.
*
      CALL NORM4(Q,PQ)
*
* create the elements of the matrix in simple way. 
*
      DO 1 I=1,4
      DO 1 J=1,4        
      PV(J,I)=PQ(I)*PQ(J)
1     CONTINUE
*
      DO 2 I=1,4
      PS(I)=PV(I,I)
2     CONTINUE
*
      R(1,1)=PS(1)+PS(2)-PS(3)-PS(4)
      R(2,2)=PS(1)-PS(2)+PS(3)-PS(4)
      R(3,3)=PS(1)-PS(2)-PS(3)+PS(4)
*
      R(1,2)=2.0*(PV(2,3)+PV(1,4))
      R(2,1)=2.0*(PV(2,3)-PV(1,4))
      R(1,3)=2.0*(PV(2,4)-PV(1,3))
*
      R(3,1)=2.0*(PV(2,4)+PV(1,3))
      R(2,3)=2.0*(PV(3,4)+PV(1,2))
      R(3,2)=2.0*(PV(3,4)-PV(1,2))
*
* calculate determinant.
*
      DET=0.0
      DO 3 I=1,4
      DET=DET+PS(I)
3     CONTINUE
      DET=DET**(1.0/3.0)
*
* Format Statements.
*
1000  FORMAT(/' Determinant: ',F8.3/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* return normalised 4-vector.
*
      SUBROUTINE NORM4(Q,NQ)
*
* declarations.
*
      IMPLICIT INTEGER (A-Z)
*
      REAL Q(4),NQ(4),SUM
*
* initialise.
*
      SUM=0.0
*
* get length of 4-vector.
*
      DO 1 I=1,4
      SUM=SUM+Q(I)*Q(I)
1     CONTINUE
*
* error trap.
*
      IF (SUM.GT.0.0) THEN
      SUM=SQRT(SUM)
      DO 2 I=1,4
      NQ(I)=Q(I)/SUM
2     CONTINUE
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* draw molecule.
*
      SUBROUTINE GETBND
*
* Declarations.
*
      INTEGER IDIS,I,J,ICHL
*
* include statements.
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      NBOND=0
*
      DO 78 I=1,NN
      AT(I)=0
78    CONTINUE
*
* work through all chains
*      
      DO 1 ICHL=1,CHL
*
      DO 2 J=RN1(ICHL),RN2(ICHL)
*
* get bonds in this residue.
*
      CALL BNDINC(4,1,J,J,ICHL)
      CALL BNDINC(2,3,J,J,ICHL)
      CALL BNDINC(2,4,J,J,ICHL)
      CALL BNDINC(4,5,J,J,ICHL)
*
      CALL BNDINC(1,2,J,J-1,ICHL)
*
      I1=POS(1,J,ICHL)
      AT(I1)=1
      I1=POS(2,J,ICHL)
      AT(I1)=1
      I1=POS(3,J,ICHL)
      AT(I1)=1
      I1=POS(4,J,ICHL)
      AT(I1)=1
      I1=POS(5,J,ICHL)
      AT(I1)=1
*
2     CONTINUE
*
1     CONTINUE
*
      RETURN
      END
*
*N1
*C3
*O2
*CA4
*
*-------------------------------------------------------------------------------
*
* draw molecule.
*
      SUBROUTINE BNDINC(K1,K2,J1,J2,ICHL)
*
* Declarations.
*
      INTEGER IDIS,I,J,ICHL
*
* include statements.
*
      INCLUDE 'FOLD.INC'
*
* increment list of bonds.
*
      I1=POS(K1,J1,ICHL)
      I2=POS(K2,J2,ICHL)
      IF (I1.GT.0.AND.I2.GT.0) THEN
      NBOND=NBOND+1
      LSTBND(1,NBOND)=I1
      LSTBND(2,NBOND)=I2
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* draw molecule.
*
      SUBROUTINE GETSSC
*
* Declarations.
*
      INTEGER IDIS,I,J,ICHL
      CHARACTER A1*1
*
* include statements.
*
      INCLUDE 'FOLD.INC'
*
*
*
      DO 1 I=1,CHL
      DO 2 J=RN1(I),RN2(I)
*
      A1=STRSYM(J,I)
*
      IF (A1.EQ.'E') THEN
      I1=6
      ELSEIF (A1.EQ.'P') THEN
      I1=6
      ELSEIF (A1.EQ.'A') THEN
      I1=6
      ELSEIF (A1.EQ.'4') THEN
      I1=8
      ELSEIF (A1.EQ.'3') THEN
      I1=16
      ELSE
      I1=7
      ENDIF
*
      DO 3 K=1,POS(-1,J,I)
      I2=POS(K,J,I)
      IF (I2.GT.0) ATY(I2)=I1
3     CONTINUE
*
2     CONTINUE
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Actually draw molecule
*
      SUBROUTINE DWMOL5(XG,YG,ZG,DTX,DTY,STX,DTZ)
*
* Declarations.
*
      INTEGER XSIZE,IZMX,IZMN
      REAL XG(9000),YG(9000),ZG(9000)
      REAL X1,X2,X3,X4,Y1,Y2,Y3,Y4,Z1,Z2,Z3,Z4
      REAL DTX,DTY,STX,DTZ,SC(4),ATMRAD,SSK
*
      INCLUDE 'FOLD.INC'
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
      INCLUDE '/usr/include/gl/fsphere.h'
*
      ATMRAD=0.18
*
* change to colour change lighting mode.
*
      CALL LMCOLO(LMCAMB)
*
*      CALL SPHMOD(SPHDEP,10)
*
      SC(4)=ATMRAD*STX
      SSK=0.1*STX
*
* draw all atoms.
*
      DO 44 I=1,NN
*
* Error trap.
*
      IF (AT(I).LT.1) GOTO 44
*
* Colour atom.
*
      CALL ELECOL(ATY(I),255)
*
      SC(1)=STX*XG(I)+DTX
      SC(2)=STX*YG(I)+DTY
      SC(3)=STX*ZG(I)+DTZ
*
* draw sphere.
*
      CALL SPHDRA(SC)
*
44    CONTINUE
*
* set up depth cueing parameters.
*
      IZMN=10
      IZMX=255
*
      DO 1 I=1,NBOND
*
* get pointers.
*
      I1=LSTBND(1,I)
      I2=LSTBND(2,I)
*
      IF (AT(I1).LT.1.OR.AT(I2).LT.1) GOTO 1
*
* local copy of coordinates.
*
      X1=XG(I1)
      Y1=YG(I1)
      Z1=ZG(I1)
*
      X2=XG(I2)
      Y2=YG(I2)
      Z2=ZG(I2)
*
* draw cylindrical bond.
*
      CALL
     +DWCYLB(ATY(I1),ATY(I2),
     +IZMX,IZMN,X1,X2,Y1,Y2,Z1,Z2,DTX,DTY,STX,DTZ,SC(4))
*
1     CONTINUE
*
      DO 2 I=1,NHBOND
*
* get pointers.
*
      I1=LSTHBD(1,I)
      I2=LSTHBD(2,I)
*
* local copy of coordinates.
*
      X1=XG(I1)
      Y1=YG(I1)
      Z1=ZG(I1)
*
      X2=XG(I2)
      Y2=YG(I2)
      Z2=ZG(I2)
*
* draw bond.
*
      CALL
     +DWCYLB(15,15,
     +IZMX,IZMN,X1,X2,Y1,Y2,Z1,Z2,DTX,DTY,STX,DTZ,SSK)
*
2     CONTINUE

* default lighting mode
*
      CALL LMCOLO(LMCCOL) 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Actually draw molecule
*
      SUBROUTINE DWSTND(IST,ICHL,XG,YG,ZG,XAXIS,DTX,DTY,STX,DTZ)
*
* Declarations.
*
      INTEGER I1,I2,I3,I,I4,IST,NXI,IDC
      REAL XG(9000),YG(9000),ZG(9000),XAXIS(3,9000),SAXIS(3,4)
      REAL X1(3),X2(3),X3(3),XW(3),X4(3),X5(3),X6(3),XS1(3),XS2(3)
      REAL X1T(3),X2T(3),X3T(3),X4T(3),VV3(3),VV4(3)
      REAL X7(3),X1K,Y1K,Z1K,X2K,Y2K,Z2K,V1(3),V2(3)
      REAL XX1(3),XX2(3),XX3(3),XX4(3),VK(3,100),VAXIS(3,4),
     +     GAXIS(3,9000),DAXIS(3,9000),NAXIS(3,9000)
      REAL VN(3),VV(3),VV1(3),VV2(3),VN1(3),VN2(3),VB(3),VAZI(3),
     +VNS(3),VNZ(3),VNV(3),VNK(3),VS1(3),VS2(3),VS3(3),VS4(3)
*
      REAL DTX,DTY,STX,DTZ,SWID,DWID,VB1(3),VB2(3)
*
      REAL XK1(3,9000),XK2(3,9000),XK3(3,9000),XK4(3,900),
     +XVZ(3,9000),VK1(3,100),VK2(3,100),VK3(3,100),VK4(3,100)
*
      REAL XUM(3,9000),XUP(3,9000),XDM(3,9000),XDP(3,9000)
*
      INCLUDE 'FOLD.INC'
*
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* Error trap.
*
      IF (ICHL.GT.0) THEN
*
* Initialise.
*
      SWID=1.5
      DWID=0.3
*
      VNS(1)=1.0
      VNS(2)=0.0
      VNS(3)=0.0
      VNK(1)=1.0
      VNK(2)=0.0
      VNK(3)=0.0
*
      ISEND=0
*
* Work through strand.
*
      DO 972 J=STRAND1(IST,ICHL)-1,STRAND2(IST,ICHL)+1
*
* get pointers
*
      I1=POS(4,J-1,ICHL)
      I2=POS(4,J,ICHL)
      I3=POS(4,J+1,ICHL)
*
      IF (I1.GT.0.AND.I2.GT.0.AND.I3.GT.0) THEN
*
      X1(1)=XG(I1)
      X1(2)=YG(I1)
      X1(3)=ZG(I1)
*
      X2(1)=XG(I2)
      X2(2)=YG(I2)
      X2(3)=ZG(I2)
*
      X3(1)=XG(I3)
      X3(2)=YG(I3)
      X3(3)=ZG(I3)
*
* get vectors.
*
      DO 971 I=1,3
      V1(I)=X2(I)-X1(I)
      V2(I)=X2(I)-X3(I)
      VV(I)=V1(I)+V2(I)
971   CONTINUE
*
* in plane.
*
      CALL NORM3(VV)
*
* get vector normal to CA-CA-CA plane.
*
      CALL CROSS3(VN,V1,V2)
*
      IF (J.GT.(STRAND1(IST,ICHL)-1)) THEN
*
* project so all point same way.
*
      CALL PROJV(VNS,VN,VNZ)
      CALL PROJV(VNK,VV,VNV)
*
      DO 1435 I=1,3
      VN(I)=VNZ(I)
      VV(I)=VNV(I)
1435  CONTINUE
      ENDIF
*
      CALL NORM3(VN)
      CALL NORM3(VV)
*
* get Calpha position.
*
      CALL REGBET(
     +XG(I1),YG(I1),ZG(I1),
     +XG(I2),YG(I2),ZG(I2),
     +XG(I3),YG(I3),ZG(I3),
     +X2(1),X2(2),X2(3),DIST,
     +ISEND,X1K,Y1K,Z1K,X2K,Y2K,Z2K)
*
* Create and save points of block.
*
      DO 973 I=1,3
      GAXIS(I,I2)=VV(I)
      XAXIS(I,I2)=X2(I)
      XK1(I,I2)=X2(I)-VN(I)*SWID+VV(I)*DWID
      XK2(I,I2)=X2(I)+VN(I)*SWID+VV(I)*DWID
      XK3(I,I2)=X2(I)-VN(I)*SWID-VV(I)*DWID
      XK4(I,I2)=X2(I)+VN(I)*SWID-VV(I)*DWID
      VNS(I)=VN(I)
      VNK(I)=VV(I)
973   CONTINUE
*
      ENDIF
*
972   CONTINUE
*
* Work through chain.
*
      ISEND=1
      DO 892 J=STRAND1(IST,ICHL)-1,STRAND2(IST,ICHL)+1
*
* get pointers
*
      I1=POS(4,J-1,ICHL)
      I2=POS(4,J,ICHL)
      I3=POS(4,J+1,ICHL)
*
      IF (I1.GT.0.AND.I2.GT.0.AND.I3.GT.0) THEN
*
* smooth projected vectors.
*
      CALL REGBET(
     +XK1(1,I1),XK1(2,I1),XK1(3,I1),
     +XK1(1,I2),XK1(2,I2),XK1(3,I2),
     +XK1(1,I3),XK1(2,I3),XK1(3,I3),
     +X1(1),X1(2),X1(3),DIST,
     +ISEND,X1K,Y1K,Z1K,X2K,Y2K,Z2K)
*
      CALL REGBET(
     +XK2(1,I1),XK2(2,I1),XK2(3,I1),
     +XK2(1,I2),XK2(2,I2),XK2(3,I2),
     +XK2(1,I3),XK2(2,I3),XK2(3,I3),
     +X2(1),X2(2),X2(3),DIST,
     +ISEND,X1K,Y1K,Z1K,X2K,Y2K,Z2K)
*
      CALL REGBET(
     +XK3(1,I1),XK3(2,I1),XK3(3,I1),
     +XK3(1,I2),XK3(2,I2),XK3(3,I2),
     +XK3(1,I3),XK3(2,I3),XK3(3,I3),
     +X3(1),X3(2),X3(3),DIST,
     +ISEND,X1K,Y1K,Z1K,X2K,Y2K,Z2K)
*
      CALL REGBET(
     +XK4(1,I1),XK4(2,I1),XK4(3,I1),
     +XK4(1,I2),XK4(2,I2),XK4(3,I2),
     +XK4(1,I3),XK4(2,I3),XK4(3,I3),
     +X4(1),X4(2),X4(3),DIST,
     +ISEND,X1K,Y1K,Z1K,X2K,Y2K,Z2K)
*
* reset pointer.
*
      ISEND=0
*
* Save.
*
      DO 897 I=1,3
      XUM(I,I2)=X1(I)
      XUP(I,I2)=X2(I)
      XDM(I,I2)=X3(I)
      XDP(I,I2)=X4(I)
897   CONTINUE
*
      ENDIF
*
892   CONTINUE
*
* regularize N and C-terminii.
*
      I1=POS(4,STRAND2(IST,ICHL)-2,ICHL)
      I2=POS(4,STRAND2(IST,ICHL)-1,ICHL)
      DO 797 I=1,3
      VS1(I)=XUM(I,I2)-XUM(I,I1)
      VS2(I)=XUP(I,I2)-XUP(I,I1)
      VS3(I)=XDM(I,I2)-XDM(I,I1)
      VS4(I)=XDP(I,I2)-XDP(I,I1)
797   CONTINUE
*
      CALL NORM3(VS1)
      CALL NORM3(VS2)
      CALL NORM3(VS3)
      CALL NORM3(VS4)
*
      I1=POS(4,STRAND2(IST,ICHL)-1,ICHL)
      I2=POS(4,STRAND2(IST,ICHL),ICHL)
      DO 798 I=1,3
      XUM(I,I2)=XUM(I,I1)+3.4*VS1(I)
      XUP(I,I2)=XUP(I,I1)+3.4*VS2(I)
      XDM(I,I2)=XDM(I,I1)+3.4*VS3(I)
      XDP(I,I2)=XDP(I,I1)+3.4*VS4(I)
798   CONTINUE
*
      I1=POS(4,STRAND1(IST,ICHL)+2,ICHL)
      I2=POS(4,STRAND1(IST,ICHL)+1,ICHL)
      DO 2797 I=1,3
      VS1(I)=XUM(I,I2)-XUM(I,I1)
      VS2(I)=XUP(I,I2)-XUP(I,I1)
      VS3(I)=XDM(I,I2)-XDM(I,I1)
      VS4(I)=XDP(I,I2)-XDP(I,I1)
2797  CONTINUE
*
      CALL NORM3(VS1)
      CALL NORM3(VS2)
      CALL NORM3(VS3)
      CALL NORM3(VS4)
*
      I1=POS(4,STRAND1(IST,ICHL)+1,ICHL)
      I2=POS(4,STRAND1(IST,ICHL),ICHL)
      I3=POS(4,STRAND1(IST,ICHL)-1,ICHL)
      DO 2798 I=1,3
      XUM(I,I2)=XUM(I,I1)+3.4*VS1(I)
      XUP(I,I2)=XUP(I,I1)+3.4*VS2(I)
      XDM(I,I2)=XDM(I,I1)+3.4*VS3(I)
      XDP(I,I2)=XDP(I,I1)+3.4*VS4(I)
      XUM(I,I3)=XUM(I,I1)+4.4*VS1(I)
      XUP(I,I3)=XUP(I,I1)+4.4*VS2(I)
      XDM(I,I3)=XDM(I,I1)+4.4*VS3(I)
      XDP(I,I3)=XDP(I,I1)+4.4*VS4(I)
2798  CONTINUE

* Actually draw it.
*
      JDEC=0
      I1=POS(4,STRAND1(IST,ICHL),ICHL)
      VN(1)=GAXIS(1,I1)
      VN(2)=GAXIS(2,I1)
      VN(3)=GAXIS(3,I1)
*
      DO 80 J=STRAND1(IST,ICHL),STRAND2(IST,ICHL)-2
*
      DO 69 I=1,3
      VS1(I)=VK1(I,9)
      VS2(I)=VK2(I,9)
      VS3(I)=VK3(I,9)
      VS4(I)=VK4(I,9)
69    CONTINUE
*
* B-spline interpolation.
*
      I1=POS(4,J-1,ICHL)
      I2=POS(4,J,ICHL)
      I3=POS(4,J+1,ICHL)
      I4=POS(4,J+2,ICHL)
*
      DO 70 I=1,3
      VAXIS(I,1)=XUM(I,I1)
      VAXIS(I,2)=XUM(I,I2)
      VAXIS(I,3)=XUM(I,I3)
      VAXIS(I,4)=XUM(I,I4)
70    CONTINUE
*
      CALL GTSPL2(9,VAXIS,VK1)
*
      DO 71 I=1,3
      VAXIS(I,1)=XUP(I,I1)
      VAXIS(I,2)=XUP(I,I2)
      VAXIS(I,3)=XUP(I,I3)
      VAXIS(I,4)=XUP(I,I4)
71    CONTINUE
*
      CALL GTSPL2(9,VAXIS,VK2)
*
      DO 72 I=1,3
      VAXIS(I,1)=XDM(I,I1)
      VAXIS(I,2)=XDM(I,I2)
      VAXIS(I,3)=XDM(I,I3)
      VAXIS(I,4)=XDM(I,I4)
72    CONTINUE
*
      CALL GTSPL2(9,VAXIS,VK3)
*
      DO 73 I=1,3
      VAXIS(I,1)=XDP(I,I1)
      VAXIS(I,2)=XDP(I,I2)
      VAXIS(I,3)=XDP(I,I3)
      VAXIS(I,4)=XDP(I,I4)
73    CONTINUE
*
      CALL GTSPL2(9,VAXIS,VK4)
*
      IF (JDEC.EQ.0) THEN
      JDEC=1
      ELSE
      DO 75 K=1,3
      X1(K)=VK1(K,1)
      X2(K)=VK2(K,1)
      X3(K)=VK3(K,1)
      X4(K)=VK4(K,1)
75    CONTINUE
      CALL NORM3(VN)
      CALL NORM3(VV)
      CALL DWRECT(IDC,
     +      DTX,DTY,DTZ,STX,
     +      X1,X2,X3,X4,
     +      VS1,VS2,VS3,VS4,VV,VN)
*
      ENDIF
*
      FZ1=1.0
      FZ2=0.0
      DO 90 I=1,8
*
* draw a block.
*
      DO 91 K=1,3
      X1(K)=VK1(K,I)
      X2(K)=VK2(K,I)
      X3(K)=VK3(K,I)
      X4(K)=VK4(K,I)
      X1T(K)=VK1(K,I+1)
      X2T(K)=VK2(K,I+1)
      X3T(K)=VK3(K,I+1)
      X4T(K)=VK4(K,I+1)
91    CONTINUE
*
* get normal.
*
      DO 48 JZ=1,3
      VV(JZ)=VN(JZ)
48    CONTINUE
      FZ1=FZ1-0.1111111
      FZ2=FZ2+0.1111111
      DO 49 JZ=1,3
      VN(JZ)=GAXIS(JZ,I3)*FZ2+GAXIS(JZ,I2)*FZ1
49    CONTINUE
*
      CALL NORM3(VN)
      CALL NORM3(VV)
*
* actually draw it.
*
      CALL DWRECT(IDC,
     +      DTX,DTY,DTZ,STX,
     +      X1T,X2T,X3T,X4T,
     +      X1,X2,X3,X4,
     +      VV,VN)
*
90    CONTINUE
*
* increment normal.
*
      FZ1=FZ1-0.1111111
      FZ2=FZ2+0.1111111
      DO 41 JZ=1,3
      VV(JZ)=VN(JZ)
      VN(JZ)=GAXIS(JZ,I3)*FZ2+GAXIS(JZ,I2)*FZ1
41    CONTINUE
*
80    CONTINUE
*
* Draw Arrow head.
*
      DO 1897 I=1,3
      VS1(I)=VK1(I,9)-VK1(I,8)
      VS2(I)=VK2(I,9)-VK2(I,8)
      VS3(I)=VK3(I,9)-VK3(I,8)
      VS4(I)=VK4(I,9)-VK4(I,8)
1897  CONTINUE
*
      CALL NORM3(VS1)
      CALL NORM3(VS2)
      CALL NORM3(VS3)
      CALL NORM3(VS4)
*
      I1=POS(4,STRAND2(IST,ICHL)-1,ICHL)
      I2=POS(4,STRAND2(IST,ICHL),ICHL)
*
      DO 898 I=1,3
      XUM(I,I2)=VK1(I,8)+3.4*VS1(I)
      XUP(I,I2)=VK2(I,8)+3.4*VS2(I)
      XDM(I,I2)=VK3(I,8)+3.4*VS3(I)
      XDP(I,I2)=VK4(I,8)+3.4*VS4(I)
898   CONTINUE
*
      DO 224 I=1,3
      XX1(I)=X1T(I)-X2T(I)
      XX2(I)=X3T(I)-X4T(I)
224   CONTINUE
      CALL NORM3(XX2)
      CALL NORM3(XX1)
      DO 245 I=1,3
      XX3(I)=(XUM(I,I2)+XUP(I,I2))*0.5
      XX4(I)=(XDM(I,I2)+XDP(I,I2))*0.5
      VV1(I)=(X1T(I)+0.7*XX1(I))
      VV2(I)=(X2T(I)-0.7*XX1(I))
      VV3(I)=(X3T(I)+0.7*XX2(I))
      VV4(I)=(X4T(I)-0.7*XX2(I))
245   CONTINUE
*
* create points of arrow head.
* Draw them. 
*
      CALL DWRECT(IDC,
     +      DTX,DTY,DTZ,STX,
     +      XX3,XX3,XX4,XX4,
     +      VV1,VV2,VV3,VV4,
     +      VN,VN)

292   CONTINUE
*
      ENDIF
*
* store end points.
*
      I1=POS(4,STRAND1(IST,ICHL),ICHL)
      I2=POS(4,STRAND2(IST,ICHL),ICHL)
*
      DO 413 I=1,3
      XAXIS(I,I1)=0.25*(XUM(I,I1)+XUP(I,I1)+
     + XDM(I,I1)+XDP(I,I1))
      XAXIS(I,I2)=0.25*(XUM(I,I2)+XUP(I,I2)+
     + XDM(I,I2)+XDP(I,I2))
413   CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* draw a cuboid.
*
      SUBROUTINE DWRECT(IDEC,
     + DTX,DTY,DTZ,STX,
     + XUM,XUP,XDM,XDP,
     + XUMF,XUPF,XDMF,XDPF,VN,VV)
*
* Declarations.
*
      INTEGER I
      REAL XUM(3),XUP(3),XDM(3),XDP(3),
     + XUMF(3),XUPF(3),XDMF(3),XDPF(3)
      REAL VN(3),VV(3),VN1(3),VV1(3)
*
      REAL XX1(3),XX2(3),XX3(3),XX4(3)
      REAL DTX,DTY,STX,DTZ
*
      INCLUDE 'FOLD.INC'
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* top face.
*
      CALL DWR1(
     + DTX,DTY,DTZ,STX,
     + XUM,XUP,XUPF,XUMF,
     + VV,VV,VN,VN)
*
* bottom face.
*
      DO 20 I=1,3
      VV1(I)=-VV(I)
      VN1(I)=-VN(I)
20    CONTINUE 
      CALL DWR1(
     + DTX,DTY,DTZ,STX,
     + XDM,XDP,XDPF,XDMF,
     + VV1,VV1,VN1,VN1)
*
* a side face.
*
      DO 3 I=1,3
      XX1(I)=XUP(I)-XUM(I)
      XX2(I)=XDP(I)-XDM(I)
      XX3(I)=XDPF(I)-XDMF(I)
      XX4(I)=XUPF(I)-XUMF(I)
3     CONTINUE
      CALL NORM3(XX1)
      CALL NORM3(XX2)
      CALL NORM3(XX3)
      CALL NORM3(XX4)
      CALL DWR1(
     + DTX,DTY,DTZ,STX,
     + XUP,XDP,XDPF,XUPF,
     + XX1,XX2,XX3,XX4)
*
* the other side face.
*
      DO 4 I=1,3
      XX1(I)=XUM(I)-XUP(I)
      XX2(I)=XDM(I)-XDP(I)
      XX3(I)=XDMF(I)-XDPF(I)
      XX4(I)=XUMF(I)-XUPF(I)
4     CONTINUE
      CALL NORM3(XX1)
      CALL NORM3(XX2)
      CALL NORM3(XX3)
      CALL NORM3(XX4)
      CALL DWR1(
     + DTX,DTY,DTZ,STX,
     + XUM,XDM,XDMF,XUMF,
     + XX1,XX2,XX3,XX4)
*
* first end face.
*
      IF (IDEC.EQ.1) THEN
      DO 5 I=1,3
      XX1(I)=XUM(I)-XUMF(I)
      XX2(I)=XDM(I)-XDMF(I)
      XX3(I)=XDP(I)-XDPF(I)
      XX4(I)=XUP(I)-XUPF(I)
5     CONTINUE
      CALL NORM3(XX1)
      CALL NORM3(XX2)
      CALL NORM3(XX3)
      CALL NORM3(XX4)
      CALL DWR1(
     + DTX,DTY,DTZ,STX,
     + XUM,XDM,XDP,XUP,
     + XX1,XX2,XX3,XX4)
      ENDIF
*
      RETURN
      END
*
*----------------------------------------------------------------------------------
*
      SUBROUTINE DWR1(
     + DTX,DTY,DTZ,STX,
     + X1,X2,X3,X4,N1,N2,N3,N4)
*
* Declarations.
*
      REAL X1(3),X2(3),X3(3),XW(3),X4(3)
      REAL N1(3),N2(3),N3(3),N4(3)
      REAL DTX,DTY,STX,DTZ
*
      INCLUDE 'FOLD.INC'
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* draw a plate.
*
      CALL BGNPOL
*
      XW(1)=STX*X1(1)+DTX
      XW(2)=STX*X1(2)+DTY
      XW(3)=STX*X1(3)+DTZ
*
      CALL N3F(N1)
      CALL V3F(XW)
*
      XW(1)=STX*X2(1)+DTX
      XW(2)=STX*X2(2)+DTY
      XW(3)=STX*X2(3)+DTZ
*
      CALL N3F(N2)
      CALL V3F(XW)
*
      XW(1)=STX*X3(1)+DTX
      XW(2)=STX*X3(2)+DTY
      XW(3)=STX*X3(3)+DTZ
*
      CALL N3F(N3)
      CALL V3F(XW)
*
      XW(1)=STX*X4(1)+DTX
      XW(2)=STX*X4(2)+DTY
      XW(3)=STX*X4(3)+DTZ
*
      CALL N3F(N4)
      CALL V3F(XW)
*
      CALL ENDPOL
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* subroutine to smooth out beta-sheet strands (or random coil) from 
* three 3-d input points it determines the point between the middle point 
* and the line fromed by the two end points.
*
* IFEND = 0 - normal
*       = 1 - amino
*       = 3 - carboxy
*
      SUBROUTINE REGBET(
     +XA,YA,ZA,XN,YN,ZN,XB,YB,ZB,
     +XNEW,YNEW,ZNEW,DIST,
     +IFEND,
     +X1,Y1,Z1,X2,Y2,Z2)
*
* Declarations.
*
      DATA PI /3.1415926536/
*
* first put -n- at origin.
*
      AX=XA-XN
      AY=YA-YN
      AZ=ZA-ZN
      BX=XB-XN
      BY=YB-YN
      BZ=ZB-ZN
*
      IF (ABS(AX).LE.1E-6) AX=0.0
      IF (ABS(AY).LE.1E-6) AY=0.0
      IF (ABS(AZ).LE.1E-6) AZ=0.0
      IF (ABS(BX).LE.1E-6) BX=0.0
      IF (ABS(BY).LE.1E-6) BY=0.0
      IF (ABS(BZ).LE.1E-6) BZ=0.0
*
      ANG1=0.0
      ANG2=0.0
      ANG3=0.0
*
* rotate around z to bring -a- into x-z plane.
*
      IF (AY.NE.0.0.OR.AX.NE.0.0) ANG1=ATAN2(AY,AX)
*
      CX=AX*COS(-ANG1)-AY*SIN(-ANG1)
      CY=AX*SIN(-ANG1)+AY*COS(-ANG1)
      CZ=AZ
      DX=BX*COS(-ANG1)-BY*SIN(-ANG1)
      DY=BX*SIN(-ANG1)+BY*COS(-ANG1)
      DZ=BZ
*
* rotate around y to bring -a- onto the x axis.
*
      IF (CZ.NE.0.0.OR.CX.NE.0.0) ANG2=ATAN2(CZ,CX)
*
      AX=CX*COS(-ANG2)-CZ*SIN(-ANG2)
      AY=CY
      AZ=CX*SIN(-ANG2)+CZ*COS(-ANG2)
      BX=DX*COS(-ANG2)-DZ*SIN(-ANG2)
      BY=DY
      BZ=DX*SIN(-ANG2)+DZ*COS(-ANG2)
*
* rotate around x to bring -b- into the x-y plane.
*
      IF (BZ.NE.0.0.OR.BY.NE.0.0) ANG3=ATAN2(BZ,BY)
      DX=BX
      DY=BY*COS(-ANG3)-BZ*SIN(-ANG3)
*
* make sure 'Y' is positive.
*
      IF (DY.GE.0.0) GOTO 100
      DY=-DY
      ANG3=ANG3+PI
100   CONTINUE
      DZ=BY*SIN(-ANG3)+BZ*COS(-ANG3)
*
* determine connection positions.
*
      XM=(AX+DX)/4.
      YM=(AY+DY)/4.
      EX=XM
      EY=YM
      EZ=0.0
      DIST=SQRT(EX*EX+EY*EY)
*
* reverse the rotations and shift to get actual position.
*
      FX=EX
      FY=EY*COS(ANG3)-EZ*SIN(ANG3)
      FZ=EY*SIN(ANG3)+EZ*COS(ANG3)
      EX=FX*COS(ANG2)-FZ*SIN(ANG2)
      EY=FY
      EZ=FX*SIN(ANG2)+FZ*COS(ANG2)
      FX=EX*COS(ANG1)-EY*SIN(ANG1)
      FY=EX*SIN(ANG1)+EY*COS(ANG1)
      FZ=EZ
      XNEW=FX+XN
      YNEW=FY+YN
      ZNEW=FZ+ZN
*
      IF (IFEND.EQ.0) RETURN
*
*  special cases: terminii.
*
      TORANG=25*PI/180.
*
      IF (IFEND.EQ.1) THEN
*
* calculate amino terminal position.
*
      EX=AX-XM*COS(TORANG)
      EY=AY-YM*COS(TORANG)
      EZ=-SQRT(XM*XM+YM*YM)*SIN(TORANG)
*
      FX=EX
      FY=EY*COS(ANG3)-EZ*SIN(ANG3)
      FZ=EY*SIN(ANG3)+EZ*COS(ANG3)
      EX=FX*COS(ANG2)-FZ*SIN(ANG2)
      EY=FY
      EZ=FX*SIN(ANG2)+FZ*COS(ANG2)
      FX=EX*COS(ANG1)-EY*SIN(ANG1)
      FY=EX*SIN(ANG1)+EY*COS(ANG1)
      FZ=EZ
*
      X1=FX+XN
      Y1=FY+YN
      Z1=FZ+ZN
*
      ELSEIF (IFEND.EQ.2) THEN
*
* determine carboxy terminal position.
*
      EX=DX-XM*COS(TORANG)
      EY=DY-YM*COS(TORANG)
      EZ=SQRT(XM*XM+YM*YM)*SIN(TORANG)
*
      FX=EX
      FY=EY*COS(ANG3)-EZ*SIN(ANG3)
      FZ=EY*SIN(ANG3)+EZ*COS(ANG3)
      EX=FX*COS(ANG2)-FZ*SIN(ANG2)
      EY=FY
      EZ=FX*SIN(ANG2)+FZ*COS(ANG2)
      FX=EX*COS(ANG1)-EY*SIN(ANG1)
      FY=EX*SIN(ANG1)+EY*COS(ANG1)
      FZ=EZ
*
      X2=FX+XN
      Y2=FY+YN
      Z2=FZ+ZN
*
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Expand radius of helix.
*
      SUBROUTINE MODHEL(XG,YG,ZG)
*
* Declarations.
*
      INTEGER I1,I2,I3,I4,ICHL,ICA,JCHL
      REAL XG(9000),YG(9000),ZG(9000),XAXIS(3,9000),VS(3),V1(3)
*
      INCLUDE 'FOLD.INC'
      INCLUDE '/usr/include/gl/fgl.h'
      INCLUDE '/usr/include/gl/fdevice.h'
*
* get helicoidal axis.
*
      CALL RIBAX(XG,YG,ZG,XAXIS)
*
* work through all helices.
*
      DO 80 JCHL=1,CHL
      DO 1 I=1,NHEL4(JCHL)
*
* get pointers to ends of helix.
*
      II1=HEL4N1(I,JCHL)
      II2=HEL4N2(I,JCHL)
*
      IF (II1.GT.0.AND.II2.GT.0) THEN
*
      DO 2 J=II1,II2
      ICA=POS(4,J,JCHL)
      IF (ICA.GT.0) THEN
*
      V1(1)=XG(ICA)-XAXIS(1,ICA)
      V1(2)=YG(ICA)-XAXIS(2,ICA)
      V1(3)=ZG(ICA)-XAXIS(3,ICA)
*
      CALL NORM3(V1)
*
      XG(ICA)=XAXIS(1,ICA)+V1(1)*4.8
      YG(ICA)=XAXIS(2,ICA)+V1(2)*4.8
      ZG(ICA)=XAXIS(3,ICA)+V1(3)*4.8
*
      ENDIF
2     CONTINUE
*
      ENDIF
*
1     CONTINUE
*
* 310 helices.
*
      DO 11 I=1,NHEL3(JCHL)
*
* get pointers to ends of helix.
*
      II1=HEL3N1(I,JCHL)
      II2=HEL3N2(I,JCHL)
*
      IF (II1.GT.0.AND.II2.GT.0) THEN
*
      DO 12 J=II1,II2
      ICA=POS(4,J,JCHL)
      IF (ICA.GT.0) THEN
*
      V1(1)=XG(ICA)-XAXIS(1,ICA)
      V1(2)=YG(ICA)-XAXIS(2,ICA)
      V1(3)=ZG(ICA)-XAXIS(3,ICA)
*
      CALL NORM3(V1)
*
      XG(ICA)=XAXIS(1,ICA)+V1(1)*4.5
      YG(ICA)=XAXIS(2,ICA)+V1(2)*4.5
      ZG(ICA)=XAXIS(3,ICA)+V1(3)*4.5
*
      ENDIF
12    CONTINUE
*
      ENDIF
*
11    CONTINUE
*
80    CONTINUE
*
      RETURN
      END
*
