*
*
* FOLD:
*
*  Darren R Flower 1991-5.
*
*   Define Secondary structure of a protein from analysis of hydrogen bonding 
*   patterns. Uses protocol related to that of Baker and Hubbard (1984) to 
*   define hydrogen bonds. Uses protocol related in part to that of Kabsch and 
*   Sander (1983) to do recognition of pattern. Use IUPAC definition to 
*   establish range limits. Analyse higher level organisation (Sheets, 
*   topology, Barrels, etc).
*
*-------------------------------------------------------------------------------
*
      PROGRAM FOLD
*
* announce subroutine.
*
      WRITE(*,1000)
*
* read databases.
*
      CALL DATAIN
*
* read control input.
*
      CALL READCARD
*
* format statements.
*
1000  FORMAT(/'  FOLD  version 5.0  D R Flower 1995.'/)
*
      STOP'FOLD has completed normally.'
      END
*
*-------------------------------------------------------------------------------
*
* Analyse this molecule.
*
      SUBROUTINE DOFOLD
*
* Declarations.
*
      INCLUDE 'FOLD.INC'
*
* open output files.
*
      CALL OPENAL
*
* calculate main chain dihedrals.
*
      CALL DIHED
*
* calculate disulphides.
*
      CALL SSBOND
*
* find hydrogen bonds.
*
      CALL SSCALC
*
* find hydrogen bonds.
*
      CALL SSANAL
*
* write results.
*
      CALL DISPLY
*
* Close output files.
*
      CALL CLOSE1
*
* format statements.
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* open named files stemming from read in file.
*
      SUBROUTINE OPENAL
*
* declarations.
*
      INTEGER EXDEC,OPDEC
*
      CHARACTER LINE*80,FLINE*80,NM*80
*
      INCLUDE 'FOLD.INC'
*
* Open input coordinate file
*
      OPEN(UNIT=1,STATUS='OLD',READONLY,ERR=100)
      GOTO 6767
*
100   CONTINUE
      WRITE(*,7002)
*
      RETURN
*
* Get FLINE name.
*
6767  CONTINUE
*
      INQUIRE(UNIT=1,NAME=LINE,EXIST=EXDEC,OPENED=OPDEC,ERR=1000)
*
      FLINE='                                                              
     +                                                   '
*
* parse root name from file name string.
*
      CALL FINDN(80,IFAIL,LINE,FLINE)
*
      IF (IFAIL.EQ.1) FLINE(1:8)='FOLD$OUT'
*
* now get names.
*
      MOLNAME=FLINE
*
*  long file with english in it. 
*
      CALL MAKEN(FLINE,NM,'long',4)
      OPEN(UNIT=9,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* summary file.
*
      CALL MAKEN(FLINE,NM,'sum',3)
      OPEN(UNIT=10,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* summary file.
*
      CALL MAKEN(FLINE,NM,'range',5)
      OPEN(UNIT=11,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* sheet analysis.
*
      CALL MAKEN(FLINE,NM,'sheet',5)
      OPEN(UNIT=12,FILE=NM,STATUS='NEW',RECL=2000,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* short summary.
*
      CALL MAKEN(FLINE,NM,'short',5)
      OPEN(UNIT=14,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* NBRF secondary structure file.
*
      CALL MAKEN(FLINE,NM,'nbrf',4)
      OPEN(UNIT=20,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
      WRITE(20,7020) FLINE(1:75)
*
* Hydrogen bond geometry file.
*
      CALL MAKEN(FLINE,NM,'hbonds',6)
      OPEN(UNIT=25,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* bulge analysis.
*
      CALL MAKEN(FLINE,NM,'bulge',5)
      OPEN(UNIT=43,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* hairpin analysis.
*
      CALL MAKEN(FLINE,NM,'hairpin',7)
      OPEN(UNIT=42,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* disulphide analysis.
*
      CALL MAKEN(FLINE,NM,'disul',5)
      OPEN(UNIT=46,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* write file of turns.
*
      CALL MAKEN(FLINE,NM,'turns',5)
      OPEN(UNIT=70,FILE=NM,STATUS='NEW',RECL=300,
     +CARRIAGECONTROL='LIST',ERR=1002)
*
* write vector file.
*
      CALL MAKEN(FLINE,NM,'vec',3)
      OPEN(UNIT=71,IOSTAT=IOS,STATUS='NEW',FILE=NM,
     + ACCESS='SEQUENTIAL',FORM='UNFORMATTED',RECL=8,ERR=1002)
*
* title each file.
*
      WRITE(9,8000)
      WRITE(10,8000)
      WRITE(11,8000)
      WRITE(12,8000)
      WRITE(14,8000)
      WRITE(25,8000)
      WRITE(43,8000)
      WRITE(42,8000)
      WRITE(46,8000)
      WRITE(70,8000)
*
* Error handling.
*
      GOTO 1001
*
1000  CONTINUE
*
* Input file errors.
*
      IF (EXDEC.NE..TRUE.) THEN
      WRITE(*,7000)
      RETURN
      ELSE
      IF (OPDEC.EQ..FALSE.) THEN
      WRITE(*,7001)
      RETURN
      ELSE
      WRITE(*,7002)
      RETURN
      ENDIF
      ENDIF
1002  CONTINUE
*
* Output file errors.
*
      WRITE(*,7003)
      RETURN
1001  CONTINUE
*
* format statements.
*
7000  FORMAT(/' Input File does not exist.'/)
7001  FORMAT(/' Input File exists but can not be opened.'/)
7002  FORMAT(/' Error opening Input File.'/)
7003  FORMAT(/' Error opening an Output File.'/)
7020  FORMAT('>X1;',A75/)
7060  FORMAT('CODE:  ',A10)
8000  FORMAT(//20X,'             F O L D '//,
     +         20X,' Summary of Secondary Structures'//)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* make name of file from root.
*
      SUBROUTINE MAKEN(NLINE,VV,SXS,GG)
*
* declarations.
*
      CHARACTER NLINE*80,SXS*30,VV*80
*
      INTEGER I,K,GG
*
* initialise.
*
      VV(1:80)='                                                              
     +                  '
*
* do the stuff.
*
      DO 1 I=1,80 
      IF (NLINE(81-I:81-I).NE.' ') GOTO 2 
1     CONTINUE
      RETURN 
2     CONTINUE
      K=81-I
*
      VV(1:K+GG+1)=NLINE(1:K)//'.'//SXS(1:GG)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Read control input from keywords.
*
      SUBROUTINE READCARD
*
* specification statements.
*
      INTEGER IFAIL
      CHARACTER A*80,CARD*10,BLINE*80,
     +AOLD*80,FILNAM*80,CASEALL*80,
     +SNAM1*80,SNAM2*80
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      BLINE='                                                                 
     +                                       '
*
* set defaults.
*
      FTYP=0
      ANGMIN=100.0
      ANGMAX=170.0
      DMINHB=3.5
      LNKTOL=1
      BLGDEC=0
      BLGLEN=0
      IUPAC=0
      IUPSHT=0
      RNGDEC=0
      INVDEC=0
      HELLEN=0
      STDLEN=0
      TRNDEC=0
      DRWDEC=0
      HELDEC=0
      SHTDEC=0
      TRIDEC=0
      DISULD=0
      PINDEC=0
      HBDEC=0
      NBRFDEC=0
      RANGED=0
      TRIWRI=2
      NOLONG=0
      NOSUM=0
      NOSHOR=0
      NOBUL=0
*
* data reading control.
*
      IREAD=5
      ILOG=129
      LOGDEC=0
*
* open external channel to sys$input or text file.
*
      OPEN(UNIT=IREAD,STATUS='UNKNOWN',ERR=101)
*
* loop through cards until read of some form of termination marker.
*
1     CONTINUE
*
* write prompt.
*
      IF (IREAD.EQ.5) WRITE(*,4000)
*
* read instruction line to parse.
*
      READ(IREAD,3000,END=120,ERR=1) A
*
* echo line.
*
      IF (IREAD.EQ.111) WRITE(*,4001) A
      IF (LOGDEC.EQ.1) WRITE(ILOG,3000) A
*
* cut any leading spaces.
*
      DO 10 I=1,80
      IF (A(I:I).NE.' ') THEN
      A(1:80)=A(I:80)//BLINE(1:I)
      L=I
      GOTO 20
      ENDIF
10    CONTINUE
*
20    CONTINUE
*
* check for comment marker.
*
      IF (A(1:1).EQ.'!') GOTO 1
      IEND=INDEX(A,'!')
      IF (IEND.EQ.0) IEND=80
*
* change case and get card.
*
      AOLD=A
      A=CASEALL(A,1)
      CARD=A(1:10)
*
* check for return or blank line only.
*
      IF (CARD(1:4).EQ.'    ') GOTO 1
*
* check for termination marker.
*
      IF (CARD(1:2).EQ.'##')   GOTO 101
      IF (CARD(1:3).EQ.'END')  GOTO 101
      IF (CARD(1:4).EQ.'QUIT') GOTO 101
      IF (CARD(1:4).EQ.'STOP') GOTO 101
      IF (CARD(1:4).EQ.'EXIT') GOTO 101
      IF (CARD(1:3).EQ.'BYE')  GOTO 101
*
* now check for each card in turn and then read arguments on card.
*
      IF (CARD(1:1).EQ.'$'.OR.CARD(1:5).EQ.'SPAWN') THEN
*
* spawn a sub process.
*
      WRITE(*,4060)
*
* call VAX specific machine routine to create subprocess.
*
      ISTAT=LIB$SPAWN(,,,,,,,,,,)
*
      GOTO 1
*
* open and read a file.
*
      ELSE IF (CARD(1:4).EQ.'READ') THEN
*
* parse file name.
*
      FILNAM=BLINE
      CALL PULWRD((IEND-4),FILNAM,AOLD(5:IEND))
      CALL LSTWRD(2,(IEND-4),SNAM1,A(5:IEND))
      CALL LSTWRD(3,(IEND-4),SNAM2,A(5:IEND))
*
* open files.
*
      IF (FILNAM(1:1).EQ.' ') THEN
*
      OPEN(UNIT=1,STATUS='OLD',ERR=1070,
     +READONLY,RECL=35000)
      REWIND(UNIT=1)
*
      CALL CLEAR1
*
      CALL FILEIN(1,IFAIL)
*
      GOTO 1
*
      ELSEIF (FILNAM(1:1).EQ.'@') THEN
*
* file of filenames.
*
      CLOSE(UNIT=2)
      OPEN(UNIT=2,STATUS='OLD',FILE=FILNAM(2:),ERR=1070,
     +READONLY,RECL=1000)
      REWIND(UNIT=2)
*
* process many files.
*
      CALL DOMANY(2)
*
      ELSE
*
* single files.
*
      CLOSE(UNIT=1)
      OPEN(UNIT=1,STATUS='OLD',FILE=FILNAM,ERR=1070,
     +READONLY,RECL=35000)
      REWIND(UNIT=1)
*
      CALL CLEAR1
*
      CALL FILEIN(1,IFAIL)
*
      ENDIF
*
      GOTO 1
*
* read from instruction file.
*
      ELSE IF (CARD(1:1).EQ.'@') THEN
*
* parse file name.
*
      IF (IREAD.EQ.5) THEN
      FILNAM=BLINE
      CALL PULWRD(IEND,FILNAM,AOLD(2:IEND))
*
* open input log file.
*
      OPEN(UNIT=111,FILE=FILNAM,STATUS='OLD',READONLY,
     +ERR=121)
*
* change to read log file.
*
      IOLD=IREAD
      IREAD=111
*
      ELSE
*
* log file within log file. not allowed.
*
      WRITE(*,4010)
      ENDIF
*
      GOTO 1
*
* open Log file.
*
      ELSE IF (CARD(1:3).EQ.'LOG') THEN
*
      IF (LOGDEC.EQ.0) THEN
      LOGDEC=1
      FILNAM=BLINE
      CALL PULWRD((IEND-3),FILNAM,AOLD(4:IEND))
      OPEN(UNIT=ILOG,FILE=FILNAM,STATUS='NEW',ERR=1071,
     +CARRIAGECONTROL='LIST')
      WRITE(*,4002)
      ELSE
      WRITE(*,4003)
      ENDIF
*
      GOTO 1
*
* close log file.
*
      ELSE IF (CARD(1:5).EQ.'NOLOG') THEN
*
      IF (LOGDEC.EQ.1) THEN      
      LOGDEC=0
      WRITE(*,4004)
      CLOSE(UNIT=129)
      ELSE
      WRITE(*,4005)
      ENDIF
*
      GOTO 1
*
      ELSE
*
* call all other options.
*
      CALL DOCARD(IFAIL,IEND,CARD,A,AOLD)
*
* Error trap.
*
      IF (IFAIL.EQ.1) THEN
      GOTO 750
      ELSEIF (IFAIL.EQ.2) THEN
      GOTO 100
      ELSEIF (IFAIL.EQ.3) THEN
      GOTO 1071
      ELSEIF (IFAIL.EQ.4) THEN
      GOTO 1071
      ELSE
      GOTO 1
      ENDIF
*
      ENDIF
*
* error trap and warn unknown card.
*
750   CONTINUE
*
      FILNAM=BLINE
      CALL PULWRD(IEND,FILNAM,AOLD(1:IEND))
      WRITE(*,3009) FILNAM(1:40)
      IF (LOGDEC.EQ.1) WRITE(ILOG,3009) FILNAM(1:40)
*
      GOTO 1
*
* Error trap error on failure on read.
*
100   CONTINUE
*
      FILNAM=BLINE
      CALL PULWRD(IEND,FILNAM,AOLD(1:IEND))
      WRITE(*,3005) FILNAM(1:40)
      IF (LOGDEC.EQ.1) WRITE(ILOG,3005) FILNAM(1:40)
*
      GOTO 1
*
* error trap read in.
*
120   CONTINUE
*
      CLOSE(UNIT=IREAD)
*
      IF (IREAD.EQ.111) THEN
      WRITE(*,3012)
      IREAD=5
      OPEN(UNIT=IREAD,STATUS='UNKNOWN')
      GOTO 1
      ELSE
      WRITE(*,3011)
      ENDIF
*     
      GOTO 101
*
* no file to open.
*
1070  CONTINUE
*
      WRITE(*,4059)
      GOTO 1
*
* no file to open.
*
1071  CONTINUE
*
      WRITE(*,4079)
      GOTO 1
*
* error trap for subsidiary input file.
*
121   CONTINUE
      WRITE(*,3020)
      GOTO 1
*
122   CONTINUE
      WRITE(*,3021)
      GOTO 1
*
101   CONTINUE
*
* close input and log files.
* 
      CLOSE(UNIT=5)
      IF (IREAD.EQ.111) CLOSE(UNIT=IREAD)
      IF (LOGDEC.EQ.1) CLOSE(UNIT=ILOG)
*
* format statements.
*
3000  FORMAT(A80)
3005  FORMAT(' Error parsing from command ',A40)
3009  FORMAT(' Unknown command ',A40)
3010  FORMAT(/
     +' Reading of commands has been completed with normal 
     +termination.')
3011  FORMAT(/
     +' Reading of commands has been terminated by end of file.')
3012  FORMAT(' Read end of subsidiary instruction file.')
3020  FORMAT(' Instruction file does not exist.')
3021  FORMAT(' Instruction file is empty.')
3050  FORMAT(/' ERROR: no instructions to read.')
*
4000  FORMAT(' Fold: '$)
4001  FORMAT(' Data line:'/,1X,A80)
4002  FORMAT(' LOG file opened.')
4003  FORMAT(' already writing a LOG file.')
4004  FORMAT(' LOG file now closed.')
4005  FORMAT(' no LOG file to close.')
4010  FORMAT(' already reading a LOG file.')
4050  FORMAT(' All parameters have been reset.')
4051  FORMAT(' Can not read input file. File type not given.')
4052  FORMAT(' Can not write output file. File type not given.')
4053  FORMAT(' Atom data cleared.')
4059  FORMAT(' Can not read input file.
     + Error in file specification.')
4060  FORMAT(' Creating sub-process.')
4079  FORMAT(' Can not open output file.
     + Error in file specification.')
*
5000  FORMAT(/' Rings perceived:'/)
5001  FORMAT(/' Geometry calculation.'/)
5002  FORMAT(' Bond angles.'/)
5003  FORMAT(/' Torsion angles.'/)
5005  FORMAT(' Bond Lengths.'/)
*
7001  FORMAT(/' Did not receive input/output file types.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get information from cards.
*
      SUBROUTINE DOCARD(IFAIL,IEND,CARD,A,AOLD)
*
* Declarations.
*
      INTEGER IFAIL,IEND,IIH(80)
      REAL FFH(80)
*
      CHARACTER A*80,CARD*10,CCH(80)*1,
     +AOLD*80,FILNAM*80,SNAM1*80
*
      INCLUDE 'FOLD.INC'
*
* Reinitialise.
*
      IFAIL=0
*
* check for each card in turn and then read arguments on card.
*
*  filetype:
*
      IF (CARD(1:6).EQ.'FILEIN') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      FTYP=IIH(1)
      IF (FTYP.LT.1.OR.FTYP.GT.5) GOTO 100
      GOTO 1
*
* define hbond parameters:
*
      ELSEIF (CARD(1:6).EQ.'ANGMIN') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      ANGMIN=FFH(1)
      IF (ANGMIN.LT.0.0)   ANGMIN=0.0
      IF (ANGMIN.GT.180.0) ANGMIN=180.0
*
      IF (NH.LT.2) THEN
      ANGMIN1=ANGMIN
      ELSE
      ANGMIN1=FFH(2)
      IF (ANGMIN1.LT.0.0)   ANGMIN1=0.0
      IF (ANGMIN1.GT.180.0) ANGMIN1=180.0
      ENDIF
*
      GOTO 1
*
      ELSEIF (CARD(1:6).EQ.'ANGMAX') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      ANGMAX=FFH(1)
      IF (ANGMAX.LT.0.0)   ANGMAX=0.0
      IF (ANGMAX.GT.180.0) ANGMAX=180.0
*
      IF (NH.LT.2) THEN
      ANGMAX1=ANGMIN
      ELSE
      ANGMAX1=FFH(2)
      IF (ANGMAX1.LT.0.0)   ANGMAX1=0.0
      IF (ANGMAX1.GT.180.0) ANGMAX1=180.0
      ENDIF
*
      GOTO 1
*
      ELSEIF (CARD(1:6).EQ.'DISMAX') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      DMAXHB=FFH(1)
      IF (DMINHB.LT.0.0) DMINHB=0.0
      GOTO 1
*
      ELSEIF (CARD(1:6).EQ.'DISMIN') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      DMINHB=FFH(1)
      IF (DMINHB.LT.0.0) DMINHB=0.0
      GOTO 1
*
      ELSEIF (CARD(1:7).EQ.'CONTACT') THEN
      CALL LRDRF(A(8:IEND),(IEND-7),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      DCONTACT=FFH(1)
      IF (DCONTACT.LT.0.0) DCONTACT=0.0
      GOTO 1
*
* toggle Analysis of beta bulges.
* 
      ELSE IF (CARD(1:5).EQ.'BULGE') THEN
      CALL LRDRF(A(6:IEND),(IEND-5),IIH,FFH,CCH,NH)
      IF (NH.LT.1) THEN
      BLGLEN=1
      ELSE
      BLGLEN=IIH(1)
      ENDIF
      GOTO 1 
*
* get tolerance for combining strands into sheets.
*
      ELSE IF (CARD(1:4).EQ.'JOIN') THEN
      CALL LRDRF(A(5:IEND),(IEND-4),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      LNKTOL=MAX(ABS(IIH(1)),ABS(INT(FFH(1))))
      GOTO 1 
*
* Analyse sheets.
*
      ELSE IF (CARD(1:6).EQ.'SHEETS') THEN
*
      SHTDEC=1
*
      GOTO 1 
*
* toggle bulge linking of strands. 
*
      ELSE IF (CARD(1:4).EQ.'LINK') THEN
      BLGDEC=1
      IF (BLGLEN.EQ.0) BLGLEN=1
      GOTO 1 
*
* toggle non-strict assignments.
*
      ELSE IF (CARD(1:5).EQ.'IUPAC') THEN
      IUPDEC=1
*
* flag strand options.
*
      IY=INDEX(A(1:IEND),'STRAND')
*
      IF (IY.GT.0) THEN 
      IUPSHT=1
      CALL LRDRF(A(IY:IEND),(IEND-IY),IIH,FFH,CCH,NH)
      IY=MAX(IIH(1),INT(FFH(1)))
      IF (IY.EQ.2) IUPSHT=2
      ENDIF
*
      GOTO 1 
*
* identify ring paths.
*
      ELSEIF (CARD(1:5).EQ.'REDUC') THEN
*
      REDDEC=1
      GOTO 1 
*
* identify ring paths.
*
      ELSEIF (CARD(1:5).EQ.'RINGS') THEN
*
      RNGDEC=1
      GOTO 1 
*
* identify turns.
*
      ELSEIF (CARD(1:5).EQ.'TURNS') THEN
*
      TRNDEC=1
      GOTO 1 
*
* Vector file.
*
      ELSEIF (CARD(1:4).EQ.'DRAW') THEN
*
      DRWDEC=1
      GOTO 1 
*
* Vector file.
*
      ELSEIF (CARD(1:5).EQ.'HBOND') THEN
*
      HBDEC=1
      GOTO 1 
*
* Vector file.
*
      ELSEIF (CARD(1:5).EQ.'HAIRP') THEN
*
      PINDEC=1
      GOTO 1 
*
* Write NBRF file.
*
      ELSEIF (CARD(1:4).EQ.'NBRF') THEN
*
      NBRFDEC=1
      GOTO 1
*
* Write Range file.
*
      ELSEIF (CARD(1:5).EQ.'RANGE') THEN
*
      RANGED=1
      GOTO 1
*
      ELSEIF (CARD(1:5).EQ.'DISUL') THEN
*
      DISULD=1
      GOTO 1
*
      ELSEIF (CARD(1:6).EQ.'NOLONG') THEN
*
      NOLONG=1
      GOTO 1
*
      ELSEIF (CARD(1:7).EQ.'NOSHORT') THEN
*
      NOSHOR=1
      GOTO 1
*
      ELSEIF (CARD(1:5).EQ.'NOSUM') THEN
*
      NOSUM=1
      GOTO 1
*
      ELSEIF (CARD(1:5).EQ.'NOBUL') THEN
*
      NOBUL=1
      GOTO 1
*
      ELSEIF (CARD(1:4).EQ.'VIEW') THEN
*
      CALL PULWRD((IEND-4),SNAM1,A(5:IEND))
*
      IF (SNAM1(1:4).EQ.'RIBB') THEN
      CALL VIEW(1)
      ELSE
      CALL VIEW(0)
      ENDIF
*
      ELSEIF (CARD(1:5).EQ.'ANALY') THEN
*
* Analyse structure.
*
      IF (NN.GT.0) THEN
      CALL DOFOLD
      ELSE
      WRITE(*,3045)
      ENDIF
*
      GOTO 1
      ELSE
*
* unknown card.
*
      IFAIL=1
*
      ENDIF
*
* jump to end of look up.
*
1     CONTINUE
*
      RETURN
*
* error trap.
*
100   CONTINUE
*
      IFAIL=2
      RETURN
*
1070  CONTINUE
*
      IFAIL=3
      RETURN
*
1071  CONTINUE
*
      IFAIL=4
*
* error trap.
*
      IF (ANGMAX.LT.ANGMIN) THEN
      APAP=ANGMAX
      ANGMAX=ANGMIN
      ANGMIN=APAP
      ENDIF
*
* format statements.
*
3000  FORMAT(A80)
3005  FORMAT(' Error reading from card ',A4)
3009  FORMAT(' unknown card encountered ',A4)
3010  FORMAT(/
     +' Reading of cards has been completed with normal termination.')
3031  FORMAT(/
     +' Reading of cards has been terminated by end of file.')
3045  FORMAT(' No structure available to analyze.')
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
*  read in files.
*
      SUBROUTINE FILEIN(II,IFAIL)
*
* declarations.
*
      INTEGER II,IDEC,IFAIL
*
      INCLUDE 'FOLD.INC'
*
      IFAIL=0
*
* open files.
*
      OPEN(UNIT=II,STATUS='OLD',READONLY,ERR=100)
*
* choose filetype.
*
      IF (FTYP.EQ.1) THEN
      CALL PROLSQIN(II)
      ELSEIF (FTYP.EQ.2) THEN 
      CALL PDBIN(II)
      ELSEIF (FTYP.EQ.5) THEN
      CALL FRODOIN(II)
      ELSE
      WRITE(*,1000)
      CALL PDBIN(II)
      ENDIF
*
* create atom lookup table.
*
      CALL LOOKUP(IDEC)
*
* error trap no atoms
*
      IF (IDEC.EQ.1) THEN
      IFAIL=1
      WRITE(*,1002)
      CLOSE(UNIT=9,DISPOSE='DELETE')
      CLOSE(UNIT=10,DISPOSE='DELETE')
      CLOSE(UNIT=11,DISPOSE='DELETE')
      CLOSE(UNIT=12,DISPOSE='DELETE')
      CLOSE(UNIT=42,DISPOSE='DELETE')
      CLOSE(UNIT=43,DISPOSE='DELETE')
      RETURN
      ENDIF
*
      RETURN
*
* error no file.
*
100   CONTINUE      
*
      WRITE(*,1001)
*
* format statements.
*
1000  FORMAT(/' ERROR: file type not given.'/) 
1001  FORMAT(/' ERROR: file not found.'/) 
1002  FORMAT(/' ERROR: No protein atoms read from file.'/) 
*
      END
*
*-------------------------------------------------------------------------------
*
*' read in FRODO type DIAMOND format file.
*
      SUBROUTINE FRODOIN(II)
*
* declarations.
*
      INTEGER J,II
*
      INCLUDE 'FOLD.INC'
*
* announce subroutine.
*
      WRITE(*,7001)
*
      DO 11 J=1,3
      READ(II,101) DFLINE(J)
11    CONTINUE
*
      J=1
*
1     CONTINUE
*
      READ(II,100,ERR=50,END=500)
     +X(J),Y(J),Z(J),
     +BFAC(J),AT(J),RN(J),AN(J),ATR(J),
     +RNAM(J),RLAB(J),ATNAM(J)
*
      J=J+1
*
      IF (J.GT.7000) THEN
      WRITE(*,8000)
      NN=7000
      RETURN
      ENDIF
*
50    CONTINUE
      GOTO 1
500   CONTINUE
      WRITE(*,7000)
*
      NN=J-1
*
      IF (NN.GT.0) THEN
      WRITE(*,7002) NN
      ELSE 
      WRITE(*,7003) 
      RETURN
      ENDIF
*
* format statements:
*
100   FORMAT(4F10.5,3I5,F9.4,1X,A3,4X,A1,2X,A4)                           DIAMF
101   FORMAT(A80)
7000  FORMAT(/' Read-in of file completed.')
7001  FORMAT(/' Reading Frodo type Diamond format file (5).')
7002  FORMAT(/1X,I5,' atoms read in.'/)
7003  FORMAT(/' ERROR: no atoms read from file.'/)
8000  FORMAT(/' Maximum number of atoms exceeded. Read in aborted.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
*' read in BROOKHAVEN format file.
*
      SUBROUTINE PDBIN(II)
*
* declarations.
*
      INTEGER J,II
      CHARACTER IDEN*6
*
      INCLUDE 'FOLD.INC'
*
* announce subroutine
*
      WRITE(*,7001)
*
* work through file.
*
      J=1
1     CONTINUE
*
      READ(II,100,END=500,ERR=50)
     +IDEN,AN(J),ATNAM(J),RNAM(J),RLAB(J),
     +RN(J),
     +X(J),Y(J),Z(J),QOCC(J),BFAC(J)
*
      IF (IDEN.EQ.'ATOM  ') THEN 
      ATY(J)=1
      J=J+1
      ENDIF
*
      IF (J.GT.7000) THEN
      WRITE(*,8000)
      NN=7000
      RETURN
      ENDIF 
*
50    CONTINUE
      GOTO 1
500   CONTINUE
      WRITE(*,7000)
*
      NN=J-1
*
      IF (NN.GT.0) THEN
      WRITE(*,7002) NN
      ELSE 
      WRITE(*,7003) 
      RETURN
      ENDIF
*
* format statements:
*
100   FORMAT(A6,I5,2X,A4,A3,1X,A1,I4,4X,3F8.3,2F6.2)                      PDB
7000  FORMAT(/' Read-in of file completed.')
7001  FORMAT(/' Reading Brookhaven format file.')
7002  FORMAT(/1X,I5,' atoms read in.'/)
7003  FORMAT(/' ERROR: no atoms read from file.'/)
8000  FORMAT(/' Maximum number of atoms exceeded. Read in aborted.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* read in PROLSQ type DIAMOND format file.
*
      SUBROUTINE PROLSQIN(II)
*
* declarations.
*
      INTEGER J,II
*
      INCLUDE 'FOLD.INC'
*
* announce subroutine.
*
      WRITE(*,7001)
*
      DO 11 J=1,3
      READ(II,101) DFLINE(J)
11    CONTINUE
*
      J=1
*
1     CONTINUE
*
      READ(II,100,ERR=50,END=500)
     +X(J),Y(J),Z(J),
     +BFAC(J),AT(J),RN(J),AN(J),ATR(J),
     +RNAM(J),RLAB(J),ATNAM(J)
*
      J=J+1
*
      IF (J.GT.7000) THEN
      WRITE(*,8000)
      NN=7000
      RETURN
      ENDIF
*
50    CONTINUE
      GOTO 1
500   CONTINUE
      WRITE(*,7000)
*
      NN=J-1
*
      IF (NN.GT.0) THEN
      WRITE(*,7002) NN
      ELSE 
      WRITE(*,7003) 
      RETURN
      ENDIF
*
* format statements:
*
100   FORMAT(4F10.5,3I5,F9.4,1X,A3,3X,A1,3X,A4)                           DIAMP
101   FORMAT(A80)
7000  FORMAT(/' Read-in of file completed.')
7001  FORMAT(/' Reading a Prolsq type Diamond format file.')
7002  FORMAT(/1X,I5,' atoms read in.'/)
7003  FORMAT(/' ERROR: no atoms read from file.'/)
8000  FORMAT(/' Maximum number of atoms exceeded. Read in aborted.'/)
*
      RETURN 
      END
*  
*-------------------------------------------------------------------------------
*
* create lookup table or index for atoms.
*
      SUBROUTINE LOOKUP(IDEC)
*
* Declarations.
*
      INTEGER I,J,K,PP,E1,CHDEC,IP1,IV
      INTEGER IND(1000),IDN2(1000),LKL(1000),ATMPCH(1000)
*
      CHARACTER CHLIST*20
*
* lookup table:
*
      CHARACTER ATLOOK(38)*4
*
      INCLUDE 'FOLD.INC'
*
* form lookup table for standard atom names.
*
      DATA  ATLOOK /
*      1      2      3      4      5
     +'N   ','C   ','O   ','CA  ','CB  ',
*      6      7      8      9
     +'CG  ','CD  ','NE  ','CZ  ',
*      10     11     12     13
     +'NH1 ','NH2 ','OD1 ','OD2 ',
*      14     15     16     17
     +'CD1 ','CE1 ','CE2 ','CD2 ',
*      18     19     20     21
     +'SG  ','OE1 ','OE2 ','OH  ',
*      22     23     24     25
     +'OG1 ','CG2 ','CE  ','NZ  ',
*      26     27     28     29
     +'CG1 ','ND2 ','NE2 ','SD  ',
*      30     31     32
     +'OG  ','OT  ','OTX ', 
     +'ND1 ',
     +'NE1 ',
     +'CZ2 ',
     +'CH2 ',
     +'CZ3 ',
     +'CE3 ' /
*
* Initialise.
*
      CHLIST='                                                    '
*
* Create lookup table for atoms.
*
* error trap.
*
      IF (NN.LT.1) THEN
      IDEC=1
      RETURN
      ELSE
*
* initialise with first atom.
* 
      CHL=1
      CHLIST(1:1)=RLAB(1)
      RN1(1)=RN(1)
      RN2(1)=RN(1)
      ATMPCH(1)=0
*
* loop through all atoms creating index as we go.
*
      DO 4 I=1,NN
*
* check in list of chain identifiers.
*
      PP=0
      CHDEC=INDEX(CHLIST(1:CHL),RLAB(I))
*
* is this a new chain.
*
      IF (CHDEC.LT.1) THEN
*
      IF (CHL.LT.10) THEN
      CHL=CHL+1
      CHLIST(CHL:CHL)=RLAB(I)
      CHDEC=CHL
      RN1(CHDEC)=RN(I)
      RN2(CHDEC)=RN(I)
      ATMPCH(CHDEC)=1
      ELSE
      GOTO 4
      ENDIF
*
      ELSE
*
* increment atoms/chain counter.
*
      ATMPCH(CHDEC)=ATMPCH(CHDEC)+1
*
      ENDIF
*
* get limits of this chain.
*
      RN2(CHDEC)=MAX(RN2(CHDEC),RN(I))
      RN1(CHDEC)=MIN(RN1(CHDEC),RN(I))
*
* get pointers.
*
      PP=POS(-1,RN(I),CHDEC)+1
      POS(-1,RN(I),CHDEC)=PP
*
      POS(PP,RN(I),CHDEC)=I
*
4     CONTINUE
*
* now go through tree structure assigning residue types and sorting
* protein atoms.
*
      DO 10 I=1,CHL
      DO 10 J=RN1(I),RN2(I)
*
* reset
*
      IJ=0
      KJ=0
      LMAX=0
*
* get number of atoms in this residue.
*
      INAT=POS(-1,J,I)
*
* error trap empty residue.
*
      IF (INAT.GT.0) THEN
      DO 11 K=1,INAT
*
* get pointer.
*
      JJ=POS(K,J,I)
*
* is it a protein or hetero atom.
* is atom in protein lookup table.
*
      DO 12 L=1,38
      IF (ATNAM(JJ).EQ.ATLOOK(L)) THEN
      IJ=IJ+1
      LKL(IJ)=JJ
      IND(IJ)=L
      IF (LMAX.LT.L) LMAX=L
      ENDIF
12    CONTINUE
*
      KJ=KJ+1
*
* error trap.
*
11    CONTINUE
      ENDIF
*
* assign residue type.
*
      IF (KJ.EQ.0) THEN
*
* no atoms.
*
      POS(0,J,I)=-1
      ELSE
*
      IF (IJ.NE.KJ) THEN
*
* not protein.
*
      POS(0,J,I)=0
*
      ELSE
*
* protein.
*
      POS(0,J,I)=1
*
* error trap no atoms.
*
      IF (INAT.GT.0) THEN
*
* sort on position in atom list.
*
      CALL ISORT(INAT,IND,IDN2)
*
* reinitialise.
*
      DO 17 L=1,40
      POS(L,J,I)=0
17    CONTINUE
*
* write back the index.
*
      IT1=0
      DO 16 L=1,INAT
*
* get pointer to sorted position.
*
      E1=IDN2(L)
*
      IF (E1.GT.0) THEN
*
* within residue position counter
*
      IT1=IT1+1
*
* get pointers.
*
      IV=LKL(E1)
      IP1=IND(E1)
*
* error trap.
*
      IF (IP1.LT.41) THEN
      IF (IV.GT.0.AND.IV.LE.NN) THEN
*
* save pointer to data arrays.
*
      POS(IT1,J,I)=IV
*
      ENDIF
      ENDIF
      ENDIF
*
16    CONTINUE
*
* record number of atoms in this residue.
*
      POS(-1,J,I)=INAT
*
      ENDIF
*
      ENDIF
      ENDIF
*
10    CONTINUE
*
* Write results: Summary of chain labels and size of chains.
*
      CCLIS=CHLIST
*
      WRITE(*,1000) CHL
      DO 7 I=1,CHL
      WRITE(*,1001) I,CHLIST(I:I),ATMPCH(I),RN1(I),RN2(I)
7     CONTINUE
*
      ENDIF
*
* format statements.
*
1000  FORMAT(' Number of different chains:',I3,'.')
1001  FORMAT('   chain',I4,' label:',1X,A1,' with',I5,' atoms.'/,
     +       '        residue limits:',I4,' - ',I4,'.')
1010  FORMAT(' Unknown Atom Name: ',A4,' from chain:',I4)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get next word from string.
*
      SUBROUTINE PULWRD(II,B,A)
*
* declarations.
*
      INTEGER II,ICOUNT,IDEC
      CHARACTER A*(*),B*80
*
* initialise
*
      ICOUNT=0
      IDEC=0
      B='                                                              
     +                                                              '
*
* work through line.
*
      DO 1 I=1,II
*
      IF (A(I:I).NE.' ') THEN
      IDEC=1
      ICOUNT=ICOUNT+1
      B(ICOUNT:ICOUNT)=A(I:I)
      ENDIF
*
      IF (A(I:I).EQ.' '.AND.IDEC.EQ.1) RETURN
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
*  Integer sorting routine. Returns the order of A in IN.
*
*  ref: COMM. ACM vol.12 #3 march 1969, R.C.Singleton.
*
      SUBROUTINE ISORT(N,A,IN)
*
* declarations.
*
      INTEGER N,A(N),IN(N),IL(16),IU(16),T,TT,I,J
*
* initialise.
*
      DO 1000 I=1,N
      IN(I)=I
1000  CONTINUE
*
      M=1
      I=1
      J=N
*
* begin.
*
5     CONTINUE
      IF (I.GE.J) GOTO 70
10    CONTINUE
      K=I
      IJ=(I+J)/2
      T=IN(IJ)
      IF (A(IN(I)).LE.A(T)) GOTO 20
      IN(IJ)=IN(I)
      IN(I)=T
      T=IN(IJ)
20    CONTINUE
      L=J
      IF (A(IN(J)).GE.A(T)) GOTO 40
      IF (A(IN(J)).LT.A(IN(I))) GOTO 25
      IN(IJ)=IN(J)
      IN(J)=T
      T=IN(IJ)
      GOTO 40
*
25    CONTINUE
      IN(IJ)=IN(I)
      IN(I)=IN(J)
      IN(J)=T
      T=IN(IJ)
      GOTO 40
*
30    CONTINUE
      IN(L)=IN(K)
      IN(K)=TT
40    CONTINUE
      L=L-1
      IF (A(IN(L)).GT.A(T)) GOTO 40
      TT=IN(L)
50    CONTINUE
      K=K+1
      IF (A(IN(K)).LT.A(T)) GOTO 50
      IF (K.LE.L) GOTO 30
      IF ((L-I).LE.(J-K)) GOTO 60
      IL(M)=I
      IU(M)=L
      I=K
      M=M+1
      GOTO 80
*
60    CONTINUE
      IL(M)=K
      IU(M)=J
      J=L
      M=M+1
      GOTO 80
*
70    CONTINUE
      M=M-1
      IF (M.EQ.0) GOTO 900
      I=IL(M)
      J=IU(M)
80    CONTINUE
      IF ((J-I).GE.11) GOTO 10
      IF (I.EQ.1) GOTO 5
      I=I-1
90    CONTINUE
      I=I+1
      IF (I.EQ.J) GOTO 70
      T=IN(I+1)
      IF (A(IN(I)).LE.A(T)) GOTO 90
      K=I
100   CONTINUE
      IN(K+1)=IN(K)
      K=K-1
      IF (A(T).LT.A(IN(K))) GOTO 100
      IN(K+1)=T
      GOTO 90
*
900   CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* read fragment library and angle files.
*
      SUBROUTINE DATAIN
*
* declarations.
*
      INCLUDE 'FOLD.INC'
*
* open next file.
*
      OPEN(UNIT=116,STATUS='OLD',READONLY,ERR=200)
*
* read torsion angle names/pointers.
*
      NAT=1
*
10    CONTINUE
*
      READ(116,2000,ERR=10,END=12) 
     +TNAM1(NAT),T1(NAT),
     +TNAM2(NAT),T2(NAT),
     +TNAM3(NAT),T3(NAT),
     +TNAM4(NAT),T4(NAT),
     +TORNAM(NAT)
*
      NAT=NAT+1
*
      GOTO 10
*
12    CONTINUE
*
      NAT=NAT-1
*
      WRITE(*,2010) NAT
*
* store number of torsions.
*
      NTOR=NAT
*
* close data file.
*
      CLOSE(UNIT=116)
*
200   CONTINUE
*
* format statements.
*
1000  FORMAT(A1,A3,1X,A1,I3)
1001  FORMAT(A4,I3,I4,I2,3F10.5,4(I3,I1))
1002  FORMAT(I5,' library residues read.') 
2000  FORMAT(4(A4,I3,1X),A4)
2010  FORMAT(I5,' Torsion angles read.')
7000  FORMAT(/1X,A3,1X,I3/)
7003  FORMAT(/' Reading Libraries.'/)
7004  FORMAT(/)
7103  FORMAT(1X,A4,2X,F9.4)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* read fragment library and angle files.
*
      SUBROUTINE FINDN(IL,IFAIL,LINE,FLINE)
*
* declarations.
*
      INTEGER IL,K1,K2,IFAIL
      CHARACTER LINE*(*),FLINE*(*)
*
* initialise.
*
      K1=0
      K2=0
*
* find root from input string.
*
      DO 1 I=IL,1,-1
*
* Vax delimiter.
*
      IF (LINE(I:I).EQ.']') GOTO 11
*
* Unix delimiter.
*
      IF (LINE(I:I).EQ.'/') GOTO 11
*
1     CONTINUE
*
* trap just name.
*
      I=0
*
11    CONTINUE
*
      K1=I+1
*
      DO 2 I=IL,K1,-1
      IF (LINE(I:I).EQ.'.') GOTO 12
2     CONTINUE
*
* trap just name.
*
      I=IL+1
*
12    CONTINUE
*
      K2=I-1
*
* error trap.
*
      IF (K1.LT.K2) THEN 
*
* create root name string.
*
      IFAIL=0
      CL=(K2-K1)+1
      FLINE(1:CL)=LINE(K1:K2)
*
      ELSE
*
* fail.
*
      IFAIL=1
*
      ENDIF 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* case swapping routine:
*' IFLAG=1 : lower to upper case.
*' IFLAG=0 : upper to lower case.
*
      CHARACTER*80 FUNCTION CASEALL(W,IFLAG)
*
* declarations.
*
      IMPLICIT LOGICAL (A-Z)
*
      INTEGER I,AV,IFLAG
*
      CHARACTER W*80
*
* do change.
*
      IF (IFLAG.EQ.1) THEN
      DO 1 I=1,80
      AV=ICHAR(W(I:I))
      IF (AV.GE.97.AND.AV.LE.122) AV=AV-32
      W(I:I)=CHAR(AV)
1     CONTINUE
      ELSE
      DO 11 I=1,80
      AV=ICHAR(W(I:I))
      IF (AV.GE.65.AND.AV.LE.90) AV=AV+32
      W(I:I)=CHAR(AV)
11    CONTINUE
      ENDIF
*
      CASEALL=W
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get first word from a line
*
      SUBROUTINE LSTWRD(IW,II,B,A)
*
* declarations.
*
      INTEGER II,ICOUNT,IDEC
      CHARACTER A*(*),B*80
*
* initialise
*
      ICOUNT=0
      IDEC=0
      B(1:80)='                                                  
     +                                             '
      IT=1
*
* work through line.
*
      DO 1 I=1,II
*
* a non-blank character.
*
      IF (A(I:I).NE.' ') THEN
*
* set flags and counters.
*
      IDEC=1
      ICOUNT=ICOUNT+1
*
* Error trap.
*
      IF (ICOUNT.LT.81) THEN
      B(ICOUNT:ICOUNT)=A(I:I)
      ENDIF
*
      ENDIF
*
* end of a word.
*
      IF (A(I:I).EQ.' '.AND.IDEC.EQ.1) THEN
*
* reset flags and counters.
*
      ICOUNT=0
      IDEC=0
*
* increment word counter.
*
      IT=IT+1
*
* Check if we have the word required.
*
      IF (IT.EQ.IW+1) RETURN
*
* default word string.
*
      B(1:80)='                                                  
     +                                             '
      ENDIF
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* automated transformation.
*
      SUBROUTINE DOMANY(IO1)
*
* Declarations.
*
      INTEGER IO1
      CHARACTER FLINE*80,BLINE*80
      CHARACTER FNAM1*80
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      BLINE='                                                             
     +                                                '
*
* work through a file of file names.
*
1     CONTINUE
*
* read a file name.
*
      READ(IO1,1000,ERR=1,END=100) FLINE
*
* parse names.
*
      FNAM1=BLINE
      CALL PULWRD(80,FNAM1,FLINE)
*
* open input file.
*
      IF (FNAM1(1:1).EQ.' ') THEN
      GOTO 1
      ELSE
      OPEN(UNIT=1,STATUS='OLD',FILE=FNAM1,RECL=1000,
     +READONLY,ERR=70)
      REWIND(UNIT=1)
*
* reinitialise.
*
      CALL CLEAR1
*
* read file.
*
      CALL FILEIN(1,IFAIL)
*
      ENDIF
*
* do analysis.
*
      IF (IFAIL.EQ.0) THEN
      CALL DOFOLD
      ENDIF
*
70    CONTINUE
*
* Close files.
*
      CLOSE(UNIT=1)
*
* return for next one.
*
      GOTO 1
*
100   CONTINUE
*
1000  FORMAT(A80)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* set/reset defaults.
*
      SUBROUTINE CLEAR1
*
* declarations.
*
      INTEGER I,J,II
      INCLUDE 'FOLD.INC'
*
* initialise atom indexing.
*
      DO 1 I=1,CHL
*
      DO 2 J=RN1(I),RN2(I)
      DO 2 II=-2,40
      POS(II,J,I)=0
2     CONTINUE
*
      RN1(I)=0
      RN2(I)=0
*
1     CONTINUE
*
      CALL CLEAR2
*
      CHL=0
*
* clear connectivities and other information.
*
      DO 3 I=1,NN
*
* clear attributes.
*
      X(I)=0.0
      Y(I)=0.0
      Z(I)=0.0
      BFAC(I)=0.0
      QOCC(I)=0.0
*
      RN(I)=1
      ATR(I)=0.0
      AT(I)=0
      AN(I)=0
      ATY(I)=0
*
3     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE CLEAR2
*
      INCLUDE 'FOLD.INC'
*
* initialise residue based properties.
*
      DO 1 I=1,CHL
      DO 2 J=RN1(I),RN2(I)
*
      DO 10 K=1,10
      DANGL(K,J,I)=0
10    CONTINUE
      DO 11 K=1,6
      BLGLNK(K,J,I)=0
11    CONTINUE
*
2     CONTINUE
1     CONTINUE
*
* initialise element based properties.
*
      DO 3 I=1,10
*
*
      DO 4 J=1,100
      BULGE1(J,I)=0
      BULGE2(J,I)=0
4     CONTINUE
*
3     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* set/reset defaults.
*
      SUBROUTINE CLOSE1
*
      INCLUDE 'FOLD.INC'
*
* Close files. Keep or delete.
*
* Long file.
*
      IF (NOLONG.EQ.0) THEN
      CLOSE(UNIT=9)
      ELSE
      CLOSE(UNIT=9,DISPOSE='DELETE')
      ENDIF
*
* Summary file.
*
      IF (NOSUM.EQ.0) THEN
      CLOSE(UNIT=10)
      ELSE
      CLOSE(UNIT=10,DISPOSE='DELETE')
      ENDIF
*
* Short file.
*
      IF (NOSHOR.EQ.0) THEN
      CLOSE(UNIT=14)
      ELSE
      CLOSE(UNIT=14,DISPOSE='DELETE')
      ENDIF
*
* Summary of Ranges.
*
      IF (RANGED.EQ.0) THEN
      CLOSE(UNIT=11,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=11)
      ENDIF
*
* Sheets file.
*
      IF (SHTDEC.EQ.0) THEN
      CLOSE(UNIT=12,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=12)
      ENDIF
*
* NBRF file.
*
      IF (NBRFDEC.EQ.0) THEN
      CLOSE(UNIT=20,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=20)
      ENDIF
*
* Hydrogen Bonds.
*
      IF (HBDEC.EQ.0) THEN
      CLOSE(UNIT=25,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=25)
      ENDIF
*
* Bulges.
*
      IF (BLGDEC.EQ.0.OR.NOBUL.EQ.1) THEN
      CLOSE(UNIT=43,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=43)
      ENDIF
*
* Hairpins.
*
      IF (PINDEC.EQ.0) THEN
      CLOSE(UNIT=42,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=42)
      ENDIF
*
* Disulphides.
*
      IF (DISULD.EQ.0) THEN
      CLOSE(UNIT=46,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=46)
      ENDIF
*
* Turns.
*
      IF (TRNDEC.EQ.0) THEN
      CLOSE(UNIT=70,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=70)
      ENDIF
*
* Drawing / Vector file.
*
      IF (DRWDEC.EQ.0) THEN
      CLOSE(UNIT=71,DISPOSE='DELETE')
      ELSE
      CLOSE(UNIT=71)
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE VIEW(IDEC)
      INTEGER IDEC
      WRITE(*,1000)
1000  FORMAT(' Graphics available on SG only.')
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* do hydrogen bonding calculation.
*
* find donors and acceptors.
*
      SUBROUTINE SSCALC
*
* declarations.
*
      INTEGER NMAINO,NMAINN,E1,E2,E3,E4,NTRIC,I,J
      INTEGER IMAINN(5000),IMAINO(5000)
*
      INTEGER 
     +HBLIST(1000,1000),
     +PARLST(2,1000),
     +TYLST(2,1000),
     +SSHEL(1000),
     +SSTRN(1000),
     +SSSHT(1000),
     +TRILST(4,1000)
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      IOBLG=1
      INBULG=0
      NHBOND=0
*
      DO 500 I=1,10
      DO 500 J=1,1000
      SECSTR(J,I)=0
      HELSTR(J,I)=0
      SHTSTR(J,I)=0
      ITURN(J,I)=0
      ISSBND(J,I)=0
      IANGL(J,I)=0
      BBPART(1,J,I)=0
      BBPART(2,J,I)=0   
      PPLINK(1,J,I)=0
      PPLINK(2,J,I)=0
      TYLINK(1,J,I)=0
      TYLINK(2,J,I)=0
500   CONTINUE
*
* work through chains.
*
      DO 1 I=1,CHL
*
* reinitialise.
*
      DO 501 II=1,1000
      SSHEL(II)=0
      SSTRN(II)=0
      SSSHT(II)=0
      TYLST(1,II)=0
      TYLST(2,II)=0
      PARLST(1,II)=0
      PARLST(2,II)=0
      DO 501 J=1,4
      TRILST(J,II)=0
501   CONTINUE
*
* Calculate hydrogen bonds.
*
      CALL HBCALC(I,NMAINN,NMAINO,IMAINN,IMAINO,HBLIST)
*
* Analyse hydrogen bonds.
*
      NTRIC=0
      CALL HBANAL(NMAINO,I,NTRIC,
     +SSHEL,SSSHT,SSTRN,PARLST,TYLST,HBLIST,
     +TRILST)
*
* put secondary structure into global array.
*
      DO 3 J=1,NMAINO
*
* get pointer.
*
      E1=IMAINO(J)
*
* Error trap.
*
      IF (E1.GT.0) THEN 
*
* get pointers.
*
      E2=RN(E1)
      E3=INDEX(CCLIS,RLAB(E1))
*
* Error trap.
*
      IF (E2.GT.0.AND.E3.GT.0) THEN
*
* save secondary structure information.
*
      SECSTR(E2,E3)=MIN(SSHEL(J),ABS(SSSHT(J)))
      HELSTR(E2,E3)=SSHEL(J)
      SHTSTR(E2,E3)=SSSHT(J)
      ITURN(E2,E3)=SSTRN(J)
*
* partners.
*
      E4=IMAINO(PARLST(1,J))
      IF (E4.GT.0) THEN
      BBPART(1,E2,E3)=E4 
      TYLINK(1,E2,E3)=TYLST(1,J)
      ENDIF
*
      E4=IMAINO(PARLST(2,J))
      IF (E4.GT.0) THEN
      BBPART(2,E2,E3)=E4 
      TYLINK(2,E2,E3)=TYLST(2,J)
      ENDIF
*
      ENDIF
      ENDIF
3     CONTINUE
*
* process bulge links.
*
      IF (BLGLEN.GT.0.AND.INBULG.GE.IOBLG) THEN
*
* do the extra bulges found for this chain.
*
      DO 4 I1=IOBLG,INBULG
*
* get pointers.
*
      E1=BLGLNK(1,1,I1)
      E2=BLGLNK(2,1,I1)
      E3=BLGLNK(3,1,I1)
*
* save them.
*
      BLGLNK(1,1,I1)=IMAINO(E1)
      BLGLNK(2,1,I1)=IMAINO(E2)
      BLGLNK(3,1,I1)=IMAINO(E3)
*
4     CONTINUE
*
* save end of this list.
*
      IOBLG=INBULG
      ENDIF
*
1     CONTINUE
*
      RETURN
      END
*  
*-------------------------------------------------------------------------------
*
* do hydrogen bonding ANALYSIS.
*
      SUBROUTINE HBANAL(IELEMN,ICHL,NTRIC,
     +SSHEL,SSSHT,SSTRN,PARLST,TYLST,HBLIST,TRILST)
*
* declarations.
*
      INTEGER I,J,K,IELEMN,ICHL
*
      INTEGER HBLIST(1000,1000),PARLST(2,1000),
     +SSHEL(1000),SSSHT(1000),TYLST(2,1000),SSTRN(1000),
     +TRILST(4,1000),NTRIC
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      DO 2 J=1,IELEMN
*
* Primitive assignment.
*
      SSHEL(J)=0
      SSSHT(J)=0
*
* N(j)->O (partner)
*
* INNER
*
      PARLST(1,J)=0
*
* O(j)->N (partner)
*
* OUTER
*
      PARLST(2,J)=0
*
2     CONTINUE
*
* get turns and helices.
*
      DO 401 J=1,IELEMN
*
* 2 Turns.
*
      JJ=J-2
      IF (JJ.GT.1) THEN
      IF (HBLIST(JJ,J).EQ.1) THEN
      SSTRN(J)=SSTRN(J)+2
      ENDIF
      ENDIF
*
* 3 Turns.
*
      JJ=J-3
      IF (JJ.GT.1) THEN
      IF (HBLIST(JJ,J).EQ.1) THEN
      SSHEL(J)=3
      SSTRN(J)=SSTRN(J)+30
      ENDIF
      ENDIF
*
* 4 Turns.
*
      JJ=J-4
      IF (JJ.GT.1) THEN
      IF (HBLIST(JJ,J).EQ.1) THEN
      SSHEL(J)=4
      SSTRN(J)=SSTRN(J)+400
      ENDIF
      ENDIF
*
401   CONTINUE
*
* beta bridges.
*
      DO 101 J=1,IELEMN
*
      DO 101 I=J,IELEMN
*
* error trap.
*
      IJI=ABS(J-I)
*
* Bulges.
*
      IF (BLGLEN.GT.0) THEN
*
      DO 201 K=1,BLGLEN
*
* error trap.
*
      IF (IJI.LE.K) GOTO 201
*
*  anti-parallel.
*
*   classic.
*
      IF 
     +(HBLIST(I,J-K).EQ.1.AND.HBLIST(J,I).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=I
      BLGLNK(2,1,INBULG)=J
      BLGLNK(3,1,INBULG)=J+K
      BLGLNK(1,2,INBULG)=1
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
      IF 
     +(HBLIST(J,I-K).EQ.1.AND.HBLIST(I,J).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=J
      BLGLNK(2,1,INBULG)=I
      BLGLNK(3,1,INBULG)=I+K
      BLGLNK(1,2,INBULG)=1
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
*  wide type.
*
      IF 
     +(HBLIST(J-1,I+1).EQ.1.AND.HBLIST(I-1,J+1+K).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=I
      BLGLNK(2,1,INBULG)=J
      BLGLNK(3,1,INBULG)=J+K
      BLGLNK(1,2,INBULG)=2
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
      IF 
     +(HBLIST(I-1,J+1).EQ.1.AND.HBLIST(J-1,I+1+K).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=J
      BLGLNK(2,1,INBULG)=I
      BLGLNK(3,1,INBULG)=I+K
      BLGLNK(1,2,INBULG)=2
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
* parallel bulge.
*
*  classic.
*
      IF 
     +(HBLIST(I,J+1+K).EQ.1.AND.HBLIST(J-1,I).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=I
      BLGLNK(2,1,INBULG)=J
      BLGLNK(3,1,INBULG)=J+K
      BLGLNK(1,2,INBULG)=3
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
      IF 
     +(HBLIST(J,I+1+K).EQ.1.AND.HBLIST(I-1,J).EQ.1) THEN
      INBULG=INBULG+1
      BLGLNK(1,1,INBULG)=J
      BLGLNK(2,1,INBULG)=I
      BLGLNK(3,1,INBULG)=I+K
      BLGLNK(1,2,INBULG)=3
      BLGLNK(2,2,INBULG)=K
      ENDIF
*
201   CONTINUE
*
      ENDIF
*
* error trap.
*
      IF (IJI.LT.2) GOTO 101
*
* Anti-Parallel bridge.
*
      IF 
     +(HBLIST(I,J).EQ.1.AND.HBLIST(J,I).EQ.1) THEN
*
      PARLST(1,J)=I
      PARLST(1,I)=J
      TYLST(1,J)=8
      TYLST(1,I)=8
      SSSHT(I)=8
      SSSHT(J)=8
*
      GOTO 101
      ENDIF
*
* error trap.
*
      IF (IJI.LT.3) GOTO 101
*
* Outer type beta-bridge.
*
      IF 
     +(HBLIST(I-1,J+1).EQ.1.AND.HBLIST(J-1,I+1).EQ.1) THEN
*
      PARLST(2,I)=J
      PARLST(2,J)=I
      TYLST(2,J)=8
      TYLST(2,I)=8
      SSSHT(I)=8
      SSSHT(J)=8
*
      GOTO 101
      ENDIF
*
* Parallel bridges.
*
      IF 
     +(HBLIST(I-1,J).EQ.1.AND.HBLIST(J,I+1).EQ.1) THEN
*
      PARLST(1,J)=I
      PARLST(2,I)=J
      TYLST(1,J)=9
      TYLST(2,I)=9
      SSSHT(I)=9
      SSSHT(J)=9
*
      GOTO 101
      ENDIF
*
      IF 
     +(HBLIST(J-1,I).EQ.1.AND.HBLIST(I,J+1).EQ.1) THEN
*
      PARLST(1,I)=J
      PARLST(2,J)=I
      TYLST(1,I)=9
      TYLST(2,J)=9
      SSSHT(I)=9
      SSSHT(J)=9
*
      GOTO 101
      ENDIF
*
101   CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* do hydrogen bonding calculation.
*
*   find donors and acceptors.
*   create separate file for each sort of interaction.
*
      SUBROUTINE 
     +HBCALC(II,NMAINN,NMAINO,IMAINN,IMAINO,HBLIST)
*
* declarations.
*
      INTEGER J,NHB,IDEC,II
      INTEGER NMAINN,NMAINO,IMAINN(5000),IMAINO(5000),E1,NP,OP
      INTEGER HBLIST(1000,1000)
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      DMNHBS=DMAXHB*DMAXHB
*
* announce subroutine.
*
      WRITE(*,1000) DMINHB,DMAXHB,
     +              ANGMIN,ANGMAX,ANGMIN1,ANGMAX1
*
* find main chain bonding atoms.
*
      NMAINN=0
      NMAINO=0
*
      DO 1 J=RN1(II),RN2(II)
*
*      IF (POS(0,J,I).LT.1) GOTO 1
*      IF (POS(-1,J,I).LT.4) GOTO 1
*
      E1=POS(1,J,II)
      IF (E1.GT.0) THEN
      NMAINN=NMAINN+1
      IMAINN(NMAINN)=E1
      ELSE
      NMAINN=NMAINN+1
      IMAINN(NMAINN)=0
      ENDIF
*
      E1=POS(3,J,II)
      IF (E1.GT.0) THEN
      NMAINO=NMAINO+1
      IMAINO(NMAINO)=E1
      ELSE
      NMAINO=NMAINO+1
      IMAINO(NMAINO)=0
      ENDIF
1     CONTINUE
*
* write out summary of donors and acceptors found.
*
      IF (NMAINN.LT.1) THEN
      WRITE(*,1033) 
      STOP'FOLD has been terminated by Error Status.'
      ELSEIF (NMAINO.LT.1) THEN
      WRITE(*,1034)
      STOP'FOLD has been terminated by Error Status.'
      ELSE
      WRITE(*,1002) NMAINO,NMAINN
      ENDIF
*
* Now find main chain - main chain hydrogen bonds.
*
      NHB=0
*
      DO 11 IDONOR=1,NMAINN
*
      NP=IMAINN(IDONOR)
*
      IF (NP.GT.0) THEN
*
      DO 12 IACCOR=1,NMAINO
*
      OP=IMAINO(IACCOR)
*
      HBLIST(IACCOR,IDONOR)=0
*
      IF (OP.GT.0) THEN
*
* check not same residue.
*
      IF (RN(NP).EQ.RN(OP)) THEN
      IF (RLAB(NP).EQ.RLAB(OP)) GOTO 22
      ENDIF
*
* use distance to screen out non-hits.
*
      CALL GETDIS(IDEC,NP,OP,DD,DMAXHB,DMNHBS)
*
* check if good angles. calculate geometry.
*
      IF (IDEC.EQ.1) THEN 
*
* Check geometry of interaction.
*
      CALL 
     +ANALHB(MIDEC,NP,OP,DD)
*
* Store logical hbond.
*
      IF (MIDEC.EQ.1) THEN
      NHB=NHB+1
      HBLIST(IACCOR,IDONOR)=1
      ENDIF
*
      ENDIF
*
22    CONTINUE
*
      ENDIF
*
12    CONTINUE
*
      ENDIF
*
11    CONTINUE
*
      WRITE(*,1003) NHB
*
* format statements.
*
1000  FORMAT(/' Calculating Hydrogen bonds.'//,
     +'      minimum distance for hydrogen bond:',F8.3,'.'/,
     +'      maximum distance for hydrogen bond:',F8.3,'.'/,
     +'  limits for hydrogen bond angle (N-O-C):',2F8.3/,
     +'  limits for hydrogen bond angle (O-N-C):',2F8.3)
1001  FORMAT(/'  Main Chain - Main Chain Hydrogen Bonds.'//)
1002  FORMAT(/
     +I5,' main chain acceptors found.'/,
     +I5,' main chain donors found.'/)
1003  FORMAT(/' Total number of good main chain hydrogen bonds 
     +found:',I6/)
1010  FORMAT(
     +'      Donor      Acceptor      distance      angle    in-plane  
     +  out-of-plane'/)
1033  FORMAT(/' ERROR: no main chain donors found.')
1034  FORMAT(/' ERROR: no main chain acceptors found.')
3000  FORMAT(36I2)
*
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* form lookup table for standard atom names.
*
*      DATA  ATLOOK /
*     +'N   ','C   ','O   ','CA  ','CB  ',
*     +'CG  ','CD  ','NE  ','CZ  ',
*     +'NH1 ','NH2 ','OD1 ','OD2 ',
*     +'CD1 ','CE1 ','CE2 ','CD2 ',
*     +'SG  ','OE1 ','OE2 ','OH  ',
*     +'OG1 ','CG2 ','CE  ','NZ  ',
*     +'CG1 ','ND2 ','NE2 ','SD  ',
*     +'OG  ','OT  ','OTX ' /
*  
*-------------------------------------------------------------------------------
*
* check hydrogen bonding distance.
*
      SUBROUTINE GETDIS(IDEC,NP,OP,DD,DLIM,DLIMS)
*
* declarations.
*
      INTEGER NP,OP,IDEC
      REAL DD,DLIM,DLIMS
      REAL DX,DY,DZ,DR
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      IDEC=0
      DD=0.0
*
      DX=ABS(X(NP)-X(OP))
      IF (DX.GT.DLIM) RETURN
      DY=ABS(Y(NP)-Y(OP))
      IF (DY.GT.DLIM) RETURN
      DZ=ABS(Z(NP)-Z(OP))
      IF (DZ.GT.DLIM) RETURN
      DR=DX*DX+DY*DY+DZ*DZ
*
* now check.
*
      IF (DR.LE.DLIMS) THEN
      DD=SQRT(DR)
      IDEC=1
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* analyse geometry of hydrogen bond.
*
      SUBROUTINE ANALHB(MDEC,NP,OP,DD1)
*
* declarations.
*
      INTEGER NP,OP,EC,MDEC,K,EC1,K1,L1,EO1,EN,L
      REAL BANG,TANG1,TANG2,DD1
*
      INCLUDE 'FOLD.INC'
*
* reinitialise.
*
      MDEC=0
*
* trap short hbonds.
*
      IF (DD1.LT.DMINHB) THEN
      RETURN
      ENDIF
*
* get pointer to C and N of acceptor.
*
      K=INDEX(CCLIS,RLAB(OP))
      L=RN(OP)
*
* Error trap.
*
      IF (K.GT.0.AND.L.GT.0) THEN
*
* now get atom pointers.
*
      EC=POS(2,L,K)
      EN=POS(1,L+1,K)
*
* Error trap.
*
      IF (EC.GT.0.AND.EN.GT.0) THEN
*
* get bond angle of hydrogen bond.
*
      CALL BANGL(EC,OP,NP,BANG)
*
* is it acceptable.
*
      IF (BANG.LT.ANGMIN.OR.
     +    BANG.GT.ANGMAX) THEN
      ELSE
*
* get pointer to C and N of donor.
*
      K1=INDEX(CCLIS,RLAB(NP))
      L1=RN(NP)
*
* Error trap.
*
      IF (K1.GT.0.AND.L1.GT.0) THEN
*
* Get atom pointers.
*
      EC1=POS(2,L1-1,K1)
      EO1=POS(3,L1-1,K1)
*
* Error trap.
*
      IF (EC1.GT.0.AND.EO1.GT.0) THEN
*
* Calculate this bond angle.
*
      CALL BANGL(EC1,NP,OP,BANG2)
*
* is it acceptable.
*
      IF (BANG2.LT.ANGMIN1.OR.
     +    BANG2.GT.ANGMAX1) THEN
      ELSE
*
* set return flag for bond counter.
*
      MDEC=1
*
* draw vectors to file.
*
      IF (DRWDEC.EQ.1) THEN
      CALL VECPLT(0,X(NP),Y(NP),Z(NP),71)
      CALL VECPLT(1,X(OP),Y(OP),Z(OP),71)
      ENDIF
*
* update 3D hbond list.
*
      IF (NHBOND.LT.15000) THEN
      NHBOND=NHBOND+1
      LSTHBD(1,NHBOND)=NP
      LSTHBD(2,NHBOND)=OP
      ENDIF
*
* Calculate torsion angles N-C-Oac-Nd.
*
      CALL TORANG(EN,EC,OP,NP,TANG1)
*
* Calculate torsion angle N-C-Nd-Oac.
*
      CALL TORANG(EO1,EC1,NP,OP,TANG2)
*
* Calculate peptide-peptide dihedral angle.
*
      CALL TORANG(EC,OP,NP,EC1,TANG3)
*
* Write information.
*
      WRITE(25,1500) RNAM(NP),RN(NP),RLAB(NP),
     +RNAM(OP),RN(OP),RLAB(OP),
     +DD1,BANG,BANG2,TANG3
*
* projection geometry.
*
      WRITE(25,2000) 
     +DANGL(1,L,K),DANGL(2,L,K),ASYMB(L,K),
     +DD1,BANG,TANG1
*
      WRITE(25,2001) 
     +DANGL(1,L1,K1),DANGL(2,L1,K1),ASYMB(L1,K1),
     +DD1,BANG2,TANG2
*
      ENDIF
      ENDIF
*
      ENDIF
      ENDIF
*
      ENDIF
      ENDIF
*
* format statements.
*
1000  FORMAT(1X,2(A4,A3,I4,A1,1X),4(F10.3,1X))
1001  FORMAT(1X,2(A4,A3,I4,A1,1X),2(F10.3,1X),2(5X,'-',5X))
1002  FORMAT(1X,2(A4,A3,I4,A1,1X),F10.3,1X,3(5X,'-',5X))
*
1500  FORMAT(1X,A3,I4,A1,' - ',1X,A3,I4,A1,
     +' C O N C:',F5.2,3F9.3)
2000  FORMAT(2X,2F8.2,1X,A2,'   N O C N:',3F9.3)
2001  FORMAT(2X,2F8.2,1X,A2,'   O N C O:',3F9.3)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get angle of Hydrogen bond.
*
      SUBROUTINE BANGL(EC,OP,NP,BANG)
*
* Declarations.
*
      INTEGER EC,OP,NP
      REAL BANG
*
      REAL X1(3),X2(3)
      REAL DD1,DD2,DX1,DX2,DY1,DY2,DZ1,DZ2
      REAL CONV
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      CONV=180.0/3.14159
*
* get vectors.
*
      X1(1)=X(NP)-X(OP)
      X1(2)=Y(NP)-Y(OP)
      X1(3)=Z(NP)-Z(OP)
      X2(1)=X(EC)-X(OP)
      X2(2)=Y(EC)-Y(OP)
      X2(3)=Z(EC)-Z(OP)
*
* Get angle.
*
      DX1=X1(1)**2
      DY1=X1(2)**2
      DZ1=X1(3)**2
*
      DX2=X2(1)**2
      DY2=X2(2)**2
      DZ2=X2(3)**2
*
      DD1=SQRT(DX1+DY1+DZ1)
      DD2=SQRT(DX2+DY2+DZ2)
*
      TAU=(
     +X1(1)*X2(1)+
     +X1(2)*X2(2)+
     +X1(3)*X2(3))
*
      DAU=(DD1*DD2)
*
      IF (ABS(DAU).LT.0.00001) THEN
      BANG=0.0
      RETURN
      ENDIF
*
      TAU=TAU/DAU
      BANG=ACOS(TAU)*CONV
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Check the 3x3 matrix for orthogonality.
*
      SUBROUTINE CHKMAT(R,DET)
*
* declarations.
*
      REAL R(3,3),DET
*
* Determinant.
*
      DET=
     $   R(1,1)*R(2,2)*R(3,3)
     $ + R(1,2)*R(2,3)*R(3,1)
     $ + R(1,3)*R(2,1)*R(3,2)
     $ - R(1,3)*R(2,2)*R(3,1)
     $ - R(1,2)*R(2,1)*R(3,3)
     $ - R(1,1)*R(2,3)*R(3,2)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* write drawing command to VECTOR file.
*
      SUBROUTINE VECPLT(IFLAG,X,Y,Z,IIO)
*
* declarations.
*
      INTEGER IFLAG,ICOL,IIO
      REAL X,Y,Z,XDUMMY,YDUMMY,FDUMMY
*
* initialise.
*
      XDUMMY=0.
      YDUMMY=0.
      FDUMMY=0.
      ICOL=0
*
* MOVE if iflag=0.
* DRAW if iflag=1.
*
      WRITE(IIO) IFLAG,ICOL,XDUMMY,YDUMMY,FDUMMY,X,Y,Z
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Find all disulphides.
*
      SUBROUTINE SSBOND
*
* Declarations.
*
      INTEGER IE,E1,E2,IPSS(1000),NSP,ISS1(500),ISS2(500),IDEC,NSS
*
      INCLUDE 'FOLD.INC'
*
* Announce subroutine.
*
      WRITE(*,1000)
*
* work through chains.
*
      NSS=0
      DO 1 I=1,CHL
      DO 1 J=RN1(I),RN2(I)     
*
* get pointers and atom names.
*
      IE=POS(6,J,I)
*
      IF (ATNAM(IE).EQ.'SG  ') THEN
      NSS=NSS+1
      IPSS(NSS)=IE
      ENDIF
*
1     CONTINUE
*
* Error trap no cysteines.
*
      IF (NSS.GT.0) THEN
*
* report cysteines found.
*
      WRITE(*,1001) NSS
*
* check good disulphide bond distance.
*
      NSP=0
*
* work through all cysteines.
*
      DO 2 I=1,NSS
      DO 2 J=(I+1),NSS
*
* get pointers.
*
      E1=IPSS(I)
      E2=IPSS(J)
*
* get distance.
*
      IDEC=0
      CALL GETDIS(IDEC,E1,E2,DD,3.5,3.5*3.5)
*
* check it.
*
      IF (IDEC.EQ.1) THEN
*
* save pair.
*
      NSP=NSP+1
      ISS1(NSP)=E1
      ISS2(NSP)=E2
*
* get information.
*
      CALL CLCSSB(E1,E2,NSP,DD)
*
      ENDIF
*
2     CONTINUE
*
      ENDIF
*
* write summary. delete file if empty.
*
      IF (NSP.GT.0) THEN
      WRITE(*,7005) NSP
      WRITE(46,7005) NSP
      ELSE
      CLOSE(UNIT=46,DISPOSE='DELETE')
      ENDIF
*
* format statements.
*
1000  FORMAT(/' Calculating Disulphide bond parameters.') 
1001  FORMAT(/' Number of free sulphurs:',I5,'.'/)
1100  FORMAT(/' Chain: ',I2,' label: ',A1,'.')
7000  FORMAT(/1X,A3,1X,I3/)
7001  FORMAT(/' Bond Lengths.'/)
7004  FORMAT(/)
7005  FORMAT(' Total number of disulphides found:',I6,'.'/)
7101  FORMAT(2(1X,A3),2X,F9.4)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Calculate SS-bond characteristics.
*
      SUBROUTINE CLCSSB(E1,E2,IDISUL,DSS)
*
* Declarations.
*
      INTEGER E1,E2,C1,CA1,N1,R1,R2,C2,CA2,N2,IDISUL
      REAL DSS
*
      INCLUDE 'FOLD.INC'
*
* get pointers to other atoms. CB,CA, AND N.
*
      R1=RN(E1)
      L1=INDEX(CCLIS,RLAB(E1))
      C1=POS(5,R1,L1)    
      CA1=POS(4,R1,L1)    
      N1=POS(1,R1,L1)
*
      R2=RN(E2)
      L2=INDEX(CCLIS,RLAB(E2))
      CA2=POS(4,R2,L2)    
      C2=POS(5,R2,L2)
      N2=POS(1,R2,L2)
*
* Save disulphide connection pointer.
*
      ISSBND(R1,L1)=IDISUL
      ISSBND(R2,L2)=IDISUL
*
* get CA-CA distance.
*
      CALL GETDIS(IDEC,CA1,CA2,DCA,50.0,2500.)
*
* get the bond angles.
*
      CALL BNDANG(E2,E1,C1,B1)
      CALL BNDANG(E1,E2,C2,B2)
*
* get the torsion angles. Di-SS, CHI1 and CHI2 for both.
*
      CALL TORANG(C1,E1,E2,C2,TT)
*
* chi1
*
      CALL TORANG(N1,CA1,C1,E1,TC1)
      CALL TORANG(N2,CA2,C2,E2,TC2)
*
* chi2
*
      CALL TORANG(CA1,C1,E1,E2,TB1)
      CALL TORANG(CA2,C2,E2,E1,TB2)
*
* now write result.
*
      WRITE(46,1000) IDISUL,
     +RNAM(E1),R1,RLAB(E1),
     +RNAM(E2),R2,RLAB(E2),
     +DSS,B1,B2,TT,
     +RNAM(E1),R1,RLAB(E1),TC1,
     +RNAM(E2),R2,RLAB(E2),TC2,
     +RNAM(E1),R1,RLAB(E1),TB1,
     +RNAM(E2),R2,RLAB(E2),TB2,
     +DCA
*
* format statements.
*
1000  FORMAT(' Disulphide number:',I4,'.'/,
     +1X,A3,I4,A1,' - ',A3,I4,A1/,
     +'            S - S distance:',F10.4/,
     +'       CB-SG-SG bond angle:',F10.4/,
     +'       SG-SG-CB bond angle:',F10.4/,
     +' CB-SG-SG-CB torsion angle:',F10.4/,
     +'           CHI1 - ',A3,I4,A1,':',F10.4/,
     +'           CHI1 - ',A3,I4,A1,':',F10.4/,
     +'           CHI2 - ',A3,I4,A1,':',F10.4/,
     +'           CHI2 - ',A3,I4,A1,':',F10.4/,
     +'            CA-CA distance:',F10.4/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* measure bond angle.
*
      SUBROUTINE BNDANG(E1,E2,E3,TANG)
*
* declarations.
*
      INTEGER E1,E2,E3
      REAL DD1,DD2,DX1,DX2,DY1,DY2,DZ1,DZ2,CONV,TANG
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      CONV=180.0/3.14159
*
* calculate.
*
      DD1=SQRT((X(E1)-X(E2))**2 + 
     + (Y(E1)-Y(E2))**2 + 
     + (Z(E1)-Z(E2))**2)
*
      DD2=SQRT((X(E3)-X(E2))**2 + 
     + (Y(E3)-Y(E2))**2 + 
     + (Z(E3)-Z(E2))**2)
*
      DX1=X(E1)-X(E2)
      DY1=Y(E1)-Y(E2)
      DZ1=Z(E1)-Z(E2)
*
      DX2=X(E3)-X(E2)
      DY2=Y(E3)-Y(E2)
      DZ2=Z(E3)-Z(E2)
*
      TAU=(
     $DX1*DX2+ 
     $DY1*DY2+ 
     $DZ1*DZ2)
*
      DAU=(DD1*DD2)
*
      IF (ABS(DAU).LT.0.00001) THEN
      TAU=0.0
      ELSE
      TAU=TAU/DAU
      ENDIF
      TANG=ACOS(TAU)*CONV
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* calculate torsion angles.
*
      SUBROUTINE DIHED
*
* declarations.
*
      INTEGER I,J,K,NT
      REAL TORS(10),TANG,TANG1,TANG2
      CHARACTER SYMBOL*2
*
      INCLUDE 'FOLD.INC'
*
* announce subroutine.
*
      WRITE(*,1000)
*
* Initialise.
*
      DO 500 I=1,10
      DO 500 J=1,1000
      DO 500 K=1,10
      DANGL(K,J,I)=0.0
500   CONTINUE
*
* work through chains.
*
      DO 1 I=1,CHL
      DO 1 J=RN1(I),RN2(I)
*
* get phi:
*
      CALL APHI(J,I,TANG1)
      DANGL(1,J,I)=TANG1
*
* get psi:
*
      CALL APSI(J,I,TANG2)
      DANGL(2,J,I)=TANG2
*
* get Omega:
*
      CALL AOMG(J,I,TANG)
      DANGL(3,J,I)=TANG
*
* Get and store Ramachandran region.
*
      CALL REGAS(TANG1,TANG2,SYMBOL)
      ASYMB(J,I)=SYMBOL
*
* get all side chain torsions.
*
      CALL GETANG(J,I,NT,TORS)
*
* store them.
*
      IF (NT.GT.0) THEN
      DO 2 I1=1,NT
      DANGL(3+I1,J,I)=TORS(I1)
2     CONTINUE
      IANGL(J,I)=NT+3
      ELSE
      IANGL(J,I)=3
      ENDIF
*
1     CONTINUE
*
* format statements.
*
1000  FORMAT(/' Calculating main chain torsion angles.'/)
*
      RETURN
      END
*  
*-------------------------------------------------------------------------------
*
      SUBROUTINE GETANG(IRES,ICHL,IL,TORS)
*
* Declarations.
*
      INTEGER GETTOR,IL,IRES,ICHL
      INTEGER E1,E2,E3,E4,Q1,Q2,Q3,Q4
      REAL TORS(10)
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      IL=0
*
* work through all torsions.
*
      DO 1 K=4,NTOR
*
* check torsion.
*
      IDEC=GETTOR(K,IRES,ICHL,E1,E2,E3,E4,Q1,Q2,Q3,Q4)
*
* check that this torsion has been found.
*
      IF (IDEC.EQ.1) THEN
*
* increment counter of found torsions.
*
      IL=IL+1
*
* calculate present torsion angle.
*
      CALL TORANG(E1,E2,E3,E4,TANG)
*
* store it.
*
      TORS(IL)=TANG
*     
      ENDIF
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* do angle calculation.
*
      SUBROUTINE APSI(JJ,II,TANG)
*
* declarations.
*
      INTEGER E1,E2,E3,E4,JJ,II
      REAL TANG
*
      INCLUDE 'FOLD.INC'
*
* get pointers.
*
      E1=POS(1,JJ,II)
      E2=POS(4,JJ,II)
      E3=POS(2,JJ,II)
      E4=POS(1,JJ+1,II)
*
* call torsion angle.
*
      CALL TORANG(E1,E2,E3,E4,TANG)
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* do main angle calculation.
*
      SUBROUTINE APHI(JJ,II,TANG)
*
* declarations.
*
      INTEGER JJ,II,E1,E2,E3,E4
      REAL TANG
*
      INCLUDE 'FOLD.INC'
*
* get pointers.
*
      E1=POS(2,JJ-1,II)
      E2=POS(1,JJ,II)
      E3=POS(4,JJ,II)
      E4=POS(2,JJ,II)
*
* call torsion angle.
*
      CALL TORANG(E1,E2,E3,E4,TANG)
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* do main angle calculation.
*
      SUBROUTINE AOMG(JJ,II,TANG)
*
* declarations.
*
      INTEGER II,JJ,E1,E2,E3,E4
*
      REAL TANG
*
      INCLUDE 'FOLD.INC'
*
* get pointers.
*
      E1=POS(4,JJ-1,II)
      E2=POS(2,JJ-1,II)
      E3=POS(1,JJ,II)
      E4=POS(4,JJ,II)
*
* call torsion angle.
*
      CALL TORANG(E1,E2,E3,E4,TANG)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Measure torsion angle.
*
      SUBROUTINE TORANG(E1,E2,E3,E4,TANG)
*
* declarations.
*
      INTEGER E1,E2,E3,E4,I,J
      REAL    TANG,T,S,CONV,WMAG
      REAL    XX(3,4),Q(3,3),U(3),V(3),W(3),A(3),B(3)
*
      INCLUDE 'FOLD.INC'
*
* initialise.
*
      CONV=180.0/3.14159
      TANG=0.0
*
* error trap:
*
      IF (E1.LT.1) RETURN
      IF (E2.LT.1) RETURN
      IF (E3.LT.1) RETURN
      IF (E4.LT.1) RETURN
*
* form triad of interatomic vectors.
*
      XX(1,1)=X(E1)
      XX(1,2)=X(E2)
      XX(1,3)=X(E3)
      XX(1,4)=X(E4)
      XX(2,1)=Y(E1)
      XX(2,2)=Y(E2)
      XX(2,3)=Y(E3)
      XX(2,4)=Y(E4)
      XX(3,1)=Z(E1)
      XX(3,2)=Z(E2)
      XX(3,3)=Z(E3)
      XX(3,4)=Z(E4)
*
      DO 10 I=1,3
      U(I)=XX(I,1)-XX(I,2)
      V(I)=XX(I,4)-XX(I,3)
      W(I)=XX(I,3)-XX(I,2)
10    CONTINUE
*
* Find a = u.cross.w.
*
      A(1)=U(2)*W(3)-U(3)*W(2)
      A(2)=U(3)*W(1)-U(1)*W(3)
      A(3)=U(1)*W(2)-U(2)*W(1)
*
* find b = v.cross.w.
*
      B(1)=V(2)*W(3)-V(3)*W(2)
      B(2)=V(3)*W(1)-V(1)*W(3)
      B(3)=V(1)*W(2)-V(2)*W(1)
*
* find ^w^.
*
      WMAG=SQRT(W(1)**2+W(2)**2+W(3)**2)
*
*' (A.CROSS.B).DOT.W = ^A^*^B^*^W^*SIN(ANGLE).
*
      DO 20 J=1,3
      Q(1,J)=A(J)
      Q(2,J)=B(J)
      Q(3,J)=W(J)
20    CONTINUE
*
* Get determinant.
*
      CALL CHKMAT(Q,S)
*
*' (A.DOT.B)*^W^ = ^A^*^B^*^W^*COS(ANGLE).
*
      T=(A(1)*B(1)+A(2)*B(2)+A(3)*B(3))*WMAG
*
* torsion angle result in degrees.
*
      IF (ABS(S).LT.0.0001) THEN
      TANG=0.0
      ELSE
      TANG=ATAN2(S,T)*CONV
      ENDIF
* 
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get torsion angle names.
*
      INTEGER FUNCTION GETTOR(ITOR,IRES,ICHL,
     +I1,I2,I3,I4,Q1,Q2,Q3,Q4)
*
* Declarations.
*
      INTEGER Q(4),IH(4)
      INTEGER I1,I2,I3,I4,Q1,Q2,Q3,Q4
      CHARACTER TN(4)*4
*
      INCLUDE 'FOLD.INC'
*
* reset decision variable.
*
      GETTOR=0
      ILAST=1
*
* get size of residue.
*
      II=POS(-1,IRES,ICHL)
*
* Error trap no atoms.
*
      IF (II.GT.0) THEN
*
* get pointers
*
      TN(1)=TNAM1(ITOR)
      TN(2)=TNAM2(ITOR)
      TN(3)=TNAM3(ITOR)
      TN(4)=TNAM4(ITOR)
*
* work through all torsions.
*
      DO 3 K=1,4
*
* work through remaining atoms.
*
      DO 2 I=ILAST,II
*
* get atom pointer.
*
      IP1=POS(I,IRES,ICHL)
*
* comapre atom names.
*
      IF (IP1.GT.0) THEN
      IF (ATNAM(IP1).EQ.TN(K)) THEN
      ILAST=I+1
      Q(K)=I
      IH(K)=IP1
      GOTO 3
      ENDIF
      ENDIF
*
2     CONTINUE
*
* Error.
*
      RETURN
*
3     CONTINUE
*
* copy back pointers.
*
      I1=IH(1)
      I2=IH(2)
      I3=IH(3)
      I4=IH(4)
*
      Q1=Q(1)
      Q2=Q(2)
      Q3=Q(3)
      Q4=Q(4)
*
* flag successful torsion discovery.
*
      GETTOR=1
*
      ENDIF
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* assign residues to secondary structure types.
*
      SUBROUTINE SSANAL
*
* declarations.
*
      INTEGER I,II,JJ
*
      INCLUDE 'FOLD.INC'
*
* report definition criteria.
*
      IF (IUPDEC.EQ.0) THEN
      WRITE(*,1001)
      ELSE
      IF (IUPSHT.GT.0) THEN
      WRITE(*,1003)
      ELSE
      WRITE(*,1002)
      ENDIF
      ENDIF
*
* Assign structure to residues. First Pass.
*
      CALL SSELEM
*
* join strands interupted by explicit beta-bulges.
*
      IF (BLGDEC.EQ.1) THEN
*
* Error trap no bulges.
*
      IF (INBULG.GT.0) THEN
      CALL BULGES
      IF (NOBUL.EQ.0) THEN
      CALL WRBLG
      ENDIF
      ELSE
      CLOSE(UNIT=43,DISPOSE='DELETE')
      ENDIF
*
      ENDIF
*
* now list isolated turns.
*
      IF (TRNDEC.EQ.1) THEN
      CALL TURNS
      ENDIF
*
* having assigned residues to a particular secondary structure type work
* through chains doing higher order analysis.
*
      DO 3 I=1,CHL
*
* get lists.
*
      CALL LISTS(I)
*
* Analysis of sheets of this chain.
*
* initialise
*
      DO 551 II=1,100
      SHMARK(II)=0
      SHTCON(II)=0
      DO 551 JJ=1,100
      SHTLNK(JJ,II)=0
      SHTNUM(JJ,II)=0
      SHLTYP(JJ,II)=0
      SHTYP8(JJ,II)=0
      SHTYP9(JJ,II)=0
551   CONTINUE
*
      DO 96 II=1,20
      SHTRNG(II,I)=0
      SHTLEN(II,I)=0
      SHTTYP(II,I)=0
      SHTMRK(II,I)=0
      DO 94 J=1,100
      SHTORI(J,II,I)=0
      SHTTOP(J,II,I)=0
      SHNCON(J,II,I)=0
94    CONTINUE
      DO 96 J=1,30
      RNGLEN(J,II,I)=0
      DO 96 K=1,50
      RNGLST(K,J,II,I)=0
      SHICON(K,J,II,I)=0
96    CONTINUE
*
      NSHEET(I)=0
*
      IF (NSTRAND(I).GT.0) THEN
      CALL SHTSUB(I)
      ENDIF
*
3     CONTINUE 
*
* trap empty hairpin file.
*
      IF (NPIN.GT.0) THEN
      WRITE(42,1000) NPIN
      ELSE
      CLOSE(UNIT=42,DISPOSE='DELETE')
      ENDIF
*
* format statements.
*
1000  FORMAT(/'   Total number of beta-hairpins:',I5,'.'/)
1001  FORMAT(/'   Using strict definitions for helices and strands.')
1002  FORMAT(/'   Using IUPAC definitions for helices.')
1003  FORMAT(/'   Using IUPAC definitions for helices and strands.')
1010  FORMAT(/'   Applying Ring Perception to Closed Sheets.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* assign residues to secondary structure types.
*
      SUBROUTINE SSELEM
*
* declarations.
*
      INTEGER E1,E2,I,J,J1,MCHL
*
      CHARACTER
     +A1*1,A0*1,A2*1,A3*1,SYM2(1000,10)*1,ABB*1
*
      INCLUDE 'FOLD.INC'
*
* work through all chains.
*
      MCHL=MIN(CHL,10)
*
      DO 1 I=1,MCHL
*
* re-initialise.
*
      DO 550 J=1,1000
      SYM2(J,I)=' '
      STRSYM(J,I)=' '
550   CONTINUE
*
* work through the residues of this chain doing helices.
*
      DO 2 J=RN1(I),RN2(I)
*
* get values of structure type.
*
      E1=HELSTR(J,I)
*
* decide.
*
      IF (E1.EQ.0) THEN
*
* skip if nothing.
*
      GOTO 2
*
* 310-helices.
*
      ELSEIF (E1.EQ.3) THEN
      E0=HELSTR(J+1,I)
      IF (E0.EQ.3) THEN
      DO 501 J1=0,2
      IF (STRSYM(J-J1,I).EQ.' ') STRSYM(J-J1,I)='3'
501   CONTINUE
      ENDIF
      GOTO 2     
*
* Alpha-helices.
*
      ELSEIF (E1.EQ.4) THEN
      E0=HELSTR(J+1,I)
      IF (E0.EQ.4) THEN
      DO 502 J1=0,3
      STRSYM(J-J1,I)='4'
502   CONTINUE
      ENDIF
      GOTO 2     
*
      ENDIF 
*
2     CONTINUE
*
* now do strands.
*
      DO 22 J=RN1(I),RN2(I)
*
* get values of structure type.
*
      ABB=STRSYM(J,I)
*
* error trap.
*
      IF (ABB.NE.' ') GOTO 22
*
      E1=SHTSTR(J,I)
*
* error trap.
*
      IF (E1.EQ.0) THEN
      GOTO 22
*
*  anti-parallel beta-strands.
*
      ELSEIF (E1.EQ.8) THEN
*
* get flanking stuff.
*
      E0=SHTSTR(J-1,I)
      E2=SHTSTR(J+1,I)
      A0=STRSYM(J-1,I)
      A2=STRSYM(J+1,I)
*
* anti-parallel strands.
*
      IF (E0.EQ.8) THEN
*
      IF (A0.EQ.'4'.OR.A0.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='A'
      GOTO 22
      ENDIF
*
      ELSEIF (E2.EQ.8) THEN 
*
      IF (A2.EQ.'4'.OR.A2.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='A'
      GOTO 22
      ENDIF
*
* parallel strands.
*
      ELSEIF (E0.EQ.9) THEN
*
      IF (A0.EQ.'4'.OR.A0.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='A'
      GOTO 22
      ENDIF
*
      ELSEIF (E2.EQ.9) THEN
*
      IF (A2.EQ.'4'.OR.A2.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='A'
      GOTO 22
      ENDIF
*
      ELSE
*
* isolated bridge.
*
*      STRSYM(J,I)='a'
*
      GOTO 22
      ENDIF
*
      GOTO 22
*
* parallel beta-strands.
*
      ELSEIF (E1.EQ.9) THEN
*
* get stuff for flanking residues.
*
      E0=SHTSTR(J-1,I)
      E2=SHTSTR(J+1,I)
      A0=STRSYM(J-1,I)
      A2=STRSYM(J+1,I)
*
* parallel strands.
*
      IF (E0.EQ.9) THEN
*
      IF (A0.EQ.'4'.OR.A0.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='P'
      GOTO 22
      ENDIF
*
      ELSEIF (E2.EQ.9) THEN
*
      IF (A2.EQ.'4'.OR.A2.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='P'
      GOTO 22
      ENDIF
*
* anti-parallel strands.
*
      ELSEIF (E0.EQ.8) THEN
*
      IF (A0.EQ.'4'.OR.A0.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='P'
      GOTO 22
      ENDIF
*
      ELSEIF (E2.EQ.8) THEN
*
      IF (A2.EQ.'4'.OR.A2.EQ.'3') THEN
      ELSE
      STRSYM(J,I)='P'
      GOTO 22
      ENDIF
*
      ELSE
*
* isolated bridge.
*
*      STRSYM(J,I)='p'
*
      GOTO 22
      ENDIF
*
      ENDIF
*
22    CONTINUE      
*
* non-strict assignments. 
*
      IF (IUPDEC.EQ.1) THEN
*
* work through residues doing helices.
*
      DO 50 J=RN1(I),RN2(I)
*
* get values of structure type.
*
      A1=STRSYM(J,I)
*
* decide.
*
      IF (A1.NE.' ') THEN 
*
      A2=STRSYM(J-1,I)
      A3=STRSYM(J+1,I)
*
* extend minus.
*
      IF (A2.EQ.' '.AND.SYM2(J-1,I).EQ.' ') THEN 
*
* helices.
*
      IF (A1.EQ.'4') THEN
      SYM2(J-1,I)='4'
      ELSEIF (A1.EQ.'3') THEN
      SYM2(J-1,I)='3'
      ENDIF
*
      ENDIF
*
* extend Plus.
*
      IF (A3.EQ.' '.AND.SYM2(J+1,I).EQ.' ') THEN 
*
* helices.
*
      IF (A1.EQ.'4') THEN
      SYM2(J+1,I)='4'
      ELSEIF (A1.EQ.'3') THEN
      SYM2(J+1,I)='3'
      ENDIF
*
      ENDIF
*
      ENDIF
*
50    CONTINUE
*
* now do strands.
*
      DO 51 J=RN1(I),RN2(I)
*
* get values of structure type.
*
      A1=STRSYM(J,I)
*
* decide.
*
      IF (A1.NE.' ') THEN 
*
      A2=STRSYM(J-1,I)
      A3=STRSYM(J+1,I)
*
* extend minus.
*
      IF (A2.EQ.' '.AND.SYM2(J-1,I).EQ.' ') THEN 
*
* strands.
*
      IF (A1.EQ.'P') THEN
      SYM2(J-1,I)='Q'
      ELSEIF (A1.EQ.'A') THEN
*
* flexible definitions of strand ends.
*
      IF (IUPSHT.EQ.1) THEN
      SYM2(J-1,I)='B'
      ELSEIF (IUPSHT.EQ.2) THEN
      E1=BBPART(1,J,I)
      IF (E1.GT.0) SYM2(J-1,I)='B'
      ENDIF
*
      ENDIF
      ENDIF
*
* extend Plus.
*
      IF (A3.EQ.' '.AND.SYM2(J+1,I).EQ.' ') THEN 
*
* Strands.
*
      IF (A1.EQ.'P') THEN
      SYM2(J+1,I)='Q'
      ELSEIF (A1.EQ.'A') THEN
*
* flexible definitions of strand ends.
*
      IF (IUPSHT.EQ.1) THEN
      SYM2(J+1,I)='B'
      ELSEIF (IUPSHT.EQ.2) THEN
      E1=BBPART(1,J,I)
      IF (E1.GT.0) SYM2(J+1,I)='B'
      ENDIF
*
      ENDIF
*
      ENDIF
      ENDIF
*
51    CONTINUE
*
* Copy sub array into global one.
* Check that beta-hairpins etc are not closed.
*
      DO 507 J=RN1(I),RN2(I)
*
* check sub array entry.
*
      IF (SYM2(J,I).NE.' ') THEN
      IF (STRSYM(J,I).EQ.' ') THEN
*
* get putative definitions.
*
      A1=SYM2(J,I)
      A2=SYM2(J-1,I)
      A3=SYM2(J+1,I)
*
* check strands.
*
      IF (A1.EQ.'B') THEN
      IF (A2.EQ.'B'.OR.A3.EQ.'B'.OR.A2.EQ.'Q'.OR.A3.EQ.'Q') THEN
      STRSYM(J,I)=' '
      ELSE
      STRSYM(J,I)='A'
      ENDIF
      ENDIF
*
      IF (A1.EQ.'Q') THEN
      IF (A2.EQ.'Q'.OR.A3.EQ.'Q'.OR.A2.EQ.'B'.OR.A3.EQ.'B') THEN
      STRSYM(J,I)=' '
      ELSE
      STRSYM(J,I)='P'
      ENDIF
      ENDIF
*
* now check for helices.
*
      IF (A1.EQ.'4') THEN
      STRSYM(J,I)='4'
      ELSEIF (A1.EQ.'3') THEN
      STRSYM(J,I)='3'
      ENDIF
*
      ENDIF
      ENDIF
*
507   CONTINUE
*
      ENDIF
*
* Check isolated bridges.
*
      DO 508 J=RN1(I),RN2(I)
*
* parallel
*
      IF (STRSYM(J,I).EQ.'p') THEN
      IF (STRSYM(J+1,I).EQ.'P'.OR.STRSYM(J-1,I).EQ.'P') 
     +STRSYM(J,I)='P'
      ENDIF
*
* antiparallel
*
      IF (STRSYM(J,I).EQ.'a') THEN
      IF (STRSYM(J-1,I).EQ.'A'.OR.STRSYM(J+1,I).EQ.'A') 
     +STRSYM(J,I)='A'
      ENDIF
*
508   CONTINUE
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get lists of secondary structure elements.
*
      SUBROUTINE LISTS(I)
*
* declarations.
*
      INTEGER I
*
      CHARACTER ANOW*1,ALAST*1
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      ALAST=' '
      CALL INITEL(I)
*
* work through this chain.
*
      DO 1 II=RN1(I),RN2(I)+1
*
* simplify and error trap for last residue in this chain.
*
      IF (II.GT.RN2(I)) THEN
      ANOW=' '
      ELSE
      ANOW=STRSYM(II,I)
      IF (ANOW.EQ.'A'.OR.ANOW.EQ.'P') ANOW='E'
      ENDIF
*
* sheets.
*
      IF (ANOW.EQ.'E') THEN 
      IF (ALAST.NE.'E') THEN 
      NELEM(I)=NELEM(I)+1
      ELEM(NELEM(I),I)=1
      NSTRAND(I)=NSTRAND(I)+1
      STRAND1(NSTRAND(I),I)=II
*
      IF (ALAST.EQ.' ') LOOP2(NLOOP(I),I)=II-1
      IF (ALAST.EQ.'3') HEL3N2(NHEL3(I),I)=II-1
      IF (ALAST.EQ.'4') HEL4N2(NHEL4(I),I)=II-1
*
      ENDIF
      ENDIF
*
* error trap for single bridges interrupting helices.
*
      IF (ANOW.EQ.'a'.OR.ANOW.EQ.'p') THEN 
      IF (ALAST.EQ.'3') HEL3N2(NHEL3(I),I)=II-1
      IF (ALAST.EQ.'4') HEL4N2(NHEL4(I),I)=II-1
      ENDIF
*
* mark strands.
*
      IF (ANOW.EQ.'E') THEN
      SSLINK(II,I)=NSTRAND(I)
      ENDIF
*
* 3-helix.
*
      IF (ANOW.EQ.'3') THEN
      IF (ALAST.NE.'3') THEN 
      NELEM(I)=NELEM(I)+1
      ELEM(NELEM(I),I)=2
      NHEL3(I)=NHEL3(I)+1
      HEL3N1(NHEL3(I),I)=II
*
      IF (ALAST.EQ.' ') LOOP2(NLOOP(I),I)=II-1
      IF (ALAST.EQ.'E') STRAND2(NSTRAND(I),I)=II-1
      IF (ALAST.EQ.'4') HEL4N2(NHEL4(I),I)=II-1
*
      ENDIF
      ENDIF
*
* 4-helix
*
      IF (ANOW.EQ.'4') THEN
      IF (ALAST.NE.'4') THEN 
      NELEM(I)=NELEM(I)+1
      ELEM(NELEM(I),I)=2
      NHEL4(I)=NHEL4(I)+1
      HEL4N1(NHEL4(I),I)=II
      IF (ALAST.EQ.' ') LOOP2(NLOOP(I),I)=II-1
      IF (ALAST.EQ.'E') STRAND2(NSTRAND(I),I)=II-1
      IF (ALAST.EQ.'3') HEL3N2(NHEL3(I),I)=II-1
      ENDIF
      ENDIF
*
* loops.
*
      IF (ANOW.EQ.' ') THEN
      IF (ALAST.NE.' ') THEN
      NLOOP(I)=NLOOP(I)+1
      LOOP1(NLOOP(I),I)=II
      IF (ALAST.EQ.'E') STRAND2(NSTRAND(I),I)=II-1
      IF (ALAST.EQ.'3') HEL3N2(NHEL3(I),I)=II-1
      IF (ALAST.EQ.'4') HEL4N2(NHEL4(I),I)=II-1
      ENDIF
      ENDIF
*
* store structure type.
*
      ALAST=ANOW
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Initialise lists.
*
      SUBROUTINE INITEL(ICHAIN)
*
* declarations.
*
      INTEGER I,ICHAIN
*
      INCLUDE 'FOLD.INC'
*
* counters.
*
      NELEM(ICHAIN)=0
      NLOOP(ICHAIN)=0
      NSTRAND(ICHAIN)=0
      NHEL3(ICHAIN)=0
      NHEL4(ICHAIN)=0
*
* Ranges.
*
      DO 1 I=1,100
      LOOP1(I,ICHAIN)=0
      LOOP2(I,ICHAIN)=0
      STRAND1(I,ICHAIN)=0
      STRAND2(I,ICHAIN)=0
      HEL3N1(I,ICHAIN)=0
      HEL3N2(I,ICHAIN)=0
      HEL4N1(I,ICHAIN)=0
      HEL4N2(I,ICHAIN)=0
1     CONTINUE
*
      DO 2 I=1,1000
      ELEM(I,ICHAIN)=0
      SSLINK(I,ICHAIN)=0
2     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* close bulges in strands.
*
      SUBROUTINE BULGES
*
* declarations.
*
      INTEGER I,J,K,E1,E2,E3,J1,J2,J3,I1,I2,I3,II
      CHARACTER A1*1
*
      INCLUDE 'FOLD.INC'
*
* work through chains linking bulge interrupted chains.
*
      DO 9 I=1,CHL
*
* get lists.
*
      CALL LISTS(I)
*
* work through bulges.
*
      DO 91 J=1,INBULG
*
* get pointers.
*
      E1=BLGLNK(1,1,J)
      E2=BLGLNK(2,1,J)
      E3=BLGLNK(3,1,J)
*
* error trap.
*
      IF (E1.GT.0.AND.E2.GT.0.AND.E3.GT.0) THEN 
*
* get pointers.
*
      I1=INDEX(CCLIS,RLAB(E1))
      I2=INDEX(CCLIS,RLAB(E2))
      I3=INDEX(CCLIS,RLAB(E3))
*
* error trap.
*
      IF (I1.GT.0.AND.I2.GT.0.AND.I3.GT.0) THEN
*
      IF (I1.EQ.I.AND.I2.EQ.I.AND.I3.EQ.I) THEN
*
* get pointers.
*
      J1=RN(E1)
      J2=RN(E2)
      J3=RN(E3)
*
* error trap.
*
      IF (SSLINK(J1,I).EQ.SSLINK(J2,I).OR.
     +    SSLINK(J1,I).EQ.SSLINK(J3,I).OR.
     +    SSLINK(J1,I).EQ.SSLINK(J2-1,I).OR.
     +    SSLINK(J1,I).EQ.SSLINK(J3+1,I)) THEN
      ELSE
*
* get symbol.
*
      A1=STRSYM(J1,I)
*
* check appropriate type of secondary strcuture.
*
      IF (A1.EQ.'A'.OR.A1.EQ.'P') THEN
*
      IF (STRSYM(J2,I).EQ.'A'.OR.STRSYM(J2,I).EQ.'P'
     +.OR.STRSYM(J2-1,I).EQ.'A'.OR.STRSYM(J2-1,I).EQ.'P') THEN
*
      IF (STRSYM(J3,I).EQ.'A'.OR.STRSYM(J3,I).EQ.'P'
     +.OR.STRSYM(J3+1,I).EQ.'A'.OR.STRSYM(J3+1,I).EQ.'P') THEN
*
* choose fill in type.
*
      K=BLGLNK(1,2,J)
      A1=' '
      IF (K.EQ.1.OR.K.EQ.2) A1='A'
      IF (K.EQ.3) A1='P'
*
* fill bulge.
*
      DO 92 II=J2,J3
      IF (STRSYM(II,I).EQ.' ') STRSYM(II,I)=A1
92    CONTINUE
*
      ENDIF
      ENDIF
      ENDIF
*
      ENDIF
*
      ENDIF
      ENDIF
      ENDIF
*
91    CONTINUE
*
9     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* find and analyse sheets in structure.
*
      SUBROUTINE SHTSUB(I)
*
* declarations.
*
      INTEGER I,J,II,IH,JJ,EE1,E1,E2,E3,E4,N8,N9,N10,IDEC
      INTEGER NLIST(100),ILIST(100,100),IRG
      INTEGER LOCORI(100,100),NCON(1000),ICON(100,1000)
*
      CHARACTER ANOW*1
*
      INCLUDE 'FOLD.INC'
*
* Initialise
*
      DO 95 II=1,NSTRAND(I)
*
      DO 95 J=1,NSTRAND(I)
*
      LOCORI(J,II)=0
*
      SHNCON(J,II,I)=0
*
      ORISHT(J,II,I)=0
      LNKSHT(J,II,I)=0
*
      SHEETS(J,II,I)=0
*
95    CONTINUE
*
* work though strands.
*
* get links.
*
      DO 1 II=1,NSTRAND(I)
      DO 2 J=STRAND1(II,I),STRAND2(II,I)
*
* get indexes.
*
      DO 3 IH=1,2
*
* Get pointers.
*
      EE1=BBPART(IH,J,I)
*
* Error trap in range.
*
      IF (EE1.GT.0.AND.EE1.LE.NN) THEN
*
      E3=INDEX(CCLIS,RLAB(EE1))
      E4=RN(EE1)
*
* error trap no neighbour.
*
      IF (E3.GT.0.AND.E4.GT.0) THEN
      ANOW=STRSYM(E4,E3)
*
* check strand.
*
      IF (ANOW.EQ.'P'.OR.ANOW.EQ.'A') THEN
      PPLINK(IH,E4,E3)=II
      E1=SSLINK(E4,E3)
*
* fill entries.
*
      IF (E1.GT.0) THEN
*
* Strand connection matrix.
*
      SHTLNK(E1,II)=SHTLNK(E1,II)+1
      SHTLNK(II,E1)=SHTLNK(II,E1)+1
*
* type of connection: parallel or antiparallel.
*
      IF (ABS(TYLINK(IH,E4,E3)).EQ.8) THEN
      SHTYP8(E1,II)=SHTYP8(E1,II)+1
      SHTYP8(II,E1)=SHTYP8(II,E1)+1
      ELSEIF (ABS(TYLINK(IH,E4,E3)).EQ.9) THEN
      SHTYP9(E1,II)=SHTYP9(E1,II)+1
      SHTYP9(II,E1)=SHTYP9(II,E1)+1
      ENDIF
*
      ENDIF
*
      ENDIF
      ENDIF
      ENDIF
*
3     CONTINUE
*
2     CONTINUE
1     CONTINUE
*
* Decide overall parallel/antiparallel connectedness of linked strands.
*
      DO 20 I2=1,NSTRAND(I)
      DO 20 I1=1,NSTRAND(I)
*
* Error trap self comparison.
*
      IF (I1.EQ.I2) GOTO 20
*
* logic for pure vs mixed.
*
      IF (SHTYP8(I1,I2).GT.0) THEN
*
      IF (SHTYP9(I1,I2).LT.1) THEN
      SHLTYP(I1,I2)=8
      ELSE
      IF (SHTYP9(I1,I2).LT.SHTYP8(I1,I2)) THEN
      SHLTYP(I1,I2)=18
      ELSE     
      SHLTYP(I1,I2)=19
      ENDIF
      ENDIF
*
      ELSE
      SHLTYP(I1,I2)=9
      ENDIF
*
* get matrix for richardson orientation.
*
      IF (SHLTYP(I1,I2).EQ.9.OR.SHLTYP(I1,I2).EQ.19) THEN
      LOCORI(I1,I2)=0
      ELSE
      LOCORI(I1,I2)=1
      ENDIF
*
20    CONTINUE
*
* Cluster:
*
      IFK=NSTRAND(I)
      CALL CLUSHT2(LNKTOL,IFK,SHTLNK,LOCORI)
*
* reinitialise.
*
      DO 4 II=1,100
      SHMARK(II)=0
4     CONTINUE
*
* check for antiparallel beta-hairpins.
*
      WRITE(42,1000) I,CCLIS(I:I)
*
* work through strands.
*
      DO 5 II=1,(NSTRAND(I)-1)
*
* Is connection +1 ?
*
      IF (SHTLNK(II,II+1).EQ.1) THEN
*
* Is connection antiparallel.
*
      IF (SHLTYP(II,II+1).EQ.8.OR.SHLTYP(II,II+1).EQ.18) THEN
*
* Increment hairpin counter.
*
      NPIN=NPIN+1
*
* record strands participating.
*
      WRITE(42,1001) II,II+1, 
     +STRAND1(II,I),STRAND2(II,I),
     +STRAND1(II+1,I),STRAND2(II+1,I)
*
* classify hairpin.
*
      DO 51 IY=STRAND2(II,I),STRAND1(II,I),-1
      DO 51 IH=1,2
*
* get pointers.
*
      IE1=BBPART(IH,IY,I)
      IF (IE1.GT.0) THEN
      IE4=RN(IE1)
      IT=PPLINK(IH,IY,I)
*
* is this the loop closing hydrogen bond ?.
*
      IF (IT.EQ.(II+1)) THEN
      ID1=ABS(IY-IE4)-1
      GOTO 52
      ENDIF
      ENDIF
*
51    CONTINUE
52    CONTINUE
*
* Write Sibanda classification to file.
*
      IF (IH.EQ.1) THEN
      WRITE(42,1002) ID1,ID1
      ELSE
      WRITE(42,1002) (ID1-2),ID1
      ENDIF
*
      ENDIF
      ENDIF
5     CONTINUE
*
* Fill sheet lists.
*
      DO 6 II=1,NSTRAND(I)
*
* error trap.
*
      IF (SHMARK(II).EQ.1) THEN
      ELSE
*
* increment counters.
*
      SHMARK(II)=1
      NSHEET(I)=NSHEET(I)+1
      SHTLEN(NSHEET(I),I)=1
*
      SHTNUM(SHTLEN(NSHEET(I),I),NSHEET(I))=II
      SHEETS(SHTLEN(NSHEET(I),I),NSHEET(I),I)=II
*
* get partners in sheet.
*
      DO 66 JJ=1,NSTRAND(I)
*
* trap diagonal.
*
      IF (II.EQ.JJ) THEN
      ELSE
*
* is there a connection ? if so add into list and mark it.
*
      IF (SHTLNK(II,JJ).GT.0) THEN
*
      SHTLEN(NSHEET(I),I)=SHTLEN(NSHEET(I),I)+1
      SHEETS(SHTLEN(NSHEET(I),I),NSHEET(I),I)=JJ
      SHTNUM(SHTLEN(NSHEET(I),I),NSHEET(I))=JJ
      SHMARK(JJ)=1
*
      ENDIF
      ENDIF
*
66    CONTINUE
*
      ENDIF
*
6     CONTINUE
*
* Save data.
*
      DO 601 K1=1,NSTRAND(I)
      DO 601 K2=1,NSTRAND(I)
      ORISHT(K2,K1,I)=LOCORI(K2,K1)
      LNKSHT(K2,K1,I)=SHTLNK(K2,K1)
601   CONTINUE
*
* get connectivity of sheets.
*
      IF (NSHEET(I).GT.0) THEN
*
* work through sheets.
*
      DO 7 II=1,NSHEET(I)
*
* work through members of this sheet.
*
      IF (SHTLEN(II,I).GT.1) THEN
*
* reinitialise.
*
      DO 8 JJ=1,100
      SHTCON(JJ)=0
      NCON(JJ)=0
8     CONTINUE
*
      E3=0
      N8=0
      N9=0
      N10=0
*
* work through members of this sheet.
*
      DO 9 JJ=1,SHTLEN(II,I)
*
* set pointers.
*
      E1=SHTNUM(JJ,II)
      E2=0
*
* Compare to all other strands.
*
      DO 10 KK=1,SHTLEN(II,I)
*
* get pointer.
*
      E4=SHTNUM(KK,II)
*
* Partner ?
*
      IF (SHTLNK(E4,E1).EQ.1.AND.E4.NE.E1) THEN
*
      E2=E2+1
      E3=E3+1
*
* fill connection table.
*
      NCON(JJ)=NCON(JJ)+1
      ICON(NCON(JJ),JJ)=KK
      NCON(KK)=NCON(KK)+1
      ICON(NCON(KK),KK)=JJ
*
* Type of sheet.
*
      IF (SHLTYP(E4,E1).EQ.8) N8=N8+1
      IF (SHLTYP(E4,E1).EQ.9) N9=N9+1
      IF (SHLTYP(E4,E1).EQ.18.OR.SHLTYP(E4,E1).EQ.19) N10=N10+1
*
      ENDIF
10    CONTINUE
      SHTCON(E2)=SHTCON(E2)+1
9     CONTINUE
*
* classify joining type.
*
      CALL SHCLAS(IDEC,N8,N9,N10)      
*
* store result.
*
      SHTTYP(II,I)=IDEC
*
* get richardson topology.
*
      CALL RICHARD(II,I)
*
* calculate number of rings.
*
      E3=(E3/2)-SHTLEN(II,I)+1
      SHTRNG(II,I)=E3
*
* Classify sheet.
*
      IF (E3.GT.0) THEN 
*
* closed and unbranched.
*
      IF (SHTCON(1).LT.1) THEN
      SHTMRK(II,I)=1
      ELSE
*
* closed and branched.
*
      SHTMRK(II,I)=2
      ENDIF
*
      ELSE
*
      IF (SHTCON(1).GT.2) THEN
*
* open and branched
*
      SHTMRK(II,I)=3
      ELSE
*
* open and unbranched.
*
      SHTMRK(II,I)=4
      ENDIF
*
      ENDIF
*
* Save Sheet connectivity.
*
      IFK=SHTLEN(II,I)
      CALL BNDDUP(IFK,NCON,ICON)
*
      DO 35 IU=1,SHTLEN(II,I)
      SHNCON(IU,II,I)=NCON(IU)
      DO 35 IZ=1,NCON(IU)
      SHICON(IZ,IU,II,I)=ICON(IZ,IU)
35    CONTINUE
*
* find rings.
*
      IF (RNGDEC.EQ.1) THEN
*
* Error trap no rings.
*
      IF (E3.GT.0) THEN 
*
* Call ring perception algorithm.
*
      IFK=SHTLEN(II,I)
      CALL RINGS(IFK,IRG,NCON,ICON,NLIST,ILIST)
*
* Order rings.
*
      CALL RNGORD(IRG,NLIST,ILIST)
*
* Save number of rings.
*
      SHTRNG(II,I)=IRG
*
* Save lists of ring members.
*
      IF (IRG.GT.0) THEN
      DO 30 IU=1,IRG
      RNGLEN(IU,II,I)=NLIST(IU)
      DO 31 IZ=1,NLIST(IU)
      RNGLST(IZ,IU,II,I)=ILIST(IZ,IU)
31    CONTINUE
30    CONTINUE
      ENDIF
*
      ENDIF
*
      ENDIF
*
      ENDIF
*
7     CONTINUE
      ENDIF
*
* format statements.
*
1000  FORMAT(/' Chain: ',I2,' label: "',A1,'"'/)
1001  FORMAT(' strands ',I3,' and ',I3,' form a beta-hairpin.'/,
     +'   residues',I5,' - ',I5,' and',I5,' - ',I5,'.')
1002  FORMAT(6X,'Sibanda classification:',I4,':',I4,'.'/)
*
      RETURN
      END
*  
*-------------------------------------------------------------------------------
*
* classify joining of strands within sheet.
*
      SUBROUTINE SHCLAS(IDEC,N8,N9,N10)
*
* declarations.
*
      INTEGER IDEC,N8,N9,N10
*
* logic
*
      IDEC=0
*
* mixed.
*
      IF (N8*N9.GT.0.OR.N10.GT.0) THEN
      IDEC=3
      ELSE
*
      IF (N8.LT.1.AND.N9.GT.0) THEN
*
* parallel
*
      IDEC=2
      ELSEIF (N8.GT.0.AND.N9.LT.1) THEN
*
* antiparallel.
*
      IDEC=1
      ENDIF
*
      ENDIF
*
      RETURN
      END
*  
*-------------------------------------------------------------------------------
*
* write results out to files.
*
      SUBROUTINE DISPLY
*
* declarations.
*
      INTEGER I,J,E1,E2,E3
*
      CHARACTER LINE1*80,LINE2*80,LINE3*80,LINE4*80,
     +LINE5*80,LINE6*80
*
      CHARACTER A1*1,A3*3,S1L*1,S2L*1,S3L*1,
     +A1L*1,A2L*1,SMB2*2,SMBC*1
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      LINE3='                                                                
     +                             '
*
* work through chains writing summary of secondary structure.
*
      DO 1 I=1,CHL
*
* write chain label.
*
      WRITE(9,1001)  I,CCLIS(I:I)
      WRITE(10,1001) I,CCLIS(I:I)
      WRITE(14,1001) I,CCLIS(I:I)
*
* reinitialise.
*
      J1=0
      LINE1=LINE3
      LINE2=LINE3
      LINE4=LINE3
      LINE5=LINE3
      LINE6=LINE3
*
* work through chain.
*
      DO 2 J=RN1(I),RN2(I)
*
* get pointer to this residue.
*
      E1=POS(1,J,I)
*
* error trap.
*
      IF (E1.GT.0) THEN
*
* increment line pointers.
*
      J1=J1+1
      SMBC=' '
*
* get secondary structure symbol.
*
      S1L=STRSYM(J,I)
*
* get disulphide label.
*
      IF (ISSBND(J,I).GT.0) THEN
      IFK=(ISSBND(J,I)+26)
      CALL NUMLET(IFK,S3L)
      ELSE
      S3L=' '
      ENDIF
*
* get sheet label.
*
      IF (SSLINK(J,I).GT.0) THEN
      IFK=SSLINK(J,I)
      CALL NUMLET(IFK,S2L)
      LINE4(J1:J1)=S2L
      ELSE
      S2L=' '
      ENDIF
*
* get strand partners.
*
      A1L=' '
      A2L=' '
      E2=PPLINK(1,J,I)
      E3=PPLINK(2,J,I)
*
      IF (E2.GT.0) THEN
      CALL NUMLET(E2,A1L)
      LINE5(J1:J1)=A1L
      ENDIF
*
      IF (E3.GT.0) THEN
      CALL NUMLET(E3,A2L)
      LINE6(J1:J1)=A2L
      ENDIF
*
* get pointers to actual partners.
*
      E2=BBPART(1,J,I)
      E3=BBPART(2,J,I)
*
* error trap.
*
      IF (E2.LT.1) A1L=' '
      IF (E3.LT.1) A2L=' '
*
* do stuff for long file
*
      A3=RNAM(E1)
*
* alpha-helix.
*
      IF (S1L.EQ.'4') THEN
      WRITE(9,1101) A3,J
*
* 310 helix.
*
      ELSE IF (S1L.EQ.'3') THEN
      WRITE(9,1102) A3,J
*
* antiparallel strand.
*
      ELSE IF (S1L.EQ.'A') THEN
*
*      IF (A1L.NE.' '.AND.A2L.NE.' ') THEN
      IF (E2.GT.0.AND.E3.GT.0) THEN
*
* doubly connected.
*
      WRITE(9,1104) A3,J,S2L,
     +RNAM(E2),RN(E2),RLAB(E2),A1L,
     +RNAM(E3),RN(E3),RLAB(E3),A2L
      SMBC='d'
*
* Singly connected.
*
      ELSEIF (E2.GT.0) THEN
      WRITE(9,1105) A3,J,S2L,
     +RNAM(E2),RN(E2),RLAB(E2),A1L
      SMBC='s'
*
      ELSEIF (E3.GT.0) THEN
      WRITE(9,1106) A3,J,S2L,
     +RNAM(E3),RN(E3),RLAB(E3),A2L
      SMBC='s'
*
* unnconected.
*
      ELSE 
*
      WRITE(9,1110) A3,J
*
      ENDIF
*
* parallel strand.
*
      ELSE IF (S1L.EQ.'P') THEN
*
*      IF (A1L.NE.' '.AND.A2L.NE.' ') THEN
      IF (E2.GT.0.AND.E3.GT.0) THEN
*
* doubly connected.
*
      WRITE(9,1107) A3,J,S2L,
     +RNAM(E2),RN(E2),RLAB(E2),A1L,
     +RNAM(E3),RN(E3),RLAB(E3),A2L
      SMBC='d'
*
* Singly connected.
*
      ELSEIF (E2.GT.0) THEN
      WRITE(9,1108) A3,J,S2L,
     +RNAM(E2),RN(E2),RLAB(E2),A1L
      SMBC='s'
*
      ELSEIF (E3.GT.0) THEN
      WRITE(9,1109) A3,J,S2L,
     +RNAM(E3),RN(E3),RLAB(E3),A2L
      SMBC='s'
*
      ELSE 
*
* unconnected.
*
      WRITE(9,1111) A3,J,S1L
*
      ENDIF
*
* not part of a secondary structure.
*
      ELSE
*
      WRITE(9,1100) A3,J
*
      ENDIF
*
* get other information for summary files.
*
      CALL RNMTCH(A3,A1)
*
      LINE1(J1:J1)=A1
      LINE2(J1:J1)=S1L
*
* get region of ramachandran chart. 
*
      SMB2=ASYMB(J,I)
*
* write angles.
*
      IF (SMB2(2:2).EQ.' ') THEN
      WRITE(9,1113) (DANGL(K7,J,I),K7=1,3),SMB2(1:1)
      ELSE
      WRITE(9,1112) (DANGL(K7,J,I),K7=1,3),SMB2
      ENDIF
*
* write short output.
*
      IF (IANGL(J,I).GT.3) THEN
*
      WRITE(14,1115) 
     +A3,J,S3L,SMBC,S1L,
     +(DANGL(K7,J,I),K7=1,3),SMB2,
     +(DANGL(K8,J,I),K8=4,IANGL(J,I))
*
      ELSE
*
      WRITE(14,1114) 
     +A3,J,S3L,SMBC,S1L,
     +(DANGL(K7,J,I),K7=1,3),SMB2
*
      ENDIF
*
      ENDIF
* 
* write this line.
*
      IF (J1.EQ.80) THEN
      WRITE(10,2000) LINE1,LINE2,LINE4,LINE5,LINE6
      CALL WRNBRF(20,LINE2)
      J1=0
      LINE1=LINE3
      LINE2=LINE3
      LINE4=LINE3
      LINE5=LINE3
      LINE6=LINE3
      ENDIF 
*
2     CONTINUE
*
* cope with overhanging sequence.
*
      IF (J1.GT.0) THEN
      WRITE(10,2000) LINE1,LINE2,LINE4,LINE5,LINE6
      CALL WRNBRF(20,LINE2) 
      ENDIF
*
* terminate NBRF file.
*
      WRITE(20,1021)
*
1     CONTINUE
*
* Write ranges.
*
      IF (RANGED.EQ.1) THEN
      CALL RGEDIS
      ENDIF
*
* Display Sheet information.
*
      IF (SHTDEC.EQ.1) THEN
      CALL SHTDIS
      ENDIF
*
* format statements.
*
1000  FORMAT(//20X,'             F O L D '//,
     +         20X,' Summary of Secondary Structures'//)
1001  FORMAT(/' Chain: ',I2,' label: "',A1,'"'/)
1020  FORMAT(A80)
1021  FORMAT('*')
*
1100  FORMAT(2X,A3,I4)
1101  FORMAT(2X,A3,I4,' is in an Alpha-helix.')
1102  FORMAT(2X,A3,I4,' is in a 310 helix.')
1103  FORMAT(2X,A3,I4,' is in a PI helix.')
1104  FORMAT(2X,A3,I4,
     +' is a doubly connected part of an anti-parallel strand ('
     +,A1,').'/,
     +9X,' inner bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.'/,
     +9X,' outer bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.')
1105  FORMAT(2X,A3,I4,
     +' is a singly connected part of an anti-parallel strand (',
     +A1,').'/,
     +9X,' inner bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.')
1106  FORMAT(2X,A3,I4,
     +' is a singly connected part of an anti-parallel strand (',
     +A1,').'/,
     +9X,' outer bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.')
1107  FORMAT(2X,A3,I4,
     +' is a doubly connected part of a parallel strand (',A1,').'/,
     +9X,' inner bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.'/,
     +9X,' outer bridge partner: ',A3,I4,A1,' part of strand: ',A1,'.')
1108  FORMAT(2X,A3,I4,
     +' is a singly connected part of a parallel strand (',
     +A1,').'/,
     +9X,' inner bridge partner: ',A3,I4,A1,' part of strand: ',A1,'.')
1109  FORMAT(2X,A3,I4,
     +' is a singly connected part of a parallel strand (',
     +A1,').'/,
     +9X,' outer bridge partner: ',A3,I4,A1,' part of strand: ',
     +A1,'.')
1110  FORMAT(2X,A3,I4,
     +' is an unconnected part of an anti-parallel strand.')
1111  FORMAT(2X,A3,I4,
     +' is an unconnected part of a parallel strand.')
1112  FORMAT(10X,'   (Phi:',F9.2,'  Psi:',F9.2,'  Omg:',F9.2,
     +'  region: ',A2,') ')
1113  FORMAT(10X,'   (Phi:',F9.2,'  Psi:',F9.2,'  Omg:',F9.2,
     +'  region: ',A1,') ')
1114  FORMAT(3X,A3,I5,A1,2X,A1,A1,2X,3F9.2,2X,A2)
1115  FORMAT(3X,A3,I5,A1,2X,A1,A1,2X,3F9.2,2X,A2,7(3F9.2,2X))
*
2000  FORMAT(5(A80/))
2032  FORMAT(A80/A80)
2001  FORMAT(I1)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* write range summaries. 
*
      SUBROUTINE RGEDIS
*
* Declarations.
*
      INTEGER LTYP(500),AMTHEL,AMTSTR,ACCIAA(20),E1,E2
      CHARACTER W1*1,W2*2,A3*3
*
      INCLUDE 'FOLD.INC'
*
* Work through chains.
*
      DO 3 I=1,CHL
*
* Initialise.
*
      AMTHEL=0
      AMTSTR=0
*
      DO 700 JJ=1,20
      ACCIAA(JJ)=0
700   CONTINUE
*
      WRITE(11,1001) I,CCLIS(I:I)
*
* alpha helices.
*
      IF (NHEL4(I).GT.0) THEN
      WRITE(11,*)
      DO 41 JJ=1,NHEL4(I)
      WRITE(11,1500) HEL4N1(JJ,I),HEL4N2(JJ,I)
      AMTHEL=AMTHEL+ABS(HEL4N2(JJ,I)-HEL4N1(JJ,I))+1
41    CONTINUE
      ENDIF
*
* 310 helices.
*
      IF (NHEL3(I).GT.0) THEN
      WRITE(11,*)
      DO 42 JJ=1,NHEL3(I)
      WRITE(11,1501) HEL3N1(JJ,I),HEL3N2(JJ,I)
      AMTHEL=AMTHEL+ABS(HEL3N2(JJ,I)-HEL3N1(JJ,I))+1
42    CONTINUE
      ENDIF
*
* Strands.
*
      IF (NSTRAND(I).GT.0) THEN
      WRITE(11,*)
      DO 44 JJ=1,NSTRAND(I)
      WRITE(11,1503) STRAND1(JJ,I),STRAND2(JJ,I)
      AMTSTR=AMTSTR+ABS(STRAND2(JJ,I)-STRAND1(JJ,I))+1
44    CONTINUE
      ENDIF
*
* process loops.
*
      IF (NLOOP(I).GT.0) THEN
*
      WRITE(11,*)
*
      DO 46 JJ=2,(NLOOP(I)-1)
      LTYP(JJ)=0
      IF ((LOOP2(JJ,I)-LOOP1(JJ,I)).GT.1) THEN
      E1=LOOP1(JJ,I)
      E2=LOOP2(JJ,I)
      W1=STRSYM(E1-1,I)
      W2=STRSYM(E2+1,I)
      IF (W1.EQ.'A'.OR.W1.EQ.'P') THEN
      IF (W2.EQ.'A'.OR.W2.EQ.'P') THEN
      LTYP(JJ)=1
      ELSEIF (W2.EQ.'4'.OR.W2.EQ.'3') THEN
      LTYP(JJ)=2
      ENDIF
      ENDIF
      IF (W1.EQ.'4'.OR.W1.EQ.'3') THEN
      IF (W2.EQ.'A'.OR.W2.EQ.'P') THEN
      LTYP(JJ)=2
      ELSEIF (W2.EQ.'4'.OR.W2.EQ.'3') THEN
      LTYP(JJ)=3
      ENDIF
      ENDIF
      ENDIF
46    CONTINUE
      DO 47 JJ=2,(NLOOP(I)-1)
      IF (LTYP(JJ).EQ.1) THEN
      E1=LOOP1(JJ,I)
      E2=LOOP2(JJ,I)
      WRITE(11,1505) E1,E2
      ENDIF
47    CONTINUE
      DO 48 JJ=2,(NLOOP(I)-1)
      IF (LTYP(JJ).EQ.2) THEN
      E1=LOOP1(JJ,I)
      E2=LOOP2(JJ,I)
      WRITE(11,1506) E1,E2
      ENDIF
48    CONTINUE
      DO 49 JJ=2,(NLOOP(I)-1)
      IF (LTYP(JJ).EQ.3) THEN
      E1=LOOP1(JJ,I)
      E2=LOOP2(JJ,I)
      WRITE(11,1507) E1,E2
      ENDIF
49    CONTINUE
      ENDIF
*
3     CONTINUE
*
* format statements.
*
1001  FORMAT(/' Chain: ',I2,' label: "',A1,'"'/)
1500  FORMAT(' Alpha Helix:',I5,I5)
1501  FORMAT('   310 Helix:',I5,I5)
1502  FORMAT('    PI Helix:',I5,I5)
1503  FORMAT('      Strand:',I5,I5)
1504  FORMAT('        Loop:',I5,I5)
1505  FORMAT('     BB-Loop:',I5,I5)
1506  FORMAT('     AB-Loop:',I5,I5)
1507  FORMAT('     AA-Loop:',I5,I5)
1510  FORMAT('       Bulge:',I5,I5)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* write results out to files.
*
      SUBROUTINE SHTDIS
*
* declarations.
*
      INTEGER I,J,IDEC,E1,E2,ITOP,K1,K2,P(100)
*
      CHARACTER LINE3*80
*
      CHARACTER A1*1,A4*4,TSLINE*80
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      LINE3='                                                            
     +                               '
*
* write summary of sheets to file.
*
      IDEC=0
      DO 5 I=1,CHL
*
* Trap no sheets.
*
      IF (NSHEET(I).GT.0) THEN
      IDEC=1
      WRITE(12,1001) I,CCLIS(I:I)
*
* work through sheets in this chain.
*
      DO 51 II=1,NSHEET(I)
*
* trap sheet length.
*
      IF (SHTLEN(II,I).GT.1) THEN
*
* report sheet number and length.
*
      WRITE(12,1600) II,SHTLEN(II,I)
*
      ITOP=1
      TSLINE=LINE3
      CALL NUMLET(II,A1)
      TSLINE(1:10)=
     +MOLNAME(1:4)//' '//CCLIS(I:I)//'_'//A1//': '
      ITOP=11
*
* work through this sheet.
*
      DO 6 J=1,SHTLEN(II,I)
*
* Get pointer.
*
      E1=SHEETS(J,II,I)
*
* write sheet topology.
*
      CALL TOPDIS(SHTORI(J,II,I),SHTTOP(J,II,I),ITOP,E1,I,TSLINE)
*
6     CONTINUE
*
* Report summary line for sheet.
*
      CALL PACK1(ITOP,TSLINE)
      WRITE(12,1667) 
      CALL WRLINE(12,ABS(ITOP)-1,
     +TSLINE(1:ABS(ITOP-2))//'.')
*
* now do DRF topology.
*
      CALL SHTSMI(12,II,I)
*
* classify sheet.
*
      IF (SHTMRK(II,I).EQ.1) THEN
      WRITE(12,1601)
      ELSEIF (SHTMRK(II,I).EQ.2) THEN 
      WRITE(12,1602)
      ELSEIF (SHTMRK(II,I).EQ.3) THEN
      WRITE(12,1603)
      ELSEIF (SHTMRK(II,I).EQ.4) THEN
      WRITE(12,1604)
      ELSE
      WRITE(12,1605)
      ENDIF
*
* echo number of rings.
* 
      IF (SHTRNG(II,I).EQ.1) THEN
*
* a single ring.
*
      WRITE(12,1606) 
*
      IF (RNGDEC.EQ.1) THEN
*
* report length.
*
      WRITE(12,1710) 1,RNGLEN(1,II,I)
*
* reinitialise.
*
      ITOP=1
      TSLINE=LINE3
      CALL NUMLET(II,A1)
      TSLINE(1:16)=
     +MOLNAME(1:4)//' '//CCLIS(I:I)//'_'//A1//': '
      ITOP=11
*
* get within ring sequence distance.
*
      CALL SIRING(1,II,I,P)
*
      DO 91 IZ=1,RNGLEN(1,II,I)
*
* get pointers.
*
      K1=RNGLST(IZ,1,II,I)
      E1=SHEETS(K1,II,I)
*
      E2=0
      IF (IZ.GT.1) THEN
      K2=RNGLST(IZ-1,1,II,I)
      E2=SHEETS(K2,II,I)
      ELSE
      K2=RNGLST(RNGLEN(1,II,I),1,II,I)
      E2=SHEETS(K2,II,I)
      ENDIF
*
* get distance between strands in sequence.
*
      IF (REDDEC.EQ.1) THEN
      K3=K1-K2
      K3=P(K1)-P(K2)
      ELSE
      K3=E1-E2
      ENDIF
*
* write sheet topology.
*
      CALL TOPDIS(ORISHT(E1,E2,I),K3,ITOP,E1,I,TSLINE)
*
91    CONTINUE
*
      CALL PACK1(ITOP,TSLINE)
      WRITE(A4,'(I4)') RNGLEN(1,II,I)
      WRITE(12,1667) 
      CALL WRLINE(12,ABS(ITOP)+9,' ring '//
     +TSLINE(1:ABS(ITOP)-2)//'.'//A4)
*
      WRITE(12,*)
      ENDIF
*
      ELSEIF (SHTRNG(II,I).GT.1) THEN
*
* multiple rings.
*
      WRITE(12,1607) SHTRNG(II,I)
      IF (RNGDEC.EQ.1) THEN
      DO 8 IZ=1,SHTRNG(II,I)
*
      WRITE(12,1710) IZ,RNGLEN(IZ,II,I)
*
* reinitialise.
*
      ITOP=1
      TSLINE=LINE3
      CALL NUMLET(II,A1)
      TSLINE(1:10)=
     +MOLNAME(1:4)//' '//CCLIS(I:I)//'_'//A1//': '
      ITOP=11
*
* get within ring sequence distance.
*
      CALL SIRING(IZ,II,I,P)
*
      DO 81 IZ1=1,RNGLEN(IZ,II,I)
*
* get pointers.
*
      K1=RNGLST(IZ1,IZ,II,I)
      E1=SHEETS(K1,II,I)
*
      E2=0
      IF (IZ1.GT.1) THEN
      K2=RNGLST(IZ1-1,IZ,II,I)
      E2=SHEETS(K2,II,I)
      ELSE
      K2=RNGLST(RNGLEN(IZ,II,I),IZ,II,I)
      E2=SHEETS(K2,II,I)
      ENDIF
*
* get distance in sequence between strands.
*
      IF (REDDEC.EQ.1) THEN
      K3=K1-K2
      K3=P(K1)-P(K2)
      ELSE
      K3=E1-E2
      ENDIF
*
* write sheet topology.
*
      CALL TOPDIS(ORISHT(E1,E2,I),K3,ITOP,E1,I,TSLINE)
*
81    CONTINUE
*
      CALL PACK1(ITOP,TSLINE)
      WRITE(A4,'(I4)') RNGLEN(IZ,II,I)
      WRITE(12,1667) 
      CALL WRLINE(12,ABS(ITOP)+9,' ring '//
     +TSLINE(1:ABS(ITOP)-2)//'.'//A4)
*
      WRITE(12,*)
8     CONTINUE
      ENDIF
      ELSE
*
* no rings.
*
      WRITE(*,*)
      ENDIF
*
* joining classification. 
*
      IF (SHTTYP(II,I).EQ.1) THEN
      WRITE(12,1701)
      ELSEIF (SHTTYP(II,I).EQ.2) THEN 
      WRITE(12,1702)
      ELSEIF (SHTTYP(II,I).EQ.3) THEN
      WRITE(12,1703)
      ELSE
      WRITE(12,1705)
      ENDIF
*
      ENDIF
*
51    CONTINUE
*
      ENDIF
*
5     CONTINUE
*
* trap empty sheet file.
*
      IF (IDEC.EQ.1) THEN
      CLOSE(UNIT=12)
      ELSE
      CLOSE(UNIT=12,DISPOSE='DELETE')
      ENDIF
*
* Format Statements.
*
1001  FORMAT(/' Chain: ',I2,' label: "',A1,'"'/)
*
1600  FORMAT(/' Sheet:',I3,' has',I3,' strands.'/)
1601  FORMAT(/' this sheet is CLOSED and UNBRANCHED.')
1602  FORMAT(/' this sheet is CLOSED and BRANCHED.')
1603  FORMAT(/' this sheet is OPEN and BRANCHED.')
1604  FORMAT(/' this sheet is OPEN and UNBRANCHED.')
1605  FORMAT(/' this sheet is UNCLASSIFIED.')
1606  FORMAT('  and contains 1 ring.'/)
1607  FORMAT('  and contains',I3,' rings.'/)
1652  FORMAT('      Strand:',I5,I5,3X,A4)
1662  FORMAT('      Strand:',I5,I5,3X,A5)
1654  FORMAT('      Strand:',I5,I5)
1664  FORMAT('      Strand:',I5,I5)
1667  FORMAT(/' Topological summary: '/)
*
1653  FORMAT('+',I2,'.')
1655  FORMAT('-',I2,'.')
1663  FORMAT('+',I2,'x.')
1665  FORMAT('-',I2,'x.')
*
1701  FORMAT('  sheet joining is antiparallel.'/)
1702  FORMAT('  sheet joining is parallel.'/)
1703  FORMAT('  sheet joining is mixed parallel and antiparallel.'/)
1705  FORMAT('  sheet joining is unclassified.'/)
*
1710  FORMAT(5X,'    ring number:',I4,'. ring length:',I4,'.'/)
1711  FORMAT(10X,' Strand:',2I5) 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get 1 letter code given three letter code.
*
      SUBROUTINE RNMTCH(RLONG,R1)
*
* declarations.
*
      INTEGER I
      CHARACTER RLONG*3,R1*1
      CHARACTER*4 RLIST(20)
*
* initialise.
*
      DATA RLIST /
     +'ALAA',
     +'ARGR',
     +'ASNN',
     +'ASPD',
     +'CYSC',
     +'GLNQ',
     +'GLUE',
     +'GLYG',
     +'HISH',
     +'ILEI',
     +'LEUL',
     +'LYSK',
     +'METM',
     +'PHEF',
     +'PROP',
     +'SERS',
     +'THRT',
     +'TRPW',
     +'TYRY',
     +'VALV' /
*
* run through list.
*
      DO 1 I=1,20
      IF (RLONG(1:3).EQ.RLIST(I)(1:3)) GOTO 2
1     CONTINUE
      R1='X'
      RETURN
*
2     CONTINUE
*
      R1(1:1)=RLIST(I)(4:4)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get 1 letter code given three letter code.
*
      SUBROUTINE RESPNT(RLONG,IAA)
*
* declarations.
*
      INTEGER I,IAA
      CHARACTER RLONG*3
      CHARACTER*4 RLIST(20)
*
* initialise.
*
      DATA RLIST /
     +'ALAA',
     +'ARGR',
     +'ASNN',
     +'ASPD',
     +'CYSC',
     +'GLNQ',
     +'GLUE',
     +'GLYG',
     +'HISH',
     +'ILEI',
     +'LEUL',
     +'LYSK',
     +'METM',
     +'PHEF',
     +'PROP',
     +'SERS',
     +'THRT',
     +'TRPW',
     +'TYRY',
     +'VALV' /
*
* run through list.
*
      DO 1 I=1,20
      IF (RLONG(1:3).EQ.RLIST(I)(1:3)) GOTO 2
1     CONTINUE
      IAA=0
      RETURN
*
2     CONTINUE
*
      IAA=I
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get a letter corresponding to a number. cyclic.
*
      SUBROUTINE NUMLET(IN,A1)
*
* declarations.
*
      INTEGER II,IN
      CHARACTER LINE1*26,LINE2*26,A1*1
*
* initialise.
*
      LINE1='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
      LINE2='abcdefghijklmnopqrstuvwxyz'
*
* Do it.
*
      II=IN
1     CONTINUE
*
      IF (II.GT.52) THEN
      II=II-52
      GOTO 1
      ENDIF
*
      IF (II.GT.26) THEN
      II=II-26
      A1=LINE2(II:II)
      ELSE
      A1=LINE1(II:II)
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* write out beta bulges to bulge summary file
*
      SUBROUTINE WRBLG
*
* declarations.
*
      INTEGER E1,E2,E3,V1,IK1,IK2,I1,I3,J1,J2,J3
      CHARACTER S1*2
      CHARACTER LINE1*80,LINE2*80,BLINE*80,A1*1
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      BLINE='                                                             
     +                                                           '
*
* title file.
*
      IF (INBULG.GT.0) THEN
      WRITE(*,2000)
      WRITE(*,2001) BLGLEN,INBULG
      WRITE(43,2001) BLGLEN,INBULG
      ELSE
      RETURN
      ENDIF
*
* work through list of Bulges.
*
      DO 1 J=1,INBULG
*
* reinitialise.
*
      IK1=0
      IK2=0
      LINE1=BLINE
      LINE2=BLINE
*
* get pointers.
*
      E1=BLGLNK(1,1,J)
      E2=BLGLNK(2,1,J)
      E3=BLGLNK(3,1,J)
*
* error trap
*
      IF (E1.LT.1) GOTO 2
      IF (E2.LT.1) GOTO 2
      IF (E3.LT.1) GOTO 2
*
* write header.
*
      KV=BLGLNK(1,2,J)
      KW=BLGLNK(2,2,J)
*
      IF (KV.EQ.1) WRITE(43,1001) KW
      IF (KV.EQ.2) WRITE(43,1002) KW
      IF (KV.EQ.3) WRITE(43,1003) KW
      IF (KV.EQ.4) WRITE(43,1004) KW
*
* get pointers to involved residues.
*
      I1=INDEX(CCLIS,RLAB(E1))
      I3=INDEX(CCLIS,RLAB(E3))
      J1=RN(E1)
      J2=RN(E2)
      J3=RN(E3)
*
      IF (I1.GT.0.AND.I3.GT.0) THEN
*
* work through ranges. 
*
      DO 3 I=J2-2,J3+2
*
* get regions of ramachandran chart.
*
      S1=ASYMB(I,I3)
*
* get pointer.
*
      V1=POS(1,I,I3)
*
* write residues.
*
      WRITE(43,1000) 
     +RNAM(V1),RN(V1),RLAB(V1),STRSYM(I,I1),
     +S1,DANGL(1,I,I3),DANGL(2,I,I3)
*
* record sequence.
*
      IK1=IK1+1
      CALL RNMTCH(RNAM(V1),A1)
      LINE1(IK1:IK1)=A1
*
3     CONTINUE
*
      WRITE(43,*)
*
* work through ranges. 
*
      DO 4 I=J1-2,J1+2
*
* get pointer.
*
      V1=POS(1,I,I1)
*
* get regions of ramachandran chart.
*
      S1=ASYMB(I,I1)
*
* write residues.
*
      WRITE(43,1000) 
     +RNAM(V1),RN(V1),RLAB(V1),STRSYM(I,I1),
     +S1,DANGL(1,I,I1),DANGL(2,I,I1)
*
* record sequence.
*
      IK2=IK2+1
      CALL RNMTCH(RNAM(V1),A1)
      LINE2(IK2:IK2)=A1
*
4     CONTINUE
*
      ENDIF
*
2     CONTINUE
*
* write output sequence.
*
      WRITE(43,3010) LINE1(1:20),LINE2(1:20)
*
1     CONTINUE
*
* format statements.
*
1000  FORMAT(3X,A3,I4,A1,2X,A1,5X,A2,2(1X,F8.3))
*
1001  FORMAT(/' classic antiparallel bulge of length',I4,'.'/)
1002  FORMAT(/' wide type antiparallel bulge of length',I4,'.'/)
1003  FORMAT(/' classic parallel bulge of length',I4,'.'/)
1004  FORMAT(/' wide type parallel bulge of length',I4,'.'/)
*
2000  FORMAT(/2X,' Analysis of beta-bulges.')
2001  FORMAT(/2X,'  Maximum size of Bulge:',I6,'.'/,2X,
     +        ' Number of Bulges found:',I6,'.'/)
*
3000  FORMAT('  Bulge length:',I4/,
     +3X,A3,I4,A1,1X,A2,2(1X,F8.3)/,
     +3X,A3,I4,A1,1X,A2,2(1X,F8.3)/,
     +3X,A3,I4,A1,1X,A2,2(1X,F8.3))
3001  FORMAT('  Bulge length:',I4,'.'/)
3010  FORMAT('  Bulge:'/,10X,A20,' - ',A20)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* assign regions of PHI/PSI space.
*
      SUBROUTINE REGAS(TANG1,TANG2,SYMB)
*
* declarations.
*
      REAL TANG1,TANG2,T1,T2
      CHARACTER*2 SYMB
*
      INTEGER I1,I2,ITYP(8,8)
      CHARACTER SB(6)*2
*
* initialise.
*
      DATA SB / 
     + 'AR','AL','B ','GR','GL','E ' /
*
      DATA ITYP / 
     + 3, 3, 3, 3, 0, 0, 0, 0,
     + 3, 3, 3, 3, 2, 2, 0, 0,
     + 0, 3, 3, 0, 2, 2, 0, 0,
     + 0, 4, 4, 0, 2, 2, 5, 0,
     + 0, 1, 1, 1, 0, 5, 5, 0,
     + 0, 1, 1, 1, 0, 0, 0, 0,
     + 0, 0, 0, 0, 0, 6, 6, 0,
     + 3, 3, 3, 3, 0, 6, 6, 0 /
*
* lookup angles in 2d array:
* 
      T1=TANG1+180.0
      T2=TANG2+180.0
*
* get pointers
*
      I1=INT(T1/45.0)+1
      I2=INT(T2/45.0)+1
*
* use look up table.
*
      I3=ITYP(I1,9-I2)
*
* get symbol.
*
      SYMB='  '
      IF (I3.GT.0.AND.I3.LT.7) THEN
      SYMB=SB(I3)
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* convert structure definition line to pseudo NBRF.
*
      SUBROUTINE WRNBRF(IOUT,LINE)
*
* declarations.
*
      INTEGER IOUT,I
      CHARACTER LINE*80,FLINE*80
*
* work through line 
*
      DO 1 I=1,80
      FLINE(I:I)='-'
      IF (LINE(I:I).EQ.'A') FLINE(I:I)='A'
      IF (LINE(I:I).EQ.'P') FLINE(I:I)='P'
      IF (LINE(I:I).EQ.'4') FLINE(I:I)='H'
      IF (LINE(I:I).EQ.'3') FLINE(I:I)='G'
1     CONTINUE
*
* write line.
*
      WRITE(IOUT,1000) FLINE
*
* format statements.
*
1000  FORMAT(A80)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* calculate RCBs and paths of all rings.
*
      SUBROUTINE RINGS(INODE,IDEL,NCON,ICON,NLIST,ILIST)
*
* Declarations.
*
      INTEGER INODE,IBND,NVX,IDEL,NFRAG,IFK
      INTEGER CORD1(2000),CORD2(2000)
      INTEGER NCON(1000),ICON(100,1000),IEDGE(2,2000)
      INTEGER IMRK(1000),P(2000),IDN(2000),ITEMP(1000)
      INTEGER NLIST(100),ILIST(100,100),BCON(100,1000)
*
* initialise.
*
      IBND=0
      IDEL=0
      NVX=0
      NFRAG=0
*
      DO 700 I=1,2000
      P(I)=0
      IDN(I)=0
      IMRK(I)=0
      IEDGE(1,I)=0
      IEDGE(2,I)=0
      CORD1(I)=0
      CORD2(I)=0
700   CONTINUE
*
      DO 128 I=1,INODE
*
* copy connection list.
*
      DO 129 IT=1,NCON(I)
      ITEMP(IT)=ICON(IT,I)
129   CONTINUE
*
* sort partners.
*
      IFK=NCON(I)
      CALL ISORT(IFK,ITEMP,IDN)
*
* reinitialise.
*
      IMRK(I)=0
      P(I)=0
*
* restore sorted partner lists.
*
      DO 130 J=1,NCON(I)
      I1=IDN(J)
      BCON(J,I)=ITEMP(I1)
      ICON(J,I)=ITEMP(I1)
130   CONTINUE
*
128   CONTINUE
*
* work through all fragments.
*
100   CONTINUE
*
* initialise.
*
      IBND=0
*
* increment fragment counter.
*
      NFRAG=NFRAG+1
*
* get root of tree.
*
      INOW=0
      DO 2 I=1,INODE
      IF (IMRK(I).EQ.0) THEN
      INOW=I
      IMRK(INOW)=NFRAG
      GOTO 3
      ENDIF
2     CONTINUE
*
      IF (INOW.EQ.0) THEN
      ELSE
*
* create tree.
*
3     CONTINUE
*
* fill edge list.
*
      IF (P(INOW).EQ.0) THEN
      NVX=NVX+1
      P(INOW)=NVX
      ENDIF
*
* work through connections to this node.
*
      DO 4 I=1,NCON(INOW)
      IC=ICON(I,INOW)
      IF (IC.GT.0) THEN
      IBND=IBND+1
      IEDGE(1,IBND)=INOW
      IEDGE(2,IBND)=IC
      ICON(I,INOW)=0
      DO 41 J=1,NCON(IC)
      IF (ICON(J,IC).EQ.INOW) ICON(J,IC)=0
41    CONTINUE
      ENDIF
4     CONTINUE
*
* check if any bonds remain.
*
      IF (IBND.GT.0) THEN
*
* get pointers to remaining edges.
*
      I1=IEDGE(1,IBND)
      I2=IEDGE(2,IBND)
*
* find a loop closing bond.
*
      IF (IMRK(I1).EQ.NFRAG.AND.IMRK(I2).EQ.NFRAG) THEN
      IDEL=IDEL+1
      CORD1(IDEL)=I1
      CORD2(IDEL)=I2
      ELSE
*
* not a loop closing bond.
*
      INOW=I2
      IMRK(I2)=NFRAG
      ENDIF
*
      IBND=IBND-1
*
      GOTO 3
      ELSE
      ENDIF
*
      ENDIF
*
* all fragments found.
*
      IF (INOW.EQ.0) THEN
      ELSE
      GOTO 100
      ENDIF
*
* now find cycles in graph.
*
      DO 6 I=1,IDEL
*
* get first cord.
*
      IF (P(CORD1(I)).GT.P(CORD2(I))) THEN
      I1=CORD2(I)
      I2=CORD1(I)
      ELSE
      I2=CORD2(I)
      I1=CORD1(I)
      ENDIF
*
* reset pointers and counters.
*
      INOW=I2
      NLIST(I)=1
      ILIST(1,I)=INOW
*
      IT=NVX+1
      IK=0
*
* find partner with lowest position in tree.
*
      DO 71 II=1,NCON(INOW)
      IB=BCON(II,INOW)
      IF (P(IB).LT.IT.AND.IB.NE.I1.
     +AND.P(IB).NE.0.AND.P(IB).GE.P(I1)) THEN
      IT=P(IB)
      IK=IB
      ENDIF
71    CONTINUE
*
* check we have found one.
*
      IF (IK.GT.0) THEN 
*
      NLIST(I)=NLIST(I)+1
      ILIST(NLIST(I),I)=IK
      INOW=IK
*
8     CONTINUE
*
* update pointers and counters.
*
      IT=NVX+1
      IK=0
*
* work through all connections to find partner.
*
      DO 7 II=1,NCON(INOW)
      IB=BCON(II,INOW)
*
* check if we have found other partner of cord.
*
      IF (IB.EQ.I1) THEN
      NLIST(I)=NLIST(I)+1
      ILIST(NLIST(I),I)=I1
      GOTO 6
      ENDIF
*
* search for lowest scoring partner.
*
      IF (P(IB).LT.IT .AND.
     +    P(IB).NE.0  .AND.
     +    P(IB).GE.P(I1)) THEN
*
      IT=P(IB)
      IK=IB
*
      ENDIF
*
7     CONTINUE
*
* update list of ring members.
*
      NLIST(I)=NLIST(I)+1
      ILIST(NLIST(I),I)=IK
      INOW=IK
*
* check if we have found other partner of cord.
*
      IF (IK.EQ.I1.OR.NLIST(I).GT.INODE) THEN
      ELSE
      GOTO 8
      ENDIF
*
      ENDIF
*
6     CONTINUE
*
* loop back for next fragment.
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* cluster sheets.
*
      SUBROUTINE CLUSHT2(NTOL,NSTRND,LINKS,LINKA)
*
* declarations.
*
      INTEGER I,J,K,J1,J2
      INTEGER NTOL,NSTRND,LINKS(100,100),LINKA(100,100)
*
      INTEGER LINK1(100,100),LINK2(100,100)
*
* Check enough connections. if enough make a 1-2 link.
*
      DO 1 I=1,NSTRND
      DO 1 J=1,NSTRND
      IF (LINKS(J,I).GE.NTOL) THEN
      LINK1(J,I)=1
      ELSE
      LINK1(J,I)=0
      ENDIF
1     CONTINUE
*
      DO 11 I=1,NSTRND
      LINK1(I,I)=0
11    CONTINUE
*
* get 1-n links from 1-(n-1) links.
*
      DO 2 K=1,NSTRND
      DO 2 I=1,NSTRND
      DO 2 J1=1,NSTRND
      DO 2 J2=1,NSTRND     
*
* error trap self-self comparison.
*
      IF (J1.EQ.J2) GOTO 2
*
* is there a conection ?
*
      IF (LINK1(I,J1).EQ.1.AND.LINK1(J2,I).EQ.K) THEN
*
* has it been found before.
*
      IF (LINK1(J2,J1).EQ.0) THEN
      LINK1(J2,J1)=K+1
      IF (LINKA(I,J1).EQ.LINKA(J2,I)) THEN
      LINKA(J2,J1)=0
      LINKA(J1,J2)=0
      ELSE
      LINKA(J2,J1)=1
      LINKA(J1,J2)=1
      ENDIF
      ENDIF
*
      ENDIF
*
* is there a conection ?
*
      IF (LINK1(J2,I).EQ.1.AND.LINK1(I,J1).EQ.K) THEN
*
* has it been found before.
*
      IF (LINK1(J2,J1).EQ.0) THEN
      LINK1(J2,J1)=K+1
      IF (LINKA(J2,I).EQ.LINKA(I,J1)) THEN
      LINKA(J2,J1)=0
      LINKA(J1,J2)=0
      ELSE
      LINKA(J2,J1)=1
      LINKA(J1,J2)=1
      ENDIF
      ENDIF
*
      ENDIF
*
2     CONTINUE
*
* copy sheetmatrix back.
*
      DO 4 I=1,NSTRND
      DO 4 J=1,NSTRND
      LINKS(J,I)=LINK1(J,I)     
4     CONTINUE
*
      RETURN 
      END
*
*-------------------------------------------------------------------------------
*
* Display turns.
*
      SUBROUTINE TURNS
*
* Declarations.
*
      INTEGER I1,I2,E1,NT(2),INT1(1000,2),INT2(1000,2)
      CHARACTER A9*9,A12*12,SMB2*2
*
      INCLUDE 'FOLD.INC'
*
* work through all chains. 
*
      DO 1 I=1,CHL
*
* work through all residues. 
*
      DO 2 J=RN1(I),RN2(I)
*
* Error trap.
*
      IK=ITURN(J,I)
*
      IF (IK.EQ.0) THEN
      ELSE
*
* get H-bond turn type.
*
      IF (IK.GT.4999) IK=IK-5000
      IF (IK.GT.399)  IK=IK-400
      IK1=IK
      IF (IK.GT.29)   IK=IK-30
*
      IF (IK.EQ.2.OR.IK1.GT.2) THEN
*
* check not all part of a proper helix.
*
      DO 3 K1=0,3
*
* Error trap.
*
      IF (STRSYM(J-K1,I).EQ.'4') THEN
      ELSEIF (STRSYM(J-K1,I).EQ.'3') THEN
      ELSE
      IF (IK1.GT.2) THEN
*
* B-turns.
*
      NT(2)=NT(2)+1
      INT1(NT(2),2)=J
      INT2(NT(2),2)=I
      ELSE
*
* gamma-turns
*
      NT(1)=NT(1)+1
      INT1(NT(1),1)=J
      INT2(NT(1),1)=I
      ENDIF
      GOTO 2
      ENDIF
*
3     CONTINUE
*
      ENDIF
      ENDIF
*
2     CONTINUE
*
1     CONTINUE
*
*100   CONTINUE
*
* now write results to file.
*
      IF (NT(1).GT.0) THEN
*
* write header.
*
      WRITE(70,1000)
*
* work through all turns.
*
      DO 41 I=1,NT(1)
*
* get pointers.
*
      I1=INT1(I,1)
      I2=INT2(I,1)
      E1=POS(4,I1,I2)
      I1=I1-2
      E2=POS(4,I1,I2)
*
* Error trap.
*
      IF (E1.GT.0.AND.E2.GT.0) THEN
*
* get main chain conformations.
*
      SMB2=ASYMB(I1,I2)
      A9(1:3)=SMB2//' '
      SMB2=ASYMB(I1+1,I2)
      A9(4:6)=SMB2//' '
      SMB2=ASYMB(I1+2,I2)
      A9(7:9)=SMB2//' '
*
* write this turn.
*
      WRITE(70,1001) 
     +RNAM(E2),RN(E2),RLAB(E2),
     +RNAM(E1),RN(E1),RLAB(E1),
     +A9//'   '
*
      ENDIF
41    CONTINUE
      WRITE(70,1003) NT(1)
      ENDIF
*
* beta turns.
*
      IF (NT(2).GT.0) THEN
*
* write header.
*
      WRITE(70,1002)
*
* work through turns.
*
      DO 42 I=1,NT(2)
*
* get pointers.
*
      I1=INT1(I,2)
      I2=INT2(I,2)
      E1=POS(4,I1,I2)
      I1=I1-3
      E2=POS(4,I1,I2)
*
* error trap.
*
      IF (E1.GT.0.AND.E2.GT.0) THEN
*
* get main chain conformations.
*
      SMB2=ASYMB(I1,I2)
      A12(1:3)=SMB2//' '
      SMB2=ASYMB(I1+1,I2)
      A12(4:6)=SMB2//' '
      SMB2=ASYMB(I1+2,I2)
      A12(7:9)=SMB2//' '
      SMB2=ASYMB(I1+3,I2)
      A12(10:12)=SMB2//' '
*
* write turn to file.
*
      WRITE(70,1001) 
     +RNAM(E2),RN(E2),RLAB(E2),
     +RNAM(E1),RN(E1),RLAB(E1),A12
*
      ENDIF
42    CONTINUE
*
* write total number found.
*
      WRITE(70,1003) NT(2)
      ENDIF
*
* Close empty file.
*
      IF (NT(1).LT.1.AND.NT(2).LT.1) THEN
      CLOSE(UNIT=70,DISPOSE='DELETE')
      ENDIF
*
* format statements.
*
1000  FORMAT(/'  Gamma turns:'/)
1001  FORMAT(3X,A3,I4,A1,' - ',A3,I4,A1,' -',3X,A12)
1002  FORMAT(/'  Beta turns:'/)
1003  FORMAT(/' Total number of turns:',I6)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Create DRF nomenclature of sheet joining.
*
      SUBROUTINE SHTSMI(IOUT,ISHEET,ICHL)
*
* Declarations.
*
      INTEGER ISHEET,ICHL
*
* initialise.
*
      CALL INITSM(ISHEET,ICHL)
*
* write toplogy.
*
      CALL WRSMIL(IOUT,ISHEET,ICHL)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* initialise smiles strings.
*
      SUBROUTINE INITSM(ISHEET,ICHL)
*
* declarations.
*
      INTEGER I,J,ISHEET,ICHL,I1,I2,RNGNUM
      CHARACTER A1*1
*
      INCLUDE 'FOLD.INC'
*
* work through strings.
*
      DO 1 I=1,SHTLEN(ISHEET,ICHL)
*
* default string.
*
      IF (SHNCON(I,ISHEET,ICHL).GT.0) THEN
*
      DO 11 J=1,50
      TOPLINE(I)(J:J)=' '
11    CONTINUE
*
* get letter of strand connection.
*
      IF (REDDEC.EQ.1) THEN
      CALL NUMLET(I,A1)
      ELSE
      IFK=SHEETS(I,ISHEET,ICHL)
      CALL NUMLET(IFK,A1)
      ENDIF
*
      TOPLINE(I)(1:1)=A1
*
      ENDIF
*
1     CONTINUE
*
* reinitialise.
*
      RNGNUM=0
      IRING=SHTRNG(ISHEET,ICHL)
*
* found all rings. now modify connectivity information.
*
      DO 30 I=1,IRING
*
* increase ring counter
*
      RNGNUM=RNGNUM+1
* 
* get pointers.
*
      I1=RNGLST(1,I,ISHEET,ICHL)
      I2=RNGLST(RNGLEN(I,ISHEET,ICHL),I,ISHEET,ICHL)
*
* modify connections.
*
      DO 31 J=1,SHNCON(I1,ISHEET,ICHL)
      IF (SHICON(J,I1,ISHEET,ICHL).EQ.I2) THEN
      SHICON(J,I1,ISHEET,ICHL)=-ABS(SHICON(J,I1,ISHEET,ICHL))
      ENDIF
31    CONTINUE
*
      DO 32 J=1,SHNCON(I2,ISHEET,ICHL)
      IF (SHICON(J,I2,ISHEET,ICHL).EQ.I1) THEN
      SHICON(J,I2,ISHEET,ICHL)=-ABS(SHICON(J,I2,ISHEET,ICHL))
      ENDIF
32    CONTINUE
*
* write orientation
*
      A1=' '
      IF (ORISHT(I1,I2,ICHL).EQ.0) A1='x'
*
* write broken bonds to smiles file.
*
      IF (RNGNUM.LT.10) THEN
*
* less than 10 ring closures.
*
      WRITE(TOPLINE(I1)(42:46),1000) A1,RNGNUM
      CALL PACK(TOPLINE(I1))
*
      WRITE(TOPLINE(I2)(42:46),1000) A1,RNGNUM
      CALL PACK(TOPLINE(I2))
*
      ELSE
*
* more than 10 ring closures.
*
      WRITE(TOPLINE(I1)(42:49),1010) A1,RNGNUM
      CALL PACK(TOPLINE(I1))
*
      WRITE(TOPLINE(I2)(42:49),1010) A1,RNGNUM
      CALL PACK(TOPLINE(I2))
      ENDIF
*
30    CONTINUE
*
* formats statements.
*
1000  FORMAT(A1,I4)
1010  FORMAT(A1,'%',I6)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* find longest path through an acyclic graph which has at least one branching 
* point.
*
      SUBROUTINE WRSMIL(IOUT,ISHEET,ICHL)
*
* Declarations.
*
      INTEGER NLIST,IFAIL,IOUT,SCON(1000),PBIG,
     +P(1000),ILIST(1000),NLAST,ILAST(1000),IMRK(1000),NCON(1000),
     +ICON(100,1000),ISHEET,ICHL,ITOP
*
      CHARACTER FLINE*2000,A1*1,FLINE2*500
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      ITOP=1
      FLINE2='                                                        
     +                                                             
     +                                                             
     +                                                             '
      FLINE='                                                        
     +                                                             
     +                                                             
     +                                                             '
*
      CALL NUMLET(ISHEET,A1)
      FLINE2(1:10)=
     +MOLNAME(1:4)//' '//CCLIS(ICHL:ICHL)//'_'//A1//': '
      ITOP=11
*
      IFAIL=0
      NLAST=0
      DO 6 I=1,SHTLEN(ISHEET,ICHL)
      NCON(I)=SHNCON(I,ISHEET,ICHL)
      IF (SHNCON(I,ISHEET,ICHL).GT.0) THEN
      ILAST(I)=0
      IMRK(I)=0
      SCON(I)=0
      DO 61 J=1,NCON(I)
      ICON(J,I)=SHICON(J,I,ISHEET,ICHL)
      IF (ICON(J,I).GT.0) SCON(I)=SCON(I)+1
61    CONTINUE
      ENDIF
6     CONTINUE
*
* get spanning tree.
*
      IFK=SHTLEN(ISHEET,ICHL)
      CALL SPTREE(
     +IFK,NLIST,PBIG,ILIST,P,SCON,NCON,ICON)
*
* mark atoms of main chain.
*
      DO 770 I=1,NLIST
      IF (ILIST(I).LT.1) ILIST(I)=0
      P(ILIST(I))=-1
770   CONTINUE
*
* copy sheet identification to smiles.
*
      CALL NUMLET(ISHEET,A1)
      FLINE(1:10)=
     +MOLNAME(1:4)//' '//CCLIS(ICHL:ICHL)//'_'//A1//': '
      IL=10
*
* now write smiles.
*
      WRITE(IOUT,1668)
      CALL TOPOUT(IOUT,IL,ILIST(1),0,ISHEET,ICHL,FLINE,ITOP,FLINE2)
*
* work through main chain.
*
      DO 107 I=2,NLIST
*
      K1=ILIST(I)
*
      IF (K1.GT.0) THEN
*
      K2=ILIST(I-1)
      K3=ILIST(I+1)
*
* write smiles for this main chain atom.
*
      CALL TOPOUT(IOUT,IL,K1,K2,ISHEET,ICHL,FLINE,ITOP,FLINE2)
*
* is it branched.
*
      IF (SCON(K1).GT.2) THEN
*
400   CONTINUE
*
      NLAST=0
*
* find pointers to branches. longest first.
*
      P1=0
      ID=0
      DO 20 J=1,NCON(K1)
      I1=ICON(J,K1)
      IF (I1.GT.0) THEN
      IF (I1.EQ.K2.OR.I1.EQ.K3) THEN
      ELSE
      IF (P(I1).GT.P1) THEN
      P1=P(I1)
      ID=I1
      ENDIF
      ENDIF
      ENDIF
20    CONTINUE
*
* check we have found all branches.
*
      IF (ID.EQ.0) THEN
      ELSE
*
      IT=ID
      IPART=K1
*
      P(IT)=-1
*
* write bracket.
*
      IL=IL+1
      FLINE(IL:IL)='('
*
600   CONTINUE
*
* error trap.
*
      IT=ABS(IT)
      IF (IT.LT.1) THEN
      GOTO 400
      ENDIF
*
* reach a terminal node.
*
      IF (SCON(IT).EQ.1) THEN
*
* write this atom.
*
      CALL TOPOUT(IOUT,IL,IT,IPART,ISHEET,ICHL,FLINE,ITOP,FLINE2)
*
* write closing bracket.
* 
      IL=IL+1
      FLINE(IL:IL)=')'
*
* go back to last branching point.
*
      IF (NLAST.LT.1) THEN
      GOTO 400
      ELSE
      IT=ILAST(NLAST)
      GOTO 600
      ENDIF
*
* move up linear branch.
*
      ELSEIF (SCON(IT).EQ.2) THEN
*
* write this atom.
*
      CALL TOPOUT(IOUT,IL,IT,IPART,ISHEET,ICHL,FLINE,ITOP,FLINE2)
*
* get pointer to next atom.
*
      P1=PBIG+1
      ID=0
      IJ=0
*
* find shortest connection of this branch.
*
      DO 347 J=1,NCON(IT)
      I1=ICON(J,IT)
      IF (I1.GT.0) THEN
      IF (P(I1).GT.0) THEN
      IJ=IJ+1
      IF (P(I1).LT.P1) THEN
      P1=P(I1)
      ID=I1
      ENDIF
      ENDIF
      ENDIF
347   CONTINUE
*
      IPART=IT
      IT=ID
      P(IT)=-1
*
* error trap.
*
      IF (ID.LT.1) THEN
      IF (NLAST.LT.1) THEN
      GOTO 400
      ELSE
      IT=ILAST(NLAST)
      GOTO 600
      ENDIF
      ENDIF
*
* go to next atom.
*
      GOTO 600
*
* branching point.
*
      ELSEIF (SCON(IT).GT.2) THEN
*
      P1=PBIG+1
      ID=0
      IJ=0
*
* find shortest connection of this branch.
*
      DO 307 J=1,NCON(IT)
      I1=ICON(J,IT)
      IF (I1.GT.0) THEN
      IF (P(I1).GT.0) THEN
      IJ=IJ+1
      IF (P(I1).LT.P1) THEN
      P1=P(I1)
      ID=I1
      ENDIF
      ENDIF
      ENDIF
307   CONTINUE
*
* have all connections been used.
*
      IF (ID.EQ.0.OR.IJ.EQ.0) THEN
*
* end of this main chain branch.
*
      IF (NLAST.LT.2) GOTO 400
*
* go back to last branching point.
*
      NLAST=NLAST-1
      IT=ILAST(NLAST)
      GOTO 600
      ENDIF
*
* write this atom.
*
      IF (IMRK(IT).EQ.0) THEN
      CALL TOPOUT(IOUT,IL,IT,IPART,ISHEET,ICHL,FLINE,ITOP,FLINE2)
      ENDIF
*
* write bracket for branches.
*
      IF (IJ.GT.1) THEN
      IL=IL+1
      FLINE(IL:IL)='('
      ENDIF
*
* save this atom. branch.
*
      NLAST=NLAST+1
      ILAST(NLAST)=IT
      IMRK(IT)=1
      IPART=IT
      IT=ID
*
      P(IT)=-1
*
      GOTO 600
*
* reached a terminal atom.
*
      ELSE
      IF (NLAST.LT.1) THEN
      GOTO 400
      ELSE
      IT=ILAST(NLAST)
      GOTO 600
      ENDIF
      ENDIF
*
      ENDIF
      ENDIF
      ENDIF
*
107   CONTINUE
*
* write overhanging line.
*
      CALL PACK1(IL,FLINE)
      CALL PACK1(ITOP,FLINE2)
*
      WRITE(12,1667) 
      CALL WRLINE(12,ABS(ITOP)-1,
     +FLINE2(1:ABS(ITOP-2))//'.')
      CALL WRLINE(IOUT,IL,FLINE)
*
* format statements.
*
1000  FORMAT(' Topology string too long. Not written.')
1667  FORMAT(/' Topological summary: '/)
1668  FORMAT(/' Topology based on Joining: '/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Write out topology file.
*
      SUBROUTINE TOPOUT(IOUT,IL,K1,K2,ISHEET,ICHL,FLINE,ITOP,FLINE2)
*
* Declarations.
*
      INTEGER IL,IOUT,ISHEET,ICHL,K1,K2,E1,ITOP
      CHARACTER FLINE*2000,FLINE2*500
      CHARACTER TOPSMB*5
*
      INCLUDE 'FOLD.INC'
*
* error trap.
*
      IF (K1.LT.1) RETURN
*
* Get pointer.
*
      E1=SHEETS(K1,ISHEET,ICHL)
      E2=SHEETS(K2,ISHEET,ICHL)
*
* get sequence distance.
*
      IF (REDDEC.EQ.1) THEN
      ID=ABS(K1-K2)
      ELSE
      ID=ABS(E1-E2)
      ENDIF
*
* write sheet topology.
*
      IORI=1
      IF (E1.GT.0.AND.E2.GT.0) THEN
      IF (ORISHT(E1,E2,ICHL).EQ.0) IORI=0
      ENDIF
*
* write orientation to topology string.
*
      IF (IORI.EQ.0) THEN
      IL=IL+1
      FLINE(IL:IL)='x'
      ENDIF
*
* work through this string.
*
      DO 2 IK=1,50
*
* trap white space.
*
      IF (TOPLINE(K1)(IK:IK).NE.' ') THEN
*
* copy to output file.
*
      IL=IL+1
      FLINE(IL:IL)=TOPLINE(K1)(IK:IK)
*
* write string.
*
      IF (IL.EQ.2000) THEN
      WRITE(IOUT,1000) FLINE
      IL=0
      ENDIF
      ENDIF
*
2     CONTINUE
*
* Now write strands in connectedness order.
*
      IF (K2.EQ.0) THEN
      WRITE(IOUT,1654) STRAND1(E1,ICHL),STRAND2(E1,ICHL)
      ELSE
*
      IF (K1.GT.K2) THEN
*
* positive
*
      IF (IORI.EQ.1) THEN
*
* antiparallel.
*
      WRITE(TOPSMB(1:4),1653) ID
      WRITE(IOUT,1652) STRAND1(E1,ICHL),STRAND2(E1,ICHL),TOPSMB(1:4)
      FLINE2(ITOP:ITOP+3)=TOPSMB(1:3)//','
      ITOP=ITOP+4
      ELSE
*
* parallel.
*
      WRITE(TOPSMB(1:5),1663) ID
      WRITE(IOUT,1662) STRAND1(E1,ICHL),STRAND2(E1,ICHL),TOPSMB(1:5)
      FLINE2(ITOP:ITOP+4)=TOPSMB(1:4)//','
      ITOP=ITOP+5
      ENDIF
*
      ELSEIF (K2.GT.K1) THEN
*
* negative.
*
      IF (IORI.EQ.1) THEN
*
* antiparallel.
*
      WRITE(TOPSMB(1:4),1655) ID
      WRITE(IOUT,1652) STRAND1(E1,ICHL),STRAND2(E1,ICHL),TOPSMB(1:4)
      FLINE2(ITOP:ITOP+4)=TOPSMB(1:3)//','
      ITOP=ITOP+4
      ELSE
*
* parallel.
*
      WRITE(TOPSMB(1:5),1665) ID
      WRITE(IOUT,1662) STRAND1(E1,ICHL),STRAND2(E1,ICHL),TOPSMB(1:5)
      FLINE2(ITOP:ITOP+4)=TOPSMB(1:4)//','
      ITOP=ITOP+5
      ENDIF
      ENDIF
*
      ENDIF
*
* Format statements.
*
1000  FORMAT(/' Summary of topology: '/,
     +A2000)
*
1652  FORMAT('      Strand:',I5,I5,3X,A4)
1662  FORMAT('      Strand:',I5,I5,3X,A5)
1654  FORMAT('      Strand:',I5,I5)
1664  FORMAT('      Strand:',I5,I5)
*
1667  FORMAT(/' Topological summary: '/,A)
*
1653  FORMAT('+',I2,'.')
1655  FORMAT('-',I2,'.')
1663  FORMAT('+',I2,'x.')
1665  FORMAT('-',I2,'x.')
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* find longest path through an acyclic graph which has at least one branching 
* point.
*
      SUBROUTINE SPTREE(INODE,NLIST,PBIG,ILIST,P,SCON,NCON,ICON)
*
* Declarations.
*
      INTEGER N1,LCON(1000),NLIST,ITEMP(1000),
     +P(1000),LCON1(1000),ILIST(1000),SCON(1000),ICOUNT,PBIG,
     +ICON(100,1000),NCON(1000),INODE
*
      INCLUDE 'FOLD.INC'
*
* Initialise.
*
      NLIST=0
      DO 6 I=1,INODE
      P(I)=1
      LCON(I)=SCON(I)
      LCON1(I)=SCON(I)
      ILIST(I)=0
6     CONTINUE
*
* top of loop.
*
100   CONTINUE
*
* reinitialise.
*
      N1=0
*
* work through and find all singly connected atoms.
*
      DO 2 I=1,INODE
*
      IF (LCON(I).EQ.1) THEN
*
      LCON(I)=0
*
      ICOUNT=P(I)
*
      I1=I
*
200   CONTINUE
*
      N1=N1+1
      P(I1)=ICOUNT
      LCON(I1)=0
*
      DO 3 J=1,NCON(I1)
      I2=ICON(J,I1)
      IF (I2.GT.0) THEN
      IF (LCON(I2).EQ.2) THEN
      ICOUNT=ICOUNT+1
      IF (P(I2).GT.ICOUNT) ICOUNT=P(I2)
      I1=I2      
      GOTO 200
      ELSEIF (LCON(I2).GT.2) THEN
      LCON1(I2)=LCON1(I2)-1
      P(I2)=MAX(P(I2),ICOUNT+1)
      GOTO 2
      ENDIF
      ENDIF
3     CONTINUE
*      
      ENDIF
2     CONTINUE
*
      IF (N1.GT.0) THEN
      DO 50 I=1,INODE
      IF (LCON(I).GT.0) THEN
      LCON(I)=MAX(0,LCON1(I))
      ELSE
      LCON1(I)=0
      ENDIF
50    CONTINUE
      GOTO 100
      ENDIF
*
* get node furthest from outside of graph.
*
      PBIG=0
      IBIG=0
      DO 10 I=1,INODE
      IF (P(I).GT.PBIG) THEN
      IBIG=I
      PBIG=P(I)
      ENDIF
10    CONTINUE
*
      IDEC=1
      NLIST=0
      P(IBIG)=-1
*
* now find longest path.
*
300   CONTINUE
*
      IT=0
      P1=0
      DO 11 I=1,NCON(IBIG)
      IJ=ICON(I,IBIG)
      IF (IJ.GT.0) THEN
      IF (P(IJ).GT.P1) THEN
      IT=IJ
      P1=P(IJ)
      ENDIF
      ENDIF
11    CONTINUE
*
      P(IT)=-1
      NLIST=NLIST+1
      ILIST(NLIST)=IT
*
301   CONTINUE      
*
      IF (IT.GT.0) THEN
*
      I1=0
      P1=0
      DO 12 I=1,NCON(IT)
      IJ=ICON(I,IT)
      IF (IJ.GT.0) THEN
      IF (P(IJ).GT.P1) THEN
      I1=IJ
      P1=P(IJ)
      ENDIF
      ENDIF
12    CONTINUE
*
      IF (I1.EQ.0.OR.P1.EQ.0) THEN
      ELSE
*
      IT=I1
      P(IT)=-1
      NLIST=NLIST+1
      ILIST(NLIST)=IT
*
      IF (P1.GT.1) GOTO 301
*
      ENDIF
      ENDIF
*
* invert first list.
*
      IF (IDEC.EQ.1) THEN
*
      DO 15 I=1,NLIST
      ITEMP(I)=ILIST(I)
15    CONTINUE
*
      IU=0
      DO 16 I=NLIST,1,-1
      IU=IU+1
      ILIST(IU)=ITEMP(I)
16    CONTINUE
*
      NLIST=NLIST+1
      ILIST(NLIST)=IBIG
*
      IMIDP=NLIST
*
      IDEC=0
*
* return for second half of list.
*
      GOTO 300
      ENDIF
*
* invert list, if needed, so smallest terminii first.
*
      IF (ILIST(1).GT.ILIST(NLIST)) THEN
*
      DO 148 I=1,NLIST
      ITEMP(I)=ILIST(I)
148   CONTINUE
*
      IU=0
      DO 149 I=NLIST,1,-1
      IU=IU+1
      ILIST(IU)=ITEMP(I)
149   CONTINUE
*
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* write a string without trailing spaces.
*
      SUBROUTINE WRLINE(IOUT,ILEN,LINE)
*
* Declarations.
*
      INTEGER ILEN,IOUT
*
      CHARACTER LINE*(*)
      CHARACTER CC*9
*
* error trap.
*
      IF (ILEN.GT.0.AND.ILEN.LT.1000000) THEN
*
* write line of known length.
*
      IF (ILEN.GT.99999) THEN
      WRITE(CC,105) '(A',ILEN,')'
      ELSE
      IF (ILEN.GT.9999) THEN
      WRITE(CC,104) '(A',ILEN,') '
      ELSE
      IF (ILEN.GT.999) THEN
      WRITE(CC,103) '(A',ILEN,')  '
      ELSE
      IF (ILEN.GT.99) THEN
      WRITE(CC,102) '(A',ILEN,')   '
      ELSE
*
      IF (ILEN.GT.9) THEN
      WRITE(CC,101) '(A',ILEN,')    '
      ELSE
      WRITE(CC,100) '(A',ILEN,')     '
      ENDIF
*
      ENDIF
      ENDIF
      ENDIF
      ENDIF
*
* write line to output file.
*
      WRITE(IOUT,CC) LINE(1:ILEN)
*
      ENDIF
*
* format statements.
*
100   FORMAT(A2,I1,A6)
101   FORMAT(A2,I2,A5)
102   FORMAT(A2,I3,A4)
103   FORMAT(A2,I4,A3)
104   FORMAT(A2,I5,A2)
105   FORMAT(A2,I6,A1)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* pack a string.
*
      SUBROUTINE PACK(AA)
*
* Declarations.
*
      CHARACTER AA*50,VV*50
*
      INTEGER I,J
*
* work through string.
*
      J=0
      DO 1 I=1,50
      VV(I:I)=' '
      IF  (AA(I:I).NE.' ') THEN
      J=J+1
      VV(J:J)=AA(I:I)
      ENDIF
1     CONTINUE
*
* copy back packed string.
*
      AA=VV
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* delete duplicates from the bond connection table.
*
      SUBROUTINE BNDDUP(INODE,NCON,ICON)
*
* Declarations.
*
      INTEGER INODE,NCON(1000),ICON(100,1000)
*
* work through all atoms.
*
      DO 1 I=1,INODE
*
      DO 2 J=1,NCON(I)
      I1=ICON(J,I)
      IF (I1.GT.0) THEN
      DO 3 K=(J+1),NCON(I)
      I2=ICON(K,I)
      IF (I1.EQ.I2) ICON(K,I)=0
3     CONTINUE
      ENDIF
2     CONTINUE
*
* compress bond list.
*
      CALL COMPRESS(I,NCON,ICON)
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* compress connectivity list.
*
      SUBROUTINE COMPRESS(IP,NCON,ICON)
*
* Declarations.
*
      INTEGER NEWCON(1000),IP,J,II,NCON(1000),ICON(100,1000)
*
* Error trap.
*
      IF (IP.LT.1) THEN
      ELSE
*
* initialise
*
      II=0
*
* Process next atom.
*
      DO 5 J=1,NCON(IP)
*
      NEWCON(J)=0
*
      IF (ICON(J,IP).EQ.0) THEN
      ELSE
      II=II+1
      NEWCON(II)=ABS(ICON(J,IP))
      ENDIF
*
5     CONTINUE
*
* write new lists. 
*
      NCON(IP)=II
*
      DO 6 J=1,8
      ICON(J,IP)=NEWCON(J)
6     CONTINUE
*
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get Richardson's Topology of sheet joining.
*
      SUBROUTINE RICHARD(ISHEET,ICHL)
*
* Declarations.
*
      INTEGER ISHEET,ICHL
      INTEGER IRICH,INOW,IDOI,IDOJ,IDIJ
      INTEGER J2,J3,JJ
*
      INCLUDE 'FOLD.INC'
*
* Assign Richardson topology.
*
      INOW=0
*
* work through strands of this sheet.
*
      DO 1 J=1,SHTLEN(ISHEET,ICHL)
*
* get topology of strand connections.
* 
      IF (J.LT.3) THEN
*
      J2=SHEETS(J-1,ISHEET,ICHL)
      J3=SHEETS(J,ISHEET,ICHL)
      SHTTOP(J,ISHEET,ICHL)=LNKSHT(J3,J2,ICHL)
      SHTORI(J,ISHEET,ICHL)=ORISHT(J3,J2,ICHL)
*
      ELSE
*
* get pointers.
*
      JJ=SHEETS(J,ISHEET,ICHL)
      J2=SHEETS(J-1,ISHEET,ICHL)
      J3=SHEETS(J-2,ISHEET,ICHL)
*
* get distances.
*
      IDIJ=LNKSHT(J2,JJ,ICHL)
      IDOJ=LNKSHT(J3,JJ,ICHL)
      IDOI=LNKSHT(J3,J2,ICHL)
*
* logic to get distance and direction.
*
      CALL RICHTOP(INOW,IDOI,IDOJ,IDIJ,IRICH)
*
* record it.
*
      SHTTOP(J,ISHEET,ICHL)=IDIJ*IRICH
      SHTORI(J,ISHEET,ICHL)=ORISHT(J2,JJ,ICHL)
*
      ENDIF
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get Richardson topology of an open sheet.
*
      SUBROUTINE RICHTOP(INOW,DOI,DOJ,DIJ,IRICH)
*
* Declarations.
*
      INTEGER INOW,DOI,DOJ,DIJ,IRICH
*
* Is it plus or minus.
*
      IF (INOW.GT.0) THEN
*
       IF (DOJ.EQ.(DOI+DIJ)) THEN
        INOW=1
        IRICH=-1
        RETURN
       ELSE
        IF (DOI.EQ.(DOJ+DIJ)) THEN
         INOW=1
         IRICH=1
         RETURN
        ELSE IF (DIJ.EQ.(DOI+DOJ)) THEN
         INOW=-1
         IRICH=1
         RETURN
        ENDIF
       ENDIF
*
      ELSE IF (INOW.LT.1) THEN
*
       IF (DOJ.EQ.(DOI+DIJ)) THEN
        INOW=-1
        IRICH=1
        RETURN
       ELSE
        IF (DOI.EQ.(DOJ+DIJ)) THEN
         INOW=-1
         IRICH=-1
         RETURN
        ELSE IF (DIJ.EQ.(DOI+DOJ)) THEN
         INOW=1
         IRICH=-1
         RETURN
        ENDIF
       ENDIF
*
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* display topology of strands.
*
      SUBROUTINE TOPDIS(IORIENT,ITOPOL,ITOP,E1,ISHEET,TSLINE)
*
* Declarations.
*
      INTEGER IORIENT,ITOPOL,ITOP,E1,ISHEET
      CHARACTER TOPSMB*5,TSLINE*80
      INCLUDE 'FOLD.INC'
*
      IF (IORIENT.EQ.1) THEN
*
* Antiparallel.
*
      IF (ITOPOL.GT.0) THEN
      WRITE(TOPSMB(1:4),1653) ABS(ITOPOL)
      TSLINE(ITOP:ITOP+3)=TOPSMB(1:3)//','
      ITOP=ITOP+4
      WRITE(12,1652) 
     +STRAND1(E1,ISHEET),STRAND2(E1,ISHEET),TOPSMB(1:4)
      ELSEIF (ITOPOL.EQ.0) THEN
      WRITE(12,1654) STRAND1(E1,ISHEET),STRAND2(E1,ISHEET)
      ELSEIF (ITOPOL.LT.0) THEN
      WRITE(TOPSMB(1:4),1655) ABS(ITOPOL)
      TSLINE(ITOP:ITOP+3)=TOPSMB(1:3)//','
      ITOP=ITOP+4
      WRITE(12,1652) 
     +STRAND1(E1,ISHEET),STRAND2(E1,ISHEET),TOPSMB(1:4)
      ENDIF
*
      ELSE
*
* parallel.
*
      IF (ITOPOL.GT.0) THEN
      WRITE(TOPSMB,1663) ABS(ITOPOL)
      TSLINE(ITOP:ITOP+4)=TOPSMB(1:4)//','
      ITOP=ITOP+5
      WRITE(12,1662) 
     +STRAND1(E1,ISHEET),STRAND2(E1,ISHEET),TOPSMB
      ELSEIF (ITOPOL.EQ.0) THEN
      WRITE(12,1664) STRAND1(E1,ISHEET),STRAND2(E1,ISHEET)
      ELSEIF (ITOPOL.LT.0) THEN
      WRITE(TOPSMB,1665) ABS(ITOPOL)
      TSLINE(ITOP:ITOP+4)=TOPSMB(1:4)//','
      ITOP=ITOP+5
      WRITE(12,1662) 
     +STRAND1(E1,ISHEET),STRAND2(E1,ISHEET),TOPSMB
      ENDIF
*
      ENDIF
*
* format statements.
*
1652  FORMAT('      Strand:',I5,I5,3X,A4)
1662  FORMAT('      Strand:',I5,I5,3X,A5)
1654  FORMAT('      Strand:',I5,I5)
1664  FORMAT('      Strand:',I5,I5)
1653  FORMAT('+',I2,'.')
1655  FORMAT('-',I2,'.')
1663  FORMAT('+',I2,'x.')
1665  FORMAT('-',I2,'x.')
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* pack a string.
*
      SUBROUTINE PACK1(IL,AA)
*
* Declarations.
*
      CHARACTER AA*80,VV*80
*
      INTEGER I,J
*
* work through string.
*
      J=0
      DO 1 I=1,80
      VV(I:I)=' '
      IF (AA(I:I).EQ.':'.OR.AA(I:I).EQ.',') THEN
      J=J+1
      VV(J:J)=AA(I:I)
      J=J+1
      VV(J:J)=' '
      ELSEIF (AA(I:I).NE.' ') THEN
      J=J+1
      VV(J:J)=AA(I:I)
      ENDIF
1     CONTINUE
*
* copy back packed string.
*
      IL=J
      AA=VV
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Within ring sequence distance.
*
      SUBROUTINE SIRING(IRING,ISHEET,ICHAIN,P)
*
* Declarations.
*
      INTEGER ISHEET,ICHAIN,IRING,P(100),IDN(100),P1(100)
*
      INCLUDE 'FOLD.INC'
*
      DO 2 I=1,100
      P(I)=0
2     CONTINUE
*
      II=0
      IZ=RNGLEN(IRING,ISHEET,ICHAIN)
      DO 1 I=1,IZ
*
      K1=RNGLST(I,IRING,ISHEET,ICHAIN)
*
      IF (K1.GT.0) THEN
      II=II+1
      P1(II)=K1
      ENDIF
*
1     CONTINUE
*
      CALL ISORT(II,P1,IDN)
*
      DO 3 I=1,II
      K1=IDN(I)
      P(P1(K1))=I
3     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* calculate RCBs and paths of all rings.
*
      SUBROUTINE RNGORD(IDEL,NLIST,ILIST)
*
* Declarations.
*
      INTEGER IDEL,ILOW,ILOC
      INTEGER NLIST(100),ILIST(100,100),JLIST(200)
*
* do all rings.
*
      DO 10 IU=1,IDEL
*
* get ring to start with lowest member.
*
      ILOW=2000000
*
      DO 1 IZ=1,NLIST(IU)
      IF (ILOW.GT.ILIST(IZ,IU)) THEN
      ILOW=ILIST(IZ,IU)
      ILOC=IZ
      ENDIF
1     CONTINUE
*
* copy reordered ring list.
*
      IF (ILOC.GT.1) THEN
      IT1=0
      DO 2 IZ=ILOC,NLIST(IU)
      IT1=IT1+1
      JLIST(IT1)=ILIST(IZ,IU)
2     CONTINUE
      DO 3 IZ=1,ILOC-1
      IT1=IT1+1
      JLIST(IT1)=ILIST(IZ,IU)
3     CONTINUE
      IT1=NLIST(IU)
      ELSE
      IT1=NLIST(IU)
      DO 7 I=1,IT1
      JLIST(I)=ILIST(I,IU)
7     CONTINUE
      ENDIF
*
* re-order.
*
      IF (JLIST(2).LT.JLIST(IT1)) THEN
      DO 4 IZ=1,IT1
      ILIST(IZ,IU)=JLIST(IZ)
4     CONTINUE
      ELSE
      ILIST(1,IU)=JLIST(1)
      IT2=1
      DO 5 IZ=IT1,2,-1
      IT2=IT2+1
      ILIST(IT2,IU)=JLIST(IZ)
5     CONTINUE
      ENDIF
*
10    CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* simple but fairly robust parser.
*     picks up lists of integer and real numbers. 
*     plus a letter if it follows an integer directly.
*
* nb:
*
*  ILAST = 0 not a number.
*  ILAST = 1 integer number.
*  ILAST = 2 real number.
*
      SUBROUTINE LRDRF(A,N,IH,FH,CH,NN)
*
* decalarations.
*
      IMPLICIT INTEGER (A-Z)
*
      INTEGER J1,N,NN,PP,I,ILAST,FCOUNT,FFT
      INTEGER IH(80),MULT(80)
*
      REAL FH(80)
*
      CHARACTER A*(*),CH(80)*1 
*
* initialise.
*
      DO 10 I=1,80
      IH(I)=0
      FH(I)=0.0
      CH(I)=' '
10    CONTINUE
*
      J1=1
      ILAST=0
      IH(J1)=0
      FH(J1)=0.0
      MULT(J1)=1
      FCOUNT=1
*
* Work through line.
*
      DO 2 I=1,N
      PP=INDEX('0123456789',A(I:I))
*
      IF (PP.GT.0) THEN
*
      IF (ILAST.NE.2) THEN
* integer
      ILAST=1
      IH(J1)=(IH(J1)*10)+(PP-1)
      ELSE
* real
      FFT=10**FCOUNT
      FH(J1)=FH(J1)+(FLOAT(PP-1)/FLOAT(FFT))
      FCOUNT=FCOUNT+1
      ENDIF
*
* get sign.
*
      IF (A(I-1:I-1).EQ.'-') MULT(J1)=-1
*
      ELSE
*
* found a decimal point.
*
      IF (A(I:I).EQ.'.') THEN 
      ILAST=2
      FCOUNT=1
      FH(J1)=FLOAT(IH(J1))
      IH(J1)=0
* get sign.
      IF (A(I-1:I-1).EQ.'-') MULT(J1)=-1
      GOTO 2
      ENDIF
*
* get chain label.
* 
      IF (ILAST.EQ.1) THEN
      CH(J1)=A(I:I)
      J1=J1+1
      MULT(J1)=1
      IH(J1)=0
      CH(J1)=' '
      ILAST=0
      ENDIF
*
* last was decimal point.
*
      IF (ILAST.EQ.2) THEN
      J1=J1+1
      MULT(J1)=1
      IH(J1)=0
      CH(J1)=' '
      ILAST=0
      ENDIF
*
      ENDIF
*
2     CONTINUE
*
* get number of numbers found.
*
      NN=J1-1
*
* get correct sign for each number.
*
      DO 3 I=1,NN
      IF (MULT(I).EQ.-1) THEN
      IH(I)=-IH(I)
      FH(I)=-FH(I)
      ENDIF
3     CONTINUE
*
      RETURN
      END
