      subroutine matfit(x1, x2, rm, n, iw, wt1)
c
c     SUBROUTINE TO FIT THE COORD SET XA(3,N) TO THE SET XB(3,N)
c     IN THE SENSE OF:
c            XA= R*XB +V
c     R IS A UNITARY 3.3 RIGHT HANDED ROTATION MATRIX
c     AND V IS THE OFFSET VECTOR. THIS IS AN ANALYTIC SOLUTION
c
c     IF ENTRY IS LOGICALLY FALSE ONLY THE RMS COORDINATE ERROR
c     WILL BE RETURNED (BUT QUICKLY)
c
c    THIS SUBROUTINE IS THAT ACCORDING TO MCLACHLAN (1982). SEE:
c     MCLACHAN, A.D., ACTA CRYST.(1982),A38,871-873.
c
c     AMMENDED BY M.J. SUTCLIFFE   DECEMBER 1985
c
c
      include 'mnyfit.h'
c     Common blocks for mnyfit  
c
      dimension umat(3, 3), rm(3, 3), wt1(maxats), x1(3, maxats), x2(3, 
     &maxats)
      if (nf .lt. 3) then
        write(STDERR,'(''mnyfit: number of points < 3'')')
        call EXIT(1)
      end if
      if (iw .le. 0) then
      do 20 i = 1, 3
      do 10 j = 1, 3
      umat(i,j) = 0.0
   10 continue
      do 20 j = 1, n
      do 20 k = 1, 3
      umat(i,k) = umat(i,k) + (x1(i,j) * x2(k,j))
   20 continue
      else
      do 40 i = 1, 3
      do 30 j = 1, 3
      umat(i,j) = 0.0
   30 continue
      do 40 j = 1, n
      do 40 k = 1, 3
      umat(i,k) = umat(i,k) + ((wt1(j) * x1(i,j)) * x2(k,j))
   40 continue
c
c--   FIT IT
c
      end if
      call qikfit(umat, rm)
      return 
      end
