#!/usr/local/bin/perl
use CGI qw/:standard/;

############################################
##                                        ##
##              CompNet perl              ##
##              ASAP Programs             ##
##           by Marc A Marti              ##
## e-mail marcius@guitar.rockefeller.edu  ##
##                                        ##
##             version:  1.0              ##
##         last modified: 27/05/98        ##
##                                        ##
############################################

# Initialize
$Used_pl     = "CompNet";
$header_file = "../CompNet/xtras/header.txt";
$footer_file = "../CompNet/xtras/footer.txt";
$log_file    = "../CompNet/xtras/compnet.log";
$time        = localtime;

# Get parameters from HTML input
$Adbinp = param('A_db');
$Bdbinp = param('B_db');
$Afile2 = param('A_inputfile2');
$Afile3 = param('A_inputfile3');
$Afile4 = param('A_inputfile4');
$Bfile2 = param('B_inputfile2');
$Bfile3 = param('B_inputfile3');
$Bfile4 = param('B_inputfile4');

if ($Adbinp eq "Your own DB") {
   $Adb = 1;
}
if ($Adbinp eq "S. cerevisiae") {
   $Adb = 2;
}
if ($Adbinp eq "E. coli") {
   $Adb = 3;
}
if ($Bdbinp eq "Your own DB") {
   $Bdb = 1;
}
if ($Bdbinp eq "S. cerevisiae") {
   $Bdb = 2;
}
if ($Bdbinp eq "E. coli") {
   $Bdb = 3;
}

# Checking input from HTML
if ($Adb eq "") {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter a DATA BASE A and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($Adb eq 1 and !$Afile2) {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the TWO RESIDUE TABLE file in database A and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($Adb eq 1 and !$Afile3) {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the THREE RESIDUE TABLE file in database A and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($Adb eq 1 and !$Afile4) {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the FOUR RESIDUE TABLE file in database A and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($Bdb eq "") {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter a DATA BASE B and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($Bdb eq 1 and !$Bfile2) {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the TWO RESIDUE TABLE file in database B and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($Bdb eq 1 and !$Bfile3) {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the THREE RESIDUE TABLE file in database B and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($Bdb eq 1 and !$Bfile4) {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the FOUR RESIDUE TABLE file in database B and try again </H1>\n";
   &Footer("Search Results");
   exit;
}

# Printing  & Executing programs
open(INP, "| ../CompNet/bin/comp-net") || die ("Can't open output file\n");
print INP "$Adb\n";
if ($Adb eq 1) {
   while (<$Afile2>) {
      print INP $_;
   }
   while (<$Afile3>) {
      print INP $_;
   }
   while (<$Afile4>) {
      print INP $_;
   }
}
print INP "$Bdb\n";
if ($Bdb eq 1) {
   while (<$Bfile2>) {
      print INP $_;
   }
   while (<$Bfile3>) {
      print INP $_;
   }
   while (<$Bfile4>) {
      print INP $_;
   }
}
close (INP);
wait;

# Write log file with several information about use of SeqDetNet
&Writelogfile;

# End of perl
exit;

# Functions

sub Header {
        if ($header_file) {
                open (HEADER,"$header_file");
                @header = <HEADER>;
                close (HEADER);
                foreach $line (@header) {
                        print "$line";
                }
        }
}

sub Footer {
        if ($footer_file) {
                open (FOOTER,"<$footer_file");
                @footer = <FOOTER>;
                close (FOOTER);
                foreach $line (@footer) {
                        print "$line";
                }
        }
}

sub Writelogfile {
        # Geting remote information
        $remote_host = remote_host();
        $remote_addr = remote_addr();
        $remote_user = remote_user();

        # Writting
        open (LOG, ">>$log_file");
        print LOG "---------------------------------------->>\n";
        print LOG "New user for $Used_pl\n";
        print LOG "Date: $time\n";
        print LOG "Num user: $numusuari\n";
        print LOG "Remote host: $remote_host\n";
        print LOG "Remote address: $remote_addr\n";
        print LOG "Remote user: $remote_user\n";
        print LOG "<<----------------------------------------\n";
        print LOG "\n";
        close (LOG);
}

