#!/usr/local/bin/perl
use CGI qw/:standard/;

############################################
##                                        ##
##               SeqDet perl              ##
##           by Marc A Marti-Renom        ##
## (e-mail marcius@guitar.rockefeller.edu)##
##                                        ##
##             version:  1.0              ##
##         last modified: 02/24/99        ##
##                                        ##
############################################

# Initialize
$Used_pl     = "SeqDetNet";
$header_file = "../SeqDetNet/xtras/header.txt";
$footer_file = "../SeqDetNet/xtras/footer.txt";
$log_file    = "../SeqDetNet/xtras/seqdet.log";
$time        = localtime;

# Get parameters from HTML input
$seq = param('seq');
$fdb  = param('db');

if ($fdb eq "S. cerevisiae") {
   $db = 1;
}
if ($fdb eq "E. coli") {
   $db = 2;
}

# Cheking inputs
if ($fdb eq "----") {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter a DATA BASE and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($seq eq "") {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the SEQUENCE and try again </H1>\n";
   &Footer("Search Results");
   exit;
}

# Executing programs & printing output
open(INP, "| ../SeqDetNet/bin/seqdet-net") || die ("Can't open output file\n");
print INP "$db\n";
print INP "$seq\n";
close (INP);
wait;

# Write log file with several information about use of SeqDetNet
&Writelogfile;

# End of perl
exit;

# Functions

sub Header {
        if ($header_file) {
                open (HEADER,"$header_file");
                @header = <HEADER>;
                close (HEADER);
                foreach $line (@header) {
                        print "$line";
                }
        }
}

sub Footer {
        if ($footer_file) {
                open (FOOTER,"<$footer_file");
                @footer = <FOOTER>;
                close (FOOTER);
                foreach $line (@footer) {
                        print "$line";
                }
        }
}

sub Writelogfile {
  	# Geting remote information
        $remote_host = remote_host();
        $remote_addr = remote_addr();
        $remote_user = remote_user();

        # Writting
        open (LOG, ">>$log_file");
        print LOG "---------------------------------------->>\n";
        print LOG "New user for $Used_pl\n";
        print LOG "Date: $time\n";
        print LOG "Num user: $numusuari\n";
        print LOG "Remote host: $remote_host\n";
        print LOG "Remote address: $remote_addr\n";
        print LOG "Remote user: $remote_user\n";
        print LOG "<<----------------------------------------\n";
        print LOG "\n";
        close (LOG);
}

