#!/bin/sh 

# Ready to start?
if test -z "$1"; then
   echo -n ' Usage: install.sh "Path_to_your__ASAP_server" \n'
   echo -n '   VERY IMPORTANT: You should include "\" in front any ":", ".", "/" or "~" characters\n'
   echo -n '   i.e. install.sh "http\:\/\/guitar\.rockefeller\.edu\/\~marcius"\n'
   exit 1
fi
# Initialize some variables
path=$1
pwdir=$PWD
f77file=
perlfile=
CGIfile=

# Check requeriments
echo '-------------->> Cheking minimum requeriments...'
for dir in /usr/bin /usr/local/bin /bin /usr/sbin; do
  if test -f $dir/f77; then
     echo "--->> f77 under $dir"
     f77file=$dir/f77
     break
  fi
done
for dir in /usr/bin /usr/local/bin /bin /usr/sbin; do
  if test -f $dir/perl; then
     echo "--->> Perl under $dir"
     perlfile=$dir/perl
     break
  fi
done
for dir in /usr/lib/ /usr/local/lib /lib /usr/lib/perl5 /usr/local/lib/perl5 /lib/perl5; do
  if test -f $dir/CGI.pm; then
     echo "--->> CGI under $dir"
     CGIfile=$dir/CGI.pm
     break
  fi
done
if test -z "$f77file"; then 
    echo ' #ERROR# You have no access to compile FORTRAN with f77 command'
    echo ' #ERROR# STOP compilation...'
    exit 1
fi
if test -z "$perlfile"; then 
    echo ' #WARNING# You have no access to perl libraries'
    echo ' #WARNING# Continue instalation and then install perl libraries'
fi
if test -z "$CGIfile"; then 
    echo ' #WARNING# You have no access to CGI libraries'
    echo ' #WARNING# Continue instalation and then install CGI libraries'
fi

echo "-------------->> ok"

echo "-------------->> Starting compilation..."
echo '-------------->> Actual directory:' $pwdir
echo '-------->> Move to ClonErrNet to compile it...'
cd ClonErrNet/src/
f77 -mips1 clonerr-net.f -o ../bin/clonerr-net
echo '-------->> Move to SeqDetNet to compile it...'
cd ../../SeqDetNet/src/
f77 -mips1 seqdet-net.f -o ../bin/seqdet-net
echo '-------->> Move to GenerNet to compile it...'
cd ../../GenerNet/src/
f77 -mips1 gener-net.f -o ../bin/gener-net
echo '-------->> Move to CompNet to compile it...'
cd ../../CompNet/src/
f77 -mips1 comp-net.f -o ../bin/comp-net
cd ../../

echo '-------------->> Creating files with correct path...'
echo '-------------->> Actual directory:' $pwdir
echo '-------->> Move to ClonErrNet...'
cd ClonErrNet/xtras/
sed   -e 's/PATH_ASAP/'$path'/' body.master > body.txt
sed   -e 's/PATH_ASAP/'$path'/' footer.master > footer.txt
sed   -e 's/PATH_ASAP/'$path'/' header.master > header.txt
sed   -e 's/PATH_ASAP/'$path'/' help.master > help.html
sed   -e 's/PATH_ASAP/'$path'/' example.master > example.html
echo '-------->> Move to CompNet...'
cd ../../CompNet/xtras/
sed   -e 's/PATH_ASAP/'$path'/' body.master > body.txt
sed   -e 's/PATH_ASAP/'$path'/' footer.master > footer.txt
sed   -e 's/PATH_ASAP/'$path'/' header.master > header.txt
sed   -e 's/PATH_ASAP/'$path'/' help.master > help.html
sed   -e 's/PATH_ASAP/'$path'/' example.master > example.html
echo '-------->> Move to GenerNet...'
cd ../../GenerNet/xtras/
sed   -e 's/PATH_ASAP/'$path'/' body.master > body.txt
sed   -e 's/PATH_ASAP/'$path'/' footer.master > footer.txt
sed   -e 's/PATH_ASAP/'$path'/' header.master > header.txt
sed   -e 's/PATH_ASAP/'$path'/' help.master > help.html
sed   -e 's/PATH_ASAP/'$path'/' example.master > example.html
echo '-------->> Move to SeqDetNet...'
cd ../../SeqDetNet/xtras/
sed   -e 's/PATH_ASAP/'$path'/' body.master > body.txt
sed   -e 's/PATH_ASAP/'$path'/' footer.master > footer.txt
sed   -e 's/PATH_ASAP/'$path'/' header.master > header.txt
sed   -e 's/PATH_ASAP/'$path'/' help.master > help.html
sed   -e 's/PATH_ASAP/'$path'/' example.master > example.html
cd ../../
sed   -e 's/PATH_ASAP/'"$path"'/' ASAP.master > ASAP.html

echo '-------------->> Set links...'
cd GenerNet
ln -sf ../ASAP.html index.html
cd ../CompNet
ln -sf ../ASAP.html index.html
cd data
ln -sf ../../ClonErrNet/data/ecoli ecoli
ln -sf ../../ClonErrNet/data/yeast yeast
cd ../../ClonErrNet
ln -sf ../ASAP.html index.html
cd ../SeqDetNet
ln -sf ../ASAP.html index.html
cd ../

echo '-------------->> Set file permisions...'
chmod 777 GenerNet/tmp
chmod 666 GenerNet/xtras/gener.log
chmod 666 CompNet/xtras/compnet.log
chmod 666 ClonErrNet/xtras/clonerr.log
chmod 666 SeqDetNet/xtras/seqdet.log

echo "-------------->> End of compilation. Do not to forget to check "
echo "                 important points mentioned in INSTALL.html file."
echo "                 Any question mail me at marcius@guitar.rockefeller.edu"

exit
#last line
