cf ----------------------------------------------------------------------------
cf
cf    Comments on all of the alignment routines:
cf
cf    They return the best score in SCORE and the alignment in the unusual
cf    format in array IALN(MAXRES) (processed by mkaln() into the usual
cf    IALN2(2,MAXRES) format). The routines use the global dynamic programming
cf    with the two sequences in ISEQ1() and ISEQ2(), their lengths in NA and 
cf    NB, type by type weights in RRWGHT(MRESTP,MRESTP), gap constants
cf    U and V (G = U + V*LEN), diagonal speedup NDIAG2, and the
cf    similarity/distance selection in SIMILAR. Optionally, the whole
cf    weight matrix may be specified in RRWGHT(MAXRES,MAXRES) instead
cf    of in ISEQ1(), ISEQ2(), RRWGHT(MRESTP,MRESTP). The routines are:
cf
cf    NAME        TYPE     INPUT        OUTPUT
cf    -----------------------------------------------------------
cf
cf    ALIGN1  ... integer  sequence     score
cf    ALIGN2  ... integer  sequence     score, alignment
cf
cf    ALIGN5  ... real     sequence     score, alignment
cf    ALIGN6  ... real     weights      score
cf    ALIGN7  ... real     sequence     score
cf    ALIGN8  ... real     weights      score, alignment
cf
cf ----------------------------------------------------------------------------



      subroutine align1(iseq1,iseq2,rrwght,mrestp,na,nb,u,v,score,dist,
     &                  p,q,ip,iq,maxres,ndiag,similar,novrhng,local,
     &                  offset,ipoint)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, novrhng, iopt, jopt
        integer pq,p1,q1,p2,q2,uppv
        integer na,nb,maxres,mrestp,ndiag
        integer dist(0:maxres,0:maxres)
        integer p(0:maxres), q(0:maxres)
        integer ipoint(0:maxres,0:maxres)
        integer rrwght(mrestp,mrestp)
        integer ip(maxres),iq(maxres)
        integer iseq1(na), iseq2(nb)
        integer u,v,score,similar,forbid,offset
        real rdiag
        logical local,idefd

#include "distdp1.inc"
c --------- substitution score:
            pq = dist(i1,j1)+rrwght(iseq1(i),iseq2(j))
#include "distdp2.inc"
#include "distdp3.inc"
 
        return
      end




      subroutine align2(iseq1,iseq2,rrwght,mrestp,na,nb,u,v,score,
     &                  ialn,naln,dist,p,q,ip,iq,ipoint,maxres,ndiag,
     &                  similar,novrhng,local,offset)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, novrhng
        integer pq,p1,q1,p2,q2,uppv,iopt,jopt
        integer maxres, ialn(maxres), naln, na, nb, mrestp, ndiag
        integer ipoint(0:maxres,0:maxres)
        integer ip(maxres),iq(maxres)
        integer iseq1(na), iseq2(nb)
        integer dist(0:maxres,0:maxres)
        integer p(0:maxres), q(0:maxres)
        integer rrwght(mrestp,mrestp)
        integer u,v,score,similar,forbid,offset
        real rdiag
        logical local,idefd

#include "distdp1.inc"
c --------- substitution score:
            pq = dist(i1,j1)+rrwght(iseq1(i),iseq2(j))
#include "distdp2.inc"
#include "distdp3.inc"

        call pntdp(na,nb,ialn,naln,ipoint,iopt,jopt,maxres)

        return
      end




      subroutine align5(iseq1,iseq2,rrwght,mrestp,na,nb,u,v,score,
     &                  ialn,naln,dist,p,q,ip,iq,ipoint,maxres,ndiag,
     &                  similar,novrhng,local,offset)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, iopt,jopt, novrhng
        real    pq,p1,q1,p2,q2,uppv
        integer maxres,ndiag
        integer ialn(maxres), naln, na, nb, mrestp
        integer ipoint(0:maxres,0:maxres)
        integer ip(maxres),iq(maxres)
        integer iseq1(na), iseq2(nb)
        real dist(0:maxres,0:maxres)
        real p(0:maxres), q(0:maxres)
        real rrwght(mrestp,mrestp)
        real u,v,score,similar,forbid,offset
        real rdiag
        logical local,idefd

#include "distdp1.inc"
c --------- substitution score:
            pq = dist(i1,j1)+rrwght(iseq1(i),iseq2(j))
#include "distdp2.inc"
#include "distdp3.inc"

        call pntdp(na,nb,ialn,naln,ipoint,iopt,jopt,maxres)

        return
      end



      subroutine align6(rrwght,na,nb,u,v,score,dist,p,q,ip,iq,maxres,
     &                  ndiag,similar,novrhng,local,offset,ipoint)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, iopt, jopt, novrhng
        real    pq,p1,q1,p2,q2,uppv
        integer maxres,ndiag
        integer na, nb
        integer ip(maxres),iq(maxres)
        integer ipoint(0:maxres,0:maxres)
        real dist(0:maxres,0:maxres),rrwght(maxres,maxres)
        real p(0:maxres), q(0:maxres)
        real u,v,score,similar,forbid,offset
        real rdiag
        logical local,idefd

#include "distdp1.inc"
c --------- substitution score:
            pq = dist(i1,j1)+rrwght(i,j)
#include "distdp2.inc"
#include "distdp3.inc"

        return
      end




      subroutine align7(iseq1,iseq2,rrwght,mrestp,na,nb,u,v,score,
     &                  dist,p,q,ip,iq,maxres,ndiag,similar,novrhng,
     &                  local,offset,ipoint)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, iopt, jopt, novrhng
        integer maxres,ndiag
        integer ipoint(0:maxres,0:maxres)
        real    pq,p1,q1,p2,q2,uppv
        integer na, nb, mrestp
        integer ip(maxres),iq(maxres)
        integer iseq1(na), iseq2(nb)
        real dist(0:maxres,0:maxres)
        real p(0:maxres), q(0:maxres)
        real rrwght(mrestp,mrestp)
        real u,v,score,similar,forbid,offset
        real rdiag
        logical local,idefd

#include "distdp1.inc"
c --------- substitution score:
            pq = dist(i1,j1)+rrwght(iseq1(i),iseq2(j))
#include "distdp2.inc"
#include "distdp3.inc"

        return
      end




      subroutine align8(rrwght,na,nb,u,v,score,ialn,naln,dist,p,q,ip,
     &                  iq,ipoint,maxres,ndiag,similar,novrhng,local,
     &                  offset)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, iopt, jopt, novrhng
        real    pq,p1,q1,p2,q2,uppv
        integer maxres,ndiag
        integer ialn(maxres), naln, na, nb
        integer ipoint(0:maxres,0:maxres)
        integer ip(maxres),iq(maxres)
        real dist(0:maxres,0:maxres),rrwght(maxres,maxres)
        real p(0:maxres), q(0:maxres)
        real u,v,score,similar,forbid
        real rdiag,offset
        logical local,idefd

#include "distdp1.inc"

c ----- substitution score:
        pq = dist(i1,j1)+rrwght(i,j)

#include "distdp2.inc"
#include "distdp3.inc"

        call pntdp(na,nb,ialn,naln,ipoint,iopt,jopt,maxres)

cdeb    write(*,*)
cdeb    do  i = 0, na
cdeb      write(*,'(99f5.1)') (dist(i,j),j=0,nb)
cdeb    end do
cdeb    write(*,*)
cdeb    do  i = 0, na
cdeb      write(*,'(99i5)') (ipoint(i,j),j=0,nb)
cdeb    end do
cdeb    write(*,*)
cdeb    write(*,'(2i5,f5.1)') iopt, jopt, score
cdeb    write(*,*)
cdeb    write(*,'(99i5)') (ialn(i),i=1,naln)

        return
      end




cf ----------------------------------------------------------------------------
cf
cf    PNTDP re-traces the dynamic programming pointer array to infer the
cf    best alignment.
cf
cf    subroutine pntdp(na,nb,ialn,naln,ipoint,iopt,jopt,maxres)
cf
cf ----------------------------------------------------------------------------

      subroutine pntdp(na,nb,ialn,naln,ipoint,iopt,jopt,maxres)
        implicit none
#include "numbers.cst"
        integer maxres, ialn(maxres), naln, na, nb
        integer ipoint(0:maxres,0:maxres)
        integer i, j, ipntij, iopt, jopt
        logical recover

c ----- the alignment will be stored in ialn(naln) in the same way
c       directions are stored in ipoint(i,j); to get the alignment 
c       interpret ialn from the end to the beginning;

c ----- set the boundaries of the ipoint array for easier traceback when
c       i1=0 or j1=0:
        do  i = 1, na
          ipoint(i, 0) =  i
        end do
        do  j = 1, nb
          ipoint(0, j) = -j
        end do

c ----- for local alignments:
        naln = 0
        if (iopt .lt. na) then
          naln = 1
          ialn(1) = na - iopt
        else
          if (jopt .lt. nb) then
            naln = 1
            ialn(1) = -(nb - jopt)
          end if
        end if

c ----- traceback the pointers array:
        i = iopt
        j = jopt
10      if (((i.eq.0).and.(j.eq.0)).or.(ipoint(i,j).eq.nundf)) go to 100
          if (naln.ge.maxres) then
            write(*,'(a)') 'pntdp___E> increase MAXRES or gap pen'
c --------- exit from this routine without further action if necessary
            if (recover(.true., 1)) return
          end if
          ipntij = ipoint(i,j)
          naln = naln + 1
          ialn(naln) = ipntij
          if (ipntij .eq. 0) then
            i = i - 1
            j = j - 1
          else
            if (ipntij .lt. 0) then
              j = j + ipntij
            else
              i = i - ipntij
            end if
          end if
          go to 10
100     continue

c ----- for local alignments:
        if (((i.ne.0).or.(j.ne.0)).or.(ipoint(i,j).eq.nundf)) then
          if (i.gt.0) then
            naln = naln + 1
            ialn(naln) = i
          end if
          if (j.gt.0) then
            naln = naln + 1
            ialn(naln) = -j
          end if
        end if

        return
      end




cf ----------------------------------------------------------------------------
cf
cf     MKALN(): given ialn,naln,maxres in the format of the DP alignment 
cf     routines, it returns the alignment in the usual MODELLER format 
cf     in the array IALN2(NALN2,2) (i.e. residue index IALN(I,1) of 
cf     sequence 1 is aligned with residue index IALN(I,2) of sequence 2).
cf
cf     subroutine mkaln(ialn,naln,ialna,ialnb,naln2,maxres)
cf
cf ----------------------------------------------------------------------------

      subroutine mkaln(ialn,naln,ialna,ialnb,naln2,maxres)
        implicit none
        integer maxres,naln,naln2,i,j,ia,i1,j1
        integer ialn(naln), ialna(maxres), ialnb(maxres)
        logical recover

        i = 0 
        j = 0 
        naln2 = 0
        do  ia = naln, 1, -1
          if (ialn(ia) .gt. 0) then 
            do  i1 = 1, ialn(ia)
              if (naln2.ge.maxres) then
                write(*,'(a)') 'mkaln___E> increase MAXRES or gap pen'
c ------------- exit from this routine without further action if necessary
                if (recover(.true., 1)) return
              end if
              i = i + 1
              naln2        = naln2 + 1
              ialna(naln2) = i
              ialnb(naln2) = 0
            end do
          else
            if (ialn(ia) .lt. 0) then
              do  j1 = 1, abs(ialn(ia))
                if (naln2.ge.maxres) then
                  write(*,'(a)') 'mkaln___E> increase MAXRES or gap pen'
c --------------- exit from this routine without further action if necessary
                  if (recover(.true., 1)) return
                end if
                j     = j + 1
                naln2 = naln2 + 1
                ialna(naln2) = 0
                ialnb(naln2) = j
              end do
            else
              if (naln2.ge.maxres) then
                write(*,'(a)') 'mkaln___E> increase MAXRES or gap pen'
c ------------- exit from this routine without further action if necessary
                if (recover(.true., 1)) return
              end if
              i = i + 1
              j = j + 1
              naln2          = naln2 + 1
              ialna(naln2) = i
              ialnb(naln2) = j
            end if
          end if
        end do

        return
      end
