cf ---------------------------------------------------------------------------
cf
cf    NEWIATMS2() calculates new last atom indices of segments from the
cf    last residue indices of the segments (after build, rdmod, patch).
cf
cf    subroutine newiatms2(iress2,nsegm,iatmr1,nres,natm,iatms2)
cf
cf ---------------------------------------------------------------------------

      subroutine newiatms2(iress2,nsegm,iatmr1,nres,natm,iatms2)
        implicit none
        integer natm,nres,nsegm,iatmr1(nres),iress2(nsegm),iatms2(nsegm)
        integer i,iatmr2
 
        do  i = 1, nsegm
          iatms2(i) = iatmr2(iatmr1,nres,natm,iress2(i))
        end do

        return
      end




cf ---------------------------------------------------------------------------
cf
cf    AMASS() returns the atomic mass in atomic mass units, given the
cf    atom index for MODEL.
cf
cf    real function amass(iatmind)
cf
cf ---------------------------------------------------------------------------

      real function amass(iatmind)
        implicit none
#include "mod.cst" 
#include "model.cmn" 
#include "topol.cmn" 
        integer iatmind

        amass = amrt(iattyp(iatmind))

        return
      end



cf ---------------------------------------------------------------------------
cf
cf    CHARGE() returns the atomic charge in electron units, given the
cf    atom index for MODEL.
cf
cf    real function acharge(iatmind)
cf
cf ---------------------------------------------------------------------------

      real function acharge(iatmind)
        implicit none
#include "mod.cst" 
#include "model.cmn" 
#include "topol.cmn" 
        integer iatmind

        acharge = 0.0
c        acharge = acresrt(iresaind(iatmind), irestyp(iresatm(iatmind)))

        return
      end



cf ---------------------------------------------------------------------------
cf
cf    ATMCHM() returns the CHARMM atom name, given the atom index for MODEL.
cf
cf    character*4 function atmchm(iatmind)
cf
cf ---------------------------------------------------------------------------

      character*4 function atmchm(iatmind)
        implicit none
#include "mod.cst" 
#include "radii.cmn" 
#include "model.cmn" 
#include "lib.cmn" 
        integer iatmind
 
        if (iatmind .ge. 1 .and. iatmind .le. natm) then
          if (iattyp(iatmind) .ge. 1 .and.
     &        iattyp(iatmind) .le. nvdwtyp) then
            atmchm = vdwatm(iattyp(iatmind))
          else
            atmchm = atund
          end if
        else
          atmchm = atund
        end if

        return
      end


      logical function atdefd(iat)
        implicit none
#include "mod.cmn"
        integer iat

        if (iat .gt. 0) then
          atdefd = iattyp(iat) .ne. iatund
        else
          atdefd = .false.
        end if
 
        return
      end




cf ----------------------------------------------------------------------------
cf
cf    FNDATMS() finds indices of NIND atoms, given their [I][-,+,#,*]names,
cf    and corresponding residue indices IRESL(NRESL). It returns IND(I)=0,
cf    if atom I does not exist. PRESENT = .T., if all atoms exist. If WHOLE 
cf    is true, the whole atom list is searched; otherwise the IATMR1
cf    array is used to make the search faster.
cf
cf    subroutine fndatms(atmnam,iresatm,iatmr1,natm,nres,
cf   -           atms,nind,ind,iresl,nresl,present,whole)
cf
cf ----------------------------------------------------------------------------

      subroutine fndatms(atmnam,iresatm,iatmr1,natm,nres,
     &           atms,nind,ind,iresl,nresl,present,whole)
        implicit none
        integer natm,nres,iatmr1(nres),iresatm(natm)
        integer nind,ind(nind),i,nresl,iresl(nresl)
        integer ires1
        character atms(nind)*(*),atm1*(4),atmnam(natm)*(*)
        logical present,whole

        present = .true.
        do  i = 1, nind
c ------- find the residue index first:
          if (atms(i)(1:1) .eq. ' ') then
            write(*,'(a)') 'fndatms_E> internal'
            stop 
          end if
          if (whole) then
            call i2atint(atms(i),atmnam,natm,iresatm,iresl,nresl,
     &                   nres,ires1,atm1,ind(i))
          else
            call iatint(atms(i),atmnam,natm,iatmr1,iresl,
     &                  nresl,nres,ires1,atm1,ind(i))
          end if
          present = present .and. (ind(i) .gt. 0)
        end do

        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    I2ATINT() returns the index of the atom ATM in residue IRES,
cf    given its [I][-,+,#,*]name. It does not rely on IATMR1 but
cf    searches all atoms in the model. It also returns only the
cf    root atom name in ATM1. IRESL(NRESL) is used in getting the
cf    residue index from [I][-,+,#,*]name and IRES1.
cf
cf    subroutine i2atint(atm,atmnam,natm,iresatm,iresl,nresl,
cf   -                   nres,ires1,atm1,ind)
cf
cf ----------------------------------------------------------------------------

      subroutine i2atint(atm,atmnam,natm,iresatm,iresl,nresl,
     &                   nres,ires1,atm1,ind)
        implicit none
        integer nres,natm,ires1,iresatm(natm),nresl,iresl(nresl)
        integer indexw,ind
        character atmnam(natm)*(*), atm*(*), atm1*(4)

c ----- get the residue index of the atom to be found and its proper
c       atom name without the CHARMM residue/position/improper flag(s)
        call atmparse(atm,atm1,iresl,nresl,ires1)

c ----- does this residue exist 
        if ((ires1 .ge. 1) .and. (ires1 .le. nres)) then
c ------- find the atom name in residue ires1
          do  ind = 1, natm
            if (iresatm(ind) .eq. ires1) then
              if (indexw(atmnam(ind), atm1) .gt. 0) go to 999
            end if
          end do
        end if
        ind = 0

999     continue

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    IATINT() returns the index of the atom ATM in residue IRESL(NRESL),
cf    given its [I][-,+,#,*]name. It does rely on IATMR1 for a faster 
cf    search. It also returns only the root atom name in ATM1. IRESL(NRESL) 
cf    is used in getting the residue index from [I][-,+,#,*]name and IRES1.
cf
cf    subroutine iatint(atm,atmnam,natm,iatmr1,iresl,
cf   &                  nresl,nres,ires1,atm1,ind)
cf
cf ----------------------------------------------------------------------------

      subroutine iatint(atm,atmnam,natm,iatmr1,iresl,
     &                  nresl,nres,ires1,atm1,ind)
        implicit none
        integer nres,natm,ires1,iatmr1(nres),indxatm
        integer nresl,iresl(nresl),ind
        character atmnam(natm)*(*), atm*(*), atm1*(*)

c ----- get the residue index of the atom to be found and its proper
c       atom name without the CHARMM residue/position/improper flag(s)
        call atmparse(atm,atm1,iresl,nresl,ires1)

c ----- does this residue exist 
        if ((ires1 .ge. 1) .and. (ires1 .le. nres)) then
c ------- find the atom name in residue ires1
          ind = indxatm(atm1,ires1,atmnam,iatmr1,nres,natm)
        else
          ind = 0
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    ATMPARSE() returns the plain atom_name (ATM1) and its 
cf    residue index (IRES1)
cf
cf    The CHARMM atom name is: [I][-|+|#|*][atom_name*4];
cf
cf    [I] ... selects the I-th residue from the IRESL list; 
cf            (patch residues only)
cf     -  ... previous residue
cf     +  ... next residue
cf     #  ... next of next residue (patch residues only)
cf     *  ... it indicates an improper dihedral (in the IC list)
cf
cf    the [I] and # prefixes are used in patch residues only;
cf
cf    subroutine atmparse(atm,atm1,iresl,nresl,ires1)
cf
cf ----------------------------------------------------------------------------

      subroutine atmparse(atm,atm1,iresl,nresl,ires1)
        implicit none
#include "charmm.cst"
        integer nresl,iresl(nresl),ires1,ind,ipos,i,idig,la
        character atm*(*),atm1*(*)

c ----- process the leading optional integer [I]
        ind = 0
        ipos = 0
        la = len(atm)
        if (la .lt. 4) then
          write(*,'(a)') 'atmpars_E> internal'
          stop
        end if
        do  i = 1, la
          ipos = ipos + 1
          idig = index(digits, atm(i:i)) - 1
          if (idig .lt. 0) go to 10
          ind = 10*ind + idig
        end do
10      if (ind .gt. nresl) then
          write(*,'(a,2i5)')
     &    'atmpars_E>; too few patched residues: ', ind,nresl
          stop
        end if
        ires1 = iresl(max(1,ind))

        if (atm(ipos:ipos) .eq. prev) then
          ires1 = ires1-1
          atm1 = atm(ipos+1:)
        else
          if (atm(ipos:ipos) .eq. next) then
            ires1 = ires1+1
            atm1 = atm(ipos+1:)
          else
            if (atm(ipos:ipos) .eq. nextnext) then
              ires1 = ires1+2
              atm1 = atm(ipos+1:)
            else
              if (atm(ipos:ipos) .eq. improp) then
                atm1 = atm(ipos+1:)
              else
                atm1 = atm(ipos:)
              end if
            end if
          end if
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    INDATM() returns the index of atom ATM1*4.
cf
cf    integer function indxatm(atm1,ires1,atmnam,iatmr1,nres,natm)
cf
cf ----------------------------------------------------------------------------

      integer function indxatm(atm1,ires1,atmnam,iatmr1,nres,natm)
        implicit none
        integer iatmr2, nares, nres, natm, ires1, iatmr1(nres)
        integer ifind2word,i
        character atmnam(natm)*(*), atm1*(*)

        nares = iatmr2(iatmr1,nres,natm,ires1)-iatmr1(ires1)+1
        i = ifind2word(atm1,atmnam(iatmr1(ires1)),nares)
        if (i .gt. 0) then
          indxatm = iatmr1(ires1) + i - 1
        else
          indxatm = 0
        end if
  
        return
      end



cf ----------------------------------------------------------------------------
cf
cf    FNDATMI() prepares the indices of atom types DSTATM1*4 in IDSTA1(NRES).
cf
cf    subroutine fndatmi(nres,natm,atmnam,iatmr1,dstatm1,idsta1)
cf
cf ----------------------------------------------------------------------------

      subroutine fndatmi(nres,natm,atmnam,iatmr1,dstatm1,idsta1)
        implicit none
#include "io.cst"
        integer i, ip, natm, nres,iatmr1(nres), nares
        integer idsta1(nres), ifind2word, natmres
        character dstatm1*(*), atmnam(natm)*(*)
        logical iowr

        nares = 0

        do  i = 1, nres
         if (iatmr1(i) .lt. 1 .or. iatmr1(i) .gt. natm) then
           write(iolog,'(a,i6)') 
     &     'fndatmi_E> residue atom index out of bounds; ',
     &     '  number of atoms: ', natm
           stop
         end if
          ip = ifind2word(dstatm1, atmnam(iatmr1(i)), 
     &                    natmres(iatmr1,i,nres,natm))
          if (ip .eq. 0) then
            idsta1(i) = 0
          else
            nares = nares + 1
            idsta1(i) = iatmr1(i) + ip - 1
          end if
        end do

        if (nares .ne. nres) then
          if (iowr(3))
     &      write(iolog,'(a,2i5,1x,a)')
     &     'fndatmi_W> # of residues <> # of atoms; atom code: ',
     &     nres,nares,dstatm1
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    NATMRES() returns the number of atoms in residue IRES.
cf
cf    integer function natmres(iatmr1,ires,nres,natm)
cf
cf ----------------------------------------------------------------------------

      integer function natmres(iatmr1,ires,nres,natm)
        implicit none
        integer nres,ires,iatmr1(nres),natm
        if (ires .lt. nres) then
           natmres = iatmr1(ires+1) - iatmr1(ires)
        else
           natmres = natm - iatmr1(ires) + 1
        end if
        return
      end



cf ----------------------------------------------------------------------------
cf
cf    IATMR2() returns the index of the last atom in residue IRES.
cf
cf    integer function iatmr2(iatmr1, nres, natm, ires)
cf
cf ----------------------------------------------------------------------------

      integer function iatmr2(iatmr1, nres, natm, ires)
        implicit none
        integer nres, iatmr1(nres), natm, ires
        if (ires .eq. nres) then
          iatmr2 = natm
        else
          iatmr2 = iatmr1(ires+1) - 1
        end if
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    ISHYDROGEN function returns .T. if the atmnam is the PDB hydrogen
cf    atom code (if the first non-blank character is 'H').
cf
cf    logical function ishydrogen(atmnam)
cf
cf ----------------------------------------------------------------------------

      logical function ishydrogen(atmnam)
        implicit none
        character atmnam*(*), atdum*(5)

        atdum = atmnam 
        call ljust(atdum)
        if (atdum(1:1) .eq. 'H') then
          ishydrogen = .true.
        else
          if (index('1234567890',atmnam(1:1)).gt.0.and.
     -        atdum(2:2).eq.'H') then
            ishydrogen = .true.
          else
            ishydrogen = .false.
          end if
        end if

        return
      end

c --- returns residue index of a residue in MODEL with RESID=resid
c     (number[:chain])
      integer function iresind1(resid)
        implicit none
#include "mod.cst" 
#include "model.cmn" 
        integer iresind
        character resid*(*)

        iresind1 = iresind(resid,resnum,chain,nres)

        return
      end



c --- returns residue index of a residue in MODEL with RESID=resid
c     (number[:chain])
      integer function iresind2(resid)
        implicit none
#include "mod.cst" 
#include "model2.cmn" 
        integer iresind
        character resid*(*)

        iresind2 = iresind(resid,res2num,chain2,nres2)

        return
      end


c --- returns residue index of a residue with RESID=resid
c     (number[:chain])
      integer function iresind(resid,resnum,chain,nres)
        implicit none
        integer nres, i
        character resid*(*), res*(5), chn*(1),resnum(nres)*(*)
        character chain(nres)*(*)
        logical reseqv2

        call resparse(resid, res, chn)
        do  i = 1, nres
          if(reseqv2(res,chn,resnum(i),chain(i)))then
            iresind = i
            return
          end if
        end do
        iresind = 0

        return
      end



      logical function reseqv1(resnum1,chnid1,resnum2,chnid2)
        implicit none
#include "reslib.cst"
        integer indexw
        character resnum1*(*), chnid1*(*)
        character resnum2*(*), chnid2*(*)
        logical res, chn

        res = (indexw(resnum1,resnum2).gt.0) .or. 
     &          (index(resnum1,anyrid).gt.0 .or. 
     &           index(resnum2,anyrid).gt.0)
        chn = chnid1.eq.chnid2 .or. 
     &          (chnid1.eq.anyrid .or. chnid2.eq.anyrid)
        reseqv1 = res .and. chn

        return
      end


      logical function reseqv2(resnum1,chnid1,resnum2,chnid2)
        implicit none
        integer indexw
        character resnum1*(*), chnid1*(*)
        character resnum2*(*), chnid2*(*)

        reseqv2=indexw(resnum1,resnum2).gt.0.and.chnid1.eq.chnid2

        return
      end


       
      subroutine resparse(resid, res, chn)
        implicit none
        integer i
        character resid*(*), res*(*), chn*(*)

        i = index(resid, ':')
        if (i.lt.1) then
          res = resid
          chn = ' '
        else
          if (i-1.gt.0) then
            res = resid(1:i-1)
          else
            res = ' '
          end if
          if (i+1.le.len(resid)) then
            chn = resid(i+1:)
          else
            chn = ' '
          end if
        end if

        return
      end

      

      character*7 function rnumchn(ires)
        implicit none
#include "mod.cst" 
#include "model.cmn" 
        integer ires
        character c*(7)
        call concat(resnum(ires), ':', c)
        call addstr(c, chain(ires))
        rnumchn = c
        return
      end


      subroutine iresinda(resid,nresid,iresl,resnum,chain,nres)
        implicit none
        integer nres, i, nresid, iresl(nresid), iresind
        character resid(nresid)*(*),resnum(nres)*(*)
        character chain(nres)*(*)

        do  i = 1, nresid
          iresl(i) = iresind(resid(i),resnum,chain,nres)
          if (iresl(i) .eq. 0) then
            write(*,'(2a)')
     &      'iresinda_E> residue id not found: ', resid(i)
            stop
          end if
        end do

        return
      end
