cf ----------------------------------------------------------------------------
cf
cf    BADLINE() returns .T. if parsing the input line does not give the 
cf    expected structure. The expected FORMAT of the line in the steering 
cf    file is:
cf
cf    CODE   =    CONTENTS
cf
cf    logical function badline(commchr,delim,card,cod,contents)
cf
cf ----------------------------------------------------------------------------

      logical function badline(commchr,delim,card,cod,contents)
        implicit none
        integer lenr,lcard,lcont,idelim,lcod
        character card*(*),cod*(*),contents*(*),delim*(*),commchr*(*)

        badline = .true.

c ----- bad line if:
c            a) comment character is the first printable character on the line
c            b) line is empty
c            c) code is empty 
c            d) there is no delimiter
c            e) contents is empty

        call ljust(card)
        lcard = lenr(card)
        if (lcard.lt.1) return
        if (card(1:1) .eq. commchr) return
        idelim = index(card, delim)
        if (idelim .lt. 1) then
          write(*,*)'Warning[badline]; no delimiter in card: ',
     &              card(1:lcard)
          return
        else
          if (idelim .eq. 1) then
            write(*,*)'Warning[badline]; no code in card: ',
     &                card(1:lcard)
            return
          end if
        end if

c ----- now get the key which is the first word on the line:
        call str_s(card(1:idelim-1), cod)
        lcod = lenr(cod)
        if (lcod .lt. 1) then
          write(*,*)'Warning[badline]; no code in card: ',
     &              card(1:lcard)
          return
        end if


c ----- get the contents which is everything after the delimiter
        if (idelim+1 .gt. lcard) then
          write(*,*) 'Warning[badline]; no contents in card: ',
     &                card(1:lcard)
          return
        end if
        contents = card(idelim+1:lcard)
        call ljust(contents)
        lcont = lenr(contents)
        write(*,'(a,1x,a,1x,a)')cod(1:lenr(cod)),delim,contents(1:lcont)

        badline = .false.

        return
      end

