cf ----------------------------------------------------------------------------
cf
cf    INDMDT() function returns the index in the MDT pdf of the point
cf    whose feature bin indices are INDF(NFEAT).
cf
cf    integer function indmdt(indf,nprodp,nfeat,indi,i1mdt,idmdt)
cf
cf ----------------------------------------------------------------------------

      integer function indmdt(indf,nprodp,nfeat,indi,i1mdt,idmdt)
      implicit none
      integer nfeat,i,ind,indval
      integer indf(nfeat), nprodp(nfeat), indi(nfeat), i1mdt(nfeat)
      integer idmdt(nfeat)
c --- indval referes to the (value of feature i in MDT array) - 1
      ind = (indf(indi(1)) - i1mdt(1)) / idmdt(1) + 1
      do  i = 2, nfeat
        indval = (indf(indi(i)) - i1mdt(i)) / idmdt(i)
        ind = ind + nprodp(i)*indval
      end do
c      if (ind .le. 0) then
c         write(*,*) 'IND: ', ind
c         write(*,*) 'NFEAT: ', nfeat
c         write(*,*) 'indf(i): ', (indf(i),i=1,nfeat)
c         write(*,*) 'i1mdt(i): ', (i1mdt(i),i=1,nfeat)
c         write(*,*) 'idmdt(i): ', (idmdt(i),i=1,nfeat)
c         write(*,*) 'nprodp(i): ', (nprodp(i),i=1,nfeat)
c      end if
      indmdt = ind
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    PINDMDT() routine sets variables for faster calculation of the MDT
cf    pdf indices in INDMDT() function.
cf
cf    subroutine pindmdt(nbins,indi,nfeat,nprodp,nelems)
cf
cf ----------------------------------------------------------------------------

c --- for faster evaluation of function indmdt:
c     calling order(i)    = position of a feature i in READ of mdt using indmdt
c                           (in the future)
c     definition order(i) = position of a feature i in WRITE to mdt 
c                           (in the past)
c
c --- Input:
c     nbins(1..nfeat)   ... no. of used bins for features, in calling order
c     indi(1..nfeat)    ... calling order(indi(i)) = definition order(i)
c --- Output:
c     nprodp(1..nfeat)  ... an array for faster indmdt
c     nelems            ... no. of elements in data file if it corresponded
c                           to BIN file ranges
c
      subroutine pindmdt(nbins,indi,nfeat,nprodp,nelems)
        implicit none
        integer i, nfeat
        integer nbins(nfeat), indi(nfeat), nprodp(nfeat), nelems

        nprodp(1) = 1
        do  i = 2, nfeat
          nprodp(i) = nprodp(i-1)*nbins(indi(i-1))
c          nprodp(i) = nprodp(i-1)*ndimen(ifeat2(i-1))
        end do

c ----- number of elements in the full mdt array:
        nelems = nprodp(nfeat)*nbins(indi(nfeat))
 
        return
      end
