cf --------------------------------------------------------------------------
cf
cf    PDBNAM() returnes the PDB atom filename.
cf
cf    subroutine pdbnam(dirpath, code, pdbloc, ipdbfnd, compressed, 
cf   &                  istop, iverbose)
cf
cf ---------------------------------------------------------------------------

      subroutine pdbnam(dirpath,incode,pdbloc,ipdbfnd,compressed,istop,
     &                  iverbose)
        implicit none
        integer mpdbfil
        parameter (mpdbfil = 10000)
        integer mdir
        parameter (mdir=20)
        integer npdbfil, ifindword, lenr, ipos, ipdbfnd, istop, lr
        integer iverbose
        character dirpath*(*), exts*(50)
        character pdbfil(mpdbfil)*(100), pdbcod(mpdbfil)*(5)
        character incode*(*), pdbloc*(*),code*(255)
        logical filexs,compressed
        common /intpdb/ npdbfil
        common /chrpdb/ pdbfil,pdbcod
        data exts /' :.atm:.pdb:.ent:.crd'/

c ----- in case the arguments fname and fulfill are the same variable
        code = incode

        call fullfn(dirpath,incode,exts,pdbloc,ipdbfnd,compressed,0,
     &              iverbose)

        if (ipdbfnd .eq. 0) return

c ----- code is not a full filename, try to find it in the library 
c       of codes:

        ipos = ifindword(code(1:4), pdbcod, npdbfil)

        if (ipos .gt. 0) then
          ipdbfnd = -1
          pdbloc = pdbfil(ipos)
          lr = lenr(pdbloc)

          if (lr .ge. 2) then
            if (pdbloc(lr-1:lr) .eq. '.Z') then
              compressed = .true.
              if (iverbose.gt.0) write(*,'(2a)')
     &          'pdbnam___> trying: ', pdbloc(1:lenr(pdbloc))
              if (filexs(pdbloc)) return
              compressed = .false.
              pdbloc(lr-1:lr) = '  '
              if (iverbose.gt.0) write(*,'(2a)')
     &          'pdbnam___> trying: ', pdbloc(1:lenr(pdbloc))
              if (filexs(pdbloc)) return
            else
              compressed = .false.
              if (iverbose.gt.0) write(*,'(2a)')
     &          'pdbnam___> trying: ', pdbloc(1:lenr(pdbloc))
              if (filexs(pdbloc)) return
              compressed = .true.
              if (iverbose.gt.0) write(*,'(2a)')
     &          'pdbnam___> trying: ', pdbloc(1:lenr(pdbloc))
              call addstr(pdbloc, '.Z')
              if (filexs(pdbloc)) return
            end if
          else
            compressed = .false.
            if (iverbose.gt.0) write(*,'(2a)')
     &        'pdbnam___> trying: ', pdbloc(1:lenr(pdbloc))
            if (filexs(pdbloc)) return
          end if

        end if

        write(*,'(2a/2a/2a)') 
     &  'pdbnam__W> filename for code not found: ',
     &  code(1:lenr(code)),
     &  '           dirs: ', dirpath(1:lenr(dirpath)),
     &  '           exts: ', exts(1:lenr(exts))
        if (istop .eq. 1) stop
        pdbloc = 'file-not-found'
        ipdbfnd = 1

        return
      end




c --- assume: pdbxxxxc.ent, where xxxx is PDB code, and c is an optional
c             chain id.

      subroutine ipdbnam
        implicit none
#include "io.cst"
        integer mpdbfil
        parameter (mpdbfil = 10000)
        integer npdbfil, i, ierr, l, lenr
        character pdbfil(mpdbfil)*(100), pdbcod(mpdbfil)*(5)
        character root*(20),pdblst*(100)
        logical cmpr
        common /intpdb/ npdbfil
        common /chrpdb/ pdbfil,pdbcod

        call getenv('PDBENT', pdblst)
        if (lenr(pdblst).lt.1) then

          write(*,'(a)')
     &      'ipdbnam_W> environment variable PDBENT undefined'
          npdbfil = 0

        else

          call openf4(ioinp,pdblst,'OLD','SEQUENTIAL','FORMATTED',4,
     &                .false.,ierr,cmpr,iolog)

          if (ierr .eq. 0) then
            npdbfil = 1
10          read(ioinp, '(a)', end=100) pdbfil(npdbfil)
              npdbfil = npdbfil + 1
              if(npdbfil.gt.mpdbfil)stop'ipdbnam_E> increase MPDBFIL'
              go to 10
100         continue
            npdbfil = npdbfil - 1
            close(ioinp)
          else
            npdbfil = 0
            write(*,'(a)') '           (do not worry about this one)'
          end if

c ------- get the protein PDB codes from the pdb file list; PDB code is
c         xxxx in pdbxxxx.ent.Z, where pdb may also be missing.
c         xxxx is an arbitrary string at least one character long, and 
c         everything after the first period is arbitrary altogether.
          do  i = 1, npdbfil
            call rootfn2(pdbfil(i), root)
            l = lenr(root)

            if (l.lt.4) then
              write(*,'(2a)') 'ipdbnam_E> PDB name non conforming: ',
     &        pdbfil(i)(1:lenr(pdbfil(i)))
              stop
            end if
 
            if (root(1:3).eq.'pdb') then
              pdbcod(i) = root(4:)
            else
              pdbcod(i) = root
            end if
          end do
        end if

        return
      end
