cf -----------------------------------------------------------------------------
cf
cf   PSA() will return atomic and residue contact (SURFTYP = 1) or
cf   surface (SURFTYP = 2; 3 times the contact area) areas for all 
cf   atoms in X, Y, Z.
cf
cf    subroutine psa(surftyp,probe,step,x,y,z,natm,nres,iatmr1,iattyp,
cf   &               irestyp,atmnam,vdwcnt,nvdwtyp,r,atmacc,resacc)
cf
cf -----------------------------------------------------------------------------

      subroutine psa(surftyp,probe,step,x,y,z,natm,nres,iatmr1,iattyp,
     &               irestyp,atmnam,vdwcnt,nvdwtyp,r,atmacc,resacc)
        implicit none
        integer natm,nres,surftyp,irestyp(nres),iattyp(natm),nvdwtyp
        integer iatmr1(nres),i
        real probe, step, resacc(10,nres),atmacc(natm)
        real x(natm), y(natm), z(natm), r(natm), vdwcnt(nvdwtyp)
        character atmnam(natm)*(*)

        do  i = 1, natm
          r(i) = vdwcnt(iattyp(i))
        end do

        call cnctarea(step,probe,x,y,z,r,natm,atmacc)

        if (surftyp.eq.2) call cntacc(atmacc, natm, r, probe)

        call resarea(surftyp,iatmr1,atmnam,nres,natm,atmacc,irestyp,
     &               resacc)

        return
      end


c --- converts from contact to surface areas (about 3 times larger):
      subroutine cntacc(atmacc, natm, vdwrad, probe_size)
        implicit none
        integer natm, i
        real vdwrad(natm), atmacc(natm), probe_size, dummy

        do  i = 1, natm
          dummy = vdwrad(i) + probe_size
          atmacc(i) = (atmacc(i)*dummy*dummy) / (vdwrad(i)*vdwrad(i))
        end do

        return
      end



      subroutine cnctarea(step,probe,x,y,z,radx,natm,atmacc)
      implicit none
      integer maxats, maxcubes, maxintersect, maxatomscube
      real pi, pix2
      parameter (maxats       = 10000,
     -           maxcubes     = 10000,
     -           maxintersect =  2000,
     -           maxatomscube =   100,
     -           pi           =     3.141592653,
     -           pix2         =     2.0*pi)
      integer inov(maxintersect), tag(maxintersect), cube(maxats), idim
      integer jidim, kjidim, l, j, k, kji, n, io, kk, jj, mkji, nm, m
      integer iatm(maxatomscube,maxcubes),itab(maxcubes),natm,nzp,karc,i
      integer ir,in1
      real x(natm), y(natm), z(natm), radx(natm), atmacc(natm), b
      real rad(maxats), radsq(maxats), rsecr, rsec2r, zres, zgrid
      real arci(maxintersect), arcf(maxintersect), xr, yr, zr, rr
      real dx(maxintersect),dy(maxintersect),d(maxintersect),rsec2n
      real dsq(maxintersect),probe,step,rrx2,rrsq,rsecn,alpha,beta
      real xmin, ymin, zmin, xmax, ymax, zmax, rmax, ti, tf, t, tt
      real parea, area, arcsum
C
C a paralleliped spanned by the molecule is divided into cubes of 2*rmax,
C where RMAX is max (rad atom + probe radius):
C
C
C Various initializations
C
      if (maxats .lt. natm) then
        write(*,'(a)') 'cnctarea_E> too many atoms; increase MAXATS'
        stop
      end if
C
C assign defaults, if not set
C
      if (step .eq. 0.0) then
        step = 0.05
      end if
C
C number of integration layers along z-axis:
C
      nzp=nint(1./step+0.5)
C
      if (probe .eq. 0.0) then
        probe = 1.4
      end if

      xmin= 9999.9
      ymin= 9999.9
      zmin= 9999.9
      xmax=-9999.9
      ymax=-9999.9
      zmax=-9999.9
C
      rmax=0.0
C
      karc=maxintersect
C
C Find bounding box for atoms
C
      do i=1,natm
        rad(i)=radx(i)+probe
        radsq(i)=rad(i)*rad(i)
        if (rad(i) .gt. rmax) rmax=rad(i)
        if (xmin .gt. x(i)) xmin=x(i)
        if (ymin .gt. y(i)) ymin=y(i)
        if (zmin .gt. z(i)) zmin=z(i)
        if (xmax .lt. x(i)) xmax=x(i)
        if (ymax .lt. y(i)) ymax=y(i)
        if (zmax .lt. z(i)) zmax=z(i)
      end do
C
      rmax=rmax*2.0
C
C Cubicals containing the atoms are setup. the dimension of an edge equals
C the radius of the largest atom sphere
C The cubes have a single index
C
      idim=(xmax-xmin)/rmax+1.
      if (idim .lt. 3) then
        idim=3
      end if
      jidim=(ymax-ymin)/rmax+1.
      if (jidim .lt. 3) then
        jidim=3
      end if
      jidim=idim*jidim
      kjidim=(zmax-zmin)/rmax+1.
      if (kjidim .lt. 3) then
        kjidim=3
      end if
      kjidim=jidim*kjidim
C
      if (kjidim.gt.maxcubes) then
        write(*,'(a)') 
     &  'cnctarea_E> too many cubes; increase MAXATS/MAXCUBES'
        stop
      end if
C
C Prepare upto ncube cubes each containing upto MAXATOMSCUBE atoms.
C the cube index is KJI. the number of atoms in each cube is in ITAB;
C the cube index for each atom is in CUBE;
C
      do l=1,maxcubes
        itab(l)=0
      end do
C
      do 4 l=1,natm
        i=(x(l)-xmin)/rmax+1.
        j=(y(l)-ymin)/rmax
        k=(z(l)-zmin)/rmax
        kji=k*jidim+j*idim+i
        n=itab(kji)+1
C
        if (n .gt. maxatomscube) then
          write(*,'(a)')
     &    'cnctarea_E> too many atoms per cube; increase MAXATOMSCUBE'
          stop
        end if
C
        itab(kji)=n
        iatm(n,kji)=l
        cube(l)=kji
4     continue
C
C Process each atom
C
      do 5 ir=1,natm
        kji=cube(ir)
        io=0
        area=0.0
        xr=x(ir)
        yr=y(ir)
        zr=z(ir)
        rr=rad(ir)
        rrx2=rr*2.
        rrsq=radsq(ir)
C
C Find the MKJI cubes neighboring the KJI cube
C
        do 6 kk=1,3
          k=kk-2
          do 6 jj=1,3
            j=jj-2
            do 6 i=1,3
              mkji=kji+k*jidim+j*idim+i  -2
              if (mkji.lt.1) goto 6
              if (mkji.gt.kjidim) goto 14
              nm=itab(mkji)
              if (nm.lt.1) goto 6
C
C Record the atoms in INOV that neighbor atom IR
C
              do 12 m=1,nm
                in1=iatm(m,mkji)
                if (in1 .eq. ir) goto 12
                io=io+1
                if (io.gt.maxintersect) then
                 write(*,'(2a)') 'cnctarea_E> too many intersections; ',
     &                           'increase MAXINTERSECT'
                 stop
                end if
                dx(io)=xr-x(in1)
                dy(io)=yr-y(in1)
                dsq(io)=dx(io)*dx(io)+dy(io)*dy(io)
                d(io)=sqrt(dsq(io))
                inov(io)=in1
12            continue
6     continue
C
14    if (io.ne.0)goto 17
      area=pix2*rrx2
      goto 18
C
C Z resolution determined
C
17    zres=rrx2/nzp
      zgrid=z(ir)-rr-zres/2.
C
C Section atom spheres perpendicular to the z axis
C
      do 9 i=1,nzp
        zgrid=zgrid+zres
C
C Find the radius of the circle of intersection of the IR sphere
c on the current z-plane
C
        rsec2r=rrsq-(zgrid-zr)*(zgrid-zr)
        rsecr=sqrt(rsec2r)
        do 34 k=1,karc
          arci(k)=0.0
34      continue
        karc=0
        do 10 j=1,io
          in1=inov(j)
C
C Find radius of circle locus
C
          rsec2n=radsq(in1)-(zgrid-z(in1))*(zgrid-z(in1))
          if (rsec2n.le.0.0)goto 10
          rsecn=sqrt(rsec2n)
C
C Find intersections of N.circles with IR circles in section
C
          if (d(j).ge.rsecr+rsecn)goto 10
C
C Do the circles intersect, or is one circle completely inside the other?
C
          b=rsecr-rsecn
          if (d(j).gt.abs(b)) goto 20
          if (b.le.0.0) goto 9
          goto 10
C
C If the circles intersect, find the points of intersection
C
20        karc=karc+1
C
          if (karc.ge.maxintersect) then
            write(*,'(a)') 
     &      'cnctarea_E> too many intersections; increase MAXINTERSECT'
            stop
          end if
C
C Initial and final arc endpoints are found for the IR circle intersected
C by a neighboring circle contained in the same plane. the initial endpoint
C of the enclosed arc is stored in arci, and the final arc in arcf
C law of cosines
C
          alpha=acos((dsq(j)+rsec2r-rsec2n)/(2.*d(j)*rsecr))
C
C Alpha is the angle between a line containing a point of intersection and
C the reference circle center and the line containing both circle centers
C
          beta=atan2(dy(j),dx(j))+pi
C
C Beta is the angle between the line containing both circle centers and the
C x-axis
C
          ti=beta-alpha
          tf=beta+alpha
          if (ti.lt.0.0)ti=ti+pix2
          if (tf.gt.pix2)tf=tf-pix2
          arci(karc)=ti
          if (tf.ge.ti) goto 3
C
C If the arc crosses zero, then it is broken into two segments.
C the first ends at PIX2 and the second begins at zero
C
          arcf(karc)=pix2
          karc=karc+1
    3     arcf(karc)=tf
10    continue
C
C Find the atmaccible contact surface area for the sphere IR on
C this section
C
      if (karc.ne.0) goto 19
      arcsum=pix2
      goto 25
C
C The arc endpoints are sorted on the value of the initial arc endpoint
19    call sortag(arci,karc,tag)
C
C Calculate the atmaccible area
C
      arcsum=arci(1)
      t=arcf(tag(1))
      if (karc.eq.1) goto 11
      do 27 k=2,karc
      if (t.lt.arci(k))arcsum=arcsum+arci(k)-t
      tt=arcf(tag(k))
      if (tt.gt.t) t=tt
27    continue
11    arcsum=arcsum+pix2-t
C
C The area/radius is equal to the atmaccible arc length X the section thickness.
C
25    parea=arcsum*zres
C
C Add the atmaccible area for this atom in this section to the area for this
C atom for all the section encountered thus far
C
      area=area+parea

9     continue
C
C Scale to VDW shell
C
18    atmacc(ir)=area*(rr-probe)*(rr-probe)/rr
C
5     continue
C
      return
      end



      subroutine resarea(surftyp,iatmr1,atmnam,nres,natm,atmacc,irestyp,
     &                   resacc)
c
c CALCULATE ABSOLUTE AND PERCENTAGE ACCESSIBILITIES FOR:
c                     WHOLE RESIDUE
c                     NON POLAR SIDECHAIN ATOMS (INCLUDING CA)
c                     POLAR SIDECHAIN ATOMS
c                     TOTAL SIDECHAIN ATOMS
c                     TOTAL MAINCHAIN ATOMS (EXCLUDING CA)
c
c SUMMATION FOR SIDE CHAIN INCLUDES CA: GLY THEN HAS A SIDECHAIN AND THERE
c IS NO SPECIAL CASE.
c
      implicit none
      integer nrt
      parameter (nrt=20)
      integer natm,nres,iatmr1(nres), iatmr2, surftyp, imnch, iat, i
      integer irestyp(nres), ires, ipolsdch, k , ityp, indtyp(nrt)
      real resacc(10,nres),atmacc(natm), percentage
      real atotal(nrt,2), amain(nrt,2), aside(nrt,2)
      real apolside(nrt,2), anpolside(nrt,2)
      character atmnam(natm)*(*)
      data indtyp /1,5,4,7,14,8,9,10,12,11,13,3,15,6,2,16,17,20,18,19/
    
C
C --- New standard accessibilities by Simon Hubbard (Dec. 1989) ------------

c
c     1     2     3     4     5     6     7     8     9     10
c    'ALA','ARG','ASN','ASP','CYS','GLN','GLU','GLY','HIS','ILE',
c    'LEU','LYS','MET','PHE','PRO','SER','THR','TRP','TYR','VAL'
c

C
C TOTAL CONTACT AREA IN FULLY EXTENDED open CHAIN FORM
C
      data (atotal(i,1),i=1,nrt)/ 33.27, 72.58, 40.91, 39.38, 41.90,
     &                            51.60, 48.53, 23.75, 54.98, 55.52,
     &                            56.53, 61.45, 61.86, 60.81, 44.58,
     &                            33.77, 41.85, 75.22, 62.17, 47.71/
C
C TOTAL ACCESSIBLE SURFACE AREA IN FULLY EXTENDED open CHAIN FORM
C
      data (atotal(i,2),i=1,nrt)/109.19,243.03,144.93,141.31,136.20,
     &                           180.60,174.46, 81.20,183.87,177.22,
     &                           180.35,204.10,197.05,199.73,140.92,
     &                           118.24,142.04,248.09,212.29,153.33/
C
C TOTAL NON POLAR AREA OF SIDECHAIN IN EXTENDED FORM (INCLUDING CA)
C
      data (anpolside(i,1),i=1,nrt)/ 23.16, 25.92, 14.56, 15.95, 31.96,
     &                               17.00, 19.75, 10.84, 30.43, 45.71,
     &                               46.61, 38.72, 51.94, 51.54, 39.28,
     &                               15.76, 24.92, 58.15, 42.35, 37.89/
C
C TOTAL NON-POLAR ACCESSIBLE SURFACE AREA OF SIDECHAIN IN EXTENDED
C FORM (INCLUDING CA)
C
      data (anpolside(i,2),i=1,nrt)/ 70.81, 79.70, 45.01, 49.50, 98.3,
     &                               52.53, 61.20, 33.14, 96.38,139.76,
     &                              142.52,118.39,159.23,164.49,120.12,
     &                               48.19, 76.21,185.88,134.89,115.87/
C
C TOTAL POLAR AREA OF SIDE CHAIN IN EXTENDED CONFORMATION
C
      data (apolside(i,1),i=1,nrt)/   0.0, 36.74, 16.38, 13.44,  0.0,
     &                              24.68, 18.86,   0.0, 15.18,  0.0,
     &                                0.0, 12.81,   0.0,   0.0,  0.0,
     &                               7.86,  7.01,  6.93, 10.56,  0.0/
C
C TOTAL POLAR ACCESSIBLE SURFACE AREA OF SIDECHAIN IN EXTENDED CONFORM
C
      data (apolside(i,2),i=1,nrt)/ 0.00,125.54, 61.88, 53.78,   0.0,
     &                             90.25, 75.42,   0.0, 51.88,   0.0,
     &                               0.0, 47.88,   0.0,  0.00,  0.00,
     &                             31.44, 28.04, 23.69, 42.22,  0.00/
C
C TOTAL SIDE CHAIN AREA (INCLUDING CA)
C
      data (aside(i,1),i=1,nrt)/23.16,62.66,30.93,29.40,31.96,
     &                          41.67,38.61,10.84,45.61,45.71,
     &                          46.61,51.53,51.94,51.54,39.28,
     &                          23.62,31.93,65.08,52.91,37.89/
C
C TOTAL SIDE CHAIN ACCESSIBLE SURFACE AREA (INCLUDING CA)
C
      data (aside(i,2),i=1,nrt)/ 70.81,205.23,106.90,103.28, 98.3,
     &                          142.78,136.63, 33.14,148.25,139.76,
     &                          142.52,166.28,159.23,164.49,120.12,
     &                           79.63,104.24,209.56,177.11,115.87/
C
C MAIN CHAIN AREAS IN EXTENDED FORM (NOT INCLUDING CA)
C
      data (amain(i,1),i=1,nrt)/10.11, 9.92, 9.98, 9.98, 9.94,
     &                           9.92, 9.92,12.91, 9.37, 9.81,
     &                           9.92, 9.92, 9.92, 9.28, 5.29,
     &                          10.15, 9.92,10.14, 9.26, 9.82/
C
C MAIN CHAIN ACCESSIBLE SURFACE AREA IN EXTENDED FORM (NOT INCLUDING CA)
C
      data (amain(i,2),i=1,nrt)/38.38,37.83,38.03,38.03,37.90,
     &                          37.83,37.83,48.06,35.62,37.45,
     &                          37.83,37.83,37.83,35.24,20.80,
     &                          38.61,37.80,38.53,35.18,37.46/
C
C    -----------------------------------------------------------------------
 
      do  ires = 1, nres
 
c c ----- is the current residue one of the 20 standard residue types (ASX,
c c       and GLX are used as ASN, and GLN respectively):

        do k=1, 10
          resacc(k,ires)=0.0
        end do

        if (irestyp(ires).le.nrt .and. irestyp(ires).ge.1) then
          ityp=indtyp(irestyp(ires))

c ------- add an area of each atom to the appropriate bin:
 
          do iat=iatmr1(ires), iatmr2(iatmr1,nres,natm,ires)
            if (imnch(atmnam(iat)) .gt. 0) then
 
c ------------- it is a main chain atom:
 
                resacc(9,ires)=resacc(9,ires)+atmacc(iat)
                resacc(1,ires)=resacc(1,ires)+atmacc(iat)
            else
              if (ipolsdch(atmnam(iat)) .gt. 0) then
 
c ------------- it is a polar side chain atom:
 
                resacc(7,ires)=resacc(7,ires)+atmacc(iat)
                resacc(5,ires)=resacc(5,ires)+atmacc(iat)
                resacc(1,ires)=resacc(1,ires)+atmacc(iat)
              else
 
c ------------- it must be a non-polar side chain atom then:
 
                resacc(7,ires)=resacc(7,ires)+atmacc(iat)
                resacc(3,ires)=resacc(3,ires)+atmacc(iat)
                resacc(1,ires)=resacc(1,ires)+atmacc(iat)
              end if
            end if
          end do
 
c ------  get the percentages of contact areas for this residue:
 
          resacc( 2,ires)=percentage(resacc(1,ires),
     &                               atotal(ityp,surftyp))
          resacc( 4,ires)=percentage(resacc(3,ires),
     &                               anpolside(ityp,surftyp))
          resacc( 6,ires)=percentage(resacc(5,ires),
     &                               apolside(ityp,surftyp))
          resacc( 8,ires)=percentage(resacc(7,ires),
     &                               aside(ityp,surftyp))
          resacc(10,ires)=percentage(resacc(9,ires),
     &                               amain(ityp,surftyp))
        end if
      end do
 
      return
      end



      integer function ipolsdch(atmnam)
      implicit none
      integer np
      parameter (np=19)
      integer i, ifind2word
      character polatm(np)*(4), atmnam*(*)
      data (polatm(i),i=1,np) /'AD1', 'AD2', 'AE1', 'AE2',
     &                         'ND1', 'ND2', 'NE',  'NE1',
     &                         'NE2', 'NH1', 'NH2', 'NZ',
     &                         'OD1', 'OD2', 'OE1', 'OE2',
     &                         'OG',  'OG1', 'OH '/

      ipolsdch = ifind2word(atmnam, polatm, np) 
 
      return
      end



      real function percentage(x,y)
      implicit none
      real x, y

      if (y.gt.1.0E-6) then
        percentage = 100.0 * x/y
      else
        percentage = 0.0
      end if

      return
      end



      integer function imnch(atmnam)
        implicit none
        integer nm
        parameter (nm=3)
        integer i, ifind2word
        character atmnam*(*), mnchatm(nm)*(4)
        data (mnchatm(i),i=1,nm) /'N', 'C', 'O'/

        imnch = ifind2word(atmnam, mnchatm, nm)

        return
      end



      subroutine wrpsa(ioout,iolog,outfile,resacc,nres,resnum,resnam,
     &                 probe,step,surftyp)
      implicit none
      integer nres, i, surftyp, ioout, j, ierr, iolog
      real resacc(10,nres), probe, step
      character resnum(nres)*(*), resnam(nres)*(*), outfile*(*)
      logical cmpr
C
C   OUTPUT TO FILE; COLUMNS FORMAT:
C   1. # or ACCESS          : (A6),1X
C   2. RESIDUE NUMBER       : (A5),2X
C   3. RESIDUE TYPE         : (A3),1X,A1,1X
C   4. ALL ATOMS            : SUM (F5.2); PERCENTAGE (F5.1),2X
C   5. NON POLAR SIDE CHAINS: the same
C   6. POLAR SIDE CHAINS    : the same
C   7. TOTAL SIDE CHAIN     : the same
C   8. MAIN CHAIN           : the same
C
      call openf4(ioout,outfile,'UNKNOWN','SEQUENTIAL','FORMATTED',3,
     &            .true.,ierr,cmpr,iolog)
 
      write (ioout,'(''# produced by MODELLER'')')
      write (ioout,'(''#'')')
      write (ioout,'(''# File of summed (Sum) and % (per.)'',
     +            '' accessibilities'')')
      write (ioout,'(''# probe radius       : '',F7.3)') probe
      write (ioout,'(''# integration step   : '',F7.3)') step
      write (ioout,'(''# water included     : ?'')')
      write (ioout,'(''# hetatom included   : ?'')')
      if (surftyp.eq.2) then
        write (ioout,'(''# accessibility type : SURFACE'')')
      else
        write (ioout,'(''# accessibility type : CONTACT'')')
      end if
      write (ioout,'(''# number of residues : '',I7)') nres
      write (ioout,'(''#'')')
      write (ioout,'(''#       Res   Res   All atoms   Non P side'',
     +            ''  Polar Side  Total Side  Main Chain'')')
      write (ioout,'(''#       Num  type    Sum  Per.   Sum  Per.'',
     +            ''   Sum  Per.   Sum  Per.   Sum  Per.'')')
 
      do i = 1, nres
        write(ioout,'(a,a5,2x,a,1x,f6.2,f5.1,4(1x,f6.2,f5.1))') 
     &        'ACCESS ', resnum(i), resnam(i), (resacc(j,i),j=1,10)
      end do
 
      close (ioout)
 
      return
      end



      subroutine sortag(a,n,tag)
C
      integer tag, tg, i, j, ij, k, n, m, l, il(16), iu(16)
      dimension a(n), tag(n)
C
      do i=1,n
        tag(i)=i
      end do
      m=1
      i=1
      j=n

 5    if (i .ge. j) then
        go to 70
      end if
C
 10   k=i
      ij=(j+i)/2
      t=a(ij)
      if (a(i) .le. t) then
        go to 20
      end if
C
      a(ij)= a(i)
      a(i)=t
      t=a(ij)
      tg=tag(ij)
      tag(ij)=tag(i)
      tag(i)=tg
 20   l=j
      if (a(j) .ge. t) then
         go to 40
      end if
C
      a(ij)=a(j)
      a(j)=t
      t=a(ij)
      tg=tag(ij)
      tag(ij)=tag(j)
      tag(j)=tg
      if (a(i) .le. t) then
         go to 40
      end if
C
      a(ij)=a(i)
      a(i)=t
      t=a(ij)
      tg=tag(ij)
      tag(ij)=tag(i)
      tag(i)=tg
      go to 40
C
 30   a(l)=a(k)
      a(k)=tt
      tg=tag(l)
      tag(l)=tag(k)
      tag(k)=tg
C
 40   l=l-1
      if (a(l) .gt. t) then
         go to 40
      end if
      tt=a(l)
C
 50   k=k+1
      if (a(k) .lt. t) then
         go to 50
      end if
      if (k .le. l) then
         go to 30
      end if
      if (l-i .le. j-k) then
         go to 60
      end if
      il(m)=i
      iu(m)=l
      i=k
      m=m+1
      go to 80
C
 60   il(m)=k
      iu(m)=j
      j=l
      m=m+1
      go to 80
C
 70   m=m-1
      if (m .eq. 0) return
      i=il(m)
      j=iu(m)
C
 80   if (j-i .ge. 1) go to 10
      if (i .eq. 1) go to 5
      i=i-1
C
 90   i=i+1
      if (i .eq. j) go to 70
      t=a(i+1)
      if (a(i) .le. t) go to 90
      tg=tag(i+1)
      k=i
C
 100  a(k+1)=a(k)
      tag(k+1)=tag(k)
      k=k-1
      if (t .lt. a(k)) go to 100
      a(k+1)=t
      tag(k+1)=tg
      go to 90
C
      end


      subroutine wrsol(ioout,iolog,outfile,resnum,resnam,nres,atmnam,
     &           natm,iresatm,chain,atmacc,r,x,y,z,probe,step,surftyp)
        implicit none
        integer natm, iolog
        integer nres, i, surftyp, ioout, ierr, iresatm(natm)
        real atmacc(natm), probe, step, x(natm), y(natm), z(natm)
        real r(natm)
        character resnum(nres)*(*), resnam(nres)*(*), outfile*(*)
        character atmnam(natm)*(*), chain(nres)*(*)
        logical cmpr
 
        call openf4(ioout,outfile,'UNKNOWN','SEQUENTIAL','FORMATTED',
     &              3,.true.,ierr,cmpr,iolog)
 
        write (ioout,'(''# produced by MODELLER'')')
        write (ioout,'(''#'')')
        write (ioout,'(''# File of atomic accessibilities'')')
        write (ioout,'(''# probe radius       : '',F7.3)') probe
        write (ioout,'(''# integration step   : '',F7.3)') step
        write (ioout,'(''# water included     : ?'')')
        write (ioout,'(''# hetatom included   : ?'')')
        if (surftyp.eq.2) then
          write (ioout,'(''# accessibility type : SURFACE'')')
        else
          write (ioout,'(''# accessibility type : CONTACT'')')
        end if
        write (ioout,'(''# number of residues : '',I7)') nres

        do  i = 1, natm
          write(ioout,15) 'ATOM  ',i,atmnam(i),' ',resnam(iresatm(i)),
     &          chain(iresatm(i)),resnum(iresatm(i)),x(i),y(i),z(i),
     &          r(i), atmacc(i)
15        format(a6,i5,1x,a4,a1,a3,1x,a1,a5,3x,3f8.3,2x,2f8.3)
        end do
        close(ioout)

        return
      end
