cf ----------------------------------------------------------------------------
cf
cf    RDMDT() reads the MDT pdf data file.
cf
cf    subroutine rdmdt(ioinp, iolog, mdtfil, rmdt, ndimen, ifeat, nfeat, 
cf   -                 nelems, maxelems, mfeatcorr, pdfmdt, i1mdt, 
cf   -                 i2mdt, idmdt, formin, nalns, nprots, naprots,
cf   -                 rnpoints, featnam)
cf
cf ----------------------------------------------------------------------------

      subroutine rdmdt(ioinp, iolog, mdtfil, rmdt, ndimen, ifeat, nfeat, 
     &                 nelems, maxelems, mfeatcorr, pdfmdt, i1mdt, 
     &                 i2mdt, idmdt, formin, nalns, nprots, naprots,
     &                 rnpoints, featnam)
        implicit none
        integer nalns, nprots, naprots, ioerr, iolog
        integer ioinp,nfeat,nelems,maxelems,mfeatcorr,i,j
        integer ndimen(mfeatcorr), ifeat(mfeatcorr)
        integer i1mdt(mfeatcorr), i2mdt(mfeatcorr), idmdt(mfeatcorr)
        real rmdt(maxelems),rnpnts2, rnpoints
        character line*80, mdtfil*(*), formin*(*)
        character featnam(mfeatcorr)*(*), formin2*(20)
        logical pdfmdt, fake,cmpr

        formin2 = formin
        call upper(formin2)

        call openf4(ioinp,mdtfil,'OLD','SEQUENTIAL',formin2,3,.true.,
     &              ioerr,cmpr,iolog)

c ----- set the dummy default values for i1mdt ..., which will be later 
c       converted to true default values when other information is available
c ----- (this is only to allow for absence of these values in older 
c        (formatted) MDT files)
        do  i = 1, mfeatcorr
          i1mdt(i) = 0 
          i2mdt(i) = 0
          idmdt(i) = 0
        end do

        if (formin2 .eq. 'FORMATTED') then
      
c ------- do: 
c           read a line, identify it, do the appropriate actions; 
c         until no more lines;
c
10        read(ioinp, '(a)', end=100)line

c --------- this is to allow specification of dimensions for MDT restraints
c           that are expressed as analytic functions (CA-CA distance, ...),
c           not as relative frequency tables; used by MODELLER, not by MDT 
c           and PLOT.
            if (index(line, 'OUTPUT OF PROGRAM:').gt.0) 
     &        fake = (index(line, 'FAKE') .gt. 0)

            if (line .eq. '  #  FEATURE NBINS NAME') then
              nfeat = 0
25            read(ioinp, '(a)', err=999) line
                if (line(1:6) .eq. '      ') go to 10
                nfeat = nfeat + 1
                if (nfeat.gt.mfeatcorr) 
     &            stop 'rdmdt____E> increase MFEATCORR'
                read(line, '(6x,2i6,1x,a60)', err=999) 
     &               ifeat(nfeat), ndimen(nfeat), featnam(nfeat)
              go to 25
            end if

c --------- The indices here specify the subset of the full range of feature 
c           values (specified in BIN file) that are actually present in 
c           the mdt array in this file; these i1mdt & i2mdt have to be used
c           in function indmdt when accessing the mdt array
c
c --------- This part of the file may not be present in older MDT files:
            if (line.eq.'  # ISTART   IEND  ISTEP  NBINS') then
              do  i = 1, nfeat
                read(ioinp, *, err=999) j, i1mdt(i), i2mdt(i), idmdt(i)
              end do
            end if

            if (index(line,'Number of alignments').gt.0) then
              read(line(45:), '(i10)', err=999) nalns
              read(ioinp, '(45x,i10)', err=999) nprots
              read(ioinp, '(45x,i10)', err=999) naprots
              read(ioinp, '(45x,f10.0)', err=999) rnpoints
              read(ioinp, '(45x,f10.0)', err=999) rnpnts2
              if(rnpoints.ne.rnpnts2) 
     &          write(*,'(a,2f15.2)') 'rdmdt___W> rnpoints<>rnpnts2: ',
     &          rnpoints,rnpnts2
            end if

            if (index(line, 'MDT TABLE START:').gt.0) then
              read(line(17:), '(i9)', err=999) nelems
              if (.not. fake) then
                if (nelems .gt. maxelems) 
     &             stop 'ERROR[rdmdt]: too many elems in MDT.'
                do  i = 1, nelems
                  read(ioinp, *, err=999) rmdt(i)
                end do
              end if
            end if

            if (index(line, 'MDT TABLE END:').gt.0) 
     &        pdfmdt = index(line, 'PDF') .gt. 0

          go to 10

100       continue

        else

          read(ioinp, err=999) fake
          read(ioinp, err=999) nfeat
          do  i = 1, nfeat
            read(ioinp, err=999) j,ifeat(i),ndimen(i),featnam(i)
          end do
          do  i = 1, nfeat
            read(ioinp, err=999) j, i1mdt(i), i2mdt(i), idmdt(i)
          end do
          read(ioinp, err=999) nalns, nprots,naprots,rnpoints,rnpnts2
          if (rnpoints.ne.rnpnts2) stop 'rdmdt___E> rnpoints<>rnpnts2'
          read(ioinp, err=999) nelems
          if (.not. fake) then
            if (nelems .gt. maxelems) 
     &         stop 'ERROR[rdmdt]: too many elems in MDT.'
            read(ioinp, err=999) (rmdt(i),i=1,nelems)
          end if
          read(ioinp, err=999) pdfmdt

        end if

        close(ioinp)
        return

999     close(ioinp)
        write(*,*)'rdmdt__E> reading file: ',mdtfil
        stop
      end




cf ----------------------------------------------------------------------------
cf
cf    WRMDT() write the MDT pdf to a file. 
cf
cf    Not to be used in MDT1.F because of the different meaning of ifeat() in
cf    PLOT/GETCSR/MODELLER as compared to MDT. To be used for writing out
cf    the MDT table when rdmdt() was used to read it in.
cf
cf    subroutine wrmdt(ioout, iolog, mdtfil, rmdt, ndimen, ifeat, nfeat, 
cf   -                 nelems, maxelems, mfeatcorr, pdfmdt, i1mdt, 
cf   -                 i2mdt, idmdt, formout, nalns, nprots, naprots,
cf   -                 rnpoints, featnam)
cf
cf ----------------------------------------------------------------------------


      subroutine wrmdt(ioout, iolog, mdtfil, rmdt, ndimen, ifeat, nfeat, 
     &                 nelems, maxelems, mfeatcorr, pdfmdt, i1mdt, 
     &                 i2mdt, idmdt, formout, nalns, nprots, naprots,
     &                 rnpoints, featnam)
        implicit none
        integer nalns, nprots, naprots, ioerr, iolog
        integer ioout,nfeat,nelems,maxelems,mfeatcorr,i
        integer ndimen(mfeatcorr), ifeat(mfeatcorr), nb
        integer i1mdt(mfeatcorr), i2mdt(mfeatcorr), idmdt(mfeatcorr)
        real rmdt(maxelems),rnpoints
        character mdtfil*(*), formout*(*), formout2*(20)
        character featnam(mfeatcorr)*(*)
        logical pdfmdt,cmpr

        formout2 = formout
        call upper(formout2)

        call openf4(ioout,mdtfil,'UNKNOWN','SEQUENTIAL',formout2,
     &              3,.true.,ioerr,cmpr,iolog)

        if  (formout2 .eq. 'FORMATTED') then

          write(ioout, 10) 
10        format('REAL OUTPUT OF PROGRAM:  ** PLOT1.F **' ///
     &           'FEATURES TABULATED IN THIS MULTIDIMENSIONAL ',
     &           'TABLE:' // '  #  FEATURE NBINS NAME' )
          do  i = 1, nfeat
            write(ioout, '(i3, 3x, i6, i6, 1x, a60)')
     &             i, ifeat(i), ndimen(i), featnam(i)
          end do

          write(ioout, 16)
16        format(//,'SUBSET OF VALUES (WITH RESPECT TO THE BIN FILE)'/
     &'THAT ARE ACTUALLY PRESENT IN THIS FILE (first index rolls frst):'
     &      // '  # ISTART   IEND  ISTEP  NBINS')
          do  i = 1, nfeat
            nb = (i2mdt(i)-i1mdt(i) + idmdt(i)) / max(idmdt(i),1)
            write(ioout, '(i3,5i7)')i,i1mdt(i),i2mdt(i),idmdt(i),nb
          end do

          write(ioout, 25) nalns,nprots,naprots,nint(rnpoints),
     &                     nint(rnpoints)
25        format(///'Number of alignments                      : ',i10/
     &           'Number of proteins in the alignments      : ', i10/
     &           'Number of analysed proteins or their pairs: ', i10/
     &           'Number of data points                     : ', i10/
     &           'Number of data points (check)             : ', i10//)
          write(ioout, '(// a16, i9)') 'MDT TABLE START:', nelems
          do  i = 1, nelems
            write(ioout, '(f9.0)') rmdt(i)
          end do
          if (pdfmdt) then
            write(ioout, '(a)') 'MDT TABLE END:PDF'
          else
            write(ioout, '(a)') 'MDT TABLE END:FREQUENCY'
          end if

        else

          write(ioout) .false.
          write(ioout) nfeat
          do  i = 1, nfeat
            write(ioout) i, ifeat(i), ndimen(i), featnam(i)
          end do
          do  i = 1, nfeat
            nb = (i2mdt(i)-i1mdt(i) + idmdt(i)) / max(idmdt(i),1)
            write(ioout) i, i1mdt(i), i2mdt(i), idmdt(i), nb
          end do
          write(ioout) nalns, nprots, naprots, rnpoints, rnpoints
          write(ioout) nelems
          write(ioout) (rmdt(i),i=1,nelems)
          write(ioout) pdfmdt

        end if

        close(ioout)
        return

      end
