cf ----------------------------------------------------------------------------
cf
cf    RDPDB() reads a compressed/uncompressed Brookhaven Protein Databank file.
cf
cf    Input:
cf      IOINP     ... I/O input stream ;
cf      BRKNAME   ... file name of a compressed or uncompressed PDB file;
cf      MAXATM    ... maximal number of atoms ;
cf      MAXRES    ... maximal number of residues ;
cf      WATER     ... true, if water to be read in
cf      HETATM    ... true, if HETATMS to be read in
cf      HYDROGEN  ... true, if H atoms to be read in
cf      RNG(2)    ... residue numbers of the first and last residue of a
cf                    segment to read in
cf      CHNRNG(2) ... chain id's of the first and last residue to read in
cf
cf    Output:
cf      NATM      ... number of atoms ;
cf      NRES      ... number of residues ;
cf      RESNAM()  ... vector of residue names (A3);
cf      RESNUM()  ... vector of residue numbers (A5 - 5. ch. is insertion code)
cf      ATMNAM()  ... vector of atom names (A4)
cf      IATMR1(I) ... index of the 1. atom in the I-th resiude ;
cf      IRESATM(I)... residue index of each atom;
cf      CHAIN(I)  ... chain id of residue I
cf      HEADER    ... PDB file header
cf      BISO(i)   ... isotropic temperature factor for each atom
cf      X,Y,Z     ... coordinate vectors ;
cf
cf    Read all atoms no matter what residue they are comming from, except for:
cf    1. B positions for double occupancy atoms.
cf    2. Atoms from water residues when the WATER flag is set to false
cf       (irrespective of whether water occurs in an ATOM or HETATM record).
cf    3. HETATM atoms when the HETATM flag is set to false,
cf       except when they are waters and WATER is true.
cf    4. No hydrogens, when hydrogen=.false.
cf
cf
cf ............................................................................
cf
cf       rdpdb() definitions for the calling routine:
cf
cf       integer maxres, ioinp, maxatm
cf       parameter (maxres=5000,maxatm=15*maxres,ioinp=11)
cf
cf       integer ierr,iresatm(maxatm)
cf       integer natm,nres,iatmr1(maxres)
cf       real x(maxatm),y(maxatm),z(maxatm),biso(maxatm)
cf       character rng(2)*(5),chnrng(2)*(1),header*(80)
cf       character chain(maxres)*(1),atmnam(maxatm)*(4)
cf       character resnam(maxres)*(3),resnum(maxres)*(5)
cf       character brkname*(255)
cf       logical hetatm,water,hydrogen,ishydrogen
cf
cf       data hetatm,water,hydrogen /.false.,.false.,.false./
cf       data rng,chnrng /'@','X','@','X'/
cf
cf ............................................................................
cf
cf    subroutine rdpdb(ioinp,iolog,brkname,water,hetatm,hydrogen,x,y,z,
cf   &           maxatm,maxres,natm,nres,resnam,resnum,atmnam,iatmr1,
cf   &           chain,header,rng,chnrng,iresatm,biso,ierr,iress1,iress2,
cf   &           maxseg,nsegm)
cf
cf ----------------------------------------------------------------------------

      subroutine rdpdb(ioinp,iolog,brkname,water,hetatm,hydrogen,x,y,z,
     &           maxatm,maxres,natm,nres,resnam,resnum,atmnam,iatmr1,
     &           chain,header,rng,chnrng,iresatm,biso,ierr,iress1,
     &           iress2,maxseg,nsegm)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')

cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CST constants define the parameters for the residue type
cf      transformations.
cf
cf      mrestyp = 100   ... maximal number of residue types
cf      mfield  =  20   ... maximal number of characters for all the synonyms
cf                          of a PDB residue name
cf      gapsym  ='GAP'  ... 3-char PDB code for a gap
cf      glysym  ='GLY'  ... 3-char PDB code for a glycine
cf      watsym  ='WAT'  ... 3-char PDB code for a water residue
cf      cyssym  ='CYS'  ... 3-char PDB code for a cysteine/cystine residue
cf      prosym  ='PRO'  ... 3-char PDB code for a proline residue
cf      brksym  ='BRK'  ... 3-char PDB code for a chain break
cf      blksym  ='BLK'  ... 3-char PDB code for a residue block
cf      norid   ='X'    ... 1-char id for no residue id
cf      anyrid  ='@'    ... 1-char id for any residue id
cf
cf ----------------------------------------------------------------------------

        integer mrestyp, mfield
        parameter (mrestyp = 100, mfield = 20)

        character gapsym*(3), watsym*(3), cyssym*(3), prosym*(3)
        character brksym*(3), glysym*(3), blksym*(3)
        character norid*(1), anyrid*(1)
        parameter (gapsym='GAP',watsym='WAT',cyssym='CYS',prosym='PRO')
        parameter (brksym='BRK',glysym='GLY',blksym='BLK')
        parameter (norid='X',anyrid='@')

      integer lenf

c --- Maximal length of a filename:
      parameter (lenf = 128)


cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CMN common blocks define the variables used in translating
cf      residue types. A programming note: all the libraries and data 
cf      structures that contain information for the different residue
cf      types should be isomorphous with the CHARMM residue type
cf      vector. More precisely, the data in the files may be given in
cf      any order, specifying CHARMM residue types that they refer
cf      to, and the library reading routine should then place the
cf      input items into the arrays in the correct order reflecting
cf      the ordering in the reslib.lib file and obtained with
cf      the routines in the residues.f. If the data for a certain
cf      residue type are not in the data file this should also be
cf      reflected without crashing the program later on.
cf
cf ----------------------------------------------------------------------------

        integer nrestyp, igaptyp, iwattyp, icystyp, iprotyp, ibrktyp
        integer iglytyp, iblktyp
        character chmres(mrestyp)*(4), modres(mrestyp)*(1)
        character brkres(mrestyp)*(mfield),resfnam*(128)
        common /ireslib/ nrestyp,igaptyp,iwattyp,icystyp,iprotyp,
     &                   ibrktyp,iglytyp,iblktyp
        common /creslib/ chmres,modres,brkres,resfnam

c ----------------------------------------------------------------------------
c ----- rdpdb() definitions for the passed variables:
        integer maxseg,nsegm,iress1(maxseg),iress2(maxseg)
        integer maxres,natm,nres,iatmr1(maxres)
        integer ioinp,maxatm,iolog
        integer ierr,iresatm(maxatm)
        real x(maxatm),y(maxatm),z(maxatm),biso(maxatm)
        character rng(2)*(*),chnrng(2)*(*),header*(*)
        character chain(maxres)*(*),atmnam(maxatm)*(*)
        character resnam(maxres)*(*),resnum(maxres)*(*)
        character brkname*(*)
        logical hetatm,water,hydrogen,ishydrogen,ter,reseqv1
c ----------------------------------------------------------------------------

c ----- local variables
        character oldnum*5,newnum*5,newnam*3
        character card*80, newid*(1), oldid*(1)
        character atnumb*(5), oldnam*(3)
        logical p,compressed,inrange,pdblin
        external pdblin

        call openf4(ioinp,brkname,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .false.,ierr,compressed,iolog)

        if (ierr .gt. 0) then
          ierr = 1
          return
        end if

        natm = 0
        nres = 0
        oldnum = '%%%%%'
        oldnam = '%%%'
        oldid = '%'
        inrange = .false.
        nsegm = 1
        iress1(1) = 1
        ter = .false.

5       continue
          read(ioinp, '(a80)', end=20, err=300)card

          if (card(1:6) .eq. 'TER   ') ter = .true.

          if (card(1:6) .eq. 'HEADER') header=card

          p = pdblin(card(1:6),card(18:20),card(17:17),card(13:16),
     &               water,hydrogen,hetatm,iwattyp)

          if (p) then
            natm = natm + 1
            if (natm .gt. maxatm) then
              ierr = 2
              write(*,'(a)') 'rdpdb___E> too many atoms'
              go to 500
            end if
            read(card, 15) atnumb, atmnam(natm), newnam, newid,
     &           newnum, x(natm), y(natm), z(natm), biso(natm)
15          format(6x,a5,1x,a4,1x,a3,1x,a1,a5,3x,3f8.3,6x,f6.2)

c --------- convert QUANTA undefined to MODELLER undefined:
            if ((x(natm) .eq. 9999.) .or. (y(natm) .eq. 9999.) .or.
     &          (z(natm) .eq. 9999.)) then
              x(natm) = nundf
              y(natm) = nundf
              z(natm) = nundf
              write(*,'(a/a)')
     &          'rdpdb___W> undefined coordinates: ', card
              stop
            end if

            call ljust(atmnam(natm))
            newnam = card(18:20)

            if(reseqv1(newnum,newid,rng(1),chnrng(1)))inrange=.true.

            if (inrange) then
              if ((newnum.ne.oldnum) .or. (newnam.ne.oldnam)) then
                if (reseqv1(oldnum,oldid,rng(2),chnrng(2))) then
                  natm = natm - 1
                  go to 20
                end if
                nres = nres + 1
                if (nres .gt. maxres) then
                  ierr = 3
                  write(*,'(a)') 'rdpdb___E> too many residues'
                  go to 500
                end if
                chain(nres) = newid
                resnam(nres) = newnam
                resnum(nres) = newnum
                oldnum = newnum
                oldnam = newnam
                oldid  = newid
                iatmr1(nres) = natm
c ------------- was previous record TER
                if (ter .and. nres.gt.1) then
                  iress2(nsegm) = nres-1
                  nsegm = nsegm + 1
                  if (nsegm .gt. maxseg)
     &              stop 'rdpdb___E> increase MAXSEG'
                  iress1(nsegm) = nres
                end if
              end if
              iresatm(natm) = nres
            else
              natm = natm - 1
            end if

            ter = .false.
          end if
          go to 5
20      continue
        close(ioinp)
        iress2(nsegm) = nres

        if (natm .gt. 0) then
          ierr = 0
        else
          ierr = 4
          write(*,'(a/a/a/a,1x,a,1x,a)')
     &    'rdpdb___E> no atoms read from the input PDB file;',
     &    '  probably because segment specified incorrectly in',
     &    '  the alignment file or in MODEL_SEGMENT;',
     &    '  beginning residue number/chain id probably not found:'
     &    ,rng(1),chnrng(1)
        end if
        go to 500

300     ierr = 5

500     continue
        call unprepfil(brkname, compressed)
        return

      end




      logical function pdblin(t1,t2,t3,t4,water,hydrogen,hetatm,iwattyp)
        implicit none
        integer iwattyp, istr2int
        character t1*(*), t2*(*), t3*(*), t4*(*)
        logical water, hydrogen, hetatm, ishydrogen, p
        external ishydrogen, istr2int

c ----- special pre-processing (do something about it if it gets too
c       clumsy)
        if (t2.eq.'MSE') then
          t1 = 'ATOM  '
          t2 = 'MET'
        end if
        if((t2.eq.'MEX').or.(t2.eq.'ABU'))then
          t1 = 'ATOM  '
          t2 = 'CYS'
        end if

c ----- ATOM test:
        if((t1.eq.'ATOM  ')) then
          p = (istr2int(t2) .ne. iwattyp) .or. water
        else
          if (t1.eq.'HETATM') then
            if (istr2int(t2) .eq. iwattyp) then
              p = water
            else
              p = hetatm
            end if
          else
            p = .false.
          end if
        end if

c ----- do not read any H atoms if so requested:
        if ((.not. hydrogen).and.(ishydrogen(t4))) p = .false.

c ----- never read in the pseudo-atoms:
        if (t4(2:2) .eq. 'Q') p = .false.

c ----- occupancy test (note: only positions A will be read in; some
c       files do not use A but some other combination of chars, so
c       no atom for double occupancy positions will be read in):
        if((t3 .ne. ' ') .and. (t3 .ne. 'A')) p = .false.

        pdblin = p
 
        return
      end
