cf ---------------------------------------------------------------------------
cf
cf    RDGROUPS() routine will read the residue type resgrp to be used
cf    in residue classification.
cf
cf    subroutine rdresgrp(ioinp,iolog,grpfil,resgrp,mresgrp,mrescls,
cf   &                    nresgrp,nrescls)
cf
cf ---------------------------------------------------------------------------

      subroutine rdresgrp(ioinp,iolog,grpfil,resgrp,mresgrp,mrescls,
     &                    nresgrp,nrescls)
        implicit none
        integer mresgrp, nresgrp, ioinp, nrescls(mresgrp), mrescls
        integer iolog, ierr
        character grpfil*(*), card*256, resgrp(mrescls,mresgrp)*(*)
        logical iowr,cmpr

        call openf4(ioinp,grpfil,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .true.,ierr,cmpr,iolog)
        nresgrp = 0
10      read(ioinp, '(a)', end=100) card
          if (card(1:11) .eq. 'BEGIN_GROUP') then
            nresgrp = nresgrp + 1 
            if (nresgrp .gt. mresgrp) then
              write(iolog,'(a)') 'rdresgrp_E> increase MGROUPS'
              stop
            end if
            nrescls(nresgrp) = 0
20          read(ioinp, '(a)', end=100) card
            if (card(1:9) .eq. 'END_GROUP') go to 30
              nrescls(nresgrp) = nrescls(nresgrp) + 1
              if (nrescls(nresgrp) .gt. mrescls) then
                write(iolog,'(a)') 'rdresgrp_E> increase MRESCLS'
                stop
              end if
              resgrp(nrescls(nresgrp),nresgrp) = card
            go to 20
30          continue
          end if       
          go to 10
100     continue
        close(ioinp) 

        if (iowr(2))
     &    write(iolog,'(a,i4)') 
     &    'rdresgrp_> Number of residue groupings: ', nresgrp

        return
      end
