cf ----------------------------------------------------------------------------
cf
cf    RDRRWGHT() reads the matrix for comparison of the residue types.
cf    The first line must be either #DISTANCE or #SIMILARITY to 
cf    indicate what kind of scoring system is used. Then, there
cf    are comments indicated by '#' at the top. Then the
cf    single residue codes for the residues in the file (in the
cf    same order) follow in their own line. Next, the matrix follows.
cf
cf    subroutine rdrrwght(ioinp, iolog, rrfil, rrwght, mrestyp2, similar)
cf
cf ----------------------------------------------------------------------------

      subroutine rdrrwght(ioinp,iolog,rrfil,rrwght,mrestyp2,similar)
        implicit none
#include "reslib.cst"
        integer ioinp,i,j,mrestyp2,nrestyp,ichr2int,lenr,ind(mrestyp)
        integer iolog,ierr
        real rrwght(mrestyp2,mrestyp2), similar
        character line*(255), rrfil*(*)
        logical iowr,cmpr

c ----- default weights are 0.0:
        do  i = 1, mrestyp2
          do  j = 1, mrestyp2
            rrwght(i,j) = 0.0
          end do
        end do

        call openf4(ioinp,rrfil,'OLD','SEQUENTIAL','FORMATTED',3,.true.,
     &              ierr,cmpr,iolog)
        read(ioinp, '(a)') line
        call upper(line)
        if (line .eq. '#SIMILARITY') then
          similar = -1.0
        else
          if (line .eq. '#DISTANCE') then
            similar =  1.0
          else
            write(iolog,'(2a/2a)') 
     &       'rdrrwgh_E> format error; first line not #DISTANCE ',
     &       'or #SIMILARITY', 
     &       '           line: ', line(1:lenr(line))
            stop
          end if
        end if
c ----- read as many comments lines as there are (they can only be
c       at the top):
10      read(ioinp, '(a)') line
        if (line(1:1).eq.'#') go to 10

c ----- the first non-comment lines must contain the single character codes
c       reflecting the order of the residue types in this weights file

        nrestyp = lenr(line)
        if (nrestyp.gt.mrestyp2) then
          write(iolog,'(a,i4)') 'rdrrwght_E> Increase MRESTYP to ', 
     &          nrestyp
          stop
        end if
        if (iowr(2))
     &    write(iolog,'(a,i4)')'rdrrwght_> Number of residue types: ',
     &          nrestyp

c ----- the true order of residues from this file:
        do  j = 1, nrestyp
          ind(j) = ichr2int(line(j:j))
          if (ind(j).gt.mrestyp2) then
            write(iolog,'(a,i4)')'rdrrwght_E> Increase MRESTYP: ',ind(j)
            stop
          end if
          if (ind(j).lt.1) then
            write(iolog,'(a,i4,1x,a1)') 
     &      'rdrrwght_E> unrecognized residue type: ',j,line(j:j)
            stop
          end if
        end do

        do  i = 1, nrestyp
          read(ioinp, *, err=300, end=300) 
     &        (rrwght(ind(i),ind(j)),j=1,nrestyp)
        end do
        close(ioinp)
        return
  
300     continue
        write(iolog,'(a)') 'rdrrwght_E> reading the weights file.'
        stop

      end
