cf ----------------------------------------------------------------------------
cf
cf    STDEV() returns the value of the following polynomial: a constant 
cf    (NA=1), or a linear (NA=2), quadratic, cubic, or quartic form, 
cf    depending on how many parameters A(NA) are given.
cf
cf    real function stdev(x,nx,a,na)
cf
cf ----------------------------------------------------------------------------

      real function stdev(x,nx,a,na)
        implicit none
        integer nx,na,k,i,j,l,m
        real s, x(nx), a(na)

c ----- additive constant
        k = 1
        s = a(k)

c ----- linear terms
        do  i = 1, nx
          k = k + 1
          s = s + a(k)*x(i)
        end do
        if (k.eq.na) then
          stdev = s
          return
        end if

c ----- quadratic terms
        do  i = 1, nx
          do  j = i, nx
            k = k + 1
            s = s + a(k)*x(i)*x(j)
          end do
        end do
        if (k.eq.na) then
          stdev = s
          return
        end if

c ----- x*y*z cubic terms
        do  i = 1, nx
          do  j = i, nx
            do  l = j, nx
              k = k + 1
              s = s + a(k)*x(i)*x(j)*x(l)
            end do
          end do
        end do
        if (k.eq.na) then
          stdev = s
          return
        end if

c ----- x*y*z*t quartic terms
        do  i = 1, nx
          do  j = i, nx
            do  l = j, nx
              do  m = l, nx
                k = k + 1
                s = s + a(k)*x(i)*x(j)*x(l)*x(m)
              end do
            end do
          end do
        end do

        if (k.ne.na) stop 'stdev___E> wrong number of parameters'
        stdev = s

        return
      end
