cf ----------------------------------------------------------------------------
cf
cf    WRALN() write out the alignment in the specfied format: PIR, PAP,
cf    or QUANTA.
cf
cf    subroutine wraln(ioout,iolog,filout,form,ialn,caln,nseq,maxres,
cf   &           naln,code,prottyp,pdbcod,name,source,range,alnchn,
cf   &           resol,rfactr,comment,ncomment,nsegmn,iress1n,iress2n,
cf   &           segidn,maxseg,alnaln,iblock,alnacc,alnfeat,prof,nprof,
cf   &           gap1, gap2)
cf
cf ----------------------------------------------------------------------------

      subroutine wraln(ioout,iolog,filout,form,ialn,caln,nseq,maxres,
     &         naln,code,prottyp,pdbcod,name,source,range,alnchn,
     &         resol,rfactr,comment,ncomment,nsegmn,iress1n,iress2n,
     &         segidn,maxseg,alnaln,iblock,alnacc,alnfeat,prof,nprof,
     &         gap1,gap2)
        implicit none
        integer ioout,nseq,naln,maxres,ncomment,maxseg,iolog
        integer iress1n(maxseg,nseq),iress2n(maxseg,nseq)
        integer nsegmn(nseq),ialn(maxres,nseq),iblock,nprof
        real resol(nseq),rfactr(nseq),alnacc(naln)
        real prof(maxres,nprof),gap1(maxres),gap2(maxres)
        character segidn(maxseg,nseq)*(*)
        character pdbcod(nseq)*(*),name(nseq)*(*),alnchn(2,nseq)*(*)
        character source(nseq)*(*),range(2,nseq)*(*)
        character prottyp(nseq)*(*),comment(ncomment)*(*)
        character filout*(*),caln(maxres,nseq)*(*),code(nseq)*(*)
        character form*(*),alnfeat*(*)
        logical strgin,alnaln

        if (strgin(form,'PIR'))
     &    call wrpir(ioout,iolog,filout,caln,nseq,maxres,naln,code,
     &         prottyp,pdbcod,name,source,range,alnchn,resol,rfactr,
     &         comment,ncomment)

        if (strgin(form,'QUANTA'))
     &    call wrqnt(ioout,iolog,filout,ialn,caln,nseq,maxres,naln,
     &         pdbcod,nsegmn,iress1n,iress2n,segidn,maxseg,range,
     &         alnchn)

        if (strgin(form,'PAP').or.strgin(form,'INSIGHT'))
     &    call wrpap(ioout,iolog,filout,code,nseq,maxres,caln,naln,
     &         alnaln,iblock,alnacc,alnfeat,strgin(form,'INSIGHT'),
     &         prof,nprof,gap1,gap2)

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    WRPIR() writes out the alignment in the PIR format.
cf
cf    subroutine wrpir(ioout,iolog,filout,caln-nseq,maxres,naln,code,
cf   &           prottyp,pdbcod,name,source,range,alnchn,resol,rfactr,
cf   &           comment,ncomment)
cf
cf ----------------------------------------------------------------------------

      subroutine wrpir(ioout,iolog,filout,caln,nseq,maxres,naln,code,
     &           prottyp,pdbcod,name,source,range,alnchn,resol,rfactr,
     &           comment,ncomment)
        implicit none
#include "mdt_aln.cst"
        integer iseq,ialn,ioout,nseq,naln,maxres,ipos,imin,imax
        integer nlines,iline,lenr2,ncomment,i,ierr,iolog,lenr
        real resol(nseq),rfactr(nseq)
        character pdbcod(nseq)*(*),name(nseq)*(*),alnchn(2,nseq)*(*)
        character source(nseq)*(*),range(2,nseq)*(*)
        character prottyp(nseq)*(*),comment(ncomment)*(*)
        character filout*(*),caln(maxres,nseq)*(*),code(nseq)*(*)
        character card*(line)
        logical cmpr
        external lenr2,lenr

        if (ioout .ne. iolog)
     &    call openf4(ioout,filout,'UNKNOWN','SEQUENTIAL','FORMATTED',
     &                3,.true.,ierr,cmpr,iolog)

c ----- write out the comments:
        do  i = 1, ncomment
          write(ioout,'(a)') comment(i)(1:lenr2(comment(i)))
        end do

        nlines = naln / line
        if (mod(naln, line) .gt. 0) nlines = nlines + 1
        do  iseq = 1, nseq

c ------- make sure you do not write char(0) to the aln file:
          if (lenr(code(iseq)) .lt. 1) code(iseq) = ' '
          if (lenr(prottyp(iseq)) .lt. 1) prottyp(iseq) = ' '
          if (lenr(pdbcod(iseq)) .lt. 1) pdbcod(iseq) = ' '
          if (lenr(name(iseq)) .lt. 1) name(iseq) = ' '
          if (lenr(source(iseq)) .lt. 1) source(iseq) = ' '

c ------- write a header for this sequence
          call ljust(code(iseq))
          write(ioout, '(''>P1;'', a)') code(iseq)(1:lenr2(code(iseq)))
          write(ioout, '(8(a,'':''), f5.2, '':'', f5.2)')
     &      prottyp(iseq)(1:lenr2(prottyp(iseq))),
     &      pdbcod(iseq)(1:lenr2(pdbcod(iseq))),
     &      range(1,iseq), alnchn(1,iseq),
     &      range(2,iseq), alnchn(2,iseq),
     &      name(iseq)(1:lenr2(name(iseq))),
     &      source(iseq)(1:lenr2(source(iseq))),
     &      resol(iseq), rfactr(iseq)
          do  iline = 1, nlines
c --------- get a line string
            imin = (iline-1)*line + 1
            imax = min(iline*line, naln)
            ipos = 0
            do  ialn = imin, imax
              ipos = ipos + 1
              card(ipos:ipos) = caln(ialn, iseq)
            end do
c --------- write it out
            if (iline .eq. nlines) then
              write(ioout, '(2a)') card(1:ipos), endseq
            else
              write(ioout, '(a)') card
            end if
          end do
        end do
        if (ioout .ne. iolog) close(ioout)

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    WRQNT() writes out the alignment in the format close to the
cf    QUANTA alignment file format. Some residue numbers may not be
cf    exactly correct because this routine does not read in the
cf    the whole atom coordinate files. The first and last residue
cf    numbers, however, are correct (obtained from RANGE). If
cf    SEGIDN is empty, ALNCHN is used if not empty, otherwise an
cf    aribtrary string '@' is assigned. This means that you should
cf    be very careful when mixing different
cf    alignment file formats and also relying on automated segment/chain
cf    specification --- it really should not be done. Also, if
cf    any of the inferred residue numbers is higher than the last
cf    residue number, the automated segment specification won't work.
cf    The bootom line: only use QUANTA alignment input/output.
cf
cf    subroutine wrqnt(ioout,iolog,filout,ialn,caln,nseq,maxres,naln,
cf   &           pdbcod,nsegmn,iress1n,iress2n,segidn,maxseg,range,
cf   &           alnchn)
cf
cf ----------------------------------------------------------------------------

      subroutine wrqnt(ioout,iolog,filout,ialn,caln,nseq,maxres,naln,
     &           pdbcod,nsegmn,iress1n,iress2n,segidn,maxseg,range,
     &           alnchn)
        implicit none
#include "mdt_aln.cst"
#include "reslib.cst"
        integer iseq,maxres,nseq,ialn(maxres,nseq),ioout,naln,ierr
        integer lr,ic,il,nlines,lenr2,ia,ialn2(maxseq),maxseg,iolog
        integer iress1n(maxseg,nseq),iress2n(maxseg,nseq),lenr
        integer nsegmn(nseq),iseg(maxseq),lrs(maxseq)
        character segidn(maxseg,nseq)*(*),pdbcod(nseq)*(*)
        character segid(maxseq)*(nqntwcol), chr2str*(3)
        character filout*(*),caln(maxres,nseq)*(*),str2chr*(1)
        character card*(mqntlin),gap1*(1),range(2,nseq)*(*)
        character rnum*(5),alnchn(2,nseq)*(*)
        logical cmpr
        external lenr2, str2chr, lenr

        if (ioout .ne. iolog)
     &    call openf4(ioout,filout,'UNKNOWN','SEQUENTIAL','FORMATTED',
     &                3,.true.,ierr,cmpr,iolog)

        do  iseq = 1, nseq
         if (lenr(pdbcod(iseq)) .lt. 1) pdbcod(iseq) = ' '
         write(ioout,'(3a)')'MOL  ',pdbcod(iseq)(1:lenr2(pdbcod(iseq))),
     &                      '.msf'
          iseg(iseq) = 1
          call newsegnam(alnchn(1,iseq),segidn(iseg(iseq),iseq),
     &                   segid(iseq))
          lrs(iseq) = lenr(segid(iseq))
        end do

c ----- number of lines for each alignment position:
        if (mod(nseq, nqntcol) .eq. 0) then
          nlines = nseq / nqntcol
        else
          nlines = nseq / nqntcol + 1
        end if

c ----- first residue integer number or an approximation to it:
        do  iseq = 1, nseq
          call str_i2(range(1,iseq)(1:4), ialn2(iseq), ierr)
          if (ierr .gt. 0) then
            write(iolog,'(3a/a)')
     &      'wrqnt___W> only integer residue numbers should ',
     &      'occur here: ', range(1,iseq),
     &      '           may have problems with automated segment specs'
            ialn2(iseq) = 1
          end if
        end do

c ----- gap character in caln():
        gap1 = str2chr(gapsym)

        do  ia = 1, naln
          iseq = 0
          do il = 1, nlines
            write(card, '(i4)') ia
c --------- the character column just before the first residue name in
c           the QUANTA alignment file:
            lr = 7
            do  ic = 1, nqntcol
              iseq = iseq + 1
              if (iseq .le. nseq) then
                if (ialn(ia,iseq).gt.0) then

c --------------- get residue number:
                  if (ialn(ia,iseq).eq.1) then
c ----------------- the exact residue number for the first residue:
                    rnum = range(1,iseq)
                  else
                    if(ialn(ia,iseq).eq.iress2n(nsegmn(iseq),iseq))then
c ------------------- the exact residue number for the last residue:
                      rnum = range(2,iseq)
                    else
c ------------------- guess a residue number for a non-terminal residue
c                     (the only way to overcome this is to read the residue
c                      numbers from QUANTA alignment file or from atom files):
                      write(rnum, '(i5)')ialn2(iseq)+ialn(ia,iseq)-1
                    end if
                  end if
                  call ljust(rnum)

c --------------- get segment index and current segment name:
                  if (ialn(ia,iseq) .gt. iress2n(iseg(iseq),iseq)) then
                    iseg(iseq) = iseg(iseq) + 1
                    call newsegnam(alnchn(1,iseq),
     &                   segidn(iseg(iseq),iseq), segid(iseq))
                    lrs(iseq) = lenr(segid(iseq))
                  end if

                  write(card(lr+1:),'(5a)')
     &            chr2str(caln(ia,iseq)), ' ', segid(iseq)(1:lrs(iseq)),
     &            ':', rnum

                else

                  write(card(lr+1:),'(3a)') qntgap,'   ',qntgap

                end if

                lr = lr + nqntwcol
              end if
            end do
            write(ioout, '(a)') card(1:lenr2(card))
          end do
        end do

        if (ioout .ne. iolog) close(ioout)

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    WRPAP() writes out the alignment in the PAP format.
cf
cf    subroutine wrpap(ioout,iolog,filout,code,nseq,maxres,caln,naln,
cf   &           alnaln,iblock,alnacc,alnfeat,insght,prof,nprof,gap1,gap2)
cf
cf ----------------------------------------------------------------------------

      subroutine wrpap(ioout,iolog,filout,code,nseq,maxres,caln,naln,
     &                 alnaln,iblock,alnacc,alnfeat,insght,prof,nprof,
     &                 gap1,gap2)
        implicit none
        integer laa, mult, maxlin, ncode2, nspace, nresl2, nresl1
c ----- positions for aa code, every which residue position numbered,
c       maximal length of line, space for the protein code in PAP,
c       space between residue codes, number of residues per line
c       in PAP, INSIGHT:
        parameter (laa=1,mult=10,maxlin=255,ncode2=10,nspace=0)
c ----- PAP, INSIGHT total line length:
        parameter (nresl2=60, nresl1 = 57)
        integer ioout,ir,il,ires1,ires2,maxres,nseq,naln,ires,lenr
        integer iseq,lenl,lr,ll,iblock,iacc,ncode,i,nresl,iolog,ierr
        integer lenr2,nprof
        real alnacc(naln),prof(maxres,nprof),gapmax1,gapmin1
        real gapmax2,gapmin2
        real gap1(maxres), gap2(maxres)
        character filout*(*),line*(maxlin),caln(maxres,nseq)*(*)
        character code(nseq)*(*), alnfeat*(*)
        logical cmpr, notaa1, alnaln, insght, strgin, all
        external lenr, notaa1, lenl, lenr2, strgin

        if (ioout .ne. iolog)
     &    call openf4(ioout,filout,'UNKNOWN','SEQUENTIAL','FORMATTED',
     &                3,.true.,ierr,cmpr,iolog)

c        if (ncode+nresl*(laa+nspace) .gt. maxlin) then
c          write(iolog,'(a)') 'wrpap___E> increase MAXLIN'
c          stop
c        end if

        gapmax1 = -1.0e32
        gapmin1 =  1.0e32
        gapmax2 = -1.0e32
        gapmin2 =  1.0e32
        do  i = 1, naln
          if (gap1(i) .ge. 0.0) then
            if (gap1(i) .gt. gapmax1) gapmax1 = gap1(i)
            if (gap1(i) .lt. gapmin1) gapmin1 = gap1(i)
          end if
          if (gap2(i) .ge. 0.0) then
            if (gap2(i) .gt. gapmax2) gapmax2 = gap2(i)
            if (gap2(i) .lt. gapmin2) gapmin2 = gap2(i)
          end if
        end do

c ----- maximal code length:
        if (insght) then
          ncode = lenr(code(1))
          do  i = 2, nseq
            ncode = max(ncode, lenr(code(i)))
          end do
          ncode = ncode + 2
          nresl = nresl1 - ncode
        else
          ncode = ncode2
          nresl = nresl2
        end if

        all = strgin(alnfeat, 'ALL')

C ----- OUTER LEVEL: BLOCKS
        ires2 = 0
10      continue
C ------- NEXT LEVEL: SEQUENCES
          ires1 = ires2 + 1
          ires2 = min(ires2 + nresl, naln)

          if (ires1 .gt. 1) then
           if (insght) then
            write(ioout, '(//)')
           else
            write(ioout, '(/)')
           end if
          end if

          if((all.or.strgin(alnfeat,'INDICES')).and..not.insght)then
            call blank(line)
            line = ' _aln.pos'
            ir = 0
            do  ires = ires1, ires2
              ir = ir + 1
              if(mod(ires, mult) .eq. 0) then
                il = ncode + ir*(nspace+laa) - 4
                if (il .gt. 0) write(line(il:il+4), '(i5)') ires
              end if
            end do
            write(ioout, '(a)') line(1:lenr2(line))
          end if

          do  iseq = 1, nseq
            call blank(line)
            ll = lenl(code(iseq))
            if (ll.gt.0) then
              lr = lenr(code(iseq))
              write(line(1:), '(a)')
     &          code(iseq)(ll:min(ll+lr-1,ll+ncode-1))
              if (insght) write(line(ncode-1:), '(a1)') ':'
            end if
            il = ncode + 1
            do  ires = ires1, ires2
              il = il + nspace
              write(line(il:il), '(a)') caln(ires,iseq)
              il = il + 1
            end do
            write(ioout, '(a)') line(1:il)
          end do

          if((all.or.strgin(alnfeat, 'ACCURACY')).and..not.insght)then
            call blank(line)
            line = ' _accurac'
            il = ncode
            do  ires = ires1, ires2
              il = il + 1
              iacc = alnacc(ires)*9.499
               if (iacc .ge. 0 .and. iacc .le. 9)
     &           write(line(il:il), '(i1)') iacc
            end do
            write(ioout, '(a)') line(1:lenr2(line))
          end if

          if((all.or.strgin(alnfeat,'CONSERVATION')).and..not.insght)
     &      then
          call blank(line)
          line = ' _consrvd'
          il = ncode
          do 20  ires = ires1, ires2
            il = il + 1
            if (alnaln) then
              do  iseq = 1, iblock
                if (caln(ires,iseq).ne.caln(ires,iblock+iseq)) go to 20
              end do
              line(il:il) = '*'
            else
              if (nseq.gt.1 .and. .not. notaa1(caln(ires,1))) then
                do  iseq = 2, nseq
                  if (notaa1(caln(ires,iseq)) .or.
     &                caln(ires,iseq).ne.caln(ires,1)) go to 20
                end do
                line(il:il) = '*'
              end if
            end if
20        continue
          write(ioout, '(a)') line(1:lenr2(line))
          end if

          if((all.or.strgin(alnfeat,'HELIX')).and..not.insght)then
            call blank(line)
            line = ' _helix'
            il = ncode
            do  ires = ires1, ires2
              il = il + 1
              iacc = prof(ires,1)*9.499
              if (iacc .gt. 0 .and. iacc .le. 9)
     &          write(line(il:il), '(i1)') iacc
            end do
            write(ioout, '(a)') line(1:lenr2(line))
          end if

          if((all.or.strgin(alnfeat,'BETA')).and..not.insght)then
            call blank(line)
            line = ' _beta'
            il = ncode
            do  ires = ires1, ires2
              il = il + 1
              iacc = prof(ires,2)*9.499
              if (iacc .gt. 0 .and. iacc .le. 9)
     &          write(line(il:il), '(i1)') iacc
            end do
            write(ioout, '(a)') line(1:lenr2(line))
          end if

          if((all.or.strgin(alnfeat,'ACCESSIBILITY')).and..not.insght)
     &      then
            call blank(line)
            line = ' _buried'
            il = ncode
            do  ires = ires1, ires2
              il = il + 1
              iacc = prof(ires,3)*9.499
              if (iacc .ge. 0 .and. iacc .le. 9)
     &          write(line(il:il), '(i1)') iacc
            end do
            write(ioout, '(a)') line(1:lenr2(line))
          end if

          if((all.or.strgin(alnfeat,'STRAIGHTNESS')).and..not.insght)
     &      then
            call blank(line)
            line = ' _straigt '
            il = ncode
            do  ires = ires1, ires2
              il = il + 1
c ----------- the range is from 0 to 1:
              iacc = prof(ires,4)*9.499
              if (iacc .ge. 0 .and. iacc .le. 9)
     &          write(line(il:il), '(i1)') iacc
            end do
            write(ioout, '(a)') line(1:lenr2(line))
          end if

          if((all.or.strgin(alnfeat,'GAP1')).and..not.insght)then
            call blank(line)
            line = ' _gap1'
            il = ncode
            do  ires = ires1, ires2
              il = il + 1
              iacc = nint((gap1(ires)-gapmin1)/max(0.001,
     &                     gapmax1-gapmin1)*9.499)
              if (iacc .ge. 0) write(line(il:il), '(i1)') iacc
            end do
            write(ioout, '(a)') line(1:lenr2(line))
          end if

          if((all.or.strgin(alnfeat,'GAP2')).and..not.insght)then
C --------- A LINE OF GAP INDICES:
            call blank(line)
            line = ' _gap2'
            il = ncode
            do  ires = ires1, ires2
              il = il + 1
              iacc = nint((gap2(ires)-gapmin2)/max(0.001,
     &                     gapmax2-gapmin2)*9.499)
              if (iacc .ge. 0) write(line(il:il), '(i1)') iacc
            end do
            write(ioout, '(a)') line(1:lenr2(line))
          end if


        if (ires2 .lt. naln) go to 10

        if (ioout .ne. iolog) close(ioout)

        return
      end



cf ---------------------------------------------------------------------------
cf
cf    NEWSEGNAM() returns a segment name from a suggested segment name.
cf
cf     subroutine newsegnam(alnchn, segidn, segid)
cf
cf ---------------------------------------------------------------------------

       subroutine newsegnam(alnchn, segidn, segid)
         implicit none
#include "reslib.cst"
         integer lenr
         character segidn*(*), segid*(*), alnchn(2)*(*)
         external lenr

         if (lenr(segidn) .lt. 1) then
           if (lenr(alnchn(1)) .lt. 1) then
             segid = alnchn(1)
           else
             segid = anyrid
           end if
         else
           segid = segidn
         end if

         return
       end
