cf ----------------------------------------------------------------------------
cf
cf    FNDATMS() finds indices of NIND atoms, given their [I][-,+,#,*]names,
cf    and corresponding residue indices IRESL(NRESL). It returns IND(I)=0,
cf    if atom I does not exist. PRESENT = .T., if all atoms exist. If WHOLE 
cf    is true, the whole atom list is searched; otherwise the IATMR1
cf    array is used to make the search faster.
cf
cf    subroutine fndatms(atmnam,iresatm,iatmr1,natm,nres,
cf   -           atms,nind,ind,iresl,nresl,present,whole)
cf
cf ----------------------------------------------------------------------------

      subroutine fndatms(atmnam,iresatm,iatmr1,natm,nres,
     &           atms,nind,ind,iresl,nresl,present,whole)
        implicit none
        integer natm,nres,iatmr1(nres),iresatm(natm)
        integer nind,ind(nind),i,nresl,iresl(nresl)
        integer ires1
        character atms(nind)*(*),atm1*(4),atmnam(natm)*(*)
        logical present,whole

        present = .true.
        do  i = 1, nind
c ------- find the residue index first:
          if (atms(i)(1:1) .eq. ' ') then
            write(*,'(a)') 'fndatms_E> internal'
            stop 
          end if
          if (whole) then
            call i2atint(atms(i),atmnam,natm,iresatm,iresl,nresl,
     &                   nres,ires1,atm1,ind(i))
          else
            call iatint(atms(i),atmnam,natm,iatmr1,iresl,
     &                  nresl,nres,ires1,atm1,ind(i))
          end if
          present = present .and. (ind(i) .gt. 0)
        end do

        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    I2ATINT() returns the index of the atom ATM in residue IRES,
cf    given its [I][-,+,#,*]name. It does not rely on IATMR1 but
cf    searches all atoms in the model. It also returns only the
cf    root atom name in ATM1. IRESL(NRESL) is used in getting the
cf    residue index from [I][-,+,#,*]name and IRES1.
cf
cf    subroutine i2atint(atm,atmnam,natm,iresatm,iresl,nresl,
cf   -                   nres,ires1,atm1,ind)
cf
cf ----------------------------------------------------------------------------

      subroutine i2atint(atm,atmnam,natm,iresatm,iresl,nresl,
     &                   nres,ires1,atm1,ind)
        implicit none
        integer nres,natm,ires1,iresatm(natm),nresl,iresl(nresl)
        integer indexw,ind
        character atmnam(natm)*(*), atm*(*), atm1*(4)

c ----- get the residue index of the atom to be found and its proper
c       atom name without the CHARMM residue/position/improper flag(s)
        call atmparse(atm,atm1,iresl,nresl,ires1)

c ----- does this residue exist 
        if ((ires1 .ge. 1) .and. (ires1 .le. nres)) then
c ------- find the atom name in residue ires1
          do  ind = 1, natm
            if (iresatm(ind) .eq. ires1) then
              if (indexw(atmnam(ind), atm1) .gt. 0) go to 999
            end if
          end do
        end if
        ind = 0

999     continue

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    IATINT() returns the index of the atom ATM in residue IRESL(NRESL),
cf    given its [I][-,+,#,*]name. It does rely on IATMR1 for a faster 
cf    search. It also returns only the root atom name in ATM1. IRESL(NRESL) 
cf    is used in getting the residue index from [I][-,+,#,*]name and IRES1.
cf
cf    subroutine iatint(atm,atmnam,natm,iatmr1,iresl,
cf   &                  nresl,nres,ires1,atm1,ind)
cf
cf ----------------------------------------------------------------------------

      subroutine iatint(atm,atmnam,natm,iatmr1,iresl,
     &                  nresl,nres,ires1,atm1,ind)
        implicit none
        integer nres,natm,ires1,iatmr1(nres),indxatm
        integer nresl,iresl(nresl),ind
        character atmnam(natm)*(*), atm*(*), atm1*(*)

c ----- get the residue index of the atom to be found and its proper
c       atom name without the CHARMM residue/position/improper flag(s)
        call atmparse(atm,atm1,iresl,nresl,ires1)

c ----- does this residue exist 
        if ((ires1 .ge. 1) .and. (ires1 .le. nres)) then
c ------- find the atom name in residue ires1
          ind = indxatm(atm1,ires1,atmnam,iatmr1,nres,natm)
        else
          ind = 0
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    ATMPARSE() returns the plain atom_name (ATM1) and its 
cf    residue index (IRES1)
cf
cf    The CHARMM atom name is: [I][-|+|#|*][atom_name*4];
cf
cf    [I] ... selects the I-th residue from the IRESL list; 
cf            (patch residues only)
cf     -  ... previous residue
cf     +  ... next residue
cf     #  ... next of next residue (patch residues only)
cf     *  ... it indicates an improper dihedral (in the IC list)
cf
cf    the [I] and # prefixes are used in patch residues only;
cf
cf    subroutine atmparse(atm,atm1,iresl,nresl,ires1)
cf
cf ----------------------------------------------------------------------------

      subroutine atmparse(atm,atm1,iresl,nresl,ires1)
        implicit none
#include "charmm.cst"
        integer nresl,iresl(nresl),ires1,ind,ipos,i,idig,la
        character atm*(*),atm1*(*)

c ----- process the leading optional integer [I]
        ind = 0
        ipos = 0
        la = len(atm)
        if (la .lt. 4) then
          write(*,'(a)') 'atmpars_E> internal'
          stop
        end if
        do  i = 1, la
          ipos = ipos + 1
          idig = index(digits, atm(i:i)) - 1
          if (idig .lt. 0) go to 10
          ind = 10*ind + idig
        end do
10      if (ind .gt. nresl) then
          write(*,'(a,2i5)')
     &    'atmpars_E>; too few patched residues: ', ind,nresl
          stop
        end if
        ires1 = iresl(max(1,ind))

        if (atm(ipos:ipos) .eq. prev) then
          ires1 = ires1-1
          atm1 = atm(ipos+1:)
        else
          if (atm(ipos:ipos) .eq. next) then
            ires1 = ires1+1
            atm1 = atm(ipos+1:)
          else
            if (atm(ipos:ipos) .eq. nextnext) then
              ires1 = ires1+2
              atm1 = atm(ipos+1:)
            else
              if (atm(ipos:ipos) .eq. improp) then
                atm1 = atm(ipos+1:)
              else
                atm1 = atm(ipos:)
              end if
            end if
          end if
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    INDATM() returns the index of atom ATM1*4.
cf
cf    integer function indxatm(atm1,ires1,atmnam,iatmr1,nres,natm)
cf
cf ----------------------------------------------------------------------------

      integer function indxatm(atm1,ires1,atmnam,iatmr1,nres,natm)
        implicit none
        integer iatmr2, nares, nres, natm, ires1, iatmr1(nres)
        integer ifind2word,i
        character atmnam(natm)*(*), atm1*(*)

        nares = iatmr2(iatmr1,nres,natm,ires1)-iatmr1(ires1)+1
        i = ifind2word(atm1,atmnam(iatmr1(ires1)),nares)
        if (i .gt. 0) then
          indxatm = iatmr1(ires1) + i - 1
        else
          indxatm = 0
        end if
  
        return
      end



cf ----------------------------------------------------------------------------
cf
cf    FNDATMI() prepares the indices of atom types DSTATM1*4 in IDSTA1(NRES).
cf
cf    subroutine fndatmi(nres,natm,atmnam,iatmr1,dstatm1,idsta1)
cf
cf ----------------------------------------------------------------------------

      subroutine fndatmi(nres,natm,atmnam,iatmr1,dstatm1,idsta1)
        implicit none
#include "io.cst"
        integer i, ip, natm, nres,iatmr1(nres), nares
        integer idsta1(nres), ifind2word, natmres
        character dstatm1*(*), atmnam(natm)*(*)
        logical iowr

        nares = 0

        do  i = 1, nres
          ip = ifind2word(dstatm1, atmnam(iatmr1(i)), 
     &                    natmres(iatmr1,i,nres,natm))
          if (ip .eq. 0) then
            idsta1(i) = 0
          else
            nares = nares + 1
            idsta1(i) = iatmr1(i) + ip - 1
          end if
        end do

        if (nares .ne. nres) then
          if (iowr(3))
     &      write(iolog,'(a,2i5,1x,a)')
     &     'fndatmi_W> # of residues <> # of atoms; atom code: ',
     &     nres,nares,dstatm1
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    NATMRES() returns the number of atoms in residue IRES.
cf
cf    integer function natmres(iatmr1,ires,nres,natm)
cf
cf ----------------------------------------------------------------------------

      integer function natmres(iatmr1,ires,nres,natm)
        implicit none
        integer nres,ires,iatmr1(nres),natm
        if (ires .lt. nres) then
           natmres = iatmr1(ires+1) - iatmr1(ires)
        else
           natmres = natm - iatmr1(ires) + 1
        end if
        return
      end



cf ----------------------------------------------------------------------------
cf
cf    IATMR2() returns the index of the last atom in residue IRES.
cf
cf    integer function iatmr2(iatmr1, nres, natm, ires)
cf
cf ----------------------------------------------------------------------------

      integer function iatmr2(iatmr1, nres, natm, ires)
        implicit none
        integer nres, iatmr1(nres), natm, ires
        if (ires .eq. nres) then
          iatmr2 = natm
        else
          iatmr2 = iatmr1(ires+1) - 1
        end if
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    ISHYDROGEN function returns .T. if the atmnam is the PDB hydrogen
cf    atom code (if the first non-blank character is 'H').
cf
cf    logical function ishydrogen(atmnam)
cf
cf ----------------------------------------------------------------------------

      logical function ishydrogen(atmnam)
        implicit none
        character atmnam*(*), atdum*(5)

        atdum = atmnam 
        call ljust(atdum)
        if (atdum(1:1) .eq. 'H') then
          ishydrogen = .true.
        else
          if (index('1234567890',atmnam(1:1)).gt.0.and.
     -        atdum(2:2).eq.'H') then
            ishydrogen = .true.
          else
            ishydrogen = .false.
          end if
        end if

        return
      end
