      subroutine getdata(istop)
        implicit none
#include "io.cst"
#include "mdt_all.cmn"
        integer i,istop
        logical iowr

c ----- by default, all proteins have all their data fine:
        do  i = 1, nseq
          accepts(i) = .true.
        end do

c ----- read all the data you need for this family in this run
        do 100  i = 1, maxdatatyp
c ------- read the data of the type i
          if (readin(i)) then
c --- FEATURE SLOT
            go to (1,2,3,4,5,6,7,8,9,10,11,12,13,14) i
c --------- All atoms' x,y,z and atomic isotropic temperature factors
1             call rdabrk(istop)
              go to 200
c --------- Phi, psi, chi1, chi2, chi3, chi4, sec.str. codes
2             call rdasst (istop)
              go to 200
c --------- Residue accessibilities
3             call rdapsa_old(istop)
c 3             call rdapsa
              go to 200
c --------- Nearest neighbours
4             call rdangh
              go to 200
c --------- Number of contacts with hetatms
5             stop 'NOT IMPLEMENTED YET'
c              call rdacnt(istop)
c              go to 200
c --------- Calculate Phi 
6             call mkadih(iphityp,istop)
              go to 200
c --------- Calculate Psi
7             call mkadih(ipsityp,istop)
              go to 200
c --------- Calculate omega
8             call mkadih(iomgtyp,istop)
              go to 200
c --------- Calculate chi1
9             call mkadih(ichi1typ,istop)
              go to 200
c --------- Calculate chi2
10            call mkadih(ichi2typ,istop)
              go to 200
c --------- Calculate chi3
11            call mkadih(ichi3typ,istop)
              go to 200
c --------- Calculate chi4
12            call mkadih(ichi4typ,istop)
              go to 200
c --------- Read all dihedrals
13            call rdadih
              go to 200
c --------- Calculate chi5
14            call mkadih(ichi5typ,istop)
              go to 200
c --- FEATURE SLOT
200         continue
          end if
100     continue

c ----- total number of accepted proteins analyzed in this run:
        nseqacc = 0
        do  i = 1, nseq
          if (accepts(i)) then
            nseqacc = nseqacc + 1
            if (iowr(2))
     &      write(iolog,'(2a)')'getdata__> protein accepted    : ',
     &      code(i)
          else
            if (iowr(3))
     &      write(iolog,'(2a)')'getdata_W> protein not accepted: ',
     &      code(i)
          end if
        end do
        if (iowr(2))
     &    write(iolog,'(a,2i4)')
     &    'getdata__> proteins all/accepted: ',nseq,nseqacc
          nprots = nprots + nseqacc

        return
      end



      subroutine rdabrk(istop)
        implicit none
#include "io.cst"
#include "mdt_all.cmn"
        integer nsegmmk, iress1mk(maxseg), iress2mk(maxseg)
        integer i, j, nreschk, ierr, ichr2int, istop
        character type*4, header*(80)
        character chain(maxres)*(1), str2chr*(1)
        character rescrm(maxres)*(4), atmpdb(maxatm)*(4)
        logical filexs,iowr

        data type /'pdb'/

c ----- forget all the derivative data that may now be in memory
        do  i = 1, 5
          datrdy(i) = .false.
        end do

        if (noaln) naln = 0

        do  i = 1, nseq1
c ------- get a full atom filename from pdbcod or explicit atmfull:
          call atmdef(1,pdbcod(i),atmdir,atmfil(i),1,atmfull(i),istop)

c ------- Does the PDB file exist?
          if (filexs(atmfull(i))) then

c -------- do not use nsegmn, iress1n, iress2n --- these are set in rdaln().
           call rdpdb(ioinp,iolog,atmfull(i),water,hetatm,hydrogen,
     &          xn(1,i),yn(1,i),zn(1,i),maxatm,maxres,natmn(i),nreschk,
     &          resnamn(1,i),resnumn(1,i),atmpdb,iatmr1n(1,i),chain,
     &          header,range(1,i),alnchn(1,i),iresatmn(1,i),bison(1,i),
     &          ierr,iress1mk,iress2mk,maxseg,nsegmmk)

c -------- convert from PDB to the CHARMM atom names so that resdih.lib 
c          can be used (the resnam remain to be the PDB residue names because
c          I do not want to change the whole MDT1.F to CHARMM naming yet):
c -------- not good for multi-segment PDB files because only the last
c          residue is recognized as COOH bearing
           call pdb2crm(resnamn(1,i),iresatmn(1,i),atmpdb,natmn(i),
     &                  nreschk,rescrm,atmnamn(1,i),nreschk,1)
           if (ierr .gt. 0) then
             if (iowr(3))
     &         write(iolog,'(a,i3)') 
     &         'rdabrk__W> protein not accepted/PDB: ',i
             accepts(i) = .false.
           end if

c -------- construct the default alignment
           if (noaln) then
             nresn(i) = nreschk
             naln = max(naln, nresn(i))
             do  j = 1, nresn(i)
               ialn(j,i) = j
               caln(j,i) = str2chr(resnamn(j,i))
               ccaln(j,i) = caln(j,i)
               irestypn(j,i) = ichr2int(ccaln(j,i))
               invaln(j,i) = j
             end do
           end if

           call chkseq(type, i, nreschk, resnamn(1,i), ierr)
           if (ierr .gt. 0) then
             if (iowr(3))
     &       write(iolog,'(a,i3)') 
     &       'rdabrk__W> protein not accepted/SEQ: ',i
             accepts(i) = .false.
           end if

          else

            accepts(i) = .false.
            if (iowr(3))
     &        write(iolog,'(a,i3)') 
     &        'rdabrk__W> protein not accepted/non-existing: ',i

          end if

        end do

        return
      end



      subroutine rdadih
        implicit none
#include "io.cst"
#include "mdt_all.cmn"
        integer i

c ----- expecting that the coordinates are already in memory!

c ----- Are the derivative data already in memory?
        if (.not. datrdy(3)) then
        datrdy(3) = .true.

        do  i = 1, nseq1
c ------- returns dihedrals in degrees and without C2 symmetry conversion
c         (ie no reduction to 0 .. 180 range for C2 residues); dihedrals
c         for the Cys-Cys disulfides are also calculated.
          call diheds(xn(1,i),yn(1,i),zn(1,i),iresatmn(1,i),
     &         iatmr1n(1,i),atmnamn(1,i),resnamn(1,i),nresn(i),
     &         natmn(i),0,.true.,.true.,ndiht,maxres,dih(1,1,i))
        end do

        end if

        return
      end



      subroutine rdadih_old(istop)
        implicit none
#include "io.cst"
#include "mdt_all.cmn"
        integer i, nreschk, ierr, ipdbfnd, istop
        character fname*(255), reschk(maxres)*3, type*4
        logical cmprs,filexs
        data type /'.dih'/

        do  i = 1, nseq1
c ------- get a full atom filename from pdbcod or explicit atmfull:
          call atmdef(1,pdbcod(i),atmdir,atmfil(i),1,atmfull(i),istop)

c ------- Does the PDB file exist?
          if (filexs(atmfull(i))) then
            call mkfile(atmdir,atmfull(i),range(1,i),alnchn(1,i),type,
     &                  fname,ipdbfnd,cmprs,1,outdir)

            call rddih(ioinp,iolog,fname,dih(1,1,i),ndiht,reschk,
     &                 nreschk,maxres,ierr)
            if (ierr .gt. 0) accepts(i) = .false.
            call chkseq(type, i, nreschk, reschk, ierr)
            if (ierr .gt. 0) accepts(i) = .false.

          else

            accepts(i) = .false.

          end if

        end do

        return
      end



      subroutine rddih(ioinp,iolog,fname,dih,ndiht,resnam,nres,maxres,
     &                 ierr)
        implicit none
        integer nres,maxres,ierr,ioinp,ndiht,i,ii,lenr,iolog
        real dih(maxres,ndiht)
        character resnam(maxres)*(*), line*(10), fname*(*), aa*(1)
        character chr2str*(3)
        logical compressed

        call openf4(ioinp,fname,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .false.,ierr,compressed,iolog)

        nres = 0

        if (ierr .ne. 0) go to 300

10      read(ioinp, '(a)', err=300, end=300) line
        if (line(1:4) .ne. '   #') go to 10

        nres = 1
20      read(ioinp, '(i4,3x,a1,999f7.1)', err=300, end=40) 
     &              ii, aa, (dih(nres,i),i=1,ndiht)
          resnam(nres) = chr2str(aa)
          nres = nres + 1
          if (nres.gt.maxres) stop 'rddih___E> increase MAXRES'
          go to 20
40      continue
        nres = nres - 1
        close(ioinp)
        call unprepfil(fname, compressed)
        ierr = 0
        return

300     ierr = 1
        write(iolog,'(2a)') 'rddih___E> reading file: ',
     &                      fname(1:lenr(fname))
        return

      end



      subroutine rdasst(istop)
        implicit none
#include "io.cst"
#include "mdt_all.cmn"
        integer i, nreschk, ierr, ipdbfnd, istop
        character fname*255, reschk(maxres)*3, type*4
        logical cmprs,filexs
        data type /'.sst'/

        do  i = 1, nseq1 
c ------- get a full atom filename from pdbcod or explicit atmfull:
          call atmdef(1,pdbcod(i),atmdir,atmfil(i),1,atmfull(i),istop)

c ------- Does the PDB file exist?
          if (filexs(atmfull(i))) then
            call mkfile(atmdir,atmfull(i),range(1,i),alnchn(1,i),type,
     &                  fname,ipdbfnd,cmprs,1,outdir)

            call rdsst(ioinp,iolog,fname,ssec(1,i),reschk,nreschk,
     &                 maxres,ierr)
            if (ierr .gt. 0) accepts(i) = .false.
            call chkseq(type, i, nreschk, reschk, ierr)
            if (ierr .gt. 0) accepts(i) = .false.

          else

            accepts(i) = .false.

          end if

        end do

        return
      end



      subroutine mkadih(idiht,istop)
        implicit none
#include "mdt_all.cmn"
        integer i, idiht, ityp, istop
        logical chklbl, degr
        data ityp /0/
        data chklbl, degr /.true., .true./

        do  i = 1, nseq1 
          call dihedn(xn(1,i),yn(1,i),zn(1,i),iresatmn(1,i),
     &         iatmr1n(1,i),atmnamn(1,i),resnamn(1,i),nresn(i),
     &         natmn(i),idiht,ityp,degr,chklbl,dih(1,idiht,i))
          if (idiht.eq.ichi2typ.or.idiht.eq.ichi3typ.or.idiht.eq.
     &        ichi5typ)
     &      call dihdisn(xn(1,i),yn(1,i),zn(1,i),
     &           iatmr1n(1,i),atmnamn(1,i),resnamn(1,i),nresn(i),
     &           natmn(i),degr,dih(1,ichi1typ,i),dih(1,ichi2typ,i),
     &           dih(1,ichi3typ,i),dih(1,ichi4typ,i),dih(1,ichi5typ,i))
        end do

        return
      end


      subroutine rdapsa
        implicit none
#include "io.cst"
#include "mdt_all.cmn"
        integer i, j, iattypn(maxatm)
        real atmacc(maxatm), resacc(10,maxres), r(maxatm)
        logical error

c ----- expecting that the coordinates are already in memory!

c ----- Are the derivative data already in memory?
        if (.not. datrdy(1)) then
        datrdy(1) = .true.

        do  i = 1, nseq1
          error = .false.
          do  j = 1, natmn(i)
            call iup2crm(atmnamn(j,i),iattypn(j),
     &                   irestypn(iresatmn(j,i),i),error)
          end do
          write(iolog,'(a,i5)') 
     &    'rdapsa___> calculating psa for str: ', i
          call psa(surftyp,rprobe,stepint,xn(1,i),yn(1,i),zn(1,i),
     &         natmn(i),nresn(i),iatmr1n(1,i),iattypn,irestypn(1,i),
     &         atmnamn(1,i),vdwcnt,nvdwtyp,r,atmacc,resacc)
          do  j = 1, nresn(i)
            acc(j, i) = resacc(iacc1typ, j)
          end do
        end do

        end if

        return
      end


      subroutine rdapsa_old(istop)
        implicit none
#include "io.cst"
#include "mdt_all.cmn"
        integer i, nreschk, ierr, ipdbfnd, istop
        character fname*255, reschk(maxres)*3, type*4
        logical cmprs,filexs
        data type /'.psa'/

        do  i = 1, nseq1 
c ------- get a full atom filename from pdbcod or explicit atmfull:
          call atmdef(1,pdbcod(i),atmdir,atmfil(i),1,atmfull(i),istop)

c ------- Does the PDB file exist?
          if (filexs(atmfull(i))) then
            call mkfile(atmdir,atmfull(i),range(1,i),alnchn(1,i),type,
     &                  fname,ipdbfnd,cmprs,1,outdir)

            call rdpsa(ioinp,iolog,fname,acc(1,i),reschk,nreschk,
     &                 iacc1typ,maxres,ierr)
            if (ierr .gt. 0) accepts(i) = .false.
            call chkseq(type, i, nreschk, reschk, ierr)
            if (ierr .gt. 0) accepts(i) = .false.

          else

            accepts(i) = .false.

          end if
        end do

        return
      end



      subroutine rdangh
        implicit none
#include "io.cst"
#include "mdt_all.cmn"
        integer i

c ----- expecting that the coordinates are already in memory!

c ----- Are the derivative data already in memory?
        if (.not. datrdy(2)) then
        datrdy(2) = .true.

        do  i = 1, nseq1 
          call neighs(iolog,xn(1,i),yn(1,i),zn(1,i),nresn(i),natmn(i),
     &         iatmr1n(1,i),distngh,neigh(1,i),ineigh(1,1,i),
     &         maxngh,sdchngh)
        end do

        end if

        return
      end



      subroutine rdangh_old(istop)
        implicit none
#include "io.cst"
#include "mdt_all.cmn"
        integer i, nreschk, ierr, ipdbfnd, istop
        character fname*255, reschk(maxres)*3, type*4
        logical cmprs,filexs
        data type /'.ngh'/

        do  i = 1, nseq1 
c ------- get a full atom filename from pdbcod or explicit atmfull:
          call atmdef(1,pdbcod(i),atmdir,atmfil(i),1,atmfull(i),istop)

c ------- Does the PDB file exist?
          if (filexs(atmfull(i))) then
            call mkfile(atmdir,atmfull(i),range(1,i),alnchn(1,i),type,
     &                  fname,ipdbfnd,cmprs,1,outdir)

            call rdngh(ioinp,iolog,fname,neigh(1,i),ineigh(1,1,i),
     &                 reschk,nreschk,maxres,maxngh,ierr)
            if (ierr .gt. 0) accepts(i) = .false.
            call chkseq(type, i, nreschk, reschk, ierr)
            if (ierr .gt. 0) accepts(i) = .false.

          else

            accepts(i) = .false.

          end if
        end do

        return
      end



      subroutine rdacnt(istop)
        implicit none
#include "io.cst"
#include "mdt_all.cmn"
        integer i, nreschk, ierr, ipdbfnd, istop
        character fname*(255), reschk(maxres)*3, type*4
        logical cmprs,filexs
        data type /'.cnt'/

        do  i = 1, nseq1 
c ------- get a full atom filename from pdbcod or explicit atmfull:
          call atmdef(1,pdbcod(i),atmdir,atmfil(i),1,atmfull(i),istop)

c ------- Does the PDB file exist?
          if (filexs(atmfull(i))) then
            call mkfile(atmdir,atmfull(i),range(1,i),alnchn(1,i),type,
     &                  fname,ipdbfnd,cmprs,1,outdir)

            call rdcnt(ioinp,iolog,fname,rncnts(1,i),reschk,nreschk,
     &                 maxres,ierr)
            if (ierr .gt. 0) accepts(i) = .false.
            call chkseq(type, i, nreschk, reschk, ierr)
            if (ierr .gt. 0) accepts(i) = .false.

          else

            accepts(i) = .false.

          end if
        end do

        return
      end


      subroutine rdngh(ioinp,iolog,fname,neigh,ineigh,resnam,nres,
     &                 maxres,maxngh,ierr)
        implicit none
        integer maxngh, i, nres, ierr,lenr,iolog
        integer maxres, ioinp, neigh(maxres), ineigh(maxngh,maxres)
        character fname*(*), resnam(maxres)*(*), line*80
        logical compressed,iowr

        call openf4(ioinp,fname,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .false.,ierr,compressed,iolog)

        nres = 0

        if (ierr .ne. 0) go to 500

5       read(ioinp,'(a)',end=500,err=500) line 
        if (line(1:5) .ne. 'START') go to 5

        nres = 1
10      read(ioinp, 20, end=100, err=500) i, resnam(nres), neigh(nres)
20        format(i4,7x,a3,1x,i3)
          if (neigh(nres) .gt. 0) then
            if (neigh(nres) .gt. maxngh) then
              if (iowr(3))
     &          write(iolog,'(a,2i6)')
     &          'rdngh___W> too many neighs; res, nghs: ',
     &          nres,neigh(nres)
              neigh(nres) = maxngh
            end if
            read(ioinp,*) (ineigh(i,nres),i=1,neigh(nres))
          end if
          nres = nres + 1
          go to 10
100     continue
        nres = nres - 1
        close(ioinp) 
        call unprepfil(fname, compressed)
        ierr = 0
        return

500     continue
        nres = nres - 1
        ierr = 1
        write(iolog,'(a,a)') 'rdngh___E> opening/reading file: ',
     &        fname(1:lenr(fname))
        return
      end


      subroutine rdcnt(ioinp,iolog,fname,neigh,resnam,nres,maxres,ierr)
        implicit none
        integer maxres, ierr, i, nmain, nside, ioinp, nres, lenr, iolog
        character fname*(*), resnam(maxres)*(*), line*80
        real neigh(maxres)
        logical compressed

        call openf4(ioinp,fname,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .false.,ierr,compressed,iolog)

        nres = 0

        if (ierr .ne. 0) go to 500

5       read(ioinp, '(a)',end=500,err=500) line
        if (line(1:5) .ne. 'START') go to 5

        nres = 1
10      read(ioinp, 20, end=100, err=500) i, resnam(nres), nmain, nside
20        format(i4,7x,a3,1x,2i3)
          neigh(nres) = nmain + nside
          nres = nres + 1
          go to 10
100     continue
        nres = nres - 1
        close(ioinp) 
        ierr = 0
        call unprepfil(fname, compressed)
        return

500     ierr = 1
        nres = nres - 1
        write(iolog,*) 'rdcnt___E> error reading file: ', 
     &                 fname(1:lenr(fname))

        return
      end



      subroutine rdpsa(ioinp, iolog, fname, acc, resnam, nres, iacctyp, 
     &                 maxres, ierr)
        implicit none
        integer i, ioinp,nres,maxres,iacctyp,ierr,iolog
        real acc(maxres), accv(10)
        character line*80, fname*(*), resnam(maxres)*(*)
        logical compressed

        call openf4(ioinp,fname,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .false.,ierr,compressed,iolog)

        nres = 0

        if (ierr .ne. 0) go to 300

10      read(ioinp, '(a78)', end = 100, err=300)line
          if ((line(1:6).eq.'ACCESS').or.(line(1:6).eq.'ATOM  '))then
            nres = nres + 1
            read(line,30)resnam(nres),(accv(i),i=1,10)
30          format(14x, a3, 1x, 5(2x,f5.2,f5.1))
            acc(nres) = accv(iacctyp)
          end if
          go to 10
100     continue
        close(ioinp)
        ierr = 0
        call unprepfil(fname, compressed)
        return

300     ierr = 1
        write(iolog,'(2a)') 'rdpsa___E> reading file: ', fname
        return

      end




      subroutine rdsst(ioinp,iolog,fname,ssec,resnam,nres,maxres,ierr)
        implicit none
        integer ioinp, maxres,ierr, nres, iolog
        character line*132, fname*(*)
        character ssec(maxres)*1, resnam(maxres)*(*)
        logical compressed

        call openf4(ioinp,fname,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .false.,ierr,compressed,iolog)

        nres = 0

        if (ierr .ne. 0) go to 300

10      read(ioinp, '(a)', err=300, end=300) line
        if (index(line, 'num  seq.no ') .lt. 1) go to 10

20      read(ioinp, '(a)', err=300, end=40) line
          if (line(1:1) .eq. char(12)) go to 40
          nres = nres + 1
          read(line, 30, err=300) resnam(nres), ssec(nres)
30        format(14x,a3,5x,a1,22x,3(1x,f6.1))
          go to 20
40      continue

        close(ioinp)
        call unprepfil(fname, compressed)
        ierr = 0
        return

300     ierr = 1
        write(iolog,'(2a)') 'rdsst___E> reading file: ', fname
        return

      end


      subroutine rdsst2(ioinp,iolog,fname,phi,psi,omega,chi1,chi2,chi3,
     &                  chi4,ssec,resnam,nres,maxres,ierr)
        implicit none
        integer ioinp, maxres,ierr, nres, iolog
        real phi(maxres), psi(maxres), chi1(maxres), chi2(maxres)
        real chi3(maxres), chi4(maxres), omega(maxres)
        character line*132, fname*(*)
        character ssec(maxres)*1, resnam(maxres)*(*)
        logical compressed

        call openf4(ioinp,fname,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .false.,ierr,compressed,iolog)

        nres = 0

        if (ierr .ne. 0) go to 300

10      read(ioinp, '(a)', err=300, end=300) line
        if (index(line, 'num  seq.no ') .lt. 1) go to 10

20      read(ioinp, '(a)', err=300, end=40) line
          if (line(1:1) .eq. char(12)) go to 40
          nres = nres + 1
          read(line, 30, err=300) resnam(nres), ssec(nres), phi(nres), 
     &                   psi(nres), omega(nres)
30        format(14x,a3,5x,a1,22x,3(1x,f6.1))
          go to 20
40      continue

50      read(ioinp, '(a)', err=300, end=300) line
        if (index(line, 'num  seq.no ') .lt. 1) go to 50

        nres = 0
60      read(ioinp, '(a)', err=300, end=80) line
          if (line(1:1) .eq. char(12)) go to 80
          nres = nres + 1
          read(line, 70, err=300) resnam(nres), chi1(nres), chi2(nres),
     &                   chi3(nres), chi4(nres)
70        format(12x,a3,12x,4(1x,f6.1))
          go to 60
80      continue

        close(ioinp)
        call unprepfil(fname, compressed)
        ierr = 0
        return

300     ierr = 1
        write(iolog,'(2a)') 'rdsst2__E> reading file: ', fname
        return

      end

      subroutine chkseq(where, ibrk, nreschk, reschk, ierr)
        implicit none
#include "io.cst"  
#include "mdt_all.cmn"  
        integer ibrk, nreschk, irt, i, istr2int, ierr, nerr, k, j
        character where*(*), reschk(nreschk)*(*), res3*(3), nghs*(11)
        character int2str*(3)

        ierr = 0

c ----- check the number of residues with that from an alignment:
        if(nresn(ibrk).ne.nreschk) then
          write(iolog,5)where, nresn(ibrk), nreschk, ibrk
5         format('chkseq__E> Numbs of res in ALN<>',a,', STR: ', 3i6)
          ierr = 2
        end if

c ----- check the residue types with that from the alignment: 
        nerr = 0
        do  i = 1, nreschk
          irt = istr2int(reschk(i))
          if (irestypn(i,ibrk) .ne. irt) then
           nerr = nerr + 1
           if (nerr .le. 10) then

            if (nerr .eq. 1) write(iolog,'(4a)') 'chkseq__E> ', where,
     &      ' STRCT INDEX        ITYP     RES    ALN_ITYP ALN_RES',
     &      '    ALN_NGHS'

            k = 0
            do  j = i-5, i+5
              k = k + 1
              if (j.lt.1.or.j.gt.naln) then
                nghs(k:k) = '-'
              else
                nghs(k:k) = ccaln(j,ibrk)
              end if
            end do
            res3 = int2str(irestypn(i,ibrk))

            write(iolog,'(15x,2i6, 4x, i8,5x,a3, 4x, i8,5x,a3,1x,a)') 
     &      ibrk, i, irt, reschk(i), irestypn(i,ibrk), res3, nghs

            ierr = 1
           end if
          end if
        end do

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    ATMDEF() routine tries to obtain the names of the existing atom 
cf    files for all entries in the alignment. It ATOM_FILES is defined
cf    it uses ATOM_FILES with the PDBNAM routine; otherwise, it uses 
cf    the alignment PDBCOD() with the PDBNAM routine.
cf
cf    subroutine atmdef(nseq,pdbcod,atmdir,atmfil,natmfil,atmfull,istop)
cf
cf ----------------------------------------------------------------------------

      subroutine atmdef(nseq,pdbcod,atmdir,atmfil,natmfil,atmfull,istop)
        implicit none
        integer iseq, nseq, natmfil, ipdbfnd, lenr, istop
        character pdbcod(nseq)*(*),pdbloc*255
        character atmfil(natmfil)*(*), atmfull(nseq)*(*), atmdir*(*)
        logical cmprs

        do  iseq = 1, nseq
          pdbloc = pdbcod(iseq)

c ------- if there is an explicit ATOM_FILES entry use it:
          if (iseq.le.natmfil) then
            if (lenr(atmfil(iseq)).gt.0) pdbloc = atmfil(iseq)
          end if

          call pdbnam(atmdir,pdbloc,atmfull(iseq),ipdbfnd,cmprs,istop,0)
        end do

        return
      end
