cf ----------------------------------------------------------------------------
cf
cf    RDAMOD()  reads in the library file that specifies the topology
cf    models in terms of an atom subsets of the most detailed model
cf    for each residue type.
cf
cf    subroutine rdamod(ioinp,iolog,modfil,nx,na,a,nmod,maxna,maxnx,
cf   &                  maxmod)
cf
cf ----------------------------------------------------------------------------

      subroutine rdamod(ioinp,iolog,modfil,nx,na,a,nmod,maxna,maxnx,
     &                  maxmod)
        implicit none
        integer maxn
        parameter (maxn=100)
        integer n, i, nmod, ioinp, maxmod, maxna, maxnx, nx(maxmod)
        integer na(maxmod),iolog,ierr
        real buffr(maxn), a(maxna,maxmod)
        character line*1024, modfil*(*)
        logical cmpr

        call openf4(ioinp,modfil,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .true.,ierr,cmpr,iolog)

        nmod = 0
10      read(ioinp, '(a)', end=100) line
          if (line(1:1) .ne. '#') then
            nmod = nmod + 1

            if (nmod.gt.maxmod)
     &        stop 'rdamod__E> too many models. increase MAXMOD.'

            call str_rn2(line, buffr, maxn, n, ierr)

            if (n-2 .ne. buffr(2)) then
              write(*,*)'rdamod__E> no of parameters <> specified: ',
     &                  n-2, buffr(2)
              stop
            end if

            nx(nmod) = nint(buffr(1))
            na(nmod) = nint(buffr(2))

            if (nx(nmod).gt.maxnx)
     &      stop 'rdamod__E> too many indpndnt vars. increase MAXNX.'
            if (na(nmod).gt.maxna)
     &        stop 'rdamod__E> too many parameters. increase MAXNA.'

            do  i = 1, na(nmod)
              a(i,nmod) = buffr(i+2)
            end do
          end if
          go to 10
100     continue
        close(ioinp)

        return
      end
