cf ----------------------------------------------------------------------------
cf
cf   RDRDIH() reads the library file of all dihedral angles for many
cf   residue types. It also reads the numbers of optima and their specs
cf   for each dihedral angle. It returns values in degrees if degr=.true.,
cf   otherwise in radians.
cf
cf    subroutine rdrdih(ioinp,dihfnam2,degr)
cf
cf ----------------------------------------------------------------------------

      subroutine rdrdih(ioinp,iolog,dihfnam2,degr)
        implicit none
#include "numbers.cst"
#include "reslib.cst"
#include "lenf.cst"
#include "dihlib.cst"
#include "dihlib.cmn"
        integer mbuffr
        parameter (mbuffr = 50)
        integer nreslib,irest,nbuffr,nd,ii,iolog
        integer i,j,k,ioinp,icrm2int,ndihnam,ierr
        real radians2
        character dihfnam2*(*),card*(255),reschrm*(4)
        character buffr(mbuffr)*(15)
        logical degr,iowr,cmpr

        call openf4(ioinp,dihfnam2,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .true.,ierr,cmpr,iolog)
5       read(ioinp, '(a)', end=100) card
        if (card(1:8) .ne. '# START:') go to 5

        read(ioinp,'(a)') card
        call str_sn2(card, dihnam, mdihtyp, ndihnam)

        read(ioinp,*) nreslib
        if (nreslib.gt.mrestyp) stop 'rdrdih__E> increase mrestyp'

        ndiht = 0
        ndihc = 0
        do  i = 1, nreslib
          read(ioinp, '(a)', end=110) card
          call str_sn2(card, buffr, mbuffr, nbuffr)
          if (nbuffr .ne. 2) stop 'rdrdih__E> nbuffr<>2'
          reschrm = buffr(1)
          call str_i(buffr(2), nd, ierr)
          if(nd.gt.mdihtyp)stop 'rdrdih__E> increase mdihtyp'
          ndiht = max(nd, ndiht)
          irest = icrm2int(reschrm)
          if (irest .eq. 0) then
            write(iolog,'(a)')
     &      'rdrdih__E> CHARMM residue type unrecognized:', reschrm
            stop
          end if
          ndihlib(irest) = nd

          do  j = 1, ndihlib(irest)

            read(ioinp,'(a)',end=110) card
            call str_sn2(card,buffr,mbuffr,nbuffr)

            do  k = 1, 4
              dihlib(k,j,irest) = buffr(k)
            end do
            call str_i(buffr(5), ndihopt(j,irest), ierr)
            if (ndihopt(j,irest) .gt. mdihopt-1)
     &        stop 'rdrdih__E> increase mdihopt'
            nd = ndihopt(j,irest)
            ndihc = max(ndihc, nd)
            if ((5+5*nd) .ne. nbuffr) then
              write(iolog,*)'rdrdih__E> incorrect # of items on line:'
              write(iolog,*) card
              stop
            end if
            ii = 5+3*nd
            do  k = 1, ndihopt(j,irest)
              call str_r2(buffr(5+k),wdihlib(k,j,irest),ierr)
              call str_r2(buffr(5+nd+k),adihlib(k,j,irest),ierr)
              call str_r2(buffr(5+2*nd+k),sdihlib(k,j,irest),ierr)
              ii = ii + 1
              call str_r2(buffr(ii),dihcls(1,k,j,irest),ierr)
              ii = ii + 1
              call str_r2(buffr(ii),dihcls(2,k,j,irest),ierr)
            end do

c            write(iolog,'(4(a5,1x),i2,1x,999f9.3)')
c     -           ((dihlib(k,j,irest)),k=1,4),
c     -           ndihopt(j,irest),
c     -           (wdihlib(k,j,irest),k=1,min(mdihopt,ndihopt(j,irest))),
c     -           (adihlib(k,j,irest),k=1,min(mdihopt,ndihopt(j,irest))),
c     -           (sdihlib(k,j,irest),k=1,min(mdihopt,ndihopt(j,irest)))

c --------- convert to radians without changing the phase:
            if (.not. degr) then
              do  k = 1, ndihopt(j,irest)
                adihlib(k,j,irest)  = radians2(adihlib(k,j,irest))
                sdihlib(k,j,irest)  = radians2(sdihlib(k,j,irest))
                dihcls(1,k,j,irest) = radians2(dihcls(1,k,j,irest))
                dihcls(2,k,j,irest) = radians2(dihcls(2,k,j,irest))
              end do
            end if

c --------- check self-consistency of means and ranges:
            do  k = 1, ndihopt(j,irest)
              if (adihlib(k,j,irest) .gt. dihcls(2,k,j,irest) .or.
     &            adihlib(k,j,irest) .lt. dihcls(1,k,j,irest)) then
                write(iolog, '(a,2i3,1x,a,1x,3f9.3)')
     &          'rdrdih__E> opt,dih,res mean out of range:',
     &          k, j, reschrm,adihlib(k,j,irest),
     &          dihcls(1,k,j,irest), dihcls(2,k,j,irest)
                stop
              end if
            end do

c --------- check weights:
            call wghnorm(wdihlib(1,j,irest),ndihopt(j,irest),j,irest)

c --------- for the purposes of csrdih() (to allow use of the mdt files
c           with undefined bin):
            do  k = ndihopt(j,irest)+1, mdihopt
              wdihlib(k,j,irest) = 0.0
              adihlib(k,j,irest) = nundf
              sdihlib(k,j,irest) = nundf
            end do

          end do
        end do
        close(ioinp)

        if (ndihnam .ne. ndiht)
     &    write(iolog,'(a,2i4)') 'rdrdih__W> ndihnam <> ndiht: ',
     &    ndihnam,ndiht

        if (iowr(2)) then
          write(iolog,'(a,i4/a,i4/a,999(a,1x))')
     &    'rdrdih___> Number of dihedral angle types: ',ndiht,
     &    '           Maximal number of optima      : ',ndihc,
     &    '           dihedral names : ',
     &    (dihnam(k), k = 1, ndihnam)
        end if

        return

100     write(iolog,'(a)') 'rdrdih__E> no "# START:" card.'
        stop

110     write(iolog,'(a)') 'rdrdih__E> premature eof.'
        stop
      end




cf ----------------------------------------------------------------------------
cf
cf    WGHNORM() routine checks and normalizes a unit vector wgh. I1 and
cf    I2 are id's for warnings.
cf
cf    subroutine call wghnorm(wgh,n,i1,i2)
cf
cf ----------------------------------------------------------------------------

      subroutine wghnorm(wgh,n,i1,i2)
        implicit none
#include "io.cst"
#include "numbers.cst"
        integer n, i1, i2, k
        real wgh(n), sum

        sum = 0.0
        do  k = 1, n
          sum = sum + wgh(k)
        end do

        if (abs(sum) .lt. tenm2) then
          write(iolog,'(a,f8.5,2i4)')
     &    'wghnorm_E> weights are (almost) 0; i1,i2: ', sum, i1, i2
          stop
        end if

        if (abs(sum-1.0) .gt. tenm2) then
          write(iolog,'(a,f8.5,2i4)')
     &    'wghnorm_W> weights do not sum to 1; i1,i2: ', sum, i1, i2
          write(iolog,'(a,999f8.5)')
     &    '           old weights            : ',
     &    (wgh(k),k=1,n)
          do  k = 1, n
            wgh(k) = wgh(k) / sum
          end do
          write(iolog,'(a,999f8.5)')
     &    '           new weights            : ',
     &    (wgh(k),k=1,n)
        else
          do  k = 1, n
            wgh(k) = wgh(k) / sum
          end do
        end if

        return
      end
