      subroutine neighs(iolog,x,y,z,nres,natm,iatmr1,distngh,neigh,
     -                  ineigh,maxngh,sdch)
        integer nres, natm, iatmr1(nres), neigh(nres) 
        integer ineigh(maxngh,nres),iolog
        integer iatmr2
        real x(natm), y(natm), z(natm)
        logical sdch
     
c ----- scan over all central residues
        do 100 icr = 1, nres
          neigh(icr) = 0

c-------- Find the atoms in the central residue
          if (sdch) then
            iacstart = iatmr1(icr) + 4
          else
            iacstart = iatmr1(icr)
          end if
          iacend = iatmr2(iatmr1, nres, natm, icr)

c ------- examine all potential peripheral residues, omit the central residue:
          do 90  ipr = 1, nres 
           if (ipr .ne. icr) then
c---------- Find the atoms in the peripheral residue
            if (sdch) then
              iapstart = iatmr1(ipr) + 4
            else
              iapstart = iatmr1(ipr)
            end if
            iapend = iatmr2(iatmr1, nres, natm, ipr)

c --------- scan over all atoms in the central residue:
            do 80  ica = iacstart, iacend

c ----------- examine all atoms in the peripheral residue for contact
              do 70  ipa = iapstart, iapend
                d = dist(x(ica),y(ica),z(ica),x(ipa),y(ipa),z(ipa))
                if (d .le. distngh) then
                  neigh(icr) = neigh(icr) + 1
                  if (neigh(icr).gt.maxngh) then
                    write(iolog,'(a)')
     &              'neighs___E> too many neighbours: ', neigh(icr)
                    neigh(icr) = neigh(icr) - 1
                  end if               
                  ineigh(neigh(icr),icr) = ipr
                  go to 90
                end if
70            continue
80          continue
           end if
90        continue
100     continue

        return
      end



      subroutine wrngh(ioout,iolog,fname,neigh,ineigh,resnngh,restngh,
     &                 nresngh,maxres,maxngh,sdch,distngh)
        integer ioout, neigh(maxres), ineigh(maxngh,maxres), nresngh
        integer ierr, iolog
        character fname*(*), resnngh(maxres)*(*), restngh(maxres)*(*)
        character side*3
        logical sdch,cmpr

        if (sdch) then
          side = 'YES'
        else
          side = 'NO '
        end if

        call openf4(ioout,fname,'UNKNOWN','SEQUENTIAL','FORMATTED',3,
     &              .true.,ierr,cmpr,iolog)
        write(ioout, 1) side, distngh, nresngh
1       format('NEAREST NEIGHBOURS' /
     &         'FORMAT   : RES INDEX (I4,1X), RES NUMBER (A5,1X), ' /
     &         '           RES TYPE (A1,1X), NUMBER OF NEIGHBOURS (I3)'/
     &         '           (FOLLOWED BY THAT MANY NEIGHBOURS INDICES)'/
     &         'ONLY SDCH: ', a3 /
     &         'CONT DIST: ', f6.2 /
     &         'TOTAL RES: ', i6 /
     &         'START --------------------------------------------')

        do  i = 1, nresngh
          write(ioout, '(i4,1x,a5,1x,a3,1x,i3)')
     &          i, resnngh(i), restngh(i), neigh(i)
          if (neigh(i) .gt. 0)
     &      write(ioout,'(999i5)') (ineigh(j,i),j=1,neigh(i))
        end do
        close(ioout) 

        return
      end
