cf ----------------------------------------------------------------------------
cf
cf    ICHKMDT() takes some input about the MDT pdf dimensions and 
cf    cross-checks it. It also initializes for using the MDT array 
cf    read in by rdmdt (after rdbin).
cf
cf
cf    Output: 
cf       feature indices 1..nfeat follow the order in the steering file!
cf       nbins(1..nfeat)   ... no of used bins for feature i in MDT
cf       nbinm(1..nfeat)   ... no of used bins for feature i in STEER subset
cf       istart,end,istep  ... starting bin, ending bin, and step for feature i
cf       indi(1..nfeat)    ... the order of features specified in steering file
cf                             as they occur in the mdt.bin file
cf       nelems            ... number of elements in mdt file
cf
cf    subroutine ichkmdt(ndmen2, ndimen, ifeat, ifeat2, nprodp, nfeat, 
cf   -                  nfeat2, nelems, nelms2, maxfeats, indi, istart, 
cf   -                  iend, istep, nbins, nbinm, i1mdt, i2mdt, idmdt,
cf   -                  mfeatcorr)
cf
cf ----------------------------------------------------------------------------

      subroutine ichkmdt(ndmen2, ndimen, ifeat, ifeat2, nprodp, nfeat, 
     &                  nfeat2, nelems, nelms2, maxfeats, indi, istart, 
     &                  iend, istep, nbins, nbinm, i1mdt, i2mdt, idmdt,
     &                  mfeatcorr)
      implicit none  
      integer maxfeats,nfeat,nelems,nelms2,nfeat2,mfeatcorr,i,i1d
      integer ndmen2(mfeatcorr), ndimen(maxfeats), nprodp(mfeatcorr)
      integer ifeat2(mfeatcorr), ifeat(mfeatcorr), indi(mfeatcorr) 
      integer istart(mfeatcorr), iend(mfeatcorr), istep(mfeatcorr)
      integer nbins(mfeatcorr), nbinm(mfeatcorr)
      integer i1mdt(mfeatcorr), i2mdt(mfeatcorr), idmdt(mfeatcorr)

c --- checks:

      if (nfeat2 .ne. nfeat) then
        write(*,*) 'Error[ichkmdt]; no. of feats in STEER <> MDT: ', 
     &             nfeat,nfeat2
        stop
      end if

      if (nfeat .gt. mfeatcorr) then
        write(*,*)'Error[ichkmdt]: too many features in association; ', 
     &            nfeat
        write(*,*) '      increase MFEATCORR.'
        stop
      end if

c --- get the pointers of features read from steering file to that 
c     from mdt data file (steer(indi(i)) = mdt(i):
      call getind(ifeat2, ifeat, nfeat2, nfeat, indi)

      do 10  i = 1, nfeat
        if(ndimen(ifeat(indi(i))) .ne. ndmen2(i)) then
          write(*,*) 'ichkmdt__E> dimensions in BIN <> MDT: ', 
     &               ndimen(ifeat(indi(i))), ndmen2(i)
          write(*,*) '            feature index in MDT: ', i
          write(*,*) '            feature index in INP: ', indi(i)
          write(*,*) '            feature index in BIN: ', 
     &               ifeat(indi(i))
          stop
        end if
10    continue

c --- substitute 0 starts and ends with defaults: 1 and ndimen, respectively:
c --- for MDT file features
      do  i = 1, nfeat2
        if (i1mdt(i) .le. 0) i1mdt(i) = 1
        if (i2mdt(i) .le. 0) i2mdt(i) = ndmen2(i)
        if (idmdt(i) .le. 0) idmdt(i) = 1
      end do

c --- for STEER file features
      do  i = 1, nfeat
        if (istart(indi(i)) .le. 0) 
     &     istart(indi(i)) = i1mdt(i)+abs(istart(indi(i)))
        if (iend(indi(i))   .le. 0) 
     &     iend(indi(i))   = i2mdt(i)-abs(iend(indi(i)))
        if (istep(indi(i))  .le. 0) 
     &     istep(indi(i))  = idmdt(i)
      end do

c --- check whether the STEER feature values are the right sub-set of the MDT
c     values subset:
      do  i = 1, nfeat
        if (mod(istep(indi(i)), idmdt(i)) .ne. 0) then
          write(*,*) 'Warning[initialize]: istep <> INT * idmdt' 
          write(*,*) '     istep, imdt, MDT ifeat: ', 
     &                     istep(indi(i)), idmdt(i), i
          write(*,*)'istep reset to idmdt'
          istep(indi(i)) = idmdt(i) 
        end if

        i1d = istart(indi(i)) - i1mdt(i)
        if (mod(i1d,idmdt(i)) .ne. 0) then
          write(*,*)'Warning[initialize]: istart <> i1mdt+INT*idmdt'
          write(*,*)'     istart, i1mdt, idmdt, MDT ifeat: ',
     &                    istart(indi(i)), i1mdt(i), idmdt(i), i
          write(*,*)'istart reset to i1mdt'
          istart(indi(i)) = i1mdt(i) 
        end if
        if (i1d .lt. 0) then
          write(*,*)'Warning[initialize]: istart < i1mdt, MDT ifeat: '
          write(*,*)'     istart, i1mdt, MDT ifeat: ',
     &                    istart(indi(i)), i1mdt(i), i
          write(*,*)'istart reset to i1mdt'
          istart(indi(i)) = i1mdt(i) 
        end if
        
        if (iend(indi(i)) .gt. i2mdt(i)) then
          write(*,*)'Warning[initialize]: iend > i2mdt, MDT ifeat: '
          write(*,*)'     iend, i2mdt, MDT ifeat: ',
     &                    iend(indi(i)), i2mdt(i), i
          write(*,*)'iend reset to i2mdt'
          iend(indi(i)) = i2mdt(i) 
        end if

      end do

      do  i = 1, nfeat
        if (iend(i) .lt. istart(i)) then
          write(*,*) 'Warning[initialize]: iend < istart, STEER ifeat:',
     &               iend(i), istart(i), i
          stop
        end if
      end do

c --- numbers of used bins in the MDT and super-smoothed arrays:
c     use STEER order in both cases:
      do  i = 1, nfeat
        nbinm(indi(i)) = (i2mdt(i) - i1mdt(i)) / idmdt(i) + 1
        nbins(i) = (iend(i) - istart(i)) / istep(i) + 1
c        nbins(indi(i)) = ndmen2(i)
c        write(*,*) 'i,isteer,indi,imdt: ',i,ifeat(i),indi(i),ifeat(indi(i))
      end do

c      do  i = 1, nfeat
c        write(*,*) 'i,ifeat,nbins: ', i, ifeat(i), nbins(i)
c      end do

c --- for faster evaluation of function indmdt:
      call pindmdt(nbinm,indi,nfeat,nprodp,nelems)

      if (nelms2 .ne. nelems) then
        write(*,*) 'ichkmdt__E> numb of elems in STEER <> MDT: ', 
     &             nelems, nelms2
        stop
      end if

      return
      end



cf ----------------------------------------------------------------------------
cf
cf    WEIGHTS() calculates the weights in the smoothing procesdure for
cf    combining the a priori pdf with the experimental pdf.
cf
cf    subroutine weights(smthw, nbin, sum, w1, w2)
cf
cf ----------------------------------------------------------------------------

      subroutine weights(smthw, nbin, sum, w1, w2)
        implicit none
        real eps
        parameter (eps = 1.0E-10)
        integer nbin
        real smthw, w1, w2, sum
c        write(*,*) 'smthw, sum, nbin: ', smthw, sum, nbin
        if (smthw .gt. eps) then
          w1 = 1.0 / (1.0 + sum/(smthw*nbin))
        else
          w1 = 0.0
        end if
        w2 = 1.0 - w1
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    GETIND() gets the pointers: ind2(ind21(i)) = ind1(i)
cf
cf    subroutine getind(ind1, ind2, n1, n2, ind21)
cf
cf ----------------------------------------------------------------------------

      subroutine getind(ind1, ind2, n1, n2, ind21)
        implicit none
        integer n1, n2, i, j
        integer ind1(n1), ind2(n2), ind21(n1)

        do 20  i = 1, n1
          do  j = 1, n2
            if(ind1(i).eq.ind2(j)) then
              ind21(i) = j 
              go to 20
            end if
          end do
          write(*,*)'Error[getind]: feature not found: ', ind1(i)
          stop 
20      continue

        return
      end
