cf ----------------------------------------------------------------------------
cf
cf    PRECALC() calculates the data needed to create or use the currently 
cf    specified or read in MDT pdf. It makes the bin indices where possible
cf    and does some other things to speed up the tabulation or use of MDT.
cf
cf    subroutine precalc
cf
cf ----------------------------------------------------------------------------

      subroutine precalc
        implicit none
#include "mdt_all.cmn"
        integer i, j, ibrk, ife, ifi, iacontent
        logical datapr(maxfeats,maxseq), equal

c ----- NOTE: value ranges for bins are those for the known in both cases:
c       for the known and unknown (to avoid duplication of bin indices arrays)!

c ----- flag all data types as unprocessed:
        do  i = 1, maxfeats
          do  j = 1, maxseq
            datapr(i,j) = .false.
          end do
        end do

c ----- if testing, always get chi1 and chi2 classes even you only need them
c       when testing chi12 class (for getcsr.f);
        if (actn .eq. 'TEST') then
          if (nfeat+2.gt.mfeatcorr) 
     &       stop 'Error[precalc] increase mfeatcorr'
          ifeat(nfeat+1) = 3
          ifeat(nfeat+2) = 5
          nfeat=nfeat+2
        end if

c ----- precalculate useful data for each structure in the alignment
        do 200  ibrk = 1, nseq1

c ------ do only if all the data files were fine:

         if (accepts(ibrk)) then

         do 100  ife = 1, nfeat 

c --- FEATURE SLOT
          ifi = ifeat(ife)

          if(ifi.lt.1.or.ifi.gt.maxfeats)stop'precalc__E> internal'
          if (idatfeat(ifi) .lt. 1 .or. idatfeat(ifi) .gt. 28) 
     &      stop 'precalc__E> error in mdt1.ini'

          go to (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
     &           21,22,23,24,25,26,27,28) idatfeat(ifi)

c ------- construct the array of chi_1 dihedral angles' bin indices:
1          if (.not. datapr(1,ibrk))then 
             call alliclsbin(nresn(ibrk),dih(1,ichi1typ,ibrk),
     &            idih(1,ichi1typ,ibrk),
     &            rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(1,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of chi_2 dihedral angles' bin indices:
2          if (.not. datapr(2,ibrk))then 
             call alliclsbin(nresn(ibrk),dih(1,ichi2typ,ibrk),
     &            idih(1,ichi2typ,ibrk),
     &            rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(2,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of phi angles' bin indices:
3          if (.not. datapr(3,ibrk)) then
             call alliclsbin(nresn(ibrk),dih(1,iphityp,ibrk),
     &            idih(1,iphityp,ibrk),
     &            rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(3,ibrk) = .true.
           end if
           go to 100

c -------- construct the array of psi angles' bin indices:
4          if (.not. datapr(4,ibrk)) then
             call alliclsbin(nresn(ibrk),dih(1,ipsityp,ibrk),
     &            idih(1,ipsityp,ibrk),
     &            rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(4,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of main chain conformation bin indices:
5          if (.not. datapr(5,ibrk))then
             call mccnfbin(nresn(ibrk),dih(1,iphityp,ibrk),
     &            dih(1,ipsityp,ibrk),ssec(1,ibrk),imnch(1,ibrk),
     &            irestypn(1,ibrk))
             datapr(5,ibrk) = .true.
           end if
           go to 100

c -------- construct the array of the accessibility bin indices
6          if (.not. datapr(6,ibrk))then 
             call alliclsbin(nresn(ibrk),acc(1,ibrk),iacc(1,ibrk),
     &            rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(6,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of the percent sequence identities:
c         (just once)
7          if (.not. datapr(7,1))then 
             call idbin(caln,naln,maxres,nseq,iglbsim,maxseq,nresn,
     &                  rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1,
     &                  fractglsim)
             datapr(7,1) = .true.
           end if
           go to 100

c -------- construct the array of the resolution bin indices
8          if (.not. datapr(8,ibrk))then 
c ---------- artificalially change the resolution of the NMR structures
c            from the defined -1.00 to 0.5, to decrease the number of
c            bins required to hold all defined resolutions while still
c            separating NMR from X-ray structures:
             if (equal(resol(ibrk), -1.00)) resol(ibrk) = 0.45
             call alliclsbin(1,resol(ibrk),iresol(ibrk),
     &            rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(8,ibrk) = .true.
           end if
           go to 100

c ------- no action
9          continue
           go to 100

c ------- construct the array of average side chain Biso indices
10         if (.not. datapr(10,ibrk)) then 
             call bisoind(bison(1,ibrk),iatmr1n(1,ibrk),atmnamn(1,ibrk),
     &                    natmn(ibrk),nresn(ibrk),ibiso(1,ibrk),
     &                    rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(10,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of hetatm contacts indices:
11         if (.not. datapr(11,ibrk)) then
             call alliclsbin(nresn(ibrk),rncnts(1,ibrk),incnts(1,ibrk),
     &            rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(11,ibrk) = .true.
           end if
           go to 100

c -------- construct the array of mainchain conf - Wilmot indices
12         if (.not. datapr(12,ibrk)) then
             call mccnfwbin(nresn(ibrk),dih(1,iphityp,ibrk),
     &            dih(1,ipsityp,ibrk),imnchw(1,ibrk),
     &            irestypn(1,ibrk))
             datapr(12,ibrk) = .true.
           end if
           go to 100

c -------- construct the array of sidechain conf - chi_12 indices
13         if (.not. datapr(13,ibrk)) then
             call sc12dihbin(nresn(ibrk),dih(1,ichi1typ,ibrk),
     &            dih(1,ichi2typ,ibrk),irestypn(1,ibrk),ichi12(1,ibrk),
     &            .true.,.false.)
             datapr(13,ibrk) = .true.
           end if
           go to 100

c -------- construct the array of mainchain A class content for each protein
14         if (.not. datapr(14,ibrk)) then
             call mccnfwbin(nresn(ibrk),dih(1,iphityp,ibrk),
     &                      dih(1,ipsityp,ibrk),imnchw(1,ibrk),
     &                      irestypn(1,ibrk))
             iacont(ibrk) = iacontent(imnchw(1,ibrk),nresn(ibrk),ifi) 
             datapr(14,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of chi_3 dihedral angles' bin indices:
15         if (.not. datapr(15,ibrk))then 
             call alliclsbin(nresn(ibrk),dih(1,ichi3typ,ibrk),
     &                       idih(1,ichi3typ,ibrk),
     &                       rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(15,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of chi_4 dihedral angles' bin indices:
16        if (.not. datapr(16,ibrk))then 
             call alliclsbin(nresn(ibrk),dih(1,ichi4typ,ibrk),
     &            idih(1,ichi4typ,ibrk),
     &            rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(16,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of the atom indices for distance 1 calculation
17        if (.not. datapr(17,ibrk))then 
             call fndatmi(nresn(ibrk),natmn(ibrk),atmnamn(1,ibrk),
     &                    iatmr1n(1,ibrk),dstatm(1),idsta1(1,ibrk))
             call fndatmi(nresn(ibrk),natmn(ibrk),atmnamn(1,ibrk),
     &                    iatmr1n(1,ibrk),dstatm(2),idsta2(1,ibrk))
             datapr(17,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of chi1 dihedral angle class bin indices:
18        if (.not. datapr(18,ibrk))then 
             call dihclsn(nresn(ibrk),dih(1,ichi1typ,ibrk),
     &            irestypn(1,ibrk),ichi1typ,idihc(1,ichi1typ,ibrk),
     &            .true.,.false.)
             datapr(18,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of chi2 dihedral angle class bin indices:
19        if (.not. datapr(19,ibrk))then 
             call dihclsn(nresn(ibrk),dih(1,ichi2typ,ibrk),
     &            irestypn(1,ibrk),ichi2typ,idihc(1,ichi2typ,ibrk),
     &            .true.,.false.)
             datapr(19,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of chi3 dihedral angle class bin indices:
20        if (.not. datapr(20,ibrk))then 
             call dihclsn(nresn(ibrk),dih(1,ichi3typ,ibrk),
     &            irestypn(1,ibrk),ichi3typ,idihc(1,ichi3typ,ibrk),
     &            .true.,.false.)
             datapr(20,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of chi4 dihedral angle class bin indices:
21        if (.not. datapr(21,ibrk))then 
             call dihclsn(nresn(ibrk),dih(1,ichi4typ,ibrk),
     &            irestypn(1,ibrk),ichi4typ,idihc(1,ichi4typ,ibrk),
     &            .true.,.false.)
             datapr(21,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of omega dihedral angle bin indices (not class):
22         if (.not. datapr(22,ibrk))then
             call alliclsbin(nresn(ibrk),dih(1,iomgtyp,ibrk),
     &            idih(1,iomgtyp,ibrk),
     &            rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(22,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of phi dihedral class bin indices:
23         if (.not. datapr(23,ibrk))then
             call dihclsn(nresn(ibrk),dih(1,iphityp,ibrk),
     &            irestypn(1,ibrk),iphityp,idihc(1,iphityp,ibrk),
     &            .true.,.false.)
             datapr(23,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of psi dihedral class bin indices:
24         if (.not. datapr(24,ibrk))then
             call dihclsn(nresn(ibrk),dih(1,ipsityp,ibrk),
     &            irestypn(1,ibrk),ipsityp,idihc(1,ipsityp,ibrk),
     &            .true.,.false.)
             datapr(24,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of omega dihedral class bin indices:
25         if (.not. datapr(25,ibrk))then
             call dihclsn(nresn(ibrk),dih(1,iomgtyp,ibrk),
     &            irestypn(1,ibrk),iomgtyp,idihc(1,iomgtyp,ibrk),
     &            .true.,.false.)
             datapr(25,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of chi5 dihedral angle bin indices (not class):
26         if (.not. datapr(26,ibrk))then
             call alliclsbin(nresn(ibrk),dih(1,ichi5typ,ibrk),
     &            idih(1,ichi5typ,ibrk),
     &            rang1(1,ifi),rang2(1,ifi),ndimen(ifi)-1)
             datapr(26,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of chi5 dihedral class bin indices:
27         if (.not. datapr(27,ibrk))then
             call dihclsn(nresn(ibrk),dih(1,ichi5typ,ibrk),
     &            irestypn(1,ibrk),ichi5typ,idihc(1,ichi5typ,ibrk),
     &            .true.,.false.)
             datapr(27,ibrk) = .true.
           end if
           go to 100

c ------- construct the array of the atom indices for distance 2 calculation
28        if (.not. datapr(28,ibrk))then 
             call fndatmi(nresn(ibrk),natmn(ibrk),atmnamn(1,ibrk),
     &                    iatmr1n(1,ibrk),dst2atm(1),idst2a1(1,ibrk))
             call fndatmi(nresn(ibrk),natmn(ibrk),atmnamn(1,ibrk),
     &                    iatmr1n(1,ibrk),dst2atm(2),idst2a2(1,ibrk))
             datapr(28,ibrk) = .true.
           end if
           go to 100

c --- FEATURE SLOT

100      continue
         end if
200     continue

c ----- restore the real number of features in the correlation
        if (actn .eq. 'TEST') nfeat = nfeat - 2
        
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    IACONTENT() returns the bin for the fractional content of the mainchain
cf    conformation class A (Wilmot definition, not DSSP).
cf
cf    integer function iacontent(imnw,nr,indfeat)
cf
cf ----------------------------------------------------------------------------

      integer function iacontent(imnw,nr,indfeat)
        implicit none
#include "mdt_all.cmn"
        integer nr, i, indfeat, nal, nbe, npb, iclsbin
        integer imnw(nr)
        real fna

        nal = 0
        nbe = 0
        npb = 0
        do  i = 1, nr
          if (imnw(i) .eq. 1) nal = nal + 1
          if (imnw(i) .eq. 2) nbe = nbe + 1
          if (imnw(i) .eq. 3) npb = npb + 1
        end do

        if (nr .lt. 1) stop 'Error[iacontent]; nres < 1.'
c ----- FP conversion:
        fna = (1.0*nal) / nr

        iacontent = iclsbin(fna,rang1(1,indfeat),rang2(1,indfeat),
     &                      ndimen(indfeat)-1)

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    ICLSBIN() converts a real X into the bin index, given the NRANG
cf    ranges for defined value bin indices. If X not in one of those
cf    ranges, ICLSBIN=NRANG+1.
cf
cf    integer function iclsbin(x,rang1,rang2,nrang)
cf
cf ----------------------------------------------------------------------------

      integer function iclsbin(x,rang1,rang2,nrang)
        implicit none
        integer i, nrang
        real rang1(nrang), rang2(nrang),x

        logical compls
        common /special/ compls

        do  i = 1, nrang
          iclsbin = i
          if ((x.ge.rang1(i)).and.(x.le.rang2(i))) return
        end do
        if (compls) write(*,20) x,rang1(1),rang2(nrang),nrang+1
20      format('  undefined value; X,x1,x2,n,bin: ', 3f10.4,i4)
        iclsbin = nrang + 1
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    ALLICLSBIN() runs ICLSBIN() on a vector of reals and converts all
cf    of them into the bin indices.
cf
cf    subroutine alliclsbin(nres,x,ix,rang1,rang2,nrang)
cf
cf ----------------------------------------------------------------------------

      subroutine alliclsbin(nres,x,ix,rang1,rang2,nrang)
        implicit none
        integer nres,i,ix(nres),nrang,iclsbin
        real x(nres), rang1(nrang), rang2(nrang)
        do  i = 1, nres
          ix(i) = iclsbin(x(i),rang1,rang2,nrang)
        end do
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    BISOIND() prepares the vector of bin indices for average residue
cf    Biso factors. The vector contains indices for all residues in the
cf    protein.
cf
cf    subroutine bisoind(biso,iatmr1,atmnam,natm,nres,ibiso,rang1,
cf   -                   rang2,nrang)
cf
cf ----------------------------------------------------------------------------

      subroutine bisoind(biso,iatmr1,atmnam,natm,nres,ibiso,rang1,
     &                   rang2,nrang)
        implicit none
#include "numbers.cst"
        integer mmaxres
        parameter (mmaxres=1000)
        real fpi2,fact
        parameter (fpi2 = 4.0*pi*pi)
        integer nat,nres,ntot,i,iatmr1(nres), ibiso(nres), nrang
        integer ia1, ia2
        integer ia,natm,iclsbin
        real tot
        real biso(natm), rang1(nrang), rang2(nrang), aver(mmaxres)
        character atmnam(natm)*4

        if(nres.gt.mmaxres) stop 'bisoind_E> increase MMAXRES'

        tot = 0.0
        ntot = 0
        do 20  i = 1, nres
          ia1 = iatmr1(i)
          if (i .eq. nres) then
            ia2 = natm
          else
            ia2 = iatmr1(i+1)-1
          end if

          aver(i) = 0.0
          nat = 0
          do 10  ia = ia1, ia2
c           if (index(' N   CA  C   O  ', atmnam(ia)) .gt. 0) then
            if (index(' N   C   O  ', atmnam(ia)) .le. 0) then
              aver(i) = aver(i) + biso(ia)
              nat = nat + 1
            end if
10        continue

          if (nat .gt. 0) then
            aver(i) = aver(i) / nat
            tot = tot + aver(i)
            ntot = ntot + 1
          else 
            aver(i) = 0.0
          end if

20      continue

c ----- make sure the units are in the order of tens
        if (ntot .gt. 0) then
          tot = tot / ntot
          if (tot .lt. 2.0) then
            fact = fpi2
          else
            fact = 1.0
          end if
          do 30  i = 1, nres
            if (aver(i) .gt. 0.0) then
            ibiso(i) = iclsbin(fact*aver(i),rang1,rang2,nrang)
            else
c ----------- Biso undefined for this residue:
              ibiso(i) = nrang+1
            end if
30        continue
        else
c ------- no Biso in the file, undefined for all residues:
          do 40  i = 1, nres
            ibiso(i) = nrang+1 
40        continue
        end if
     
        return
      end

cf ----------------------------------------------------------------------------
cf
cf    FIDBIN() uses the alignment of sequences and calculates the array
cf    of fraction sequence identity, FRACTGLSIM(I,J).
cf
cf    subroutine fidbin(caln,naln,maxres,nseq,iglbsim,maxseq,nresn,
cf   -                 rang1,rang2,nrang,fractglsim)
cf
cf ----------------------------------------------------------------------------

      subroutine fidbin(caln,naln,maxres,nseq,maxseq,nresn,fractglsim)
      implicit none
      integer maxseq, i1, i2, nid, i, naln, nseq, maxres
      integer nresn(nseq), nidc
      character caln(maxres,nseq)*1
      real fractglsim(maxseq,maxseq)

      do  i1 = 1, nseq-1
        fractglsim(i1,i1) = 1.0
        do  i2 = i1+1, nseq
          nid = nidc(caln(1,i1),caln(1,i2),naln)
          fractglsim(i1,i2) = (1.*nid) / max(1,min(nresn(i1),nresn(i2)))
          fractglsim(i2,i1) = fractglsim(i1,i2)
        end do
      end do
      fractglsim(nseq,nseq) = 1.0

      return
      end

cf ----------------------------------------------------------------------------
cf
cf    IDBIN() uses the alignment of sequences and calculates the array
cf    of fraction sequence identity, FRACTGLSIM(I,J), as well as the bin
cf    indices for the same feature, IGLBSIM(I,J).
cf
cf    subroutine idbin(caln,naln,maxres,nseq,iglbsim,maxseq,nresn,
cf   -                 rang1,rang2,nrang,fractglsim)
cf
cf ----------------------------------------------------------------------------

      subroutine idbin(caln,naln,maxres,nseq,iglbsim,maxseq,nresn,
     &                 rang1,rang2,nrang,fractglsim)
      implicit none
      integer maxseq, i1, i2, nid, i, naln, nseq, maxres, nrang
      integer nresn(nseq), iglbsim(maxseq,maxseq), nidc
      character caln(maxres,nseq)*1
      real rang1(nrang), rang2(nrang), fractglsim(maxseq,maxseq)

      do  i1 = 1, nseq-1
        fractglsim(i1,i1) = 1.0
        do  i2 = i1+1, nseq
          nid = nidc(caln(1,i1),caln(1,i2),naln)
          fractglsim(i1,i2) = (1.*nid) / max(1,min(nresn(i1),nresn(i2)))
          fractglsim(i2,i1) = fractglsim(i1,i2)
        end do
      end do
      fractglsim(nseq,nseq) = 1.0
      do  i = 1, nseq
        call alliclsbin(nseq,fractglsim(1,i),iglbsim(1,i),rang1,
     &                  rang2,nrang)
      end do

c      do  i1 = 1, nseq
c        write(*,'(9999f8.3)') (fractglsim(i1,i2),i2=1,nseq)
c      end do

      return
      end



cf ----------------------------------------------------------------------------
cf
cf    NIDC() calculates the number of identical residues between two sequences
cf    SEQ1 and SEQ2.
cf
cf    integer function nidc(seq1,seq2,naln)
cf
cf ----------------------------------------------------------------------------

      integer function nidc(seq1,seq2,naln)
        implicit none
        integer naln,nid,i
        character seq1(naln)*(*),seq2(naln)*(*),r1*1,r2*1
        logical notaa1

        nid = 0
        do  i = 1, naln
          r1 = seq1(i)
          r2 = seq2(i)
          if (.not. (notaa1(r1) .or. notaa1(r2))) then
            if (r1 .eq. r2) nid = nid + 1
          end if
        end do
        nidc= nid

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    NIDC2() calculates the number of identical residues between two sequences
cf    SEQ1 and SEQ2.
cf
cf    integer function nidc2(ialn1,ialn2,iseq1,iseq2,nres1,nres2,naln)
cf
cf ----------------------------------------------------------------------------

      integer function nidc2(ialn1,ialn2,iseq1,iseq2,nres1,nres2,naln)
        implicit none
        integer naln,nid,i,nres1,nres2,ialn1(naln),ialn2(naln)
        integer iseq1(nres1),iseq2(nres2)

        nid = 0
        do  i = 1, naln
          if ((ialn1(i).ne.0) .and. (ialn2(i).ne.0)) then
            if (iseq1(ialn1(i)) .eq. iseq2(ialn2(i))) nid = nid + 1
          end if
        end do
        nidc2 = nid

        return
      end
