cf ----------------------------------------------------------------------------
cf
cf    RDBIN() reads the mdt1.bin file for the MDT system. This files
cf    specifies the classification into bins of the feature values.
cf
cf    It is useful, but not necessary if you know what you are doing,
cf    if ndihc+1 is the same as ndimen() for the dihedral angle classes.
cf
cf    subroutine rdbin(ioinp,iolog,fname,ndimen,maxfeats,maxrng,symb1,
cf   &           symb2,featnam,rang1,rang2,ndecpl,itsymb,nrescls,
cf   &           nmnch2,mnchcls)
cf
cf ----------------------------------------------------------------------------

      subroutine rdbin(ioinp,iolog,fname,ndimen,maxfeats,maxrng,symb1,
     &           symb2,featnam,rang1,rang2,ndecpl,itsymb,nrescls,
     &           nmnch2,mnchcls)
        implicit none
        integer i,ioinp,maxfeats,maxrng,j,npre,itsymb(maxfeats)
        integer ndimen(maxfeats), ndecpl(maxfeats)
        integer nmnch2,nrescls,ierr,iolog
        real rbeg,dr,dec
        real rang1(maxrng,maxfeats), rang2(maxrng,maxfeats), rngs(2)
        character line*80, symb1(maxrng,maxfeats)*5, card*(40)
        character symb2(maxrng,maxfeats)*5
        character featnam(maxfeats)*(*)
        character fname*(*),mnchcls*(*),int2chr*(1)
        logical cmpr

        call openf4(ioinp,fname,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .true.,ierr,cmpr,iolog)

10      read(ioinp, '(a)', end=100) card
         if (card(1:3) .eq. 'END') go to 100
         if (card(1:7) .eq. 'FEATURE') then
          call str_i(card(8:), i, ierr)
          if ((i .lt. 1) .or. (i .gt. maxfeats)) then
           write(*,'(a,i4)')'rdbin___E> feature index out of range: ',i
           stop
          end if
          read(ioinp, '(a)', end=900) featnam(i)
          read(ioinp, *, end=900) ndimen(i), itsymb(i)

          if (ndimen(i) .gt. 0) then

            if (ndimen(i) .gt. maxrng) then
              write(*,'(a,i5)')'rdbin___E> increase MAXRNG: ',ndimen(i)
              stop
            end if

          if (itsymb(i) .eq. 0) then
c --------- default class names; other things are hird-wired in the code:
            do  j = 1, ndimen(i)-1
              call i_str(j, symb1(j,i), 5)
              call i_str(j, symb2(j,i), 5)
              call ljust(symb1(j,i))
              call ljust(symb2(j,i))
              rang1(j,i) = j-1
              rang2(j,i) = j
            end do
c --------- the last one is always UNDEFINED class:
            symb1(ndimen(i),i) = 'U'
            symb2(ndimen(i),i) = 'U'
            rang1(ndimen(i),i) = ndimen(i)-1
            rang2(ndimen(i),i) = ndimen(i)
          end if

          if (itsymb(i) .eq. 1) then
c --------- only symbols for every range specified explicitly:
            do  j = 1, ndimen(i)
              read(ioinp, '(20x,a5,5x,a5)', end=900)
     &             symb1(j,i),symb2(j,i)
            end do
          end if

          if (itsymb(i) .eq. 2) then
c --------- every range and symbol specified explicitly:
            do  j = 1, ndimen(i)
              read(ioinp, '(a)', end=900) line
              if (j.lt.ndimen(i)) call str_rn(line, rngs, 2, ierr)
              rang1(j,i) = rngs(1)
              rang2(j,i) = rngs(2)
              symb1(j,i) = line(21:25)
              symb2(j,i) = line(31:35)
            end do
          end if

          if (itsymb(i) .eq. 3) then
c --------- only the beginning and the width of ranges specified:
            read(ioinp, *, end=900) rbeg, dr
c --------- now you have to generate ranges and symbols:
            do  j = 1, ndimen(i) - 1
              rang1(j,i) = rbeg + (j-1)*dr
              rang2(j,i) = rang1(j,i) + dr
c ----------- find the number of decimal places required, if not set explicitly:
              if (ndecpl(i) .eq. 0) then
                dec = 1.0
66              if (dr .ge. dec) go to 77
                  dec = dec / 10.0
                  ndecpl(i) = ndecpl(i) + 1
                  go to 66
77              continue
              end if
c ----------- when there are post-decimal digits, there is also decimal point
c             and the number of pre-decimal places has to be decreased
              if (ndecpl(i) .ge. 0) then
                npre = 5 - ndecpl(i) - 1
              else
                npre = 5
                ndecpl(i) = -1
              end if
              call r_str(rang1(j,i),symb1(j,i),npre,ndecpl(i))
              call r_str(rang2(j,i),symb2(j,i),npre,ndecpl(i))
              call ljust(symb1(j,i))
              call ljust(symb2(j,i))
            end do

c --------- the last one is always UNDEFINED class:
            symb1(ndimen(i),i) = 'U'
            symb2(ndimen(i),i) = 'U'
          end if
          end if
         end if
         go to 10
100     continue
        close(ioinp)

c ----- hard-wired in the source code: take care of the 0-type specs:
c
c ----- at least all those features that had ndimen(i) = 0 have to appear here:

c ----- Features 1 and 2 are the residue types of proteins A and B:
        do  j = 1, 21
          symb1(j,1) = ' '
          symb2(j,1) = ' '
          symb1(j,2) = ' '
          symb2(j,2) = ' '
          symb1(j,66) = ' '
          symb2(j,66) = ' '
          symb1(j,67) = ' '
          symb2(j,67) = ' '
          symb1(j,68) = ' '
          symb2(j,68) = ' '
          symb1(j,69) = ' '
          symb2(j,69) = ' '
          symb1(j,77) = ' '
          symb2(j,77) = ' '
          symb1(j,78) = ' '
          symb2(j,78) = ' '
          symb1(j,1)(1:1) = int2chr(j)
          symb2(j,1)(1:1) = int2chr(j)
          symb1(j,2)(1:1) = int2chr(j)
          symb2(j,2)(1:1) = int2chr(j)
          symb1(j,66)(1:1) = int2chr(j)
          symb2(j,66)(1:1) = int2chr(j)
          symb1(j,67)(1:1) = int2chr(j)
          symb2(j,67)(1:1) = int2chr(j)
          symb1(j,68)(1:1) = int2chr(j)
          symb2(j,68)(1:1) = int2chr(j)
          symb1(j,69)(1:1) = int2chr(j)
          symb2(j,69)(1:1) = int2chr(j)
          symb1(j,77)(1:1) = int2chr(j)
          symb2(j,77)(1:1) = int2chr(j)
          symb1(j,78)(1:1) = int2chr(j)
          symb2(j,78)(1:1) = int2chr(j)
        end do
        symb1(22,1) = 'u'
        symb2(22,1) = 'u'
        symb1(22,2) = 'u'
        symb2(22,2) = 'u'
        symb1(22,66) = 'u'
        symb2(22,66) = 'u'
        symb1(22,67) = 'u'
        symb2(22,67) = 'u'
        symb1(22,68) = 'u'
        symb2(22,68) = 'u'
        symb1(22,69) = 'u'
        symb2(22,69) = 'u'
        symb1(22,77) = 'u'
        symb2(22,77) = 'u'
        symb1(22,78) = 'u'
        symb2(22,78) = 'u'

c ----- make sure all the variables needed for the residue class are defined:
        ndimen(71) = nrescls + 1
        ndimen(72) = nrescls + 1
        do  j = 1, ndimen(71)-1
          call i_str(j, symb1(j,71), 5)
          call i_str(j, symb2(j,71), 5)
          call i_str(j, symb1(j,72), 5)
          call i_str(j, symb2(j,72), 5)
          call ljust(symb1(j,71))
          call ljust(symb2(j,71))
          call ljust(symb1(j,72))
          call ljust(symb2(j,72))
          rang1(j,71) = j-1
          rang2(j,71) = j
          rang1(j,72) = j-1
          rang2(j,72) = j
        end do
c ----- the last one is always UNDEFINED class:
        symb1(ndimen(71),71) = 'U'
        symb2(ndimen(71),71) = 'U'
        rang1(ndimen(72),72) = ndimen(71)-1
        rang2(ndimen(72),72) = ndimen(72)

c ----- make sure all the variables needed for the Ramachandran
c       mainchain conformation class are defined:
        ndimen(43) = nmnch2 + 1
        ndimen(44) = nmnch2 + 1
        do  j = 1, nmnch2
          symb1(j,43) = mnchcls(j:j)
          symb2(j,43) = mnchcls(j:j)
          symb1(j,44) = mnchcls(j:j)
          symb2(j,44) = mnchcls(j:j)
          rang1(j,43) = j-1
          rang2(j,43) = j
          rang1(j,44) = j-1
          rang2(j,44) = j
        end do
c ----- the last one is always UNDEFINED class:
        symb1(ndimen(43),43) = 'U'
        symb2(ndimen(44),44) = 'U'
        rang1(ndimen(43),43) = ndimen(43)-1
        rang2(ndimen(44),44) = ndimen(44)
        return

900     continue
        write(*,'(a)') 'rdbin___E> premature end of the BIN file'
        stop

      end
