cf ----------------------------------------------------------------------------
cf
cf    RDWILMOT() reads the library file 36x36 which contains the
cf    mainchain conformation class definitions for all 10x10 
cf    degree areas of the Ramachandran plot. Initially, it was
cf    the Wilmot and Thornton (1990) definition, but is now changed
cf    to my own.
cf
cf    subroutine rdwilmot(ioinp, iolog, fnwilmot, iwilmot, 
cf   &                    nmnch2, mnchcls, nrtyp)
cf
cf ----------------------------------------------------------------------------

      subroutine rdwilmot(ioinp, iolog, fnwilmot, iwilmot, 
     &                    nmnch2, mnchcls, nrtyp)
        implicit none
        integer nrtyp, i, ioinp, j, iwilmot(36,36,nrtyp)
        integer nmnch2, icls, lenr, iolog
        integer ierr, istr2int, irtyp, nr
        character wilmot(36,36)*1, fnwilmot*(*)
        character card*20, mnchcls*(*)
        logical iowr,cmpr
        external iowr,istr2int

        call openf4(ioinp,fnwilmot,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .true.,ierr,cmpr,iolog)
        read(ioinp, '(a)') mnchcls
c ----- number of classes (including the undefined class which is not
c       explicitly specified here):
        nmnch2 = lenr(mnchcls)

        if (iowr(2))
     &    write(iolog,'(2a,1x,i4)') 'rdwilmot_> mnch classes: ', 
     &          mnchcls(1:lenr(mnchcls)), nmnch2

        nr = 0
5       read(ioinp, '(a)', end=10) card
        if (card(1:7) .ne. 'RESIDUE') go to 5

        irtyp = istr2int(card(9:))
        if (irtyp .lt. 1) stop 'rdwilmot_E> undefined residue type'
        nr = nr + 1

        read(ioinp, '(a)') card
        do  i = 1, 36
          read(ioinp, '(2x,36a1)') (wilmot(j,i),j=1,36)
        end do

        do  i = 1, 36
          do  j = 1, 36
            icls = index(mnchcls, wilmot(j,i))
            if (icls .lt. 1 .or. icls .gt. nmnch2) then
              write(iolog,'(a,3i4,1x,a)') 
     &        'rdwilmo_E> error in mainchain class code: ', 
     &        j, i, icls, wilmot(j,i)
              stop
            else
              iwilmot(j,i,irtyp) = icls
            end if
          end do
        end do

        go to 5

10      continue

        if (nr .ne. 20) stop 'rdwilmot_E> missing residue data.'

        close(ioinp)

        return
      end
