c --- This file contains the routines for conversion between 1, 3 and 4 letter,
c     and integer residue codes, in scalar and vector versions.
c --- Integer code 0, character '#', '###' and '####' are for unknown 
c     residue types.
c ------------------------------------------------------------------------
c --- SCALAR VERSIONS:
c      logical function notaa1(aa1)
c      logical function notaa3(aa3)
c      logical function notaa4(aa4)
c      logical function notiaa(iaa)
c      character*(1) function int2chr(ires)
c      character*(3) function int2str(ires)
c      character*(4) function int2crm(ires)
c      character*(3) function chr2str(res1)
c      character*(4) function chr2crm(res1)
c      character*(1) function str2chr(res3)
c      character*(4) function str2crm(res3)
c      character*(1) function crm2chr(res4)
c      character*(3) function crm2str(res4)
c      integer function ichr2int(res1)
c      integer function istr2int(res3)
c      integer function icrm2int(res4)
c --- VECTOR VERSIONS:
c      subroutine int2strn(ires, res3, nres)
c      subroutine int2chrn(ires, res1, nres)
c      subroutine chr2strn(res1, res3, nres)
c      subroutine str2chrn(res3, res1, nres)
c      subroutine str2intn(res3, ires, nres)
c      subroutine chr2intn(res1, ires, nres)
c      subroutine str2crmn(res3, res4, nres)
c      subroutine crm2chrn(res4, res1, nres)
c -----------------------------------------------------------------------


cf ----------------------------------------------------------------------------
cf
cf     NOTAA4() function will return .T. if the argument is not the 
cf     MODELLER code (char*1) for a building block.
cf
cf     logical function notaa4(aa4)
cf
cf ----------------------------------------------------------------------------

      logical function notaa4(aa4)
        implicit none
        integer icrm2int
        character aa4*(4)
        logical notiaa
        notaa4 = notiaa(icrm2int(aa4)) 
        return
      end


cf ----------------------------------------------------------------------------
cf
cf     NOTAA3() function will return .T. if the argument is not the 
cf     PDB code (char*3) for a building block.
cf
cf     logical function notaa3(aa3)
cf
cf ----------------------------------------------------------------------------

      logical function notaa3(aa3)
        implicit none
        integer istr2int
        character aa3*(3)
        logical notiaa
        notaa3 = notiaa(istr2int(aa3)) 
        return
      end


cf ----------------------------------------------------------------------------
cf
cf     NOTAA1() function will return .T. if the argument is not the 
cf     MODELLER code (char*1) for a building block.
cf
cf     logical function notaa1(aa1)
cf
cf ----------------------------------------------------------------------------

      logical function notaa1(aa1)
        implicit none
        integer ichr2int
        character aa1*(1)
        logical notiaa
        notaa1 = notiaa(ichr2int(aa1)) 
        return
      end



cf ----------------------------------------------------------------------------
cf
cf     NOTIAA() function will return .T. if the argument is not the 
cf     integer code for a building block.
cf
cf     logical function notiaa(iaa)
cf
cf ----------------------------------------------------------------------------


      logical function notiaa(iaa)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CST constants define the parameters for the residue type
cf      transformations.
cf
cf      mrestyp = 100   ... maximal number of residue types
cf      mfield  =  20   ... maximal number of characters for all the synonyms
cf                          of a PDB residue name
cf      gapsym  ='GAP'  ... 3-char PDB code for a gap
cf      glysym  ='GLY'  ... 3-char PDB code for a glycine
cf      watsym  ='WAT'  ... 3-char PDB code for a water residue
cf      cyssym  ='CYS'  ... 3-char PDB code for a cysteine/cystine residue
cf      prosym  ='PRO'  ... 3-char PDB code for a proline residue
cf      brksym  ='BRK'  ... 3-char PDB code for a chain break
cf      blksym  ='BLK'  ... 3-char PDB code for a residue block
cf      norid   ='X'    ... 1-char id for no residue id
cf      anyrid  ='@'    ... 1-char id for any residue id
cf
cf ----------------------------------------------------------------------------

        integer mrestyp, mfield
        parameter (mrestyp = 100, mfield = 20)

        character gapsym*(3), watsym*(3), cyssym*(3), prosym*(3)
        character brksym*(3), glysym*(3), blksym*(3)
        character norid*(1), anyrid*(1)
        parameter (gapsym='GAP',watsym='WAT',cyssym='CYS',prosym='PRO')
        parameter (brksym='BRK',glysym='GLY',blksym='BLK')
        parameter (norid='X',anyrid='@')

      integer lenf

c --- Maximal length of a filename:
      parameter (lenf = 128)


cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CMN common blocks define the variables used in translating
cf      residue types. A programming note: all the libraries and data 
cf      structures that contain information for the different residue
cf      types should be isomorphous with the CHARMM residue type
cf      vector. More precisely, the data in the files may be given in
cf      any order, specifying CHARMM residue types that they refer
cf      to, and the library reading routine should then place the
cf      input items into the arrays in the correct order reflecting
cf      the ordering in the reslib.lib file and obtained with
cf      the routines in the residues.f. If the data for a certain
cf      residue type are not in the data file this should also be
cf      reflected without crashing the program later on.
cf
cf ----------------------------------------------------------------------------

        integer nrestyp, igaptyp, iwattyp, icystyp, iprotyp, ibrktyp
        integer iglytyp, iblktyp
        character chmres(mrestyp)*(4), modres(mrestyp)*(1)
        character brkres(mrestyp)*(mfield),resfnam*(128)
        common /ireslib/ nrestyp,igaptyp,iwattyp,icystyp,iprotyp,
     &                   ibrktyp,iglytyp,iblktyp
        common /creslib/ chmres,modres,brkres,resfnam
        integer iaa

        notiaa = (iaa .eq. igaptyp) .or. (iaa .eq. ibrktyp)
  
        return
      end



cf ----------------------------------------------------------------------------
cf
cf    INIRES() routine initializes the residue type transformation routines.
cf    It reads in the table of residue types in different conventions from 
cf    a library file INFIL.
cf
cf    subroutine inires(ioinp, iolog, infil)
cf
cf ----------------------------------------------------------------------------

      subroutine inires(ioinp, iolog, infil)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CST constants define the parameters for the residue type
cf      transformations.
cf
cf      mrestyp = 100   ... maximal number of residue types
cf      mfield  =  20   ... maximal number of characters for all the synonyms
cf                          of a PDB residue name
cf      gapsym  ='GAP'  ... 3-char PDB code for a gap
cf      glysym  ='GLY'  ... 3-char PDB code for a glycine
cf      watsym  ='WAT'  ... 3-char PDB code for a water residue
cf      cyssym  ='CYS'  ... 3-char PDB code for a cysteine/cystine residue
cf      prosym  ='PRO'  ... 3-char PDB code for a proline residue
cf      brksym  ='BRK'  ... 3-char PDB code for a chain break
cf      blksym  ='BLK'  ... 3-char PDB code for a residue block
cf      norid   ='X'    ... 1-char id for no residue id
cf      anyrid  ='@'    ... 1-char id for any residue id
cf
cf ----------------------------------------------------------------------------

        integer mrestyp, mfield
        parameter (mrestyp = 100, mfield = 20)

        character gapsym*(3), watsym*(3), cyssym*(3), prosym*(3)
        character brksym*(3), glysym*(3), blksym*(3)
        character norid*(1), anyrid*(1)
        parameter (gapsym='GAP',watsym='WAT',cyssym='CYS',prosym='PRO')
        parameter (brksym='BRK',glysym='GLY',blksym='BLK')
        parameter (norid='X',anyrid='@')

      integer lenf

c --- Maximal length of a filename:
      parameter (lenf = 128)


cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CMN common blocks define the variables used in translating
cf      residue types. A programming note: all the libraries and data 
cf      structures that contain information for the different residue
cf      types should be isomorphous with the CHARMM residue type
cf      vector. More precisely, the data in the files may be given in
cf      any order, specifying CHARMM residue types that they refer
cf      to, and the library reading routine should then place the
cf      input items into the arrays in the correct order reflecting
cf      the ordering in the reslib.lib file and obtained with
cf      the routines in the residues.f. If the data for a certain
cf      residue type are not in the data file this should also be
cf      reflected without crashing the program later on.
cf
cf ----------------------------------------------------------------------------

        integer nrestyp, igaptyp, iwattyp, icystyp, iprotyp, ibrktyp
        integer iglytyp, iblktyp
        character chmres(mrestyp)*(4), modres(mrestyp)*(1)
        character brkres(mrestyp)*(mfield),resfnam*(128)
        common /ireslib/ nrestyp,igaptyp,iwattyp,icystyp,iprotyp,
     &                   ibrktyp,iglytyp,iblktyp
        common /creslib/ chmres,modres,brkres,resfnam
        integer ioinp,ifind2word
        character infil*(*),line*(80)
        integer ierr,i1,i2,i3,i4,iolog
        logical cmpr

        call openf4(ioinp,infil,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .true.,ierr,cmpr,iolog)
        nrestyp = 0
10      read(ioinp, '(a)', end=100) line
          if (line(1:1) .ne. '#') then
            i1 = index(line, '|')
            i2 = i1 + index(line(i1+1:), '|')
            i3 = i2 + index(line(i2+1:), '|')
            i4 = i3 + index(line(i3+1:), '|')
            nrestyp = nrestyp + 1
            if (nrestyp .gt. mrestyp) then
              write(iolog,'(a)') 'inires__E> increase MRESTAB'
              stop
            end if
            brkres(nrestyp) = line(i1+1:i2-1)
            call ljust(brkres(nrestyp))
            call str_s(line(i2+1:i3-1), modres(nrestyp))
            call str_s(line(i3+1:i4-1), chmres(nrestyp))
          end if
          go to 10
100     continue
        close(ioinp)

        igaptyp = ifind2word(gapsym, brkres, nrestyp)
        if (igaptyp.lt.1) 
     &    write(iolog,'(a)') 'inires__W> gap residue type not found'
        iglytyp = ifind2word(glysym, brkres, nrestyp)
        if (iglytyp.lt.1) 
     &    write(iolog,'(a)') 'inires__W> Gly residue type not found'
        iwattyp = ifind2word(watsym, brkres, nrestyp)
        if (iwattyp.lt.1) 
     &    write(iolog,'(a)') 'inires__W> water residue type not found'
        icystyp = ifind2word(cyssym, brkres, nrestyp)
        if (icystyp.lt.1) 
     &    write(iolog,'(a)') 'inires__W> Cys residue type not found'
        iprotyp = ifind2word(prosym, brkres, nrestyp)
        if (iprotyp.lt.1) 
     &    write(iolog,'(a)') 'inires__W> Pro residue type not found'
        ibrktyp = ifind2word(brksym, brkres, nrestyp)
        if (ibrktyp.lt.1) 
     &    write(iolog,'(a)') 
     &    'inires__W> chain-break residue type not found'
        iblktyp = ifind2word(blksym, brkres, nrestyp)
        if (iblktyp.lt.1) 
     &    write(iolog,'(a)') 'inires__W> block residue type not found'

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    ISTR2INT() function returns an integer type for a three letter
cf    residue code. If a code can not be recognized, 0 is returned;
cf
cf    integer function istr2int(res)
cf
cf ----------------------------------------------------------------------------

      integer function istr2int(res)
      implicit none
      integer ifind2word
      character res*(3)

cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CST constants define the parameters for the residue type
cf      transformations.
cf
cf      mrestyp = 100   ... maximal number of residue types
cf      mfield  =  20   ... maximal number of characters for all the synonyms
cf                          of a PDB residue name
cf      gapsym  ='GAP'  ... 3-char PDB code for a gap
cf      glysym  ='GLY'  ... 3-char PDB code for a glycine
cf      watsym  ='WAT'  ... 3-char PDB code for a water residue
cf      cyssym  ='CYS'  ... 3-char PDB code for a cysteine/cystine residue
cf      prosym  ='PRO'  ... 3-char PDB code for a proline residue
cf      brksym  ='BRK'  ... 3-char PDB code for a chain break
cf      blksym  ='BLK'  ... 3-char PDB code for a residue block
cf      norid   ='X'    ... 1-char id for no residue id
cf      anyrid  ='@'    ... 1-char id for any residue id
cf
cf ----------------------------------------------------------------------------

        integer mrestyp, mfield
        parameter (mrestyp = 100, mfield = 20)

        character gapsym*(3), watsym*(3), cyssym*(3), prosym*(3)
        character brksym*(3), glysym*(3), blksym*(3)
        character norid*(1), anyrid*(1)
        parameter (gapsym='GAP',watsym='WAT',cyssym='CYS',prosym='PRO')
        parameter (brksym='BRK',glysym='GLY',blksym='BLK')
        parameter (norid='X',anyrid='@')

      integer lenf

c --- Maximal length of a filename:
      parameter (lenf = 128)


cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CMN common blocks define the variables used in translating
cf      residue types. A programming note: all the libraries and data 
cf      structures that contain information for the different residue
cf      types should be isomorphous with the CHARMM residue type
cf      vector. More precisely, the data in the files may be given in
cf      any order, specifying CHARMM residue types that they refer
cf      to, and the library reading routine should then place the
cf      input items into the arrays in the correct order reflecting
cf      the ordering in the reslib.lib file and obtained with
cf      the routines in the residues.f. If the data for a certain
cf      residue type are not in the data file this should also be
cf      reflected without crashing the program later on.
cf
cf ----------------------------------------------------------------------------

        integer nrestyp, igaptyp, iwattyp, icystyp, iprotyp, ibrktyp
        integer iglytyp, iblktyp
        character chmres(mrestyp)*(4), modres(mrestyp)*(1)
        character brkres(mrestyp)*(mfield),resfnam*(128)
        common /ireslib/ nrestyp,igaptyp,iwattyp,icystyp,iprotyp,
     &                   ibrktyp,iglytyp,iblktyp
        common /creslib/ chmres,modres,brkres,resfnam

      istr2int = ifind2word(res, brkres, nrestyp)

      return
      end


cf ----------------------------------------------------------------------------
cf
cf    INT2STR() routine returns the char*3 residue type for the integer
cf    residue code; if a code can not be recognized, '###' is returned
cf
cf    character*3 function int2str(ires)
cf
cf ----------------------------------------------------------------------------

      character*3 function int2str(ires)
      implicit none
      integer ires

cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CST constants define the parameters for the residue type
cf      transformations.
cf
cf      mrestyp = 100   ... maximal number of residue types
cf      mfield  =  20   ... maximal number of characters for all the synonyms
cf                          of a PDB residue name
cf      gapsym  ='GAP'  ... 3-char PDB code for a gap
cf      glysym  ='GLY'  ... 3-char PDB code for a glycine
cf      watsym  ='WAT'  ... 3-char PDB code for a water residue
cf      cyssym  ='CYS'  ... 3-char PDB code for a cysteine/cystine residue
cf      prosym  ='PRO'  ... 3-char PDB code for a proline residue
cf      brksym  ='BRK'  ... 3-char PDB code for a chain break
cf      blksym  ='BLK'  ... 3-char PDB code for a residue block
cf      norid   ='X'    ... 1-char id for no residue id
cf      anyrid  ='@'    ... 1-char id for any residue id
cf
cf ----------------------------------------------------------------------------

        integer mrestyp, mfield
        parameter (mrestyp = 100, mfield = 20)

        character gapsym*(3), watsym*(3), cyssym*(3), prosym*(3)
        character brksym*(3), glysym*(3), blksym*(3)
        character norid*(1), anyrid*(1)
        parameter (gapsym='GAP',watsym='WAT',cyssym='CYS',prosym='PRO')
        parameter (brksym='BRK',glysym='GLY',blksym='BLK')
        parameter (norid='X',anyrid='@')

      integer lenf

c --- Maximal length of a filename:
      parameter (lenf = 128)


cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CMN common blocks define the variables used in translating
cf      residue types. A programming note: all the libraries and data 
cf      structures that contain information for the different residue
cf      types should be isomorphous with the CHARMM residue type
cf      vector. More precisely, the data in the files may be given in
cf      any order, specifying CHARMM residue types that they refer
cf      to, and the library reading routine should then place the
cf      input items into the arrays in the correct order reflecting
cf      the ordering in the reslib.lib file and obtained with
cf      the routines in the residues.f. If the data for a certain
cf      residue type are not in the data file this should also be
cf      reflected without crashing the program later on.
cf
cf ----------------------------------------------------------------------------

        integer nrestyp, igaptyp, iwattyp, icystyp, iprotyp, ibrktyp
        integer iglytyp, iblktyp
        character chmres(mrestyp)*(4), modres(mrestyp)*(1)
        character brkres(mrestyp)*(mfield),resfnam*(128)
        common /ireslib/ nrestyp,igaptyp,iwattyp,icystyp,iprotyp,
     &                   ibrktyp,iglytyp,iblktyp
        common /creslib/ chmres,modres,brkres,resfnam
      if ((ires .ge. 1).and. (ires.le. nrestyp)) then
        int2str = brkres(ires)
      else
        int2str = '###'
      end if
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    ICHR2INT() function returns the residue type index of a 
cf    one letter residue code RES.
cf
cf    integer function ichr2int(res)
cf
cf ----------------------------------------------------------------------------

      integer function ichr2int(res)
        implicit none
        integer ifindword
        character res*1

cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CST constants define the parameters for the residue type
cf      transformations.
cf
cf      mrestyp = 100   ... maximal number of residue types
cf      mfield  =  20   ... maximal number of characters for all the synonyms
cf                          of a PDB residue name
cf      gapsym  ='GAP'  ... 3-char PDB code for a gap
cf      glysym  ='GLY'  ... 3-char PDB code for a glycine
cf      watsym  ='WAT'  ... 3-char PDB code for a water residue
cf      cyssym  ='CYS'  ... 3-char PDB code for a cysteine/cystine residue
cf      prosym  ='PRO'  ... 3-char PDB code for a proline residue
cf      brksym  ='BRK'  ... 3-char PDB code for a chain break
cf      blksym  ='BLK'  ... 3-char PDB code for a residue block
cf      norid   ='X'    ... 1-char id for no residue id
cf      anyrid  ='@'    ... 1-char id for any residue id
cf
cf ----------------------------------------------------------------------------

        integer mrestyp, mfield
        parameter (mrestyp = 100, mfield = 20)

        character gapsym*(3), watsym*(3), cyssym*(3), prosym*(3)
        character brksym*(3), glysym*(3), blksym*(3)
        character norid*(1), anyrid*(1)
        parameter (gapsym='GAP',watsym='WAT',cyssym='CYS',prosym='PRO')
        parameter (brksym='BRK',glysym='GLY',blksym='BLK')
        parameter (norid='X',anyrid='@')

      integer lenf

c --- Maximal length of a filename:
      parameter (lenf = 128)


cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CMN common blocks define the variables used in translating
cf      residue types. A programming note: all the libraries and data 
cf      structures that contain information for the different residue
cf      types should be isomorphous with the CHARMM residue type
cf      vector. More precisely, the data in the files may be given in
cf      any order, specifying CHARMM residue types that they refer
cf      to, and the library reading routine should then place the
cf      input items into the arrays in the correct order reflecting
cf      the ordering in the reslib.lib file and obtained with
cf      the routines in the residues.f. If the data for a certain
cf      residue type are not in the data file this should also be
cf      reflected without crashing the program later on.
cf
cf ----------------------------------------------------------------------------

        integer nrestyp, igaptyp, iwattyp, icystyp, iprotyp, ibrktyp
        integer iglytyp, iblktyp
        character chmres(mrestyp)*(4), modres(mrestyp)*(1)
        character brkres(mrestyp)*(mfield),resfnam*(128)
        common /ireslib/ nrestyp,igaptyp,iwattyp,icystyp,iprotyp,
     &                   ibrktyp,iglytyp,iblktyp
        common /creslib/ chmres,modres,brkres,resfnam
        ichr2int = ifindword(res, modres, nrestyp)
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    ICRM2INT() function returns the residue type index of a 
cf    four letter residue code RES.
cf
cf    integer function icrm2int(res)
cf
cf ----------------------------------------------------------------------------

      integer function icrm2int(res)
        implicit none
        integer ifindword
        character res*4

cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CST constants define the parameters for the residue type
cf      transformations.
cf
cf      mrestyp = 100   ... maximal number of residue types
cf      mfield  =  20   ... maximal number of characters for all the synonyms
cf                          of a PDB residue name
cf      gapsym  ='GAP'  ... 3-char PDB code for a gap
cf      glysym  ='GLY'  ... 3-char PDB code for a glycine
cf      watsym  ='WAT'  ... 3-char PDB code for a water residue
cf      cyssym  ='CYS'  ... 3-char PDB code for a cysteine/cystine residue
cf      prosym  ='PRO'  ... 3-char PDB code for a proline residue
cf      brksym  ='BRK'  ... 3-char PDB code for a chain break
cf      blksym  ='BLK'  ... 3-char PDB code for a residue block
cf      norid   ='X'    ... 1-char id for no residue id
cf      anyrid  ='@'    ... 1-char id for any residue id
cf
cf ----------------------------------------------------------------------------

        integer mrestyp, mfield
        parameter (mrestyp = 100, mfield = 20)

        character gapsym*(3), watsym*(3), cyssym*(3), prosym*(3)
        character brksym*(3), glysym*(3), blksym*(3)
        character norid*(1), anyrid*(1)
        parameter (gapsym='GAP',watsym='WAT',cyssym='CYS',prosym='PRO')
        parameter (brksym='BRK',glysym='GLY',blksym='BLK')
        parameter (norid='X',anyrid='@')

      integer lenf

c --- Maximal length of a filename:
      parameter (lenf = 128)


cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CMN common blocks define the variables used in translating
cf      residue types. A programming note: all the libraries and data 
cf      structures that contain information for the different residue
cf      types should be isomorphous with the CHARMM residue type
cf      vector. More precisely, the data in the files may be given in
cf      any order, specifying CHARMM residue types that they refer
cf      to, and the library reading routine should then place the
cf      input items into the arrays in the correct order reflecting
cf      the ordering in the reslib.lib file and obtained with
cf      the routines in the residues.f. If the data for a certain
cf      residue type are not in the data file this should also be
cf      reflected without crashing the program later on.
cf
cf ----------------------------------------------------------------------------

        integer nrestyp, igaptyp, iwattyp, icystyp, iprotyp, ibrktyp
        integer iglytyp, iblktyp
        character chmres(mrestyp)*(4), modres(mrestyp)*(1)
        character brkres(mrestyp)*(mfield),resfnam*(128)
        common /ireslib/ nrestyp,igaptyp,iwattyp,icystyp,iprotyp,
     &                   ibrktyp,iglytyp,iblktyp
        common /creslib/ chmres,modres,brkres,resfnam
        icrm2int = ifindword(res, chmres, nrestyp)
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    INT2CHR() function returns one letter residue code given
cf    an integer index of a residue type RES.
cf
cf    character*1 function int2chr(ires)
cf
cf ----------------------------------------------------------------------------

      character*1 function int2chr(ires)
        implicit none
        integer ires

cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CST constants define the parameters for the residue type
cf      transformations.
cf
cf      mrestyp = 100   ... maximal number of residue types
cf      mfield  =  20   ... maximal number of characters for all the synonyms
cf                          of a PDB residue name
cf      gapsym  ='GAP'  ... 3-char PDB code for a gap
cf      glysym  ='GLY'  ... 3-char PDB code for a glycine
cf      watsym  ='WAT'  ... 3-char PDB code for a water residue
cf      cyssym  ='CYS'  ... 3-char PDB code for a cysteine/cystine residue
cf      prosym  ='PRO'  ... 3-char PDB code for a proline residue
cf      brksym  ='BRK'  ... 3-char PDB code for a chain break
cf      blksym  ='BLK'  ... 3-char PDB code for a residue block
cf      norid   ='X'    ... 1-char id for no residue id
cf      anyrid  ='@'    ... 1-char id for any residue id
cf
cf ----------------------------------------------------------------------------

        integer mrestyp, mfield
        parameter (mrestyp = 100, mfield = 20)

        character gapsym*(3), watsym*(3), cyssym*(3), prosym*(3)
        character brksym*(3), glysym*(3), blksym*(3)
        character norid*(1), anyrid*(1)
        parameter (gapsym='GAP',watsym='WAT',cyssym='CYS',prosym='PRO')
        parameter (brksym='BRK',glysym='GLY',blksym='BLK')
        parameter (norid='X',anyrid='@')

      integer lenf

c --- Maximal length of a filename:
      parameter (lenf = 128)


cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CMN common blocks define the variables used in translating
cf      residue types. A programming note: all the libraries and data 
cf      structures that contain information for the different residue
cf      types should be isomorphous with the CHARMM residue type
cf      vector. More precisely, the data in the files may be given in
cf      any order, specifying CHARMM residue types that they refer
cf      to, and the library reading routine should then place the
cf      input items into the arrays in the correct order reflecting
cf      the ordering in the reslib.lib file and obtained with
cf      the routines in the residues.f. If the data for a certain
cf      residue type are not in the data file this should also be
cf      reflected without crashing the program later on.
cf
cf ----------------------------------------------------------------------------

        integer nrestyp, igaptyp, iwattyp, icystyp, iprotyp, ibrktyp
        integer iglytyp, iblktyp
        character chmres(mrestyp)*(4), modres(mrestyp)*(1)
        character brkres(mrestyp)*(mfield),resfnam*(128)
        common /ireslib/ nrestyp,igaptyp,iwattyp,icystyp,iprotyp,
     &                   ibrktyp,iglytyp,iblktyp
        common /creslib/ chmres,modres,brkres,resfnam
        if ((ires.ge.1).and.(ires.le.nrestyp)) then
          int2chr = modres(ires)
        else
          int2chr = '#'
        end if
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    INT2CRM() is a function that returns four letter residue code 
cf    given an integer index of a residue type RES.
cf
cf    character*4 function int2crm(ires)
cf
cf ----------------------------------------------------------------------------

      character*4 function int2crm(ires)
        implicit none
        integer ires

cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CST constants define the parameters for the residue type
cf      transformations.
cf
cf      mrestyp = 100   ... maximal number of residue types
cf      mfield  =  20   ... maximal number of characters for all the synonyms
cf                          of a PDB residue name
cf      gapsym  ='GAP'  ... 3-char PDB code for a gap
cf      glysym  ='GLY'  ... 3-char PDB code for a glycine
cf      watsym  ='WAT'  ... 3-char PDB code for a water residue
cf      cyssym  ='CYS'  ... 3-char PDB code for a cysteine/cystine residue
cf      prosym  ='PRO'  ... 3-char PDB code for a proline residue
cf      brksym  ='BRK'  ... 3-char PDB code for a chain break
cf      blksym  ='BLK'  ... 3-char PDB code for a residue block
cf      norid   ='X'    ... 1-char id for no residue id
cf      anyrid  ='@'    ... 1-char id for any residue id
cf
cf ----------------------------------------------------------------------------

        integer mrestyp, mfield
        parameter (mrestyp = 100, mfield = 20)

        character gapsym*(3), watsym*(3), cyssym*(3), prosym*(3)
        character brksym*(3), glysym*(3), blksym*(3)
        character norid*(1), anyrid*(1)
        parameter (gapsym='GAP',watsym='WAT',cyssym='CYS',prosym='PRO')
        parameter (brksym='BRK',glysym='GLY',blksym='BLK')
        parameter (norid='X',anyrid='@')

      integer lenf

c --- Maximal length of a filename:
      parameter (lenf = 128)


cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CMN common blocks define the variables used in translating
cf      residue types. A programming note: all the libraries and data 
cf      structures that contain information for the different residue
cf      types should be isomorphous with the CHARMM residue type
cf      vector. More precisely, the data in the files may be given in
cf      any order, specifying CHARMM residue types that they refer
cf      to, and the library reading routine should then place the
cf      input items into the arrays in the correct order reflecting
cf      the ordering in the reslib.lib file and obtained with
cf      the routines in the residues.f. If the data for a certain
cf      residue type are not in the data file this should also be
cf      reflected without crashing the program later on.
cf
cf ----------------------------------------------------------------------------

        integer nrestyp, igaptyp, iwattyp, icystyp, iprotyp, ibrktyp
        integer iglytyp, iblktyp
        character chmres(mrestyp)*(4), modres(mrestyp)*(1)
        character brkres(mrestyp)*(mfield),resfnam*(128)
        common /ireslib/ nrestyp,igaptyp,iwattyp,icystyp,iprotyp,
     &                   ibrktyp,iglytyp,iblktyp
        common /creslib/ chmres,modres,brkres,resfnam
        if ((ires.ge.1).and.(ires.le.nrestyp)) then
          int2crm = chmres(ires)
        else
          int2crm = '####'
        end if
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    CHR2STR() routine returns three letter code, given one letter code.
cf
cf    character*3 function chr2str(res1)
cf
cf ----------------------------------------------------------------------------

      character*3 function chr2str(res1)
        implicit none
        integer ichr2int
        character res1*(1), int2str*(3)
        chr2str = int2str(ichr2int(res1))
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    CHR2CRM() routine returns four letter code, given one letter code.
cf
cf    character*4 function chr2crm(res1)
cf
cf ----------------------------------------------------------------------------

      character*4 function chr2crm(res1)
        implicit none
        integer ichr2int
        character res1*(1), int2crm*(4)
        chr2crm = int2crm(ichr2int(res1))
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    STR2CHR() routine returns one letter code, given three letter code.
cf
cf    character*1 function str2chr(res3)
cf
cf ----------------------------------------------------------------------------

      character*1 function str2chr(res3)
        implicit none
        integer istr2int
        character res3*(3), int2chr*(1)
        str2chr = int2chr(istr2int(res3))
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    CRM2CHR() routine returns one letter code, given four letter code.
cf
cf    character*1 function crm2chr(res4)
cf
cf ----------------------------------------------------------------------------

      character*1 function crm2chr(res4)
        implicit none
        integer icrm2int
        character res4*(4),int2chr*(1)
        crm2chr = int2chr(icrm2int(res4))
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    STR2CRM() routine returns four letter code, given three letter code.
cf
cf    character*4 function str2crm(res3)
cf
cf ----------------------------------------------------------------------------

      character*4 function str2crm(res3)
        implicit none
        integer istr2int
        character res3*(3), int2crm*(4)
        str2crm = int2crm(istr2int(res3))
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    CHR2STR() routine returns three letter code, given four letter code.
cf
cf    character*3 function crm2str(res4)
cf
cf ----------------------------------------------------------------------------

      character*3 function crm2str(res4)
        implicit none
        integer icrm2int
        character res4*(4), int2str*(3)
        crm2str = int2str(icrm2int(res4))
        return
      end

c --- The following are the versions of the above routines, but for vectors
c     of residue codes

cf ----------------------------------------------------------------------------
cf
cf    INT2STRN()
cf
cf    subroutine int2strn(ires, res, nres)
cf
cf ----------------------------------------------------------------------------

      subroutine int2strn(ires, res, nres)
        implicit none
        integer i,nres,ires(nres)
        character res(nres)*3, int2str*(3)
        do  i = 1, nres
          res(i) = int2str(ires(i))
        end do
        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    INT2CHRN()
cf
cf    subroutine int2chrn(ires, res, nres)
cf
cf ----------------------------------------------------------------------------

      subroutine int2chrn(ires, res, nres)
        implicit none
        integer i,nres,ires(nres)
        character res(nres)*1, int2chr*(1)
        do  i = 1, nres
          res(i) = int2chr(ires(i))
        end do
        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    CHR2STRN()
cf
cf    subroutine chr2strn(res1, res3, nres)
cf
cf ----------------------------------------------------------------------------

      subroutine chr2strn(res1, res3, nres)
        implicit none
        integer i, nres
        character res1(nres)*1, res3(nres)*3, chr2str*(3)
        do  i = 1, nres
          res3(i) = chr2str(res1(i))
        end do
        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    STR2CHRN()
cf
cf    subroutine str2chrn(res3, res1, nres)
cf
cf ----------------------------------------------------------------------------

      subroutine str2chrn(res3, res1, nres)
        implicit none
        integer i, nres
        character res1(nres)*1, res3(nres)*3, str2chr*(1)
        do  i = 1, nres
          res1(i) = str2chr(res3(i))
        end do
        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    CRM2CHRN()
cf
cf    subroutine crm2chrn(res4, res1, nres)
cf
cf ----------------------------------------------------------------------------

      subroutine crm2chrn(res4, res1, nres)
        implicit none
        integer i, nres
        character res4(nres)*4, res1(nres)*1, crm2chr*(1)
        do  i = 1, nres
          res1(i) = crm2chr(res4(i))
        end do
        return
      end 



cf ----------------------------------------------------------------------------
cf
cf    STR2CRMN()
cf
cf    subroutine str2crmn(res3, res4, nres)
cf
cf ----------------------------------------------------------------------------

      subroutine str2crmn(res3, res4, nres)
        implicit none
        integer i, nres
        character res4(nres)*4, res3(nres)*3, str2crm*(4)
        do  i = 1, nres
          res4(i) = str2crm(res3(i))
        end do
        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    CRM2STRN()
cf
cf    subroutine crm2strn(res4, res3, nres)
cf
cf ----------------------------------------------------------------------------

      subroutine crm2strn(res4, res3, nres)
        implicit none
        integer i, nres
        character res4(nres)*4, res3(nres)*3, crm2str*(3)
        do  i = 1, nres
          res3(i) = crm2str(res4(i))
        end do
        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    STR2INTN()
cf
cf    subroutine str2intn(res, ires, nres)
cf
cf ----------------------------------------------------------------------------

      subroutine str2intn(res, ires, nres)
        implicit none
        integer i,nres,ires(nres),istr2int
        character res(nres)*3
        do  i = 1, nres
          ires(i) = istr2int(res(i))
        end do
        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    CHR2INTN()
cf
cf    subroutine chr2intn(ires, res, nres)
cf
cf ----------------------------------------------------------------------------

      subroutine chr2intn(res, ires, nres)
        implicit none
        integer i,nres,ires(nres),ichr2int
        character res(nres)*1
        do  i = 1, nres
          ires(i) = ichr2int(res(i))
        end do
        return
      end 


cf ----------------------------------------------------------------------------
cf
cf      FIXSEQ() fixes an amino acid sequence entry in the alignment 
cf      data structures. Asx and Glx to Asn and Gln, respectively; all 
cf      other non-standard residue types into Gly.
cf
cf      call fixseq(irestyp1,nres1,ialn2,caln2,ccaln2)
cf
cf ----------------------------------------------------------------------------

        subroutine fixseq(irestyp,nres,ialn,naln,caln,ccaln)
          implicit none
          integer ires,nres,naln,irestyp(nres),ialn(naln)
          integer iasxtyp,iglxtyp,iasntyp,iglntyp,iglytyp,ichr2int
          character caln(naln)*(1), ccaln(naln)*(1)

          iasxtyp = ichr2int('B')
          iglxtyp = ichr2int('Z')
          iasntyp = ichr2int('N')
          iglntyp = ichr2int('Q')
          iglytyp = ichr2int('G')
 
          do  ires = 1, nres
            if (irestyp(ires).eq.iasxtyp) then
              irestyp(ires) = iasntyp
              ccaln(ires) = 'N'
              caln(ialn(ires)) = 'N'
            end if
            if (irestyp(ires).eq.iglxtyp) then
              irestyp(ires) = iglntyp
              ccaln(ires) = 'Q'
              caln(ialn(ires)) = 'Q'
            end if
            if (irestyp(ires).gt.20) then
              irestyp(ires) = iglytyp
              ccaln(ires) = 'G'
              caln(ialn(ires)) = 'G'
            end if
          end do

          return
        end


      logical function reseqv1(resnum1,chnid1,resnum2,chnid2)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf      RESLIB.CST constants define the parameters for the residue type
cf      transformations.
cf
cf      mrestyp = 100   ... maximal number of residue types
cf      mfield  =  20   ... maximal number of characters for all the synonyms
cf                          of a PDB residue name
cf      gapsym  ='GAP'  ... 3-char PDB code for a gap
cf      glysym  ='GLY'  ... 3-char PDB code for a glycine
cf      watsym  ='WAT'  ... 3-char PDB code for a water residue
cf      cyssym  ='CYS'  ... 3-char PDB code for a cysteine/cystine residue
cf      prosym  ='PRO'  ... 3-char PDB code for a proline residue
cf      brksym  ='BRK'  ... 3-char PDB code for a chain break
cf      blksym  ='BLK'  ... 3-char PDB code for a residue block
cf      norid   ='X'    ... 1-char id for no residue id
cf      anyrid  ='@'    ... 1-char id for any residue id
cf
cf ----------------------------------------------------------------------------

        integer mrestyp, mfield
        parameter (mrestyp = 100, mfield = 20)

        character gapsym*(3), watsym*(3), cyssym*(3), prosym*(3)
        character brksym*(3), glysym*(3), blksym*(3)
        character norid*(1), anyrid*(1)
        parameter (gapsym='GAP',watsym='WAT',cyssym='CYS',prosym='PRO')
        parameter (brksym='BRK',glysym='GLY',blksym='BLK')
        parameter (norid='X',anyrid='@')
        integer indexw
        character resnum1*(*), chnid1*(*)
        character resnum2*(*), chnid2*(*)
        logical res, chn

        res = (indexw(resnum1,resnum2).gt.0) .or.
     &          (index(resnum1,anyrid).gt.0 .or.
     &           index(resnum2,anyrid).gt.0)
        chn = chnid1.eq.chnid2 .or.
     &          (chnid1.eq.anyrid .or. chnid2.eq.anyrid)
        reseqv1 = res .and. chn

        return
      end
