cf ----------------------------------------------------------------------------
cf
cf    WRPDB() writes out the atom file in the PDB format. 
cf
cf    subroutine wrpdb(ioout,iolog,fname,x,y,z,natm,nres,resnam,
cf   -                 resnum,atmnam,iresatm,chain,iatms2,nsegm)
cf
cf ----------------------------------------------------------------------------

      subroutine wrpdb(ioout,iolog,fname,x,y,z,natm,nres,resnam,
     &                 resnum,atmnam,iresatm,chain,iatms2,nsegm)
        implicit none

        integer natm,nres,iresatm(natm),ioout,i,nsegm,iatms2(nsegm),il
        integer iolog,ierr
        real x(natm), y(natm), z(natm)
        character resnam(nres)*(*),resnum(nres)*(*),chain(nres)*(*)
        character atmnam(natm)*(*),fname*(*)
        character an1*(4),an2*(4),rec*(6)
        logical ishydrogen,chnbrk,hetatm,het,cmpr,iowr

        call openf4(ioout,fname,'UNKNOWN','SEQUENTIAL','FORMATTED',3,
     &              .true.,ierr,cmpr,iolog)
        call pdbhead(ioout)

        il = 1
        do  i = 1, natm

c ------- non H atoms have the first position blank in the Brookhaven format:
c ------- CHARMM PDB output has always a blank in the first position:
          an1 = atmnam(i)
          call ljust(an1)
          if (ishydrogen(an1)) then
            an2 = an1
          else
            an2 = ' '//an1
          end if

          het = hetatm(an1,resnam(iresatm(i)))
          if (het) then
            rec = 'HETATM'
          else
            rec = 'ATOM  '
          end if

          il = il + 1
          write(ioout,15) rec,i,an2,' ',resnam(iresatm(i)),
     &          chain(iresatm(i)),resnum(iresatm(i)),x(i),y(i),z(i),
     &          1.0, 0.0, 1, 'MOD', il
15        format(a6,i5,1x,a4,a1,a3,1x,a1,a5,3x,3f8.3,2f6.2,6x,i1,
     &           a3,i4)

c ------- chain break TER record?
          if (chnbrk(i,iatms2,nsegm).and.(i.lt.natm).and..not.het) then
            il = il + 1
c --------- repeat the atom index
            write(ioout,'(a6,i5,6x,a3,51x,a3,i4)') 
     &        'TER   ', i, resnam(iresatm(i)), 'MOD', il
          end if

        end do
        write(ioout, '(a)')  'END'
        close(ioout)

        if (iowr(2))
     &    write(iolog,'(a,2i5)')'wrpdb____> residues, atoms: ', 
     &          nres,natm

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    WRPDB2() writes out the atom file in the PDB format. 
cf
cf    subroutine wrpdb2(ioout,iolog,fname,x,y,z,natm,nres,resnam,
cf   -                  resnum,atmnam,iresatm,chain,iatms2,nsegm)
cf
cf ----------------------------------------------------------------------------

      subroutine wrpdb2(ioout,iolog,fname,x,y,z,natm,nres,resnam,
     &                  resnum,atmnam,iresatm,chain,biso,iatms2,nsegm)
        implicit none

        integer natm,nres,iresatm(natm),ioout,i,nsegm,iatms2(nsegm),il
        integer isg,iolog,ierr
        real x(natm), y(natm), z(natm), biso(natm)
        character resnam(nres)*(*),resnum(nres)*(*),chain(nres)*(*)
        character atmnam(natm)*(*),fname*(*)
        character an1*(4),an2*(4),rec*(6)
        logical ishydrogen,chnbrk,hetatm,het,iowr,cmpr

        call openf4(ioout,fname,'UNKNOWN','SEQUENTIAL','FORMATTED',3,
     &              .true.,ierr,cmpr,iolog)
        call pdbhead(ioout)

        il = 1
        isg = 1
        do  i = 1, natm

c ------- non H atoms have the first position blank in the Brookhaven format:
c ------- CHARMM PDB output has always a blank in the first position:
          an1 = atmnam(i)
          call ljust(an1)
          if (ishydrogen(an1)) then
            an2 = an1
          else
            an2 = ' '//an1
          end if

          het = hetatm(an1,resnam(iresatm(i)))
          if (het) then
            rec = 'HETATM'
          else
            rec = 'ATOM  '
          end if

          il = il + 1
          write(ioout,15) rec,i,an2,' ',resnam(iresatm(i)),
     &          chain(iresatm(i)),resnum(iresatm(i)),x(i),y(i),z(i),
     &          1.0, biso(i), isg, 'SG', il
15        format(a6,i5,1x,a4,a1,a3,1x,a1,a5,3x,3f8.3,2f6.2,6x,i2,
     &           a2,i4)

c ------- chain break TER record?
          if (chnbrk(i,iatms2,nsegm).and.(i.lt.natm).and..not.het) then
            il = il + 1
c --------- repeat the atom index
            write(ioout,'(a6,i5,6x,a3,2x,a5,45x,i2,a2,i4)') 
     &        'TER   ', i, resnam(iresatm(i)), resnum(iresatm(i)),
     &        isg, 'SG', il
            isg = isg + 1
          end if

        end do
        write(ioout, '(a)')  'END'
        close(ioout)

        if (iowr(2))
     &    write(iolog,'(a,2i5)')'wrpdb2___> residues, atoms: ', 
     &          nres,natm

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    WRPDB3() reads in a PDB file, transforms coordinates and writes it
cf    out.
cf
cf    subroutine wrpdb3(ioinp,ioout,iolog,inpfil,outfil,rotmat,trans)
cf
cf ----------------------------------------------------------------------------

      subroutine wrpdb3(ioinp,ioout,iolog,inpfil,outfil,rotmat,trans)
        implicit none
        integer ioinp,ioout,lenr,lr,ierr,iolog
        real x, y, z, trans(3), rotmat(3,3)
        character card*80
        character inpfil*(*), outfil*(*)
        logical compressed

        call openf4(ioinp,inpfil,'OLD','SEQUENTIAL','FORMATTED',3,
     &              .false.,ierr,compressed,iolog)

        if (ierr .gt. 0) then
          write(*,'(2a)') 'wrpdb3___E> openning input file : ',inpfil
          stop
        end if

        call openf4(ioout,outfil,'UNKNOWN','SEQUENTIAL','FORMATTED',3,
     &              .false.,ierr,compressed,iolog)
        call pdbhead(ioout)

10      read(ioinp, '(a)', end=100) card
          lr = lenr(card)
          if((card(1:6).eq.'ATOM  ').or.(card(1:6).eq.'HETATM'))then
            read(card,'(30x,3f8.3)') x, y, z
            call trnsf1(x,y,z,1,rotmat,trans)
            if (lr.ge.55) then
              write(ioout,'(a30,3f8.3,a)') card(1:30),x,y,z,card(55:lr)
            else
              write(ioout,'(a30,3f8.3)') card(1:30),x,y,z
            end if
          else
            write(ioout,'(a)') card(1:lr)
          end if
          go to 10
100     continue

        close(ioinp)
        close(ioout)

        call unprepfil(inpfil, compressed)

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    PDBHEAD writes out one REMARK record for the PDB file.
cf
cf    logical function hetatm(atm,rescrm)
cf
cf ----------------------------------------------------------------------------

      subroutine pdbhead(ioout)
        implicit none
        integer ioout, lenr
        character datetime*(40)

        call sys('date', datetime)

        write(ioout, '(a29,a40,7x,i4)') 
     &  'REMARK Produced by MODELLER: ',datetime(1:lenr(datetime)),1

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    HETATM returns .T. if the PDB atom name ATM in the PDB residue 
cf    name is a HETATM.
cf
cf    logical function hetatm(atm,res)
cf
cf ----------------------------------------------------------------------------

      logical function hetatm(atm,res)
        implicit none
        integer istr2int
        character atm*(*), res*(*)

        if (istr2int(res) .gt. 27) then
          hetatm = .true.
        else
          hetatm = .false.
        end if

        return
      end
