c --- This is a subset of the joylib routines written by John Overingon that
c     are needed for his modified version of psa. Several of these routines have
c     close relatives in one of my string/residue libraries and at some point
c     I should maybe make psa autarctic (Andrej Sali).

      integer function ISTRINT(RES)
C
C this function returns the integer type for the three letter i
C residue code; if a code can not be recognized, 21 is returned;
C
      implicit NONE
      integer NTYPES
      parameter (NTYPES = 25)
      integer I
      character RES*3, RESLST(NTYPES)*3
C
C three letter amino acid residue types:
C
      data   RESLST /'ALA', 'CYS', 'ASP', 'GLU', 'PHE', 'GLY',
     +               'HIS', 'ILE', 'LYS', 'LEU', 'MET', 'ASN',
     +               'PRO', 'GLN', 'ARG', 'SER', 'THR', 'VAL',
     +               'TRP', 'TYR', 'ASX', 'GLX', 'UNK', 'PCA', 'INI'/
C
      do I=1,NTYPES
        if (RESLST(I) .eq. RES) then
          ISTRINT=I
          if (I .eq. 21) ISTRINT=12        ! ASX => ASN
          if (I .eq. 22) ISTRINT=14        ! GLX => GLN
          if (I .eq. 23) ISTRINT=6        ! UNK => GLY
          if (I .gt. 23) ISTRINT=21        ! XXX => GAP
          return
        end if
      end do
      ISTRINT = 21                           ! ??? => GAP
      return
      end
      subroutine ERROR(TEXT1,TEXT2,CODE)
C
C Simple routine to write an error message on the standard error and then to
C exit or return to calling routine. A code of one or more exits the program.
C
      implicit NONE
      integer STDERR
      parameter (STDERR=6)
      character*(*) TEXT1,TEXT2
      integer CODE
C
C catch strange codes
C
      if (CODE .lt. 0 .or. CODE .gt. 4) then
        write (STDERR,'(''error: bad call to error - unknown code'')')
      end if
C
C Output error message
C
      write (STDERR,'(A,1X,A)') TEXT1,TEXT2
C
C Exit if error code is not equal to zero and told to catch fatal errors
C
      if (CODE .eq. 0) then 
        continue
      else
        call EXIT(CODE)
      end if
C
      return
      end
      integer function ISTRTYP(STR, STRARR, NARR)
C
      implicit none
      integer NARR, I
      character*(*) STR, STRARR(NARR)
C
      do I=1,NARR
        ISTRTYP=I
        if (STR .eq. STRARR(I)) return
      end do
      ISTRTYP=0
      return
      end
      logical function FILEEXIST(FILENAME)
C
C returns wheter a file exists (should really be a macro)
C
      implicit none
      character*(*) FILENAME
C
      inquire (file=FILENAME,exist=FILEEXIST)
C
      return
      end
      integer function LASTCHAR(STRING)
C
C Returns the position of the last printable character (not a blank) in the
C string STRING
C
      character*(*)  STRING
      integer J
      logical ISPRINT
C
      LASTCHAR=LEN(STRING)
      do J=LEN(STRING),1,-1
        if (ISPRINT(STRING(J:J))) then
          LASTCHAR=J
          return
        end if
        LASTCHAR=J
      end do
C
      return
      end
      logical function ISPRINT(A1CHAR)
C
C Function that returns if a character variable is printable or not
C
      implicit none
      character*1 A1CHAR
      integer     N
C
C N.B. This version does not count a blank as printable !!!
C
      N=ICHAR(A1CHAR)
      if ((N.ge.33).and.(N.le.126)) then
        ISPRINT=.TRUE.
        return
      end if
      ISPRINT=.FALSE.
C
      return
      end
      subroutine MESSAGE(TEXT)
C
C Simple routine to write a message on the standard output and then to
C return to calling routine.
C
      implicit NONE
      integer STDERR, STDOUT
      parameter (STDERR=6, STDOUT=6)
      character*(*) TEXT
C
C Output error message
C
      write (STDERR,'(A)',err=900) TEXT
      return
C
900   call ERROR('message: bad call to message',TEXT,1)
C
      end
      subroutine TIMEDIFF(TIME1,TIME2,TIMED,TIME3)
C
C calculates the difference in time between two times, result returned as char
C in hours minutes and seconds
C
      integer HR1, HR2, MN1, MN2, SC1, SC2, IHR, IMN, ISC, ITIME
      character*8 TIME1, TIME2, TIME3
      real RTIME1, RTIME2, TIMED
C
      TIMED=0.0
      TIME3='XX:XX:XX'
C
C get minutes, etc from strings
C
      read (TIME1(1:2),'(I2)') HR1
      read (TIME1(4:5),'(I2)') MN1
      read (TIME1(7:8),'(I2)') SC1
      read (TIME2(1:2),'(I2)') HR2
      read (TIME2(4:5),'(I2)') MN2
      read (TIME2(7:8),'(I2)') SC2
C
C convert to seconds
C
      RTIME1=(real(HR1)*3600.0)+(real(MN1)*60.0)+(real(SC1))
      RTIME2=(real(HR2)*3600.0)+(real(MN2)*60.0)+(real(SC2))
C
C 86400 is the number of seconds in a day
C
      TIMED=RTIME2-RTIME1
      if (TIMED.lt.0.0) then
        RTIME2=RTIME2+86400.0
        TIMED=RTIME2-RTIME1
      end if
C
C convert from seconds to h:m:s
C
      ITIME=int(TIMED)
      IHR=ITIME/3600
      ITIME=ITIME-(IHR*3600)
      IMN=ITIME/60
      ITIME=ITIME-(IMN*60)
      ISC=ITIME
C
      write (TIME3(1:2),'(I2.2)') IHR
      write (TIME3(4:5),'(I2.2)') IMN
      write (TIME3(7:8),'(I2.2)') ISC
C
      return
      end
