cf ----------------------------------------------------------------------------
cf
cf    GETCHRM() does the hard-wired patches to get the CHARMM residue and
cf    atom codes from the PDB names.
cf
cf    subroutine getchrm(resnam, atmnam, rn, an, cterm)
cf
cf ----------------------------------------------------------------------------

      subroutine getchrm(resnam, atmnam, rn, an, cterm)
        implicit none
        character resnam*(*), atmnam*(*), rn*(*), an*(*)
c ----- CHARMM atom names without the [-+*...] prefix here:
        character an2*(4)
        logical cterm

        rn = resnam
        an = atmnam

c    1) by default, neutral HIS with H on ND1 is returned:
        if (rn .eq. 'HIS') rn = 'HSD'

c    3) CD1 of ILE to CD:
        if (resnam.eq.'ILE') then
          if (an.eq.'CD1')  an = 'CD'
          if (an.eq.'HD11') an = 'HD1'
          if (an.eq.'HD12') an = 'HD2'
          if (an.eq.'HD13') an = 'HD3'
        end if

c    4) CD1/CD2 of LEU:
        if (resnam.eq.'LEU') then
          an2 = an
          if (an.eq.'CD1')  an2 = 'CD2'
          if (an.eq.'HD11') an2 = 'HD21'
          if (an.eq.'HD12') an2 = 'HD22'
          if (an.eq.'HD13') an2 = 'HD23'
          if (an.eq.'CD2')  an2 = 'CD1'
          if (an.eq.'HD21') an2 = 'HD11'
          if (an.eq.'HD22') an2 = 'HD12'
          if (an.eq.'HD23') an2 = 'HD13'
          an = an2
        end if

c    5) for the carboxy terminus:
        if (cterm) then
          if (an.eq.'O')   an = 'OT1'
          if (an.eq.'OXT') an = 'OT2'
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    GETPDB() does the hard-wired patches to get the PDB residue and
cf    atom codes from the CHARMM names.
cf
cf    subroutine getpdb(resnam, atmnam, rn, an)
cf
cf ----------------------------------------------------------------------------

      subroutine getpdb(resnam, atmnam, rn, an)
        implicit none
        character resnam*(*), atmnam*(*), rn*(*), an*(*)
c ----- CHARMM atom names without the [-+*...] prefix here:
        character an2*(4)

c ----- non H atoms have the first position blank in the Brookhaven format:
c ----- CHARMM PDB output has always a blank in the first position:

        an = atmnam
        rn = resnam

c    1) Any HIS goes to HIS --- Not quite!
c        if (index('HSD HSE HSP', resnam) .gt. 0) rn = 'HIS'
c        if (index('HSD', resnam) .gt. 0) rn = 'HIS'

c    2) CD of ILE to CD1:
        if (resnam.eq.'ILE') then
          if (an.eq.'CD')  an = 'CD1'
          if (an.eq.'HD1') an = 'HD11'
          if (an.eq.'HD2') an = 'HD12'
          if (an.eq.'HD3') an = 'HD13'
        end if

c    3) CD1/CD2 of LEU:
        if (resnam.eq.'LEU') then
          an2 = an
          if (an.eq.'CD1')  an2 = 'CD2'
          if (an.eq.'HD11') an2 = 'HD21'
          if (an.eq.'HD12') an2 = 'HD22'
          if (an.eq.'HD13') an2 = 'HD23'
          if (an.eq.'CD2')  an2 = 'CD1'
          if (an.eq.'HD21') an2 = 'HD11'
          if (an.eq.'HD22') an2 = 'HD12'
          if (an.eq.'HD23') an2 = 'HD13'
          an = an2
        end if

c    4) for the carboxy terminus:
        if (an.eq.'OT1') an = 'O'
        if (an.eq.'OT2') an = 'OXT'

        return
      end



cf ---------------------------------------------------------------------------
cf
cf    PDB2CHRM() routine converts the vectors of atom and residue names
cf    from the PDB types to the CHARMM types.
cf
cf    subroutine pdb2crm(resnam,iresatm,atmnam,natm,nres,rescrm,
cf                       atmcrm,iatms2,nsegm)
cf
cf ---------------------------------------------------------------------------

      subroutine pdb2crm(resnam,iresatm,atmnam,natm,nres,rescrm,
     &                   atmcrm,iress2,nsegm)
        implicit none
        integer i, natm, nres, iresatm(natm), nsegm, iress2(nsegm)
        character resnam(nres)*(*),atmnam(natm)*(*)
        character rescrm(nres)*(*),atmcrm(natm)*(*)
        logical cterm, chnbrk

        do i = 1, natm
          cterm = chnbrk(iresatm(i), iress2, nsegm)
          call getchrm(resnam(iresatm(i)),atmnam(i),rescrm(iresatm(i)),
     &                 atmcrm(i),cterm)
        end do

c ----- use a general residue name conversion:
        call str2crmn(resnam, rescrm, nres)

        return
      end


cf ---------------------------------------------------------------------------
cf
cf    CHNBRK returns .T. if residue/atom IATM is the terminal 
cf    residue/atom of any of the segments of the MODEL.
cf
cf    logical function chnbrk(iatm, iatms2, nsegm)
cf
cf ---------------------------------------------------------------------------

      logical function chnbrk(iatm, iatms2, nsegm)
        implicit none
        integer iatm, nsegm, i, iatms2(nsegm)

        do  i = 1, nsegm
          if (iatm .eq. iatms2(i)) then
            chnbrk = .true.
            return
          end if
        end do
        chnbrk = .false.

        return
      end


cf ---------------------------------------------------------------------------
cf
cf    CRM2PDB() routine converts the vectors of atom and residue names
cf    from the CHARMM types to the PDB types.
cf
cf    subroutine crm2pdb(resnam,iresatm,atmnam,natm,nres,respdb,
cf   -                   atmpdb)
cf
cf ---------------------------------------------------------------------------

      subroutine crm2pdb(resnam,iresatm,atmnam,natm,nres,respdb,
     &                   atmpdb)
        implicit none
        integer i, natm, nres, iresatm(natm)
        character resnam(nres)*(*),atmnam(natm)*(*)
        character respdb(nres)*(*),atmpdb(natm)*(*)

        do i = 1, natm
          call getpdb(resnam(iresatm(i)),atmnam(i),respdb(iresatm(i)), 
     &                atmpdb(i))
        end do

c ----- use a general residue name conversion:
        call crm2strn(resnam, respdb, nres)

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    IUP2CRM() converts the IUPAC atom name and residue type to CHARMM atom 
cf    type. It works better if a residue topology library is in the memory; 
cf    otherwise, default atom names are used.
cf
cf    MODIFIED FOR MDT.
cf
cf    subroutine iup2crm(atmi, iattp, irest, error)
cf
cf ----------------------------------------------------------------------------

c --- delete atmc from here

      subroutine iup2crm(atmi, iattp, irest, error)
        implicit none
        integer irest, iattp, iacrmtyp
        character atmi*(*), atmc*(4)
        logical error

          call diup2crm(atmi, atmc)
          if (.not. error) then
            write(*,'(a/4a/a)') 
     &    'iup2crm_W> no topology library in memory',
     &    '           default CHARMM atom assigned: ',
     &    atmi, ' --> ', atmc,
     &    '           this message is written only for first such atom!'
            error = .true.
          end if
          iattp = iacrmtyp(atmc)
          if (iattp .lt. 1) then
c --------- probably radii.lib/models.lib are not consistent with the 
c           topology library (new or changed CHARMM atom names?):
            write(*,*) 'iup2crm_E> internal error 2: ',irest,atmi,atmc
            stop
          end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    IACRMTYP() converts the CHARMM atom name to the CHARMM atom type.
cf    It uses the radii lib order to make it useful for pseudo atoms, too.
cf
cf    integer function iacrmtyp(atmc)
cf
cf ----------------------------------------------------------------------------

      integer function iacrmtyp(atmc)
        implicit none
#include "radii.cst"
#include "radii.cmn"
        integer ifind2word
        character atmc*(*)
    
        iacrmtyp = ifind2word(atmc, vdwatm, nvdwtyp)

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    DIUP2CRM() assigns a default CHARMM atom type from a IUPAC atom type 
cf    using the first character of the IUPAC atom name only.
cf
cf    subroutine diup2crm(atmi, atmc)
cf
cf ----------------------------------------------------------------------------

      subroutine diup2crm(atmi, atmc)
        implicit none
        integer lenl, ll
        character atmi*(*), atmc*(*), a*(1)

        ll = lenl(atmi)
        a = atmi(ll:ll)
        if (a .eq. 'C') then
          atmc = 'CT2'
        else
          if (a .eq. 'N') then
            atmc = 'N'
          else
            if (a .eq. 'O') then
              atmc = 'O'
            else
              if (a .eq. 'H') then
                atmc = 'H'
              else
                if (a .eq. 'S') then
                  atmc = 'S'
                else
c --------------- default if atom name does not start with CNOHS:
                  atmc = 'C'
                end if
              end if
            end if
          end if
        end if

        return
      end
