c --- Andrej Sali, 1990: Demo for the multi-level DO loops without DO loops.
c
c     program demo_roll_ind
c        parameter (n=5, m=4)
c        integer istart(n), iend(n), istep(n), ind(n)
c        logical roll_ind
c     
c        call ivset(ind,    n, 1)
c        call ivset(istart, n, 1)
c        call ivset(iend,   n, m)
c        call ivset(istep,  n, 1)
c
c        icount = 0
c10      continue
c          icount = icount + 1
c          write(*,'(i4,a3,999i4)') icount, ' : ', (ind(i),i=1,n)
c        if (.not. roll_ind(ind, istart, iend, istep, n)) go to 10
c
c        stop
c      end
 
 
 
cf ----------------------------------------------------------------------------
cf
cf    ROLL_IND() routine rolls n indices in ind, from istart to iend, by istep,
cf    as an n-dimensional DO loop would. It has to be called in the place
cf    of the 'end do' or 'continue' statements. 
cf
cf    Input : ind, istart, iend, istep, n
cf
cf    Output: ind
cf
cf    It emulates the following structure:
cf
cf    do  ind(1) = istart(1), iend(1), istep(1)
cf      do  ind(2) = istart(2), iend(2), istep(2)
cf        ...
cf        do  ind(n) = istart(n), iend(n), istep(n)
cf
cf        end do
cf        ...
cf      end do
cf    end do
cf
cf
cf    logical function roll_ind(ind, istart, iend, istep, n)
cf
cf ----------------------------------------------------------------------------

      logical function roll_ind(ind, istart, iend, istep, n)
        implicit none
        integer i, n, ind(n), istart(n), iend(n)
        integer istep(n)
        if (n .gt. 0) then
          i = n
10        continue
            if ((ind(i)+istep(i)) .le. iend(i)) then
              ind(i) = ind(i) + istep(i)
              roll_ind = .false.
              return
            else
              if (i .eq. 1) then
                roll_ind = .true.
                return
              else
                ind(i) = istart(i)
                i = i - 1
                go to 10
              end if
            end if
          continue
        else
          roll_ind = .true.
        end if
        return
      end

cf ----------------------------------------------------------------------------
cf
cf    ROLL2_IND(), when init=0, this routine rolls n indices in 
cf    ind=(i,j,k,...) so that all combinations of n different indices 
cf    are generated, where the possible values for each index are 1+x..nmax-y; 
cf
cf    for example, for n=3: 
cf
cf    do  i = 1, nmax-2
cf      do  j = i+1, nmax-1
cf        do  k = j+1, nmax
cf
cf    in the first call to the routine, ind has to be initialized 
cf    correctly to ind=(1,2,3,...,n); this can be done by calling roll2_ind
cf    with init <> 0
cf
cf    logical function roll2_ind(ind, n, nmax, init)
cf
cf ----------------------------------------------------------------------------

      logical function roll2_ind(ind, n, nmax, init)
        implicit none
        integer nmax,n,init,ind(n),i,k
        if (init .eq. 0) then
         if (n .gt. 0) then
          i = n
10        continue
            if (ind(i)+1 .le. (nmax-(n-i))) then
              ind(i) = ind(i) + 1
              do  k = i+1, n
                ind(k) = ind(k-1) + 1
              end do
              roll2_ind = .false.
              return
            else
              if (i .eq. 1) then
                roll2_ind = .true.
                return
              else
                i = i - 1
                go to 10
              end if
            end if
          continue
         else
          roll2_ind = .true.
         end if
        else
         do  i = 1, n
           ind(i) = i
         end do
        end if
        return
      end
