# This script illustrates the use of the swap_atoms_in_res
# argument to the model.superpose() command:

# Need to make sure that the topologies of the two molecules
# superposed are exactly the same:

env = environ()
env.libs.topology.read(file='$(LIB)/top_heav.lib')
env.libs.parameters.read(file='$(LIB)/par.lib')

atfil = '../tutorial-model/1fdx.atm'
mdl = model(env, file=atfil)
aln = alignment(env)
aln.append_model(mdl, align_codes='1fdx', atom_files=atfil)
aln.append_model(mdl, align_codes='1fdx', atom_files=atfil)
mdl.generate_topology(aln, sequence='1fdx')
mdl.transfer_xyz(aln)
mdl.build(initialize_xyz=False, build_method='INTERNAL_COORDINATES')

mdl2 = model(env, file='./1fdx.swap.atm')
mdl.superpose(mdl2, aln, swap_atoms_in_res='')
mdl.superpose(mdl2, aln, swap_atoms_in_res='DEFHLNQRVY', fit=False)
mdl.superpose(mdl2, aln, swap_atoms_in_res='', fit=True)
