import _modeller
from modeller.util.modutil import modlist
from modeller.util.modobject import modobject

class energy_data(modobject):
    """Defines the type of energy function to use"""

    def __init__(self, lennard_jones_switch=(6.5, 7.5),
                 coulomb_switch=(6.5, 7.5), contact_shell=4.0,
                 relative_dielectric=1.0, radii_factor=0.82,
                 update_dynamic=0.39, nonbonded_sel_atoms=1, covalent_cys=False,
                 excl_local=(True, True, True, True), nlogn_use=15,
                 sphere_stdv=0.05, dynamic_pairs=False, dynamic_sphere=True,
                 dynamic_coulomb=False, dynamic_lennard=False,
                 dynamic_modeller=False, dynamic_access=False,
                 dynamic_gbsa=False, copy=None):
        self.add_members(('_energy_data__modpt',))
        self.__modpt = _modeller.new_energy_data()
        for member in dir(energy_data):
            var = "energy_data." + member
            if eval("type("+var+")") is property and \
               eval(var+".fset") is not None and \
               eval(var+".fget") is not None:
                if copy:
                    exec("self."+member+" = copy."+member)
                else:
                    exec("self."+member+" = "+member)
        if copy:
            for member in copy.__dict__:
                if 'energy_data' not in member:
                    self.__dict__[member] = copy.__dict__[member]

    def __del__(self):
        _modeller.free_energy_data(self.modpt)

    def __get_modpt(self):
        return self.__modpt
    def __get_contact_shell(self):
        return _modeller.get_edata_contact_shell(self.modpt)
    def __set_contact_shell(self, val):
        _modeller.set_edata_contact_shell(self.modpt, val)
    def __get_relative_dielectric(self):
        return _modeller.get_edata_relative_dielectric(self.modpt)
    def __set_relative_dielectric(self, val):
        _modeller.set_edata_relative_dielectric(self.modpt, val)
    def __get_radii_factor(self):
        return _modeller.get_edata_radii_factor(self.modpt)
    def __set_radii_factor(self, val):
        _modeller.set_edata_radii_factor(self.modpt, val)
    def __get_sphere_stdv(self):
        return _modeller.get_edata_sphere_stdv(self.modpt)
    def __set_sphere_stdv(self, val):
        _modeller.set_edata_sphere_stdv(self.modpt, val)
    def __get_update_dynamic(self):
        return _modeller.get_edata_update_dynamic(self.modpt)
    def __set_update_dynamic(self, val):
        _modeller.set_edata_update_dynamic(self.modpt, val)
    def __get_nonbonded_sel_atoms(self):
        return _modeller.get_edata_nonbonded_sel_atoms(self.modpt)
    def __set_nonbonded_sel_atoms(self, val):
        _modeller.set_edata_nonbonded_sel_atoms(self.modpt, val)
    def __get_nlogn_use(self):
        return _modeller.get_edata_nlogn_use(self.modpt)
    def __set_nlogn_use(self, val):
        _modeller.set_edata_nlogn_use(self.modpt, val)
    def __get_covalent_cys(self):
        return _modeller.get_edata_covalent_cys(self.modpt) != 0
    def __set_covalent_cys(self, val):
        _modeller.set_edata_covalent_cys(self.modpt, val)
    def __get_dynamic_pairs(self):
        return _modeller.get_edata_dynamic_pairs(self.modpt) != 0
    def __set_dynamic_pairs(self, val):
        _modeller.set_edata_dynamic_pairs(self.modpt, val)
    def __get_dynamic_sphere(self):
        return _modeller.get_edata_dynamic_sphere(self.modpt) != 0
    def __set_dynamic_sphere(self, val):
        _modeller.set_edata_dynamic_sphere(self.modpt, val)
    def __get_dynamic_coulomb(self):
        return _modeller.get_edata_dynamic_coulomb(self.modpt) != 0
    def __set_dynamic_coulomb(self, val):
        _modeller.set_edata_dynamic_coulomb(self.modpt, val)
    def __get_dynamic_lennard(self):
        return _modeller.get_edata_dynamic_lennard(self.modpt) != 0
    def __set_dynamic_lennard(self, val):
        _modeller.set_edata_dynamic_lennard(self.modpt, val)
    def __get_dynamic_modeller(self):
        return _modeller.get_edata_dynamic_modeller(self.modpt) != 0
    def __set_dynamic_modeller(self, val):
        _modeller.set_edata_dynamic_modeller(self.modpt, val)
    def __get_dynamic_access(self):
        return _modeller.get_edata_dynamic_access(self.modpt) != 0
    def __set_dynamic_access(self, val):
        _modeller.set_edata_dynamic_access(self.modpt, val)
    def __get_dynamic_gbsa(self):
        return _modeller.get_edata_dynamic_gbsa(self.modpt) != 0
    def __set_dynamic_gbsa(self, val):
        _modeller.set_edata_dynamic_gbsa(self.modpt, val)
    def __get_lennard_jones_switch(self):
        return modlist(self.modpt, 2, _modeller.get_edata_lj_switch,
                       _modeller.set_edata_lj_switch)
    def __set_lennard_jones_switch(self, val):
        for indx in max(2, range(len(val))):
            _modeller.set_edata_lj_switch(self.modpt, indx, val[indx])
    def __get_coulomb_switch(self):
        return modlist(self.modpt, 2, _modeller.get_edata_coulomb_switch,
                       _modeller.set_edata_coulomb_switch)
    def __set_coulomb_switch(self, val):
        for indx in max(2, range(len(val))):
            _modeller.set_edata_coulomb_switch(self.modpt, indx, val[indx])
    def __get_excl_local(self):
        return modlist(self.modpt, 4, get_edata_excl_local,
                       _modeller.set_edata_excl_local)
    def __set_excl_local(self, val):
        for indx in max(4, range(len(val))):
            _modeller.set_edata_excl_local(self.modpt, indx, val[indx])

    modpt = property(__get_modpt)
    contact_shell = property(__get_contact_shell, __set_contact_shell)
    relative_dielectric = property(__get_relative_dielectric,
                                   __set_relative_dielectric)
    radii_factor = property(__get_radii_factor, __set_radii_factor)
    sphere_stdv = property(__get_sphere_stdv, __set_sphere_stdv)
    update_dynamic = property(__get_update_dynamic, __set_update_dynamic)
    nonbonded_sel_atoms = property(__get_nonbonded_sel_atoms,
                                   __set_nonbonded_sel_atoms)
    nlogn_use = property(__get_nlogn_use, __set_nlogn_use)
    covalent_cys = property(__get_covalent_cys, __set_covalent_cys)
    dynamic_pairs = property(__get_dynamic_pairs, __set_dynamic_pairs)
    dynamic_sphere = property(__get_dynamic_sphere, __set_dynamic_sphere)
    dynamic_coulomb = property(__get_dynamic_coulomb, __set_dynamic_coulomb)
    dynamic_lennard = property(__get_dynamic_lennard, __set_dynamic_lennard)
    dynamic_modeller = property(__get_dynamic_modeller, __set_dynamic_modeller)
    dynamic_access = property(__get_dynamic_access, __set_dynamic_access)
    dynamic_gbsa = property(__get_dynamic_gbsa, __set_dynamic_gbsa)
    lennard_jones_switch = property(__get_lennard_jones_switch,
                                    __set_lennard_jones_switch)
    coulomb_switch = property(__get_coulomb_switch, __set_coulomb_switch)
    excl_local = property(__get_excl_local, __set_excl_local)


def get_edata_excl_local(modpt, indx):
    return _modeller.get_edata_excl_local(modpt, indx) != 0
