import _modeller
import util.top as top
import util.modutil as modutil

class sequence_db(object):
    """Holds a database of protein sequences"""

    def __init__(self, env, **vars):
        self.__modpt = _modeller.new_sequence_db()
        self.env = env.copy()
        self.top = top.top(self.env)
        if len(vars) > 0:
            self.read(**vars)

    def __del__(self):
        _modeller.free_sequence_db(self.modpt)

    def __get_modpt(self):
        return self.__modpt

    def __len__(self):
        return _modeller.get_sequence_db_nchn(self.modpt)

    def read(self, **vars):
        """Reads in a database from a file"""
        return self.top.read_sequence_db('sequence_db.read', sdb=self.modpt,
                                         **vars)

    def write(self, **vars):
        """Writes out a database to a file"""
        return self.top.write_sequence_db('sequence_db.write', sdb=self.modpt,
                                          **vars)

    def search(self, aln, io=None, **vars):
        """Search for similar sequences"""
        if io is None:
            io = self.env.io
        return self.top.sequence_search('sequence_db.search', sdb=self.modpt,
                                        aln=aln.modpt, io=io.modpt, **vars)

    def filter(self, **vars):
        """Cluster sequences by sequence-identity"""
        return self.top.seqfilter('sequence_db.filter', sdb=self.modpt, **vars)

    def __getitem__(self, indx):
        ret = modutil.handle_seq_indx(self, indx)
        if type(ret) is int:
            return sequence(self, indx)
        else:
            return ret

    modpt = property(__get_modpt)


class sequence(object):
    """A single sequence in the database"""

    def __init__(self, sdb, num):
        self.sdb = sdb
        self.num = num

    def __len__(self):
        return _modeller.get_sequence_db_nseq(self.sdb.modpt, self.num)

    def __get_code(self):
        return _modeller.get_sequence_db_code(self.sdb.modpt, self.num)
    def __set_code(self, val):
        _modeller.set_sequence_db_code(self.sdb.modpt, self.num, val)
    def __get_prottyp(self):
        return _modeller.get_sequence_db_prottyp(self.sdb.modpt, self.num)
    def __set_prottyp(self, val):
        _modeller.set_sequence_db_prottyp(self.sdb.modpt, self.num, val)
    def __get_resol(self):
        return _modeller.get_sequence_db_resol(self.sdb.modpt, self.num)
    def __set_resol(self, val):
        _modeller.set_sequence_db_resol(self.sdb.modpt, self.num, val)

    code = property(__get_code, __set_code)
    prottyp = property(__get_prottyp, __set_prottyp)
    resol = property(__get_resol, __set_resol)
