import _modeller
import util.top as top
from modeller.util.modobject import modobject

class density(modobject):
    """Holds all information from an EM (electron microscopy) density file"""

    def __init__(self, env, **vars):
        self.add_members(('_density__modpt', 'env', 'top'))
        self.__modpt = _modeller.new_density()
        self.env = env.copy()
        self.top = top.top(self.env)
        if len(vars) > 0:
            self.top.read_density('density.read', den=self.modpt, **vars)

    def __del__(self):
        _modeller.free_density(self.modpt)

    def __get_modpt(self):
        return self.__modpt

    def read(self, **vars):
        """Read in a density file"""
        return self.top.read_density('density.read', den=self.modpt, **vars)

    def grid_search(self, **vars):
        """Dock a structure into the EM density map"""
        return self.top.em_grid_search('density.grid_search', den=self.modpt,
                                       **vars)

    def __get_resolution(self):
        return _modeller.get_density_resolution(self.modpt)
    def __set_resolution(self, val):
        _modeller.set_density_resolution(self.modpt, val)

    modpt = property(__get_modpt)
    resolution = property(__get_resolution, __set_resolution)
