# Example for: model.restraints.reindex()

# This will reindex restraints obtained previously for a simpler topology so 
# that they will now apply to a more complicated topology.

env = environ()
tpl = env.libs.topology
par = env.libs.parameters

# Generate the model for the simpler topology (CA only in this case):
tpl.read(file='$(LIB)/top_ca.lib')
par.read(file='$(LIB)/par_ca.lib')

code = '1fas'
mdl = model(env, file=code)
aln = alignment(env)
aln.append_model(mdl, atom_files=code, align_codes=code)
aln.append_model(mdl, atom_files=code+'.ca', align_codes=code+'-ca')
mdl.generate_topology(aln, sequence=code+'-ca')
mdl.transfer_xyz(aln)
mdl.build(initialize_xyz=False, build_method='INTERNAL_COORDINATES')
mdl.write(file=code+'.ca')

# Generate the restraints for the simpler topology:
mdl.restraints.make(aln, restraint_type='stereo', spline_on_site=False)
mdl.restraints.write(file='1fas-ca.rsr')
mdl.energy()

# Generate the model for the more complicated topology:
tpl.read(file='$(LIB)/top_heav.lib')
par.read(file='$(LIB)/par.lib')

mdl.read(file=code)
aln = alignment(env)
aln.append_model(mdl, atom_files=code, align_codes=code)
aln.append_model(mdl, atom_files=code+'.ini', align_codes=code+'-ini')
mdl.generate_topology(aln, sequence=code+'-ini')
mdl.transfer_xyz(aln)
mdl.write(file='1fas.ini')

mdl2 = model(env, file='1fas.ca')
mdl.restraints.reindex(mdl2)
mdl.restraints.write(file='1fas.rsr')
mdl.energy()
