import _modeller
import util.top as top
from modeller.util.modobject import modobject

class group_restraints(modobject):
    """Holds restraints which act on atom classes/groups"""

    def __init__(self, classes, parameters=None):
        self.add_members(('_group_restraints__modpt',))
        self.__modpt = _modeller.new_group_restraints()
        self.__read_classes(classes)
        if parameters:
            self.append(parameters)

    def __del__(self):
        _modeller.free_group_restraints(self.modpt)

    def __get_modpt(self):
        return self.__modpt

    def __read_classes(self, file):
        return top.top().read_atom_classes('group_restraints()',
                                           gprsr=self.modpt,
                                           atom_classes_file=file)

    def append(self, file):
        return top.top().read_group_restraints('group_restraints.append',
                                               gprsr=self.modpt, file=file)

    modpt = property(__get_modpt)
