import _modeller
import util.top as top

class information(object):
    """Allows access to information about the current Modeller build"""

    def __init__(self):
        self.top = top.top()

    def time_mark(self):
        """Returns the current date, time, and CPU time used"""
        return self.top.time_mark('info.time_mark')

    def __get_version(self):
        """Returns the Modeller version, as a string"""
        return _modeller.get_version()

    def __get_version_info(self):
        """Returns the Modeller major, minor versions"""
        mod_version = _modeller.get_version_info()
        try:
            return (int(mod_version[0]), int(mod_version[2]))
        except ValueError:
            return mod_version

    def __get_build_date(self):
        """Returns the date this Modeller binary was built"""
        return _modeller.get_build_date()

    def __get_exe_type(self):
        """Returns the executable type of this Modeller binary"""
        return _modeller.get_exe_type()

    def __get_debug(self):
        """Identifies whether this is a debugging build or not"""
        return _modeller.get_debug() != 0

    version = property(__get_version)
    version_info = property(__get_version_info)
    build_date = property(__get_build_date)
    exe_type = property(__get_exe_type)
    debug = property(__get_debug)
