import _modeller
from modeller.util.modobject import modobject

class io_data(modobject):
    """Controls reading from/writing to atom files"""

    def __init__(self, hetatm=False, hydrogen=False, water=False,
                 atom_files_directory='', copy=None):
        self.add_members(('_io_data__modpt',))
        self.__modpt = _modeller.new_io_data()
        for member in dir(io_data):
            var = "io_data." + member
            if eval("type("+var+")") is property and \
               eval(var+".fset") is not None and \
               eval(var+".fget") is not None:
                if copy:
                    exec("self."+member+" = copy."+member)
                else:
                    exec("self."+member+" = "+member)
        if copy:
            for member in copy.__dict__:
                if 'io_data' not in member:
                    self.__dict__[member] = copy.__dict__[member]

    def __del__(self):
        _modeller.free_io_data(self.modpt)

    def __get_modpt(self):
        return self.__modpt

    def __get_hydrogen(self):
        return _modeller.get_io_data_hydrogen(self.modpt) != 0
    def __set_hydrogen(self, val):
        _modeller.set_io_data_hydrogen(self.modpt, val)
    def __get_hetatm(self):
        return _modeller.get_io_data_hetatm(self.modpt) != 0
    def __set_hetatm(self, val):
        _modeller.set_io_data_hetatm(self.modpt, val)
    def __get_water(self):
        return _modeller.get_io_data_water(self.modpt) != 0
    def __set_water(self, val):
        _modeller.set_io_data_water(self.modpt, val)
    def __get_atom_files_directory(self):
        return _modeller.get_io_data_af_dir(self.modpt)
    def __set_atom_files_directory(self, val):
        _modeller.set_io_data_af_dir(self.modpt, val)

    modpt = property(__get_modpt)
    hydrogen = property(__get_hydrogen, __set_hydrogen)
    hetatm = property(__get_hetatm, __set_hetatm)
    water = property(__get_water, __set_water)
    atom_files_directory = property(__get_atom_files_directory,
                                    __set_atom_files_directory)
