import _modeller
import util.top as top
import util.modutil as modutil
from modeller.util.modobject import modobject
import alignment

class profile(modobject):
    """Holds a profile of multiple sequences"""

    def __init__(self, env, aln=None, **vars):
        self.add_members(('_profile__modpt', 'env', 'top'))
        self.__modpt = _modeller.new_profile()
        self.env = env.copy()
        self.top = top.top(self.env)
        if 'file' in vars:
            self.read(**vars)
        elif aln is not None:
            self.top.aln_to_prof('alignment.to_profile', aln=aln.modpt,
                                 prf=self.modpt, **vars)

    def __del__(self):
        _modeller.free_profile(self.modpt)

    def __get_modpt(self):
        return self.__modpt

    def __len__(self):
        return _modeller.get_profile_nseq(self.modpt)

    def read(self, **vars):
        """Reads a profile from a specified file"""
        return self.top.read_profile('profile.read', prf=self.modpt, **vars)

    def write(self, **vars):
        """Write profile to a file"""
        return self.top.write_profile('profile.write', prf=self.modpt, **vars)

    def build(self, sdb, **vars):
        """Refines the profile with sequences from the given database"""
        return self.top.build_profile('profile.build', prf=self.modpt,
                                      sdb=sdb.modpt, **vars)

    def to_alignment(self):
        """Converts the profile to alignment format"""
        aln = alignment.alignment(self.env)
        self.top.prof_to_aln('profile.to_alignment', prf=self.modpt,
                             aln=aln.modpt, append_aln=False)
        return aln

    def scan(self, **vars):
        """Compare the profile against a database of profiles"""
        return self.top.profile_profile_scan('profile.scan', prf=self.modpt,
                                             **vars)

    def __getitem__(self, indx):
        ret = modutil.handle_seq_indx(self, indx)
        if type(ret) is int:
            return sequence(self, indx)
        else:
            return ret

    modpt = property(__get_modpt)


class sequence(object):

    def __init__(self, prf, num):
        self.prf = prf
        self.num = num

    def __len__(self):
        return _modeller.get_profile_nres(self.prf.modpt, self.num)

    def __get_code(self):
        return _modeller.get_profile_code(self.prf.modpt, self.num)
    def __set_code(self, val):
        _modeller.set_profile_code(self.prf.modpt, self.num, val)
    def __get_prottyp(self):
        return _modeller.get_profile_prottyp(self.prf.modpt, self.num)
    def __set_prottyp(self, val):
        _modeller.set_profile_prottyp(self.prf.modpt, self.num, val)
    def __get_iter(self):
        return _modeller.get_profile_iter(self.prf.modpt, self.num)
    def __get_neqv(self):
        return _modeller.get_profile_neqv(self.prf.modpt, self.num)
    def __get_fid(self):
        return _modeller.get_profile_fid(self.prf.modpt, self.num)
    def __get_evalue(self):
        return _modeller.get_profile_evalue(self.prf.modpt, self.num)

    code = property(__get_code, __set_code)
    prottyp = property(__get_prottyp, __set_prottyp)
    iter = property(__get_iter)
    neqv = property(__get_neqv)
    fid = property(__get_fid)
    evalue = property(__get_evalue)
