import _modeller
import util.top as top

class topology(object):
    """All information from a residue topology file"""

    # Hold a global (class) reference to the currently-used topology, so that
    # Python's garbage collector doesn't delete it if we go out of scope
    inuse = None

    def __init__(self, env):
        self.__modpt = _modeller.new_topology()
        self.env = env
        self.top = top.top(self.env)
        self.use()

    def __del__(self):
        _modeller.free_topology(self.modpt)

    def __get_modpt(self):
        return self.__modpt

    def use(self):
        """Use this topology model for all Modeller operations"""
        _modeller.unuse_topology()
        topology.inuse = self
        _modeller.use_topology(self.modpt)

    def unuse(self):
        """No longer use this topology (if it was being used)"""
        if topology.inuse == self:
            _modeller.unuse_topology()
            topology.inuse = None

    def clear(self):
        _modeller.clear_topology(self.modpt)

    def read(self, file, **vars):
        """Reads a residue topology file"""
        self.clear()
        return self.append(file, **vars)

    def append(self, file, **vars):
        """Appends a residue topology file"""
        return self.top.read_topology('topology.append', tpl=self.modpt, 
                                      file=file, add_topology=True, **vars)

    def make(self, submodel):
        """Reduces the most detailed topology to a sub-topology model"""
        self.submodel = submodel
        return self.top.make_topology_model('topology.make', tpl=self.modpt)

    def write(self, **vars):
        """Writes topology library to a file"""
        return self.top.write_topology_model('topology.write', tpl=self.modpt,
                                             **vars)

    def __get_submodel(self):
        return _modeller.get_topology_submodel(self.modpt)
    def __set_submodel(self, val):
        _modeller.set_topology_submodel(self.modpt, val)

    modpt = property(__get_modpt)
    submodel = property(__get_submodel, __set_submodel)
