import _modeller
import modutil

class logger:
    """A simple log class to divert Python output to the Modeller logfile"""

    def __init__(self):
        self.buffer = ""

    def __del__(self):
        """Flush anything still in the buffer, on exit"""
        self.flush()

    def flush(self):
        """Flush anything in the buffer"""
        if self.buffer != "":
            self.write("\n")

    def level(self, output=1, notes=0, warnings=0, errors=1, memory=0):
        """Set the logging level - i.e. which messages to output"""
        modutil.set_topvars({'output_control': (output, notes, warnings,
                                                errors, memory)})

    def minimal(self):
        """Only print important logging messages"""
        self.level(output=1, notes=0, warnings=0, errors=1, memory=0)

    def verbose(self):
        """Print verbose logging messages"""
        self.level(output=1, notes=1, warnings=1, errors=1, memory=1)

    def very_verbose(self):
        """Print verbose logging messages, with dynamic memory breakdown"""
        self.level(output=1, notes=1, warnings=1, errors=1, memory=2)

    def write(self, text):
#       Modeller's wrtlog always appends a newline, so only call it when we have
#       a newline-terminated string in the buffer, and then remove our own
#       newline
        self.buffer += text
        if len(self.buffer) > 0 and \
           (self.buffer[-1] == "\n" or self.buffer[-1] == "\r"):
            _modeller.wrtlog(self.buffer[:-1])
            self.buffer = ""
